
{{cohort_ddl}}

-- Birth events (section 5.1, pp. 36-37)
-- INFO: collecting birth occurrences

INSERT INTO {{codex_events}}
     SELECT codex_source.person_id AS person_id,
            NULL AS event_id,
            'birth' AS event_class,
            codex_instant(
                to_date(concat_ws('-',
                    codex_source.year_of_birth,
                    lpad(coalesce(codex_source.month_of_birth, 1)::text, 2, '0'),
                    lpad(coalesce(codex_source.day_of_birth, 1)::text, 2, '0')),
                    'YYYY-MM-DD')
                ) AS event_period,
            jsonb_build_object(
                'gender_concept_id',
                    nullif(codex_source.gender_concept_id, 0),
                'race_concept_id',
                    nullif(codex_source.race_concept_id, 0),
                'ethnicity_concept_id',
                    nullif(codex_source.ethnicity_concept_id, 0)
                ) AS event_data,
            NULL AS event_visit_id,
            NULL AS event_provider_id
       FROM person AS codex_source
{{cohort_sql}};

-- Observation periods (section 5.2, pp. 37-38)
-- INFO: collecting observation periods

INSERT INTO {{codex_events}}
     SELECT codex_source.person_id AS person_id,
            codex_source.observation_period_id AS event_id,
            'observation_period' AS event_class,
            codex_period(
                codex_source.observation_period_start_date,
                codex_source.observation_period_end_date
                ) AS event_period,
            jsonb_build_object(
                'period_type_concept_id',
                    nullif(codex_source.period_type_concept_id, 0)
                ) AS event_data,
            NULL AS event_visit_id,
            NULL AS event_provider_id
       FROM observation_period AS codex_source
{{cohort_sql}};

-- Specimen collection events (section 5.3, pp. 38-39)
-- INFO: collecting specimen collections

INSERT INTO {{codex_events}}
     SELECT codex_source.person_id AS person_id,
            codex_source.specimen_id AS event_id,
            'specimen_collection' AS event_class,
            codex_instant(codex_source.specimen_date) AS event_period,
            jsonb_build_object(
                'specimen_concept_id',
                    nullif(codex_source.specimen_concept_id, 0),
                'specimen_type_concept_id',
                    nullif(codex_source.specimen_type_concept_id, 0),
                'quantity',
                    codex_source.quantity,
                'unit_concept_id',
                    nullif(codex_source.unit_concept_id, 0),
                'anatomic_site_concept_id',
                    nullif(codex_source.anatomic_site_concept_id, 0),
                'disease_status_concept_id',
                    nullif(codex_source.disease_status_concept_id, 0)
                ) AS event_data,
            NULL AS event_visit_id,
            NULL AS event_provider_id
       FROM specimen AS codex_source
{{cohort_sql}};

-- Death events (section 5.4, pp. 39-40)
-- INFO: collecting death occurrences

INSERT INTO {{codex_events}}
     SELECT codex_source.person_id AS person_id,
            NULL AS event_id,
            'death' AS event_class,
            codex_instant(codex_source.death_date) AS event_period,
            jsonb_build_object(
                'death_type_concept_id',
                    nullif(codex_source.death_type_concept_id, 0),
                'cause_concept_id',
                    nullif(codex_source.cause_concept_id, 0)
                ) AS event_data,
            NULL AS event_visit_id,
            NULL AS event_provider_id
       FROM death AS codex_source
{{cohort_sql}};

-- Visit occurrences (section 5.5, pp. 40-41)
-- INFO: collecting visit occurrences

INSERT INTO {{codex_events}}
     SELECT codex_source.person_id AS person_id,
            codex_source.visit_occurrence_id AS event_id,
            'visit' AS event_class,
            codex_period(
                codex_source.visit_start_date,
                codex_source.visit_end_date
                ) AS event_period,
            jsonb_build_object(
                'visit_concept_id',
                    nullif(codex_source.visit_concept_id, 0),
                'visit_type_concept_id',
                    nullif(codex_source.visit_type_concept_id, 0)
                ) AS event_data,
            codex_source.visit_occurrence_id AS event_visit_id,
            codex_source.provider_id AS event_provider_id
       FROM visit_occurrence AS codex_source
{{cohort_sql}};

-- Procedure occurrences (section 5.6, pp. 41-42)
-- INFO: collecting procedure occurrences

INSERT INTO {{codex_events}}
     SELECT codex_source.person_id AS person_id,
            codex_source.procedure_occurrence_id AS event_id,
            'procedure' AS event_class,
            codex_instant(codex_source.procedure_date) AS event_period,
            jsonb_build_object(
                'procedure_concept_id',
                    nullif(codex_source.procedure_concept_id, 0),
                'procedure_type_concept_id',
                    nullif(codex_source.procedure_type_concept_id, 0),
                'modifier_concept_id',
                    nullif(codex_source.modifier_concept_id, 0),
                'quantity',
                    codex_source.quantity
                ) AS event_data,
            codex_source.visit_occurrence_id AS event_visit_id,
            codex_source.provider_id AS event_provider_id
       FROM procedure_occurrence AS codex_source
{{cohort_sql}};

-- Drug exposures (section 5.7, pp. 43-44)
-- INFO: collecting drug exposures

INSERT INTO {{codex_events}}
     SELECT codex_source.person_id AS person_id,
            codex_source.drug_exposure_id AS event_id,
            'drug_exposure' AS event_class,
            codex_period(
                codex_source.drug_exposure_start_date,
                coalesce(
                    codex_source.drug_exposure_end_date,
                    codex_source.drug_exposure_start_date
                        + coalesce(codex_source.days_supply, 1)
                        * (coalesce(codex_source.refills, 0) + 1))
                ) AS event_period,
            jsonb_build_object(
                'drug_concept_id',
                    nullif(codex_source.drug_concept_id, 0),
                'drug_type_concept_id',
                    nullif(codex_source.drug_type_concept_id, 0),
                'stop_reason',
                    codex_source.stop_reason,
                'refills',
                    codex_source.refills,
                'quantity',
                    codex_source.quantity,
                'days_supply',
                    codex_source.days_supply,
                'route_concept_id',
                    nullif(codex_source.route_concept_id, 0),
                'effective_drug_dose',
                    codex_source.effective_drug_dose,
                'dose_unit_concept_id',
                    nullif(codex_source.dose_unit_concept_id, 0)
                ) AS event_data,
            codex_source.visit_occurrence_id AS event_visit_id,
            codex_source.provider_id AS event_provider_id
       FROM drug_exposure AS codex_source
{{cohort_sql}};

-- Device exposures (section 5.8, pp. 45-46)
-- INFO: collecting device exposures

INSERT INTO {{codex_events}}
     SELECT codex_source.person_id AS person_id,
            codex_source.device_exposure_id AS event_id,
            'device_exposure' AS event_class,
            codex_period(
                codex_source.device_exposure_start_date,
                codex_source.device_exposure_end_date
                ) AS event_period,
            jsonb_build_object(
                'device_concept_id',
                    nullif(codex_source.device_concept_id, 0),
                'device_type_concept_id',
                    nullif(codex_source.device_type_concept_id, 0),
                'quantity',
                    codex_source.quantity
                ) AS event_data,
            codex_source.visit_occurrence_id AS event_visit_id,
            codex_source.provider_id AS event_provider_id
       FROM device_exposure AS codex_source
{{cohort_sql}};

-- Condition occurrences (section 5.9, pp. 46-47)
-- INFO: collecting condition occurrences

INSERT INTO {{codex_events}}
     SELECT codex_source.person_id AS person_id,
            codex_source.condition_occurrence_id AS event_id,
            'condition' AS event_class,
            codex_period(
                codex_source.condition_start_date,
                codex_source.condition_end_date
                ) AS event_period,
            jsonb_build_object(
                'condition_concept_id',
                    nullif(codex_source.condition_concept_id, 0),
                'condition_type_concept_id',
                    nullif(codex_source.condition_type_concept_id, 0),
                'stop_reason',
                    codex_source.stop_reason
                ) AS event_data,
            codex_source.visit_occurrence_id AS event_visit_id,
            codex_source.provider_id AS event_provider_id
       FROM condition_occurrence AS codex_source
{{cohort_sql}};

-- Measurement (section 5.10, pp. 47-48)
-- INFO: collecting measurements

INSERT INTO {{codex_events}}
     SELECT codex_source.person_id AS person_id,
            codex_source.measurement_id AS event_id,
            'measurement' AS event_class,
            codex_instant(codex_source.measurement_date) AS event_period,
            jsonb_build_object(
                'measurement_concept_id',
                    nullif(codex_source.measurement_concept_id, 0),
                'measurement_type_concept_id',
                    nullif(codex_source.measurement_type_concept_id, 0),
                'operator_concept_id',
                    nullif(codex_source.operator_concept_id, 0),
                'value_as_number',
                    codex_source.value_as_number,
                'value_as_concept_id',
                    nullif(codex_source.value_as_concept_id, 0),
                'unit_concept_id',
                    nullif(codex_source.unit_concept_id, 0),
                'range_low',
                    codex_source.range_low,
                'range_high',
                    codex_source.range_high
                ) AS event_data,
            codex_source.visit_occurrence_id AS event_visit_id,
            codex_source.provider_id AS event_provider_id
       FROM measurement AS codex_source
{{cohort_sql}};

-- Observations (section 5.12, pp. 50-51)
-- INFO: collecting observations

INSERT INTO {{codex_events}}
     SELECT codex_source.person_id AS person_id,
            codex_source.observation_id AS event_id,
            'observation' AS event_class,
            codex_instant(codex_source.observation_date) AS event_period,
            jsonb_build_object(
                'observation_concept_id',
                    nullif(codex_source.observation_concept_id, 0),
                'observation_type_concept_id',
                    nullif(codex_source.observation_type_concept_id, 0),
                'value_as_number',
                    codex_source.value_as_number,
                'value_as_string',
                    codex_source.value_as_string,
                'value_as_concept_id',
                    nullif(codex_source.value_as_concept_id, 0),
                'qualifier_concept_id',
                    nullif(codex_source.qualifier_concept_id, 0),
                'unit_concept_id',
                    nullif(codex_source.unit_concept_id, 0)
                ) AS event_data,
            codex_source.visit_occurrence_id AS event_visit_id,
            codex_source.provider_id AS event_provider_id
       FROM observation AS codex_source
{{cohort_sql}};
