# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Prediction(Model):
    """result of an image classification request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id:
    :vartype id: str
    :ivar project:
    :vartype project: str
    :ivar iteration:
    :vartype iteration: str
    :ivar created:
    :vartype created: datetime
    :ivar predictions:
    :vartype predictions:
     list[~azure.cognitiveservices.vision.customvision.training.models.PredictionTag]
    :ivar image_uri:
    :vartype image_uri: str
    :ivar thumbnail_uri:
    :vartype thumbnail_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'project': {'readonly': True},
        'iteration': {'readonly': True},
        'created': {'readonly': True},
        'predictions': {'readonly': True},
        'image_uri': {'readonly': True},
        'thumbnail_uri': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'project': {'key': 'Project', 'type': 'str'},
        'iteration': {'key': 'Iteration', 'type': 'str'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'predictions': {'key': 'Predictions', 'type': '[PredictionTag]'},
        'image_uri': {'key': 'ImageUri', 'type': 'str'},
        'thumbnail_uri': {'key': 'ThumbnailUri', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Prediction, self).__init__(**kwargs)
        self.id = None
        self.project = None
        self.iteration = None
        self.created = None
        self.predictions = None
        self.image_uri = None
        self.thumbnail_uri = None
