# -*- coding: utf-8 -*-
# Created by lvjiyong on 15/6/15

import logging
import os

DEBUG = True

SERVICE_PROJECT_PATH = os.path.dirname(__file__)

# SEGMENT

SEGMENT_SERVICE_CLS = 'servicecore.contrib.segment.jiebasegment.JiebaSegment'
SEGMENT_SERVICE_PARAMS = {

    'dict': os.path.join(SERVICE_PROJECT_PATH, 'data/segment/jiebadict'),
    'stopwords': os.path.join(SERVICE_PROJECT_PATH, 'data/segment/stopwords'),
    'log_level': logging.ERROR,
}

DUPFILTER_SERVICE_CLS = 'servicecore.contrib.dupfilter.bloomfilter.BloomFilter'
DUPFILTER_SERVICE_PARAMS = {

    "capacity": 10000000,
    "error_rate": 0.1,
    "filename": os.path.join(SERVICE_PROJECT_PATH, 'data/dupfilter/testdb'),
    "enabled": True
}

SIMHASH_SERVICE_CLS = 'servicecore.contrib.simhash.mmh3simhash.Mmh3SimHash'
SIMHASH_SERVICE_PARAMS = {

    'hash_db': os.path.join(SERVICE_PROJECT_PATH, 'data/simhash/test_hash_'),
    'hash128': os.path.join(SERVICE_PROJECT_PATH, 'data/simhash/test_hash128'),
    'hash64': os.path.join(SERVICE_PROJECT_PATH, 'data/simhash/test_hash64'),
    'hash32': os.path.join(SERVICE_PROJECT_PATH, 'data/simhash/test_hash32'),
}


# QUEUE REDIS

QUEUE_SERVICE_CLS = 'servicecore.contrib.queue.redisqueue.RedisQueue'
QUEUE_SERVICE_PARAMS = {

    'host': '127.0.0.1',
    'port': 6379,
    'password': '',
    'db': 15,
    'collection': 'queue_test'

}


HASHDB_SERVICE_CLS = 'servicecore.contrib.hashdb.redishashdb.RedisHashDb'
HASHDB_SERVICE_PARAMS = {

    'host': '127.0.0.1',
    'port': 6379,
    'password': '',
    'db': 15,
    'collection': 'hashdb_test'

}
EXTEND_SERVICES = {}






