# -*- coding: utf-8 -*-
# Created by lvjiyong on 15/6/18

from servicecore.service.queue import BaseQueue
from servicecore.service.segment import Segment
from servicecore.service.dupfilter import DupFilter
from servicecore.service.simhash import SimHash
from servicecore.service.hashdb import HashDb

__all__ = ['BaseQueue',
           'Segment',
           'DupFilter',
           'SimHash',
           'HashDb',
           'PriorityQueue',
           'SettingService',
           'SegmentService',
           'DupFilterService',
           'SimhashService',
           'HashDbService']

# 定义的各项带基本配置服务

from servicecore.core.factory import priority_queue as _priority_queue

# 优先队列
PriorityQueue = _priority_queue


# 扩展服务

from servicecore.core.factory import setting_service as _setting_service

SettingService = _setting_service

# 分词服务
from servicecore.core.factory import segment as _segment_service

SegmentService = _segment_service

# 去重服务
from servicecore.core.factory import dupfilter as _dupfilter_service

DupFilterService = _dupfilter_service

#
# simhash
from servicecore.core.factory import simhash as _simhash_service

SimhashService = _simhash_service

# simhash
from servicecore.core.factory import hashdb as _hash_service

HashDbService = _hash_service

