# Copyright 2010 Boris Figovsky <borfig@gmail.com>
#
# This file is part of pybfc.

# pybfc is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# pybfc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with pybfc.  If not, see <http://www.gnu.org/licenses/>.
"""
Some useful os utilties

mkdir -p equivalent
>>> import tempfile, shutil
>>> temp_dir = tempfile.mkdtemp()
>>> makedirs(os.path.join(temp_dir, 'foo', 'bar'))
>>> makedirs(os.path.join(temp_dir, 'foo', 'bar'))
>>> open(os.path.join(temp_dir, 'foo', 'bas'), 'wb').close()
>>> try:
...     makedirs(os.path.join(temp_dir, 'foo', 'bas'))
... except OSError, e:
...     print str(e) == "[Errno 17] File exists: %r" % (os.path.join(temp_dir, 'foo', 'bas'), )
True
>>> shutil.rmtree(temp_dir)

"""

import os

def makedirs(path):
    if not os.path.isdir(path):
        os.makedirs(path)
