/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ptree;

import com.saxonica.ptree.PTreeReader;
import com.saxonica.ptree.TextObfuscator;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.transform.Source;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.trans.XPathException;

public class PackageURIResolver
extends StandardURIResolver {
    private ZipFile zipFile;
    private String baseURI;

    public Source resolve(String href, String base) throws XPathException {
        try {
            ZipEntry entry = null;
            if (href.endsWith(".zip")) {
                this.zipFile = new ZipFile(href);
                entry = this.zipFile.getEntry("0.pxsl");
                this.baseURI = new File(href).toURI().toString();
            } else if (href.endsWith(".pxsl")) {
                entry = this.zipFile.getEntry(href);
            }
            if (entry != null) {
                InputStream zis = this.zipFile.getInputStream(entry);
                DataInputStream din = new DataInputStream(new BufferedInputStream(zis));
                PTreeReader reader = new PTreeReader();
                reader.setTextMangler(new TextObfuscator(92));
                DocumentInfo doc = reader.readTree(din, this.baseURI, this.getConfiguration());
                doc.setSystemId(href);
                return doc;
            }
        }
        catch (IOException e) {
            throw new XPathException("Error opening packaged stylesheet file " + href + (base == null ? "" : " in " + base), (Throwable)e);
        }
        return super.resolve(href, base);
    }
}

