# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SecurityProfile(Model):
    """The security profile which contains Ssh public key for the HDInsight
    cluster.

    :param directory_type: The directory type. Possible values include:
     'ActiveDirectory'
    :type directory_type: str or ~azure.mgmt.hdinsight.models.DirectoryType
    :param domain: The organization's active directory domain.
    :type domain: str
    :param organizational_unit_dn: The organizational unit within the Active
     Directory to place the cluster and service accounts.
    :type organizational_unit_dn: str
    :param ldaps_urls: The LDAPS protocol URLs to communicate with the Active
     Directory.
    :type ldaps_urls: list[str]
    :param domain_username: The domain user account that will have admin
     privileges on the cluster.
    :type domain_username: str
    :param domain_user_password: The domain admin password.
    :type domain_user_password: str
    :param cluster_users_group_dns: Optional. The Distinguished Names for
     cluster user groups
    :type cluster_users_group_dns: list[str]
    :param aadds_resource_id: The resource ID of the user's Azure Active
     Directory Domain Service.
    :type aadds_resource_id: str
    :param msi_resource_id: User assigned identity that has permissions to
     read and create cluster-related artifacts in the user's AADDS.
    :type msi_resource_id: str
    """

    _attribute_map = {
        'directory_type': {'key': 'directoryType', 'type': 'DirectoryType'},
        'domain': {'key': 'domain', 'type': 'str'},
        'organizational_unit_dn': {'key': 'organizationalUnitDN', 'type': 'str'},
        'ldaps_urls': {'key': 'ldapsUrls', 'type': '[str]'},
        'domain_username': {'key': 'domainUsername', 'type': 'str'},
        'domain_user_password': {'key': 'domainUserPassword', 'type': 'str'},
        'cluster_users_group_dns': {'key': 'clusterUsersGroupDNs', 'type': '[str]'},
        'aadds_resource_id': {'key': 'aaddsResourceId', 'type': 'str'},
        'msi_resource_id': {'key': 'msiResourceId', 'type': 'str'},
    }

    def __init__(self, *, directory_type=None, domain: str=None, organizational_unit_dn: str=None, ldaps_urls=None, domain_username: str=None, domain_user_password: str=None, cluster_users_group_dns=None, aadds_resource_id: str=None, msi_resource_id: str=None, **kwargs) -> None:
        super(SecurityProfile, self).__init__(**kwargs)
        self.directory_type = directory_type
        self.domain = domain
        self.organizational_unit_dn = organizational_unit_dn
        self.ldaps_urls = ldaps_urls
        self.domain_username = domain_username
        self.domain_user_password = domain_user_password
        self.cluster_users_group_dns = cluster_users_group_dns
        self.aadds_resource_id = aadds_resource_id
        self.msi_resource_id = msi_resource_id
