from concurrent.futures import TimeoutError

from lfc.eventhandler import EventHandler


class Worker(EventHandler):
    """
    Superclass for other workers

    Workers keep a function to run on a specific set of arguments
    These workers(wrappers) are meant for organization and regulational tools that
        interact with the Thread Pool Executor in a standarized manner

    Args:
        f: A function that will be submitted to the ThreadPoolManager with the arguments that function needs
        eventManager: A reference to the main eventManager
        **kwargs: Used to take in any number of arguments so that the EventHandler class can

    """
    def __init__(self, f, eventmanager, **kwargs):
        EventHandler.__init__(self, eventmanager, **kwargs)
        self._f = f

    #Function made for other functions to submit work through the worker
    def submit(self, result=False, timeout=None, *args, **kwargs):
        try:
            future = self.eventManager._submit(self._f, *args, **kwargs)
            if result:
                return future.result(timeout=timeout)
        except TimeoutError:
            future.cancel()
            future.set_exception(TimeoutError("Function Timeout(f='{}', args={}, kwargs={}): Function Timed Out. (timeout={})"
                               .format(self._f.__name__, args, kwargs, timeout)))
        except Exception as e:
            future.cancel()
            self.log.error(e)