import time

from lfc.workers.worker import Worker

"""
Implementation of the worker class designed around adding limitations to how many things can be submitted

Does not change anything besides wrapping the submit function 
    of the Worker class with checks for the limit and sleep is it needs to wait
"""


class LimitedWorker(Worker):

    """
    Limited Worker has similar init args to the Worker with the only difference being a limit option

    The limit option has no default as this is meant to be used in specific instances where a limit is to be known

    Args:
        f: A function that will be submitted to the ThreadPoolManager with the arguments that function needs
        limit: A limit of how many function and be put into the ThreadPoolManager at one point in time
        eventManager: A reference to the main eventManager
        **kwargs: Used to take in any number of arguments so that the EventHandler class can

    """
    def __init__(self, f, limit, eventmanager, **kwargs):
        Worker.__init__(self, f, eventmanager, **kwargs)
        self.__limit = limit
        self.__working = 0

    """
    This overload the submit function of the Worker class, however 
        it doesn't completely remove the functionality it simply warps it in conditionals
        
    Args:
        results=False: Boolean to see if anything should be returned from this function
        timeout=None: A timeout option for potentially lengthy functions
        *args: Variable amounts of args to be used with the function
        **kwargs: Variable amounts of kwargs to be used with the function
    """
    def submit(self, result=False, timeout=None, *args, **kwargs):
        try:
            while self.__working >= self.__limit:
                time.sleep(1)
            self.__working += 1
            r = Worker.submit(self, result=result, timeout=timeout, *args, **kwargs)
            self.__working -= 1
            return r
        except Exception as e:
            self.__working -= 1
            self.log.error(e)
