"""
Basic Event Class

This class is meant to be used as a superclass for specific event
Those classes than inherit the Event class can now be used with @Catch(PrintEvent)
    and when fired to the event manager with handlers catching it will be run

Example:

class PrintEvent(Event):
    def __init__(self, toprint)
        Event.__init__(self, toprint=toprint)

class PrintHandler(EventHandler):

    @Catch(PrintEvent)
    def printAnything(toprint)
        print(toprint)
"""
class Event:
    """
    Constructor for any event that stores any number of arguments and key word arguments

    Args:
        *args: Takes a variable number of arguments as a list
        **kwargs: Takes a variable number of key word arguments as a dictionary
    """
    def __init__(self, *args, **kwargs):
        self.args = args
        self.kwargs = kwargs

    # Debug function used for printing
    def __str__(self):
        return "Args[{}] Kwargs[{}]".format(self.args, self.kwargs)
