from enum import Enum


class Verbosity(Enum):
    QUIET = -1, 'QUIET'
    DEFAULT = 0, 'DEFAULT'
    VERBOSE = 1, 'VERBOSE'
    VERY_VERBOSE = 2, 'VERY VERBOSE'
    DEBUG = 3, 'DEBUG'

    def __iter__(self):
        return list(Verbosity.QUIET, Verbosity.DEFAULT, Verbosity.VERBOSE, Verbosity.VERY_VERBOSE, Verbosity.DEBUG)

    @classmethod
    def get(self, check):
        ic = 0
        if isinstance(check, str):
            ic = 1

        for v in self:
            if check == v.value[ic]:
                return v

        return Verbosity.DEFAULT

    def __lt__(self, other):
        if isinstance(other, self.__class__):
            return self.value < other.value
        if isinstance(other, int):
            return self.value[0] < other

    def __le__(self, other):
        if isinstance(other, self.__class__):
            return self.value <= other.value
        if isinstance(other, int):
            return self.value[0] <= other

    def __gt__(self, other):
        if isinstance(other, self.__class__):
            return self.value > other.value
        if isinstance(other, int):
            return self.value[0] > other

    def __ge__(self, other):
        if isinstance(other, self.__class__):
            return self.value >= other.value
        if isinstance(other, int):
            return self.value[0] >= other

    def __eq__(self, other):
        return self.value[0] == other or self.value[1] == other

    def __ne__(self, other):
        return not self.__eq__(other)
