from enum import Enum

"""
Enum is used to order handlers for a specific event
The idea is that each event is a thread so that in order 
    to let certain handlers go before less important ones
    
Usage:

@Catch(Start, Priority.CRITICAL)
def thing():
    pass
    
This function is catching the start event and because it has 
    critical priority it will go before other handlers with 
    high priority or below
"""
class Priority(Enum):
    CRITICAL = 0
    HIGH = 1
    MEDIUM = 2
    LOW = 3
    END = 4