/**
 * History.js jQuery Adapter
 * @author Benjamin Arthur Lupton <contact@balupton.com>
 * @copyright 2010-2011 Benjamin Arthur Lupton <contact@balupton.com>
 * @license New BSD License <http://creativecommons.org/licenses/BSD/>
 */

// Closure
(function(window,undefined){
    "use strict";

    // Localise Globals
    var
        History = window.History = window.History||{},
        jQuery = window.jQuery;

    // Check Existence
    if ( typeof History.Adapter !== 'undefined' ) {
        throw new Error('History.js Adapter has already been loaded...');
    }

    // Add the Adapter
    History.Adapter = {
        /**
         * History.Adapter.bind(el,event,callback)
         * @param {Element|string} el
         * @param {string} event - custom and standard events
         * @param {function} callback
         * @return {void}
         */
        bind: function(el,event,callback){
            jQuery(el).bind(event,callback);
        },

        /**
         * History.Adapter.trigger(el,event)
         * @param {Element|string} el
         * @param {string} event - custom and standard events
         * @param {Object=} extra - a object of extra event data (optional)
         * @return {void}
         */
        trigger: function(el,event,extra){
            jQuery(el).trigger(event,extra);
        },

        /**
         * History.Adapter.extractEventData(key,event,extra)
         * @param {string} key - key for the event data to extract
         * @param {string} event - custom and standard events
         * @param {Object=} extra - a object of extra event data (optional)
         * @return {mixed}
         */
        extractEventData: function(key,event,extra){
            // jQuery Native then jQuery Custom
            var result = (event && event.originalEvent && event.originalEvent[key]) || (extra && extra[key]) || undefined;

            // Return
            return result;
        },

        /**
         * History.Adapter.onDomLoad(callback)
         * @param {function} callback
         * @return {void}
         */
        onDomLoad: function(callback) {
            jQuery(callback);
        }
    };

    // Try and Initialise History
    if ( typeof History.init !== 'undefined' ) {
        History.init();
    }

})(window);

