# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .service_properties_py3 import ServiceProperties


class Service(ServiceProperties):
    """Defines a service.

    All required parameters must be populated in order to send to Azure.

    :param target_location: Required. The Azure location to which the
     resources in the service belong to or should be deployed to.
    :type target_location: str
    :param target_subscription_id: Required. The subscription to which the
     resources in the service belong to or should be deployed to.
    :type target_subscription_id: str
    :param name: Name of the service.
    :type name: str
    :param service_units: The detailed information about the units that make
     up the service.
    :type service_units:
     list[~azure.mgmt.deploymentmanager.models.ServiceUnit]
    """

    _validation = {
        'target_location': {'required': True},
        'target_subscription_id': {'required': True},
    }

    _attribute_map = {
        'target_location': {'key': 'targetLocation', 'type': 'str'},
        'target_subscription_id': {'key': 'targetSubscriptionId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'service_units': {'key': 'serviceUnits', 'type': '[ServiceUnit]'},
    }

    def __init__(self, *, target_location: str, target_subscription_id: str, name: str=None, service_units=None, **kwargs) -> None:
        super(Service, self).__init__(target_location=target_location, target_subscription_id=target_subscription_id, **kwargs)
        self.name = name
        self.service_units = service_units
