# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RolloutOperationInfo(Model):
    """Detailed runtime information of the rollout.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar retry_attempt: The ordinal count of the number of retry attempts on
     a rollout. 0 if no retries of the rollout have been performed. If the
     rollout is updated with a PUT, this count is reset to 0.
    :vartype retry_attempt: int
    :ivar skip_succeeded_on_retry: True, if all steps that succeeded on the
     previous run/attempt were chosen to be skipped in this retry attempt.
     False, otherwise.
    :vartype skip_succeeded_on_retry: bool
    :ivar start_time: The start time of the rollout in UTC.
    :vartype start_time: datetime
    :ivar end_time: The start time of the rollout in UTC. This property will
     not be set if the rollout has not completed yet.
    :vartype end_time: datetime
    :ivar error: The detailed error information for any failure.
    :vartype error: ~azure.mgmt.deploymentmanager.models.CloudErrorBody
    """

    _validation = {
        'retry_attempt': {'readonly': True},
        'skip_succeeded_on_retry': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'retry_attempt': {'key': 'retryAttempt', 'type': 'int'},
        'skip_succeeded_on_retry': {'key': 'skipSucceededOnRetry', 'type': 'bool'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(self, **kwargs) -> None:
        super(RolloutOperationInfo, self).__init__(**kwargs)
        self.retry_attempt = None
        self.skip_succeeded_on_retry = None
        self.start_time = None
        self.end_time = None
        self.error = None
