# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CloudErrorBody(Model):
    """Detailed error information of any failure.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Error code string.
    :vartype code: str
    :ivar message: Descriptive error information.
    :vartype message: str
    :param target: Error target
    :type target: str
    :param details: More detailed error information.
    :type details: list[~azure.mgmt.deploymentmanager.models.CloudErrorBody]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(self, *, target: str=None, details=None, **kwargs) -> None:
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = target
        self.details = details
