#!/usr/bin/env python
# -*- coding: UTF-8 -*-
# Copyright (c) 2012 Sylvain Prat. This program is open-source software,
# and may be redistributed under the terms of the MIT license. See the
# LICENSE file in this distribution for details.

import os
import re

from setuptools import setup, find_packages


def read(*path_parts):
    here = os.path.dirname(__file__)
    return open(os.path.join(here, *path_parts)).read()


def find_version(*file_paths):
    version_file = read(*file_paths)
    version_match = re.search(r"^__version__ = ['\"]([^'\"]*)['\"]",
                              version_file, re.M)
    if version_match:
        return version_match.group(1)
    raise RuntimeError("Unable to find version string.")


# package description
desc = "Minify provides distutils commands for minifying CSS and JS resources"
long_desc = '\n'.join(read(f) for f in ('README', 'CHANGES'))


setup(
    name='minify',
    version=find_version('minify', '__init__.py'),
    author='Sylvain Prat',
    author_email='sylvain.prat+minify@gmail.com',
    description=desc,
    long_description=long_desc,
    license='MIT License',
    keywords='minify,css,javascript,js,distutils,command,setup.cfg',
    url='http://bitbucket.org/sprat/minify',
    packages=find_packages(),
    install_requires=['yuicompressor'],
    platforms='any',
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Topic :: Internet :: WWW/HTTP :: Site Management',
        'Programming Language :: Python',
    ],
    entry_points={
        'distutils.commands': [
            'minify_js = minify.command:minify_js',
            'minify_css = minify.command:minify_css',
        ],
    },
)
