# Copyright 2015 Cisco Systems, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
This is an auto-generated module containing ManagedObject Meta information.
"""

from .ucscoremeta import UcsVersion
from .ucscoremeta import MoMeta


def version():
    return '3.1(1.179a)'

class VersionMeta:
    """ This class contains all the UcsVersion supported by this package."""
    Version101e = UcsVersion("1.0(1e)")
    Version102d = UcsVersion("1.0(2d)")
    Version102e = UcsVersion("1.0(2e)")
    Version102h = UcsVersion("1.0(2h)")
    Version102j = UcsVersion("1.0(2j)")
    Version102k = UcsVersion("1.0(2k)")
    Version102l = UcsVersion("1.0(2l)")
    Version111j = UcsVersion("1.1(1j)")
    Version111l = UcsVersion("1.1(1l)")
    Version111m = UcsVersion("1.1(1m)")
    Version121b = UcsVersion("1.2(1b)")
    Version121d = UcsVersion("1.2(1d)")
    Version131c = UcsVersion("1.3(1c)")
    Version131i = UcsVersion("1.3(1i)")
    Version131m = UcsVersion("1.3(1m)")
    Version131n = UcsVersion("1.3(1n)")
    Version131o = UcsVersion("1.3(1o)")
    Version131p = UcsVersion("1.3(1p)")
    Version131q = UcsVersion("1.3(1q)")
    Version131t = UcsVersion("1.3(1t)")
    Version131w = UcsVersion("1.3(1w)")
    Version131y = UcsVersion("1.3(1y)")
    Version141i = UcsVersion("1.4(1i)")
    Version141j = UcsVersion("1.4(1j)")
    Version141k = UcsVersion("1.4(1k)")
    Version141m = UcsVersion("1.4(1m)")
    Version142b = UcsVersion("1.4(2b)")
    Version143i = UcsVersion("1.4(3i)")
    Version143l = UcsVersion("1.4(3l)")
    Version143m = UcsVersion("1.4(3m)")
    Version143q = UcsVersion("1.4(3q)")
    Version143s = UcsVersion("1.4(3s)")
    Version143u = UcsVersion("1.4(3u)")
    Version143y = UcsVersion("1.4(3y)")
    Version144f = UcsVersion("1.4(4f)")
    Version144g = UcsVersion("1.4(4g)")
    Version144i = UcsVersion("1.4(4i)")
    Version144j = UcsVersion("1.4(4j)")
    Version144k = UcsVersion("1.4(4k)")
    Version201m = UcsVersion("2.0(1m)")
    Version201q = UcsVersion("2.0(1q)")
    Version201s = UcsVersion("2.0(1s)")
    Version201t = UcsVersion("2.0(1t)")
    Version201w = UcsVersion("2.0(1w)")
    Version201x = UcsVersion("2.0(1x)")
    Version202m = UcsVersion("2.0(2m)")
    Version202q = UcsVersion("2.0(2q)")
    Version202r = UcsVersion("2.0(2r)")
    Version203a = UcsVersion("2.0(3a)")
    Version203b = UcsVersion("2.0(3b)")
    Version203c = UcsVersion("2.0(3c)")
    Version204a = UcsVersion("2.0(4a)")
    Version204b = UcsVersion("2.0(4b)")
    Version204d = UcsVersion("2.0(4d)")
    Version205a = UcsVersion("2.0(5a)")
    Version205b = UcsVersion("2.0(5b)")
    Version211a = UcsVersion("2.1(1a)")
    Version211b = UcsVersion("2.1(1b)")
    Version211d = UcsVersion("2.1(1d)")
    Version211e = UcsVersion("2.1(1e)")
    Version212a = UcsVersion("2.1(2a)")
    Version213a = UcsVersion("2.1(3a)")
    Version221b = UcsVersion("2.2(1b)")
    Version222c = UcsVersion("2.2(2c)")
    Version223a = UcsVersion("2.2(3a)")
    Version224a = UcsVersion("2.2(4a)")
    Version224b = UcsVersion("2.2(4b)")
    Version225a = UcsVersion("2.2(5a)")
    Version226a = UcsVersion("2.2(6a)")
    Version226c = UcsVersion("2.2(6c)")
    Version227b = UcsVersion("2.2(7b)")
    Version251a = UcsVersion("2.5(1a)")
    Version252a = UcsVersion("2.5(2a)")
    Version302a = UcsVersion("3.0(2a)")
    Version302c = UcsVersion("3.0(2c)")
    Version311e = UcsVersion("3.1(1e)")
    Version911z = UcsVersion("9.1(1z)")

MO_CLASS_ID = frozenset([
    "AaaAuthRealm",
    "AaaAuthRealmFsm",
    "AaaAuthRealmFsmStage",
    "AaaCimcSession",
    "AaaConsoleAuth",
    "AaaDefaultAuth",
    "AaaDomain",
    "AaaDomainAuth",
    "AaaEpAuthProfile",
    "AaaEpFsm",
    "AaaEpFsmStage",
    "AaaEpFsmTask",
    "AaaEpLogin",
    "AaaEpUser",
    "AaaExtMgmtCutThruTkn",
    "AaaLdapEp",
    "AaaLdapEpFsm",
    "AaaLdapEpFsmStage",
    "AaaLdapGroup",
    "AaaLdapGroupRule",
    "AaaLdapProvider",
    "AaaLocale",
    "AaaLog",
    "AaaModLR",
    "AaaOrg",
    "AaaPreLoginBanner",
    "AaaProviderGroup",
    "AaaProviderRef",
    "AaaPwdProfile",
    "AaaRadiusEp",
    "AaaRadiusEpFsm",
    "AaaRadiusEpFsmStage",
    "AaaRadiusProvider",
    "AaaRealmFsm",
    "AaaRealmFsmStage",
    "AaaRealmFsmTask",
    "AaaRemoteUser",
    "AaaRole",
    "AaaSession",
    "AaaSessionInfo",
    "AaaSessionInfoTable",
    "AaaSessionLR",
    "AaaShellLogin",
    "AaaSshAuth",
    "AaaTacacsPlusEp",
    "AaaTacacsPlusEpFsm",
    "AaaTacacsPlusEpFsmStage",
    "AaaTacacsPlusProvider",
    "AaaUser",
    "AaaUserData",
    "AaaUserEp",
    "AaaUserEpFsm",
    "AaaUserEpFsmStage",
    "AaaUserEpFsmTask",
    "AaaUserLocale",
    "AaaUserRole",
    "AaaWebLogin",
    "AdaptorCapQual",
    "AdaptorCapSpec",
    "AdaptorDiagCap",
    "AdaptorDynamicConfigCap",
    "AdaptorEthAdvFilterProfile",
    "AdaptorEthArfsProfile",
    "AdaptorEthCompQueueProfile",
    "AdaptorEthFailoverProfile",
    "AdaptorEthInterruptProfile",
    "AdaptorEthInterruptScalingProfile",
    "AdaptorEthNVGREProfile",
    "AdaptorEthOffloadProfile",
    "AdaptorEthPortBySizeLargeStats",
    "AdaptorEthPortBySizeLargeStatsHist",
    "AdaptorEthPortBySizeSmallStats",
    "AdaptorEthPortBySizeSmallStatsHist",
    "AdaptorEthPortErrStats",
    "AdaptorEthPortErrStatsHist",
    "AdaptorEthPortMcastStats",
    "AdaptorEthPortMcastStatsHist",
    "AdaptorEthPortOutsizedStats",
    "AdaptorEthPortOutsizedStatsHist",
    "AdaptorEthPortStats",
    "AdaptorEthPortStatsHist",
    "AdaptorEthRecvQueueProfile",
    "AdaptorEthRoCEProfile",
    "AdaptorEthVxLANProfile",
    "AdaptorEthWorkQueueProfile",
    "AdaptorEtherIfStats",
    "AdaptorEtherIfStatsHist",
    "AdaptorExtEthIf",
    "AdaptorExtEthIfFsm",
    "AdaptorExtEthIfFsmStage",
    "AdaptorExtEthIfFsmTask",
    "AdaptorExtEthIfPc",
    "AdaptorExtEthIfPcEp",
    "AdaptorExtIpV6RssHashProfile",
    "AdaptorFamilyTypeDef",
    "AdaptorFcCdbWorkQueueProfile",
    "AdaptorFcErrorRecoveryProfile",
    "AdaptorFcFnicProfile",
    "AdaptorFcIfEventStats",
    "AdaptorFcIfEventStatsHist",
    "AdaptorFcIfFC4Stats",
    "AdaptorFcIfFC4StatsHist",
    "AdaptorFcIfFrameStats",
    "AdaptorFcIfFrameStatsHist",
    "AdaptorFcInterruptProfile",
    "AdaptorFcOEIf",
    "AdaptorFcPortFLogiProfile",
    "AdaptorFcPortPLogiProfile",
    "AdaptorFcPortProfile",
    "AdaptorFcPortStats",
    "AdaptorFcPortStatsHist",
    "AdaptorFcRecvQueueProfile",
    "AdaptorFcWorkQueueProfile",
    "AdaptorFruCapProvider",
    "AdaptorFruCapRef",
    "AdaptorFwCapProvider",
    "AdaptorHostEthIf",
    "AdaptorHostEthIfFsm",
    "AdaptorHostEthIfFsmStage",
    "AdaptorHostEthIfFsmTask",
    "AdaptorHostEthIfProfile",
    "AdaptorHostFcIf",
    "AdaptorHostFcIfFsm",
    "AdaptorHostFcIfFsmStage",
    "AdaptorHostFcIfFsmTask",
    "AdaptorHostFcIfProfile",
    "AdaptorHostIfConfig",
    "AdaptorHostIscsiIf",
    "AdaptorHostIscsiIfProfile",
    "AdaptorHostMgmtCap",
    "AdaptorHostPort",
    "AdaptorHostPortCap",
    "AdaptorHostScsiIf",
    "AdaptorHostScsiLunRef",
    "AdaptorHostServiceEthIf",
    "AdaptorHostVnicHwAddrCap",
    "AdaptorHostethHwAddrCap",
    "AdaptorHostfcHwAddrCap",
    "AdaptorIScsiCap",
    "AdaptorIpV4RssHashProfile",
    "AdaptorIpV6RssHashProfile",
    "AdaptorIscsiAuth",
    "AdaptorIscsiProt",
    "AdaptorIscsiTargetIf",
    "AdaptorLanCap",
    "AdaptorLldpCap",
    "AdaptorMenloBaseErrorStats",
    "AdaptorMenloBaseErrorStatsHist",
    "AdaptorMenloDcePortStats",
    "AdaptorMenloDcePortStatsHist",
    "AdaptorMenloEthErrorStats",
    "AdaptorMenloEthErrorStatsHist",
    "AdaptorMenloEthStats",
    "AdaptorMenloEthStatsHist",
    "AdaptorMenloFcErrorStats",
    "AdaptorMenloFcErrorStatsHist",
    "AdaptorMenloFcStats",
    "AdaptorMenloFcStatsHist",
    "AdaptorMenloHostPortStats",
    "AdaptorMenloHostPortStatsHist",
    "AdaptorMenloMcpuErrorStats",
    "AdaptorMenloMcpuErrorStatsHist",
    "AdaptorMenloMcpuStats",
    "AdaptorMenloMcpuStatsHist",
    "AdaptorMenloNetEgStats",
    "AdaptorMenloNetEgStatsHist",
    "AdaptorMenloNetInStats",
    "AdaptorMenloNetInStatsHist",
    "AdaptorMenloQErrorStats",
    "AdaptorMenloQErrorStatsHist",
    "AdaptorMenloQStats",
    "AdaptorMenloQStatsHist",
    "AdaptorMgmtVnicEthConfig",
    "AdaptorNwMgmtCap",
    "AdaptorNwStatsMgmtCap",
    "AdaptorProtocolProfile",
    "AdaptorQual",
    "AdaptorRnicCapSpec",
    "AdaptorRssProfile",
    "AdaptorSanCap",
    "AdaptorUnit",
    "AdaptorUnitAssocCtx",
    "AdaptorUnitExtn",
    "AdaptorUplinkHwAddrCap",
    "AdaptorUplinkPortStats",
    "AdaptorUsnicConnDef",
    "AdaptorVlan",
    "AdaptorVnicStats",
    "AdaptorVnicStatsHist",
    "AdaptorVsan",
    "ApeAttribute",
    "ApeControllerChassis",
    "ApeControllerEeprom",
    "ApeControllerManager",
    "ApeDcosAgManager",
    "ApeFru",
    "ApeHostAgent",
    "ApeLANBoot",
    "ApeLocalDiskBoot",
    "ApeManager",
    "ApeMc",
    "ApeMcStats",
    "ApeMcTable",
    "ApeMenlo",
    "ApeMenloVnic",
    "ApeMenloVnicStats",
    "ApeNicAgManager",
    "ApePalo",
    "ApePaloVnic",
    "ApePaloVnicStats",
    "ApeParam",
    "ApeReading",
    "ApeSANBoot",
    "ApeSdr",
    "ApeSwitchFirmwareInv",
    "ApeVirtualMediaBoot",
    "BiosBOT",
    "BiosBootDev",
    "BiosBootDevGrp",
    "BiosFeatureRef",
    "BiosParameterRef",
    "BiosRef",
    "BiosSettingRef",
    "BiosSettings",
    "BiosUnit",
    "BiosVIdentityParams",
    "BiosVProfile",
    "BiosVfACPI10Support",
    "BiosVfASPMSupport",
    "BiosVfAllUSBDevices",
    "BiosVfAltitude",
    "BiosVfAssertNMIOnPERR",
    "BiosVfAssertNMIOnSERR",
    "BiosVfBootOptionRetry",
    "BiosVfCPUHardwarePowerManagement",
    "BiosVfCPUPerformance",
    "BiosVfCPUPowerManagement",
    "BiosVfConsistentDeviceNameControl",
    "BiosVfConsoleRedirection",
    "BiosVfCoreMultiProcessing",
    "BiosVfDDR3VoltageSelection",
    "BiosVfDRAMClockThrottling",
    "BiosVfDirectCacheAccess",
    "BiosVfDramRefreshRate",
    "BiosVfEnergyPerformanceTuning",
    "BiosVfEnhancedIntelSpeedStepTech",
    "BiosVfEnhancedPowerCappingSupport",
    "BiosVfExecuteDisableBit",
    "BiosVfFRB2Timer",
    "BiosVfFrequencyFloorOverride",
    "BiosVfFrontPanelLockout",
    "BiosVfIOEMezz1OptionROM",
    "BiosVfIOENVMe1OptionROM",
    "BiosVfIOENVMe2OptionROM",
    "BiosVfIOESlot1OptionROM",
    "BiosVfIOESlot2OptionROM",
    "BiosVfIntegratedGraphics",
    "BiosVfIntegratedGraphicsApertureSize",
    "BiosVfIntelEntrySASRAIDModule",
    "BiosVfIntelHyperThreadingTech",
    "BiosVfIntelTrustedExecutionTechnology",
    "BiosVfIntelTurboBoostTech",
    "BiosVfIntelVTForDirectedIO",
    "BiosVfIntelVirtualizationTechnology",
    "BiosVfInterleaveConfiguration",
    "BiosVfLocalX2Apic",
    "BiosVfLvDIMMSupport",
    "BiosVfMaxVariableMTRRSetting",
    "BiosVfMaximumMemoryBelow4GB",
    "BiosVfMemoryMappedIOAbove4GB",
    "BiosVfMirroringMode",
    "BiosVfNUMAOptimized",
    "BiosVfOSBootWatchdogTimer",
    "BiosVfOSBootWatchdogTimerPolicy",
    "BiosVfOSBootWatchdogTimerTimeout",
    "BiosVfOnboardGraphics",
    "BiosVfOnboardSATAController",
    "BiosVfOnboardStorage",
    "BiosVfOptionROMEnable",
    "BiosVfOptionROMLoad",
    "BiosVfOutOfBandManagement",
    "BiosVfPCHSATAMode",
    "BiosVfPCILOMPortsConfiguration",
    "BiosVfPCIROMCLP",
    "BiosVfPCISlotLinkSpeed",
    "BiosVfPCISlotOptionROMEnable",
    "BiosVfPOSTErrorPause",
    "BiosVfPSTATECoordination",
    "BiosVfPackageCStateLimit",
    "BiosVfProcessorC1E",
    "BiosVfProcessorC3Report",
    "BiosVfProcessorC6Report",
    "BiosVfProcessorC7Report",
    "BiosVfProcessorCMCI",
    "BiosVfProcessorCState",
    "BiosVfProcessorEnergyConfiguration",
    "BiosVfProcessorPrefetchConfig",
    "BiosVfQPILinkFrequencySelect",
    "BiosVfQPISnoopMode",
    "BiosVfQuietBoot",
    "BiosVfRedirectionAfterBIOSPOST",
    "BiosVfResumeOnACPowerLoss",
    "BiosVfSBMezz1OptionROM",
    "BiosVfSBNVMe1OptionROM",
    "BiosVfSIOC1OptionROM",
    "BiosVfSIOC2OptionROM",
    "BiosVfScrubPolicies",
    "BiosVfSelectMemoryRASConfiguration",
    "BiosVfSerialPortAEnable",
    "BiosVfSparingMode",
    "BiosVfSriovConfig",
    "BiosVfTPMPendingOperation",
    "BiosVfTPMSupport",
    "BiosVfTrustedPlatformModule",
    "BiosVfUCSMBootModeControl",
    "BiosVfUCSMBootOrderRuleControl",
    "BiosVfUEFIOSUseLegacyVideo",
    "BiosVfUSBBootConfig",
    "BiosVfUSBConfiguration",
    "BiosVfUSBFrontPanelAccessLock",
    "BiosVfUSBPortConfiguration",
    "BiosVfUSBSystemIdlePowerOptimizingSetting",
    "BiosVfVGAPriority",
    "BiosVfWorkloadConfiguration",
    "BmcSELCounter",
    "CallhomeAnonymousReporting",
    "CallhomeDest",
    "CallhomeEp",
    "CallhomeEpFsm",
    "CallhomeEpFsmStage",
    "CallhomeEpFsmTask",
    "CallhomePeriodicSystemInventory",
    "CallhomePolicy",
    "CallhomeProfile",
    "CallhomeSmtp",
    "CallhomeSource",
    "CallhomeTestAlert",
    "CapabilityCatalogue",
    "CapabilityCatalogueFsm",
    "CapabilityCatalogueFsmStage",
    "CapabilityCatalogueFsmTask",
    "CapabilityEp",
    "CapabilityFeatureLimits",
    "CapabilityMgmtExtension",
    "CapabilityMgmtExtensionFsm",
    "CapabilityMgmtExtensionFsmStage",
    "CapabilityMgmtExtensionFsmTask",
    "CapabilityNetworkLimits",
    "CapabilityStorageLimits",
    "CapabilitySystemLimits",
    "CapabilityUpdate",
    "CapabilityUpdater",
    "CapabilityUpdaterFsm",
    "CapabilityUpdaterFsmStage",
    "CapabilityUpdaterFsmTask",
    "ChangeChangedObjectRef",
    "CimcvmediaActualMountEntry",
    "CimcvmediaActualMountList",
    "CimcvmediaConfigMountEntry",
    "CimcvmediaExtMgmtRuleEntry",
    "CimcvmediaMountConfigDef",
    "CimcvmediaMountConfigPolicy",
    "ClitestTypeTest",
    "ClitestTypeTest2",
    "ClitestTypeTestChild",
    "CommCimcWebService",
    "CommCimxml",
    "CommDateTime",
    "CommDns",
    "CommDnsProvider",
    "CommEvtChannel",
    "CommHttp",
    "CommHttps",
    "CommLocale",
    "CommNtpProvider",
    "CommShellSvcLimits",
    "CommSmashCLP",
    "CommSnmp",
    "CommSnmpTrap",
    "CommSnmpUser",
    "CommSsh",
    "CommSvcEp",
    "CommSvcEpFsm",
    "CommSvcEpFsmStage",
    "CommSvcEpFsmTask",
    "CommSvcPolicy",
    "CommSyslog",
    "CommSyslogClient",
    "CommSyslogConsole",
    "CommSyslogFile",
    "CommSyslogMonitor",
    "CommSyslogSource",
    "CommTelnet",
    "CommWebChannel",
    "CommWebSvcLimits",
    "CommWsman",
    "CommXmlClConnPolicy",
    "ComputeAutoconfigPolicy",
    "ComputeBlade",
    "ComputeBladeDiscPolicy",
    "ComputeBladeEp",
    "ComputeBladeFsm",
    "ComputeBladeFsmStage",
    "ComputeBladeFsmTask",
    "ComputeBladeInheritPolicy",
    "ComputeBoard",
    "ComputeBoardConnector",
    "ComputeBoardController",
    "ComputeCartridge",
    "ComputeChassisConnPolicy",
    "ComputeChassisDiscPolicy",
    "ComputeChassisQual",
    "ComputeConstraintDef",
    "ComputeDefaults",
    "ComputeExtBoard",
    "ComputeFactoryResetOperation",
    "ComputeFwSyncAck",
    "ComputeHealthLedSensorAlarm",
    "ComputeIOHub",
    "ComputeIOHubEnvStats",
    "ComputeIOHubEnvStatsHist",
    "ComputeInstanceIdQual",
    "ComputeKvmMgmtPolicy",
    "ComputeMbPowerStats",
    "ComputeMbPowerStatsHist",
    "ComputeMbTempStats",
    "ComputeMbTempStatsHist",
    "ComputeMemoryConfigPolicy",
    "ComputeMemoryConfiguration",
    "ComputeMemoryUnitConstraintDef",
    "ComputePCIeFatalCompletionStats",
    "ComputePCIeFatalProtocolStats",
    "ComputePCIeFatalReceiveStats",
    "ComputePCIeFatalStats",
    "ComputePciCap",
    "ComputePciSlotScanDef",
    "ComputePhysicalAssocCtx",
    "ComputePhysicalFsm",
    "ComputePhysicalFsmStage",
    "ComputePhysicalFsmTask",
    "ComputePhysicalQual",
    "ComputePlatform",
    "ComputePnuOSImage",
    "ComputePool",
    "ComputePoolPolicyRef",
    "ComputePoolable",
    "ComputePooledEnclosureComputeSlot",
    "ComputePooledRackUnit",
    "ComputePooledSlot",
    "ComputePoolingPolicy",
    "ComputePowerSyncDef",
    "ComputePowerSyncPolicy",
    "ComputePsuControl",
    "ComputePsuPolicy",
    "ComputeQual",
    "ComputeRackQual",
    "ComputeRackUnit",
    "ComputeRackUnitFsm",
    "ComputeRackUnitFsmStage",
    "ComputeRackUnitFsmTask",
    "ComputeRackUnitMbTempStats",
    "ComputeRackUnitMbTempStatsHist",
    "ComputeRtcBattery",
    "ComputeScrubPolicy",
    "ComputeServerDiscPolicy",
    "ComputeServerDiscPolicyFsm",
    "ComputeServerDiscPolicyFsmStage",
    "ComputeServerDiscPolicyFsmTask",
    "ComputeServerMgmtPolicy",
    "ComputeServerTypeCap",
    "ComputeServerUnit",
    "ComputeServerUnitFsm",
    "ComputeServerUnitFsmStage",
    "ComputeServerUnitFsmTask",
    "ComputeSlotQual",
    "ConfigImpact",
    "ConfigManagedEpImpactResponse",
    "ConfigSorter",
    "ControllerHaController",
    "ControllerOperationalVersionHolder",
    "ControllerPreferedVersionHolder",
    "CpmaintAck",
    "CpmaintMaintPolicy",
    "DcxFcoeVifEp",
    "DcxNs",
    "DcxUniverse",
    "DcxVIf",
    "DcxVc",
    "DcxVifEp",
    "DhcpAcquired",
    "DhcpInst",
    "DhcpLease",
    "DiagBladeTest",
    "DiagNetworkTest",
    "DiagRslt",
    "DiagRunPolicy",
    "DiagSrvCapProvider",
    "DiagSrvCtrl",
    "DomainEnvironmentFeature",
    "DomainEnvironmentFeatureCont",
    "DomainEnvironmentParam",
    "DomainNetworkFeature",
    "DomainNetworkFeatureCont",
    "DomainNetworkParam",
    "DomainServerFeature",
    "DomainServerFeatureCont",
    "DomainServerParam",
    "DomainStorageFeature",
    "DomainStorageFeatureCont",
    "DomainStorageParam",
    "DpsecMac",
    "DupeScope",
    "DupeScopeResult",
    "EpqosDefinition",
    "EpqosDefinitionDelTask",
    "EpqosDefinitionDelTaskFsm",
    "EpqosDefinitionDelTaskFsmStage",
    "EpqosDefinitionDelTaskFsmTask",
    "EpqosDefinitionFsm",
    "EpqosDefinitionFsmStage",
    "EpqosDefinitionFsmTask",
    "EpqosEgress",
    "EquipmentAdaptorConnDef",
    "EquipmentAdaptorDef",
    "EquipmentAdvancedBootOrder",
    "EquipmentAutoconfigPolicy",
    "EquipmentBaseBoardCapProvider",
    "EquipmentBeaconCapProvider",
    "EquipmentBeaconLed",
    "EquipmentBeaconLedFsm",
    "EquipmentBeaconLedFsmStage",
    "EquipmentBeaconLedFsmTask",
    "EquipmentBinding",
    "EquipmentBiosDef",
    "EquipmentBladeAGLibrary",
    "EquipmentBladeAggregationCapRef",
    "EquipmentBladeBiosCapProvider",
    "EquipmentBladeCapProvider",
    "EquipmentBladeCapProviderTypeDef",
    "EquipmentBladeConnDef",
    "EquipmentBladeIOMConnDef",
    "EquipmentBladeSwitchConnDef",
    "EquipmentBoardControllerDef",
    "EquipmentBootDeviceConstraints",
    "EquipmentBreakoutCap",
    "EquipmentCapModSpec",
    "EquipmentCatalogCapProvider",
    "EquipmentChassis",
    "EquipmentChassisAssocCtx",
    "EquipmentChassisCapProvider",
    "EquipmentChassisFsm",
    "EquipmentChassisFsmStage",
    "EquipmentChassisFsmTask",
    "EquipmentChassisInheritPolicy",
    "EquipmentChassisIssues",
    "EquipmentChassisProfile",
    "EquipmentChassisProfileAssocCtx",
    "EquipmentChassisProfileFsm",
    "EquipmentChassisProfileFsmStage",
    "EquipmentChassisProfileFsmTask",
    "EquipmentChassisQual",
    "EquipmentChassisStats",
    "EquipmentChassisStatsHist",
    "EquipmentCimcVmedia",
    "EquipmentCiscoOsOpenGate",
    "EquipmentDbgPluginCapProvider",
    "EquipmentDimmEntry",
    "EquipmentDimmMapping",
    "EquipmentDiscoveryCap",
    "EquipmentDowngradeConstraint",
    "EquipmentEmbeddedStorageDef",
    "EquipmentFan",
    "EquipmentFanModule",
    "EquipmentFanModuleCapProvider",
    "EquipmentFanModuleDef",
    "EquipmentFanModuleStats",
    "EquipmentFanModuleStatsHist",
    "EquipmentFanStats",
    "EquipmentFanStatsHist",
    "EquipmentFex",
    "EquipmentFexCapProvider",
    "EquipmentFexEnvStats",
    "EquipmentFexEnvStatsHist",
    "EquipmentFexFsm",
    "EquipmentFexFsmStage",
    "EquipmentFexFsmTask",
    "EquipmentFexPowerSummary",
    "EquipmentFexPowerSummaryHist",
    "EquipmentFexPsuInputStats",
    "EquipmentFexPsuInputStatsHist",
    "EquipmentFexSystemStats",
    "EquipmentFexSystemStatsHist",
    "EquipmentFirmwareConstraint",
    "EquipmentFlashLife",
    "EquipmentGemCapProvider",
    "EquipmentGemPortCap",
    "EquipmentGraphicsCardCapProvider",
    "EquipmentGraphicsCardCapRef",
    "EquipmentHDDFaultMonDef",
    "EquipmentHealthLed",
    "EquipmentHostIfCapProvider",
    "EquipmentHwCapDerivativeProvider",
    "EquipmentHwRevisionModifier",
    "EquipmentIOCard",
    "EquipmentIOCardBaseFsm",
    "EquipmentIOCardBaseFsmStage",
    "EquipmentIOCardBaseFsmTask",
    "EquipmentIOCardCapProvider",
    "EquipmentIOCardFsm",
    "EquipmentIOCardFsmStage",
    "EquipmentIOCardFsmTask",
    "EquipmentIOCardStats",
    "EquipmentIOCardStatsHist",
    "EquipmentIOCardTypeDef",
    "EquipmentIOExpander",
    "EquipmentIOExpanderCapProvider",
    "EquipmentInbandMgmtCap",
    "EquipmentIndicatorLed",
    "EquipmentKvmMgmtCap",
    "EquipmentLocalDiskCapProvider",
    "EquipmentLocalDiskControllerCapProvider",
    "EquipmentLocalDiskControllerCapRef",
    "EquipmentLocalDiskControllerDef",
    "EquipmentLocalDiskControllerTypeDef",
    "EquipmentLocalDiskDef",
    "EquipmentLocatorLed",
    "EquipmentLocatorLedFsm",
    "EquipmentLocatorLedFsmStage",
    "EquipmentLocatorLedFsmTask",
    "EquipmentManufacturingDef",
    "EquipmentMemoryUnitCapProvider",
    "EquipmentMemoryUnitDiscoveryModifierDef",
    "EquipmentMgmtCapProvider",
    "EquipmentMgmtExtCapProvider",
    "EquipmentNetworkElementFanStats",
    "EquipmentNetworkElementFanStatsHist",
    "EquipmentNonCopperPassiveCap",
    "EquipmentOnboardDeviceDef",
    "EquipmentPOST",
    "EquipmentPOSTCode",
    "EquipmentPOSTCodeReporter",
    "EquipmentPOSTCodeTemplate",
    "EquipmentPciDef",
    "EquipmentPciSlotIdEntry",
    "EquipmentPciSlotIdMapping",
    "EquipmentPciSlotSubOEMIdEntry",
    "EquipmentPfcMmuCap",
    "EquipmentPhysDevicesPerBoard",
    "EquipmentPhysicalDef",
    "EquipmentPhysicalQual",
    "EquipmentPicture",
    "EquipmentPool",
    "EquipmentPoolPolicyRef",
    "EquipmentPoolable",
    "EquipmentPooledChassis",
    "EquipmentPoolingPolicy",
    "EquipmentPortCap",
    "EquipmentPortGroupAggregationDef",
    "EquipmentPortGroupDef",
    "EquipmentPortGroupSwComplexDef",
    "EquipmentPortSwComplexRef",
    "EquipmentPowerCapDef",
    "EquipmentProcessorUnitCapProvider",
    "EquipmentProcessorUnitDef",
    "EquipmentPsu",
    "EquipmentPsuCapProvider",
    "EquipmentPsuDef",
    "EquipmentPsuFsm",
    "EquipmentPsuFsmStage",
    "EquipmentPsuFsmTask",
    "EquipmentPsuInputStats",
    "EquipmentPsuInputStatsHist",
    "EquipmentPsuOutputStats",
    "EquipmentPsuOutputStatsHist",
    "EquipmentPsuStats",
    "EquipmentPsuStatsHist",
    "EquipmentQual",
    "EquipmentRackFanModuleDef",
    "EquipmentRackUnitCapProvider",
    "EquipmentRackUnitFanStats",
    "EquipmentRackUnitFanStatsHist",
    "EquipmentRackUnitPsuStats",
    "EquipmentRackUnitPsuStatsHist",
    "EquipmentRaidDef",
    "EquipmentRequirement",
    "EquipmentSecureBoot",
    "EquipmentSecurityUnitCapProvider",
    "EquipmentServerCorrectUuidBehavior",
    "EquipmentServerFeatureCap",
    "EquipmentServerPortCapProvider",
    "EquipmentServerUnitCapProvider",
    "EquipmentServiceDef",
    "EquipmentSharedIOModule",
    "EquipmentSiocTempStats",
    "EquipmentSiocTempStatsHist",
    "EquipmentSlotArray",
    "EquipmentSlotArrayRef",
    "EquipmentStorageControllerConfig",
    "EquipmentStorageControllerSlotDef",
    "EquipmentStorageEncCapProvider",
    "EquipmentStorageLimitCap",
    "EquipmentStorageSasExpanderCapProvider",
    "EquipmentStorageSasExpanderCapRef",
    "EquipmentStorageSasExpanderDef",
    "EquipmentSwitchCap",
    "EquipmentSwitchCapProvider",
    "EquipmentSwitchCard",
    "EquipmentSwitchIOCard",
    "EquipmentSwitchIOCardCapProvider",
    "EquipmentSwitchIOCardFsm",
    "EquipmentSwitchIOCardFsmStage",
    "EquipmentSwitchIOCardFsmTask",
    "EquipmentSwitchTypeDef",
    "EquipmentSystemIOController",
    "EquipmentSystemIOControllerFsm",
    "EquipmentSystemIOControllerFsmStage",
    "EquipmentSystemIOControllerFsmTask",
    "EquipmentTier",
    "EquipmentTpm",
    "EquipmentTpmCapProvider",
    "EquipmentUnifiedPortCapProvider",
    "EquipmentUuidFeatureCap",
    "EquipmentVersionConstraint",
    "EquipmentXcvr",
    "EtherErrStats",
    "EtherErrStatsHist",
    "EtherFcoeInterfaceStats",
    "EtherFcoeInterfaceStatsHist",
    "EtherLossStats",
    "EtherLossStatsHist",
    "EtherNiErrStats",
    "EtherNiErrStatsHist",
    "EtherNicIfConfig",
    "EtherPIo",
    "EtherPIoEndPoint",
    "EtherPIoFsm",
    "EtherPIoFsmStage",
    "EtherPauseStats",
    "EtherPauseStatsHist",
    "EtherPortChanIdElem",
    "EtherPortChanIdUniverse",
    "EtherRxStats",
    "EtherRxStatsHist",
    "EtherServerIntFIo",
    "EtherServerIntFIoFsm",
    "EtherServerIntFIoFsmStage",
    "EtherServerIntFIoFsmTask",
    "EtherServerIntFIoPc",
    "EtherServerIntFIoPcEp",
    "EtherSwIfConfig",
    "EtherSwitchIntFIo",
    "EtherSwitchIntFIoPc",
    "EtherSwitchIntFIoPcEp",
    "EtherTxStats",
    "EtherTxStatsHist",
    "EventEpCtrl",
    "EventHolder",
    "EventInst",
    "EventLog",
    "EventPolicy",
    "EventRecord",
    "ExtmgmtArpTargets",
    "ExtmgmtGatewayPing",
    "ExtmgmtIf",
    "ExtmgmtIfMonPolicy",
    "ExtmgmtMiiStatus",
    "ExtmgmtNdiscTargets",
    "ExtpolClient",
    "ExtpolClientCont",
    "ExtpolController",
    "ExtpolControllerCont",
    "ExtpolEp",
    "ExtpolEpFsm",
    "ExtpolEpFsmStage",
    "ExtpolEpFsmTask",
    "ExtpolProvider",
    "ExtpolProviderCont",
    "ExtpolProviderFsm",
    "ExtpolProviderFsmStage",
    "ExtpolProviderFsmTask",
    "ExtpolRegistry",
    "ExtpolRegistryFsm",
    "ExtpolRegistryFsmStage",
    "ExtpolRegistryFsmTask",
    "ExtpolSystemContext",
    "ExtvmmEp",
    "ExtvmmEpFsm",
    "ExtvmmEpFsmStage",
    "ExtvmmEpFsmTask",
    "ExtvmmFNDReference",
    "ExtvmmFabricNetwork",
    "ExtvmmFabricNetworkDefinition",
    "ExtvmmKeyInst",
    "ExtvmmKeyRing",
    "ExtvmmKeyStore",
    "ExtvmmKeyStoreFsm",
    "ExtvmmKeyStoreFsmStage",
    "ExtvmmKeyStoreFsmTask",
    "ExtvmmMasterExtKey",
    "ExtvmmMasterExtKeyFsm",
    "ExtvmmMasterExtKeyFsmStage",
    "ExtvmmMasterExtKeyFsmTask",
    "ExtvmmNetworkSets",
    "ExtvmmNetworkSetsFsm",
    "ExtvmmNetworkSetsFsmStage",
    "ExtvmmNetworkSetsFsmTask",
    "ExtvmmProvider",
    "ExtvmmProviderFsm",
    "ExtvmmProviderFsmStage",
    "ExtvmmProviderFsmTask",
    "ExtvmmSwitchDelTask",
    "ExtvmmSwitchDelTaskFsm",
    "ExtvmmSwitchDelTaskFsmStage",
    "ExtvmmSwitchDelTaskFsmTask",
    "ExtvmmSwitchSet",
    "ExtvmmUpLinkPP",
    "ExtvmmVMNDRef",
    "ExtvmmVMNetwork",
    "ExtvmmVMNetworkDefinition",
    "ExtvmmVMNetworkSets",
    "FabricBHVlan",
    "FabricBreakout",
    "FabricCabling",
    "FabricCablingSw",
    "FabricCartridgePhEp",
    "FabricCartridgeSlotEp",
    "FabricCartridgeSlotEpFsm",
    "FabricCartridgeSlotEpFsmStage",
    "FabricCartridgeSlotEpFsmTask",
    "FabricCdpLinkPolicy",
    "FabricChangedObjectRef",
    "FabricChassisEp",
    "FabricComputeMSlotEp",
    "FabricComputeMSlotEpFsm",
    "FabricComputeMSlotEpFsmStage",
    "FabricComputeMSlotEpFsmTask",
    "FabricComputePhEp",
    "FabricComputeSlotEp",
    "FabricComputeSlotEpFsm",
    "FabricComputeSlotEpFsmStage",
    "FabricComputeSlotEpFsmTask",
    "FabricDceSrv",
    "FabricDceSwSrv",
    "FabricDceSwSrvEp",
    "FabricDceSwSrvPc",
    "FabricDceSwSrvPcEp",
    "FabricEp",
    "FabricEpMgr",
    "FabricEpMgrFsm",
    "FabricEpMgrFsmStage",
    "FabricEpMgrFsmTask",
    "FabricEthEstc",
    "FabricEthEstcCloud",
    "FabricEthEstcEp",
    "FabricEthEstcPc",
    "FabricEthEstcPcEp",
    "FabricEthFlowMonLan",
    "FabricEthLan",
    "FabricEthLanEp",
    "FabricEthLanFlowMonitoring",
    "FabricEthLanPc",
    "FabricEthLanPcEp",
    "FabricEthLinkProfile",
    "FabricEthMon",
    "FabricEthMonDestEp",
    "FabricEthMonFiltEp",
    "FabricEthMonFiltRef",
    "FabricEthMonLan",
    "FabricEthMonSrcEp",
    "FabricEthMonSrcRef",
    "FabricEthTargetEp",
    "FabricEthVlanPc",
    "FabricEthVlanPortEp",
    "FabricFcEndpoint",
    "FabricFcEstc",
    "FabricFcEstcCloud",
    "FabricFcEstcEp",
    "FabricFcMon",
    "FabricFcMonDestEp",
    "FabricFcMonFiltEp",
    "FabricFcMonFiltRef",
    "FabricFcMonSan",
    "FabricFcMonSrcEp",
    "FabricFcMonSrcRef",
    "FabricFcSan",
    "FabricFcSanEp",
    "FabricFcSanPc",
    "FabricFcSanPcEp",
    "FabricFcUserZone",
    "FabricFcVsanPc",
    "FabricFcVsanPortEp",
    "FabricFcZoneProfile",
    "FabricFcoeEstcEp",
    "FabricFcoeSanEp",
    "FabricFcoeSanPc",
    "FabricFcoeSanPcEp",
    "FabricFcoeVsanPc",
    "FabricFcoeVsanPortEp",
    "FabricFlowMonDefinition",
    "FabricFlowMonExporterProfile",
    "FabricIf",
    "FabricLacpPolicy",
    "FabricLanAccessMgr",
    "FabricLanCloud",
    "FabricLanCloudFsm",
    "FabricLanCloudFsmStage",
    "FabricLanCloudFsmTask",
    "FabricLanCloudPolicy",
    "FabricLanMonCloud",
    "FabricLanPinGroup",
    "FabricLanPinTarget",
    "FabricLastAckedSlot",
    "FabricLocale",
    "FabricMulticastPolicy",
    "FabricNetGroup",
    "FabricNetflowCollector",
    "FabricNetflowIPv4Addr",
    "FabricNetflowMonExporter",
    "FabricNetflowMonExporterRef",
    "FabricNetflowMonSession",
    "FabricNetflowMonSrcEp",
    "FabricNetflowMonSrcRef",
    "FabricNetflowMonitor",
    "FabricNetflowMonitorRef",
    "FabricNetflowTimeoutPolicy",
    "FabricOrgVlanPolicy",
    "FabricPath",
    "FabricPathConn",
    "FabricPathEp",
    "FabricPoolableVlan",
    "FabricPooledVlan",
    "FabricSanCloud",
    "FabricSanCloudFsm",
    "FabricSanCloudFsmStage",
    "FabricSanCloudFsmTask",
    "FabricSanMonCloud",
    "FabricSanPinGroup",
    "FabricSanPinTarget",
    "FabricSubGroup",
    "FabricSwChPhEp",
    "FabricSwSubGroup",
    "FabricUdldLinkPolicy",
    "FabricUdldPolicy",
    "FabricVCon",
    "FabricVConProfile",
    "FabricVlan",
    "FabricVlanEp",
    "FabricVlanGroupReq",
    "FabricVlanPermit",
    "FabricVlanReq",
    "FabricVnetEpSyncEp",
    "FabricVnetEpSyncEpFsm",
    "FabricVnetEpSyncEpFsmStage",
    "FabricVnetEpSyncEpFsmTask",
    "FabricVsan",
    "FabricVsanEp",
    "FabricVsanMembership",
    "FabricZoneIdUniverse",
    "FaultAffectedClass",
    "FaultHolder",
    "FaultInst",
    "FaultLocalTypedHolder",
    "FaultPolicy",
    "FaultSuppressPolicy",
    "FaultSuppressPolicyItem",
    "FaultSuppressTask",
    "FcErrStats",
    "FcErrStatsHist",
    "FcNicIfConfig",
    "FcPIo",
    "FcPIoFsm",
    "FcPIoFsmStage",
    "FcStats",
    "FcStatsHist",
    "FcSwIfConfig",
    "FcpoolAddr",
    "FcpoolBlock",
    "FcpoolBootTarget",
    "FcpoolFormat",
    "FcpoolInitiator",
    "FcpoolInitiatorEp",
    "FcpoolInitiators",
    "FcpoolPoolable",
    "FcpoolUniverse",
    "FeatureContextEp",
    "FeatureDefinition",
    "FeatureDefinitionInstance",
    "FeatureDefinitionRef",
    "FeatureFruCapProviderInstance",
    "FeatureFruCapProviderRef",
    "FeatureProvider",
    "FeatureProviderInstance",
    "FirmwareAck",
    "FirmwareActivity",
    "FirmwareAutoSyncPolicy",
    "FirmwareBlade",
    "FirmwareBootDefinition",
    "FirmwareBootUnit",
    "FirmwareBundleInfo",
    "FirmwareBundleInfoDigest",
    "FirmwareBundleType",
    "FirmwareBundleTypeCapProvider",
    "FirmwareCatalogPack",
    "FirmwareCatalogue",
    "FirmwareChassisComponentSpec",
    "FirmwareChassisPack",
    "FirmwareCompSource",
    "FirmwareCompTarget",
    "FirmwareComponentSpec",
    "FirmwareComputeHostPack",
    "FirmwareComputeMgmtPack",
    "FirmwareConstraints",
    "FirmwareDependency",
    "FirmwareDistImage",
    "FirmwareDistributable",
    "FirmwareDistributableFsm",
    "FirmwareDistributableFsmStage",
    "FirmwareDistributableFsmTask",
    "FirmwareDownloader",
    "FirmwareDownloaderFsm",
    "FirmwareDownloaderFsmStage",
    "FirmwareDownloaderFsmTask",
    "FirmwareExcludeChassisComponent",
    "FirmwareExcludeServerComponent",
    "FirmwareFileUnit",
    "FirmwareHost",
    "FirmwareHostPackModImpact",
    "FirmwareImage",
    "FirmwareImageFsm",
    "FirmwareImageFsmStage",
    "FirmwareImageFsmTask",
    "FirmwareImageLock",
    "FirmwareInfra",
    "FirmwareInfraPack",
    "FirmwareInstallImpact",
    "FirmwareInstallable",
    "FirmwarePCHStorageConfigConstraint",
    "FirmwarePackItem",
    "FirmwarePlatformBundleTypeCapProvider",
    "FirmwareProcessorTypeConstraint",
    "FirmwareRack",
    "FirmwareRackPowerCapConstraint",
    "FirmwareRunning",
    "FirmwareServerTypeConstraint",
    "FirmwareSpec",
    "FirmwareStatus",
    "FirmwareSystem",
    "FirmwareSystemCompCheckResult",
    "FirmwareSystemFsm",
    "FirmwareSystemFsmStage",
    "FirmwareSystemFsmTask",
    "FirmwareTPMConstraint",
    "FirmwareType",
    "FirmwareUcscInfo",
    "FirmwareUpdatable",
    "FirmwareUpgradeConstraint",
    "FirmwareUpgradeDetail",
    "FirmwareUpgradeInfo",
    "FirmwareVicSlotConstraint",
    "FirmwareVnicCdnConstraint",
    "FlowctrlDefinition",
    "FlowctrlItem",
    "FsmStatus",
    "GmetaClass",
    "GmetaEp",
    "GmetaHolder",
    "GmetaHolderFsm",
    "GmetaHolderFsmStage",
    "GmetaHolderFsmTask",
    "GmetaPolicyMapElement",
    "GmetaPolicyMapHolder",
    "GmetaProp",
    "GraphicsCard",
    "GraphicsController",
    "HostimgPolicy",
    "HostimgTarget",
    "IdentIdentCtx",
    "IdentIdentRequest",
    "IdentIdentRequestFsm",
    "IdentIdentRequestFsmStage",
    "IdentIdentRequestFsmTask",
    "IdentMetaSystem",
    "IdentMetaSystemFsm",
    "IdentMetaSystemFsmStage",
    "IdentMetaSystemFsmTask",
    "IdentMetaVerse",
    "IdentRequestEp",
    "IdentSysInfo",
    "ImgprovPolicy",
    "ImgprovTarget",
    "ImgsecKey",
    "ImgsecPolicy",
    "InitiatorFcInitiatorEp",
    "InitiatorGroupEp",
    "InitiatorIScsiInitiatorEp",
    "InitiatorLunEp",
    "InitiatorMemberEp",
    "InitiatorRequestorEp",
    "InitiatorRequestorGrpEp",
    "InitiatorStoreEp",
    "InitiatorUnitEp",
    "IpDnsSuffix",
    "IpIPv4Dns",
    "IpIPv4WinsServer",
    "IpIpV4StaticAddr",
    "IpIpV4StaticTargetAddr",
    "IpServiceIf",
    "IppoolAddr",
    "IppoolBlock",
    "IppoolIpV6Addr",
    "IppoolIpV6Block",
    "IppoolIpV6Pooled",
    "IppoolPool",
    "IppoolPoolable",
    "IppoolPooled",
    "IppoolUniverse",
    "IqnpoolAddr",
    "IqnpoolBlock",
    "IqnpoolFormat",
    "IqnpoolPool",
    "IqnpoolPoolable",
    "IqnpoolPooled",
    "IqnpoolTransportBlock",
    "IqnpoolUniverse",
    "IscsiAuthProfile",
    "LicenseContents",
    "LicenseDownloader",
    "LicenseDownloaderFsm",
    "LicenseDownloaderFsmStage",
    "LicenseDownloaderFsmTask",
    "LicenseEp",
    "LicenseFeature",
    "LicenseFeatureCapProvider",
    "LicenseFeatureLine",
    "LicenseFile",
    "LicenseFileFsm",
    "LicenseFileFsmStage",
    "LicenseFileFsmTask",
    "LicenseInstance",
    "LicenseInstanceFsm",
    "LicenseInstanceFsmStage",
    "LicenseInstanceFsmTask",
    "LicenseProp",
    "LicenseServerHostId",
    "LicenseSource",
    "LicenseSourceFile",
    "LicenseTarget",
    "LldpAcquired",
    "LsAgentPolicy",
    "LsBinding",
    "LsFcLocale",
    "LsFcZone",
    "LsFcZoneGroup",
    "LsIdentityInfo",
    "LsIssues",
    "LsPower",
    "LsRequirement",
    "LsServer",
    "LsServerAssocCtx",
    "LsServerExtension",
    "LsServerFsm",
    "LsServerFsmStage",
    "LsServerFsmTask",
    "LsTier",
    "LsUuidHistory",
    "LsVConAssign",
    "LsVersionBeh",
    "LsZoneInitiatorMember",
    "LsZoneTargetMember",
    "LsbootBootSecurity",
    "LsbootDef",
    "LsbootDefaultLocalImage",
    "LsbootEFIShell",
    "LsbootEmbeddedLocalDiskImage",
    "LsbootEmbeddedLocalDiskImagePath",
    "LsbootEmbeddedLocalLunImage",
    "LsbootIScsi",
    "LsbootIScsiImagePath",
    "LsbootLan",
    "LsbootLanImagePath",
    "LsbootLocalDiskImage",
    "LsbootLocalDiskImagePath",
    "LsbootLocalHddImage",
    "LsbootLocalLunImagePath",
    "LsbootLocalStorage",
    "LsbootPolicy",
    "LsbootSan",
    "LsbootSanCatSanImage",
    "LsbootSanCatSanImagePath",
    "LsbootSanImage",
    "LsbootSanImagePath",
    "LsbootStorage",
    "LsbootUEFIBootParam",
    "LsbootUsbExternalImage",
    "LsbootUsbFlashStorageImage",
    "LsbootUsbInternalImage",
    "LsbootVirtualMedia",
    "LsmaintAck",
    "LsmaintMaintPolicy",
    "LstorageControllerDef",
    "LstorageControllerModeConfig",
    "LstorageControllerQualifier",
    "LstorageControllerRef",
    "LstorageDasScsiLun",
    "LstorageDiskGroupConfigDef",
    "LstorageDiskGroupConfigPolicy",
    "LstorageDiskGroupQualifier",
    "LstorageDiskSlot",
    "LstorageDiskZoningConfigDef",
    "LstorageDiskZoningPolicy",
    "LstorageLocalDiskConfigRef",
    "LstorageLocalDiskRef",
    "LstorageProfile",
    "LstorageProfileBinding",
    "LstorageProfileDef",
    "LstorageVirtualDriveDef",
    "MacpoolAddr",
    "MacpoolBlock",
    "MacpoolFormat",
    "MacpoolPool",
    "MacpoolPoolable",
    "MacpoolPooled",
    "MacpoolUniverse",
    "MemoryArray",
    "MemoryArrayEnvStats",
    "MemoryArrayEnvStatsHist",
    "MemoryBufferUnit",
    "MemoryBufferUnitEnvStats",
    "MemoryBufferUnitEnvStatsHist",
    "MemoryErrorStats",
    "MemoryQual",
    "MemoryRuntime",
    "MemoryRuntimeHist",
    "MemoryUnit",
    "MemoryUnitEnvStats",
    "MemoryUnitEnvStatsHist",
    "MgmtAccessPolicy",
    "MgmtAccessPolicyItem",
    "MgmtAccessPort",
    "MgmtBackup",
    "MgmtBackupExportExtPolicy",
    "MgmtBackupFsm",
    "MgmtBackupFsmStage",
    "MgmtBackupFsmTask",
    "MgmtBackupPolicy",
    "MgmtBackupPolicyConfig",
    "MgmtBackupPolicyFsm",
    "MgmtBackupPolicyFsmStage",
    "MgmtCfgExportPolicy",
    "MgmtCfgExportPolicyFsm",
    "MgmtCfgExportPolicyFsmStage",
    "MgmtCimcSecureBoot",
    "MgmtCmcSecureBoot",
    "MgmtConnection",
    "MgmtController",
    "MgmtControllerFsm",
    "MgmtControllerFsmStage",
    "MgmtControllerFsmTask",
    "MgmtEntity",
    "MgmtExportPolicyFsm",
    "MgmtExportPolicyFsmStage",
    "MgmtExportPolicyFsmTask",
    "MgmtHealthAttr",
    "MgmtHealthStatus",
    "MgmtIPv6IfAddr",
    "MgmtIPv6IfAddrFsm",
    "MgmtIPv6IfAddrFsmStage",
    "MgmtIPv6IfAddrFsmTask",
    "MgmtIPv6IfConfig",
    "MgmtIf",
    "MgmtIfFsm",
    "MgmtIfFsmStage",
    "MgmtIfFsmTask",
    "MgmtImporter",
    "MgmtImporterFsm",
    "MgmtImporterFsmStage",
    "MgmtImporterFsmTask",
    "MgmtInbandProfile",
    "MgmtIntAuthPolicy",
    "MgmtInterface",
    "MgmtMgmtDbState",
    "MgmtPmonEntry",
    "MgmtProfDerivedInterface",
    "MgmtVnet",
    "MorefFruRef",
    "MorefImportRoot",
    "MorefImportRootFsm",
    "MorefImportRootFsmStage",
    "MorefImportRootFsmTask",
    "MorefProp",
    "MorefRef",
    "NetworkElement",
    "NetworkIfStats",
    "NetworkLanNeighborEntry",
    "NetworkLanNeighbors",
    "NetworkLldpNeighborEntry",
    "NetworkLldpNeighbors",
    "NetworkOperLevel",
    "NetworkSanNeighborEntry",
    "NetworkSanNeighbors",
    "NfsEp",
    "NfsMountDef",
    "NfsMountDefFsm",
    "NfsMountDefFsmStage",
    "NfsMountDefFsmTask",
    "NfsMountInst",
    "NfsMountInstFsm",
    "NfsMountInstFsmStage",
    "NfsMountInstFsmTask",
    "NwctrlDefinition",
    "ObserveFilter",
    "ObserveObserved",
    "ObserveObservedCont",
    "ObserveObservedFsm",
    "ObserveObservedFsmStage",
    "ObserveObservedFsmTask",
    "OrgOrg",
    "OrgSourceMask",
    "OsARPLinkMonitoringPolicy",
    "OsARPTarget",
    "OsAgent",
    "OsEthBondIntf",
    "OsEthBondModeActiveBackup",
    "OsEthBondModeBalancedALB",
    "OsEthBondModeBalancedRR",
    "OsEthBondModeBalancedTLB",
    "OsEthBondModeBalancedXOR",
    "OsEthBondModeBroadcast",
    "OsEthIntf",
    "OsInstance",
    "OsMiiLinkMonitoringPolicy",
    "OsPrimarySlave",
    "PciEquipSlot",
    "PciUnit",
    "PkiCertReq",
    "PkiEp",
    "PkiEpFsm",
    "PkiEpFsmStage",
    "PkiEpFsmTask",
    "PkiKeyRing",
    "PkiTP",
    "PolicyCentraleSync",
    "PolicyCommunication",
    "PolicyConfigBackup",
    "PolicyControlEp",
    "PolicyControlEpFsm",
    "PolicyControlEpFsmStage",
    "PolicyControlEpFsmTask",
    "PolicyControlledInstance",
    "PolicyControlledType",
    "PolicyControlledTypeFsm",
    "PolicyControlledTypeFsmStage",
    "PolicyControlledTypeFsmTask",
    "PolicyDateTime",
    "PolicyDigest",
    "PolicyDiscovery",
    "PolicyDns",
    "PolicyElement",
    "PolicyEquipment",
    "PolicyFault",
    "PolicyIdResolvePolicy",
    "PolicyInfraFirmware",
    "PolicyLocalMap",
    "PolicyMEp",
    "PolicyMonitoring",
    "PolicyPolicyEp",
    "PolicyPolicyRequestor",
    "PolicyPolicyScope",
    "PolicyPolicyScopeCont",
    "PolicyPolicyScopeContext",
    "PolicyPolicyScopeFsm",
    "PolicyPolicyScopeFsmStage",
    "PolicyPolicyScopeFsmTask",
    "PolicyPortConfig",
    "PolicyPowerMgmt",
    "PolicyPsu",
    "PolicyRefReq",
    "PolicySecurity",
    "PolicyStorageAutoConfig",
    "PolicySystemEp",
    "PortDomainEp",
    "PortGroup",
    "PortPIoFsm",
    "PortPIoFsmStage",
    "PortPIoFsmTask",
    "PortSubGroup",
    "PortTrustMode",
    "PowerBudget",
    "PowerChassisMember",
    "PowerEp",
    "PowerFIMember",
    "PowerFexMember",
    "PowerGroup",
    "PowerGroupAdditionPolicy",
    "PowerGroupQual",
    "PowerGroupStats",
    "PowerGroupStatsHist",
    "PowerMgmtPolicy",
    "PowerPlacement",
    "PowerPolicy",
    "PowerPrioWght",
    "PowerProfiledPower",
    "PowerRackUnitMember",
    "ProcDoer",
    "ProcManager",
    "ProcPrt",
    "ProcPrtCounts",
    "ProcStimulusCounts",
    "ProcSvc",
    "ProcTxCounts",
    "ProcessorCore",
    "ProcessorEnvStats",
    "ProcessorEnvStatsHist",
    "ProcessorErrorStats",
    "ProcessorQual",
    "ProcessorRuntime",
    "ProcessorRuntimeHist",
    "ProcessorThread",
    "ProcessorUnit",
    "ProcessorUnitAssocCtx",
    "QosclassDefinition",
    "QosclassDefinitionFsm",
    "QosclassDefinitionFsmStage",
    "QosclassDefinitionFsmTask",
    "QosclassEthBE",
    "QosclassEthClassified",
    "QosclassFc",
    "QueryresultDependency",
    "QueryresultUsage",
    "SecurityUnit",
    "SesDiskSlotEp",
    "SesEnclosure",
    "SolConfig",
    "SolIf",
    "SolPolicy",
    "StatsCollectionPolicy",
    "StatsCollectionPolicyFsm",
    "StatsCollectionPolicyFsmStage",
    "StatsCollectionPolicyFsmTask",
    "StatsHolder",
    "StatsThr32Definition",
    "StatsThr32Value",
    "StatsThr64Definition",
    "StatsThr64Value",
    "StatsThrFloatDefinition",
    "StatsThrFloatValue",
    "StatsThresholdClass",
    "StatsThresholdPolicy",
    "StorageAuthKey",
    "StorageConnectionDef",
    "StorageConnectionPolicy",
    "StorageController",
    "StorageControllerEp",
    "StorageControllerRef",
    "StorageDiskEnvStats",
    "StorageDiskEnvStatsHist",
    "StorageDomainEp",
    "StorageDrive",
    "StorageEmbeddedStorage",
    "StorageEnclosure",
    "StorageEnclosureCap",
    "StorageEnclosureDiskSlotEp",
    "StorageEnclosureFsm",
    "StorageEnclosureFsmStage",
    "StorageEnclosureFsmTask",
    "StorageEnclosureLocalDiskConfig",
    "StorageEpUser",
    "StorageEtherIf",
    "StorageFcIf",
    "StorageFcTargetEp",
    "StorageFcTargetIf",
    "StorageFlexFlashCard",
    "StorageFlexFlashController",
    "StorageFlexFlashControllerFsm",
    "StorageFlexFlashControllerFsmStage",
    "StorageFlexFlashControllerFsmTask",
    "StorageFlexFlashDrive",
    "StorageFlexFlashVirtualDrive",
    "StorageHddMotherBoardTempStats",
    "StorageHddMotherBoardTempStatsHist",
    "StorageHwRevisionModifier",
    "StorageIScsiTargetIf",
    "StorageIniGroup",
    "StorageInitiator",
    "StorageItem",
    "StorageLocalDisk",
    "StorageLocalDiskConfigDef",
    "StorageLocalDiskConfigPolicy",
    "StorageLocalDiskEp",
    "StorageLocalDiskFsm",
    "StorageLocalDiskFsmStage",
    "StorageLocalDiskFsmTask",
    "StorageLocalDiskPartition",
    "StorageLocalDiskSlotEp",
    "StorageLocalLun",
    "StorageLunDisk",
    "StorageLunResourceSelectionLog",
    "StorageMezzFlashLife",
    "StorageNodeEp",
    "StorageNvmeStats",
    "StorageNvmeStatsHist",
    "StorageOnboardDevice",
    "StorageOperation",
    "StorageQual",
    "StorageRaidBattery",
    "StorageSasExpander",
    "StorageSasLinkDescriptor",
    "StorageSasPort",
    "StorageSasPortDescriptor",
    "StorageSasUpLink",
    "StorageScsiLunRef",
    "StorageSystem",
    "StorageSystemFsm",
    "StorageSystemFsmStage",
    "StorageSystemFsmTask",
    "StorageTransportableFlashModule",
    "StorageVDMemberEp",
    "StorageVirtualDrive",
    "StorageVirtualDriveContainer",
    "StorageVirtualDriveEp",
    "StorageVirtualDriveRef",
    "StorageVsanRef",
    "SwAccessDomain",
    "SwAccessDomainFsm",
    "SwAccessDomainFsmStage",
    "SwAccessDomainFsmTask",
    "SwAccessEp",
    "SwCardEnvStats",
    "SwCardEnvStatsHist",
    "SwCmclan",
    "SwEnvStats",
    "SwEnvStatsHist",
    "SwEthEstcEp",
    "SwEthEstcPc",
    "SwEthLanBorder",
    "SwEthLanBorderFsm",
    "SwEthLanBorderFsmStage",
    "SwEthLanBorderFsmTask",
    "SwEthLanEp",
    "SwEthLanFlowMon",
    "SwEthLanFlowMonFsm",
    "SwEthLanFlowMonFsmStage",
    "SwEthLanFlowMonFsmTask",
    "SwEthLanMon",
    "SwEthLanPc",
    "SwEthMon",
    "SwEthMonDestEp",
    "SwEthMonFsm",
    "SwEthMonFsmStage",
    "SwEthMonFsmTask",
    "SwEthMonSrcEp",
    "SwEthTargetEp",
    "SwExtUtility",
    "SwExtUtilityFsm",
    "SwExtUtilityFsmStage",
    "SwExtUtilityFsmTask",
    "SwFabricZoneNs",
    "SwFabricZoneNsOverride",
    "SwFcEndpoint",
    "SwFcEstcEp",
    "SwFcMon",
    "SwFcMonDestEp",
    "SwFcMonFsm",
    "SwFcMonFsmStage",
    "SwFcMonFsmTask",
    "SwFcMonSrcEp",
    "SwFcSanBorder",
    "SwFcSanBorderFsm",
    "SwFcSanBorderFsmStage",
    "SwFcSanBorderFsmTask",
    "SwFcSanEp",
    "SwFcSanMon",
    "SwFcSanPc",
    "SwFcServerZoneGroup",
    "SwFcUserZone",
    "SwFcUserZoneGroup",
    "SwFcZone",
    "SwFcZoneSet",
    "SwFcoeEstcEp",
    "SwFcoeSanEp",
    "SwFcoeSanPc",
    "SwIpRoute",
    "SwNFExporterRef",
    "SwNetflowExporter",
    "SwNetflowMonSession",
    "SwNetflowMonitor",
    "SwNetflowMonitorRef",
    "SwNetflowRecordDef",
    "SwPhys",
    "SwPhysEtherEp",
    "SwPhysFcEp",
    "SwPhysFsm",
    "SwPhysFsmStage",
    "SwPhysFsmTask",
    "SwPortBreakout",
    "SwSubGroup",
    "SwSystemStats",
    "SwSystemStatsHist",
    "SwUlan",
    "SwUtilityDomain",
    "SwUtilityDomainFsm",
    "SwUtilityDomainFsmStage",
    "SwUtilityDomainFsmTask",
    "SwVIFRef",
    "SwVirtL3Intf",
    "SwVlan",
    "SwVlanGroup",
    "SwVlanPortNs",
    "SwVlanPortNsOverride",
    "SwVlanRef",
    "SwVsan",
    "SwZoneInitiatorMember",
    "SwZoneTargetMember",
    "SwatAction",
    "SwatCondition",
    "SwatInjection",
    "SwatResultstats",
    "SwatTarget",
    "SwatTrigger",
    "SyntheticDirectory",
    "SyntheticFile",
    "SyntheticFileSystem",
    "SyntheticFsObj",
    "SyntheticFsObjFsm",
    "SyntheticFsObjFsmStage",
    "SyntheticFsObjFsmTask",
    "SyntheticTime",
    "SysdebugAutoCoreFileExportTarget",
    "SysdebugAutoCoreFileExportTargetFsm",
    "SysdebugAutoCoreFileExportTargetFsmStage",
    "SysdebugAutoCoreFileExportTargetFsmTask",
    "SysdebugBackupBehavior",
    "SysdebugCore",
    "SysdebugCoreFileRepository",
    "SysdebugCoreFsm",
    "SysdebugCoreFsmStage",
    "SysdebugCoreFsmTask",
    "SysdebugEp",
    "SysdebugLogControlDestinationFile",
    "SysdebugLogControlDestinationSyslog",
    "SysdebugLogControlDomain",
    "SysdebugLogControlEp",
    "SysdebugLogControlEpFsm",
    "SysdebugLogControlEpFsmStage",
    "SysdebugLogControlEpFsmTask",
    "SysdebugLogControlModule",
    "SysdebugLogExportPolicy",
    "SysdebugLogExportPolicyFsm",
    "SysdebugLogExportPolicyFsmStage",
    "SysdebugLogExportPolicyFsmTask",
    "SysdebugLogExportStatus",
    "SysdebugMEpLog",
    "SysdebugMEpLogPolicy",
    "SysdebugManualCoreFileExportTarget",
    "SysdebugManualCoreFileExportTargetFsm",
    "SysdebugManualCoreFileExportTargetFsmStage",
    "SysdebugManualCoreFileExportTargetFsmTask",
    "SysdebugTechSupFileRepository",
    "SysdebugTechSupport",
    "SysdebugTechSupportCmdOpt",
    "SysdebugTechSupportFsm",
    "SysdebugTechSupportFsmStage",
    "SysdebugTechSupportFsmTask",
    "SysfileDigest",
    "SysfileMutation",
    "SysfileMutationFsm",
    "SysfileMutationFsmStage",
    "SysfileMutationFsmTask",
    "TopInfoPolicy",
    "TopInfoSyncPolicy",
    "TopMetaInf",
    "TopRoot",
    "TopSysDefaults",
    "TopSystem",
    "TrigAbsWindow",
    "TrigClientToken",
    "TrigLocalAbsWindow",
    "TrigLocalSched",
    "TrigMeta",
    "TrigRecurrWindow",
    "TrigSched",
    "TrigTest",
    "TrigTriggered",
    "UuidpoolAddr",
    "UuidpoolBlock",
    "UuidpoolFormat",
    "UuidpoolPool",
    "UuidpoolPoolable",
    "UuidpoolPooled",
    "UuidpoolUniverse",
    "VersionApplication",
    "VersionEp",
    "VmComputeEp",
    "VmDC",
    "VmDCOrg",
    "VmEp",
    "VmHba",
    "VmHv",
    "VmInstance",
    "VmLifeCyclePolicy",
    "VmLifeCyclePolicyFsm",
    "VmLifeCyclePolicyFsmStage",
    "VmLifeCyclePolicyFsmTask",
    "VmNic",
    "VmOrg",
    "VmSwitch",
    "VmVif",
    "VmVlan",
    "VmVnicProfCl",
    "VmVnicProfInst",
    "VmVsan",
    "VnicBootIpPolicy",
    "VnicBootTarget",
    "VnicConnDef",
    "VnicDefBeh",
    "VnicDynamicCon",
    "VnicDynamicConPolicy",
    "VnicDynamicConPolicyRef",
    "VnicDynamicIdUniverse",
    "VnicDynamicProvider",
    "VnicDynamicProviderEp",
    "VnicEthConfig",
    "VnicEthLif",
    "VnicEther",
    "VnicEtherIf",
    "VnicFc",
    "VnicFcGroupDef",
    "VnicFcGroupTempl",
    "VnicFcIf",
    "VnicFcLif",
    "VnicFcNode",
    "VnicFcOEIf",
    "VnicIPv4Dhcp",
    "VnicIPv4Dns",
    "VnicIPv4If",
    "VnicIPv4IscsiAddr",
    "VnicIPv4PooledIscsiAddr",
    "VnicIPv4StaticRoute",
    "VnicIPv6If",
    "VnicIScsi",
    "VnicIScsiAutoTargetIf",
    "VnicIScsiBootParams",
    "VnicIScsiBootVnic",
    "VnicIScsiConfig",
    "VnicIScsiInitAutoConfigPolicy",
    "VnicIScsiLCP",
    "VnicIScsiNode",
    "VnicIScsiStaticTargetIf",
    "VnicInternalProfile",
    "VnicIpV4History",
    "VnicIpV4MgmtPooledAddr",
    "VnicIpV4PooledAddr",
    "VnicIpV4ProfDerivedAddr",
    "VnicIpV4StaticAddr",
    "VnicIpV6History",
    "VnicIpV6MgmtPooledAddr",
    "VnicIpV6StaticAddr",
    "VnicIpc",
    "VnicIpcIf",
    "VnicIqnHistory",
    "VnicLanConnPolicy",
    "VnicLanConnTempl",
    "VnicLifVlan",
    "VnicLifVsan",
    "VnicLun",
    "VnicMacHistory",
    "VnicOProfileAlias",
    "VnicProfile",
    "VnicProfileAlias",
    "VnicProfileRef",
    "VnicProfileSet",
    "VnicProfileSetFsm",
    "VnicProfileSetFsmStage",
    "VnicProfileSetFsmTask",
    "VnicRackServerDiscoveryProfile",
    "VnicSanConnPolicy",
    "VnicSanConnTempl",
    "VnicScsi",
    "VnicScsiIf",
    "VnicUsnicConPolicy",
    "VnicUsnicConPolicyRef",
    "VnicVhbaBehPolicy",
    "VnicVlan",
    "VnicVmqConPolicy",
    "VnicVmqConPolicyRef",
    "VnicVnicBehPolicy",
    "VnicWwnnHistory",
    "VnicWwpnHistory",
    ])

MO_CLASS_META = {
    "AaaAuthRealm": MoMeta("AaaAuthRealm", "aaaAuthRealm", "auth-realm", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'topSystem'], [u'aaaAuthRealmFsm', u'aaaConsoleAuth', u'aaaDefaultAuth', u'aaaDomain', u'aaaRealmFsm', u'aaaRealmFsmTask', u'eventInst', u'faultInst'], ["Get", "Set"]),
    "AaaAuthRealmFsm": MoMeta("AaaAuthRealmFsm", "aaaAuthRealmFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'aaaAuthRealm'], [u'aaaAuthRealmFsmStage'], [None]),
    "AaaAuthRealmFsmStage": MoMeta("AaaAuthRealmFsmStage", "aaaAuthRealmFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'aaaAuthRealmFsm'], [], [None]),
    "AaaCimcSession": MoMeta("AaaCimcSession", "aaaCimcSession", "cimc-term-[id]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], [u'aaaEpUser', u'aaaRemoteUser', u'aaaUser', u'commSnmpUser', u'storageEpUser'], [], ["Get", "Set"]),
    "AaaConsoleAuth": MoMeta("AaaConsoleAuth", "aaaConsoleAuth", "console-auth", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaAuthRealm'], [u'faultInst'], ["Get", "Set"]),
    "AaaDefaultAuth": MoMeta("AaaDefaultAuth", "aaaDefaultAuth", "default-auth", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaAuthRealm'], [u'faultInst'], ["Get", "Set"]),
    "AaaDomain": MoMeta("AaaDomain", "aaaDomain", "domain-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaAuthRealm'], [u'aaaDomainAuth', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaDomainAuth": MoMeta("AaaDomainAuth", "aaaDomainAuth", "domain-auth", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaDomain'], [u'faultInst'], ["Get", "Set"]),
    "AaaEpAuthProfile": MoMeta("AaaEpAuthProfile", "aaaEpAuthProfile", "auth-profile-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin", "ls-security", "ls-security-policy"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'orgOrg'], [u'aaaEpUser'], ["Add", "Get", "Remove", "Set"]),
    "AaaEpFsm": MoMeta("AaaEpFsm", "aaaEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'aaaLdapEp', u'aaaRadiusEp', u'aaaTacacsPlusEp'], [u'aaaEpFsmStage'], [None]),
    "AaaEpFsmStage": MoMeta("AaaEpFsmStage", "aaaEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'aaaEpFsm'], [], [None]),
    "AaaEpFsmTask": MoMeta("AaaEpFsmTask", "aaaEpFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'aaaLdapEp', u'aaaRadiusEp', u'aaaTacacsPlusEp'], [], [None]),
    "AaaEpLogin": MoMeta("AaaEpLogin", "aaaEpLogin", "ep-login-[name]-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'aaaUserEp'], [], ["Get"]),
    "AaaEpUser": MoMeta("AaaEpUser", "aaaEpUser", "user-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin", "ls-security", "ls-security-policy"], [u'aaaEpAuthProfile', u'computeServerUnit'], [u'aaaCimcSession'], ["Add", "Get", "Remove", "Set"]),
    "AaaExtMgmtCutThruTkn": MoMeta("AaaExtMgmtCutThruTkn", "aaaExtMgmtCutThruTkn", "-[token]", VersionMeta.Version102d, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaUserEp'], [], ["Get"]),
    "AaaLdapEp": MoMeta("AaaLdapEp", "aaaLdapEp", "ldap-ext", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'topSystem'], [u'aaaEpFsm', u'aaaEpFsmTask', u'aaaLdapEpFsm', u'aaaLdapGroup', u'aaaLdapGroupRule', u'aaaLdapProvider', u'aaaProviderGroup', u'eventInst', u'faultInst'], ["Get", "Set"]),
    "AaaLdapEpFsm": MoMeta("AaaLdapEpFsm", "aaaLdapEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'aaaLdapEp'], [u'aaaLdapEpFsmStage'], [None]),
    "AaaLdapEpFsmStage": MoMeta("AaaLdapEpFsmStage", "aaaLdapEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'aaaLdapEpFsm'], [], [None]),
    "AaaLdapGroup": MoMeta("AaaLdapGroup", "aaaLdapGroup", "ldapgroup-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaLdapEp'], [u'aaaUserLocale', u'aaaUserRole'], ["Add", "Get", "Remove", "Set"]),
    "AaaLdapGroupRule": MoMeta("AaaLdapGroupRule", "aaaLdapGroupRule", "ldapgroup-rule", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaLdapEp', u'aaaLdapProvider'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaLdapProvider": MoMeta("AaaLdapProvider", "aaaLdapProvider", "provider-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaLdapEp'], [u'aaaLdapGroupRule'], ["Add", "Get", "Remove", "Set"]),
    "AaaLocale": MoMeta("AaaLocale", "aaaLocale", "locale-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaUserEp'], [u'aaaOrg', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaLog": MoMeta("AaaLog", "aaaLog", "aaa-log", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin", "operations"], [u'topRoot'], [u'aaaModLR', u'aaaSessionLR'], ["Get"]),
    "AaaModLR": MoMeta("AaaModLR", "aaaModLR", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'aaaLog'], [], ["Get"]),
    "AaaOrg": MoMeta("AaaOrg", "aaaOrg", "org-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaLocale'], [u'faultInst'], ["Add", "Get", "Remove"]),
    "AaaPreLoginBanner": MoMeta("AaaPreLoginBanner", "aaaPreLoginBanner", "pre-login-banner", VersionMeta.Version201m, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaUserEp'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaProviderGroup": MoMeta("AaaProviderGroup", "aaaProviderGroup", "providergroup-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaLdapEp', u'aaaRadiusEp', u'aaaTacacsPlusEp'], [u'aaaProviderRef', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaProviderRef": MoMeta("AaaProviderRef", "aaaProviderRef", "provider-ref-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaProviderGroup'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaPwdProfile": MoMeta("AaaPwdProfile", "aaaPwdProfile", "pwd-profile", VersionMeta.Version201m, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaUserEp'], [], ["Get", "Set"]),
    "AaaRadiusEp": MoMeta("AaaRadiusEp", "aaaRadiusEp", "radius-ext", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'topSystem'], [u'aaaEpFsm', u'aaaEpFsmTask', u'aaaProviderGroup', u'aaaRadiusEpFsm', u'aaaRadiusProvider', u'eventInst', u'faultInst'], ["Get", "Set"]),
    "AaaRadiusEpFsm": MoMeta("AaaRadiusEpFsm", "aaaRadiusEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'aaaRadiusEp'], [u'aaaRadiusEpFsmStage'], [None]),
    "AaaRadiusEpFsmStage": MoMeta("AaaRadiusEpFsmStage", "aaaRadiusEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'aaaRadiusEpFsm'], [], [None]),
    "AaaRadiusProvider": MoMeta("AaaRadiusProvider", "aaaRadiusProvider", "provider-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaRadiusEp'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaRealmFsm": MoMeta("AaaRealmFsm", "aaaRealmFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'aaaAuthRealm'], [u'aaaRealmFsmStage'], [None]),
    "AaaRealmFsmStage": MoMeta("AaaRealmFsmStage", "aaaRealmFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'aaaRealmFsm'], [], [None]),
    "AaaRealmFsmTask": MoMeta("AaaRealmFsmTask", "aaaRealmFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'aaaAuthRealm'], [], [None]),
    "AaaRemoteUser": MoMeta("AaaRemoteUser", "aaaRemoteUser", "remoteuser-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaUserEp'], [u'aaaCimcSession', u'aaaSession', u'aaaUserLocale', u'aaaUserRole'], ["Get", "Remove"]),
    "AaaRole": MoMeta("AaaRole", "aaaRole", "role-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaUserEp'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaSession": MoMeta("AaaSession", "aaaSession", "term-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaRemoteUser', u'aaaUser'], [], ["Get", "Remove"]),
    "AaaSessionInfo": MoMeta("AaaSessionInfo", "aaaSessionInfo", "term-[id]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaSessionInfoTable'], [], [None]),
    "AaaSessionInfoTable": MoMeta("AaaSessionInfoTable", "aaaSessionInfoTable", "session-table", VersionMeta.Version212a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'topSystem'], [u'aaaSessionInfo'], [None]),
    "AaaSessionLR": MoMeta("AaaSessionLR", "aaaSessionLR", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'aaaLog'], [], [None]),
    "AaaShellLogin": MoMeta("AaaShellLogin", "aaaShellLogin", "sh-login-[name]-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'aaaUserEp'], [], [None]),
    "AaaSshAuth": MoMeta("AaaSshAuth", "aaaSshAuth", "sshauth", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaUser'], [], ["Get", "Set"]),
    "AaaTacacsPlusEp": MoMeta("AaaTacacsPlusEp", "aaaTacacsPlusEp", "tacacs-ext", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'topSystem'], [u'aaaEpFsm', u'aaaEpFsmTask', u'aaaProviderGroup', u'aaaTacacsPlusEpFsm', u'aaaTacacsPlusProvider', u'eventInst', u'faultInst'], ["Get", "Set"]),
    "AaaTacacsPlusEpFsm": MoMeta("AaaTacacsPlusEpFsm", "aaaTacacsPlusEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'aaaTacacsPlusEp'], [u'aaaTacacsPlusEpFsmStage'], [None]),
    "AaaTacacsPlusEpFsmStage": MoMeta("AaaTacacsPlusEpFsmStage", "aaaTacacsPlusEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'aaaTacacsPlusEpFsm'], [], [None]),
    "AaaTacacsPlusProvider": MoMeta("AaaTacacsPlusProvider", "aaaTacacsPlusProvider", "provider-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaTacacsPlusEp'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaUser": MoMeta("AaaUser", "aaaUser", "user-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaUserEp'], [u'aaaCimcSession', u'aaaSession', u'aaaSshAuth', u'aaaUserData', u'aaaUserLocale', u'aaaUserRole', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaUserData": MoMeta("AaaUserData", "aaaUserData", "user-data", VersionMeta.Version201m, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaUser'], [], ["Get"]),
    "AaaUserEp": MoMeta("AaaUserEp", "aaaUserEp", "user-ext", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'topSystem'], [u'aaaEpLogin', u'aaaExtMgmtCutThruTkn', u'aaaLocale', u'aaaPreLoginBanner', u'aaaPwdProfile', u'aaaRemoteUser', u'aaaRole', u'aaaShellLogin', u'aaaUser', u'aaaUserEpFsm', u'aaaUserEpFsmTask', u'aaaWebLogin', u'eventInst', u'faultInst'], ["Get", "Set"]),
    "AaaUserEpFsm": MoMeta("AaaUserEpFsm", "aaaUserEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'aaaUserEp'], [u'aaaUserEpFsmStage'], [None]),
    "AaaUserEpFsmStage": MoMeta("AaaUserEpFsmStage", "aaaUserEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'aaaUserEpFsm'], [], [None]),
    "AaaUserEpFsmTask": MoMeta("AaaUserEpFsmTask", "aaaUserEpFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'aaaUserEp'], [], [None]),
    "AaaUserLocale": MoMeta("AaaUserLocale", "aaaUserLocale", "locale-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaLdapGroup', u'aaaRemoteUser', u'aaaUser'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaUserRole": MoMeta("AaaUserRole", "aaaUserRole", "role-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaLdapGroup', u'aaaRemoteUser', u'aaaUser'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaWebLogin": MoMeta("AaaWebLogin", "aaaWebLogin", "web-login-[name]-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'aaaUserEp'], [], ["Get"]),
    "AdaptorCapQual": MoMeta("AdaptorCapQual", "adaptorCapQual", "cap-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'adaptorQual'], [], ["Add", "Get", "Remove", "Set"]),
    "AdaptorCapSpec": MoMeta("AdaptorCapSpec", "adaptorCapSpec", "cap-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorDiagCap": MoMeta("AdaptorDiagCap", "adaptorDiagCap", "diag", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorDynamicConfigCap": MoMeta("AdaptorDynamicConfigCap", "adaptorDynamicConfigCap", "cap-dynamic-config", VersionMeta.Version302a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'adaptorFruCapProvider'], [], [None]),
    "AdaptorEthAdvFilterProfile": MoMeta("AdaptorEthAdvFilterProfile", "adaptorEthAdvFilterProfile", "eth-adv-filter", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile'], [], [None]),
    "AdaptorEthArfsProfile": MoMeta("AdaptorEthArfsProfile", "adaptorEthArfsProfile", "eth-arfs", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile'], [], ["Get", "Set"]),
    "AdaptorEthCompQueueProfile": MoMeta("AdaptorEthCompQueueProfile", "adaptorEthCompQueueProfile", "eth-comp-q", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get", "Set"]),
    "AdaptorEthFailoverProfile": MoMeta("AdaptorEthFailoverProfile", "adaptorEthFailoverProfile", "eth-failover", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get", "Set"]),
    "AdaptorEthInterruptProfile": MoMeta("AdaptorEthInterruptProfile", "adaptorEthInterruptProfile", "eth-int", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get", "Set"]),
    "AdaptorEthInterruptScalingProfile": MoMeta("AdaptorEthInterruptScalingProfile", "adaptorEthInterruptScalingProfile", "eth-interrupt-scaling", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile'], [], [None]),
    "AdaptorEthNVGREProfile": MoMeta("AdaptorEthNVGREProfile", "adaptorEthNVGREProfile", "eth-nvgre", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile'], [], ["Get", "Set"]),
    "AdaptorEthOffloadProfile": MoMeta("AdaptorEthOffloadProfile", "adaptorEthOffloadProfile", "eth-offload", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get", "Set"]),
    "AdaptorEthPortBySizeLargeStats": MoMeta("AdaptorEthPortBySizeLargeStats", "adaptorEthPortBySizeLargeStats", "eth-port-by-size-large-stats-[traffic_direction]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorExtEthIf', u'adaptorHostEthIf', u'vmNic'], [u'adaptorEthPortBySizeLargeStatsHist'], ["Get"]),
    "AdaptorEthPortBySizeLargeStatsHist": MoMeta("AdaptorEthPortBySizeLargeStatsHist", "adaptorEthPortBySizeLargeStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorEthPortBySizeLargeStats'], [], ["Get"]),
    "AdaptorEthPortBySizeSmallStats": MoMeta("AdaptorEthPortBySizeSmallStats", "adaptorEthPortBySizeSmallStats", "eth-port-by-size-small-stats-[traffic_direction]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorExtEthIf', u'adaptorHostEthIf', u'vmNic'], [u'adaptorEthPortBySizeSmallStatsHist'], ["Get"]),
    "AdaptorEthPortBySizeSmallStatsHist": MoMeta("AdaptorEthPortBySizeSmallStatsHist", "adaptorEthPortBySizeSmallStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorEthPortBySizeSmallStats'], [], ["Get"]),
    "AdaptorEthPortErrStats": MoMeta("AdaptorEthPortErrStats", "adaptorEthPortErrStats", "eth-port-err-stats-[traffic_direction]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorExtEthIf', u'adaptorHostEthIf', u'vmNic'], [u'adaptorEthPortErrStatsHist'], ["Get"]),
    "AdaptorEthPortErrStatsHist": MoMeta("AdaptorEthPortErrStatsHist", "adaptorEthPortErrStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorEthPortErrStats'], [], ["Get"]),
    "AdaptorEthPortMcastStats": MoMeta("AdaptorEthPortMcastStats", "adaptorEthPortMcastStats", "eth-port-mcast-stats-[traffic_direction]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorExtEthIf', u'adaptorHostEthIf', u'vmNic'], [u'adaptorEthPortMcastStatsHist'], ["Get"]),
    "AdaptorEthPortMcastStatsHist": MoMeta("AdaptorEthPortMcastStatsHist", "adaptorEthPortMcastStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorEthPortMcastStats'], [], ["Get"]),
    "AdaptorEthPortOutsizedStats": MoMeta("AdaptorEthPortOutsizedStats", "adaptorEthPortOutsizedStats", "eth-port-outsized-stats-[traffic_direction]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorExtEthIf', u'adaptorHostEthIf', u'vmNic'], [u'adaptorEthPortOutsizedStatsHist'], ["Get"]),
    "AdaptorEthPortOutsizedStatsHist": MoMeta("AdaptorEthPortOutsizedStatsHist", "adaptorEthPortOutsizedStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorEthPortOutsizedStats'], [], ["Get"]),
    "AdaptorEthPortStats": MoMeta("AdaptorEthPortStats", "adaptorEthPortStats", "eth-port-stats-[traffic_direction]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorExtEthIf', u'adaptorHostEthIf', u'vmNic'], [u'adaptorEthPortStatsHist'], ["Get"]),
    "AdaptorEthPortStatsHist": MoMeta("AdaptorEthPortStatsHist", "adaptorEthPortStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorEthPortStats'], [], ["Get"]),
    "AdaptorEthRecvQueueProfile": MoMeta("AdaptorEthRecvQueueProfile", "adaptorEthRecvQueueProfile", "eth-rcv-q", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get", "Set"]),
    "AdaptorEthRoCEProfile": MoMeta("AdaptorEthRoCEProfile", "adaptorEthRoCEProfile", "eth-roce", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile'], [], ["Get", "Set"]),
    "AdaptorEthVxLANProfile": MoMeta("AdaptorEthVxLANProfile", "adaptorEthVxLANProfile", "eth-vxlan", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile'], [], ["Get", "Set"]),
    "AdaptorEthWorkQueueProfile": MoMeta("AdaptorEthWorkQueueProfile", "adaptorEthWorkQueueProfile", "eth-work-q", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get", "Set"]),
    "AdaptorEtherIfStats": MoMeta("AdaptorEtherIfStats", "adaptorEtherIfStats", "ether-if-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorVlan'], [u'adaptorEtherIfStatsHist'], ["Get"]),
    "AdaptorEtherIfStatsHist": MoMeta("AdaptorEtherIfStatsHist", "adaptorEtherIfStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorEtherIfStats'], [], ["Get"]),
    "AdaptorExtEthIf": MoMeta("AdaptorExtEthIf", "adaptorExtEthIf", "ext-eth-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], [u'adaptorUnit'], [u'adaptorEthPortBySizeLargeStats', u'adaptorEthPortBySizeSmallStats', u'adaptorEthPortErrStats', u'adaptorEthPortMcastStats', u'adaptorEthPortOutsizedStats', u'adaptorEthPortStats', u'adaptorExtEthIfFsm', u'adaptorExtEthIfFsmTask', u'dcxVIf', u'eventInst', u'fabricEthMonSrcEp', u'faultInst'], ["Get", "Set"]),
    "AdaptorExtEthIfFsm": MoMeta("AdaptorExtEthIfFsm", "adaptorExtEthIfFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'adaptorExtEthIf'], [u'adaptorExtEthIfFsmStage'], [None]),
    "AdaptorExtEthIfFsmStage": MoMeta("AdaptorExtEthIfFsmStage", "adaptorExtEthIfFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'adaptorExtEthIfFsm'], [], [None]),
    "AdaptorExtEthIfFsmTask": MoMeta("AdaptorExtEthIfFsmTask", "adaptorExtEthIfFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'adaptorExtEthIf'], [], [None]),
    "AdaptorExtEthIfPc": MoMeta("AdaptorExtEthIfPc", "adaptorExtEthIfPc", "pc-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], [u'fabricLocale'], [u'adaptorExtEthIfPcEp'], ["Get"]),
    "AdaptorExtEthIfPcEp": MoMeta("AdaptorExtEthIfPcEp", "adaptorExtEthIfPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], [u'adaptorExtEthIfPc'], [], ["Get"]),
    "AdaptorExtIpV6RssHashProfile": MoMeta("AdaptorExtIpV6RssHashProfile", "adaptorExtIpV6RssHashProfile", "ext-ipv6-rss-hash", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get"]),
    "AdaptorFamilyTypeDef": MoMeta("AdaptorFamilyTypeDef", "adaptorFamilyTypeDef", "family-type", VersionMeta.Version202m, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider', u'equipmentLocalDiskControllerCapProvider'], [], ["Get"]),
    "AdaptorFcCdbWorkQueueProfile": MoMeta("AdaptorFcCdbWorkQueueProfile", "adaptorFcCdbWorkQueueProfile", "fc-cdb-work-q", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIf', u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcErrorRecoveryProfile": MoMeta("AdaptorFcErrorRecoveryProfile", "adaptorFcErrorRecoveryProfile", "fc-err-rec", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIf', u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcFnicProfile": MoMeta("AdaptorFcFnicProfile", "adaptorFcFnicProfile", "fc-fnic", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIf', u'adaptorHostFcIfProfile'], [], [None]),
    "AdaptorFcIfEventStats": MoMeta("AdaptorFcIfEventStats", "adaptorFcIfEventStats", "fc-if-event-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostFcIf'], [u'adaptorFcIfEventStatsHist'], ["Get"]),
    "AdaptorFcIfEventStatsHist": MoMeta("AdaptorFcIfEventStatsHist", "adaptorFcIfEventStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorFcIfEventStats'], [], ["Get"]),
    "AdaptorFcIfFC4Stats": MoMeta("AdaptorFcIfFC4Stats", "adaptorFcIfFC4Stats", "fc-if-fc4-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostFcIf'], [u'adaptorFcIfFC4StatsHist'], ["Get"]),
    "AdaptorFcIfFC4StatsHist": MoMeta("AdaptorFcIfFC4StatsHist", "adaptorFcIfFC4StatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorFcIfFC4Stats'], [], ["Get"]),
    "AdaptorFcIfFrameStats": MoMeta("AdaptorFcIfFrameStats", "adaptorFcIfFrameStats", "fc-if-frame-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostFcIf'], [u'adaptorFcIfFrameStatsHist'], ["Get"]),
    "AdaptorFcIfFrameStatsHist": MoMeta("AdaptorFcIfFrameStatsHist", "adaptorFcIfFrameStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorFcIfFrameStats'], [], ["Get"]),
    "AdaptorFcInterruptProfile": MoMeta("AdaptorFcInterruptProfile", "adaptorFcInterruptProfile", "fc-int", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIf', u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcOEIf": MoMeta("AdaptorFcOEIf", "adaptorFcOEIf", "fcoe", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'adaptorHostEthIf', u'adaptorHostFcIf'], [u'dcxVIf'], ["Get"]),
    "AdaptorFcPortFLogiProfile": MoMeta("AdaptorFcPortFLogiProfile", "adaptorFcPortFLogiProfile", "fc-port-flogi", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIf', u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcPortPLogiProfile": MoMeta("AdaptorFcPortPLogiProfile", "adaptorFcPortPLogiProfile", "fc-port-plogi", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIf', u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcPortProfile": MoMeta("AdaptorFcPortProfile", "adaptorFcPortProfile", "fc-port", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIf', u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcPortStats": MoMeta("AdaptorFcPortStats", "adaptorFcPortStats", "fc-port-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostFcIf', u'vmNic'], [u'adaptorFcPortStatsHist'], ["Get"]),
    "AdaptorFcPortStatsHist": MoMeta("AdaptorFcPortStatsHist", "adaptorFcPortStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorFcPortStats'], [], ["Get"]),
    "AdaptorFcRecvQueueProfile": MoMeta("AdaptorFcRecvQueueProfile", "adaptorFcRecvQueueProfile", "fc-rcv-q", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIf', u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcWorkQueueProfile": MoMeta("AdaptorFcWorkQueueProfile", "adaptorFcWorkQueueProfile", "fc-work-q", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIf', u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFruCapProvider": MoMeta("AdaptorFruCapProvider", "adaptorFruCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'adaptorCapSpec', u'adaptorDiagCap', u'adaptorDynamicConfigCap', u'adaptorFamilyTypeDef', u'adaptorFwCapProvider', u'adaptorHostMgmtCap', u'adaptorHostPortCap', u'adaptorHostVnicHwAddrCap', u'adaptorHostethHwAddrCap', u'adaptorHostfcHwAddrCap', u'adaptorIScsiCap', u'adaptorLanCap', u'adaptorLldpCap', u'adaptorMgmtVnicEthConfig', u'adaptorNwMgmtCap', u'adaptorNwStatsMgmtCap', u'adaptorRnicCapSpec', u'adaptorSanCap', u'adaptorUplinkHwAddrCap', u'equipmentAdaptorDef', u'equipmentManufacturingDef', u'equipmentPciDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentPortGroupAggregationDef', u'equipmentPortGroupDef', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'firmwareSpec', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "AdaptorFruCapRef": MoMeta("AdaptorFruCapRef", "adaptorFruCapRef", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], ["Get"]),
    "AdaptorFwCapProvider": MoMeta("AdaptorFwCapProvider", "adaptorFwCapProvider", "fw-vendor-[vendor]-model-[model]-version-[version]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorHostEthIf": MoMeta("AdaptorHostEthIf", "adaptorHostEthIf", "host-eth-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], [u'adaptorUnit'], [u'adaptorEthAdvFilterProfile', u'adaptorEthArfsProfile', u'adaptorEthCompQueueProfile', u'adaptorEthFailoverProfile', u'adaptorEthInterruptProfile', u'adaptorEthInterruptScalingProfile', u'adaptorEthNVGREProfile', u'adaptorEthOffloadProfile', u'adaptorEthPortBySizeLargeStats', u'adaptorEthPortBySizeSmallStats', u'adaptorEthPortErrStats', u'adaptorEthPortMcastStats', u'adaptorEthPortOutsizedStats', u'adaptorEthPortStats', u'adaptorEthRecvQueueProfile', u'adaptorEthRoCEProfile', u'adaptorEthVxLANProfile', u'adaptorEthWorkQueueProfile', u'adaptorExtIpV6RssHashProfile', u'adaptorFcOEIf', u'adaptorHostEthIfFsm', u'adaptorHostEthIfFsmTask', u'adaptorIpV4RssHashProfile', u'adaptorIpV6RssHashProfile', u'adaptorRssProfile', u'adaptorUsnicConnDef', u'adaptorVlan', u'adaptorVnicStats', u'dcxVIf', u'dhcpAcquired', u'eventInst', u'faultInst', u'firmwareBootDefinition', u'firmwareRunning', u'mgmtIf', u'networkIfStats'], ["Get", "Set"]),
    "AdaptorHostEthIfFsm": MoMeta("AdaptorHostEthIfFsm", "adaptorHostEthIfFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'adaptorHostEthIf'], [u'adaptorHostEthIfFsmStage'], [None]),
    "AdaptorHostEthIfFsmStage": MoMeta("AdaptorHostEthIfFsmStage", "adaptorHostEthIfFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'adaptorHostEthIfFsm'], [], [None]),
    "AdaptorHostEthIfFsmTask": MoMeta("AdaptorHostEthIfFsmTask", "adaptorHostEthIfFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'adaptorHostEthIf'], [], [None]),
    "AdaptorHostEthIfProfile": MoMeta("AdaptorHostEthIfProfile", "adaptorHostEthIfProfile", "eth-profile-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'orgOrg', u'policySystemEp'], [u'adaptorEthAdvFilterProfile', u'adaptorEthArfsProfile', u'adaptorEthCompQueueProfile', u'adaptorEthFailoverProfile', u'adaptorEthInterruptProfile', u'adaptorEthInterruptScalingProfile', u'adaptorEthNVGREProfile', u'adaptorEthOffloadProfile', u'adaptorEthRecvQueueProfile', u'adaptorEthRoCEProfile', u'adaptorEthVxLANProfile', u'adaptorEthWorkQueueProfile', u'adaptorExtIpV6RssHashProfile', u'adaptorIpV4RssHashProfile', u'adaptorIpV6RssHashProfile', u'adaptorRssProfile'], ["Add", "Get", "Remove", "Set"]),
    "AdaptorHostFcIf": MoMeta("AdaptorHostFcIf", "adaptorHostFcIf", "host-fc-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], [u'adaptorUnit'], [u'adaptorFcCdbWorkQueueProfile', u'adaptorFcErrorRecoveryProfile', u'adaptorFcFnicProfile', u'adaptorFcIfEventStats', u'adaptorFcIfFC4Stats', u'adaptorFcIfFrameStats', u'adaptorFcInterruptProfile', u'adaptorFcOEIf', u'adaptorFcPortFLogiProfile', u'adaptorFcPortPLogiProfile', u'adaptorFcPortProfile', u'adaptorFcPortStats', u'adaptorFcRecvQueueProfile', u'adaptorFcWorkQueueProfile', u'adaptorHostFcIfFsm', u'adaptorHostFcIfFsmTask', u'adaptorVnicStats', u'adaptorVsan', u'dcxVIf', u'eventInst', u'faultInst', u'firmwareBootDefinition', u'firmwareRunning', u'networkIfStats'], ["Get", "Set"]),
    "AdaptorHostFcIfFsm": MoMeta("AdaptorHostFcIfFsm", "adaptorHostFcIfFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'adaptorHostFcIf'], [u'adaptorHostFcIfFsmStage'], [None]),
    "AdaptorHostFcIfFsmStage": MoMeta("AdaptorHostFcIfFsmStage", "adaptorHostFcIfFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'adaptorHostFcIfFsm'], [], [None]),
    "AdaptorHostFcIfFsmTask": MoMeta("AdaptorHostFcIfFsmTask", "adaptorHostFcIfFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'adaptorHostFcIf'], [], [None]),
    "AdaptorHostFcIfProfile": MoMeta("AdaptorHostFcIfProfile", "adaptorHostFcIfProfile", "fc-profile-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'orgOrg'], [u'adaptorFcCdbWorkQueueProfile', u'adaptorFcErrorRecoveryProfile', u'adaptorFcFnicProfile', u'adaptorFcInterruptProfile', u'adaptorFcPortFLogiProfile', u'adaptorFcPortPLogiProfile', u'adaptorFcPortProfile', u'adaptorFcRecvQueueProfile', u'adaptorFcWorkQueueProfile'], ["Add", "Get", "Remove", "Set"]),
    "AdaptorHostIfConfig": MoMeta("AdaptorHostIfConfig", "adaptorHostIfConfig", "host-if-config-[id]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], [None]),
    "AdaptorHostIscsiIf": MoMeta("AdaptorHostIscsiIf", "adaptorHostIscsiIf", "host-iscsi-[id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], [u'adaptorUnit'], [u'adaptorIscsiProt', u'adaptorIscsiTargetIf', u'adaptorProtocolProfile', u'adaptorVlan', u'adaptorVnicStats', u'fabricNetflowIPv4Addr', u'faultInst', u'networkIfStats', u'vnicIPv4Dhcp', u'vnicIPv4Dns', u'vnicIPv4IscsiAddr', u'vnicIPv4PooledIscsiAddr', u'vnicIPv4StaticRoute', u'vnicIpV4MgmtPooledAddr', u'vnicIpV4PooledAddr', u'vnicIpV4ProfDerivedAddr', u'vnicIpV4StaticAddr'], ["Get"]),
    "AdaptorHostIscsiIfProfile": MoMeta("AdaptorHostIscsiIfProfile", "adaptorHostIscsiIfProfile", "iscsi-profile-[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'orgOrg'], [u'adaptorProtocolProfile'], ["Add", "Get", "Remove", "Set"]),
    "AdaptorHostMgmtCap": MoMeta("AdaptorHostMgmtCap", "adaptorHostMgmtCap", "host-mgmt", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorHostPort": MoMeta("AdaptorHostPort", "adaptorHostPort", "host-port-[id]", VersionMeta.Version223a, "InputOutput", 0x1, [], ["read-only"], [u'adaptorUnit'], [], ["Get"]),
    "AdaptorHostPortCap": MoMeta("AdaptorHostPortCap", "adaptorHostPortCap", "max-host-port", VersionMeta.Version223a, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorHostScsiIf": MoMeta("AdaptorHostScsiIf", "adaptorHostScsiIf", "host-scsi-[id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], [u'adaptorUnit'], [u'adaptorHostScsiLunRef', u'adaptorVnicStats', u'faultInst', u'networkIfStats'], ["Get"]),
    "AdaptorHostScsiLunRef": MoMeta("AdaptorHostScsiLunRef", "adaptorHostScsiLunRef", "host-scsi-lun-[lun_order]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin"], [u'adaptorHostScsiIf'], [], ["Get"]),
    "AdaptorHostServiceEthIf": MoMeta("AdaptorHostServiceEthIf", "adaptorHostServiceEthIf", "host-service-eth-[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], [u'adaptorUnit'], [u'adaptorVlan', u'adaptorVnicStats', u'dcxVIf', u'faultInst', u'networkIfStats'], ["Get", "Set"]),
    "AdaptorHostVnicHwAddrCap": MoMeta("AdaptorHostVnicHwAddrCap", "adaptorHostVnicHwAddrCap", "hwaddr-hostvnic", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], [None]),
    "AdaptorHostethHwAddrCap": MoMeta("AdaptorHostethHwAddrCap", "adaptorHostethHwAddrCap", "hwaddr-hosteth", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorHostfcHwAddrCap": MoMeta("AdaptorHostfcHwAddrCap", "adaptorHostfcHwAddrCap", "hwaddr-hostfc", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorIScsiCap": MoMeta("AdaptorIScsiCap", "adaptorIScsiCap", "iscsi", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorIpV4RssHashProfile": MoMeta("AdaptorIpV4RssHashProfile", "adaptorIpV4RssHashProfile", "ipv4-rss-hash", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get"]),
    "AdaptorIpV6RssHashProfile": MoMeta("AdaptorIpV6RssHashProfile", "adaptorIpV6RssHashProfile", "ipv6-rss-hash", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get"]),
    "AdaptorIscsiAuth": MoMeta("AdaptorIscsiAuth", "adaptorIscsiAuth", "iscsi-auth", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "AdaptorIscsiProt": MoMeta("AdaptorIscsiProt", "adaptorIscsiProt", "iscsi-prot", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [u'adaptorHostIscsiIf'], [], [None]),
    "AdaptorIscsiTargetIf": MoMeta("AdaptorIscsiTargetIf", "adaptorIscsiTargetIf", "iscsi-target[priority]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [u'adaptorHostIscsiIf'], [], [None]),
    "AdaptorLanCap": MoMeta("AdaptorLanCap", "adaptorLanCap", "lan", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorLldpCap": MoMeta("AdaptorLldpCap", "adaptorLldpCap", "lldp", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorMenloBaseErrorStats": MoMeta("AdaptorMenloBaseErrorStats", "adaptorMenloBaseErrorStats", "menlo-base-error-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], [u'adaptorMenloBaseErrorStatsHist'], ["Get"]),
    "AdaptorMenloBaseErrorStatsHist": MoMeta("AdaptorMenloBaseErrorStatsHist", "adaptorMenloBaseErrorStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloBaseErrorStats'], [], ["Get"]),
    "AdaptorMenloDcePortStats": MoMeta("AdaptorMenloDcePortStats", "adaptorMenloDcePortStats", "menlo-dce-port-stats-[menlo_port_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloDcePortStatsHist'], ["Get"]),
    "AdaptorMenloDcePortStatsHist": MoMeta("AdaptorMenloDcePortStatsHist", "adaptorMenloDcePortStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloDcePortStats'], [], ["Get"]),
    "AdaptorMenloEthErrorStats": MoMeta("AdaptorMenloEthErrorStats", "adaptorMenloEthErrorStats", "menlo-eth-error-stats-[menlo_eth_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloEthErrorStatsHist'], ["Get"]),
    "AdaptorMenloEthErrorStatsHist": MoMeta("AdaptorMenloEthErrorStatsHist", "adaptorMenloEthErrorStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloEthErrorStats'], [], ["Get"]),
    "AdaptorMenloEthStats": MoMeta("AdaptorMenloEthStats", "adaptorMenloEthStats", "menlo-eth-stats-[menlo_eth_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloEthStatsHist'], ["Get"]),
    "AdaptorMenloEthStatsHist": MoMeta("AdaptorMenloEthStatsHist", "adaptorMenloEthStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloEthStats'], [], ["Get"]),
    "AdaptorMenloFcErrorStats": MoMeta("AdaptorMenloFcErrorStats", "adaptorMenloFcErrorStats", "menlo-fc-error-stats-[menlo_fc_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloFcErrorStatsHist'], ["Get"]),
    "AdaptorMenloFcErrorStatsHist": MoMeta("AdaptorMenloFcErrorStatsHist", "adaptorMenloFcErrorStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloFcErrorStats'], [], ["Get"]),
    "AdaptorMenloFcStats": MoMeta("AdaptorMenloFcStats", "adaptorMenloFcStats", "menlo-fc-stats-[menlo_fc_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloFcStatsHist'], ["Get"]),
    "AdaptorMenloFcStatsHist": MoMeta("AdaptorMenloFcStatsHist", "adaptorMenloFcStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloFcStats'], [], ["Get"]),
    "AdaptorMenloHostPortStats": MoMeta("AdaptorMenloHostPortStats", "adaptorMenloHostPortStats", "menlo-host-port-stats-[menlo_port_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloHostPortStatsHist'], ["Get"]),
    "AdaptorMenloHostPortStatsHist": MoMeta("AdaptorMenloHostPortStatsHist", "adaptorMenloHostPortStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloHostPortStats'], [], ["Get"]),
    "AdaptorMenloMcpuErrorStats": MoMeta("AdaptorMenloMcpuErrorStats", "adaptorMenloMcpuErrorStats", "menlo-mcpu-error-stats-[menlo_mcpu_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloMcpuErrorStatsHist'], ["Get"]),
    "AdaptorMenloMcpuErrorStatsHist": MoMeta("AdaptorMenloMcpuErrorStatsHist", "adaptorMenloMcpuErrorStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloMcpuErrorStats'], [], ["Get"]),
    "AdaptorMenloMcpuStats": MoMeta("AdaptorMenloMcpuStats", "adaptorMenloMcpuStats", "menlo-mcpu-stats-[menlo_mcpu_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloMcpuStatsHist'], ["Get"]),
    "AdaptorMenloMcpuStatsHist": MoMeta("AdaptorMenloMcpuStatsHist", "adaptorMenloMcpuStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloMcpuStats'], [], ["Get"]),
    "AdaptorMenloNetEgStats": MoMeta("AdaptorMenloNetEgStats", "adaptorMenloNetEgStats", "menlo-net-eg-stats-[menlo_net_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloNetEgStatsHist'], ["Get"]),
    "AdaptorMenloNetEgStatsHist": MoMeta("AdaptorMenloNetEgStatsHist", "adaptorMenloNetEgStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloNetEgStats'], [], ["Get"]),
    "AdaptorMenloNetInStats": MoMeta("AdaptorMenloNetInStats", "adaptorMenloNetInStats", "menlo-net-in-stats-[menlo_net_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloNetInStatsHist'], ["Get"]),
    "AdaptorMenloNetInStatsHist": MoMeta("AdaptorMenloNetInStatsHist", "adaptorMenloNetInStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloNetInStats'], [], ["Get"]),
    "AdaptorMenloQErrorStats": MoMeta("AdaptorMenloQErrorStats", "adaptorMenloQErrorStats", "menlo-q-error-stats-comp-[menlo_queue_component]index-[menlo_queue_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloQErrorStatsHist'], ["Get"]),
    "AdaptorMenloQErrorStatsHist": MoMeta("AdaptorMenloQErrorStatsHist", "adaptorMenloQErrorStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloQErrorStats'], [], ["Get"]),
    "AdaptorMenloQStats": MoMeta("AdaptorMenloQStats", "adaptorMenloQStats", "menlo-q-stats-comp-[menlo_queue_component]index-[menlo_queue_index]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloQStatsHist'], ["Get"]),
    "AdaptorMenloQStatsHist": MoMeta("AdaptorMenloQStatsHist", "adaptorMenloQStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloQStats'], [], ["Get"]),
    "AdaptorMgmtVnicEthConfig": MoMeta("AdaptorMgmtVnicEthConfig", "adaptorMgmtVnicEthConfig", "mgmt-vnic", VersionMeta.Version224a, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], [None]),
    "AdaptorNwMgmtCap": MoMeta("AdaptorNwMgmtCap", "adaptorNwMgmtCap", "nw-mgmt", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorNwStatsMgmtCap": MoMeta("AdaptorNwStatsMgmtCap", "adaptorNwStatsMgmtCap", "nw-stats-mgmt", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], [None]),
    "AdaptorProtocolProfile": MoMeta("AdaptorProtocolProfile", "adaptorProtocolProfile", "iscsi-prot-profile", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostIscsiIf', u'adaptorHostIscsiIfProfile'], [], ["Add", "Get", "Set"]),
    "AdaptorQual": MoMeta("AdaptorQual", "adaptorQual", "adaptor", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computeQual'], [u'adaptorCapQual'], ["Add", "Get", "Remove"]),
    "AdaptorRnicCapSpec": MoMeta("AdaptorRnicCapSpec", "adaptorRnicCapSpec", "cap-[type]", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorRssProfile": MoMeta("AdaptorRssProfile", "adaptorRssProfile", "rss", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIf', u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get", "Set"]),
    "AdaptorSanCap": MoMeta("AdaptorSanCap", "adaptorSanCap", "san", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorUnit": MoMeta("AdaptorUnit", "adaptorUnit", "adaptor-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'adaptorExtEthIf', u'adaptorHostEthIf', u'adaptorHostFcIf', u'adaptorHostIscsiIf', u'adaptorHostPort', u'adaptorHostScsiIf', u'adaptorHostServiceEthIf', u'adaptorMenloDcePortStats', u'adaptorMenloEthErrorStats', u'adaptorMenloEthStats', u'adaptorMenloFcErrorStats', u'adaptorMenloFcStats', u'adaptorMenloHostPortStats', u'adaptorMenloMcpuErrorStats', u'adaptorMenloMcpuStats', u'adaptorMenloNetEgStats', u'adaptorMenloNetInStats', u'adaptorMenloQErrorStats', u'adaptorMenloQStats', u'adaptorUnitExtn', u'dcxNs', u'equipmentPOST', u'equipmentPciDef', u'faultInst', u'mgmtController'], ["Get"]),
    "AdaptorUnitAssocCtx": MoMeta("AdaptorUnitAssocCtx", "adaptorUnitAssocCtx", "adaptorunit-assoc-ctx-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'lsServerAssocCtx'], [], ["Get"]),
    "AdaptorUnitExtn": MoMeta("AdaptorUnitExtn", "adaptorUnitExtn", "adaptor-extn-[id]", VersionMeta.Version202m, "InputOutput", 0x1, [], ["read-only"], [u'adaptorUnit'], [u'faultInst'], ["Get"]),
    "AdaptorUplinkHwAddrCap": MoMeta("AdaptorUplinkHwAddrCap", "adaptorUplinkHwAddrCap", "hwaddr-uplink", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorUplinkPortStats": MoMeta("AdaptorUplinkPortStats", "adaptorUplinkPortStats", "", VersionMeta.Version251a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "AdaptorUsnicConnDef": MoMeta("AdaptorUsnicConnDef", "adaptorUsnicConnDef", "usnic-conn-def-[con_policy_name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "read-only"], [u'adaptorHostEthIf'], [u'adaptorEthCompQueueProfile', u'adaptorEthFailoverProfile', u'adaptorEthInterruptProfile', u'adaptorEthOffloadProfile', u'adaptorEthRecvQueueProfile', u'adaptorEthWorkQueueProfile', u'adaptorExtIpV6RssHashProfile', u'adaptorIpV4RssHashProfile', u'adaptorIpV6RssHashProfile', u'adaptorRssProfile'], [None]),
    "AdaptorVlan": MoMeta("AdaptorVlan", "adaptorVlan", "vlan-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'adaptorHostEthIf', u'adaptorHostIscsiIf', u'adaptorHostServiceEthIf'], [u'adaptorEtherIfStats', u'fabricNetflowIPv4Addr', u'faultInst', u'vnicIPv4Dhcp', u'vnicIPv4Dns', u'vnicIPv4IscsiAddr', u'vnicIPv4PooledIscsiAddr', u'vnicIPv4StaticRoute', u'vnicIScsiAutoTargetIf', u'vnicIScsiStaticTargetIf', u'vnicIpV4MgmtPooledAddr', u'vnicIpV4PooledAddr', u'vnicIpV4ProfDerivedAddr', u'vnicIpV4StaticAddr'], ["Get"]),
    "AdaptorVnicStats": MoMeta("AdaptorVnicStats", "adaptorVnicStats", "vnic-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostEthIf', u'adaptorHostFcIf', u'adaptorHostIscsiIf', u'adaptorHostScsiIf', u'adaptorHostServiceEthIf', u'vmNic'], [u'adaptorVnicStatsHist'], ["Get"]),
    "AdaptorVnicStatsHist": MoMeta("AdaptorVnicStatsHist", "adaptorVnicStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorVnicStats'], [], ["Get"]),
    "AdaptorVsan": MoMeta("AdaptorVsan", "adaptorVsan", "vsan-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'adaptorHostFcIf'], [], ["Get"]),
    "ApeAttribute": MoMeta("ApeAttribute", "apeAttribute", "attribute-[id]", VersionMeta.Version224a, "InputOutput", 0x1, [], ["read-only"], [u'apeMcTable'], [], [None]),
    "ApeControllerChassis": MoMeta("ApeControllerChassis", "apeControllerChassis", "Chassis-[index]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'apeControllerManager'], [u'apeControllerEeprom'], [None]),
    "ApeControllerEeprom": MoMeta("ApeControllerEeprom", "apeControllerEeprom", "Eeprom-[side]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'apeControllerChassis'], [], [None]),
    "ApeControllerManager": MoMeta("ApeControllerManager", "apeControllerManager", "Controller", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'apeManager'], [u'apeControllerChassis'], [None]),
    "ApeDcosAgManager": MoMeta("ApeDcosAgManager", "apeDcosAgManager", "DcosAgManager", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], [u'apeManager'], [u'apeSwitchFirmwareInv'], [None]),
    "ApeFru": MoMeta("ApeFru", "apeFru", "fru-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'apeMcTable'], [], [None]),
    "ApeHostAgent": MoMeta("ApeHostAgent", "apeHostAgent", "hostagent-[chassis_id]-[slot_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'apeManager'], [], [None]),
    "ApeLANBoot": MoMeta("ApeLANBoot", "apeLANBoot", "lanboot-[vnic_name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'apeManager'], [], [None]),
    "ApeLocalDiskBoot": MoMeta("ApeLocalDiskBoot", "apeLocalDiskBoot", "localdiskboot-[chassis_id]-[slot_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'apeManager'], [], [None]),
    "ApeManager": MoMeta("ApeManager", "apeManager", "ape", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'apeControllerManager', u'apeDcosAgManager', u'apeHostAgent', u'apeLANBoot', u'apeLocalDiskBoot', u'apeMc', u'apeNicAgManager', u'apeSANBoot', u'apeVirtualMediaBoot'], [None]),
    "ApeMc": MoMeta("ApeMc", "apeMc", "mc-[ip]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'apeManager'], [u'apeMcTable'], [None]),
    "ApeMcStats": MoMeta("ApeMcStats", "apeMcStats", "", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ApeMcTable": MoMeta("ApeMcTable", "apeMcTable", "mctable-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'apeMc'], [u'apeAttribute', u'apeFru', u'apeParam', u'apeReading', u'apeSdr'], [None]),
    "ApeMenlo": MoMeta("ApeMenlo", "apeMenlo", "Menlo-[mac1]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'apeNicAgManager'], [u'apeMenloVnic', u'apePaloVnic'], [None]),
    "ApeMenloVnic": MoMeta("ApeMenloVnic", "apeMenloVnic", "AdapterVnic-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'apeMenlo', u'apePalo'], [u'apeMenloVnicStats', u'apePaloVnicStats'], [None]),
    "ApeMenloVnicStats": MoMeta("ApeMenloVnicStats", "apeMenloVnicStats", "menlostats", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'apeMenloVnic', u'apePaloVnic'], [], [None]),
    "ApeNicAgManager": MoMeta("ApeNicAgManager", "apeNicAgManager", "NicAgManager", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'apeManager'], [u'apeMenlo', u'apePalo'], [None]),
    "ApePalo": MoMeta("ApePalo", "apePalo", "Palo-[mac1]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'apeNicAgManager'], [u'apeMenloVnic', u'apePaloVnic'], [None]),
    "ApePaloVnic": MoMeta("ApePaloVnic", "apePaloVnic", "AdapterVnic-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'apeMenlo', u'apePalo'], [u'apeMenloVnicStats', u'apePaloVnicStats'], [None]),
    "ApePaloVnicStats": MoMeta("ApePaloVnicStats", "apePaloVnicStats", "palostats", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'apeMenloVnic', u'apePaloVnic'], [], [None]),
    "ApeParam": MoMeta("ApeParam", "apeParam", "param-[key]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'apeMcTable'], [], [None]),
    "ApeReading": MoMeta("ApeReading", "apeReading", "reading-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'apeMcTable'], [], [None]),
    "ApeSANBoot": MoMeta("ApeSANBoot", "apeSANBoot", "sanboot-[target_wwn]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'apeManager'], [], [None]),
    "ApeSdr": MoMeta("ApeSdr", "apeSdr", "sdr-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'apeMcTable'], [], [None]),
    "ApeSwitchFirmwareInv": MoMeta("ApeSwitchFirmwareInv", "apeSwitchFirmwareInv", "SwitchFirmwareInv-[fabric]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], [u'apeDcosAgManager'], [], [None]),
    "ApeVirtualMediaBoot": MoMeta("ApeVirtualMediaBoot", "apeVirtualMediaBoot", "virtualmediaboot-[chassis_id]-[slot_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'apeManager'], [], [None]),
    "BiosBOT": MoMeta("BiosBOT", "biosBOT", "bdgep", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'biosUnit'], [u'biosBootDevGrp'], ["Get"]),
    "BiosBootDev": MoMeta("BiosBootDev", "biosBootDev", "[order]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'biosBootDevGrp'], [], ["Get"]),
    "BiosBootDevGrp": MoMeta("BiosBootDevGrp", "biosBootDevGrp", "bdg-[order]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'biosBOT'], [u'biosBootDev'], ["Get"]),
    "BiosFeatureRef": MoMeta("BiosFeatureRef", "biosFeatureRef", "feature-ref-[name]", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], [u'biosRef'], [u'biosParameterRef'], ["Get"]),
    "BiosParameterRef": MoMeta("BiosParameterRef", "biosParameterRef", "parameter-ref-[name]", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], [u'biosFeatureRef'], [u'biosSettingRef'], ["Get"]),
    "BiosRef": MoMeta("BiosRef", "biosRef", "bios-ref", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], [u'equipmentBladeBiosCapProvider'], [u'biosFeatureRef'], ["Get"]),
    "BiosSettingRef": MoMeta("BiosSettingRef", "biosSettingRef", "setting-ref-[name]", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], [u'biosParameterRef'], [], ["Get"]),
    "BiosSettings": MoMeta("BiosSettings", "biosSettings", "bios-settings", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], [u'biosUnit', u'computeDefaults', u'computePlatform'], [u'biosVfACPI10Support', u'biosVfASPMSupport', u'biosVfAllUSBDevices', u'biosVfAltitude', u'biosVfAssertNMIOnPERR', u'biosVfAssertNMIOnSERR', u'biosVfBootOptionRetry', u'biosVfCPUHardwarePowerManagement', u'biosVfCPUPerformance', u'biosVfCPUPowerManagement', u'biosVfConsistentDeviceNameControl', u'biosVfConsoleRedirection', u'biosVfCoreMultiProcessing', u'biosVfDDR3VoltageSelection', u'biosVfDRAMClockThrottling', u'biosVfDirectCacheAccess', u'biosVfDramRefreshRate', u'biosVfEnergyPerformanceTuning', u'biosVfEnhancedIntelSpeedStepTech', u'biosVfEnhancedPowerCappingSupport', u'biosVfExecuteDisableBit', u'biosVfFRB2Timer', u'biosVfFrequencyFloorOverride', u'biosVfFrontPanelLockout', u'biosVfIOEMezz1OptionROM', u'biosVfIOENVMe1OptionROM', u'biosVfIOENVMe2OptionROM', u'biosVfIOESlot1OptionROM', u'biosVfIOESlot2OptionROM', u'biosVfIntegratedGraphics', u'biosVfIntegratedGraphicsApertureSize', u'biosVfIntelEntrySASRAIDModule', u'biosVfIntelHyperThreadingTech', u'biosVfIntelTrustedExecutionTechnology', u'biosVfIntelTurboBoostTech', u'biosVfIntelVTForDirectedIO', u'biosVfIntelVirtualizationTechnology', u'biosVfInterleaveConfiguration', u'biosVfLocalX2Apic', u'biosVfLvDIMMSupport', u'biosVfMaxVariableMTRRSetting', u'biosVfMaximumMemoryBelow4GB', u'biosVfMemoryMappedIOAbove4GB', u'biosVfMirroringMode', u'biosVfNUMAOptimized', u'biosVfOSBootWatchdogTimer', u'biosVfOSBootWatchdogTimerPolicy', u'biosVfOSBootWatchdogTimerTimeout', u'biosVfOnboardGraphics', u'biosVfOnboardSATAController', u'biosVfOnboardStorage', u'biosVfOptionROMEnable', u'biosVfOptionROMLoad', u'biosVfOutOfBandManagement', u'biosVfPCHSATAMode', u'biosVfPCILOMPortsConfiguration', u'biosVfPCIROMCLP', u'biosVfPCISlotLinkSpeed', u'biosVfPCISlotOptionROMEnable', u'biosVfPOSTErrorPause', u'biosVfPSTATECoordination', u'biosVfPackageCStateLimit', u'biosVfProcessorC1E', u'biosVfProcessorC3Report', u'biosVfProcessorC6Report', u'biosVfProcessorC7Report', u'biosVfProcessorCMCI', u'biosVfProcessorCState', u'biosVfProcessorEnergyConfiguration', u'biosVfProcessorPrefetchConfig', u'biosVfQPILinkFrequencySelect', u'biosVfQPISnoopMode', u'biosVfQuietBoot', u'biosVfRedirectionAfterBIOSPOST', u'biosVfResumeOnACPowerLoss', u'biosVfSBMezz1OptionROM', u'biosVfSBNVMe1OptionROM', u'biosVfSIOC1OptionROM', u'biosVfSIOC2OptionROM', u'biosVfScrubPolicies', u'biosVfSelectMemoryRASConfiguration', u'biosVfSerialPortAEnable', u'biosVfSparingMode', u'biosVfSriovConfig', u'biosVfTPMPendingOperation', u'biosVfTPMSupport', u'biosVfTrustedPlatformModule', u'biosVfUCSMBootModeControl', u'biosVfUCSMBootOrderRuleControl', u'biosVfUEFIOSUseLegacyVideo', u'biosVfUSBBootConfig', u'biosVfUSBConfiguration', u'biosVfUSBFrontPanelAccessLock', u'biosVfUSBPortConfiguration', u'biosVfUSBSystemIdlePowerOptimizingSetting', u'biosVfVGAPriority', u'biosVfWorkloadConfiguration'], ["Get"]),
    "BiosUnit": MoMeta("BiosUnit", "biosUnit", "bios", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeExtBoard', u'computeRackUnit', u'computeServerUnit'], [u'biosBOT', u'biosSettings', u'firmwareBootDefinition', u'firmwareRunning', u'firmwareUpdatable'], ["Get"]),
    "BiosVIdentityParams": MoMeta("BiosVIdentityParams", "biosVIdentityParams", "bios-videntity-params", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], ["Get"]),
    "BiosVProfile": MoMeta("BiosVProfile", "biosVProfile", "bios-prof-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'orgOrg'], [u'biosVfACPI10Support', u'biosVfASPMSupport', u'biosVfAllUSBDevices', u'biosVfAltitude', u'biosVfAssertNMIOnPERR', u'biosVfAssertNMIOnSERR', u'biosVfBootOptionRetry', u'biosVfCPUHardwarePowerManagement', u'biosVfCPUPerformance', u'biosVfCPUPowerManagement', u'biosVfConsistentDeviceNameControl', u'biosVfConsoleRedirection', u'biosVfCoreMultiProcessing', u'biosVfDDR3VoltageSelection', u'biosVfDRAMClockThrottling', u'biosVfDirectCacheAccess', u'biosVfDramRefreshRate', u'biosVfEnergyPerformanceTuning', u'biosVfEnhancedIntelSpeedStepTech', u'biosVfEnhancedPowerCappingSupport', u'biosVfExecuteDisableBit', u'biosVfFRB2Timer', u'biosVfFrequencyFloorOverride', u'biosVfFrontPanelLockout', u'biosVfIOEMezz1OptionROM', u'biosVfIOENVMe1OptionROM', u'biosVfIOENVMe2OptionROM', u'biosVfIOESlot1OptionROM', u'biosVfIOESlot2OptionROM', u'biosVfIntegratedGraphics', u'biosVfIntegratedGraphicsApertureSize', u'biosVfIntelEntrySASRAIDModule', u'biosVfIntelHyperThreadingTech', u'biosVfIntelTrustedExecutionTechnology', u'biosVfIntelTurboBoostTech', u'biosVfIntelVTForDirectedIO', u'biosVfIntelVirtualizationTechnology', u'biosVfInterleaveConfiguration', u'biosVfLocalX2Apic', u'biosVfLvDIMMSupport', u'biosVfMaxVariableMTRRSetting', u'biosVfMaximumMemoryBelow4GB', u'biosVfMemoryMappedIOAbove4GB', u'biosVfMirroringMode', u'biosVfNUMAOptimized', u'biosVfOSBootWatchdogTimer', u'biosVfOSBootWatchdogTimerPolicy', u'biosVfOSBootWatchdogTimerTimeout', u'biosVfOnboardGraphics', u'biosVfOnboardSATAController', u'biosVfOnboardStorage', u'biosVfOptionROMEnable', u'biosVfOptionROMLoad', u'biosVfOutOfBandManagement', u'biosVfPCHSATAMode', u'biosVfPCILOMPortsConfiguration', u'biosVfPCIROMCLP', u'biosVfPCISlotLinkSpeed', u'biosVfPCISlotOptionROMEnable', u'biosVfPOSTErrorPause', u'biosVfPSTATECoordination', u'biosVfPackageCStateLimit', u'biosVfProcessorC1E', u'biosVfProcessorC3Report', u'biosVfProcessorC6Report', u'biosVfProcessorC7Report', u'biosVfProcessorCMCI', u'biosVfProcessorCState', u'biosVfProcessorEnergyConfiguration', u'biosVfProcessorPrefetchConfig', u'biosVfQPILinkFrequencySelect', u'biosVfQPISnoopMode', u'biosVfQuietBoot', u'biosVfRedirectionAfterBIOSPOST', u'biosVfResumeOnACPowerLoss', u'biosVfSBMezz1OptionROM', u'biosVfSBNVMe1OptionROM', u'biosVfSIOC1OptionROM', u'biosVfSIOC2OptionROM', u'biosVfScrubPolicies', u'biosVfSelectMemoryRASConfiguration', u'biosVfSerialPortAEnable', u'biosVfSparingMode', u'biosVfSriovConfig', u'biosVfTPMPendingOperation', u'biosVfTPMSupport', u'biosVfTrustedPlatformModule', u'biosVfUCSMBootModeControl', u'biosVfUCSMBootOrderRuleControl', u'biosVfUEFIOSUseLegacyVideo', u'biosVfUSBBootConfig', u'biosVfUSBConfiguration', u'biosVfUSBFrontPanelAccessLock', u'biosVfUSBPortConfiguration', u'biosVfUSBSystemIdlePowerOptimizingSetting', u'biosVfVGAPriority', u'biosVfWorkloadConfiguration'], ["Add", "Get", "Remove", "Set"]),
    "BiosVfACPI10Support": MoMeta("BiosVfACPI10Support", "biosVfACPI10Support", "ACPI10-Support", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfASPMSupport": MoMeta("BiosVfASPMSupport", "biosVfASPMSupport", "ASPM-Support", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAllUSBDevices": MoMeta("BiosVfAllUSBDevices", "biosVfAllUSBDevices", "All-USB-Devices", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAltitude": MoMeta("BiosVfAltitude", "biosVfAltitude", "Altitude", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAssertNMIOnPERR": MoMeta("BiosVfAssertNMIOnPERR", "biosVfAssertNMIOnPERR", "Assert-NMI-on-PERR", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAssertNMIOnSERR": MoMeta("BiosVfAssertNMIOnSERR", "biosVfAssertNMIOnSERR", "Assert-NMI-on-SERR", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfBootOptionRetry": MoMeta("BiosVfBootOptionRetry", "biosVfBootOptionRetry", "Boot-option-retry", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfCPUHardwarePowerManagement": MoMeta("BiosVfCPUHardwarePowerManagement", "biosVfCPUHardwarePowerManagement", "CPU-Hardware-Power-Management", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfCPUPerformance": MoMeta("BiosVfCPUPerformance", "biosVfCPUPerformance", "CPU-Performance", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfCPUPowerManagement": MoMeta("BiosVfCPUPowerManagement", "biosVfCPUPowerManagement", "CPU-Power-Management", VersionMeta.Version302a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get"]),
    "BiosVfConsistentDeviceNameControl": MoMeta("BiosVfConsistentDeviceNameControl", "biosVfConsistentDeviceNameControl", "Consistent-Device-Name-Control", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfConsoleRedirection": MoMeta("BiosVfConsoleRedirection", "biosVfConsoleRedirection", "Console-redirection", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfCoreMultiProcessing": MoMeta("BiosVfCoreMultiProcessing", "biosVfCoreMultiProcessing", "Core-MultiProcessing", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDDR3VoltageSelection": MoMeta("BiosVfDDR3VoltageSelection", "biosVfDDR3VoltageSelection", "DDR3-Voltage-Selection", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDRAMClockThrottling": MoMeta("BiosVfDRAMClockThrottling", "biosVfDRAMClockThrottling", "DRAM-Clock-Throttling", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDirectCacheAccess": MoMeta("BiosVfDirectCacheAccess", "biosVfDirectCacheAccess", "Direct-Cache-Access", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDramRefreshRate": MoMeta("BiosVfDramRefreshRate", "biosVfDramRefreshRate", "Dram-Refresh-Rate", VersionMeta.Version205a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfEnergyPerformanceTuning": MoMeta("BiosVfEnergyPerformanceTuning", "biosVfEnergyPerformanceTuning", "Energy-Performance-Tuning", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfEnhancedIntelSpeedStepTech": MoMeta("BiosVfEnhancedIntelSpeedStepTech", "biosVfEnhancedIntelSpeedStepTech", "Enhanced-Intel-SpeedStep-Tech", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfEnhancedPowerCappingSupport": MoMeta("BiosVfEnhancedPowerCappingSupport", "biosVfEnhancedPowerCappingSupport", "Enhanced-PowerCapping-Support", VersionMeta.Version302a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfExecuteDisableBit": MoMeta("BiosVfExecuteDisableBit", "biosVfExecuteDisableBit", "Execute-Disable-Bit", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfFRB2Timer": MoMeta("BiosVfFRB2Timer", "biosVfFRB2Timer", "FRB-2-Timer", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfFrequencyFloorOverride": MoMeta("BiosVfFrequencyFloorOverride", "biosVfFrequencyFloorOverride", "Frequency-Floor-Override", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfFrontPanelLockout": MoMeta("BiosVfFrontPanelLockout", "biosVfFrontPanelLockout", "Front-panel-lockout", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIOEMezz1OptionROM": MoMeta("BiosVfIOEMezz1OptionROM", "biosVfIOEMezz1OptionROM", "IOEMezz1-OptionROM", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfIOENVMe1OptionROM": MoMeta("BiosVfIOENVMe1OptionROM", "biosVfIOENVMe1OptionROM", "IOENVMe1-OptionROM", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfIOENVMe2OptionROM": MoMeta("BiosVfIOENVMe2OptionROM", "biosVfIOENVMe2OptionROM", "IOENVMe2-OptionROM", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfIOESlot1OptionROM": MoMeta("BiosVfIOESlot1OptionROM", "biosVfIOESlot1OptionROM", "IOESlot1-OptionROM", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfIOESlot2OptionROM": MoMeta("BiosVfIOESlot2OptionROM", "biosVfIOESlot2OptionROM", "IOESlot2-OptionROM", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfIntegratedGraphics": MoMeta("BiosVfIntegratedGraphics", "biosVfIntegratedGraphics", "Integrated-Graphics", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfIntegratedGraphicsApertureSize": MoMeta("BiosVfIntegratedGraphicsApertureSize", "biosVfIntegratedGraphicsApertureSize", "Integrated-Graphics-Aperture-Size", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfIntelEntrySASRAIDModule": MoMeta("BiosVfIntelEntrySASRAIDModule", "biosVfIntelEntrySASRAIDModule", "Intel-entry-SAS-RAID-module", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelHyperThreadingTech": MoMeta("BiosVfIntelHyperThreadingTech", "biosVfIntelHyperThreadingTech", "Intel-HyperThreading-Tech", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelTrustedExecutionTechnology": MoMeta("BiosVfIntelTrustedExecutionTechnology", "biosVfIntelTrustedExecutionTechnology", "Intel-Trusted-Execution-Technology", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelTurboBoostTech": MoMeta("BiosVfIntelTurboBoostTech", "biosVfIntelTurboBoostTech", "Intel-Turbo-Boost-Tech", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelVTForDirectedIO": MoMeta("BiosVfIntelVTForDirectedIO", "biosVfIntelVTForDirectedIO", "Intel-VT-for-directed-IO", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelVirtualizationTechnology": MoMeta("BiosVfIntelVirtualizationTechnology", "biosVfIntelVirtualizationTechnology", "Intel-Virtualization-Technology", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfInterleaveConfiguration": MoMeta("BiosVfInterleaveConfiguration", "biosVfInterleaveConfiguration", "Interleave-Configuration", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfLocalX2Apic": MoMeta("BiosVfLocalX2Apic", "biosVfLocalX2Apic", "Local-X2-Apic", VersionMeta.Version213a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfLvDIMMSupport": MoMeta("BiosVfLvDIMMSupport", "biosVfLvDIMMSupport", "LvDIMM-Support", VersionMeta.Version131c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMaxVariableMTRRSetting": MoMeta("BiosVfMaxVariableMTRRSetting", "biosVfMaxVariableMTRRSetting", "Max-Variable-MTRR-Setting", VersionMeta.Version142b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMaximumMemoryBelow4GB": MoMeta("BiosVfMaximumMemoryBelow4GB", "biosVfMaximumMemoryBelow4GB", "Maximum-memory-below-4GB", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMemoryMappedIOAbove4GB": MoMeta("BiosVfMemoryMappedIOAbove4GB", "biosVfMemoryMappedIOAbove4GB", "Memory-mapped-IO-above-4GB", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMirroringMode": MoMeta("BiosVfMirroringMode", "biosVfMirroringMode", "Mirroring-Mode", VersionMeta.Version131c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfNUMAOptimized": MoMeta("BiosVfNUMAOptimized", "biosVfNUMAOptimized", "NUMA-optimized", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOSBootWatchdogTimer": MoMeta("BiosVfOSBootWatchdogTimer", "biosVfOSBootWatchdogTimer", "OS-Boot-Watchdog-Timer", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOSBootWatchdogTimerPolicy": MoMeta("BiosVfOSBootWatchdogTimerPolicy", "biosVfOSBootWatchdogTimerPolicy", "OS-Boot-Watchdog-Timer-Policy", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOSBootWatchdogTimerTimeout": MoMeta("BiosVfOSBootWatchdogTimerTimeout", "biosVfOSBootWatchdogTimerTimeout", "OS-Boot-Watchdog-Timer-Timeout", VersionMeta.Version203a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOnboardGraphics": MoMeta("BiosVfOnboardGraphics", "biosVfOnboardGraphics", "Onboard-Graphics", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfOnboardSATAController": MoMeta("BiosVfOnboardSATAController", "biosVfOnboardSATAController", "Onboard-SATA-controller", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get"]),
    "BiosVfOnboardStorage": MoMeta("BiosVfOnboardStorage", "biosVfOnboardStorage", "Onboard-Storage", VersionMeta.Version203a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOptionROMEnable": MoMeta("BiosVfOptionROMEnable", "biosVfOptionROMEnable", "OptionROM-Enable", VersionMeta.Version202m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get"]),
    "BiosVfOptionROMLoad": MoMeta("BiosVfOptionROMLoad", "biosVfOptionROMLoad", "OptionROM-load", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get"]),
    "BiosVfOutOfBandManagement": MoMeta("BiosVfOutOfBandManagement", "biosVfOutOfBandManagement", "Out-of-Band-Management", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfPCHSATAMode": MoMeta("BiosVfPCHSATAMode", "biosVfPCHSATAMode", "PCH-SATA-Mode", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPCILOMPortsConfiguration": MoMeta("BiosVfPCILOMPortsConfiguration", "biosVfPCILOMPortsConfiguration", "PCI-LOM-Ports-Configuration", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPCIROMCLP": MoMeta("BiosVfPCIROMCLP", "biosVfPCIROMCLP", "PCI-ROM-CLP", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfPCISlotLinkSpeed": MoMeta("BiosVfPCISlotLinkSpeed", "biosVfPCISlotLinkSpeed", "PCI-Slot-Link-Speed", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPCISlotOptionROMEnable": MoMeta("BiosVfPCISlotOptionROMEnable", "biosVfPCISlotOptionROMEnable", "PCI-Slot-OptionROM-Enable", VersionMeta.Version202m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get"]),
    "BiosVfPOSTErrorPause": MoMeta("BiosVfPOSTErrorPause", "biosVfPOSTErrorPause", "POST-error-pause", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPSTATECoordination": MoMeta("BiosVfPSTATECoordination", "biosVfPSTATECoordination", "P-STATE-Coordination", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPackageCStateLimit": MoMeta("BiosVfPackageCStateLimit", "biosVfPackageCStateLimit", "Package-C-State-Limit", VersionMeta.Version202m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorC1E": MoMeta("BiosVfProcessorC1E", "biosVfProcessorC1E", "Processor-C1E", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorC3Report": MoMeta("BiosVfProcessorC3Report", "biosVfProcessorC3Report", "Processor-C3-Report", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorC6Report": MoMeta("BiosVfProcessorC6Report", "biosVfProcessorC6Report", "Processor-C6-Report", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorC7Report": MoMeta("BiosVfProcessorC7Report", "biosVfProcessorC7Report", "Processor-C7-Report", VersionMeta.Version202m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorCMCI": MoMeta("BiosVfProcessorCMCI", "biosVfProcessorCMCI", "Processor-CMCI", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfProcessorCState": MoMeta("BiosVfProcessorCState", "biosVfProcessorCState", "Processor-C-State", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorEnergyConfiguration": MoMeta("BiosVfProcessorEnergyConfiguration", "biosVfProcessorEnergyConfiguration", "Processor-Energy-Configuration", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorPrefetchConfig": MoMeta("BiosVfProcessorPrefetchConfig", "biosVfProcessorPrefetchConfig", "Processor-Prefetch-Config", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfQPILinkFrequencySelect": MoMeta("BiosVfQPILinkFrequencySelect", "biosVfQPILinkFrequencySelect", "QPI-Link-Frequency-Select", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfQPISnoopMode": MoMeta("BiosVfQPISnoopMode", "biosVfQPISnoopMode", "QPI-Snoop-Mode", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfQuietBoot": MoMeta("BiosVfQuietBoot", "biosVfQuietBoot", "Quiet-Boot", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfRedirectionAfterBIOSPOST": MoMeta("BiosVfRedirectionAfterBIOSPOST", "biosVfRedirectionAfterBIOSPOST", "Redirection-After-BIOS-POST", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfResumeOnACPowerLoss": MoMeta("BiosVfResumeOnACPowerLoss", "biosVfResumeOnACPowerLoss", "Resume-on-AC-power-loss", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSBMezz1OptionROM": MoMeta("BiosVfSBMezz1OptionROM", "biosVfSBMezz1OptionROM", "SBMezz1-OptionROM", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfSBNVMe1OptionROM": MoMeta("BiosVfSBNVMe1OptionROM", "biosVfSBNVMe1OptionROM", "SBNVMe1-OptionROM", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfSIOC1OptionROM": MoMeta("BiosVfSIOC1OptionROM", "biosVfSIOC1OptionROM", "SIOC1-OptionROM", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfSIOC2OptionROM": MoMeta("BiosVfSIOC2OptionROM", "biosVfSIOC2OptionROM", "SIOC2-OptionROM", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfScrubPolicies": MoMeta("BiosVfScrubPolicies", "biosVfScrubPolicies", "Scrub-Policies", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSelectMemoryRASConfiguration": MoMeta("BiosVfSelectMemoryRASConfiguration", "biosVfSelectMemoryRASConfiguration", "SelectMemory-RAS-configuration", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSerialPortAEnable": MoMeta("BiosVfSerialPortAEnable", "biosVfSerialPortAEnable", "Serial-port-A-enable", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSparingMode": MoMeta("BiosVfSparingMode", "biosVfSparingMode", "Sparing-Mode", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSriovConfig": MoMeta("BiosVfSriovConfig", "biosVfSriovConfig", "Sriov-Config", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BiosVfTPMPendingOperation": MoMeta("BiosVfTPMPendingOperation", "biosVfTPMPendingOperation", "TPM-Pending-Operation", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get"]),
    "BiosVfTPMSupport": MoMeta("BiosVfTPMSupport", "biosVfTPMSupport", "TPM-Support", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfTrustedPlatformModule": MoMeta("BiosVfTrustedPlatformModule", "biosVfTrustedPlatformModule", "Trusted-Platform-Module", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUCSMBootModeControl": MoMeta("BiosVfUCSMBootModeControl", "biosVfUCSMBootModeControl", "UCSM-Boot-Mode-Control", VersionMeta.Version213a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get"]),
    "BiosVfUCSMBootOrderRuleControl": MoMeta("BiosVfUCSMBootOrderRuleControl", "biosVfUCSMBootOrderRuleControl", "UCSM-Boot-Order-Rule-Control", VersionMeta.Version142b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get"]),
    "BiosVfUEFIOSUseLegacyVideo": MoMeta("BiosVfUEFIOSUseLegacyVideo", "biosVfUEFIOSUseLegacyVideo", "UEFI-OS-use-legacy-video", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBBootConfig": MoMeta("BiosVfUSBBootConfig", "biosVfUSBBootConfig", "USB-Boot-Config", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBConfiguration": MoMeta("BiosVfUSBConfiguration", "biosVfUSBConfiguration", "USB-Configuration", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBFrontPanelAccessLock": MoMeta("BiosVfUSBFrontPanelAccessLock", "biosVfUSBFrontPanelAccessLock", "USB-Front-Panel-Access-Lock", VersionMeta.Version142b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBPortConfiguration": MoMeta("BiosVfUSBPortConfiguration", "biosVfUSBPortConfiguration", "USB-port-configuration", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBSystemIdlePowerOptimizingSetting": MoMeta("BiosVfUSBSystemIdlePowerOptimizingSetting", "biosVfUSBSystemIdlePowerOptimizingSetting", "USB-System-Idle-Power-Optimizing-Setting", VersionMeta.Version142b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfVGAPriority": MoMeta("BiosVfVGAPriority", "biosVfVGAPriority", "VGA-Priority", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfWorkloadConfiguration": MoMeta("BiosVfWorkloadConfiguration", "biosVfWorkloadConfiguration", "Workload-Configuration", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosSettings', u'biosVProfile'], [], [None]),
    "BmcSELCounter": MoMeta("BmcSELCounter", "bmcSELCounter", "Counter-[local_id]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["read-only"], [u'equipmentPOSTCodeReporter'], [], ["Get"]),
    "CallhomeAnonymousReporting": MoMeta("CallhomeAnonymousReporting", "callhomeAnonymousReporting", "anonymousreporting", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin"], [u'callhomeEp'], [], [None]),
    "CallhomeDest": MoMeta("CallhomeDest", "callhomeDest", "email-[email]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeProfile'], [], ["Add", "Get", "Remove"]),
    "CallhomeEp": MoMeta("CallhomeEp", "callhomeEp", "call-home", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'topRoot'], [u'callhomeAnonymousReporting', u'callhomeEpFsm', u'callhomeEpFsmTask', u'callhomePeriodicSystemInventory', u'callhomePolicy', u'callhomeProfile', u'callhomeSmtp', u'callhomeSource', u'callhomeTestAlert', u'eventInst', u'faultInst'], ["Get", "Set"]),
    "CallhomeEpFsm": MoMeta("CallhomeEpFsm", "callhomeEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'callhomeEp'], [u'callhomeEpFsmStage'], [None]),
    "CallhomeEpFsmStage": MoMeta("CallhomeEpFsmStage", "callhomeEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'callhomeEpFsm'], [], [None]),
    "CallhomeEpFsmTask": MoMeta("CallhomeEpFsmTask", "callhomeEpFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'callhomeEp'], [], [None]),
    "CallhomePeriodicSystemInventory": MoMeta("CallhomePeriodicSystemInventory", "callhomePeriodicSystemInventory", "periodicsysteminventory", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [], ["Get", "Set"]),
    "CallhomePolicy": MoMeta("CallhomePolicy", "callhomePolicy", "policy-[cause]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "fault"], [u'callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "CallhomeProfile": MoMeta("CallhomeProfile", "callhomeProfile", "profile-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [u'callhomeDest'], ["Add", "Get", "Remove", "Set"]),
    "CallhomeSmtp": MoMeta("CallhomeSmtp", "callhomeSmtp", "smtp", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [], ["Get", "Set"]),
    "CallhomeSource": MoMeta("CallhomeSource", "callhomeSource", "source", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [], ["Get", "Set"]),
    "CallhomeTestAlert": MoMeta("CallhomeTestAlert", "callhomeTestAlert", "testalert", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [], ["Get", "Set"]),
    "CapabilityCatalogue": MoMeta("CapabilityCatalogue", "capabilityCatalogue", "capabilities", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'topRoot'], [u'adaptorFruCapProvider', u'capabilityCatalogueFsm', u'capabilityCatalogueFsmTask', u'capabilityEp', u'diagSrvCapProvider', u'equipmentBaseBoardCapProvider', u'equipmentBladeBiosCapProvider', u'equipmentBladeCapProvider', u'equipmentCatalogCapProvider', u'equipmentChassisCapProvider', u'equipmentDbgPluginCapProvider', u'equipmentFanModuleCapProvider', u'equipmentFexCapProvider', u'equipmentGemCapProvider', u'equipmentGraphicsCardCapProvider', u'equipmentHostIfCapProvider', u'equipmentHwCapDerivativeProvider', u'equipmentIOCardCapProvider', u'equipmentIOExpanderCapProvider', u'equipmentLocalDiskCapProvider', u'equipmentLocalDiskControllerCapProvider', u'equipmentMemoryUnitCapProvider', u'equipmentMgmtCapProvider', u'equipmentMgmtExtCapProvider', u'equipmentPOSTCodeReporter', u'equipmentPOSTCodeTemplate', u'equipmentProcessorUnitCapProvider', u'equipmentPsuCapProvider', u'equipmentRackUnitCapProvider', u'equipmentSecurityUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentStorageEncCapProvider', u'equipmentStorageSasExpanderCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider', u'equipmentTpmCapProvider', u'eventInst', u'faultInst', u'featureDefinition', u'featureProvider', u'firmwareBootDefinition', u'firmwareBundleTypeCapProvider', u'firmwarePlatformBundleTypeCapProvider', u'firmwareRunning', u'licenseFeatureCapProvider'], ["Get"]),
    "CapabilityCatalogueFsm": MoMeta("CapabilityCatalogueFsm", "capabilityCatalogueFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'capabilityCatalogue'], [u'capabilityCatalogueFsmStage'], [None]),
    "CapabilityCatalogueFsmStage": MoMeta("CapabilityCatalogueFsmStage", "capabilityCatalogueFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'capabilityCatalogueFsm'], [], [None]),
    "CapabilityCatalogueFsmTask": MoMeta("CapabilityCatalogueFsmTask", "capabilityCatalogueFsmTask", "task-[item]", VersionMeta.Version131c, "OutputOnly", 0x1, [], [""], [u'capabilityCatalogue'], [], [None]),
    "CapabilityEp": MoMeta("CapabilityEp", "capabilityEp", "ep", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], [u'capabilityCatalogue'], [u'capabilityMgmtExtension', u'capabilityUpdate', u'capabilityUpdater'], ["Get"]),
    "CapabilityFeatureLimits": MoMeta("CapabilityFeatureLimits", "capabilityFeatureLimits", "feature-[platform]-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'capabilityNetworkLimits', u'capabilityStorageLimits', u'capabilitySystemLimits'], [], [None]),
    "CapabilityMgmtExtension": MoMeta("CapabilityMgmtExtension", "capabilityMgmtExtension", "mgmt-ext", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'capabilityEp'], [u'capabilityMgmtExtensionFsm', u'capabilityMgmtExtensionFsmTask', u'eventInst', u'faultInst', u'firmwareBootDefinition', u'firmwareRunning'], ["Get"]),
    "CapabilityMgmtExtensionFsm": MoMeta("CapabilityMgmtExtensionFsm", "capabilityMgmtExtensionFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'capabilityMgmtExtension'], [u'capabilityMgmtExtensionFsmStage'], [None]),
    "CapabilityMgmtExtensionFsmStage": MoMeta("CapabilityMgmtExtensionFsmStage", "capabilityMgmtExtensionFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'capabilityMgmtExtensionFsm'], [], [None]),
    "CapabilityMgmtExtensionFsmTask": MoMeta("CapabilityMgmtExtensionFsmTask", "capabilityMgmtExtensionFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], [u'capabilityMgmtExtension'], [], [None]),
    "CapabilityNetworkLimits": MoMeta("CapabilityNetworkLimits", "capabilityNetworkLimits", "network-limits", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'topSysDefaults'], [u'capabilityFeatureLimits'], [None]),
    "CapabilityStorageLimits": MoMeta("CapabilityStorageLimits", "capabilityStorageLimits", "storage-limits", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'topSysDefaults'], [u'capabilityFeatureLimits'], [None]),
    "CapabilitySystemLimits": MoMeta("CapabilitySystemLimits", "capabilitySystemLimits", "system-limits", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'topSysDefaults'], [u'capabilityFeatureLimits'], [None]),
    "CapabilityUpdate": MoMeta("CapabilityUpdate", "capabilityUpdate", "update-[version]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["admin"], [u'capabilityEp'], [], ["Get"]),
    "CapabilityUpdater": MoMeta("CapabilityUpdater", "capabilityUpdater", "updater-[file_name]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["admin"], [u'capabilityEp'], [u'capabilityUpdaterFsm', u'capabilityUpdaterFsmTask', u'eventInst', u'faultInst'], ["Get"]),
    "CapabilityUpdaterFsm": MoMeta("CapabilityUpdaterFsm", "capabilityUpdaterFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'capabilityUpdater'], [u'capabilityUpdaterFsmStage'], [None]),
    "CapabilityUpdaterFsmStage": MoMeta("CapabilityUpdaterFsmStage", "capabilityUpdaterFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'capabilityUpdaterFsm'], [], [None]),
    "CapabilityUpdaterFsmTask": MoMeta("CapabilityUpdaterFsmTask", "capabilityUpdaterFsmTask", "task-[item]", VersionMeta.Version131c, "OutputOnly", 0x1, [], [""], [u'capabilityUpdater'], [], [None]),
    "ChangeChangedObjectRef": MoMeta("ChangeChangedObjectRef", "changeChangedObjectRef", "ChangedObjectRef[id]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "CimcvmediaActualMountEntry": MoMeta("CimcvmediaActualMountEntry", "cimcvmediaActualMountEntry", "actual-mount-entry-[virtual_disk_id]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], [u'cimcvmediaActualMountList'], [u'faultInst'], ["Get"]),
    "CimcvmediaActualMountList": MoMeta("CimcvmediaActualMountList", "cimcvmediaActualMountList", "actual-mount-list", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], [u'mgmtController'], [u'cimcvmediaActualMountEntry', u'cimcvmediaExtMgmtRuleEntry'], ["Get"]),
    "CimcvmediaConfigMountEntry": MoMeta("CimcvmediaConfigMountEntry", "cimcvmediaConfigMountEntry", "cfg-mnt-entry-[mapping_name]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'cimcvmediaMountConfigDef', u'cimcvmediaMountConfigPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "CimcvmediaExtMgmtRuleEntry": MoMeta("CimcvmediaExtMgmtRuleEntry", "cimcvmediaExtMgmtRuleEntry", "ext-mgmt-rule-[mapping_name]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], [u'cimcvmediaActualMountList'], [], ["Get"]),
    "CimcvmediaMountConfigDef": MoMeta("CimcvmediaMountConfigDef", "cimcvmediaMountConfigDef", "mnt-cfg-def", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'lsServer'], [u'cimcvmediaConfigMountEntry'], ["Add", "Get", "Remove", "Set"]),
    "CimcvmediaMountConfigPolicy": MoMeta("CimcvmediaMountConfigPolicy", "cimcvmediaMountConfigPolicy", "mnt-cfg-policy-[name]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'orgOrg'], [u'cimcvmediaConfigMountEntry'], ["Add", "Get", "Remove", "Set"]),
    "ClitestTypeTest": MoMeta("ClitestTypeTest", "clitestTypeTest", "tt-", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [], ["Get"]),
    "ClitestTypeTest2": MoMeta("ClitestTypeTest2", "clitestTypeTest2", "tt2-", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [], ["Get"]),
    "ClitestTypeTestChild": MoMeta("ClitestTypeTestChild", "clitestTypeTestChild", "tt-child", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [], [], ["Get"]),
    "CommCimcWebService": MoMeta("CommCimcWebService", "commCimcWebService", "cimc-web-svc", VersionMeta.Version221b, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSvcEp'], [], [None]),
    "CommCimxml": MoMeta("CommCimxml", "commCimxml", "cimxml-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSvcEp'], [], ["Get", "Set"]),
    "CommDateTime": MoMeta("CommDateTime", "commDateTime", "datetime-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], [u'commLocale', u'commSvcEp', u'commSvcPolicy'], [u'commNtpProvider', u'faultInst'], ["Get", "Set"]),
    "CommDns": MoMeta("CommDns", "commDns", "dns-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config"], [u'commLocale', u'commSvcEp', u'commSvcPolicy'], [u'commDnsProvider'], ["Get", "Set"]),
    "CommDnsProvider": MoMeta("CommDnsProvider", "commDnsProvider", "dns-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config"], [u'commDns'], [], ["Add", "Get", "Remove"]),
    "CommEvtChannel": MoMeta("CommEvtChannel", "commEvtChannel", "svc-evt-channel", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSvcEp'], [], ["Get"]),
    "CommHttp": MoMeta("CommHttp", "commHttp", "http-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSvcEp'], [], ["Get", "Set"]),
    "CommHttps": MoMeta("CommHttps", "commHttps", "https-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSvcEp'], [], ["Get", "Set"]),
    "CommLocale": MoMeta("CommLocale", "commLocale", "locale-[name]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [], [u'commDateTime', u'commDns', u'commSyslog'], [None]),
    "CommNtpProvider": MoMeta("CommNtpProvider", "commNtpProvider", "ntp-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], [u'commDateTime'], [], ["Add", "Get", "Remove"]),
    "CommShellSvcLimits": MoMeta("CommShellSvcLimits", "commShellSvcLimits", "shell-svc-limits", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSvcEp'], [], ["Get"]),
    "CommSmashCLP": MoMeta("CommSmashCLP", "commSmashCLP", "smashclp-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSvcEp'], [], ["Get"]),
    "CommSnmp": MoMeta("CommSnmp", "commSnmp", "snmp-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSvcEp'], [u'commSnmpTrap', u'commSnmpUser', u'faultInst'], ["Get", "Set"]),
    "CommSnmpTrap": MoMeta("CommSnmpTrap", "commSnmpTrap", "snmp-trap[hostname]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSnmp'], [], ["Add", "Get", "Remove", "Set"]),
    "CommSnmpUser": MoMeta("CommSnmpUser", "commSnmpUser", "snmpv3-user-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSnmp'], [u'aaaCimcSession', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "CommSsh": MoMeta("CommSsh", "commSsh", "ssh-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSvcEp'], [], ["Get"]),
    "CommSvcEp": MoMeta("CommSvcEp", "commSvcEp", "svc-ext", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'topSystem'], [u'commCimcWebService', u'commCimxml', u'commDateTime', u'commDns', u'commEvtChannel', u'commHttp', u'commHttps', u'commShellSvcLimits', u'commSmashCLP', u'commSnmp', u'commSsh', u'commSvcEpFsm', u'commSvcEpFsmTask', u'commSyslog', u'commTelnet', u'commWebChannel', u'commWebSvcLimits', u'commWsman', u'commXmlClConnPolicy', u'eventInst', u'faultInst'], ["Get"]),
    "CommSvcEpFsm": MoMeta("CommSvcEpFsm", "commSvcEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'commSvcEp'], [u'commSvcEpFsmStage'], [None]),
    "CommSvcEpFsmStage": MoMeta("CommSvcEpFsmStage", "commSvcEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'commSvcEpFsm'], [], [None]),
    "CommSvcEpFsmTask": MoMeta("CommSvcEpFsmTask", "commSvcEpFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'commSvcEp'], [], [None]),
    "CommSvcPolicy": MoMeta("CommSvcPolicy", "commSvcPolicy", "comm-pol-[name]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'commDateTime', u'commDns', u'commSyslog'], [None]),
    "CommSyslog": MoMeta("CommSyslog", "commSyslog", "syslog", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'commLocale', u'commSvcEp', u'commSvcPolicy'], [u'commSyslogClient', u'commSyslogConsole', u'commSyslogFile', u'commSyslogMonitor', u'commSyslogSource'], ["Get", "Set"]),
    "CommSyslogClient": MoMeta("CommSyslogClient", "commSyslogClient", "client-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'commSyslog'], [], ["Get", "Set"]),
    "CommSyslogConsole": MoMeta("CommSyslogConsole", "commSyslogConsole", "console", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'commSyslog'], [], ["Get", "Set"]),
    "CommSyslogFile": MoMeta("CommSyslogFile", "commSyslogFile", "file", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'commSyslog'], [], ["Get", "Set"]),
    "CommSyslogMonitor": MoMeta("CommSyslogMonitor", "commSyslogMonitor", "monitor", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'commSyslog'], [], ["Get", "Set"]),
    "CommSyslogSource": MoMeta("CommSyslogSource", "commSyslogSource", "source", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "operations"], [u'commSyslog'], [], ["Get", "Set"]),
    "CommTelnet": MoMeta("CommTelnet", "commTelnet", "telnet-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSvcEp'], [], ["Get", "Set"]),
    "CommWebChannel": MoMeta("CommWebChannel", "commWebChannel", "svc-web-channel", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSvcEp'], [], ["Get"]),
    "CommWebSvcLimits": MoMeta("CommWebSvcLimits", "commWebSvcLimits", "web-svc-limits", VersionMeta.Version141i, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSvcEp'], [], ["Get", "Set"]),
    "CommWsman": MoMeta("CommWsman", "commWsman", "wsman-svc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSvcEp'], [], ["Get"]),
    "CommXmlClConnPolicy": MoMeta("CommXmlClConnPolicy", "commXmlClConnPolicy", "xmlclconnpolicy-[client_type]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSvcEp'], [], ["Get"]),
    "ComputeAutoconfigPolicy": MoMeta("ComputeAutoconfigPolicy", "computeAutoconfigPolicy", "autoconfig-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [u'faultInst'], ["Get", "Set"]),
    "ComputeBlade": MoMeta("ComputeBlade", "computeBlade", "blade-[slot_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassis'], [u'aaaEpAuthProfile', u'aaaEpUser', u'adaptorHostIfConfig', u'adaptorUnit', u'biosUnit', u'biosVIdentityParams', u'cimcvmediaMountConfigDef', u'computeBladeFsm', u'computeBladeFsmTask', u'computeBoard', u'computeBoardConnector', u'computeBoardController', u'computeExtBoard', u'computeFactoryResetOperation', u'computeFwSyncAck', u'computeKvmMgmtPolicy', u'computeMemoryConfiguration', u'computePhysicalFsm', u'computePhysicalFsmTask', u'computePnuOSImage', u'computePoolable', u'computeScrubPolicy', u'diagSrvCtrl', u'equipmentBeaconLed', u'equipmentHealthLed', u'equipmentIOExpander', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'equipmentPOST', u'eventInst', u'fabricLocale', u'faultInst', u'faultSuppressTask', u'firmwareImageLock', u'firmwareStatus', u'lsIdentityInfo', u'lsbootDef', u'memoryRuntime', u'mgmtController', u'osAgent', u'osInstance', u'pciEquipSlot', u'pciUnit', u'powerBudget', u'processorRuntime', u'solIf', u'storageEnclosure', u'storageVirtualDriveContainer'], ["Get", "Set"]),
    "ComputeBladeDiscPolicy": MoMeta("ComputeBladeDiscPolicy", "computeBladeDiscPolicy", "blade-discovery[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeBladeEp": MoMeta("ComputeBladeEp", "computeBladeEp", "blade-ep-[id]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ComputeBladeFsm": MoMeta("ComputeBladeFsm", "computeBladeFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'computeBlade'], [u'computeBladeFsmStage'], [None]),
    "ComputeBladeFsmStage": MoMeta("ComputeBladeFsmStage", "computeBladeFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'computeBladeFsm'], [], [None]),
    "ComputeBladeFsmTask": MoMeta("ComputeBladeFsmTask", "computeBladeFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'computeBlade'], [], [None]),
    "ComputeBladeInheritPolicy": MoMeta("ComputeBladeInheritPolicy", "computeBladeInheritPolicy", "blade-inherit-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "ComputeBoard": MoMeta("ComputeBoard", "computeBoard", "board", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'computeIOHub', u'computeMbPowerStats', u'computeMbTempStats', u'computePCIeFatalCompletionStats', u'computePCIeFatalProtocolStats', u'computePCIeFatalReceiveStats', u'computePCIeFatalStats', u'computeRackUnitMbTempStats', u'computeRtcBattery', u'equipmentTpm', u'faultInst', u'graphicsCard', u'memoryArray', u'memoryBufferUnit', u'processorUnit', u'securityUnit', u'storageController', u'storageFlexFlashController', u'storageLocalDiskSlotEp', u'storageSasExpander'], ["Get"]),
    "ComputeBoardConnector": MoMeta("ComputeBoardConnector", "computeBoardConnector", "board-conn", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade'], [], ["Get"]),
    "ComputeBoardController": MoMeta("ComputeBoardController", "computeBoardController", "boardController", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeExtBoard', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis'], [u'mgmtController'], ["Get"]),
    "ComputeCartridge": MoMeta("ComputeCartridge", "computeCartridge", "cartridge-[slot_id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassis'], [u'computeServerUnit'], ["Get", "Set"]),
    "ComputeChassisConnPolicy": MoMeta("ComputeChassisConnPolicy", "computeChassisConnPolicy", "chassis-conn-policy-chassis-[chassis_id]-fabric-[switch_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [], ["Get", "Set"]),
    "ComputeChassisDiscPolicy": MoMeta("ComputeChassisDiscPolicy", "computeChassisDiscPolicy", "chassis-discovery", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [], ["Get", "Set"]),
    "ComputeChassisQual": MoMeta("ComputeChassisQual", "computeChassisQual", "chassis-from-[min_id]-to-[max_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computeQual'], [u'computeSlotQual'], ["Add", "Get", "Remove"]),
    "ComputeConstraintDef": MoMeta("ComputeConstraintDef", "computeConstraintDef", "cons-def-[name]", VersionMeta.Version302a, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], [None]),
    "ComputeDefaults": MoMeta("ComputeDefaults", "computeDefaults", "compute-defaults", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], [u'topRoot'], [u'biosSettings', u'computePlatform'], ["Get"]),
    "ComputeExtBoard": MoMeta("ComputeExtBoard", "computeExtBoard", "ext-board-[id]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'biosUnit', u'computeBoardController', u'computeMbPowerStats', u'computeMbTempStats', u'equipmentHealthLed', u'equipmentLocatorLed', u'faultInst', u'mgmtController', u'powerBudget'], ["Get"]),
    "ComputeFactoryResetOperation": MoMeta("ComputeFactoryResetOperation", "computeFactoryResetOperation", "factory-reset", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], [None]),
    "ComputeFwSyncAck": MoMeta("ComputeFwSyncAck", "computeFwSyncAck", "fwsyncack", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'faultInst', u'trigLocalSched'], ["Get", "Set"]),
    "ComputeHealthLedSensorAlarm": MoMeta("ComputeHealthLedSensorAlarm", "computeHealthLedSensorAlarm", "sensor-alarm-[sensor_id]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentHealthLed'], [], ["Get"]),
    "ComputeIOHub": MoMeta("ComputeIOHub", "computeIOHub", "iohub", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard'], [u'computeIOHubEnvStats', u'faultInst'], ["Get"]),
    "ComputeIOHubEnvStats": MoMeta("ComputeIOHubEnvStats", "computeIOHubEnvStats", "iohub-stats", VersionMeta.Version131c, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeIOHub'], [u'computeIOHubEnvStatsHist'], ["Get"]),
    "ComputeIOHubEnvStatsHist": MoMeta("ComputeIOHubEnvStatsHist", "computeIOHubEnvStatsHist", "[id]", VersionMeta.Version131c, "OutputOnly", 0x1, [], ["read-only"], [u'computeIOHubEnvStats'], [], ["Get"]),
    "ComputeInstanceIdQual": MoMeta("ComputeInstanceIdQual", "computeInstanceIdQual", "inst-from-[min_id]-to-[max_id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computeSlotQual'], [], ["Add", "Get", "Remove"]),
    "ComputeKvmMgmtPolicy": MoMeta("ComputeKvmMgmtPolicy", "computeKvmMgmtPolicy", "kvm-mgmt-policy-[name]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-ext-access", "ls-server", "ls-server-oper", "ls-server-policy"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeMbPowerStats": MoMeta("ComputeMbPowerStats", "computeMbPowerStats", "power-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBoard', u'computeExtBoard'], [u'computeMbPowerStatsHist'], ["Get"]),
    "ComputeMbPowerStatsHist": MoMeta("ComputeMbPowerStatsHist", "computeMbPowerStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'computeMbPowerStats'], [], ["Get"]),
    "ComputeMbTempStats": MoMeta("ComputeMbTempStats", "computeMbTempStats", "temp-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBoard', u'computeExtBoard'], [u'computeMbTempStatsHist'], ["Get"]),
    "ComputeMbTempStatsHist": MoMeta("ComputeMbTempStatsHist", "computeMbTempStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'computeMbTempStats'], [], ["Get"]),
    "ComputeMemoryConfigPolicy": MoMeta("ComputeMemoryConfigPolicy", "computeMemoryConfigPolicy", "memory-config-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-server-policy", "pn-policy"], [u'orgOrg'], [], ["Get", "Set"]),
    "ComputeMemoryConfiguration": MoMeta("ComputeMemoryConfiguration", "computeMemoryConfiguration", "memmory-config", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], ["Get", "Set"]),
    "ComputeMemoryUnitConstraintDef": MoMeta("ComputeMemoryUnitConstraintDef", "computeMemoryUnitConstraintDef", "dc-[name]", VersionMeta.Version102d, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], ["Get"]),
    "ComputePCIeFatalCompletionStats": MoMeta("ComputePCIeFatalCompletionStats", "computePCIeFatalCompletionStats", "pciefat-completion-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBoard'], [], ["Get"]),
    "ComputePCIeFatalProtocolStats": MoMeta("ComputePCIeFatalProtocolStats", "computePCIeFatalProtocolStats", "pciefat-protocol-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBoard'], [], ["Get"]),
    "ComputePCIeFatalReceiveStats": MoMeta("ComputePCIeFatalReceiveStats", "computePCIeFatalReceiveStats", "pciefat-receive-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBoard'], [], ["Get"]),
    "ComputePCIeFatalStats": MoMeta("ComputePCIeFatalStats", "computePCIeFatalStats", "pciefat-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBoard'], [], ["Get"]),
    "ComputePciCap": MoMeta("ComputePciCap", "computePciCap", "pci", VersionMeta.Version111j, "InputOutput", 0x1, [], ["read-only"], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider'], [u'computePciSlotScanDef'], ["Get"]),
    "ComputePciSlotScanDef": MoMeta("ComputePciSlotScanDef", "computePciSlotScanDef", "slot-[slot_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'computePciCap'], [], [None]),
    "ComputePhysicalAssocCtx": MoMeta("ComputePhysicalAssocCtx", "computePhysicalAssocCtx", "pn-assoc-ctx", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'lsServerAssocCtx'], [], ["Get"]),
    "ComputePhysicalFsm": MoMeta("ComputePhysicalFsm", "computePhysicalFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'computePhysicalFsmStage'], [None]),
    "ComputePhysicalFsmStage": MoMeta("ComputePhysicalFsmStage", "computePhysicalFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'computePhysicalFsm'], [], [None]),
    "ComputePhysicalFsmTask": MoMeta("ComputePhysicalFsmTask", "computePhysicalFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], [None]),
    "ComputePhysicalQual": MoMeta("ComputePhysicalQual", "computePhysicalQual", "physical", VersionMeta.Version131c, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputePlatform": MoMeta("ComputePlatform", "computePlatform", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], [u'computeDefaults'], [u'biosSettings'], ["Get"]),
    "ComputePnuOSImage": MoMeta("ComputePnuOSImage", "computePnuOSImage", "pnuos", VersionMeta.Version202m, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], ["Get"]),
    "ComputePool": MoMeta("ComputePool", "computePool", "compute-pool-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [u'computePooledEnclosureComputeSlot', u'computePooledRackUnit', u'computePooledSlot', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "ComputePoolPolicyRef": MoMeta("ComputePoolPolicyRef", "computePoolPolicyRef", "poolref-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'computePoolable'], [], ["Get"]),
    "ComputePoolable": MoMeta("ComputePoolable", "computePoolable", "pool-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'computePoolPolicyRef'], ["Get"]),
    "ComputePooledEnclosureComputeSlot": MoMeta("ComputePooledEnclosureComputeSlot", "computePooledEnclosureComputeSlot", "server-[chassis_id]-[slot_id]-[server_instance_id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computePool'], [], ["Add", "Get", "Remove"]),
    "ComputePooledRackUnit": MoMeta("ComputePooledRackUnit", "computePooledRackUnit", "rack-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computePool'], [], ["Add", "Get", "Remove"]),
    "ComputePooledSlot": MoMeta("ComputePooledSlot", "computePooledSlot", "blade-[chassis_id]-[slot_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computePool'], [], ["Add", "Get", "Remove"]),
    "ComputePoolingPolicy": MoMeta("ComputePoolingPolicy", "computePoolingPolicy", "pooling-policy-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputePowerSyncDef": MoMeta("ComputePowerSyncDef", "computePowerSyncDef", "power-sync-def", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server", "ls-server-policy"], [u'lsServer'], [], [None]),
    "ComputePowerSyncPolicy": MoMeta("ComputePowerSyncPolicy", "computePowerSyncPolicy", "power-sync-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server", "ls-server-policy"], [u'orgOrg'], [], [None]),
    "ComputePsuControl": MoMeta("ComputePsuControl", "computePsuControl", "psu-contr", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'equipmentChassis'], [], ["Get"]),
    "ComputePsuPolicy": MoMeta("ComputePsuPolicy", "computePsuPolicy", "psu-policy", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], [u'orgOrg'], [], ["Get", "Set"]),
    "ComputeQual": MoMeta("ComputeQual", "computeQual", "blade-qualifier-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [u'adaptorQual', u'computeChassisQual', u'computePhysicalQual', u'computeRackQual', u'memoryQual', u'powerGroupQual', u'processorQual', u'storageQual'], ["Add", "Get", "Remove", "Set"]),
    "ComputeRackQual": MoMeta("ComputeRackQual", "computeRackQual", "rack-from-[min_id]-to-[max_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computeQual'], [], ["Add", "Get", "Remove"]),
    "ComputeRackUnit": MoMeta("ComputeRackUnit", "computeRackUnit", "rack-unit-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'topSystem'], [u'aaaEpAuthProfile', u'aaaEpUser', u'adaptorHostIfConfig', u'adaptorUnit', u'biosUnit', u'biosVIdentityParams', u'cimcvmediaMountConfigDef', u'computeBoard', u'computeBoardController', u'computeExtBoard', u'computeFactoryResetOperation', u'computeFwSyncAck', u'computeKvmMgmtPolicy', u'computeMemoryConfiguration', u'computePhysicalFsm', u'computePhysicalFsmTask', u'computePnuOSImage', u'computePoolable', u'computeRackUnitFsm', u'computeRackUnitFsmTask', u'computeScrubPolicy', u'diagSrvCtrl', u'equipmentBeaconLed', u'equipmentFanModule', u'equipmentHealthLed', u'equipmentIOExpander', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'equipmentPOST', u'equipmentPsu', u'eventInst', u'fabricLocale', u'faultInst', u'faultSuppressTask', u'firmwareImageLock', u'firmwareStatus', u'lsIdentityInfo', u'lsbootDef', u'mgmtController', u'osAgent', u'osInstance', u'pciEquipSlot', u'pciUnit', u'powerBudget', u'solIf', u'storageEnclosure', u'storageVirtualDriveContainer'], ["Get", "Set"]),
    "ComputeRackUnitFsm": MoMeta("ComputeRackUnitFsm", "computeRackUnitFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'computeRackUnit'], [u'computeRackUnitFsmStage'], [None]),
    "ComputeRackUnitFsmStage": MoMeta("ComputeRackUnitFsmStage", "computeRackUnitFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'computeRackUnitFsm'], [], [None]),
    "ComputeRackUnitFsmTask": MoMeta("ComputeRackUnitFsmTask", "computeRackUnitFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], [u'computeRackUnit'], [], [None]),
    "ComputeRackUnitMbTempStats": MoMeta("ComputeRackUnitMbTempStats", "computeRackUnitMbTempStats", "temp-stats", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBoard'], [u'computeRackUnitMbTempStatsHist'], ["Get"]),
    "ComputeRackUnitMbTempStatsHist": MoMeta("ComputeRackUnitMbTempStatsHist", "computeRackUnitMbTempStatsHist", "[id]", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["read-only"], [u'computeRackUnitMbTempStats'], [], ["Get"]),
    "ComputeRtcBattery": MoMeta("ComputeRtcBattery", "computeRtcBattery", "rtc-battery", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard'], [u'faultInst'], ["Get"]),
    "ComputeScrubPolicy": MoMeta("ComputeScrubPolicy", "computeScrubPolicy", "scrub-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeServerDiscPolicy": MoMeta("ComputeServerDiscPolicy", "computeServerDiscPolicy", "server-discovery", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [u'computeServerDiscPolicyFsm', u'computeServerDiscPolicyFsmTask', u'eventInst', u'faultInst'], ["Get", "Set"]),
    "ComputeServerDiscPolicyFsm": MoMeta("ComputeServerDiscPolicyFsm", "computeServerDiscPolicyFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'computeServerDiscPolicy'], [u'computeServerDiscPolicyFsmStage'], [None]),
    "ComputeServerDiscPolicyFsmStage": MoMeta("ComputeServerDiscPolicyFsmStage", "computeServerDiscPolicyFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'computeServerDiscPolicyFsm'], [], [None]),
    "ComputeServerDiscPolicyFsmTask": MoMeta("ComputeServerDiscPolicyFsmTask", "computeServerDiscPolicyFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'computeServerDiscPolicy'], [], [None]),
    "ComputeServerMgmtPolicy": MoMeta("ComputeServerMgmtPolicy", "computeServerMgmtPolicy", "server-mgmt-policy", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [], ["Get", "Set"]),
    "ComputeServerTypeCap": MoMeta("ComputeServerTypeCap", "computeServerTypeCap", "server-type", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], [None]),
    "ComputeServerUnit": MoMeta("ComputeServerUnit", "computeServerUnit", "server-[server_instance_id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeCartridge'], [u'aaaEpAuthProfile', u'aaaEpUser', u'adaptorHostIfConfig', u'adaptorUnit', u'biosUnit', u'biosVIdentityParams', u'cimcvmediaMountConfigDef', u'computeBoard', u'computeBoardController', u'computeExtBoard', u'computeFactoryResetOperation', u'computeFwSyncAck', u'computeKvmMgmtPolicy', u'computeMemoryConfiguration', u'computePhysicalFsm', u'computePhysicalFsmTask', u'computePnuOSImage', u'computePoolable', u'computeScrubPolicy', u'computeServerUnitFsm', u'computeServerUnitFsmTask', u'diagSrvCtrl', u'equipmentBeaconLed', u'equipmentHealthLed', u'equipmentIOExpander', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'equipmentPOST', u'eventInst', u'fabricLocale', u'faultInst', u'faultSuppressTask', u'firmwareImageLock', u'firmwareStatus', u'lsIdentityInfo', u'lsbootDef', u'mgmtController', u'osAgent', u'osInstance', u'pciEquipSlot', u'pciUnit', u'powerBudget', u'solIf', u'storageEnclosure', u'storageVirtualDriveContainer'], ["Get", "Set"]),
    "ComputeServerUnitFsm": MoMeta("ComputeServerUnitFsm", "computeServerUnitFsm", "fsm", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], [u'computeServerUnit'], [u'computeServerUnitFsmStage'], [None]),
    "ComputeServerUnitFsmStage": MoMeta("ComputeServerUnitFsmStage", "computeServerUnitFsmStage", "stage-[name]", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], [u'computeServerUnitFsm'], [], [None]),
    "ComputeServerUnitFsmTask": MoMeta("ComputeServerUnitFsmTask", "computeServerUnitFsmTask", "task-[item]", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], [u'computeServerUnit'], [], [None]),
    "ComputeSlotQual": MoMeta("ComputeSlotQual", "computeSlotQual", "slot-from-[min_id]-to-[max_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computeChassisQual'], [u'computeInstanceIdQual'], ["Add", "Get", "Remove"]),
    "ConfigImpact": MoMeta("ConfigImpact", "configImpact", "impact-[name]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [u'configManagedEpImpactResponse'], [], [None]),
    "ConfigManagedEpImpactResponse": MoMeta("ConfigManagedEpImpactResponse", "configManagedEpImpactResponse", "ManagedEpapp-id-[app_connector_id]src-id-[source_connector_id]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [], [u'configImpact'], [None]),
    "ConfigSorter": MoMeta("ConfigSorter", "configSorter", "class-[sort_class]prop-[sort_prop]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ControllerHaController": MoMeta("ControllerHaController", "controllerHaController", "HaController", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'controllerOperationalVersionHolder', u'controllerPreferedVersionHolder'], [None]),
    "ControllerOperationalVersionHolder": MoMeta("ControllerOperationalVersionHolder", "controllerOperationalVersionHolder", "OpVersHolder-[serial]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'controllerHaController'], [], [None]),
    "ControllerPreferedVersionHolder": MoMeta("ControllerPreferedVersionHolder", "controllerPreferedVersionHolder", "PrefVersHolder-[serial]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin"], [u'controllerHaController'], [], [None]),
    "CpmaintAck": MoMeta("CpmaintAck", "cpmaintAck", "ack", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassisProfile'], [u'faultInst', u'trigLocalSched'], [None]),
    "CpmaintMaintPolicy": MoMeta("CpmaintMaintPolicy", "cpmaintMaintPolicy", "chassis-profile-maint-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'orgOrg'], [], [None]),
    "DcxFcoeVifEp": MoMeta("DcxFcoeVifEp", "dcxFcoeVifEp", "fcoevif-[id]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], [u'swFcoeEstcEp', u'swFcoeSanEp', u'swFcoeSanPc'], [u'swVsan'], ["Get"]),
    "DcxNs": MoMeta("DcxNs", "dcxNs", "dcxns-[switch_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'adaptorUnit'], [u'faultInst'], ["Get"]),
    "DcxUniverse": MoMeta("DcxUniverse", "dcxUniverse", "dcxns", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'fabricEp'], [u'dcxVifEp'], ["Get"]),
    "DcxVIf": MoMeta("DcxVIf", "dcxVIf", "vif-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'adaptorExtEthIf', u'adaptorFcOEIf', u'adaptorHostEthIf', u'adaptorHostFcIf', u'adaptorHostServiceEthIf'], [u'faultInst'], ["Get"]),
    "DcxVc": MoMeta("DcxVc", "dcxVc", "vc-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'fabricLocale', u'fabricPath', u'swEthLanFlowMon', u'swEthMon', u'swFcMon'], [u'faultInst', u'swCmclan', u'swNetflowMonitorRef', u'swUlan', u'swVlan', u'swVsan'], ["Get"]),
    "DcxVifEp": MoMeta("DcxVifEp", "dcxVifEp", "vif-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'dcxUniverse', u'swFcoeEstcEp', u'swFcoeSanEp', u'swFcoeSanPc'], [u'swVsan'], ["Get"]),
    "DhcpAcquired": MoMeta("DhcpAcquired", "dhcpAcquired", "lease", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'adaptorHostEthIf', u'mgmtIf'], [], ["Get"]),
    "DhcpInst": MoMeta("DhcpInst", "dhcpInst", "dhcp", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'dhcpLease'], ["Get"]),
    "DhcpLease": MoMeta("DhcpLease", "dhcpLease", "lease-[ip]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'dhcpInst'], [], ["Get"]),
    "DiagBladeTest": MoMeta("DiagBladeTest", "diagBladeTest", "blade-test-[order]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'diagRunPolicy'], [], ["Get"]),
    "DiagNetworkTest": MoMeta("DiagNetworkTest", "diagNetworkTest", "network-test-[order]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'diagRunPolicy'], [], ["Get"]),
    "DiagRslt": MoMeta("DiagRslt", "diagRslt", "rslt-[id]", VersionMeta.Version111j, "InputOutput", 0x1, [], [""], [u'diagSrvCtrl'], [], ["Get"]),
    "DiagRunPolicy": MoMeta("DiagRunPolicy", "diagRunPolicy", "diag-policy-[name]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'diagSrvCtrl', u'orgOrg'], [u'diagBladeTest', u'diagNetworkTest'], ["Get"]),
    "DiagSrvCapProvider": MoMeta("DiagSrvCapProvider", "diagSrvCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111j, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArray', u'equipmentSlotArrayRef', u'equipmentStorageControllerConfig', u'firmwareConstraints', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "DiagSrvCtrl": MoMeta("DiagSrvCtrl", "diagSrvCtrl", "diag", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'diagRslt', u'diagRunPolicy', u'etherServerIntFIo'], ["Get"]),
    "DomainEnvironmentFeature": MoMeta("DomainEnvironmentFeature", "domainEnvironmentFeature", "env-feature-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [u'domainEnvironmentFeatureCont', u'domainNetworkFeatureCont', u'domainServerFeatureCont', u'domainStorageFeatureCont'], [u'domainEnvironmentParam', u'domainNetworkParam', u'domainServerParam', u'domainStorageParam'], [None]),
    "DomainEnvironmentFeatureCont": MoMeta("DomainEnvironmentFeatureCont", "domainEnvironmentFeatureCont", "env-feature-cont", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'domainEnvironmentFeature', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature'], [None]),
    "DomainEnvironmentParam": MoMeta("DomainEnvironmentParam", "domainEnvironmentParam", "env-param-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [u'domainEnvironmentFeature', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature'], [], [None]),
    "DomainNetworkFeature": MoMeta("DomainNetworkFeature", "domainNetworkFeature", "network-feature-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [u'domainEnvironmentFeatureCont', u'domainNetworkFeatureCont', u'domainServerFeatureCont', u'domainStorageFeatureCont'], [u'domainEnvironmentParam', u'domainNetworkParam', u'domainServerParam', u'domainStorageParam'], [None]),
    "DomainNetworkFeatureCont": MoMeta("DomainNetworkFeatureCont", "domainNetworkFeatureCont", "network-feature-cont", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'domainEnvironmentFeature', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature'], [None]),
    "DomainNetworkParam": MoMeta("DomainNetworkParam", "domainNetworkParam", "network-param-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [u'domainEnvironmentFeature', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature'], [], [None]),
    "DomainServerFeature": MoMeta("DomainServerFeature", "domainServerFeature", "server-feature-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [u'domainEnvironmentFeatureCont', u'domainNetworkFeatureCont', u'domainServerFeatureCont', u'domainStorageFeatureCont'], [u'domainEnvironmentParam', u'domainNetworkParam', u'domainServerParam', u'domainStorageParam'], [None]),
    "DomainServerFeatureCont": MoMeta("DomainServerFeatureCont", "domainServerFeatureCont", "server-feature-cont", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'domainEnvironmentFeature', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature'], [None]),
    "DomainServerParam": MoMeta("DomainServerParam", "domainServerParam", "server-param-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [u'domainEnvironmentFeature', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature'], [], [None]),
    "DomainStorageFeature": MoMeta("DomainStorageFeature", "domainStorageFeature", "storage-feature-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [u'domainEnvironmentFeatureCont', u'domainNetworkFeatureCont', u'domainServerFeatureCont', u'domainStorageFeatureCont'], [u'domainEnvironmentParam', u'domainNetworkParam', u'domainServerParam', u'domainStorageParam'], [None]),
    "DomainStorageFeatureCont": MoMeta("DomainStorageFeatureCont", "domainStorageFeatureCont", "storage-feature-cont", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'domainEnvironmentFeature', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature'], [None]),
    "DomainStorageParam": MoMeta("DomainStorageParam", "domainStorageParam", "storage-param-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [u'domainEnvironmentFeature', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature'], [], [None]),
    "DpsecMac": MoMeta("DpsecMac", "dpsecMac", "mac-sec", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'nwctrlDefinition'], [], ["Add", "Get", "Remove", "Set"]),
    "DupeScope": MoMeta("DupeScope", "dupeScope", "scope-[id]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
    "DupeScopeResult": MoMeta("DupeScopeResult", "dupeScopeResult", "result", VersionMeta.Version302a, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
    "EpqosDefinition": MoMeta("EpqosDefinition", "epqosDefinition", "ep-qos-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy", "read-only"], [u'orgOrg'], [u'epqosDefinitionFsm', u'epqosDefinitionFsmTask', u'epqosEgress', u'eventInst', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "EpqosDefinitionDelTask": MoMeta("EpqosDefinitionDelTask", "epqosDefinitionDelTask", "ep-qos-deletion-[def_int_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy", "read-only"], [u'orgOrg'], [u'epqosDefinitionDelTaskFsm', u'epqosDefinitionDelTaskFsmTask', u'eventInst', u'faultInst'], [None]),
    "EpqosDefinitionDelTaskFsm": MoMeta("EpqosDefinitionDelTaskFsm", "epqosDefinitionDelTaskFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'epqosDefinitionDelTask'], [u'epqosDefinitionDelTaskFsmStage'], [None]),
    "EpqosDefinitionDelTaskFsmStage": MoMeta("EpqosDefinitionDelTaskFsmStage", "epqosDefinitionDelTaskFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'epqosDefinitionDelTaskFsm'], [], [None]),
    "EpqosDefinitionDelTaskFsmTask": MoMeta("EpqosDefinitionDelTaskFsmTask", "epqosDefinitionDelTaskFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'epqosDefinitionDelTask'], [], [None]),
    "EpqosDefinitionFsm": MoMeta("EpqosDefinitionFsm", "epqosDefinitionFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'epqosDefinition'], [u'epqosDefinitionFsmStage'], [None]),
    "EpqosDefinitionFsmStage": MoMeta("EpqosDefinitionFsmStage", "epqosDefinitionFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'epqosDefinitionFsm'], [], [None]),
    "EpqosDefinitionFsmTask": MoMeta("EpqosDefinitionFsmTask", "epqosDefinitionFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'epqosDefinition'], [], [None]),
    "EpqosEgress": MoMeta("EpqosEgress", "epqosEgress", "egress", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy", "read-only"], [u'epqosDefinition'], [], ["Add", "Get", "Remove", "Set"]),
    "EquipmentAdaptorConnDef": MoMeta("EquipmentAdaptorConnDef", "equipmentAdaptorConnDef", "adaptor-port-[adaptor_ep]-iom-port-[iom_ep]", VersionMeta.Version202m, "InputOutput", 0x1, [], [""], [u'equipmentBladeIOMConnDef', u'equipmentBladeSwitchConnDef'], [], ["Get"]),
    "EquipmentAdaptorDef": MoMeta("EquipmentAdaptorDef", "equipmentAdaptorDef", "adaptor", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'adaptorFruCapProvider'], [], ["Get"]),
    "EquipmentAdvancedBootOrder": MoMeta("EquipmentAdvancedBootOrder", "equipmentAdvancedBootOrder", "advbootordsupp-[is_supported]", VersionMeta.Version221b, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentAutoconfigPolicy": MoMeta("EquipmentAutoconfigPolicy", "equipmentAutoconfigPolicy", "chassis-autoconfig-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [u'faultInst'], [None]),
    "EquipmentBaseBoardCapProvider": MoMeta("EquipmentBaseBoardCapProvider", "equipmentBaseBoardCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentBeaconCapProvider": MoMeta("EquipmentBeaconCapProvider", "equipmentBeaconCapProvider", "beacon-cap", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], [u'equipmentGemCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider'], [], ["Get"]),
    "EquipmentBeaconLed": MoMeta("EquipmentBeaconLed", "equipmentBeaconLed", "beacon", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'equipmentFanModule', u'equipmentFex', u'equipmentIOCard', u'equipmentPsu', u'equipmentSwitchCard'], [u'equipmentBeaconLedFsm', u'equipmentBeaconLedFsmTask', u'eventInst', u'faultInst'], ["Get"]),
    "EquipmentBeaconLedFsm": MoMeta("EquipmentBeaconLedFsm", "equipmentBeaconLedFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'equipmentBeaconLed'], [u'equipmentBeaconLedFsmStage'], [None]),
    "EquipmentBeaconLedFsmStage": MoMeta("EquipmentBeaconLedFsmStage", "equipmentBeaconLedFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'equipmentBeaconLedFsm'], [], [None]),
    "EquipmentBeaconLedFsmTask": MoMeta("EquipmentBeaconLedFsmTask", "equipmentBeaconLedFsmTask", "task-[item]", VersionMeta.Version201m, "OutputOnly", 0x1, [], [""], [u'equipmentBeaconLed'], [], [None]),
    "EquipmentBinding": MoMeta("EquipmentBinding", "equipmentBinding", "chassis", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], [u'equipmentChassisProfile'], [], [None]),
    "EquipmentBiosDef": MoMeta("EquipmentBiosDef", "equipmentBiosDef", "bios-def", VersionMeta.Version202m, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentBladeAGLibrary": MoMeta("EquipmentBladeAGLibrary", "equipmentBladeAGLibrary", "library-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentBladeAggregationCapRef": MoMeta("EquipmentBladeAggregationCapRef", "equipmentBladeAggregationCapRef", "blade-aggr", VersionMeta.Version222c, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider'], [u'equipmentPhysDevicesPerBoard'], ["Get"]),
    "EquipmentBladeBiosCapProvider": MoMeta("EquipmentBladeBiosCapProvider", "equipmentBladeBiosCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'biosRef', u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentBladeCapProvider": MoMeta("EquipmentBladeCapProvider", "equipmentBladeCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'adaptorFruCapRef', u'computeConstraintDef', u'computeMemoryUnitConstraintDef', u'computePciCap', u'computeServerTypeCap', u'equipmentAdvancedBootOrder', u'equipmentBiosDef', u'equipmentBladeAGLibrary', u'equipmentBladeAggregationCapRef', u'equipmentBladeCapProviderTypeDef', u'equipmentBladeConnDef', u'equipmentBoardControllerDef', u'equipmentBootDeviceConstraints', u'equipmentCimcVmedia', u'equipmentCiscoOsOpenGate', u'equipmentDimmMapping', u'equipmentDiscoveryCap', u'equipmentGraphicsCardCapRef', u'equipmentHDDFaultMonDef', u'equipmentHwRevisionModifier', u'equipmentInbandMgmtCap', u'equipmentKvmMgmtCap', u'equipmentLocalDiskControllerCapRef', u'equipmentManufacturingDef', u'equipmentPciSlotIdMapping', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentPowerCapDef', u'equipmentSecureBoot', u'equipmentServerCorrectUuidBehavior', u'equipmentServerFeatureCap', u'equipmentServiceDef', u'equipmentSlotArray', u'equipmentSlotArrayRef', u'equipmentStorageControllerConfig', u'equipmentStorageControllerSlotDef', u'equipmentUuidFeatureCap', u'firmwareConstraints', u'firmwareType', u'firmwareUpgradeConstraint', u'storageHwRevisionModifier'], ["Get"]),
    "EquipmentBladeCapProviderTypeDef": MoMeta("EquipmentBladeCapProviderTypeDef", "equipmentBladeCapProviderTypeDef", "blade-provider-type", VersionMeta.Version224a, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider'], [], ["Get"]),
    "EquipmentBladeConnDef": MoMeta("EquipmentBladeConnDef", "equipmentBladeConnDef", "adaptor-type-[adaptor_type]-family-[adaptor_family]-slot-[adaptor_slot_number]", VersionMeta.Version202m, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentServerUnitCapProvider'], [u'equipmentBladeIOMConnDef', u'equipmentBladeSwitchConnDef'], ["Get"]),
    "EquipmentBladeIOMConnDef": MoMeta("EquipmentBladeIOMConnDef", "equipmentBladeIOMConnDef", "-iom-type-[iocard_type]", VersionMeta.Version203a, "InputOutput", 0x1, [], [""], [u'equipmentBladeConnDef'], [u'equipmentAdaptorConnDef'], ["Get"]),
    "EquipmentBladeSwitchConnDef": MoMeta("EquipmentBladeSwitchConnDef", "equipmentBladeSwitchConnDef", "-switch-type-[switch_type]", VersionMeta.Version302a, "InputOutput", 0x1, [], [""], [u'equipmentBladeConnDef'], [u'equipmentAdaptorConnDef'], [None]),
    "EquipmentBoardControllerDef": MoMeta("EquipmentBoardControllerDef", "equipmentBoardControllerDef", "board-controller", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider'], [u'equipmentDowngradeConstraint', u'equipmentFirmwareConstraint', u'equipmentVersionConstraint'], ["Get"]),
    "EquipmentBootDeviceConstraints": MoMeta("EquipmentBootDeviceConstraints", "equipmentBootDeviceConstraints", "bootdevconstr-[boot_dev_type]", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentBreakoutCap": MoMeta("EquipmentBreakoutCap", "equipmentBreakoutCap", "breakout-cap", VersionMeta.Version311e, "InputOutput", 0x1, [], [""], [u'equipmentSwitchCapProvider'], [], [None]),
    "EquipmentCapModSpec": MoMeta("EquipmentCapModSpec", "equipmentCapModSpec", "modspec-[path]", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], [u'equipmentHwCapDerivativeProvider'], [], [None]),
    "EquipmentCatalogCapProvider": MoMeta("EquipmentCatalogCapProvider", "equipmentCatalogCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArray', u'equipmentSlotArrayRef', u'equipmentStorageControllerConfig', u'firmwareConstraints', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentChassis": MoMeta("EquipmentChassis", "equipmentChassis", "chassis-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'topSystem'], [u'computeBlade', u'computeBoardController', u'computeCartridge', u'computePsuControl', u'equipmentBeaconLed', u'equipmentChassisFsm', u'equipmentChassisFsmTask', u'equipmentChassisStats', u'equipmentFanModule', u'equipmentHealthLed', u'equipmentIOCard', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'equipmentPoolable', u'equipmentPsu', u'equipmentSharedIOModule', u'equipmentSwitchIOCard', u'equipmentSystemIOController', u'eventInst', u'fabricLocale', u'faultInst', u'faultSuppressTask', u'firmwareActivity', u'firmwareImageLock', u'firmwareStatus', u'mgmtController', u'powerBudget', u'sesEnclosure', u'storageController', u'storageEnclosure', u'storageSasExpander', u'storageVirtualDriveContainer', u'vnicRackServerDiscoveryProfile'], ["Get", "Set"]),
    "EquipmentChassisAssocCtx": MoMeta("EquipmentChassisAssocCtx", "equipmentChassisAssocCtx", "cp-assoc-ctx", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'equipmentChassisProfileAssocCtx'], [], [None]),
    "EquipmentChassisCapProvider": MoMeta("EquipmentChassisCapProvider", "equipmentChassisCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentPowerCapDef', u'equipmentServiceDef', u'equipmentSlotArray', u'equipmentSlotArrayRef', u'equipmentStorageControllerConfig', u'firmwareConstraints', u'firmwareType', u'firmwareUpgradeConstraint', u'storageEnclosureCap', u'storageSasLinkDescriptor', u'storageSasPortDescriptor'], ["Get"]),
    "EquipmentChassisFsm": MoMeta("EquipmentChassisFsm", "equipmentChassisFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'equipmentChassis'], [u'equipmentChassisFsmStage'], [None]),
    "EquipmentChassisFsmStage": MoMeta("EquipmentChassisFsmStage", "equipmentChassisFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'equipmentChassisFsm'], [], [None]),
    "EquipmentChassisFsmTask": MoMeta("EquipmentChassisFsmTask", "equipmentChassisFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'equipmentChassis'], [], [None]),
    "EquipmentChassisInheritPolicy": MoMeta("EquipmentChassisInheritPolicy", "equipmentChassisInheritPolicy", "chassis-inherit-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [u'faultInst'], [None]),
    "EquipmentChassisIssues": MoMeta("EquipmentChassisIssues", "equipmentChassisIssues", "config-issue", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassisProfile'], [u'faultInst'], [None]),
    "EquipmentChassisProfile": MoMeta("EquipmentChassisProfile", "equipmentChassisProfile", "cp-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentTier', u'orgOrg'], [u'cpmaintAck', u'equipmentBinding', u'equipmentChassisIssues', u'equipmentChassisProfileAssocCtx', u'equipmentChassisProfileFsm', u'equipmentChassisProfileFsmTask', u'equipmentRequirement', u'eventInst', u'faultInst', u'lstorageDiskZoningConfigDef'], [None]),
    "EquipmentChassisProfileAssocCtx": MoMeta("EquipmentChassisProfileAssocCtx", "equipmentChassisProfileAssocCtx", "cp-assoc-ctx", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'equipmentChassisProfile'], [u'equipmentChassisAssocCtx'], [None]),
    "EquipmentChassisProfileFsm": MoMeta("EquipmentChassisProfileFsm", "equipmentChassisProfileFsm", "fsm", VersionMeta.Version911z, "OutputOnly", 0x1, [], [""], [u'equipmentChassisProfile'], [u'equipmentChassisProfileFsmStage'], [None]),
    "EquipmentChassisProfileFsmStage": MoMeta("EquipmentChassisProfileFsmStage", "equipmentChassisProfileFsmStage", "stage-[name]", VersionMeta.Version911z, "OutputOnly", 0x1, [], [""], [u'equipmentChassisProfileFsm'], [], [None]),
    "EquipmentChassisProfileFsmTask": MoMeta("EquipmentChassisProfileFsmTask", "equipmentChassisProfileFsmTask", "task-[item]", VersionMeta.Version911z, "OutputOnly", 0x1, [], [""], [u'equipmentChassisProfile'], [], [None]),
    "EquipmentChassisQual": MoMeta("EquipmentChassisQual", "equipmentChassisQual", "chassis-from-[min_id]-to-[max_id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'equipmentQual'], [], [None]),
    "EquipmentChassisStats": MoMeta("EquipmentChassisStats", "equipmentChassisStats", "stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentChassis'], [u'equipmentChassisStatsHist'], ["Get"]),
    "EquipmentChassisStatsHist": MoMeta("EquipmentChassisStatsHist", "equipmentChassisStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentChassisStats'], [], ["Get"]),
    "EquipmentCimcVmedia": MoMeta("EquipmentCimcVmedia", "equipmentCimcVmedia", "cimcvmediasupp-[is_supported]", VersionMeta.Version222c, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentCiscoOsOpenGate": MoMeta("EquipmentCiscoOsOpenGate", "equipmentCiscoOsOpenGate", "ciscoosopengate-[is_supported]", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentDbgPluginCapProvider": MoMeta("EquipmentDbgPluginCapProvider", "equipmentDbgPluginCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArray', u'equipmentSlotArrayRef', u'equipmentStorageControllerConfig', u'firmwareConstraints', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentDimmEntry": MoMeta("EquipmentDimmEntry", "equipmentDimmEntry", "dimm-entry[id]", VersionMeta.Version202m, "InputOutput", 0x1, [], [""], [u'equipmentDimmMapping'], [], ["Get"]),
    "EquipmentDimmMapping": MoMeta("EquipmentDimmMapping", "equipmentDimmMapping", "dimm-mapping", VersionMeta.Version202m, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider'], [u'equipmentDimmEntry'], ["Get"]),
    "EquipmentDiscoveryCap": MoMeta("EquipmentDiscoveryCap", "equipmentDiscoveryCap", "disccap", VersionMeta.Version142b, "InputOutput", 0x1, [], ["read-only"], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentDowngradeConstraint": MoMeta("EquipmentDowngradeConstraint", "equipmentDowngradeConstraint", "fw-dngrd-constr", VersionMeta.Version213a, "InputOutput", 0x1, [], [""], [u'equipmentBoardControllerDef'], [], ["Get"]),
    "EquipmentEmbeddedStorageDef": MoMeta("EquipmentEmbeddedStorageDef", "equipmentEmbeddedStorageDef", "embedded-storage", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'equipmentLocalDiskControllerCapProvider'], [], [None]),
    "EquipmentFan": MoMeta("EquipmentFan", "equipmentFan", "fan-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'equipmentFanModule', u'equipmentFex', u'networkElement'], [u'equipmentFanStats', u'equipmentNetworkElementFanStats', u'equipmentRackUnitFanStats', u'faultInst'], ["Get"]),
    "EquipmentFanModule": MoMeta("EquipmentFanModule", "equipmentFanModule", "fan-module-[tray]-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'computeRackUnit', u'equipmentChassis', u'networkElement'], [u'equipmentBeaconLed', u'equipmentFan', u'equipmentFanModuleStats', u'equipmentHealthLed', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'faultInst'], ["Get"]),
    "EquipmentFanModuleCapProvider": MoMeta("EquipmentFanModuleCapProvider", "equipmentFanModuleCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentFanModuleDef', u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentFanModuleDef": MoMeta("EquipmentFanModuleDef", "equipmentFanModuleDef", "fanmod", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], [u'equipmentFanModuleCapProvider'], [], ["Get"]),
    "EquipmentFanModuleStats": MoMeta("EquipmentFanModuleStats", "equipmentFanModuleStats", "stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentFanModule'], [u'equipmentFanModuleStatsHist'], ["Get"]),
    "EquipmentFanModuleStatsHist": MoMeta("EquipmentFanModuleStatsHist", "equipmentFanModuleStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentFanModuleStats'], [], ["Get"]),
    "EquipmentFanStats": MoMeta("EquipmentFanStats", "equipmentFanStats", "stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentFan'], [u'equipmentFanStatsHist'], ["Get"]),
    "EquipmentFanStatsHist": MoMeta("EquipmentFanStatsHist", "equipmentFanStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentFanStats'], [], ["Get"]),
    "EquipmentFex": MoMeta("EquipmentFex", "equipmentFex", "fex-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], [u'topSystem'], [u'equipmentBeaconLed', u'equipmentFan', u'equipmentFexEnvStats', u'equipmentFexFsm', u'equipmentFexFsmTask', u'equipmentFexPowerSummary', u'equipmentFexSystemStats', u'equipmentHealthLed', u'equipmentIOCard', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'equipmentPOST', u'equipmentPsu', u'eventInst', u'fabricLocale', u'faultInst', u'faultSuppressTask', u'mgmtController', u'powerBudget'], ["Get", "Set"]),
    "EquipmentFexCapProvider": MoMeta("EquipmentFexCapProvider", "equipmentFexCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentPortGroupAggregationDef', u'equipmentPortGroupDef', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentFexEnvStats": MoMeta("EquipmentFexEnvStats", "equipmentFexEnvStats", "env-stats", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentFex'], [u'equipmentFexEnvStatsHist'], ["Get"]),
    "EquipmentFexEnvStatsHist": MoMeta("EquipmentFexEnvStatsHist", "equipmentFexEnvStatsHist", "[id]", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentFexEnvStats'], [], ["Get"]),
    "EquipmentFexFsm": MoMeta("EquipmentFexFsm", "equipmentFexFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'equipmentFex'], [u'equipmentFexFsmStage'], [None]),
    "EquipmentFexFsmStage": MoMeta("EquipmentFexFsmStage", "equipmentFexFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'equipmentFexFsm'], [], [None]),
    "EquipmentFexFsmTask": MoMeta("EquipmentFexFsmTask", "equipmentFexFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], [u'equipmentFex'], [], [None]),
    "EquipmentFexPowerSummary": MoMeta("EquipmentFexPowerSummary", "equipmentFexPowerSummary", "power-summary", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentFex'], [u'equipmentFexPowerSummaryHist'], ["Get"]),
    "EquipmentFexPowerSummaryHist": MoMeta("EquipmentFexPowerSummaryHist", "equipmentFexPowerSummaryHist", "[id]", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentFexPowerSummary'], [], ["Get"]),
    "EquipmentFexPsuInputStats": MoMeta("EquipmentFexPsuInputStats", "equipmentFexPsuInputStats", "fex-psu-input-stats", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentPsu'], [u'equipmentFexPsuInputStatsHist'], ["Get"]),
    "EquipmentFexPsuInputStatsHist": MoMeta("EquipmentFexPsuInputStatsHist", "equipmentFexPsuInputStatsHist", "[id]", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentFexPsuInputStats'], [], ["Get"]),
    "EquipmentFexSystemStats": MoMeta("EquipmentFexSystemStats", "equipmentFexSystemStats", "sys-stats", VersionMeta.Version311e, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentFex'], [u'equipmentFexSystemStatsHist'], [None]),
    "EquipmentFexSystemStatsHist": MoMeta("EquipmentFexSystemStatsHist", "equipmentFexSystemStatsHist", "[id]", VersionMeta.Version311e, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentFexSystemStats'], [], [None]),
    "EquipmentFirmwareConstraint": MoMeta("EquipmentFirmwareConstraint", "equipmentFirmwareConstraint", "fw-constr", VersionMeta.Version212a, "InputOutput", 0x1, [], [""], [u'equipmentBoardControllerDef'], [], ["Get"]),
    "EquipmentFlashLife": MoMeta("EquipmentFlashLife", "equipmentFlashLife", "[suport_type][card_param_type]", VersionMeta.Version222c, "InputOutput", 0x1, [], [""], [u'equipmentLocalDiskControllerCapProvider'], [], ["Get"]),
    "EquipmentGemCapProvider": MoMeta("EquipmentGemCapProvider", "equipmentGemCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentBeaconCapProvider', u'equipmentGemPortCap', u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServerPortCapProvider', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'equipmentUnifiedPortCapProvider', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentGemPortCap": MoMeta("EquipmentGemPortCap", "equipmentGemPortCap", "gem-port-cap-[port_number]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], [u'equipmentGemCapProvider'], [], ["Get"]),
    "EquipmentGraphicsCardCapProvider": MoMeta("EquipmentGraphicsCardCapProvider", "equipmentGraphicsCardCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version213a, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPciDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentGraphicsCardCapRef": MoMeta("EquipmentGraphicsCardCapRef", "equipmentGraphicsCardCapRef", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version213a, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentHDDFaultMonDef": MoMeta("EquipmentHDDFaultMonDef", "equipmentHDDFaultMonDef", "[controller_fw_version][hdd_mon_support]", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentHealthLed": MoMeta("EquipmentHealthLed", "equipmentHealthLed", "health-led", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeBlade', u'computeExtBoard', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'equipmentFanModule', u'equipmentFex', u'equipmentIOCard', u'equipmentPsu'], [u'computeHealthLedSensorAlarm', u'faultInst'], ["Get"]),
    "EquipmentHostIfCapProvider": MoMeta("EquipmentHostIfCapProvider", "equipmentHostIfCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentHwCapDerivativeProvider": MoMeta("EquipmentHwCapDerivativeProvider", "equipmentHwCapDerivativeProvider", "derivative-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue'], [u'adaptorFruCapProvider', u'diagSrvCapProvider', u'equipmentBaseBoardCapProvider', u'equipmentBladeBiosCapProvider', u'equipmentBladeCapProvider', u'equipmentCapModSpec', u'equipmentCatalogCapProvider', u'equipmentChassisCapProvider', u'equipmentDbgPluginCapProvider', u'equipmentFanModuleCapProvider', u'equipmentFexCapProvider', u'equipmentGemCapProvider', u'equipmentGraphicsCardCapProvider', u'equipmentHostIfCapProvider', u'equipmentIOCardCapProvider', u'equipmentIOExpanderCapProvider', u'equipmentLocalDiskCapProvider', u'equipmentLocalDiskControllerCapProvider', u'equipmentMemoryUnitCapProvider', u'equipmentMgmtCapProvider', u'equipmentMgmtExtCapProvider', u'equipmentProcessorUnitCapProvider', u'equipmentPsuCapProvider', u'equipmentRackUnitCapProvider', u'equipmentSecurityUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentStorageEncCapProvider', u'equipmentStorageSasExpanderCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider', u'equipmentTpmCapProvider'], [None]),
    "EquipmentHwRevisionModifier": MoMeta("EquipmentHwRevisionModifier", "equipmentHwRevisionModifier", "hw-rev-modifier-[hw_type]", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentIOCard": MoMeta("EquipmentIOCard", "equipmentIOCard", "slot-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassis', u'equipmentFex'], [u'equipmentBeaconLed', u'equipmentHealthLed', u'equipmentIOCardBaseFsm', u'equipmentIOCardBaseFsmTask', u'equipmentIOCardFsm', u'equipmentIOCardFsmTask', u'equipmentIOCardStats', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'equipmentPOST', u'eventInst', u'faultInst', u'faultSuppressTask', u'firmwareStatus', u'mgmtController', u'portGroup'], ["Get", "Set"]),
    "EquipmentIOCardBaseFsm": MoMeta("EquipmentIOCardBaseFsm", "equipmentIOCardBaseFsm", "fsm", VersionMeta.Version302a, "OutputOnly", 0x1, [], [""], [u'equipmentIOCard', u'equipmentSwitchIOCard'], [u'equipmentIOCardBaseFsmStage'], [None]),
    "EquipmentIOCardBaseFsmStage": MoMeta("EquipmentIOCardBaseFsmStage", "equipmentIOCardBaseFsmStage", "stage-[name]", VersionMeta.Version302a, "OutputOnly", 0x1, [], [""], [u'equipmentIOCardBaseFsm'], [], [None]),
    "EquipmentIOCardBaseFsmTask": MoMeta("EquipmentIOCardBaseFsmTask", "equipmentIOCardBaseFsmTask", "task-[item]", VersionMeta.Version302a, "OutputOnly", 0x1, [], [""], [u'equipmentIOCard', u'equipmentSwitchIOCard'], [], [None]),
    "EquipmentIOCardCapProvider": MoMeta("EquipmentIOCardCapProvider", "equipmentIOCardCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentIOCardTypeDef', u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentPortGroupAggregationDef', u'equipmentPortGroupDef', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentIOCardFsm": MoMeta("EquipmentIOCardFsm", "equipmentIOCardFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'equipmentIOCard'], [u'equipmentIOCardFsmStage'], [None]),
    "EquipmentIOCardFsmStage": MoMeta("EquipmentIOCardFsmStage", "equipmentIOCardFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'equipmentIOCardFsm'], [], [None]),
    "EquipmentIOCardFsmTask": MoMeta("EquipmentIOCardFsmTask", "equipmentIOCardFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'equipmentIOCard'], [], [None]),
    "EquipmentIOCardStats": MoMeta("EquipmentIOCardStats", "equipmentIOCardStats", "stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentIOCard', u'equipmentSwitchIOCard'], [u'equipmentIOCardStatsHist'], ["Get"]),
    "EquipmentIOCardStatsHist": MoMeta("EquipmentIOCardStatsHist", "equipmentIOCardStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentIOCardStats'], [], ["Get"]),
    "EquipmentIOCardTypeDef": MoMeta("EquipmentIOCardTypeDef", "equipmentIOCardTypeDef", "type", VersionMeta.Version202m, "InputOutput", 0x1, [], [""], [u'equipmentIOCardCapProvider', u'equipmentSwitchIOCardCapProvider'], [], ["Get"]),
    "EquipmentIOExpander": MoMeta("EquipmentIOExpander", "equipmentIOExpander", "io-expander-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], [None]),
    "EquipmentIOExpanderCapProvider": MoMeta("EquipmentIOExpanderCapProvider", "equipmentIOExpanderCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArray', u'equipmentSlotArrayRef', u'equipmentStorageControllerConfig', u'firmwareConstraints', u'firmwareType', u'firmwareUpgradeConstraint'], [None]),
    "EquipmentInbandMgmtCap": MoMeta("EquipmentInbandMgmtCap", "equipmentInbandMgmtCap", "ib-mgmt-cap", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentIndicatorLed": MoMeta("EquipmentIndicatorLed", "equipmentIndicatorLed", "indicator-led-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'equipmentFanModule', u'equipmentFex', u'equipmentIOCard', u'equipmentPsu'], [], ["Get"]),
    "EquipmentKvmMgmtCap": MoMeta("EquipmentKvmMgmtCap", "equipmentKvmMgmtCap", "kvm-mgmt-cap", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentLocalDiskCapProvider": MoMeta("EquipmentLocalDiskCapProvider", "equipmentLocalDiskCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentLocalDiskDef', u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentLocalDiskControllerCapProvider": MoMeta("EquipmentLocalDiskControllerCapProvider", "equipmentLocalDiskControllerCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'adaptorFamilyTypeDef', u'equipmentEmbeddedStorageDef', u'equipmentFlashLife', u'equipmentLocalDiskControllerDef', u'equipmentLocalDiskControllerTypeDef', u'equipmentManufacturingDef', u'equipmentOnboardDeviceDef', u'equipmentPciDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentRaidDef', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'equipmentStorageLimitCap', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentLocalDiskControllerCapRef": MoMeta("EquipmentLocalDiskControllerCapRef", "equipmentLocalDiskControllerCapRef", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version142b, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentLocalDiskControllerDef": MoMeta("EquipmentLocalDiskControllerDef", "equipmentLocalDiskControllerDef", "disk-controller", VersionMeta.Version131c, "InputOutput", 0x1, [], [""], [u'equipmentLocalDiskControllerCapProvider'], [], ["Get"]),
    "EquipmentLocalDiskControllerTypeDef": MoMeta("EquipmentLocalDiskControllerTypeDef", "equipmentLocalDiskControllerTypeDef", "controller-type", VersionMeta.Version224a, "InputOutput", 0x1, [], [""], [u'equipmentLocalDiskControllerCapProvider'], [], ["Get"]),
    "EquipmentLocalDiskDef": MoMeta("EquipmentLocalDiskDef", "equipmentLocalDiskDef", "disk", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'equipmentLocalDiskCapProvider'], [], ["Get"]),
    "EquipmentLocatorLed": MoMeta("EquipmentLocatorLed", "equipmentLocatorLed", "locator-led", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], [u'computeBlade', u'computeExtBoard', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'equipmentFanModule', u'equipmentFex', u'equipmentIOCard', u'equipmentPsu', u'networkElement', u'storageLocalDisk'], [u'equipmentLocatorLedFsm', u'equipmentLocatorLedFsmTask', u'eventInst', u'faultInst'], ["Get", "Set"]),
    "EquipmentLocatorLedFsm": MoMeta("EquipmentLocatorLedFsm", "equipmentLocatorLedFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'equipmentLocatorLed'], [u'equipmentLocatorLedFsmStage'], [None]),
    "EquipmentLocatorLedFsmStage": MoMeta("EquipmentLocatorLedFsmStage", "equipmentLocatorLedFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'equipmentLocatorLedFsm'], [], [None]),
    "EquipmentLocatorLedFsmTask": MoMeta("EquipmentLocatorLedFsmTask", "equipmentLocatorLedFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'equipmentLocatorLed'], [], [None]),
    "EquipmentManufacturingDef": MoMeta("EquipmentManufacturingDef", "equipmentManufacturingDef", "manufacturing", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'adaptorFruCapProvider', u'diagSrvCapProvider', u'equipmentBaseBoardCapProvider', u'equipmentBladeBiosCapProvider', u'equipmentBladeCapProvider', u'equipmentCatalogCapProvider', u'equipmentChassisCapProvider', u'equipmentDbgPluginCapProvider', u'equipmentFanModuleCapProvider', u'equipmentFexCapProvider', u'equipmentGemCapProvider', u'equipmentGraphicsCardCapProvider', u'equipmentHostIfCapProvider', u'equipmentIOCardCapProvider', u'equipmentIOExpanderCapProvider', u'equipmentLocalDiskCapProvider', u'equipmentLocalDiskControllerCapProvider', u'equipmentMemoryUnitCapProvider', u'equipmentMgmtCapProvider', u'equipmentMgmtExtCapProvider', u'equipmentProcessorUnitCapProvider', u'equipmentPsuCapProvider', u'equipmentRackUnitCapProvider', u'equipmentSecurityUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentStorageEncCapProvider', u'equipmentStorageSasExpanderCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider', u'equipmentTpmCapProvider'], [], ["Get"]),
    "EquipmentMemoryUnitCapProvider": MoMeta("EquipmentMemoryUnitCapProvider", "equipmentMemoryUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentMemoryUnitDiscoveryModifierDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentMemoryUnitDiscoveryModifierDef": MoMeta("EquipmentMemoryUnitDiscoveryModifierDef", "equipmentMemoryUnitDiscoveryModifierDef", "discmod-[name]", VersionMeta.Version102d, "InputOutput", 0x1, [], [""], [u'equipmentMemoryUnitCapProvider'], [], ["Get"]),
    "EquipmentMgmtCapProvider": MoMeta("EquipmentMgmtCapProvider", "equipmentMgmtCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArray', u'equipmentSlotArrayRef', u'equipmentStorageControllerConfig', u'firmwareConstraints', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentMgmtExtCapProvider": MoMeta("EquipmentMgmtExtCapProvider", "equipmentMgmtExtCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArray', u'equipmentSlotArrayRef', u'equipmentStorageControllerConfig', u'firmwareConstraints', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentNetworkElementFanStats": MoMeta("EquipmentNetworkElementFanStats", "equipmentNetworkElementFanStats", "stats", VersionMeta.Version201m, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentFan'], [u'equipmentNetworkElementFanStatsHist'], ["Get"]),
    "EquipmentNetworkElementFanStatsHist": MoMeta("EquipmentNetworkElementFanStatsHist", "equipmentNetworkElementFanStatsHist", "[id]", VersionMeta.Version201m, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentNetworkElementFanStats'], [], ["Get"]),
    "EquipmentNonCopperPassiveCap": MoMeta("EquipmentNonCopperPassiveCap", "equipmentNonCopperPassiveCap", "non-copper-passive-cap", VersionMeta.Version311e, "InputOutput", 0x1, [], [""], [u'equipmentSwitchCapProvider'], [], [None]),
    "EquipmentOnboardDeviceDef": MoMeta("EquipmentOnboardDeviceDef", "equipmentOnboardDeviceDef", "onboard-device-[device]", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], [u'equipmentLocalDiskControllerCapProvider', u'equipmentStorageSasExpanderCapProvider'], [u'firmwareType'], [None]),
    "EquipmentPOST": MoMeta("EquipmentPOST", "equipmentPOST", "code-[global_id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorUnit', u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'equipmentFex', u'equipmentIOCard'], [], ["Get"]),
    "EquipmentPOSTCode": MoMeta("EquipmentPOSTCode", "equipmentPOSTCode", "code-[local_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'equipmentPOSTCodeReporter', u'equipmentPOSTCodeTemplate'], [], ["Get"]),
    "EquipmentPOSTCodeReporter": MoMeta("EquipmentPOSTCodeReporter", "equipmentPOSTCodeReporter", "POST-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'capabilityCatalogue'], [u'bmcSELCounter', u'equipmentPOSTCode'], ["Get"]),
    "EquipmentPOSTCodeTemplate": MoMeta("EquipmentPOSTCodeTemplate", "equipmentPOSTCodeTemplate", "POST-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'capabilityCatalogue'], [u'equipmentPOSTCode'], ["Get"]),
    "EquipmentPciDef": MoMeta("EquipmentPciDef", "equipmentPciDef", "pci-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], [u'adaptorFruCapProvider', u'adaptorUnit', u'equipmentGraphicsCardCapProvider', u'equipmentLocalDiskControllerCapProvider'], [], ["Get"]),
    "EquipmentPciSlotIdEntry": MoMeta("EquipmentPciSlotIdEntry", "equipmentPciSlotIdEntry", "pci-slotid-entry-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'equipmentPciSlotIdMapping'], [], [None]),
    "EquipmentPciSlotIdMapping": MoMeta("EquipmentPciSlotIdMapping", "equipmentPciSlotIdMapping", "pci-slotid-mapping", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [u'equipmentPciSlotIdEntry'], [None]),
    "EquipmentPciSlotSubOEMIdEntry": MoMeta("EquipmentPciSlotSubOEMIdEntry", "equipmentPciSlotSubOEMIdEntry", "pci-slot-suboemid-entry-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'equipmentStorageControllerConfig'], [], [None]),
    "EquipmentPfcMmuCap": MoMeta("EquipmentPfcMmuCap", "equipmentPfcMmuCap", "pfc-mmu-cap", VersionMeta.Version311e, "InputOutput", 0x1, [], [""], [u'equipmentSwitchCapProvider'], [], [None]),
    "EquipmentPhysDevicesPerBoard": MoMeta("EquipmentPhysDevicesPerBoard", "equipmentPhysDevicesPerBoard", "phys-dev-per-board", VersionMeta.Version222c, "InputOutput", 0x1, [], [""], [u'equipmentBladeAggregationCapRef'], [], ["Get"]),
    "EquipmentPhysicalDef": MoMeta("EquipmentPhysicalDef", "equipmentPhysicalDef", "physical", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'adaptorFruCapProvider', u'diagSrvCapProvider', u'equipmentBaseBoardCapProvider', u'equipmentBladeBiosCapProvider', u'equipmentBladeCapProvider', u'equipmentCatalogCapProvider', u'equipmentChassisCapProvider', u'equipmentDbgPluginCapProvider', u'equipmentFanModuleCapProvider', u'equipmentFexCapProvider', u'equipmentGemCapProvider', u'equipmentGraphicsCardCapProvider', u'equipmentHostIfCapProvider', u'equipmentIOCardCapProvider', u'equipmentIOExpanderCapProvider', u'equipmentLocalDiskCapProvider', u'equipmentLocalDiskControllerCapProvider', u'equipmentMemoryUnitCapProvider', u'equipmentMgmtCapProvider', u'equipmentMgmtExtCapProvider', u'equipmentProcessorUnitCapProvider', u'equipmentPsuCapProvider', u'equipmentRackUnitCapProvider', u'equipmentSecurityUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentStorageEncCapProvider', u'equipmentStorageSasExpanderCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider', u'equipmentTpmCapProvider'], [], ["Get"]),
    "EquipmentPhysicalQual": MoMeta("EquipmentPhysicalQual", "equipmentPhysicalQual", "physicalqual", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'equipmentQual'], [], [None]),
    "EquipmentPicture": MoMeta("EquipmentPicture", "equipmentPicture", "picture-[type]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], [u'adaptorFruCapProvider', u'diagSrvCapProvider', u'equipmentBaseBoardCapProvider', u'equipmentBladeBiosCapProvider', u'equipmentBladeCapProvider', u'equipmentCatalogCapProvider', u'equipmentChassisCapProvider', u'equipmentDbgPluginCapProvider', u'equipmentFanModuleCapProvider', u'equipmentFexCapProvider', u'equipmentGemCapProvider', u'equipmentGraphicsCardCapProvider', u'equipmentHostIfCapProvider', u'equipmentIOCardCapProvider', u'equipmentIOExpanderCapProvider', u'equipmentLocalDiskCapProvider', u'equipmentLocalDiskControllerCapProvider', u'equipmentMemoryUnitCapProvider', u'equipmentMgmtCapProvider', u'equipmentMgmtExtCapProvider', u'equipmentProcessorUnitCapProvider', u'equipmentPsuCapProvider', u'equipmentRackUnitCapProvider', u'equipmentSecurityUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentStorageEncCapProvider', u'equipmentStorageSasExpanderCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider', u'equipmentTpmCapProvider'], [], ["Get"]),
    "EquipmentPool": MoMeta("EquipmentPool", "equipmentPool", "equipment-pool-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [u'equipmentPooledChassis'], [None]),
    "EquipmentPoolPolicyRef": MoMeta("EquipmentPoolPolicyRef", "equipmentPoolPolicyRef", "chassis-poolref-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'equipmentPoolable'], [], [None]),
    "EquipmentPoolable": MoMeta("EquipmentPoolable", "equipmentPoolable", "chassis-pool-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'equipmentChassis'], [u'equipmentPoolPolicyRef'], [None]),
    "EquipmentPooledChassis": MoMeta("EquipmentPooledChassis", "equipmentPooledChassis", "chassis-[chassis_id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'equipmentPool'], [], [None]),
    "EquipmentPoolingPolicy": MoMeta("EquipmentPoolingPolicy", "equipmentPoolingPolicy", "chassis-pooling-policy-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [], [None]),
    "EquipmentPortCap": MoMeta("EquipmentPortCap", "equipmentPortCap", "port-cap-start-[start_port_id]-end-[end_port_id]", VersionMeta.Version302a, "InputOutput", 0x1, [], [""], [u'equipmentSwitchCap', u'equipmentSwitchIOCardCapProvider'], [], [None]),
    "EquipmentPortGroupAggregationDef": MoMeta("EquipmentPortGroupAggregationDef", "equipmentPortGroupAggregationDef", "port-group-aggr-def-[type]", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], [u'adaptorFruCapProvider', u'equipmentFexCapProvider', u'equipmentIOCardCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider'], [], ["Get"]),
    "EquipmentPortGroupDef": MoMeta("EquipmentPortGroupDef", "equipmentPortGroupDef", "port-group-def[type]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], [u'adaptorFruCapProvider', u'equipmentFexCapProvider', u'equipmentIOCardCapProvider', u'equipmentSwitchIOCardCapProvider'], [], ["Get"]),
    "EquipmentPortGroupSwComplexDef": MoMeta("EquipmentPortGroupSwComplexDef", "equipmentPortGroupSwComplexDef", "port-group-sw-complex-def[asic]", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], [u'equipmentSwitchCapProvider'], [u'equipmentPortSwComplexRef'], ["Get"]),
    "EquipmentPortSwComplexRef": MoMeta("EquipmentPortSwComplexRef", "equipmentPortSwComplexRef", "port-sw-complex-ref-[sw_complex_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], [u'equipmentPortGroupSwComplexDef'], [], ["Get"]),
    "EquipmentPowerCapDef": MoMeta("EquipmentPowerCapDef", "equipmentPowerCapDef", "powercap", VersionMeta.Version302a, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentChassisCapProvider', u'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentProcessorUnitCapProvider": MoMeta("EquipmentProcessorUnitCapProvider", "equipmentProcessorUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentProcessorUnitDef', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentProcessorUnitDef": MoMeta("EquipmentProcessorUnitDef", "equipmentProcessorUnitDef", "cpu", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'equipmentProcessorUnitCapProvider'], [], ["Get"]),
    "EquipmentPsu": MoMeta("EquipmentPsu", "equipmentPsu", "psu-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'computeRackUnit', u'equipmentChassis', u'equipmentFex', u'networkElement'], [u'equipmentBeaconLed', u'equipmentFexPsuInputStats', u'equipmentHealthLed', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'equipmentPsuFsm', u'equipmentPsuFsmTask', u'equipmentPsuInputStats', u'equipmentPsuOutputStats', u'equipmentPsuStats', u'equipmentRackUnitPsuStats', u'eventInst', u'faultInst', u'firmwareBootDefinition', u'firmwareRunning', u'firmwareStatus', u'firmwareUpdatable'], ["Get"]),
    "EquipmentPsuCapProvider": MoMeta("EquipmentPsuCapProvider", "equipmentPsuCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentPsuDef', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentPsuDef": MoMeta("EquipmentPsuDef", "equipmentPsuDef", "[psu_type]", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], [u'equipmentPsuCapProvider'], [], ["Get"]),
    "EquipmentPsuFsm": MoMeta("EquipmentPsuFsm", "equipmentPsuFsm", "fsm", VersionMeta.Version302a, "OutputOnly", 0x1, [], [""], [u'equipmentPsu'], [u'equipmentPsuFsmStage'], [None]),
    "EquipmentPsuFsmStage": MoMeta("EquipmentPsuFsmStage", "equipmentPsuFsmStage", "stage-[name]", VersionMeta.Version302a, "OutputOnly", 0x1, [], [""], [u'equipmentPsuFsm'], [], [None]),
    "EquipmentPsuFsmTask": MoMeta("EquipmentPsuFsmTask", "equipmentPsuFsmTask", "task-[item]", VersionMeta.Version302a, "OutputOnly", 0x1, [], [""], [u'equipmentPsu'], [], [None]),
    "EquipmentPsuInputStats": MoMeta("EquipmentPsuInputStats", "equipmentPsuInputStats", "input-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentPsu'], [u'equipmentPsuInputStatsHist'], ["Get"]),
    "EquipmentPsuInputStatsHist": MoMeta("EquipmentPsuInputStatsHist", "equipmentPsuInputStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentPsuInputStats'], [], ["Get"]),
    "EquipmentPsuOutputStats": MoMeta("EquipmentPsuOutputStats", "equipmentPsuOutputStats", "output-stats", VersionMeta.Version201m, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentPsu'], [u'equipmentPsuOutputStatsHist'], ["Get"]),
    "EquipmentPsuOutputStatsHist": MoMeta("EquipmentPsuOutputStatsHist", "equipmentPsuOutputStatsHist", "[id]", VersionMeta.Version201m, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentPsuOutputStats'], [], ["Get"]),
    "EquipmentPsuStats": MoMeta("EquipmentPsuStats", "equipmentPsuStats", "stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentPsu'], [u'equipmentPsuStatsHist'], ["Get"]),
    "EquipmentPsuStatsHist": MoMeta("EquipmentPsuStatsHist", "equipmentPsuStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentPsuStats'], [], ["Get"]),
    "EquipmentQual": MoMeta("EquipmentQual", "equipmentQual", "chassis-qualifier-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [u'equipmentChassisQual', u'equipmentPhysicalQual'], [None]),
    "EquipmentRackFanModuleDef": MoMeta("EquipmentRackFanModuleDef", "equipmentRackFanModuleDef", "rack-fan-module", VersionMeta.Version212a, "InputOutput", 0x1, [], [""], [u'equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentRackUnitCapProvider": MoMeta("EquipmentRackUnitCapProvider", "equipmentRackUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'adaptorFruCapRef', u'computeConstraintDef', u'computeMemoryUnitConstraintDef', u'computePciCap', u'computeServerTypeCap', u'equipmentAdvancedBootOrder', u'equipmentBiosDef', u'equipmentBladeAGLibrary', u'equipmentBoardControllerDef', u'equipmentBootDeviceConstraints', u'equipmentCimcVmedia', u'equipmentCiscoOsOpenGate', u'equipmentDimmMapping', u'equipmentDiscoveryCap', u'equipmentGraphicsCardCapRef', u'equipmentHwRevisionModifier', u'equipmentInbandMgmtCap', u'equipmentKvmMgmtCap', u'equipmentLocalDiskControllerCapRef', u'equipmentManufacturingDef', u'equipmentPciSlotIdMapping', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentPowerCapDef', u'equipmentRackFanModuleDef', u'equipmentSecureBoot', u'equipmentServerCorrectUuidBehavior', u'equipmentServerFeatureCap', u'equipmentServiceDef', u'equipmentSlotArray', u'equipmentSlotArrayRef', u'equipmentStorageControllerConfig', u'equipmentStorageControllerSlotDef', u'equipmentStorageSasExpanderCapRef', u'equipmentUuidFeatureCap', u'firmwareConstraints', u'firmwareType', u'firmwareUpgradeConstraint', u'storageHwRevisionModifier'], ["Get"]),
    "EquipmentRackUnitFanStats": MoMeta("EquipmentRackUnitFanStats", "equipmentRackUnitFanStats", "stats", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentFan'], [u'equipmentRackUnitFanStatsHist'], ["Get"]),
    "EquipmentRackUnitFanStatsHist": MoMeta("EquipmentRackUnitFanStatsHist", "equipmentRackUnitFanStatsHist", "[id]", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentRackUnitFanStats'], [], ["Get"]),
    "EquipmentRackUnitPsuStats": MoMeta("EquipmentRackUnitPsuStats", "equipmentRackUnitPsuStats", "rackunit-power-stats", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentPsu'], [u'equipmentRackUnitPsuStatsHist'], ["Get"]),
    "EquipmentRackUnitPsuStatsHist": MoMeta("EquipmentRackUnitPsuStatsHist", "equipmentRackUnitPsuStatsHist", "[id]", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentRackUnitPsuStats'], [], ["Get"]),
    "EquipmentRaidDef": MoMeta("EquipmentRaidDef", "equipmentRaidDef", "[level]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], [u'equipmentLocalDiskControllerCapProvider'], [], ["Get"]),
    "EquipmentRequirement": MoMeta("EquipmentRequirement", "equipmentRequirement", "chassis-req", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], [u'equipmentChassisProfile'], [u'faultInst'], [None]),
    "EquipmentSecureBoot": MoMeta("EquipmentSecureBoot", "equipmentSecureBoot", "secBoot", VersionMeta.Version221b, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentSecurityUnitCapProvider": MoMeta("EquipmentSecurityUnitCapProvider", "equipmentSecurityUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'firmwareType', u'firmwareUpgradeConstraint'], [None]),
    "EquipmentServerCorrectUuidBehavior": MoMeta("EquipmentServerCorrectUuidBehavior", "equipmentServerCorrectUuidBehavior", "server-correct-uuid", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentServerFeatureCap": MoMeta("EquipmentServerFeatureCap", "equipmentServerFeatureCap", "server-feature-cap", VersionMeta.Version202m, "InputOutput", 0x1, [], ["read-only"], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentServerPortCapProvider": MoMeta("EquipmentServerPortCapProvider", "equipmentServerPortCapProvider", "server-port-cap", VersionMeta.Version311e, "InputOutput", 0x1, [], [""], [u'equipmentGemCapProvider', u'equipmentSwitchIOCardCapProvider'], [], [None]),
    "EquipmentServerUnitCapProvider": MoMeta("EquipmentServerUnitCapProvider", "equipmentServerUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version251a, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'computePciCap', u'equipmentBiosDef', u'equipmentBladeAGLibrary', u'equipmentBladeConnDef', u'equipmentBoardControllerDef', u'equipmentDimmMapping', u'equipmentHDDFaultMonDef', u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServerFeatureCap', u'equipmentServiceDef', u'equipmentSlotArray', u'equipmentSlotArrayRef', u'equipmentStorageControllerConfig', u'firmwareConstraints', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentServiceDef": MoMeta("EquipmentServiceDef", "equipmentServiceDef", "service", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'adaptorFruCapProvider', u'diagSrvCapProvider', u'equipmentBaseBoardCapProvider', u'equipmentBladeBiosCapProvider', u'equipmentBladeCapProvider', u'equipmentCatalogCapProvider', u'equipmentChassisCapProvider', u'equipmentDbgPluginCapProvider', u'equipmentFanModuleCapProvider', u'equipmentFexCapProvider', u'equipmentGemCapProvider', u'equipmentGraphicsCardCapProvider', u'equipmentHostIfCapProvider', u'equipmentIOCardCapProvider', u'equipmentIOExpanderCapProvider', u'equipmentLocalDiskCapProvider', u'equipmentLocalDiskControllerCapProvider', u'equipmentMemoryUnitCapProvider', u'equipmentMgmtCapProvider', u'equipmentMgmtExtCapProvider', u'equipmentProcessorUnitCapProvider', u'equipmentPsuCapProvider', u'equipmentRackUnitCapProvider', u'equipmentSecurityUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentStorageEncCapProvider', u'equipmentStorageSasExpanderCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider', u'equipmentTpmCapProvider'], [], ["Get"]),
    "EquipmentSharedIOModule": MoMeta("EquipmentSharedIOModule", "equipmentSharedIOModule", "shared-io-module", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassis', u'equipmentSystemIOController'], [u'faultInst', u'mgmtController', u'portGroup'], ["Get", "Set"]),
    "EquipmentSiocTempStats": MoMeta("EquipmentSiocTempStats", "equipmentSiocTempStats", "temp-stats", VersionMeta.Version911z, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentSystemIOController'], [u'equipmentSiocTempStatsHist'], [None]),
    "EquipmentSiocTempStatsHist": MoMeta("EquipmentSiocTempStatsHist", "equipmentSiocTempStatsHist", "[id]", VersionMeta.Version911z, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentSiocTempStats'], [], [None]),
    "EquipmentSlotArray": MoMeta("EquipmentSlotArray", "equipmentSlotArray", "[selector]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'diagSrvCapProvider', u'equipmentBladeCapProvider', u'equipmentCatalogCapProvider', u'equipmentChassisCapProvider', u'equipmentDbgPluginCapProvider', u'equipmentIOExpanderCapProvider', u'equipmentMgmtCapProvider', u'equipmentMgmtExtCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentStorageEncCapProvider', u'equipmentSwitchCapProvider'], [], ["Get"]),
    "EquipmentSlotArrayRef": MoMeta("EquipmentSlotArrayRef", "equipmentSlotArrayRef", "ref-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider', u'diagSrvCapProvider', u'equipmentBaseBoardCapProvider', u'equipmentBladeBiosCapProvider', u'equipmentBladeCapProvider', u'equipmentCatalogCapProvider', u'equipmentChassisCapProvider', u'equipmentDbgPluginCapProvider', u'equipmentFanModuleCapProvider', u'equipmentFexCapProvider', u'equipmentGemCapProvider', u'equipmentGraphicsCardCapProvider', u'equipmentHostIfCapProvider', u'equipmentIOCardCapProvider', u'equipmentIOExpanderCapProvider', u'equipmentLocalDiskCapProvider', u'equipmentLocalDiskControllerCapProvider', u'equipmentMemoryUnitCapProvider', u'equipmentMgmtCapProvider', u'equipmentMgmtExtCapProvider', u'equipmentProcessorUnitCapProvider', u'equipmentPsuCapProvider', u'equipmentRackUnitCapProvider', u'equipmentSecurityUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentStorageEncCapProvider', u'equipmentStorageSasExpanderCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider', u'equipmentTpmCapProvider'], [], ["Get"]),
    "EquipmentStorageControllerConfig": MoMeta("EquipmentStorageControllerConfig", "equipmentStorageControllerConfig", "ven-[vendor]-dev-[device]-subven-[subvendor]-subdev-[subdevice]", VersionMeta.Version225a, "InputOutput", 0x1, [], [""], [u'diagSrvCapProvider', u'equipmentBladeCapProvider', u'equipmentCatalogCapProvider', u'equipmentChassisCapProvider', u'equipmentDbgPluginCapProvider', u'equipmentIOExpanderCapProvider', u'equipmentMgmtCapProvider', u'equipmentMgmtExtCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentStorageEncCapProvider', u'equipmentSwitchCapProvider'], [u'equipmentPciSlotSubOEMIdEntry'], ["Get"]),
    "EquipmentStorageControllerSlotDef": MoMeta("EquipmentStorageControllerSlotDef", "equipmentStorageControllerSlotDef", "controller-slot-def-[slot_num]", VersionMeta.Version224a, "InputOutput", 0x1, [], ["read-only"], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], [None]),
    "EquipmentStorageEncCapProvider": MoMeta("EquipmentStorageEncCapProvider", "equipmentStorageEncCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArray', u'equipmentSlotArrayRef', u'equipmentStorageControllerConfig', u'firmwareConstraints', u'firmwareType', u'firmwareUpgradeConstraint'], [None]),
    "EquipmentStorageLimitCap": MoMeta("EquipmentStorageLimitCap", "equipmentStorageLimitCap", "storage-limit", VersionMeta.Version251a, "InputOutput", 0x1, [], ["read-only"], [u'equipmentLocalDiskControllerCapProvider'], [], ["Get"]),
    "EquipmentStorageSasExpanderCapProvider": MoMeta("EquipmentStorageSasExpanderCapProvider", "equipmentStorageSasExpanderCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version226a, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentOnboardDeviceDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'equipmentStorageSasExpanderDef', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentStorageSasExpanderCapRef": MoMeta("EquipmentStorageSasExpanderCapRef", "equipmentStorageSasExpanderCapRef", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version226a, "InputOutput", 0x1, [], [""], [u'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentStorageSasExpanderDef": MoMeta("EquipmentStorageSasExpanderDef", "equipmentStorageSasExpanderDef", "sas-expander-def", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'equipmentStorageSasExpanderCapProvider'], [], [None]),
    "EquipmentSwitchCap": MoMeta("EquipmentSwitchCap", "equipmentSwitchCap", "switch-cap", VersionMeta.Version111j, "InputOutput", 0x1, [], [""], [u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider'], [u'equipmentPortCap'], ["Get"]),
    "EquipmentSwitchCapProvider": MoMeta("EquipmentSwitchCapProvider", "equipmentSwitchCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentBeaconCapProvider', u'equipmentBreakoutCap', u'equipmentManufacturingDef', u'equipmentNonCopperPassiveCap', u'equipmentPfcMmuCap', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentPortGroupAggregationDef', u'equipmentPortGroupSwComplexDef', u'equipmentServiceDef', u'equipmentSlotArray', u'equipmentSlotArrayRef', u'equipmentStorageControllerConfig', u'equipmentSwitchCap', u'equipmentUnifiedPortCapProvider', u'firmwareConstraints', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentSwitchCard": MoMeta("EquipmentSwitchCard", "equipmentSwitchCard", "slot-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'equipmentBeaconLed', u'faultInst', u'portGroup'], ["Get"]),
    "EquipmentSwitchIOCard": MoMeta("EquipmentSwitchIOCard", "equipmentSwitchIOCard", "sw-slot-[id]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassis'], [u'equipmentIOCardBaseFsm', u'equipmentIOCardBaseFsmTask', u'equipmentIOCardStats', u'equipmentSwitchIOCardFsm', u'equipmentSwitchIOCardFsmTask', u'eventInst', u'faultInst', u'mgmtController', u'portGroup'], [None]),
    "EquipmentSwitchIOCardCapProvider": MoMeta("EquipmentSwitchIOCardCapProvider", "equipmentSwitchIOCardCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version302a, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentBeaconCapProvider', u'equipmentIOCardTypeDef', u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentPortCap', u'equipmentPortGroupAggregationDef', u'equipmentPortGroupDef', u'equipmentServerPortCapProvider', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'equipmentSwitchCap', u'equipmentUnifiedPortCapProvider', u'firmwareType', u'firmwareUpgradeConstraint'], [None]),
    "EquipmentSwitchIOCardFsm": MoMeta("EquipmentSwitchIOCardFsm", "equipmentSwitchIOCardFsm", "fsm", VersionMeta.Version302a, "OutputOnly", 0x1, [], [""], [u'equipmentSwitchIOCard'], [u'equipmentSwitchIOCardFsmStage'], [None]),
    "EquipmentSwitchIOCardFsmStage": MoMeta("EquipmentSwitchIOCardFsmStage", "equipmentSwitchIOCardFsmStage", "stage-[name]", VersionMeta.Version302a, "OutputOnly", 0x1, [], [""], [u'equipmentSwitchIOCardFsm'], [], [None]),
    "EquipmentSwitchIOCardFsmTask": MoMeta("EquipmentSwitchIOCardFsmTask", "equipmentSwitchIOCardFsmTask", "task-[item]", VersionMeta.Version311e, "OutputOnly", 0x1, [], [""], [u'equipmentSwitchIOCard'], [], [None]),
    "EquipmentSwitchTypeDef": MoMeta("EquipmentSwitchTypeDef", "equipmentSwitchTypeDef", "type", VersionMeta.Version302a, "InputOutput", 0x1, [], [""], [], [], [None]),
    "EquipmentSystemIOController": MoMeta("EquipmentSystemIOController", "equipmentSystemIOController", "slot-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassis'], [u'equipmentSharedIOModule', u'equipmentSiocTempStats', u'equipmentSystemIOControllerFsm', u'equipmentSystemIOControllerFsmTask', u'eventInst', u'faultInst', u'mgmtController'], [None]),
    "EquipmentSystemIOControllerFsm": MoMeta("EquipmentSystemIOControllerFsm", "equipmentSystemIOControllerFsm", "fsm", VersionMeta.Version911z, "OutputOnly", 0x1, [], [""], [u'equipmentSystemIOController'], [u'equipmentSystemIOControllerFsmStage'], [None]),
    "EquipmentSystemIOControllerFsmStage": MoMeta("EquipmentSystemIOControllerFsmStage", "equipmentSystemIOControllerFsmStage", "stage-[name]", VersionMeta.Version911z, "OutputOnly", 0x1, [], [""], [u'equipmentSystemIOControllerFsm'], [], [None]),
    "EquipmentSystemIOControllerFsmTask": MoMeta("EquipmentSystemIOControllerFsmTask", "equipmentSystemIOControllerFsmTask", "task-[item]", VersionMeta.Version911z, "OutputOnly", 0x1, [], [""], [u'equipmentSystemIOController'], [], [None]),
    "EquipmentTier": MoMeta("EquipmentTier", "equipmentTier", "cp-tier-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy"], [u'orgOrg'], [u'equipmentChassisProfile'], [None]),
    "EquipmentTpm": MoMeta("EquipmentTpm", "equipmentTpm", "Tpm-[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'computeBoard'], [u'faultInst'], ["Get"]),
    "EquipmentTpmCapProvider": MoMeta("EquipmentTpmCapProvider", "equipmentTpmCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version221b, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue', u'equipmentHwCapDerivativeProvider'], [u'equipmentManufacturingDef', u'equipmentPhysicalDef', u'equipmentPicture', u'equipmentServiceDef', u'equipmentSlotArrayRef', u'firmwareType', u'firmwareUpgradeConstraint'], ["Get"]),
    "EquipmentUnifiedPortCapProvider": MoMeta("EquipmentUnifiedPortCapProvider", "equipmentUnifiedPortCapProvider", "unified-port-cap", VersionMeta.Version201m, "InputOutput", 0x1, [], [""], [u'equipmentGemCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider'], [], ["Get"]),
    "EquipmentUuidFeatureCap": MoMeta("EquipmentUuidFeatureCap", "equipmentUuidFeatureCap", "uuid-feature-cap", VersionMeta.Version223a, "InputOutput", 0x1, [], ["read-only"], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider'], [], ["Get"]),
    "EquipmentVersionConstraint": MoMeta("EquipmentVersionConstraint", "equipmentVersionConstraint", "ver-constr", VersionMeta.Version212a, "InputOutput", 0x1, [], [""], [u'equipmentBoardControllerDef'], [], ["Get"]),
    "EquipmentXcvr": MoMeta("EquipmentXcvr", "equipmentXcvr", "transceiver", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'etherPIo', u'etherServerIntFIo', u'etherSwitchIntFIo', u'fcPIo'], [], ["Get"]),
    "EtherErrStats": MoMeta("EtherErrStats", "etherErrStats", "err-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'etherPIo', u'etherServerIntFIo', u'fabricEthEstcPc', u'fabricEthLanPc'], [u'etherErrStatsHist'], ["Get"]),
    "EtherErrStatsHist": MoMeta("EtherErrStatsHist", "etherErrStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'etherErrStats'], [], ["Get"]),
    "EtherFcoeInterfaceStats": MoMeta("EtherFcoeInterfaceStats", "etherFcoeInterfaceStats", "fcoe-interface-stats", VersionMeta.Version211a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'fabricFcoeEstcEp', u'fabricFcoeSanEp', u'fabricFcoeSanPc'], [u'etherFcoeInterfaceStatsHist'], ["Get"]),
    "EtherFcoeInterfaceStatsHist": MoMeta("EtherFcoeInterfaceStatsHist", "etherFcoeInterfaceStatsHist", "[id]", VersionMeta.Version211a, "OutputOnly", 0x1, [], ["read-only"], [u'etherFcoeInterfaceStats'], [], ["Get"]),
    "EtherLossStats": MoMeta("EtherLossStats", "etherLossStats", "loss-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'etherPIo', u'etherServerIntFIo', u'fabricEthEstcPc', u'fabricEthLanPc'], [u'etherLossStatsHist'], ["Get"]),
    "EtherLossStatsHist": MoMeta("EtherLossStatsHist", "etherLossStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'etherLossStats'], [], ["Get"]),
    "EtherNiErrStats": MoMeta("EtherNiErrStats", "etherNiErrStats", "ni-err-stats", VersionMeta.Version223a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'etherPIo', u'etherSwitchIntFIo', u'etherSwitchIntFIoPc'], [u'etherNiErrStatsHist'], ["Get"]),
    "EtherNiErrStatsHist": MoMeta("EtherNiErrStatsHist", "etherNiErrStatsHist", "[id]", VersionMeta.Version223a, "OutputOnly", 0x1, [], ["read-only"], [u'etherNiErrStats'], [], ["Get"]),
    "EtherNicIfConfig": MoMeta("EtherNicIfConfig", "etherNicIfConfig", "if-config", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "EtherPIo": MoMeta("EtherPIo", "etherPIo", "port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'portGroup', u'portSubGroup'], [u'equipmentXcvr', u'etherErrStats', u'etherLossStats', u'etherNiErrStats', u'etherPIoEndPoint', u'etherPIoFsm', u'etherPauseStats', u'etherRxStats', u'etherTxStats', u'eventInst', u'faultInst', u'lldpAcquired', u'networkIfStats', u'portDomainEp', u'portPIoFsm', u'portPIoFsmTask'], ["Get"]),
    "EtherPIoEndPoint": MoMeta("EtherPIoEndPoint", "etherPIoEndPoint", "EndPointDn-cloud-[ep_cloud_type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'etherPIo'], [], [None]),
    "EtherPIoFsm": MoMeta("EtherPIoFsm", "etherPIoFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'etherPIo'], [u'etherPIoFsmStage'], [None]),
    "EtherPIoFsmStage": MoMeta("EtherPIoFsmStage", "etherPIoFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'etherPIoFsm'], [], [None]),
    "EtherPauseStats": MoMeta("EtherPauseStats", "etherPauseStats", "pause-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'etherPIo', u'etherServerIntFIo', u'fabricEthEstcPc', u'fabricEthLanPc'], [u'etherPauseStatsHist'], ["Get"]),
    "EtherPauseStatsHist": MoMeta("EtherPauseStatsHist", "etherPauseStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'etherPauseStats'], [], ["Get"]),
    "EtherPortChanIdElem": MoMeta("EtherPortChanIdElem", "etherPortChanIdElem", "pchanid-[id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [u'etherPortChanIdUniverse'], [], ["Get"]),
    "EtherPortChanIdUniverse": MoMeta("EtherPortChanIdUniverse", "etherPortChanIdUniverse", "pchanid-universe", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [u'fabricEp'], [u'etherPortChanIdElem'], ["Get"]),
    "EtherRxStats": MoMeta("EtherRxStats", "etherRxStats", "rx-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'etherPIo', u'etherServerIntFIo', u'fabricEthEstcPc', u'fabricEthLanPc'], [u'etherRxStatsHist'], ["Get"]),
    "EtherRxStatsHist": MoMeta("EtherRxStatsHist", "etherRxStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'etherRxStats'], [], ["Get"]),
    "EtherServerIntFIo": MoMeta("EtherServerIntFIo", "etherServerIntFIo", "port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'diagSrvCtrl', u'portGroup'], [u'equipmentXcvr', u'etherErrStats', u'etherLossStats', u'etherPauseStats', u'etherRxStats', u'etherServerIntFIoFsm', u'etherServerIntFIoFsmTask', u'etherTxStats', u'eventInst', u'faultInst', u'lldpAcquired', u'portDomainEp', u'portTrustMode', u'swUlan'], ["Get"]),
    "EtherServerIntFIoFsm": MoMeta("EtherServerIntFIoFsm", "etherServerIntFIoFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'etherServerIntFIo'], [u'etherServerIntFIoFsmStage'], [None]),
    "EtherServerIntFIoFsmStage": MoMeta("EtherServerIntFIoFsmStage", "etherServerIntFIoFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'etherServerIntFIoFsm'], [], [None]),
    "EtherServerIntFIoFsmTask": MoMeta("EtherServerIntFIoFsmTask", "etherServerIntFIoFsmTask", "task-[item]", VersionMeta.Version202m, "OutputOnly", 0x1, [], [""], [u'etherServerIntFIo'], [], [None]),
    "EtherServerIntFIoPc": MoMeta("EtherServerIntFIoPc", "etherServerIntFIoPc", "pc-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], [u'portGroup'], [u'etherServerIntFIoPcEp'], ["Get"]),
    "EtherServerIntFIoPcEp": MoMeta("EtherServerIntFIoPcEp", "etherServerIntFIoPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], [u'etherServerIntFIoPc'], [], ["Get"]),
    "EtherSwIfConfig": MoMeta("EtherSwIfConfig", "etherSwIfConfig", "if-config", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'fabricDceSrv', u'fabricEthLan'], [], ["Get"]),
    "EtherSwitchIntFIo": MoMeta("EtherSwitchIntFIo", "etherSwitchIntFIo", "port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'portGroup'], [u'equipmentXcvr', u'etherNiErrStats', u'faultInst', u'portDomainEp'], ["Get"]),
    "EtherSwitchIntFIoPc": MoMeta("EtherSwitchIntFIoPc", "etherSwitchIntFIoPc", "pc-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], [u'portGroup'], [u'etherNiErrStats', u'etherSwitchIntFIoPcEp', u'faultInst'], ["Get"]),
    "EtherSwitchIntFIoPcEp": MoMeta("EtherSwitchIntFIoPcEp", "etherSwitchIntFIoPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], [u'etherSwitchIntFIoPc'], [], ["Get"]),
    "EtherTxStats": MoMeta("EtherTxStats", "etherTxStats", "tx-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'etherPIo', u'etherServerIntFIo', u'fabricEthEstcPc', u'fabricEthLanPc'], [u'etherTxStatsHist'], ["Get"]),
    "EtherTxStatsHist": MoMeta("EtherTxStatsHist", "etherTxStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'etherTxStats'], [], ["Get"]),
    "EventEpCtrl": MoMeta("EventEpCtrl", "eventEpCtrl", "evctrl", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "fault", "operations"], [], [], ["Get"]),
    "EventHolder": MoMeta("EventHolder", "eventHolder", "event", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'eventPolicy'], ["Get"]),
    "EventInst": MoMeta("EventInst", "eventInst", "event-[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'aaaAuthRealm', u'aaaLdapEp', u'aaaRadiusEp', u'aaaTacacsPlusEp', u'aaaUserEp', u'adaptorExtEthIf', u'adaptorHostEthIf', u'adaptorHostFcIf', u'callhomeEp', u'capabilityCatalogue', u'capabilityMgmtExtension', u'capabilityUpdater', u'commSvcEp', u'computeBlade', u'computeRackUnit', u'computeServerDiscPolicy', u'computeServerUnit', u'epqosDefinition', u'epqosDefinitionDelTask', u'equipmentBeaconLed', u'equipmentChassis', u'equipmentChassisProfile', u'equipmentFex', u'equipmentIOCard', u'equipmentLocatorLed', u'equipmentPsu', u'equipmentSwitchIOCard', u'equipmentSystemIOController', u'etherPIo', u'etherServerIntFIo', u'extpolEp', u'extpolProvider', u'extpolRegistry', u'extvmmEp', u'extvmmKeyStore', u'extvmmMasterExtKey', u'extvmmNetworkSets', u'extvmmProvider', u'extvmmSwitchDelTask', u'fabricCartridgeSlotEp', u'fabricComputeMSlotEp', u'fabricComputeSlotEp', u'fabricEpMgr', u'fabricLanCloud', u'fabricSanCloud', u'fabricVnetEpSyncEp', u'fcPIo', u'firmwareDistributable', u'firmwareDownloader', u'firmwareImage', u'firmwareSystem', u'gmetaHolder', u'identIdentRequest', u'identMetaSystem', u'licenseDownloader', u'licenseFile', u'licenseInstance', u'lsServer', u'mgmtBackup', u'mgmtBackupPolicy', u'mgmtCfgExportPolicy', u'mgmtController', u'mgmtIPv6IfAddr', u'mgmtIf', u'mgmtImporter', u'morefImportRoot', u'nfsMountDef', u'nfsMountInst', u'observeObserved', u'pkiEp', u'policyControlEp', u'policyControlledType', u'policyPolicyScope', u'qosclassDefinition', u'statsCollectionPolicy', u'storageEnclosure', u'storageFlexFlashController', u'storageLocalDisk', u'storageSystem', u'swAccessDomain', u'swEthLanBorder', u'swEthLanFlowMon', u'swEthMon', u'swExtUtility', u'swFcMon', u'swFcSanBorder', u'swPhys', u'swUtilityDomain', u'syntheticFsObj', u'sysdebugAutoCoreFileExportTarget', u'sysdebugCore', u'sysdebugLogControlEp', u'sysdebugLogExportPolicy', u'sysdebugManualCoreFileExportTarget', u'sysdebugTechSupport', u'sysfileMutation', u'vmLifeCyclePolicy', u'vnicProfileSet'], [], ["Get"]),
    "EventLog": MoMeta("EventLog", "eventLog", "event-log", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "fault", "operations"], [u'topRoot'], [u'eventRecord'], ["Get"]),
    "EventPolicy": MoMeta("EventPolicy", "eventPolicy", "event-policy", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "read-only"], [u'eventHolder'], [], ["Get"]),
    "EventRecord": MoMeta("EventRecord", "eventRecord", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'eventLog'], [], ["Get"]),
    "ExtmgmtArpTargets": MoMeta("ExtmgmtArpTargets", "extmgmtArpTargets", "arp-target-policy", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'extmgmtIfMonPolicy'], [u'faultInst'], ["Get", "Set"]),
    "ExtmgmtGatewayPing": MoMeta("ExtmgmtGatewayPing", "extmgmtGatewayPing", "gw-ping-policy", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'extmgmtIfMonPolicy'], [], ["Get"]),
    "ExtmgmtIf": MoMeta("ExtmgmtIf", "extmgmtIf", "extmgmt-intf", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin"], [u'networkElement'], [u'faultInst'], ["Get"]),
    "ExtmgmtIfMonPolicy": MoMeta("ExtmgmtIfMonPolicy", "extmgmtIfMonPolicy", "extmgmt-intf-monitor-policy", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'topSystem'], [u'extmgmtArpTargets', u'extmgmtGatewayPing', u'extmgmtMiiStatus', u'extmgmtNdiscTargets'], ["Get", "Set"]),
    "ExtmgmtMiiStatus": MoMeta("ExtmgmtMiiStatus", "extmgmtMiiStatus", "mii-status-policy", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'extmgmtIfMonPolicy'], [], ["Get", "Set"]),
    "ExtmgmtNdiscTargets": MoMeta("ExtmgmtNdiscTargets", "extmgmtNdiscTargets", "ndisc-target-policy", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'extmgmtIfMonPolicy'], [u'faultInst'], ["Get", "Set"]),
    "ExtpolClient": MoMeta("ExtpolClient", "extpolClient", "client-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'extpolClientCont'], [u'faultInst', u'observeObserved', u'policyPolicyScopeCont'], ["Get"]),
    "ExtpolClientCont": MoMeta("ExtpolClientCont", "extpolClientCont", "clients", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'extpolRegistry'], [u'extpolClient'], ["Get"]),
    "ExtpolController": MoMeta("ExtpolController", "extpolController", "contro-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'extpolControllerCont'], [u'observeObserved', u'policyPolicyScopeCont'], ["Get"]),
    "ExtpolControllerCont": MoMeta("ExtpolControllerCont", "extpolControllerCont", "controllers", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'extpolRegistry'], [u'extpolController'], ["Get"]),
    "ExtpolEp": MoMeta("ExtpolEp", "extpolEp", "extpol", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'eventInst', u'extpolEpFsm', u'extpolEpFsmTask', u'extpolRegistry', u'faultInst'], ["Get"]),
    "ExtpolEpFsm": MoMeta("ExtpolEpFsm", "extpolEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extpolEp'], [u'extpolEpFsmStage'], [None]),
    "ExtpolEpFsmStage": MoMeta("ExtpolEpFsmStage", "extpolEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extpolEpFsm'], [], [None]),
    "ExtpolEpFsmTask": MoMeta("ExtpolEpFsmTask", "extpolEpFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extpolEp'], [], [None]),
    "ExtpolProvider": MoMeta("ExtpolProvider", "extpolProvider", "prov-[type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'extpolProviderCont'], [u'eventInst', u'extpolProviderFsm', u'extpolProviderFsmTask', u'fabricVnetEpSyncEp', u'faultInst', u'observeObserved', u'policyPolicyScopeCont'], ["Get"]),
    "ExtpolProviderCont": MoMeta("ExtpolProviderCont", "extpolProviderCont", "providers", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'extpolRegistry'], [u'extpolProvider'], ["Get"]),
    "ExtpolProviderFsm": MoMeta("ExtpolProviderFsm", "extpolProviderFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extpolProvider'], [u'extpolProviderFsmStage'], [None]),
    "ExtpolProviderFsmStage": MoMeta("ExtpolProviderFsmStage", "extpolProviderFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extpolProviderFsm'], [], [None]),
    "ExtpolProviderFsmTask": MoMeta("ExtpolProviderFsmTask", "extpolProviderFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extpolProvider'], [], [None]),
    "ExtpolRegistry": MoMeta("ExtpolRegistry", "extpolRegistry", "reg", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'extpolEp'], [u'eventInst', u'extpolClientCont', u'extpolControllerCont', u'extpolProviderCont', u'extpolRegistryFsm', u'extpolRegistryFsmTask', u'faultInst', u'observeObserved', u'policyPolicyScopeCont'], ["Get"]),
    "ExtpolRegistryFsm": MoMeta("ExtpolRegistryFsm", "extpolRegistryFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extpolRegistry'], [u'extpolRegistryFsmStage'], [None]),
    "ExtpolRegistryFsmStage": MoMeta("ExtpolRegistryFsmStage", "extpolRegistryFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extpolRegistryFsm'], [], [None]),
    "ExtpolRegistryFsmTask": MoMeta("ExtpolRegistryFsmTask", "extpolRegistryFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extpolRegistry'], [], [None]),
    "ExtpolSystemContext": MoMeta("ExtpolSystemContext", "extpolSystemContext", "sysctx", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ExtvmmEp": MoMeta("ExtvmmEp", "extvmmEp", "extvm-mgmt", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "pn-policy"], [u'topSystem'], [u'eventInst', u'extvmmEpFsm', u'extvmmEpFsmTask', u'extvmmKeyStore', u'extvmmMasterExtKey', u'extvmmProvider', u'extvmmSwitchDelTask', u'extvmmSwitchSet', u'faultInst'], ["Get"]),
    "ExtvmmEpFsm": MoMeta("ExtvmmEpFsm", "extvmmEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extvmmEp'], [u'extvmmEpFsmStage'], [None]),
    "ExtvmmEpFsmStage": MoMeta("ExtvmmEpFsmStage", "extvmmEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extvmmEpFsm'], [], [None]),
    "ExtvmmEpFsmTask": MoMeta("ExtvmmEpFsmTask", "extvmmEpFsmTask", "task-[item]", VersionMeta.Version201m, "OutputOnly", 0x1, [], [""], [u'extvmmEp'], [], [None]),
    "ExtvmmFNDReference": MoMeta("ExtvmmFNDReference", "extvmmFNDReference", "fnd-ref-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], [u'extvmmUpLinkPP'], [u'faultInst'], ["Add", "Get", "Remove"]),
    "ExtvmmFabricNetwork": MoMeta("ExtvmmFabricNetwork", "extvmmFabricNetwork", "fabric-network-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'extvmmNetworkSets'], [u'extvmmFabricNetworkDefinition'], ["Add", "Get", "Remove", "Set"]),
    "ExtvmmFabricNetworkDefinition": MoMeta("ExtvmmFabricNetworkDefinition", "extvmmFabricNetworkDefinition", "fabric-network-def-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'extvmmFabricNetwork'], [u'extvmmVMNetworkDefinition'], ["Add", "Get", "Remove", "Set"]),
    "ExtvmmKeyInst": MoMeta("ExtvmmKeyInst", "extvmmKeyInst", "key-[inst]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["read-only"], [u'extvmmProvider'], [], ["Get"]),
    "ExtvmmKeyRing": MoMeta("ExtvmmKeyRing", "extvmmKeyRing", "keyring-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "pn-policy"], [u'extvmmKeyStore'], [], ["Add", "Get", "Remove", "Set"]),
    "ExtvmmKeyStore": MoMeta("ExtvmmKeyStore", "extvmmKeyStore", "key-store", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "pn-policy"], [u'extvmmEp'], [u'eventInst', u'extvmmKeyRing', u'extvmmKeyStoreFsm', u'extvmmKeyStoreFsmTask', u'faultInst'], ["Get"]),
    "ExtvmmKeyStoreFsm": MoMeta("ExtvmmKeyStoreFsm", "extvmmKeyStoreFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extvmmKeyStore'], [u'extvmmKeyStoreFsmStage'], [None]),
    "ExtvmmKeyStoreFsmStage": MoMeta("ExtvmmKeyStoreFsmStage", "extvmmKeyStoreFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extvmmKeyStoreFsm'], [], [None]),
    "ExtvmmKeyStoreFsmTask": MoMeta("ExtvmmKeyStoreFsmTask", "extvmmKeyStoreFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'extvmmKeyStore'], [], [None]),
    "ExtvmmMasterExtKey": MoMeta("ExtvmmMasterExtKey", "extvmmMasterExtKey", "ext-key", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "pn-policy"], [u'extvmmEp'], [u'eventInst', u'extvmmMasterExtKeyFsm', u'extvmmMasterExtKeyFsmTask', u'faultInst'], ["Get", "Set"]),
    "ExtvmmMasterExtKeyFsm": MoMeta("ExtvmmMasterExtKeyFsm", "extvmmMasterExtKeyFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extvmmMasterExtKey'], [u'extvmmMasterExtKeyFsmStage'], [None]),
    "ExtvmmMasterExtKeyFsmStage": MoMeta("ExtvmmMasterExtKeyFsmStage", "extvmmMasterExtKeyFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extvmmMasterExtKeyFsm'], [], [None]),
    "ExtvmmMasterExtKeyFsmTask": MoMeta("ExtvmmMasterExtKeyFsmTask", "extvmmMasterExtKeyFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'extvmmMasterExtKey'], [], [None]),
    "ExtvmmNetworkSets": MoMeta("ExtvmmNetworkSets", "extvmmNetworkSets", "network-sets", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricLanCloud'], [u'eventInst', u'extvmmFabricNetwork', u'extvmmNetworkSetsFsm', u'extvmmNetworkSetsFsmTask', u'faultInst', u'ippoolPool'], ["Get"]),
    "ExtvmmNetworkSetsFsm": MoMeta("ExtvmmNetworkSetsFsm", "extvmmNetworkSetsFsm", "fsm", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], [u'extvmmNetworkSets'], [u'extvmmNetworkSetsFsmStage'], [None]),
    "ExtvmmNetworkSetsFsmStage": MoMeta("ExtvmmNetworkSetsFsmStage", "extvmmNetworkSetsFsmStage", "stage-[name]", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], [u'extvmmNetworkSetsFsm'], [], [None]),
    "ExtvmmNetworkSetsFsmTask": MoMeta("ExtvmmNetworkSetsFsmTask", "extvmmNetworkSetsFsmTask", "task-[item]", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], [u'extvmmNetworkSets'], [], [None]),
    "ExtvmmProvider": MoMeta("ExtvmmProvider", "extvmmProvider", "vm-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], [u'extvmmEp'], [u'eventInst', u'extvmmKeyInst', u'extvmmProviderFsm', u'extvmmProviderFsmTask', u'faultInst', u'vmDC', u'vmDCOrg', u'vmSwitch'], ["Add", "Get", "Remove", "Set"]),
    "ExtvmmProviderFsm": MoMeta("ExtvmmProviderFsm", "extvmmProviderFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extvmmProvider'], [u'extvmmProviderFsmStage'], [None]),
    "ExtvmmProviderFsmStage": MoMeta("ExtvmmProviderFsmStage", "extvmmProviderFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extvmmProviderFsm'], [], [None]),
    "ExtvmmProviderFsmTask": MoMeta("ExtvmmProviderFsmTask", "extvmmProviderFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'extvmmProvider'], [], [None]),
    "ExtvmmSwitchDelTask": MoMeta("ExtvmmSwitchDelTask", "extvmmSwitchDelTask", "vsw-deltask-[sw_int_id]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], [u'extvmmEp'], [u'eventInst', u'extvmmSwitchDelTaskFsm', u'extvmmSwitchDelTaskFsmTask', u'faultInst'], ["Get", "Remove"]),
    "ExtvmmSwitchDelTaskFsm": MoMeta("ExtvmmSwitchDelTaskFsm", "extvmmSwitchDelTaskFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extvmmSwitchDelTask'], [u'extvmmSwitchDelTaskFsmStage'], [None]),
    "ExtvmmSwitchDelTaskFsmStage": MoMeta("ExtvmmSwitchDelTaskFsmStage", "extvmmSwitchDelTaskFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'extvmmSwitchDelTaskFsm'], [], [None]),
    "ExtvmmSwitchDelTaskFsmTask": MoMeta("ExtvmmSwitchDelTaskFsmTask", "extvmmSwitchDelTaskFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'extvmmSwitchDelTask'], [], ["Get"]),
    "ExtvmmSwitchSet": MoMeta("ExtvmmSwitchSet", "extvmmSwitchSet", "virtual-switches", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'extvmmEp'], [u'vmSwitch'], ["Get"]),
    "ExtvmmUpLinkPP": MoMeta("ExtvmmUpLinkPP", "extvmmUpLinkPP", "uplinkpp-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], [u'vmSwitch'], [u'extvmmFNDReference'], ["Add", "Get", "Remove", "Set"]),
    "ExtvmmVMNDRef": MoMeta("ExtvmmVMNDRef", "extvmmVMNDRef", "vm-network-def-ref[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'extvmmVMNetwork'], [u'faultInst'], ["Add", "Get", "Remove"]),
    "ExtvmmVMNetwork": MoMeta("ExtvmmVMNetwork", "extvmmVMNetwork", "vm-network-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'extvmmVMNetworkSets'], [u'extvmmVMNDRef', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "ExtvmmVMNetworkDefinition": MoMeta("ExtvmmVMNetworkDefinition", "extvmmVMNetworkDefinition", "vm-network-def-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'extvmmFabricNetworkDefinition'], [u'faultInst', u'vnicEtherIf'], ["Add", "Get", "Remove", "Set"]),
    "ExtvmmVMNetworkSets": MoMeta("ExtvmmVMNetworkSets", "extvmmVMNetworkSets", "vm-network-sets", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricLanCloud'], [u'extvmmVMNetwork'], ["Get"]),
    "FabricBHVlan": MoMeta("FabricBHVlan", "fabricBHVlan", "bhnet", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstcCloud'], [], ["Get"]),
    "FabricBreakout": MoMeta("FabricBreakout", "fabricBreakout", "breakout-slot-[slot_id]-port-[port_id]", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], [u'fabricCablingSw'], [], [None]),
    "FabricCabling": MoMeta("FabricCabling", "fabricCabling", "Cabling", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], [u'fabricEp'], [u'fabricCablingSw', u'statsThresholdPolicy'], [None]),
    "FabricCablingSw": MoMeta("FabricCablingSw", "fabricCablingSw", "[id]", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], [u'fabricCabling'], [u'fabricBreakout'], [None]),
    "FabricCartridgePhEp": MoMeta("FabricCartridgePhEp", "fabricCartridgePhEp", "cart-ep-ven-[vendor]-mod-[model]-ser-[serial]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricDceSrv'], [u'fabricLastAckedSlot', u'faultInst'], ["Get", "Set"]),
    "FabricCartridgeSlotEp": MoMeta("FabricCartridgeSlotEp", "fabricCartridgeSlotEp", "cart-slot-[slot_id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricChassisEp'], [u'eventInst', u'fabricCartridgeSlotEpFsm', u'fabricCartridgeSlotEpFsmTask', u'fabricComputeMSlotEp', u'fabricIf', u'faultInst'], ["Get", "Set"]),
    "FabricCartridgeSlotEpFsm": MoMeta("FabricCartridgeSlotEpFsm", "fabricCartridgeSlotEpFsm", "fsm", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], [u'fabricCartridgeSlotEp'], [u'fabricCartridgeSlotEpFsmStage'], [None]),
    "FabricCartridgeSlotEpFsmStage": MoMeta("FabricCartridgeSlotEpFsmStage", "fabricCartridgeSlotEpFsmStage", "stage-[name]", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], [u'fabricCartridgeSlotEpFsm'], [], [None]),
    "FabricCartridgeSlotEpFsmTask": MoMeta("FabricCartridgeSlotEpFsmTask", "fabricCartridgeSlotEpFsmTask", "task-[item]", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], [u'fabricCartridgeSlotEp'], [], [None]),
    "FabricCdpLinkPolicy": MoMeta("FabricCdpLinkPolicy", "fabricCdpLinkPolicy", "", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "read-only"], [], [], [None]),
    "FabricChangedObjectRef": MoMeta("FabricChangedObjectRef", "fabricChangedObjectRef", "ChangedObjectRef[id]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [u'fabricVnetEpSyncEp'], [], [None]),
    "FabricChassisEp": MoMeta("FabricChassisEp", "fabricChassisEp", "chassis-[chassis_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'fabricDceSrv'], [u'fabricCartridgeSlotEp', u'fabricComputeSlotEp', u'faultInst'], ["Get"]),
    "FabricComputeMSlotEp": MoMeta("FabricComputeMSlotEp", "fabricComputeMSlotEp", "ins-[server_instance_id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricCartridgeSlotEp'], [u'eventInst', u'fabricComputeMSlotEpFsm', u'fabricComputeMSlotEpFsmTask', u'fabricIf', u'faultInst'], ["Get", "Set"]),
    "FabricComputeMSlotEpFsm": MoMeta("FabricComputeMSlotEpFsm", "fabricComputeMSlotEpFsm", "fsm", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], [u'fabricComputeMSlotEp'], [u'fabricComputeMSlotEpFsmStage'], [None]),
    "FabricComputeMSlotEpFsmStage": MoMeta("FabricComputeMSlotEpFsmStage", "fabricComputeMSlotEpFsmStage", "stage-[name]", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], [u'fabricComputeMSlotEpFsm'], [], [None]),
    "FabricComputeMSlotEpFsmTask": MoMeta("FabricComputeMSlotEpFsmTask", "fabricComputeMSlotEpFsmTask", "task-[item]", VersionMeta.Version251a, "OutputOnly", 0x1, [], [""], [u'fabricComputeMSlotEp'], [], [None]),
    "FabricComputePhEp": MoMeta("FabricComputePhEp", "fabricComputePhEp", "compute-ep-ven-[vendor]-mod-[model]-ser-[serial]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricDceSrv'], [u'fabricLastAckedSlot', u'faultInst'], ["Get", "Set"]),
    "FabricComputeSlotEp": MoMeta("FabricComputeSlotEp", "fabricComputeSlotEp", "slot-[slot_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricChassisEp'], [u'eventInst', u'fabricComputeSlotEpFsm', u'fabricComputeSlotEpFsmTask', u'fabricIf', u'faultInst'], ["Get", "Set"]),
    "FabricComputeSlotEpFsm": MoMeta("FabricComputeSlotEpFsm", "fabricComputeSlotEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'fabricComputeSlotEp'], [u'fabricComputeSlotEpFsmStage'], [None]),
    "FabricComputeSlotEpFsmStage": MoMeta("FabricComputeSlotEpFsmStage", "fabricComputeSlotEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'fabricComputeSlotEpFsm'], [], [None]),
    "FabricComputeSlotEpFsmTask": MoMeta("FabricComputeSlotEpFsmTask", "fabricComputeSlotEpFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'fabricComputeSlotEp'], [], [None]),
    "FabricDceSrv": MoMeta("FabricDceSrv", "fabricDceSrv", "server", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], [u'fabricEp'], [u'etherSwIfConfig', u'fabricCartridgePhEp', u'fabricChassisEp', u'fabricComputePhEp', u'fabricDceSwSrv', u'fabricSwChPhEp', u'statsThresholdPolicy'], ["Get"]),
    "FabricDceSwSrv": MoMeta("FabricDceSwSrv", "fabricDceSwSrv", "sw-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], [u'fabricDceSrv'], [u'fabricDceSwSrvEp', u'fabricDceSwSrvPc', u'fabricSubGroup'], ["Get"]),
    "FabricDceSwSrvEp": MoMeta("FabricDceSwSrvEp", "fabricDceSwSrvEp", "slot-[slot_id]-port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricDceSwSrv', u'fabricSubGroup'], [u'fabricEthMonSrcEp', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricDceSwSrvPc": MoMeta("FabricDceSwSrvPc", "fabricDceSwSrvPc", "pc-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricDceSwSrv'], [u'fabricDceSwSrvPcEp', u'fabricSubGroup', u'faultInst'], ["Get"]),
    "FabricDceSwSrvPcEp": MoMeta("FabricDceSwSrvPcEp", "fabricDceSwSrvPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricDceSwSrvPc', u'fabricSubGroup'], [u'faultInst'], ["Get"]),
    "FabricEp": MoMeta("FabricEp", "fabricEp", "fabric", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'dcxUniverse', u'etherPortChanIdUniverse', u'fabricCabling', u'fabricDceSrv', u'fabricEpMgr', u'fabricEthEstcCloud', u'fabricFcEstcCloud', u'fabricLanAccessMgr', u'fabricLanCloud', u'fabricLanMonCloud', u'fabricSanCloud', u'fabricSanMonCloud', u'fabricZoneIdUniverse'], ["Get"]),
    "FabricEpMgr": MoMeta("FabricEpMgr", "fabricEpMgr", "[id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin"], [u'fabricEp'], [u'eventInst', u'fabricEpMgrFsm', u'fabricEpMgrFsmTask', u'faultInst'], ["Get"]),
    "FabricEpMgrFsm": MoMeta("FabricEpMgrFsm", "fabricEpMgrFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'fabricEpMgr'], [u'fabricEpMgrFsmStage'], [None]),
    "FabricEpMgrFsmStage": MoMeta("FabricEpMgrFsmStage", "fabricEpMgrFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'fabricEpMgrFsm'], [], [None]),
    "FabricEpMgrFsmTask": MoMeta("FabricEpMgrFsmTask", "fabricEpMgrFsmTask", "task-[item]", VersionMeta.Version201m, "OutputOnly", 0x1, [], [""], [u'fabricEpMgr'], [], [None]),
    "FabricEthEstc": MoMeta("FabricEthEstc", "fabricEthEstc", "[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricEthEstcCloud'], [u'fabricEthEstcEp', u'fabricEthEstcPc', u'fabricSubGroup', u'fabricVlan'], ["Get"]),
    "FabricEthEstcCloud": MoMeta("FabricEthEstcCloud", "fabricEthEstcCloud", "eth-estc", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEp'], [u'fabricEthEstc', u'fabricVlan', u'nwctrlDefinition', u'statsThresholdPolicy'], ["Get"]),
    "FabricEthEstcEp": MoMeta("FabricEthEstcEp", "fabricEthEstcEp", "phys-eth-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthEstc', u'fabricSubGroup'], [u'fabricEthMonSrcEp', u'fabricEthTargetEp', u'fabricVlanEp', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthEstcPc": MoMeta("FabricEthEstcPc", "fabricEthEstcPc", "pc-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthEstc'], [u'etherErrStats', u'etherLossStats', u'etherPauseStats', u'etherRxStats', u'etherTxStats', u'fabricEthEstcPcEp', u'fabricEthMonSrcEp', u'fabricEthTargetEp', u'fabricSubGroup', u'fabricVlanEp', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthEstcPcEp": MoMeta("FabricEthEstcPcEp", "fabricEthEstcPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthEstcPc', u'fabricSubGroup'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthFlowMonLan": MoMeta("FabricEthFlowMonLan", "fabricEthFlowMonLan", "[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLanFlowMonitoring'], [], [None]),
    "FabricEthLan": MoMeta("FabricEthLan", "fabricEthLan", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricLanCloud'], [u'etherSwIfConfig', u'fabricEthLanEp', u'fabricEthLanPc', u'fabricNetGroup', u'fabricSubGroup', u'fabricVlan', u'faultInst'], ["Get"]),
    "FabricEthLanEp": MoMeta("FabricEthLanEp", "fabricEthLanEp", "phys-slot-[slot_id]-port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLan', u'fabricSubGroup'], [u'fabricEthMonSrcEp', u'fabricVlanEp', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthLanFlowMonitoring": MoMeta("FabricEthLanFlowMonitoring", "fabricEthLanFlowMonitoring", "eth-flow-monitoring", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricLanMonCloud'], [u'fabricEthFlowMonLan', u'fabricFlowMonDefinition', u'fabricFlowMonExporterProfile', u'fabricNetflowCollector', u'fabricNetflowMonExporter', u'fabricNetflowMonSession', u'fabricNetflowMonitor', u'fabricNetflowTimeoutPolicy'], [None]),
    "FabricEthLanPc": MoMeta("FabricEthLanPc", "fabricEthLanPc", "pc-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLan'], [u'etherErrStats', u'etherLossStats', u'etherPauseStats', u'etherRxStats', u'etherTxStats', u'fabricEthLanPcEp', u'fabricEthMonSrcEp', u'fabricSubGroup', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthLanPcEp": MoMeta("FabricEthLanPcEp", "fabricEthLanPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLanPc', u'fabricSubGroup'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthLinkProfile": MoMeta("FabricEthLinkProfile", "fabricEthLinkProfile", "eth-link-prof-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricLanCloud'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMon": MoMeta("FabricEthMon", "fabricEthMon", "eth-mon-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthMonLan'], [u'fabricEthMonDestEp', u'fabricEthMonFiltRef', u'fabricEthMonSrcRef', u'fabricSubGroup', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMonDestEp": MoMeta("FabricEthMonDestEp", "fabricEthMonDestEp", "dest-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], [u'fabricEthMon', u'fabricFcMon', u'fabricSubGroup'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMonFiltEp": MoMeta("FabricEthMonFiltEp", "fabricEthMonFiltEp", "", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricVlan'], [], ["Get"]),
    "FabricEthMonFiltRef": MoMeta("FabricEthMonFiltRef", "fabricEthMonFiltRef", "", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'fabricEthMon'], [], ["Get"]),
    "FabricEthMonLan": MoMeta("FabricEthMonLan", "fabricEthMonLan", "[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricLanMonCloud'], [u'fabricEthMon'], ["Get"]),
    "FabricEthMonSrcEp": MoMeta("FabricEthMonSrcEp", "fabricEthMonSrcEp", "mon-src-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'adaptorExtEthIf', u'fabricDceSwSrvEp', u'fabricEthEstcEp', u'fabricEthEstcPc', u'fabricEthLanEp', u'fabricEthLanPc', u'fabricFcoeEstcEp', u'fabricFcoeSanEp', u'fabricFcoeSanPc', u'fabricVlan', u'vmNic', u'vnicEther', u'vnicFc', u'vnicIScsi', u'vnicIScsiLCP', u'vnicIpc', u'vnicScsi'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMonSrcRef": MoMeta("FabricEthMonSrcRef", "fabricEthMonSrcRef", "src-ref-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthMon'], [], ["Get"]),
    "FabricEthTargetEp": MoMeta("FabricEthTargetEp", "fabricEthTargetEp", "eth-target-ep-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthEstcEp', u'fabricEthEstcPc'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthVlanPc": MoMeta("FabricEthVlanPc", "fabricEthVlanPc", "pc-switch-[switch_id]-pc-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricNetGroup', u'fabricVlan'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthVlanPortEp": MoMeta("FabricEthVlanPortEp", "fabricEthVlanPortEp", "phys-switch-[switch_id]-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricNetGroup', u'fabricSwSubGroup', u'fabricVlan'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcEndpoint": MoMeta("FabricFcEndpoint", "fabricFcEndpoint", "endpoint-[wwpn]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcUserZone'], [], [None]),
    "FabricFcEstc": MoMeta("FabricFcEstc", "fabricFcEstc", "[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstcCloud'], [u'fabricFcEstcEp', u'fabricFcoeEstcEp', u'fabricSubGroup', u'fabricVsan'], ["Get"]),
    "FabricFcEstcCloud": MoMeta("FabricFcEstcCloud", "fabricFcEstcCloud", "fc-estc", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricEp'], [u'fabricBHVlan', u'fabricFcEstc', u'fabricFcZoneProfile', u'fabricVsan', u'statsThresholdPolicy'], ["Get"]),
    "FabricFcEstcEp": MoMeta("FabricFcEstcEp", "fabricFcEstcEp", "phys-fc-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstc'], [u'fabricFcMonSrcEp', u'fabricVsanEp', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcMon": MoMeta("FabricFcMon", "fabricFcMon", "fc-mon-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcMonSan'], [u'fabricEthMonDestEp', u'fabricFcMonDestEp', u'fabricFcMonFiltRef', u'fabricFcMonSrcRef', u'fabricSubGroup', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcMonDestEp": MoMeta("FabricFcMonDestEp", "fabricFcMonDestEp", "dest-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcMon'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcMonFiltEp": MoMeta("FabricFcMonFiltEp", "fabricFcMonFiltEp", "", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricVsan'], [], ["Get"]),
    "FabricFcMonFiltRef": MoMeta("FabricFcMonFiltRef", "fabricFcMonFiltRef", "", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'fabricFcMon'], [], ["Get"]),
    "FabricFcMonSan": MoMeta("FabricFcMonSan", "fabricFcMonSan", "[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricSanMonCloud'], [u'fabricFcMon'], ["Get"]),
    "FabricFcMonSrcEp": MoMeta("FabricFcMonSrcEp", "fabricFcMonSrcEp", "mon-src-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstcEp', u'fabricFcSanEp', u'fabricFcSanPc', u'fabricVsan', u'vmNic', u'vnicEther', u'vnicFc', u'vnicIScsi', u'vnicIScsiLCP', u'vnicIpc', u'vnicScsi'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricFcMonSrcRef": MoMeta("FabricFcMonSrcRef", "fabricFcMonSrcRef", "src-ref-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricFcMon'], [], ["Get"]),
    "FabricFcSan": MoMeta("FabricFcSan", "fabricFcSan", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricSanCloud'], [u'fabricFcSanEp', u'fabricFcSanPc', u'fabricFcoeSanEp', u'fabricFcoeSanPc', u'fabricSubGroup', u'fabricVsan', u'faultInst'], ["Get", "Set"]),
    "FabricFcSanEp": MoMeta("FabricFcSanEp", "fabricFcSanEp", "phys-slot-[slot_id]-port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcSan'], [u'fabricFcMonSrcEp', u'fabricVsanEp', u'fabricVsanMembership', u'faultInst'], ["Add", "Get", "Set"]),
    "FabricFcSanPc": MoMeta("FabricFcSanPc", "fabricFcSanPc", "pc-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcSan'], [u'fabricFcMonSrcEp', u'fabricFcSanPcEp', u'fabricVsanEp', u'fabricVsanMembership', u'faultInst', u'fcErrStats', u'fcStats'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcSanPcEp": MoMeta("FabricFcSanPcEp", "fabricFcSanPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcSanPc'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcUserZone": MoMeta("FabricFcUserZone", "fabricFcUserZone", "zone-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcZoneProfile'], [u'fabricFcEndpoint', u'faultInst', u'storageVsanRef'], [None]),
    "FabricFcVsanPc": MoMeta("FabricFcVsanPc", "fabricFcVsanPc", "pc-switch-[switch_id]-pc-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricVsan'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcVsanPortEp": MoMeta("FabricFcVsanPortEp", "fabricFcVsanPortEp", "phys-switch-[switch_id]-slot-[slot_id]-port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricVsan'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcZoneProfile": MoMeta("FabricFcZoneProfile", "fabricFcZoneProfile", "zone-profile-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstcCloud'], [u'fabricFcUserZone', u'faultInst'], [None]),
    "FabricFcoeEstcEp": MoMeta("FabricFcoeEstcEp", "fabricFcoeEstcEp", "phys-fcoe-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstc', u'fabricSubGroup'], [u'etherFcoeInterfaceStats', u'fabricEthMonSrcEp', u'fabricVsanEp', u'fabricVsanMembership', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeSanEp": MoMeta("FabricFcoeSanEp", "fabricFcoeSanEp", "phys-fcoesanep-slot-[slot_id]-port-[port_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcSan', u'fabricSubGroup'], [u'etherFcoeInterfaceStats', u'fabricEthMonSrcEp', u'fabricVsanEp', u'fabricVsanMembership', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeSanPc": MoMeta("FabricFcoeSanPc", "fabricFcoeSanPc", "fcoesanpc-[port_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcSan'], [u'etherFcoeInterfaceStats', u'fabricEthMonSrcEp', u'fabricFcoeSanPcEp', u'fabricSubGroup', u'fabricVsanEp', u'fabricVsanMembership', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeSanPcEp": MoMeta("FabricFcoeSanPcEp", "fabricFcoeSanPcEp", "fcoesanpcep-slot-[slot_id]-port-[port_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcoeSanPc', u'fabricSubGroup'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeVsanPc": MoMeta("FabricFcoeVsanPc", "fabricFcoeVsanPc", "fcoepc-switch-[switch_id]-fcoepc-[port_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricVsan'], [u'faultInst'], ["Add", "Get", "Set"]),
    "FabricFcoeVsanPortEp": MoMeta("FabricFcoeVsanPortEp", "fabricFcoeVsanPortEp", "phys-fcoe-switch-[switch_id]-slot-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricSwSubGroup', u'fabricVsan'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFlowMonDefinition": MoMeta("FabricFlowMonDefinition", "fabricFlowMonDefinition", "flow-record-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLanFlowMonitoring'], [], ["Get"]),
    "FabricFlowMonExporterProfile": MoMeta("FabricFlowMonExporterProfile", "fabricFlowMonExporterProfile", "flow-exporter-profile-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLanFlowMonitoring'], [u'vnicEtherIf'], [None]),
    "FabricIf": MoMeta("FabricIf", "fabricIf", "mgmt-if-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'fabricCartridgeSlotEp', u'fabricComputeMSlotEp', u'fabricComputeSlotEp'], [], ["Get"]),
    "FabricLacpPolicy": MoMeta("FabricLacpPolicy", "fabricLacpPolicy", "lacp-[name]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricLanAccessMgr": MoMeta("FabricLanAccessMgr", "fabricLanAccessMgr", "lan-access", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEp'], [], [None]),
    "FabricLanCloud": MoMeta("FabricLanCloud", "fabricLanCloud", "lan", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEp'], [u'eventInst', u'extvmmNetworkSets', u'extvmmVMNetworkSets', u'fabricEthLan', u'fabricEthLinkProfile', u'fabricLanCloudFsm', u'fabricLanCloudFsmTask', u'fabricLanPinGroup', u'fabricNetGroup', u'fabricUdldLinkPolicy', u'fabricVlan', u'faultInst', u'flowctrlDefinition', u'mgmtInbandProfile', u'qosclassDefinition', u'statsThresholdPolicy', u'vnicProfileSet'], ["Get", "Set"]),
    "FabricLanCloudFsm": MoMeta("FabricLanCloudFsm", "fabricLanCloudFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'fabricLanCloud'], [u'fabricLanCloudFsmStage'], [None]),
    "FabricLanCloudFsmStage": MoMeta("FabricLanCloudFsmStage", "fabricLanCloudFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'fabricLanCloudFsm'], [], [None]),
    "FabricLanCloudFsmTask": MoMeta("FabricLanCloudFsmTask", "fabricLanCloudFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'fabricLanCloud'], [], [None]),
    "FabricLanCloudPolicy": MoMeta("FabricLanCloudPolicy", "fabricLanCloudPolicy", "lan-policy", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'orgOrg'], [], [None]),
    "FabricLanMonCloud": MoMeta("FabricLanMonCloud", "fabricLanMonCloud", "lanmon", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEp'], [u'fabricEthLanFlowMonitoring', u'fabricEthMonLan', u'statsThresholdPolicy'], ["Get"]),
    "FabricLanPinGroup": MoMeta("FabricLanPinGroup", "fabricLanPinGroup", "lan-pin-group-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricLanCloud'], [u'fabricLanPinTarget', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricLanPinTarget": MoMeta("FabricLanPinTarget", "fabricLanPinTarget", "target-[fabric_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricLanPinGroup'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricLastAckedSlot": MoMeta("FabricLastAckedSlot", "fabricLastAckedSlot", "last-acked-slot", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'fabricCartridgePhEp', u'fabricComputePhEp'], [], ["Get"]),
    "FabricLocale": MoMeta("FabricLocale", "fabricLocale", "fabric-[switch_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'equipmentFex', u'mgmtController'], [u'adaptorExtEthIfPc', u'dcxVc', u'fabricPath'], ["Get"]),
    "FabricMulticastPolicy": MoMeta("FabricMulticastPolicy", "fabricMulticastPolicy", "mc-policy-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'orgOrg'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricNetGroup": MoMeta("FabricNetGroup", "fabricNetGroup", "net-group-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLan', u'fabricLanCloud'], [u'fabricEthVlanPc', u'fabricEthVlanPortEp', u'fabricPooledVlan', u'fabricSwSubGroup', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricNetflowCollector": MoMeta("FabricNetflowCollector", "fabricNetflowCollector", "flow-collector-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLanFlowMonitoring'], [u'ipIpV4StaticTargetAddr'], [None]),
    "FabricNetflowIPv4Addr": MoMeta("FabricNetflowIPv4Addr", "fabricNetflowIPv4Addr", "ipv4-addr-[fabric_id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'adaptorHostIscsiIf', u'adaptorVlan', u'swVlan', u'vnicEtherIf', u'vnicIPv4If'], [], [None]),
    "FabricNetflowMonExporter": MoMeta("FabricNetflowMonExporter", "fabricNetflowMonExporter", "lanFlowMonExporter-eth-netflow-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLanFlowMonitoring'], [u'faultInst'], [None]),
    "FabricNetflowMonExporterRef": MoMeta("FabricNetflowMonExporterRef", "fabricNetflowMonExporterRef", "flow-exporter-[nf_mon_exporter_name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricNetflowMonitor'], [u'faultInst'], [None]),
    "FabricNetflowMonSession": MoMeta("FabricNetflowMonSession", "fabricNetflowMonSession", "netflow-mon-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLanFlowMonitoring'], [u'fabricNetflowMonSrcRef', u'fabricNetflowMonitorRef', u'faultInst'], [None]),
    "FabricNetflowMonSrcEp": MoMeta("FabricNetflowMonSrcEp", "fabricNetflowMonSrcEp", "flow-mon-src-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'vnicEther', u'vnicFc', u'vnicIScsi', u'vnicIScsiLCP', u'vnicIpc', u'vnicProfile', u'vnicScsi'], [], [None]),
    "FabricNetflowMonSrcRef": MoMeta("FabricNetflowMonSrcRef", "fabricNetflowMonSrcRef", "flow-mon-src-ref-[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricNetflowMonSession'], [], [None]),
    "FabricNetflowMonitor": MoMeta("FabricNetflowMonitor", "fabricNetflowMonitor", "lanflowmon-eth-netflow-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLanFlowMonitoring'], [u'fabricNetflowMonExporterRef', u'faultInst'], ["Get"]),
    "FabricNetflowMonitorRef": MoMeta("FabricNetflowMonitorRef", "fabricNetflowMonitorRef", "flow-monitor-[nf_monitor_name]-dir-[direction]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricNetflowMonSession'], [u'faultInst'], [None]),
    "FabricNetflowTimeoutPolicy": MoMeta("FabricNetflowTimeoutPolicy", "fabricNetflowTimeoutPolicy", "flow-timeout-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLanFlowMonitoring'], [], [None]),
    "FabricOrgVlanPolicy": MoMeta("FabricOrgVlanPolicy", "fabricOrgVlanPolicy", "org-vlan-policy", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-network"], [u'orgOrg'], [], ["Get", "Set"]),
    "FabricPath": MoMeta("FabricPath", "fabricPath", "path-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'fabricLocale'], [u'dcxVc', u'fabricPathConn', u'fabricPathEp'], ["Get"]),
    "FabricPathConn": MoMeta("FabricPathConn", "fabricPathConn", "xc-[c_type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'fabricPath'], [u'fabricPathEp'], ["Get"]),
    "FabricPathEp": MoMeta("FabricPathEp", "fabricPathEp", "ep-[c_type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'fabricPath', u'fabricPathConn'], [u'portTrustMode'], ["Get"]),
    "FabricPoolableVlan": MoMeta("FabricPoolableVlan", "fabricPoolableVlan", "pool-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'fabricVlan'], [], [None]),
    "FabricPooledVlan": MoMeta("FabricPooledVlan", "fabricPooledVlan", "net-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricNetGroup'], [u'faultInst'], ["Add", "Get", "Remove"]),
    "FabricSanCloud": MoMeta("FabricSanCloud", "fabricSanCloud", "san", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricEp'], [u'eventInst', u'fabricFcSan', u'fabricSanCloudFsm', u'fabricSanCloudFsmTask', u'fabricSanPinGroup', u'fabricVsan', u'faultInst', u'statsThresholdPolicy'], ["Get", "Set"]),
    "FabricSanCloudFsm": MoMeta("FabricSanCloudFsm", "fabricSanCloudFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'fabricSanCloud'], [u'fabricSanCloudFsmStage'], [None]),
    "FabricSanCloudFsmStage": MoMeta("FabricSanCloudFsmStage", "fabricSanCloudFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'fabricSanCloudFsm'], [], [None]),
    "FabricSanCloudFsmTask": MoMeta("FabricSanCloudFsmTask", "fabricSanCloudFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], [u'fabricSanCloud'], [], [None]),
    "FabricSanMonCloud": MoMeta("FabricSanMonCloud", "fabricSanMonCloud", "sanmon", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricEp'], [u'fabricFcMonSan', u'statsThresholdPolicy'], ["Get"]),
    "FabricSanPinGroup": MoMeta("FabricSanPinGroup", "fabricSanPinGroup", "san-pin-group-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricSanCloud'], [u'fabricSanPinTarget', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricSanPinTarget": MoMeta("FabricSanPinTarget", "fabricSanPinTarget", "target-[fabric_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricSanPinGroup'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricSubGroup": MoMeta("FabricSubGroup", "fabricSubGroup", "slot-[slot_id]-aggr-port-[aggr_port_id]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy", "ls-network", "ls-network-policy"], [u'fabricDceSwSrv', u'fabricDceSwSrvPc', u'fabricEthEstc', u'fabricEthEstcPc', u'fabricEthLan', u'fabricEthLanPc', u'fabricEthMon', u'fabricFcEstc', u'fabricFcMon', u'fabricFcSan', u'fabricFcoeSanPc'], [u'fabricDceSwSrvEp', u'fabricDceSwSrvPcEp', u'fabricEthEstcEp', u'fabricEthEstcPcEp', u'fabricEthLanEp', u'fabricEthLanPcEp', u'fabricEthMonDestEp', u'fabricFcoeEstcEp', u'fabricFcoeSanEp', u'fabricFcoeSanPcEp'], ["Add", "Get"]),
    "FabricSwChPhEp": MoMeta("FabricSwChPhEp", "fabricSwChPhEp", "chassis-ep-ven-[vendor]-mod[model]-ser-[serial]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricDceSrv'], [u'faultInst'], ["Get", "Set"]),
    "FabricSwSubGroup": MoMeta("FabricSwSubGroup", "fabricSwSubGroup", "sw-[switch_id]-slot-[slot_id]-aggr-port-[aggr_port_id]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricNetGroup', u'fabricVlan', u'fabricVsan'], [u'fabricEthVlanPortEp', u'fabricFcoeVsanPortEp'], [None]),
    "FabricUdldLinkPolicy": MoMeta("FabricUdldLinkPolicy", "fabricUdldLinkPolicy", "udld-link-pol-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "read-only"], [u'fabricLanCloud'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricUdldPolicy": MoMeta("FabricUdldPolicy", "fabricUdldPolicy", "udld-policy", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'orgOrg'], [], ["Get", "Set"]),
    "FabricVCon": MoMeta("FabricVCon", "fabricVCon", "vcon-[id]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ext-lan-policy", "ls-config-policy", "ls-network", "ls-network-policy", "ls-server-policy", "ls-storage-policy"], [u'fabricVConProfile', u'lsServer'], [], ["Add", "Get", "Set"]),
    "FabricVConProfile": MoMeta("FabricVConProfile", "fabricVConProfile", "vcon-profile-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ext-lan-policy", "ls-network", "ls-network-policy", "ls-server-policy", "ls-storage-policy"], [u'orgOrg'], [u'fabricVCon'], ["Add", "Get", "Remove", "Set"]),
    "FabricVlan": MoMeta("FabricVlan", "fabricVlan", "net-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthEstc', u'fabricEthEstcCloud', u'fabricEthLan', u'fabricLanCloud'], [u'fabricEthMonFiltEp', u'fabricEthMonSrcEp', u'fabricEthVlanPc', u'fabricEthVlanPortEp', u'fabricPoolableVlan', u'fabricSwSubGroup', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricVlanEp": MoMeta("FabricVlanEp", "fabricVlanEp", "vlan-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'fabricEthEstcEp', u'fabricEthEstcPc', u'fabricEthLanEp'], [], ["Get"]),
    "FabricVlanGroupReq": MoMeta("FabricVlanGroupReq", "fabricVlanGroupReq", "vlan-group-req-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-network"], [u'orgOrg'], [u'faultInst'], ["Add", "Get", "Remove"]),
    "FabricVlanPermit": MoMeta("FabricVlanPermit", "fabricVlanPermit", "perm-[cloud]sw-[switch_id]net-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], [""], [u'orgOrg'], [], [None]),
    "FabricVlanReq": MoMeta("FabricVlanReq", "fabricVlanReq", "vlan-req-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-network"], [u'orgOrg'], [u'faultInst'], ["Add", "Get", "Remove"]),
    "FabricVnetEpSyncEp": MoMeta("FabricVnetEpSyncEp", "fabricVnetEpSyncEp", "syncEp", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [u'extpolProvider'], [u'eventInst', u'fabricChangedObjectRef', u'fabricVnetEpSyncEpFsm', u'fabricVnetEpSyncEpFsmTask', u'faultInst'], [None]),
    "FabricVnetEpSyncEpFsm": MoMeta("FabricVnetEpSyncEpFsm", "fabricVnetEpSyncEpFsm", "fsm", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], [u'fabricVnetEpSyncEp'], [u'fabricVnetEpSyncEpFsmStage'], [None]),
    "FabricVnetEpSyncEpFsmStage": MoMeta("FabricVnetEpSyncEpFsmStage", "fabricVnetEpSyncEpFsmStage", "stage-[name]", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], [u'fabricVnetEpSyncEpFsm'], [], [None]),
    "FabricVnetEpSyncEpFsmTask": MoMeta("FabricVnetEpSyncEpFsmTask", "fabricVnetEpSyncEpFsmTask", "task-[item]", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], [u'fabricVnetEpSyncEp'], [], [None]),
    "FabricVsan": MoMeta("FabricVsan", "fabricVsan", "net-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstc', u'fabricFcEstcCloud', u'fabricFcSan', u'fabricSanCloud'], [u'fabricFcMonFiltEp', u'fabricFcMonSrcEp', u'fabricFcVsanPc', u'fabricFcVsanPortEp', u'fabricFcoeVsanPc', u'fabricFcoeVsanPortEp', u'fabricSwSubGroup', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricVsanEp": MoMeta("FabricVsanEp", "fabricVsanEp", "vsan-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'fabricFcEstcEp', u'fabricFcSanEp', u'fabricFcSanPc', u'fabricFcoeEstcEp', u'fabricFcoeSanEp', u'fabricFcoeSanPc'], [u'faultInst'], ["Get"]),
    "FabricVsanMembership": MoMeta("FabricVsanMembership", "fabricVsanMembership", "vsanmember-[vsan_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'fabricFcSanEp', u'fabricFcSanPc', u'fabricFcoeEstcEp', u'fabricFcoeSanEp', u'fabricFcoeSanPc'], [u'faultInst'], [None]),
    "FabricZoneIdUniverse": MoMeta("FabricZoneIdUniverse", "fabricZoneIdUniverse", "zone-id-universe", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'fabricEp'], [], [None]),
    "FaultAffectedClass": MoMeta("FaultAffectedClass", "faultAffectedClass", "fault-[mo_class_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "fault"], [u'faultSuppressPolicy'], [], [None]),
    "FaultHolder": MoMeta("FaultHolder", "faultHolder", "fault", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "fault"], [u'topRoot'], [u'faultLocalTypedHolder', u'faultPolicy', u'faultSuppressPolicy', u'faultSuppressTask'], ["Get"]),
    "FaultInst": MoMeta("FaultInst", "faultInst", "fault-[code]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "fault", "operations"], [u'aaaAuthRealm', u'aaaConsoleAuth', u'aaaDefaultAuth', u'aaaDomain', u'aaaDomainAuth', u'aaaLdapEp', u'aaaLocale', u'aaaOrg', u'aaaProviderGroup', u'aaaRadiusEp', u'aaaRole', u'aaaTacacsPlusEp', u'aaaUser', u'aaaUserEp', u'aaaUserLocale', u'aaaUserRole', u'adaptorExtEthIf', u'adaptorHostEthIf', u'adaptorHostFcIf', u'adaptorHostIscsiIf', u'adaptorHostScsiIf', u'adaptorHostServiceEthIf', u'adaptorUnit', u'adaptorUnitExtn', u'adaptorVlan', u'callhomeEp', u'capabilityCatalogue', u'capabilityMgmtExtension', u'capabilityUpdater', u'cimcvmediaActualMountEntry', u'commDateTime', u'commSnmp', u'commSnmpUser', u'commSvcEp', u'computeAutoconfigPolicy', u'computeBlade', u'computeBladeInheritPolicy', u'computeBoard', u'computeExtBoard', u'computeFwSyncAck', u'computeIOHub', u'computePool', u'computeRackUnit', u'computeRtcBattery', u'computeServerDiscPolicy', u'computeServerUnit', u'cpmaintAck', u'dcxNs', u'dcxVIf', u'dcxVc', u'epqosDefinition', u'epqosDefinitionDelTask', u'equipmentAutoconfigPolicy', u'equipmentBeaconLed', u'equipmentChassis', u'equipmentChassisInheritPolicy', u'equipmentChassisIssues', u'equipmentChassisProfile', u'equipmentFan', u'equipmentFanModule', u'equipmentFex', u'equipmentHealthLed', u'equipmentIOCard', u'equipmentLocatorLed', u'equipmentPsu', u'equipmentRequirement', u'equipmentSharedIOModule', u'equipmentSwitchCard', u'equipmentSwitchIOCard', u'equipmentSystemIOController', u'equipmentTpm', u'etherPIo', u'etherServerIntFIo', u'etherSwitchIntFIo', u'etherSwitchIntFIoPc', u'extmgmtArpTargets', u'extmgmtIf', u'extmgmtNdiscTargets', u'extpolClient', u'extpolEp', u'extpolProvider', u'extpolRegistry', u'extvmmEp', u'extvmmFNDReference', u'extvmmKeyStore', u'extvmmMasterExtKey', u'extvmmNetworkSets', u'extvmmProvider', u'extvmmSwitchDelTask', u'extvmmVMNDRef', u'extvmmVMNetwork', u'extvmmVMNetworkDefinition', u'fabricCartridgePhEp', u'fabricCartridgeSlotEp', u'fabricChassisEp', u'fabricComputeMSlotEp', u'fabricComputePhEp', u'fabricComputeSlotEp', u'fabricDceSwSrvEp', u'fabricDceSwSrvPc', u'fabricDceSwSrvPcEp', u'fabricEpMgr', u'fabricEthEstcEp', u'fabricEthEstcPc', u'fabricEthEstcPcEp', u'fabricEthLan', u'fabricEthLanEp', u'fabricEthLanPc', u'fabricEthLanPcEp', u'fabricEthLinkProfile', u'fabricEthMon', u'fabricEthMonDestEp', u'fabricEthTargetEp', u'fabricEthVlanPc', u'fabricEthVlanPortEp', u'fabricFcEstcEp', u'fabricFcMon', u'fabricFcMonDestEp', u'fabricFcSan', u'fabricFcSanEp', u'fabricFcSanPc', u'fabricFcSanPcEp', u'fabricFcUserZone', u'fabricFcVsanPc', u'fabricFcVsanPortEp', u'fabricFcZoneProfile', u'fabricFcoeEstcEp', u'fabricFcoeSanEp', u'fabricFcoeSanPc', u'fabricFcoeSanPcEp', u'fabricFcoeVsanPc', u'fabricFcoeVsanPortEp', u'fabricLanCloud', u'fabricLanPinGroup', u'fabricLanPinTarget', u'fabricMulticastPolicy', u'fabricNetGroup', u'fabricNetflowMonExporter', u'fabricNetflowMonExporterRef', u'fabricNetflowMonSession', u'fabricNetflowMonitor', u'fabricNetflowMonitorRef', u'fabricPooledVlan', u'fabricSanCloud', u'fabricSanPinGroup', u'fabricSanPinTarget', u'fabricSwChPhEp', u'fabricVlan', u'fabricVlanGroupReq', u'fabricVlanReq', u'fabricVnetEpSyncEp', u'fabricVsan', u'fabricVsanEp', u'fabricVsanMembership', u'faultSuppressTask', u'fcPIo', u'fcpoolAddr', u'fcpoolInitiators', u'firmwareAck', u'firmwareAutoSyncPolicy', u'firmwareBootUnit', u'firmwareDistributable', u'firmwareDownloader', u'firmwareImage', u'firmwareInfra', u'firmwarePackItem', u'firmwareStatus', u'firmwareSystem', u'firmwareUpdatable', u'flowctrlItem', u'gmetaHolder', u'identIdentRequest', u'identMetaSystem', u'ippoolAddr', u'ippoolIpV6Addr', u'ippoolPool', u'iqnpoolAddr', u'iqnpoolPool', u'licenseDownloader', u'licenseFile', u'licenseInstance', u'lsBinding', u'lsIdentityInfo', u'lsIssues', u'lsRequirement', u'lsServer', u'lsmaintAck', u'lsmaintMaintPolicy', u'lstorageDasScsiLun', u'lstorageProfileBinding', u'macpoolAddr', u'macpoolPool', u'memoryArray', u'memoryBufferUnit', u'memoryUnit', u'mgmtBackup', u'mgmtBackupPolicy', u'mgmtBackupPolicyConfig', u'mgmtCfgExportPolicy', u'mgmtConnection', u'mgmtController', u'mgmtEntity', u'mgmtHealthStatus', u'mgmtIPv6IfAddr', u'mgmtIf', u'mgmtImporter', u'mgmtInterface', u'mgmtMgmtDbState', u'mgmtPmonEntry', u'morefImportRoot', u'networkElement', u'networkOperLevel', u'nfsMountDef', u'nfsMountInst', u'observeObserved', u'pkiEp', u'pkiKeyRing', u'pkiTP', u'policyControlEp', u'policyControlledType', u'policyPolicyScope', u'powerBudget', u'powerChassisMember', u'powerGroup', u'powerPolicy', u'processorUnit', u'qosclassDefinition', u'statsCollectionPolicy', u'storageConnectionDef', u'storageConnectionPolicy', u'storageController', u'storageEnclosure', u'storageEnclosureDiskSlotEp', u'storageFlexFlashCard', u'storageFlexFlashController', u'storageFlexFlashDrive', u'storageFlexFlashVirtualDrive', u'storageIniGroup', u'storageInitiator', u'storageItem', u'storageLocalDisk', u'storageLocalDiskSlotEp', u'storageMezzFlashLife', u'storageRaidBattery', u'storageSasExpander', u'storageSystem', u'storageVDMemberEp', u'storageVirtualDrive', u'storageVsanRef', u'swAccessDomain', u'swEthLanBorder', u'swEthLanFlowMon', u'swEthMon', u'swEthTargetEp', u'swExtUtility', u'swFcMon', u'swFcSanBorder', u'swPhys', u'swSystemStats', u'swUtilityDomain', u'swVlan', u'swVlanPortNs', u'syntheticFsObj', u'sysdebugAutoCoreFileExportTarget', u'sysdebugCore', u'sysdebugLogControlEp', u'sysdebugLogExportPolicy', u'sysdebugLogExportStatus', u'sysdebugMEpLog', u'sysdebugManualCoreFileExportTarget', u'sysdebugTechSupport', u'sysfileMutation', u'trigTest', u'uuidpoolAddr', u'uuidpoolPool', u'vmLifeCyclePolicy', u'vmNic', u'vmVif', u'vnicConnDef', u'vnicDynamicConPolicyRef', u'vnicEthConfig', u'vnicEther', u'vnicEtherIf', u'vnicFc', u'vnicFcGroupDef', u'vnicFcGroupTempl', u'vnicFcIf', u'vnicFcNode', u'vnicIPv4PooledIscsiAddr', u'vnicIScsi', u'vnicIScsiBootVnic', u'vnicIScsiConfig', u'vnicIScsiLCP', u'vnicIScsiNode', u'vnicIScsiStaticTargetIf', u'vnicIpV4MgmtPooledAddr', u'vnicIpV4PooledAddr', u'vnicIpV6MgmtPooledAddr', u'vnicIpc', u'vnicLanConnTempl', u'vnicProfile', u'vnicProfileSet', u'vnicSanConnTempl', u'vnicScsi', u'vnicUsnicConPolicyRef', u'vnicVmqConPolicyRef'], [], ["Get"]),
    "FaultLocalTypedHolder": MoMeta("FaultLocalTypedHolder", "faultLocalTypedHolder", "type-[type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "fault"], [u'faultHolder'], [], [None]),
    "FaultPolicy": MoMeta("FaultPolicy", "faultPolicy", "fault-policy", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "fault"], [u'faultHolder'], [], ["Get", "Set"]),
    "FaultSuppressPolicy": MoMeta("FaultSuppressPolicy", "faultSuppressPolicy", "fault-suppress-policy-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'faultHolder'], [u'faultAffectedClass', u'faultSuppressPolicyItem'], [None]),
    "FaultSuppressPolicyItem": MoMeta("FaultSuppressPolicyItem", "faultSuppressPolicyItem", "item-[type]-[cause]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'faultSuppressPolicy'], [], [None]),
    "FaultSuppressTask": MoMeta("FaultSuppressTask", "faultSuppressTask", "fault-suppress-task-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "fault"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'equipmentFex', u'equipmentIOCard', u'faultHolder', u'lsServer', u'orgOrg'], [u'faultInst', u'trigLocalSched'], ["Add", "Get", "Remove", "Set"]),
    "FcErrStats": MoMeta("FcErrStats", "fcErrStats", "err-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'fabricFcSanPc', u'fcPIo'], [u'fcErrStatsHist'], ["Get"]),
    "FcErrStatsHist": MoMeta("FcErrStatsHist", "fcErrStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'fcErrStats'], [], ["Get"]),
    "FcNicIfConfig": MoMeta("FcNicIfConfig", "fcNicIfConfig", "if-config", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "FcPIo": MoMeta("FcPIo", "fcPIo", "port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'portGroup', u'portSubGroup'], [u'equipmentXcvr', u'eventInst', u'faultInst', u'fcErrStats', u'fcPIoFsm', u'fcStats', u'lldpAcquired', u'networkIfStats', u'portDomainEp', u'portPIoFsm', u'portPIoFsmTask'], ["Get"]),
    "FcPIoFsm": MoMeta("FcPIoFsm", "fcPIoFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'fcPIo'], [u'fcPIoFsmStage'], [None]),
    "FcPIoFsmStage": MoMeta("FcPIoFsmStage", "fcPIoFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'fcPIoFsm'], [], [None]),
    "FcStats": MoMeta("FcStats", "fcStats", "stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'fabricFcSanPc', u'fcPIo'], [u'fcStatsHist'], ["Get"]),
    "FcStatsHist": MoMeta("FcStatsHist", "fcStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'fcStats'], [], ["Get"]),
    "FcSwIfConfig": MoMeta("FcSwIfConfig", "fcSwIfConfig", "if-config", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "FcpoolAddr": MoMeta("FcpoolAddr", "fcpoolAddr", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'fcpoolUniverse'], [u'faultInst', u'fcpoolPoolable'], ["Get"]),
    "FcpoolBlock": MoMeta("FcpoolBlock", "fcpoolBlock", "block-[r_from]-[to]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], [u'fcpoolInitiators'], [u'fcpoolBootTarget'], ["Add", "Get", "Remove"]),
    "FcpoolBootTarget": MoMeta("FcpoolBootTarget", "fcpoolBootTarget", "target-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], [u'fcpoolBlock', u'fcpoolInitiator'], [], ["Get"]),
    "FcpoolFormat": MoMeta("FcpoolFormat", "fcpoolFormat", "format-[format]-[mask]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], [u'fcpoolUniverse'], [], ["Get"]),
    "FcpoolInitiator": MoMeta("FcpoolInitiator", "fcpoolInitiator", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], [u'fcpoolInitiators'], [u'fcpoolBootTarget', u'fcpoolInitiatorEp'], ["Add", "Get", "Remove", "Set"]),
    "FcpoolInitiatorEp": MoMeta("FcpoolInitiatorEp", "fcpoolInitiatorEp", "[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'fcpoolInitiator'], [], [None]),
    "FcpoolInitiators": MoMeta("FcpoolInitiators", "fcpoolInitiators", "wwn-pool-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], [u'orgOrg'], [u'faultInst', u'fcpoolBlock', u'fcpoolInitiator'], ["Add", "Get", "Remove", "Set"]),
    "FcpoolPoolable": MoMeta("FcpoolPoolable", "fcpoolPoolable", "pool-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'fcpoolAddr'], [], ["Get"]),
    "FcpoolUniverse": MoMeta("FcpoolUniverse", "fcpoolUniverse", "wwn", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'fcpoolAddr', u'fcpoolFormat'], ["Get"]),
    "FeatureContextEp": MoMeta("FeatureContextEp", "featureContextEp", "contexts", VersionMeta.Version302a, "InputOutput", 0x1, [], [""], [u'topSystem'], [u'featureDefinitionInstance', u'featureFruCapProviderInstance', u'featureProviderInstance'], [None]),
    "FeatureDefinition": MoMeta("FeatureDefinition", "featureDefinition", "feature-[name]-revision-[revision]", VersionMeta.Version302a, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue'], [], [None]),
    "FeatureDefinitionInstance": MoMeta("FeatureDefinitionInstance", "featureDefinitionInstance", "feature-[name]-revision-[revision]", VersionMeta.Version302a, "InputOutput", 0x1, [], [""], [u'featureContextEp'], [], [None]),
    "FeatureDefinitionRef": MoMeta("FeatureDefinitionRef", "featureDefinitionRef", "feature-[name]-revision-[revision]", VersionMeta.Version302a, "InputOutput", 0x1, [], [""], [u'featureProvider'], [], [None]),
    "FeatureFruCapProviderInstance": MoMeta("FeatureFruCapProviderInstance", "featureFruCapProviderInstance", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version302a, "InputOutput", 0x1, [], [""], [u'featureContextEp'], [], [None]),
    "FeatureFruCapProviderRef": MoMeta("FeatureFruCapProviderRef", "featureFruCapProviderRef", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version302a, "InputOutput", 0x1, [], [""], [u'featureProvider'], [], [None]),
    "FeatureProvider": MoMeta("FeatureProvider", "featureProvider", "prov-[name]", VersionMeta.Version302a, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue'], [u'featureDefinitionRef', u'featureFruCapProviderRef'], [None]),
    "FeatureProviderInstance": MoMeta("FeatureProviderInstance", "featureProviderInstance", "inst-[name]", VersionMeta.Version302a, "InputOutput", 0x1, [], [""], [u'featureContextEp'], [], [None]),
    "FirmwareAck": MoMeta("FirmwareAck", "firmwareAck", "ack", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'firmwareSystem'], [u'faultInst', u'trigLocalSched'], ["Get", "Set"]),
    "FirmwareActivity": MoMeta("FirmwareActivity", "firmwareActivity", "fw-activity", VersionMeta.Version251a, "InputOutput", 0x1, [], ["admin"], [u'equipmentChassis'], [], [None]),
    "FirmwareAutoSyncPolicy": MoMeta("FirmwareAutoSyncPolicy", "firmwareAutoSyncPolicy", "fw-auto-sync", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [u'orgOrg'], [u'faultInst'], ["Get", "Set"]),
    "FirmwareBlade": MoMeta("FirmwareBlade", "firmwareBlade", "fw-blade", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'firmwareHost'], [], ["Get"]),
    "FirmwareBootDefinition": MoMeta("FirmwareBootDefinition", "firmwareBootDefinition", "fw-boot-def", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'adaptorHostEthIf', u'adaptorHostFcIf', u'biosUnit', u'capabilityCatalogue', u'capabilityMgmtExtension', u'equipmentPsu', u'graphicsCard', u'mgmtController', u'storageController', u'storageLocalDisk', u'storageOnboardDevice', u'storageSasExpander'], [u'firmwareBootUnit', u'firmwareUcscInfo'], ["Get"]),
    "FirmwareBootUnit": MoMeta("FirmwareBootUnit", "firmwareBootUnit", "bootunit-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'firmwareBootDefinition'], [u'faultInst', u'firmwareInstallable'], ["Get", "Set"]),
    "FirmwareBundleInfo": MoMeta("FirmwareBundleInfo", "firmwareBundleInfo", "bundle-[type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], [], [], [None]),
    "FirmwareBundleInfoDigest": MoMeta("FirmwareBundleInfoDigest", "firmwareBundleInfoDigest", "bundleinfo-[type]-version-[version]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "FirmwareBundleType": MoMeta("FirmwareBundleType", "firmwareBundleType", "-type-[type]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], [u'firmwareBundleTypeCapProvider', u'firmwarePlatformBundleTypeCapProvider'], [], ["Get"]),
    "FirmwareBundleTypeCapProvider": MoMeta("FirmwareBundleTypeCapProvider", "firmwareBundleTypeCapProvider", "bundle-type-cap", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue'], [u'firmwareBundleType', u'firmwareChassisComponentSpec', u'firmwareComponentSpec'], ["Get"]),
    "FirmwareCatalogPack": MoMeta("FirmwareCatalogPack", "firmwareCatalogPack", "fw-catalog-pack-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "operations"], [u'orgOrg'], [u'firmwarePackItem'], ["Get", "Set"]),
    "FirmwareCatalogue": MoMeta("FirmwareCatalogue", "firmwareCatalogue", "fw-catalogue", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [u'firmwareCompSource', u'firmwareDistributable', u'firmwareDownloader', u'firmwareImage', u'firmwareUcscInfo'], [None]),
    "FirmwareChassisComponentSpec": MoMeta("FirmwareChassisComponentSpec", "firmwareChassisComponentSpec", "chassis-component-spec-[type]", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'firmwareBundleTypeCapProvider'], [], [None]),
    "FirmwareChassisPack": MoMeta("FirmwareChassisPack", "firmwareChassisPack", "fw-chassis-pack-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'orgOrg'], [u'firmwareExcludeChassisComponent', u'firmwarePackItem'], [None]),
    "FirmwareCompSource": MoMeta("FirmwareCompSource", "firmwareCompSource", "source-[inv_tag]-ver-[version]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'firmwareCatalogue'], [u'firmwareCompTarget'], [None]),
    "FirmwareCompTarget": MoMeta("FirmwareCompTarget", "firmwareCompTarget", "target-[inv_tag]-ver-[version]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'firmwareCompSource'], [], [None]),
    "FirmwareComponentSpec": MoMeta("FirmwareComponentSpec", "firmwareComponentSpec", "component-spec-[type]", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], [u'firmwareBundleTypeCapProvider'], [], [None]),
    "FirmwareComputeHostPack": MoMeta("FirmwareComputeHostPack", "firmwareComputeHostPack", "fw-host-pack-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server-policy"], [u'orgOrg'], [u'firmwareExcludeServerComponent', u'firmwarePackItem'], ["Add", "Get", "Remove", "Set"]),
    "FirmwareComputeMgmtPack": MoMeta("FirmwareComputeMgmtPack", "firmwareComputeMgmtPack", "fw-mgmt-pack-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], [u'orgOrg'], [u'firmwarePackItem'], ["Add", "Get", "Remove", "Set"]),
    "FirmwareConstraints": MoMeta("FirmwareConstraints", "firmwareConstraints", "fw-constraints", VersionMeta.Version223a, "InputOutput", 0x1, [], [""], [u'diagSrvCapProvider', u'equipmentBladeCapProvider', u'equipmentCatalogCapProvider', u'equipmentChassisCapProvider', u'equipmentDbgPluginCapProvider', u'equipmentIOExpanderCapProvider', u'equipmentMgmtCapProvider', u'equipmentMgmtExtCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentStorageEncCapProvider', u'equipmentSwitchCapProvider'], [u'firmwarePCHStorageConfigConstraint', u'firmwareProcessorTypeConstraint', u'firmwareRackPowerCapConstraint', u'firmwareServerTypeConstraint', u'firmwareTPMConstraint', u'firmwareVicSlotConstraint', u'firmwareVnicCdnConstraint'], [None]),
    "FirmwareDependency": MoMeta("FirmwareDependency", "firmwareDependency", "dep-[ep]-[inv_tag]-[hw_vendor]|[hw_model]|[hw_revision]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'firmwareType'], [], ["Get"]),
    "FirmwareDistImage": MoMeta("FirmwareDistImage", "firmwareDistImage", "distimage-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'firmwareDistributable'], [], ["Get"]),
    "FirmwareDistributable": MoMeta("FirmwareDistributable", "firmwareDistributable", "distrib-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'firmwareCatalogue'], [u'eventInst', u'faultInst', u'firmwareDistImage', u'firmwareDistributableFsm', u'firmwareDistributableFsmTask'], ["Get", "Set"]),
    "FirmwareDistributableFsm": MoMeta("FirmwareDistributableFsm", "firmwareDistributableFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'firmwareDistributable'], [u'firmwareDistributableFsmStage'], [None]),
    "FirmwareDistributableFsmStage": MoMeta("FirmwareDistributableFsmStage", "firmwareDistributableFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'firmwareDistributableFsm'], [], [None]),
    "FirmwareDistributableFsmTask": MoMeta("FirmwareDistributableFsmTask", "firmwareDistributableFsmTask", "task-[item]", VersionMeta.Version131c, "OutputOnly", 0x1, [], [""], [u'firmwareDistributable'], [], [None]),
    "FirmwareDownloader": MoMeta("FirmwareDownloader", "firmwareDownloader", "dnld-[file_name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'firmwareCatalogue'], [u'eventInst', u'faultInst', u'firmwareDownloaderFsm', u'firmwareDownloaderFsmTask'], ["Add", "Get", "Remove"]),
    "FirmwareDownloaderFsm": MoMeta("FirmwareDownloaderFsm", "firmwareDownloaderFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'firmwareDownloader'], [u'firmwareDownloaderFsmStage'], [None]),
    "FirmwareDownloaderFsmStage": MoMeta("FirmwareDownloaderFsmStage", "firmwareDownloaderFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'firmwareDownloaderFsm'], [], [None]),
    "FirmwareDownloaderFsmTask": MoMeta("FirmwareDownloaderFsmTask", "firmwareDownloaderFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'firmwareDownloader'], [], [None]),
    "FirmwareExcludeChassisComponent": MoMeta("FirmwareExcludeChassisComponent", "firmwareExcludeChassisComponent", "exclude-chassis-component-[chassis_component]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'firmwareChassisPack'], [], [None]),
    "FirmwareExcludeServerComponent": MoMeta("FirmwareExcludeServerComponent", "firmwareExcludeServerComponent", "exclude-server-component-[server_component]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server-policy"], [u'firmwareComputeHostPack'], [], [None]),
    "FirmwareFileUnit": MoMeta("FirmwareFileUnit", "firmwareFileUnit", "fileunit-[type]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "FirmwareHost": MoMeta("FirmwareHost", "firmwareHost", "fw-host", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'firmwareSystem'], [u'firmwareBlade', u'firmwareRack'], ["Get"]),
    "FirmwareHostPackModImpact": MoMeta("FirmwareHostPackModImpact", "firmwareHostPackModImpact", "fw-sys-HostPackModImpact-[key_dn]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], [], [], [None]),
    "FirmwareImage": MoMeta("FirmwareImage", "firmwareImage", "image-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'firmwareCatalogue'], [u'eventInst', u'faultInst', u'firmwareImageFsm', u'firmwareImageFsmTask', u'firmwareInstallable'], ["Get", "Set"]),
    "FirmwareImageFsm": MoMeta("FirmwareImageFsm", "firmwareImageFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'firmwareImage'], [u'firmwareImageFsmStage'], [None]),
    "FirmwareImageFsmStage": MoMeta("FirmwareImageFsmStage", "firmwareImageFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'firmwareImageFsm'], [], [None]),
    "FirmwareImageFsmTask": MoMeta("FirmwareImageFsmTask", "firmwareImageFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'firmwareImage'], [], [None]),
    "FirmwareImageLock": MoMeta("FirmwareImageLock", "firmwareImageLock", "fw-imagelock[name]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis'], [], ["Get"]),
    "FirmwareInfra": MoMeta("FirmwareInfra", "firmwareInfra", "fw-infra", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'firmwareSystem'], [u'faultInst', u'trigLocalSched'], ["Get"]),
    "FirmwareInfraPack": MoMeta("FirmwareInfraPack", "firmwareInfraPack", "fw-infra-pack-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'orgOrg'], [u'firmwarePackItem'], ["Get", "Set"]),
    "FirmwareInstallImpact": MoMeta("FirmwareInstallImpact", "firmwareInstallImpact", "fw-sys-InstallImpact-[key_dn]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], [], [], ["Get"]),
    "FirmwareInstallable": MoMeta("FirmwareInstallable", "firmwareInstallable", "installable-[vendor]|[model]|[type]|[version]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'firmwareBootUnit', u'firmwareImage', u'firmwareUpdatable'], [u'firmwareUcscInfo'], ["Get"]),
    "FirmwarePCHStorageConfigConstraint": MoMeta("FirmwarePCHStorageConfigConstraint", "firmwarePCHStorageConfigConstraint", "constraint-pch-storage-config", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], [u'firmwareConstraints'], [], [None]),
    "FirmwarePackItem": MoMeta("FirmwarePackItem", "firmwarePackItem", "pack-image-[hw_vendor]|[hw_model]|[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'firmwareCatalogPack', u'firmwareChassisPack', u'firmwareComputeHostPack', u'firmwareComputeMgmtPack', u'firmwareInfraPack'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FirmwarePlatformBundleTypeCapProvider": MoMeta("FirmwarePlatformBundleTypeCapProvider", "firmwarePlatformBundleTypeCapProvider", "plat-bundle-type-cap-[platform_type]", VersionMeta.Version302a, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue'], [u'firmwareBundleType'], [None]),
    "FirmwareProcessorTypeConstraint": MoMeta("FirmwareProcessorTypeConstraint", "firmwareProcessorTypeConstraint", "constraint-processor-type-[type]", VersionMeta.Version224a, "InputOutput", 0x1, [], [""], [u'firmwareConstraints'], [], [None]),
    "FirmwareRack": MoMeta("FirmwareRack", "firmwareRack", "fw-rack", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'firmwareHost'], [], ["Get"]),
    "FirmwareRackPowerCapConstraint": MoMeta("FirmwareRackPowerCapConstraint", "firmwareRackPowerCapConstraint", "constraint-rack-powercap-config", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'firmwareConstraints'], [], [None]),
    "FirmwareRunning": MoMeta("FirmwareRunning", "firmwareRunning", "fw-[deployment]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'adaptorHostEthIf', u'adaptorHostFcIf', u'biosUnit', u'capabilityCatalogue', u'capabilityMgmtExtension', u'equipmentPsu', u'graphicsCard', u'mgmtController', u'storageController', u'storageFlexFlashController', u'storageLocalDisk', u'storageOnboardDevice', u'storageSasExpander'], [], ["Get"]),
    "FirmwareServerTypeConstraint": MoMeta("FirmwareServerTypeConstraint", "firmwareServerTypeConstraint", "constraint-server-type", VersionMeta.Version311e, "InputOutput", 0x1, [], [""], [u'firmwareConstraints'], [], [None]),
    "FirmwareSpec": MoMeta("FirmwareSpec", "firmwareSpec", "fw-spec-bundle-version-[bundle_version]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], [u'adaptorFruCapProvider'], [], ["Get"]),
    "FirmwareStatus": MoMeta("FirmwareStatus", "firmwareStatus", "fw-status", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'equipmentIOCard', u'equipmentPsu', u'networkElement', u'topSystem'], [u'faultInst'], ["Get"]),
    "FirmwareSystem": MoMeta("FirmwareSystem", "firmwareSystem", "fw-system", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], [u'topSystem'], [u'eventInst', u'faultInst', u'firmwareAck', u'firmwareHost', u'firmwareInfra', u'firmwareSystemCompCheckResult', u'firmwareSystemFsm', u'firmwareSystemFsmTask'], ["Get"]),
    "FirmwareSystemCompCheckResult": MoMeta("FirmwareSystemCompCheckResult", "firmwareSystemCompCheckResult", "fw-sys-CompCheckRes-[key_dn]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'firmwareSystem'], [], ["Get"]),
    "FirmwareSystemFsm": MoMeta("FirmwareSystemFsm", "firmwareSystemFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'firmwareSystem'], [u'firmwareSystemFsmStage'], [None]),
    "FirmwareSystemFsmStage": MoMeta("FirmwareSystemFsmStage", "firmwareSystemFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'firmwareSystemFsm'], [], [None]),
    "FirmwareSystemFsmTask": MoMeta("FirmwareSystemFsmTask", "firmwareSystemFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'firmwareSystem'], [], [None]),
    "FirmwareTPMConstraint": MoMeta("FirmwareTPMConstraint", "firmwareTPMConstraint", "constraint-tpm-revision-[tpm_revision]", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], [u'firmwareConstraints'], [], [None]),
    "FirmwareType": MoMeta("FirmwareType", "firmwareType", "fw-type-[inv_tag]", VersionMeta.Version101e, "InputOutput", 0x1, [], [""], [u'adaptorFruCapProvider', u'diagSrvCapProvider', u'equipmentBaseBoardCapProvider', u'equipmentBladeBiosCapProvider', u'equipmentBladeCapProvider', u'equipmentCatalogCapProvider', u'equipmentChassisCapProvider', u'equipmentDbgPluginCapProvider', u'equipmentFanModuleCapProvider', u'equipmentFexCapProvider', u'equipmentGemCapProvider', u'equipmentGraphicsCardCapProvider', u'equipmentHostIfCapProvider', u'equipmentIOCardCapProvider', u'equipmentIOExpanderCapProvider', u'equipmentLocalDiskCapProvider', u'equipmentLocalDiskControllerCapProvider', u'equipmentMemoryUnitCapProvider', u'equipmentMgmtCapProvider', u'equipmentMgmtExtCapProvider', u'equipmentOnboardDeviceDef', u'equipmentProcessorUnitCapProvider', u'equipmentPsuCapProvider', u'equipmentRackUnitCapProvider', u'equipmentSecurityUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentStorageEncCapProvider', u'equipmentStorageSasExpanderCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider', u'equipmentTpmCapProvider'], [u'firmwareDependency'], ["Get"]),
    "FirmwareUcscInfo": MoMeta("FirmwareUcscInfo", "firmwareUcscInfo", "ucsc-info", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin"], [u'firmwareBootDefinition', u'firmwareCatalogue', u'firmwareInstallable'], [], ["Get"]),
    "FirmwareUpdatable": MoMeta("FirmwareUpdatable", "firmwareUpdatable", "fw-updatable", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'biosUnit', u'equipmentPsu', u'mgmtController', u'storageOnboardDevice'], [u'faultInst', u'firmwareInstallable'], ["Get", "Set"]),
    "FirmwareUpgradeConstraint": MoMeta("FirmwareUpgradeConstraint", "firmwareUpgradeConstraint", "fw-upgrd-constr", VersionMeta.Version202m, "InputOutput", 0x1, [], [""], [u'adaptorFruCapProvider', u'diagSrvCapProvider', u'equipmentBaseBoardCapProvider', u'equipmentBladeBiosCapProvider', u'equipmentBladeCapProvider', u'equipmentCatalogCapProvider', u'equipmentChassisCapProvider', u'equipmentDbgPluginCapProvider', u'equipmentFanModuleCapProvider', u'equipmentFexCapProvider', u'equipmentGemCapProvider', u'equipmentGraphicsCardCapProvider', u'equipmentHostIfCapProvider', u'equipmentIOCardCapProvider', u'equipmentIOExpanderCapProvider', u'equipmentLocalDiskCapProvider', u'equipmentLocalDiskControllerCapProvider', u'equipmentMemoryUnitCapProvider', u'equipmentMgmtCapProvider', u'equipmentMgmtExtCapProvider', u'equipmentProcessorUnitCapProvider', u'equipmentPsuCapProvider', u'equipmentRackUnitCapProvider', u'equipmentSecurityUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentStorageEncCapProvider', u'equipmentStorageSasExpanderCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider', u'equipmentTpmCapProvider'], [], ["Get"]),
    "FirmwareUpgradeDetail": MoMeta("FirmwareUpgradeDetail", "firmwareUpgradeDetail", "id-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'firmwareUpgradeInfo'], [], ["Get"]),
    "FirmwareUpgradeInfo": MoMeta("FirmwareUpgradeInfo", "firmwareUpgradeInfo", "validate-upgrade", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'firmwareUpgradeDetail'], ["Get"]),
    "FirmwareVicSlotConstraint": MoMeta("FirmwareVicSlotConstraint", "firmwareVicSlotConstraint", "constraint-vic-slot-[vic_slot]", VersionMeta.Version227b, "InputOutput", 0x1, [], [""], [u'firmwareConstraints'], [], [None]),
    "FirmwareVnicCdnConstraint": MoMeta("FirmwareVnicCdnConstraint", "firmwareVnicCdnConstraint", "constraint-vnic-cdn-[type]", VersionMeta.Version224a, "InputOutput", 0x1, [], [""], [u'firmwareConstraints'], [], [None]),
    "FlowctrlDefinition": MoMeta("FlowctrlDefinition", "flowctrlDefinition", "flowctrl", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy"], [u'fabricLanCloud'], [u'flowctrlItem'], ["Get", "Set"]),
    "FlowctrlItem": MoMeta("FlowctrlItem", "flowctrlItem", "policy-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy"], [u'flowctrlDefinition'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FsmStatus": MoMeta("FsmStatus", "fsmStatus", "status-[converted_ep_ref]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [], [None]),
    "GmetaClass": MoMeta("GmetaClass", "gmetaClass", "class-[id]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], [u'gmetaHolder'], [u'gmetaProp'], [None]),
    "GmetaEp": MoMeta("GmetaEp", "gmetaEp", "gmeta", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'gmetaHolder', u'gmetaPolicyMapHolder'], [None]),
    "GmetaHolder": MoMeta("GmetaHolder", "gmetaHolder", "category-[category]-provider-[provider]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], [u'gmetaEp'], [u'eventInst', u'faultInst', u'gmetaClass', u'gmetaHolderFsm', u'gmetaHolderFsmTask'], [None]),
    "GmetaHolderFsm": MoMeta("GmetaHolderFsm", "gmetaHolderFsm", "fsm", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], [u'gmetaHolder'], [u'gmetaHolderFsmStage'], [None]),
    "GmetaHolderFsmStage": MoMeta("GmetaHolderFsmStage", "gmetaHolderFsmStage", "stage-[name]", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], [u'gmetaHolderFsm'], [], [None]),
    "GmetaHolderFsmTask": MoMeta("GmetaHolderFsmTask", "gmetaHolderFsmTask", "task-[item]", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], [u'gmetaHolder'], [], [None]),
    "GmetaPolicyMapElement": MoMeta("GmetaPolicyMapElement", "gmetaPolicyMapElement", "policymapelem-[name]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [u'gmetaPolicyMapHolder'], [], [None]),
    "GmetaPolicyMapHolder": MoMeta("GmetaPolicyMapHolder", "gmetaPolicyMapHolder", "policymapholder", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [u'gmetaEp'], [u'gmetaPolicyMapElement'], [None]),
    "GmetaProp": MoMeta("GmetaProp", "gmetaProp", "prop-[order]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], [u'gmetaClass'], [], [None]),
    "GraphicsCard": MoMeta("GraphicsCard", "graphicsCard", "graphics-card-[id]", VersionMeta.Version213a, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard'], [u'firmwareBootDefinition', u'firmwareRunning', u'graphicsController'], ["Get"]),
    "GraphicsController": MoMeta("GraphicsController", "graphicsController", "graphics-controller-[id]", VersionMeta.Version213a, "InputOutput", 0x1, [], ["read-only"], [u'graphicsCard'], [], ["Get"]),
    "HostimgPolicy": MoMeta("HostimgPolicy", "hostimgPolicy", "img-policy-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], [u'orgOrg'], [u'hostimgTarget'], ["Get"]),
    "HostimgTarget": MoMeta("HostimgTarget", "hostimgTarget", "target-[type]-comp-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], [u'hostimgPolicy'], [], ["Get"]),
    "IdentIdentCtx": MoMeta("IdentIdentCtx", "identIdentCtx", "IdCtx-[seq_num]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'identIdentRequest'], [], [None]),
    "IdentIdentRequest": MoMeta("IdentIdentRequest", "identIdentRequest", "IdentQ-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'identMetaSystem'], [u'eventInst', u'faultInst', u'identIdentCtx', u'identIdentRequestFsm', u'identIdentRequestFsmTask'], [None]),
    "IdentIdentRequestFsm": MoMeta("IdentIdentRequestFsm", "identIdentRequestFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'identIdentRequest'], [u'identIdentRequestFsmStage'], [None]),
    "IdentIdentRequestFsmStage": MoMeta("IdentIdentRequestFsmStage", "identIdentRequestFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'identIdentRequestFsm'], [], [None]),
    "IdentIdentRequestFsmTask": MoMeta("IdentIdentRequestFsmTask", "identIdentRequestFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'identIdentRequest'], [], [None]),
    "IdentMetaSystem": MoMeta("IdentMetaSystem", "identMetaSystem", "metasys", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'identMetaVerse'], [u'eventInst', u'faultInst', u'identIdentRequest', u'identMetaSystemFsm', u'identMetaSystemFsmTask'], [None]),
    "IdentMetaSystemFsm": MoMeta("IdentMetaSystemFsm", "identMetaSystemFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'identMetaSystem'], [u'identMetaSystemFsmStage'], [None]),
    "IdentMetaSystemFsmStage": MoMeta("IdentMetaSystemFsmStage", "identMetaSystemFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'identMetaSystemFsm'], [], [None]),
    "IdentMetaSystemFsmTask": MoMeta("IdentMetaSystemFsmTask", "identMetaSystemFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'identMetaSystem'], [], [None]),
    "IdentMetaVerse": MoMeta("IdentMetaVerse", "identMetaVerse", "metaverse", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'identMetaSystem'], [None]),
    "IdentRequestEp": MoMeta("IdentRequestEp", "identRequestEp", "IdentQ", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'lsServer'], [], [None]),
    "IdentSysInfo": MoMeta("IdentSysInfo", "identSysInfo", "", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ImgprovPolicy": MoMeta("ImgprovPolicy", "imgprovPolicy", "img-prov-policy-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], [u'orgOrg'], [u'imgprovTarget'], ["Get"]),
    "ImgprovTarget": MoMeta("ImgprovTarget", "imgprovTarget", "target-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], [u'imgprovPolicy'], [u'imgsecKey'], ["Get"]),
    "ImgsecKey": MoMeta("ImgsecKey", "imgsecKey", "key-[type]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], [u'imgprovTarget', u'imgsecPolicy'], [], ["Get"]),
    "ImgsecPolicy": MoMeta("ImgsecPolicy", "imgsecPolicy", "img-sec-policy-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], [u'orgOrg'], [u'imgsecKey'], ["Get"]),
    "InitiatorFcInitiatorEp": MoMeta("InitiatorFcInitiatorEp", "initiatorFcInitiatorEp", "fc-ini-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'initiatorGroupEp'], [u'storageEpUser'], [None]),
    "InitiatorGroupEp": MoMeta("InitiatorGroupEp", "initiatorGroupEp", "grp-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'initiatorRequestorEp'], [u'initiatorFcInitiatorEp', u'initiatorIScsiInitiatorEp', u'initiatorStoreEp', u'storageNodeEp'], [None]),
    "InitiatorIScsiInitiatorEp": MoMeta("InitiatorIScsiInitiatorEp", "initiatorIScsiInitiatorEp", "scsi-ini-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'initiatorGroupEp'], [u'storageEpUser'], [None]),
    "InitiatorLunEp": MoMeta("InitiatorLunEp", "initiatorLunEp", "lun-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'storageIScsiTargetIf'], [], [None]),
    "InitiatorMemberEp": MoMeta("InitiatorMemberEp", "initiatorMemberEp", "member-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'initiatorRequestorGrpEp'], [], [None]),
    "InitiatorRequestorEp": MoMeta("InitiatorRequestorEp", "initiatorRequestorEp", "req-sysid-[sys_id]-id-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'lsServer', u'storageSystem', u'topSystem'], [u'initiatorGroupEp'], [None]),
    "InitiatorRequestorGrpEp": MoMeta("InitiatorRequestorGrpEp", "initiatorRequestorGrpEp", "req-grp-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [u'initiatorMemberEp', u'initiatorUnitEp'], [None]),
    "InitiatorStoreEp": MoMeta("InitiatorStoreEp", "initiatorStoreEp", "store-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'initiatorGroupEp'], [], [None]),
    "InitiatorUnitEp": MoMeta("InitiatorUnitEp", "initiatorUnitEp", "unit-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'initiatorRequestorGrpEp'], [], [None]),
    "IpDnsSuffix": MoMeta("IpDnsSuffix", "ipDnsSuffix", "dns-suffix-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], [u'ippoolPool'], [], ["Add", "Get", "Remove", "Set"]),
    "IpIPv4Dns": MoMeta("IpIPv4Dns", "ipIPv4Dns", "ipv4-dns-[pref]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "IpIPv4WinsServer": MoMeta("IpIPv4WinsServer", "ipIPv4WinsServer", "wins-server-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], [u'ippoolPool'], [], ["Add", "Get", "Remove", "Set"]),
    "IpIpV4StaticAddr": MoMeta("IpIpV4StaticAddr", "ipIpV4StaticAddr", "addr-[addr]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [], [], ["Add", "Get", "Remove", "Set"]),
    "IpIpV4StaticTargetAddr": MoMeta("IpIpV4StaticTargetAddr", "ipIpV4StaticTargetAddr", "ipv4-addr", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricNetflowCollector'], [], [None]),
    "IpServiceIf": MoMeta("IpServiceIf", "ipServiceIf", "serv-ip-[addr]-port-[port]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'storageEtherIf'], [], [None]),
    "IppoolAddr": MoMeta("IppoolAddr", "ippoolAddr", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'ippoolUniverse'], [u'faultInst', u'ippoolPoolable'], ["Get"]),
    "IppoolBlock": MoMeta("IppoolBlock", "ippoolBlock", "block-[r_from]-[to]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], [u'ippoolPool'], [], ["Add", "Get", "Remove"]),
    "IppoolIpV6Addr": MoMeta("IppoolIpV6Addr", "ippoolIpV6Addr", "[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'ippoolUniverse'], [u'faultInst', u'ippoolPoolable'], [None]),
    "IppoolIpV6Block": MoMeta("IppoolIpV6Block", "ippoolIpV6Block", "v6block-[r_from]-[to]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], [u'ippoolPool'], [], ["Add", "Get", "Remove"]),
    "IppoolIpV6Pooled": MoMeta("IppoolIpV6Pooled", "ippoolIpV6Pooled", "[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'ippoolPool'], [], [None]),
    "IppoolPool": MoMeta("IppoolPool", "ippoolPool", "ip-pool-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], [u'extvmmNetworkSets', u'orgOrg'], [u'faultInst', u'ipDnsSuffix', u'ipIPv4WinsServer', u'ippoolBlock', u'ippoolIpV6Block', u'ippoolIpV6Pooled', u'ippoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "IppoolPoolable": MoMeta("IppoolPoolable", "ippoolPoolable", "pool-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'ippoolAddr', u'ippoolIpV6Addr'], [], ["Get"]),
    "IppoolPooled": MoMeta("IppoolPooled", "ippoolPooled", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'ippoolPool'], [], ["Get"]),
    "IppoolUniverse": MoMeta("IppoolUniverse", "ippoolUniverse", "ip", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'ippoolAddr', u'ippoolIpV6Addr'], ["Get"]),
    "IqnpoolAddr": MoMeta("IqnpoolAddr", "iqnpoolAddr", "[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [u'iqnpoolUniverse'], [u'faultInst', u'iqnpoolPoolable'], ["Get"]),
    "IqnpoolBlock": MoMeta("IqnpoolBlock", "iqnpoolBlock", "block-[suffix]-from-[r_from]-to-[to]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], [u'iqnpoolPool'], [], ["Add", "Get", "Remove"]),
    "IqnpoolFormat": MoMeta("IqnpoolFormat", "iqnpoolFormat", "format-[format]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin"], [u'iqnpoolUniverse'], [], ["Get"]),
    "IqnpoolPool": MoMeta("IqnpoolPool", "iqnpoolPool", "iqn-pool-[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], [u'orgOrg'], [u'faultInst', u'iqnpoolBlock', u'iqnpoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "IqnpoolPoolable": MoMeta("IqnpoolPoolable", "iqnpoolPoolable", "pool-[id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [u'iqnpoolAddr'], [], ["Get"]),
    "IqnpoolPooled": MoMeta("IqnpoolPooled", "iqnpoolPooled", "[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [u'iqnpoolPool'], [], ["Get"]),
    "IqnpoolTransportBlock": MoMeta("IqnpoolTransportBlock", "iqnpoolTransportBlock", "block-[suffix]-from-[r_from]-to-[to]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], [], [], [None]),
    "IqnpoolUniverse": MoMeta("IqnpoolUniverse", "iqnpoolUniverse", "iqn", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'iqnpoolAddr', u'iqnpoolFormat'], ["Get"]),
    "IscsiAuthProfile": MoMeta("IscsiAuthProfile", "iscsiAuthProfile", "iscsi-auth-profile-[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], [u'orgOrg'], [], ["Get"]),
    "LicenseContents": MoMeta("LicenseContents", "licenseContents", "contents-[feature_name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'licenseFile'], [u'licenseFeatureLine'], ["Get"]),
    "LicenseDownloader": MoMeta("LicenseDownloader", "licenseDownloader", "dnld-[file_name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin"], [u'licenseEp'], [u'eventInst', u'faultInst', u'licenseDownloaderFsm', u'licenseDownloaderFsmTask', u'licenseProp'], ["Get"]),
    "LicenseDownloaderFsm": MoMeta("LicenseDownloaderFsm", "licenseDownloaderFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'licenseDownloader'], [u'licenseDownloaderFsmStage'], [None]),
    "LicenseDownloaderFsmStage": MoMeta("LicenseDownloaderFsmStage", "licenseDownloaderFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'licenseDownloaderFsm'], [], [None]),
    "LicenseDownloaderFsmTask": MoMeta("LicenseDownloaderFsmTask", "licenseDownloaderFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], [u'licenseDownloader'], [], [None]),
    "LicenseEp": MoMeta("LicenseEp", "licenseEp", "license", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'licenseDownloader', u'licenseFeature', u'licenseFile', u'licenseServerHostId'], ["Get"]),
    "LicenseFeature": MoMeta("LicenseFeature", "licenseFeature", "feature-[name]-[vendor]-[version]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin"], [u'licenseEp'], [u'licenseInstance'], ["Get"]),
    "LicenseFeatureCapProvider": MoMeta("LicenseFeatureCapProvider", "licenseFeatureCapProvider", "feature-[feature_name]-[lic_vendor]|[lic_version]manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version141i, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue'], [], ["Get"]),
    "LicenseFeatureLine": MoMeta("LicenseFeatureLine", "licenseFeatureLine", "FeatureLine-[id]:[type]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'licenseContents'], [], ["Get"]),
    "LicenseFile": MoMeta("LicenseFile", "licenseFile", "file-[scope]:[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin"], [u'licenseEp'], [u'eventInst', u'faultInst', u'licenseContents', u'licenseFileFsm', u'licenseFileFsmTask', u'licenseSource'], ["Get"]),
    "LicenseFileFsm": MoMeta("LicenseFileFsm", "licenseFileFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'licenseFile'], [u'licenseFileFsmStage'], [None]),
    "LicenseFileFsmStage": MoMeta("LicenseFileFsmStage", "licenseFileFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'licenseFileFsm'], [], [None]),
    "LicenseFileFsmTask": MoMeta("LicenseFileFsmTask", "licenseFileFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], [u'licenseFile'], [], [None]),
    "LicenseInstance": MoMeta("LicenseInstance", "licenseInstance", "inst-[scope]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin"], [u'licenseFeature'], [u'eventInst', u'faultInst', u'licenseInstanceFsm', u'licenseInstanceFsmTask', u'licenseProp', u'licenseSourceFile', u'licenseTarget'], ["Get"]),
    "LicenseInstanceFsm": MoMeta("LicenseInstanceFsm", "licenseInstanceFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'licenseInstance'], [u'licenseInstanceFsmStage'], [None]),
    "LicenseInstanceFsmStage": MoMeta("LicenseInstanceFsmStage", "licenseInstanceFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'licenseInstanceFsm'], [], [None]),
    "LicenseInstanceFsmTask": MoMeta("LicenseInstanceFsmTask", "licenseInstanceFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], [u'licenseInstance'], [], [None]),
    "LicenseProp": MoMeta("LicenseProp", "licenseProp", "prop-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'licenseDownloader', u'licenseInstance'], [], ["Get"]),
    "LicenseServerHostId": MoMeta("LicenseServerHostId", "licenseServerHostId", "server-host-id-[scope]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'licenseEp'], [], ["Get"]),
    "LicenseSource": MoMeta("LicenseSource", "licenseSource", "source", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'licenseFile'], [], ["Get"]),
    "LicenseSourceFile": MoMeta("LicenseSourceFile", "licenseSourceFile", "src-[id]:[line]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'licenseInstance'], [], ["Get"]),
    "LicenseTarget": MoMeta("LicenseTarget", "licenseTarget", "slot-[slot_id]-aggr-port-[aggr_port_id]-port-[port_id]", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin"], [u'licenseInstance'], [], [None]),
    "LldpAcquired": MoMeta("LldpAcquired", "lldpAcquired", "lldp", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'etherPIo', u'etherServerIntFIo', u'fcPIo'], [], ["Get"]),
    "LsAgentPolicy": MoMeta("LsAgentPolicy", "lsAgentPolicy", "agent-policy-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], [u'orgOrg'], [], [None]),
    "LsBinding": MoMeta("LsBinding", "lsBinding", "pn", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "read-only"], [u'lsServer'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LsFcLocale": MoMeta("LsFcLocale", "lsFcLocale", "fc-local-[switch_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'lsServer'], [u'lsFcZoneGroup'], [None]),
    "LsFcZone": MoMeta("LsFcZone", "lsFcZone", "zone-[identity]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'lsZoneInitiatorMember'], [u'lsZoneTargetMember'], [None]),
    "LsFcZoneGroup": MoMeta("LsFcZoneGroup", "lsFcZoneGroup", "zone-group-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'lsFcLocale'], [u'lsZoneInitiatorMember'], [None]),
    "LsIdentityInfo": MoMeta("LsIdentityInfo", "lsIdentityInfo", "ls-identity-info", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'lsServer'], [u'faultInst'], ["Get"]),
    "LsIssues": MoMeta("LsIssues", "lsIssues", "config-issue", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'lsServer'], [u'faultInst'], ["Get"]),
    "LsPower": MoMeta("LsPower", "lsPower", "power", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-oper", "ls-server-policy", "pn-equipment", "pn-maintenance", "pn-policy"], [u'lsServer'], [], ["Get", "Set"]),
    "LsRequirement": MoMeta("LsRequirement", "lsRequirement", "pn-req", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "read-only"], [u'lsServer'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LsServer": MoMeta("LsServer", "lsServer", "ls-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'orgOrg'], [u'cimcvmediaMountConfigDef', u'computePowerSyncDef', u'eventInst', u'fabricVCon', u'faultInst', u'faultSuppressTask', u'identRequestEp', u'initiatorRequestorEp', u'lsBinding', u'lsFcLocale', u'lsIdentityInfo', u'lsIssues', u'lsPower', u'lsRequirement', u'lsServerAssocCtx', u'lsServerExtension', u'lsServerFsm', u'lsServerFsmTask', u'lsUuidHistory', u'lsVConAssign', u'lsVersionBeh', u'lsbootDef', u'lsmaintAck', u'lstorageProfileBinding', u'lstorageProfileDef', u'mgmtInterface', u'solConfig', u'storageIniGroup', u'storageLocalDiskConfigDef', u'storageVirtualDriveRef', u'vnicConnDef', u'vnicDefBeh', u'vnicDynamicCon', u'vnicEther', u'vnicFc', u'vnicFcNode', u'vnicIScsi', u'vnicIScsiBootParams', u'vnicIScsiLCP', u'vnicIScsiNode', u'vnicIpV4MgmtPooledAddr', u'vnicIpV4PooledAddr', u'vnicIpV4StaticAddr', u'vnicIpc', u'vnicScsi'], ["Add", "Get", "Remove", "Set"]),
    "LsServerAssocCtx": MoMeta("LsServerAssocCtx", "lsServerAssocCtx", "ls-assoc-ctx", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'lsServer'], [u'adaptorUnitAssocCtx', u'computePhysicalAssocCtx', u'processorUnitAssocCtx'], ["Get"]),
    "LsServerExtension": MoMeta("LsServerExtension", "lsServerExtension", "extension", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'lsServer'], [], ["Get", "Set"]),
    "LsServerFsm": MoMeta("LsServerFsm", "lsServerFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'lsServer'], [u'lsServerFsmStage'], [None]),
    "LsServerFsmStage": MoMeta("LsServerFsmStage", "lsServerFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'lsServerFsm'], [], [None]),
    "LsServerFsmTask": MoMeta("LsServerFsmTask", "lsServerFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], [u'lsServer'], [], [None]),
    "LsTier": MoMeta("LsTier", "lsTier", "tier-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy"], [u'orgOrg'], [u'lsServer'], [None]),
    "LsUuidHistory": MoMeta("LsUuidHistory", "lsUuidHistory", "uuid-history", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [u'lsServer'], [], [None]),
    "LsVConAssign": MoMeta("LsVConAssign", "lsVConAssign", "assign-[transport]-vnic-[vnic_name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'lsServer'], [], ["Get", "Set"]),
    "LsVersionBeh": MoMeta("LsVersionBeh", "lsVersionBeh", "ls-vers-beh", VersionMeta.Version201q, "InputOutput", 0x1, [], ["admin"], [u'lsServer'], [], ["Get", "Set"]),
    "LsZoneInitiatorMember": MoMeta("LsZoneInitiatorMember", "lsZoneInitiatorMember", "initiator-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'lsFcZoneGroup'], [u'lsFcZone'], [None]),
    "LsZoneTargetMember": MoMeta("LsZoneTargetMember", "lsZoneTargetMember", "target-[wwpn]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'lsFcZone'], [], [None]),
    "LsbootBootSecurity": MoMeta("LsbootBootSecurity", "lsbootBootSecurity", "boot-security", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootDef', u'lsbootPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootDef": MoMeta("LsbootDef", "lsbootDef", "boot-policy", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'lsServer'], [u'lsbootBootSecurity', u'lsbootEFIShell', u'lsbootIScsi', u'lsbootLan', u'lsbootSan', u'lsbootStorage', u'lsbootVirtualMedia'], ["Add", "Get", "Remove", "Set"]),
    "LsbootDefaultLocalImage": MoMeta("LsbootDefaultLocalImage", "lsbootDefaultLocalImage", "local-any", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootEFIShell": MoMeta("LsbootEFIShell", "lsbootEFIShell", "efi-shell", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootDef', u'lsbootPolicy'], [], [None]),
    "LsbootEmbeddedLocalDiskImage": MoMeta("LsbootEmbeddedLocalDiskImage", "lsbootEmbeddedLocalDiskImage", "embedded-local-jbod", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [u'lsbootEmbeddedLocalDiskImagePath'], [None]),
    "LsbootEmbeddedLocalDiskImagePath": MoMeta("LsbootEmbeddedLocalDiskImagePath", "lsbootEmbeddedLocalDiskImagePath", "diskimgpath-[type]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootEmbeddedLocalDiskImage'], [], [None]),
    "LsbootEmbeddedLocalLunImage": MoMeta("LsbootEmbeddedLocalLunImage", "lsbootEmbeddedLocalLunImage", "embedded-local-lun", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [], [None]),
    "LsbootIScsi": MoMeta("LsbootIScsi", "lsbootIScsi", "iscsi", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootDef', u'lsbootPolicy'], [u'lsbootIScsiImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootIScsiImagePath": MoMeta("LsbootIScsiImagePath", "lsbootIScsiImagePath", "path-[type]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootIScsi'], [u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLan": MoMeta("LsbootLan", "lsbootLan", "lan", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootDef', u'lsbootPolicy'], [u'lsbootLanImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLanImagePath": MoMeta("LsbootLanImagePath", "lsbootLanImagePath", "path-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLan'], [u'lsbootUEFIBootParam', u'vnicIpV4StaticAddr'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalDiskImage": MoMeta("LsbootLocalDiskImage", "lsbootLocalDiskImage", "local-jbod", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [u'lsbootLocalDiskImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalDiskImagePath": MoMeta("LsbootLocalDiskImagePath", "lsbootLocalDiskImagePath", "diskimgpath-[type]", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalDiskImage'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalHddImage": MoMeta("LsbootLocalHddImage", "lsbootLocalHddImage", "local-hdd", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [u'lsbootLocalLunImagePath', u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalLunImagePath": MoMeta("LsbootLocalLunImagePath", "lsbootLocalLunImagePath", "lunimgpath-[type]", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalHddImage'], [u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalStorage": MoMeta("LsbootLocalStorage", "lsbootLocalStorage", "local-storage", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootStorage'], [u'lsbootDefaultLocalImage', u'lsbootEmbeddedLocalDiskImage', u'lsbootEmbeddedLocalLunImage', u'lsbootLocalDiskImage', u'lsbootLocalHddImage', u'lsbootUsbExternalImage', u'lsbootUsbFlashStorageImage', u'lsbootUsbInternalImage'], ["Add", "Get", "Remove"]),
    "LsbootPolicy": MoMeta("LsbootPolicy", "lsbootPolicy", "boot-policy-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage-policy"], [u'orgOrg', u'policySystemEp'], [u'lsbootBootSecurity', u'lsbootEFIShell', u'lsbootIScsi', u'lsbootLan', u'lsbootSan', u'lsbootStorage', u'lsbootVirtualMedia'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSan": MoMeta("LsbootSan", "lsbootSan", "san", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootDef', u'lsbootPolicy'], [u'lsbootSanCatSanImage'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanCatSanImage": MoMeta("LsbootSanCatSanImage", "lsbootSanCatSanImage", "sanimg-[type]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootSan'], [u'lsbootSanCatSanImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanCatSanImagePath": MoMeta("LsbootSanCatSanImagePath", "lsbootSanCatSanImagePath", "sanimgpath-[type]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootSanCatSanImage'], [u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanImage": MoMeta("LsbootSanImage", "lsbootSanImage", "san-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootStorage'], [u'lsbootSanImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanImagePath": MoMeta("LsbootSanImagePath", "lsbootSanImagePath", "path-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootSanImage'], [u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootStorage": MoMeta("LsbootStorage", "lsbootStorage", "storage", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootDef', u'lsbootPolicy'], [u'lsbootLocalStorage', u'lsbootSanImage'], ["Add", "Get", "Remove", "Set"]),
    "LsbootUEFIBootParam": MoMeta("LsbootUEFIBootParam", "lsbootUEFIBootParam", "uefi-boot-param", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage-policy"], [u'lsbootIScsiImagePath', u'lsbootLanImagePath', u'lsbootLocalHddImage', u'lsbootLocalLunImagePath', u'lsbootSanCatSanImagePath', u'lsbootSanImagePath'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootUsbExternalImage": MoMeta("LsbootUsbExternalImage", "lsbootUsbExternalImage", "usb-extern", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootUsbFlashStorageImage": MoMeta("LsbootUsbFlashStorageImage", "lsbootUsbFlashStorageImage", "sd-card", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootUsbInternalImage": MoMeta("LsbootUsbInternalImage", "lsbootUsbInternalImage", "usb-intern", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootVirtualMedia": MoMeta("LsbootVirtualMedia", "lsbootVirtualMedia", "[access]-vm", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootDef', u'lsbootPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LsmaintAck": MoMeta("LsmaintAck", "lsmaintAck", "ack", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-oper"], [u'lsServer'], [u'faultInst', u'trigLocalSched'], ["Get", "Set"]),
    "LsmaintMaintPolicy": MoMeta("LsmaintMaintPolicy", "lsmaintMaintPolicy", "maint-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy"], [u'orgOrg'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LstorageControllerDef": MoMeta("LstorageControllerDef", "lstorageControllerDef", "controller-def-[name]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageProfile', u'lstorageProfileDef', u'storageController'], [u'lstorageControllerModeConfig', u'lstorageControllerQualifier'], [None]),
    "LstorageControllerModeConfig": MoMeta("LstorageControllerModeConfig", "lstorageControllerModeConfig", "controller-mode-config", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageControllerDef'], [], [None]),
    "LstorageControllerQualifier": MoMeta("LstorageControllerQualifier", "lstorageControllerQualifier", "controller-qual", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageControllerDef'], [], [None]),
    "LstorageControllerRef": MoMeta("LstorageControllerRef", "lstorageControllerRef", "server-[server_id]-controller-[controller_type]-[controller_id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'lstorageDiskSlot'], [], [None]),
    "LstorageDasScsiLun": MoMeta("LstorageDasScsiLun", "lstorageDasScsiLun", "das-scsi-lun-[name]", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageProfile', u'lstorageProfileDef'], [u'faultInst', u'storageLocalDiskConfigDef'], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskGroupConfigDef": MoMeta("LstorageDiskGroupConfigDef", "lstorageDiskGroupConfigDef", "disk-group-config", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'storageVirtualDriveRef'], [u'lstorageDiskGroupQualifier', u'lstorageLocalDiskConfigRef', u'lstorageVirtualDriveDef'], ["Get"]),
    "LstorageDiskGroupConfigPolicy": MoMeta("LstorageDiskGroupConfigPolicy", "lstorageDiskGroupConfigPolicy", "disk-group-config-[name]", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'orgOrg'], [u'lstorageDiskGroupQualifier', u'lstorageLocalDiskConfigRef', u'lstorageVirtualDriveDef'], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskGroupQualifier": MoMeta("LstorageDiskGroupQualifier", "lstorageDiskGroupQualifier", "disk-group-qual", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageDiskGroupConfigDef', u'lstorageDiskGroupConfigPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskSlot": MoMeta("LstorageDiskSlot", "lstorageDiskSlot", "disk-slot-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'lstorageDiskZoningConfigDef', u'lstorageDiskZoningPolicy'], [u'lstorageControllerRef'], [None]),
    "LstorageDiskZoningConfigDef": MoMeta("LstorageDiskZoningConfigDef", "lstorageDiskZoningConfigDef", "disk-zoning-def", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassisProfile'], [u'lstorageDiskSlot'], [None]),
    "LstorageDiskZoningPolicy": MoMeta("LstorageDiskZoningPolicy", "lstorageDiskZoningPolicy", "disk-zoning-policy-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'orgOrg'], [u'lstorageDiskSlot'], [None]),
    "LstorageLocalDiskConfigRef": MoMeta("LstorageLocalDiskConfigRef", "lstorageLocalDiskConfigRef", "slot-[slot_num]", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageDiskGroupConfigDef', u'lstorageDiskGroupConfigPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LstorageLocalDiskRef": MoMeta("LstorageLocalDiskRef", "lstorageLocalDiskRef", "diskref-[enclosure_id]-slot-[slot_id]", VersionMeta.Version251a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "LstorageProfile": MoMeta("LstorageProfile", "lstorageProfile", "profile-[name]", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], [u'orgOrg'], [u'lstorageControllerDef', u'lstorageDasScsiLun'], ["Add", "Get", "Remove", "Set"]),
    "LstorageProfileBinding": MoMeta("LstorageProfileBinding", "lstorageProfileBinding", "profile-binding", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lsServer'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LstorageProfileDef": MoMeta("LstorageProfileDef", "lstorageProfileDef", "profile-def", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], [u'lsServer'], [u'lstorageControllerDef', u'lstorageDasScsiLun'], ["Add", "Get", "Remove", "Set"]),
    "LstorageVirtualDriveDef": MoMeta("LstorageVirtualDriveDef", "lstorageVirtualDriveDef", "virtual-drive-def", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageDiskGroupConfigDef', u'lstorageDiskGroupConfigPolicy'], [], ["Get", "Set"]),
    "MacpoolAddr": MoMeta("MacpoolAddr", "macpoolAddr", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'macpoolUniverse'], [u'faultInst', u'macpoolPoolable'], ["Get"]),
    "MacpoolBlock": MoMeta("MacpoolBlock", "macpoolBlock", "block-[r_from]-[to]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], [u'macpoolPool'], [], ["Add", "Get", "Remove"]),
    "MacpoolFormat": MoMeta("MacpoolFormat", "macpoolFormat", "format-[format]-[mask]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ls-network", "ls-network-policy"], [u'macpoolUniverse'], [], ["Get"]),
    "MacpoolPool": MoMeta("MacpoolPool", "macpoolPool", "mac-pool-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], [u'orgOrg'], [u'faultInst', u'macpoolBlock', u'macpoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "MacpoolPoolable": MoMeta("MacpoolPoolable", "macpoolPoolable", "pool-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'macpoolAddr'], [], ["Get"]),
    "MacpoolPooled": MoMeta("MacpoolPooled", "macpoolPooled", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'macpoolPool'], [], ["Get"]),
    "MacpoolUniverse": MoMeta("MacpoolUniverse", "macpoolUniverse", "mac", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'macpoolAddr', u'macpoolFormat'], [None]),
    "MemoryArray": MoMeta("MemoryArray", "memoryArray", "memarray-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard'], [u'faultInst', u'memoryArrayEnvStats', u'memoryUnit'], ["Get"]),
    "MemoryArrayEnvStats": MoMeta("MemoryArrayEnvStats", "memoryArrayEnvStats", "array-env-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'memoryArray'], [u'memoryArrayEnvStatsHist'], ["Get"]),
    "MemoryArrayEnvStatsHist": MoMeta("MemoryArrayEnvStatsHist", "memoryArrayEnvStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'memoryArrayEnvStats'], [], ["Get"]),
    "MemoryBufferUnit": MoMeta("MemoryBufferUnit", "memoryBufferUnit", "sensor-unit-[id]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard'], [u'faultInst', u'memoryBufferUnitEnvStats'], ["Get"]),
    "MemoryBufferUnitEnvStats": MoMeta("MemoryBufferUnitEnvStats", "memoryBufferUnitEnvStats", "buffer-unit-env-stats", VersionMeta.Version131c, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'memoryBufferUnit'], [u'memoryBufferUnitEnvStatsHist'], ["Get"]),
    "MemoryBufferUnitEnvStatsHist": MoMeta("MemoryBufferUnitEnvStatsHist", "memoryBufferUnitEnvStatsHist", "[id]", VersionMeta.Version131c, "OutputOnly", 0x1, [], ["read-only"], [u'memoryBufferUnitEnvStats'], [], ["Get"]),
    "MemoryErrorStats": MoMeta("MemoryErrorStats", "memoryErrorStats", "error-stats", VersionMeta.Version131c, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'memoryUnit'], [], ["Get"]),
    "MemoryQual": MoMeta("MemoryQual", "memoryQual", "memory", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "MemoryRuntime": MoMeta("MemoryRuntime", "memoryRuntime", "[type]-mem-rt", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBlade'], [u'memoryRuntimeHist'], ["Get"]),
    "MemoryRuntimeHist": MoMeta("MemoryRuntimeHist", "memoryRuntimeHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'memoryRuntime'], [], ["Get"]),
    "MemoryUnit": MoMeta("MemoryUnit", "memoryUnit", "mem-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'memoryArray'], [u'faultInst', u'memoryErrorStats', u'memoryUnitEnvStats'], ["Get"]),
    "MemoryUnitEnvStats": MoMeta("MemoryUnitEnvStats", "memoryUnitEnvStats", "dimm-env-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'memoryUnit'], [u'memoryUnitEnvStatsHist'], ["Get"]),
    "MemoryUnitEnvStatsHist": MoMeta("MemoryUnitEnvStatsHist", "memoryUnitEnvStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'memoryUnitEnvStats'], [], ["Get"]),
    "MgmtAccessPolicy": MoMeta("MgmtAccessPolicy", "mgmtAccessPolicy", "ext-access-policy", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [u'mgmtAccessPolicyItem'], ["Get"]),
    "MgmtAccessPolicyItem": MoMeta("MgmtAccessPolicyItem", "mgmtAccessPolicyItem", "item-[subject]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'mgmtAccessPolicy'], [u'mgmtAccessPort'], ["Get"]),
    "MgmtAccessPort": MoMeta("MgmtAccessPort", "mgmtAccessPort", "[protocol]-port-[port]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'mgmtAccessPolicyItem'], [], ["Get"]),
    "MgmtBackup": MoMeta("MgmtBackup", "mgmtBackup", "backup-[hostname]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'eventInst', u'faultInst', u'mgmtBackupFsm', u'mgmtBackupFsmTask'], ["Add", "Get", "Remove"]),
    "MgmtBackupExportExtPolicy": MoMeta("MgmtBackupExportExtPolicy", "mgmtBackupExportExtPolicy", "backup-exp-policy", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin"], [u'orgOrg'], [], ["Get", "Set"]),
    "MgmtBackupFsm": MoMeta("MgmtBackupFsm", "mgmtBackupFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'mgmtBackup'], [u'mgmtBackupFsmStage'], [None]),
    "MgmtBackupFsmStage": MoMeta("MgmtBackupFsmStage", "mgmtBackupFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'mgmtBackupFsm'], [], [None]),
    "MgmtBackupFsmTask": MoMeta("MgmtBackupFsmTask", "mgmtBackupFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'mgmtBackup'], [], [None]),
    "MgmtBackupPolicy": MoMeta("MgmtBackupPolicy", "mgmtBackupPolicy", "db-backup-policy-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'orgOrg'], [u'eventInst', u'faultInst', u'mgmtBackupPolicyFsm', u'mgmtExportPolicyFsm', u'mgmtExportPolicyFsmTask'], ["Get", "Set"]),
    "MgmtBackupPolicyConfig": MoMeta("MgmtBackupPolicyConfig", "mgmtBackupPolicyConfig", "bkup-policy-cfg", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'faultInst', u'trigLocalSched'], ["Get"]),
    "MgmtBackupPolicyFsm": MoMeta("MgmtBackupPolicyFsm", "mgmtBackupPolicyFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'mgmtBackupPolicy'], [u'mgmtBackupPolicyFsmStage'], [None]),
    "MgmtBackupPolicyFsmStage": MoMeta("MgmtBackupPolicyFsmStage", "mgmtBackupPolicyFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'mgmtBackupPolicyFsm'], [], [None]),
    "MgmtCfgExportPolicy": MoMeta("MgmtCfgExportPolicy", "mgmtCfgExportPolicy", "cfg-exp-policy-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'orgOrg'], [u'eventInst', u'faultInst', u'mgmtCfgExportPolicyFsm', u'mgmtExportPolicyFsm', u'mgmtExportPolicyFsmTask'], ["Get", "Set"]),
    "MgmtCfgExportPolicyFsm": MoMeta("MgmtCfgExportPolicyFsm", "mgmtCfgExportPolicyFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'mgmtCfgExportPolicy'], [u'mgmtCfgExportPolicyFsmStage'], [None]),
    "MgmtCfgExportPolicyFsmStage": MoMeta("MgmtCfgExportPolicyFsmStage", "mgmtCfgExportPolicyFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'mgmtCfgExportPolicyFsm'], [], [None]),
    "MgmtCimcSecureBoot": MoMeta("MgmtCimcSecureBoot", "mgmtCimcSecureBoot", "mgmt-secure-boot", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ls-compute"], [u'mgmtController'], [], ["Get", "Set"]),
    "MgmtCmcSecureBoot": MoMeta("MgmtCmcSecureBoot", "mgmtCmcSecureBoot", "mgmt-cmc-secure-boot", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute"], [u'mgmtController'], [], [None]),
    "MgmtConnection": MoMeta("MgmtConnection", "mgmtConnection", "mgmt-connection-[type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'mgmtController'], [u'faultInst'], ["Get", "Set"]),
    "MgmtController": MoMeta("MgmtController", "mgmtController", "mgmt", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'adaptorUnit', u'computeBlade', u'computeBoardController', u'computeExtBoard', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'equipmentFex', u'equipmentIOCard', u'equipmentSharedIOModule', u'equipmentSwitchIOCard', u'equipmentSystemIOController', u'networkElement', u'storageController', u'storageLocalDisk', u'storageSasExpander', u'topSystem'], [u'cimcvmediaActualMountList', u'eventInst', u'fabricLocale', u'faultInst', u'firmwareBootDefinition', u'firmwareRunning', u'firmwareUpdatable', u'mgmtCimcSecureBoot', u'mgmtCmcSecureBoot', u'mgmtConnection', u'mgmtControllerFsm', u'mgmtControllerFsmTask', u'mgmtHealthStatus', u'mgmtIf', u'mgmtInterface', u'mgmtProfDerivedInterface', u'sysdebugMEpLog', u'vnicIpV4PooledAddr', u'vnicIpV4ProfDerivedAddr', u'vnicIpV4StaticAddr'], ["Get"]),
    "MgmtControllerFsm": MoMeta("MgmtControllerFsm", "mgmtControllerFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'mgmtController'], [u'mgmtControllerFsmStage'], [None]),
    "MgmtControllerFsmStage": MoMeta("MgmtControllerFsmStage", "mgmtControllerFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'mgmtControllerFsm'], [], [None]),
    "MgmtControllerFsmTask": MoMeta("MgmtControllerFsmTask", "mgmtControllerFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'mgmtController'], [], [None]),
    "MgmtEntity": MoMeta("MgmtEntity", "mgmtEntity", "mgmt-entity-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [u'faultInst', u'mgmtPmonEntry'], ["Get"]),
    "MgmtExportPolicyFsm": MoMeta("MgmtExportPolicyFsm", "mgmtExportPolicyFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'mgmtBackupPolicy', u'mgmtCfgExportPolicy'], [u'mgmtExportPolicyFsmStage'], [None]),
    "MgmtExportPolicyFsmStage": MoMeta("MgmtExportPolicyFsmStage", "mgmtExportPolicyFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'mgmtExportPolicyFsm'], [], [None]),
    "MgmtExportPolicyFsmTask": MoMeta("MgmtExportPolicyFsmTask", "mgmtExportPolicyFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'mgmtBackupPolicy', u'mgmtCfgExportPolicy'], [], [None]),
    "MgmtHealthAttr": MoMeta("MgmtHealthAttr", "mgmtHealthAttr", "[name]", VersionMeta.Version311e, "InputOutput", 0x1, [], ["read-only"], [u'mgmtHealthStatus'], [], [None]),
    "MgmtHealthStatus": MoMeta("MgmtHealthStatus", "mgmtHealthStatus", "health", VersionMeta.Version311e, "InputOutput", 0x1, [], ["read-only"], [u'mgmtController', u'networkElement'], [u'faultInst', u'mgmtHealthAttr'], [None]),
    "MgmtIPv6IfAddr": MoMeta("MgmtIPv6IfAddr", "mgmtIPv6IfAddr", "if-ipv6", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'mgmtIPv6IfConfig'], [u'eventInst', u'faultInst', u'mgmtIPv6IfAddrFsm', u'mgmtIPv6IfAddrFsmTask'], ["Get", "Set"]),
    "MgmtIPv6IfAddrFsm": MoMeta("MgmtIPv6IfAddrFsm", "mgmtIPv6IfAddrFsm", "fsm", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], [u'mgmtIPv6IfAddr'], [u'mgmtIPv6IfAddrFsmStage'], [None]),
    "MgmtIPv6IfAddrFsmStage": MoMeta("MgmtIPv6IfAddrFsmStage", "mgmtIPv6IfAddrFsmStage", "stage-[name]", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], [u'mgmtIPv6IfAddrFsm'], [], [None]),
    "MgmtIPv6IfAddrFsmTask": MoMeta("MgmtIPv6IfAddrFsmTask", "mgmtIPv6IfAddrFsmTask", "task-[item]", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], [u'mgmtIPv6IfAddr'], [], [None]),
    "MgmtIPv6IfConfig": MoMeta("MgmtIPv6IfConfig", "mgmtIPv6IfConfig", "ifConfig-ipv6", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'mgmtIf', u'networkElement'], [u'mgmtIPv6IfAddr'], ["Get"]),
    "MgmtIf": MoMeta("MgmtIf", "mgmtIf", "if-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'adaptorHostEthIf', u'mgmtController'], [u'dhcpAcquired', u'eventInst', u'faultInst', u'mgmtIPv6IfConfig', u'mgmtIfFsm', u'mgmtIfFsmTask'], ["Get"]),
    "MgmtIfFsm": MoMeta("MgmtIfFsm", "mgmtIfFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'mgmtIf'], [u'mgmtIfFsmStage'], [None]),
    "MgmtIfFsmStage": MoMeta("MgmtIfFsmStage", "mgmtIfFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'mgmtIfFsm'], [], [None]),
    "MgmtIfFsmTask": MoMeta("MgmtIfFsmTask", "mgmtIfFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'mgmtIf'], [], [None]),
    "MgmtImporter": MoMeta("MgmtImporter", "mgmtImporter", "import-config-[hostname]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'eventInst', u'faultInst', u'mgmtImporterFsm', u'mgmtImporterFsmTask'], ["Add", "Get", "Remove", "Set"]),
    "MgmtImporterFsm": MoMeta("MgmtImporterFsm", "mgmtImporterFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'mgmtImporter'], [u'mgmtImporterFsmStage'], [None]),
    "MgmtImporterFsmStage": MoMeta("MgmtImporterFsmStage", "mgmtImporterFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'mgmtImporterFsm'], [], [None]),
    "MgmtImporterFsmTask": MoMeta("MgmtImporterFsmTask", "mgmtImporterFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'mgmtImporter'], [], [None]),
    "MgmtInbandProfile": MoMeta("MgmtInbandProfile", "mgmtInbandProfile", "ib-profile", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricLanCloud'], [], ["Get", "Set"]),
    "MgmtIntAuthPolicy": MoMeta("MgmtIntAuthPolicy", "mgmtIntAuthPolicy", "int-mgmt-auth", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-security"], [u'topSystem'], [], ["Get"]),
    "MgmtInterface": MoMeta("MgmtInterface", "mgmtInterface", "iface-[mode]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'lsServer', u'mgmtController'], [u'faultInst', u'mgmtVnet'], ["Add", "Get", "Remove", "Set"]),
    "MgmtMgmtDbState": MoMeta("MgmtMgmtDbState", "mgmtMgmtDbState", "mgmt-db-state", VersionMeta.Version227b, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'faultInst'], [None]),
    "MgmtPmonEntry": MoMeta("MgmtPmonEntry", "mgmtPmonEntry", "[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [u'mgmtEntity'], [u'faultInst'], ["Get"]),
    "MgmtProfDerivedInterface": MoMeta("MgmtProfDerivedInterface", "mgmtProfDerivedInterface", "spiface-[mode]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'mgmtController'], [u'mgmtVnet'], ["Get"]),
    "MgmtVnet": MoMeta("MgmtVnet", "mgmtVnet", "network", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'mgmtInterface', u'mgmtProfDerivedInterface'], [u'vnicIpV4MgmtPooledAddr', u'vnicIpV4PooledAddr', u'vnicIpV4StaticAddr', u'vnicIpV6MgmtPooledAddr', u'vnicIpV6StaticAddr'], ["Add", "Get", "Remove", "Set"]),
    "MorefFruRef": MoMeta("MorefFruRef", "morefFruRef", "[class_name]-vendor-[vendor]-model-[model]-serial-[serial]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin"], [u'morefImportRoot'], [u'morefProp', u'morefRef'], [None]),
    "MorefImportRoot": MoMeta("MorefImportRoot", "morefImportRoot", "import-ref-root", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'eventInst', u'faultInst', u'morefFruRef', u'morefImportRootFsm', u'morefImportRootFsmTask', u'morefRef'], [None]),
    "MorefImportRootFsm": MoMeta("MorefImportRootFsm", "morefImportRootFsm", "fsm", VersionMeta.Version227b, "OutputOnly", 0x1, [], [""], [u'morefImportRoot'], [u'morefImportRootFsmStage'], [None]),
    "MorefImportRootFsmStage": MoMeta("MorefImportRootFsmStage", "morefImportRootFsmStage", "stage-[name]", VersionMeta.Version227b, "OutputOnly", 0x1, [], [""], [u'morefImportRootFsm'], [], [None]),
    "MorefImportRootFsmTask": MoMeta("MorefImportRootFsmTask", "morefImportRootFsmTask", "task-[item]", VersionMeta.Version227b, "OutputOnly", 0x1, [], [""], [u'morefImportRoot'], [], [None]),
    "MorefProp": MoMeta("MorefProp", "morefProp", "[name]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin"], [u'morefFruRef', u'morefRef'], [], [None]),
    "MorefRef": MoMeta("MorefRef", "morefRef", "[mo_rn]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin"], [u'morefFruRef', u'morefImportRoot', u'morefRef'], [u'morefProp', u'morefRef'], [None]),
    "NetworkElement": MoMeta("NetworkElement", "networkElement", "switch-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'topSystem'], [u'equipmentFan', u'equipmentFanModule', u'equipmentLocatorLed', u'equipmentPsu', u'equipmentSwitchCard', u'extmgmtIf', u'faultInst', u'firmwareStatus', u'mgmtController', u'mgmtHealthStatus', u'mgmtIPv6IfConfig', u'mgmtMgmtDbState', u'networkLanNeighbors', u'networkLldpNeighbors', u'networkOperLevel', u'networkSanNeighbors', u'nfsMountInst', u'powerBudget', u'storageItem', u'swAccessDomain', u'swCardEnvStats', u'swEnvStats', u'swEthLanBorder', u'swEthLanFlowMon', u'swEthLanMon', u'swExtUtility', u'swFabricZoneNs', u'swFcSanBorder', u'swFcSanMon', u'swPhys', u'swSystemStats', u'swUtilityDomain', u'swVlanPortNs'], ["Get", "Set"]),
    "NetworkIfStats": MoMeta("NetworkIfStats", "networkIfStats", "if-stat-[type]-[units]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'adaptorHostEthIf', u'adaptorHostFcIf', u'adaptorHostIscsiIf', u'adaptorHostScsiIf', u'adaptorHostServiceEthIf', u'etherPIo', u'fcPIo'], [], ["Get"]),
    "NetworkLanNeighborEntry": MoMeta("NetworkLanNeighborEntry", "networkLanNeighborEntry", "if-[local_interface]", VersionMeta.Version223a, "InputOutput", 0x1, [], ["read-only"], [u'networkLanNeighbors'], [], ["Get"]),
    "NetworkLanNeighbors": MoMeta("NetworkLanNeighbors", "networkLanNeighbors", "lan-neighbors", VersionMeta.Version223a, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'networkLanNeighborEntry'], ["Get"]),
    "NetworkLldpNeighborEntry": MoMeta("NetworkLldpNeighborEntry", "networkLldpNeighborEntry", "if-[local_interface]", VersionMeta.Version224a, "InputOutput", 0x1, [], ["read-only"], [u'networkLldpNeighbors'], [], ["Get"]),
    "NetworkLldpNeighbors": MoMeta("NetworkLldpNeighbors", "networkLldpNeighbors", "lldp-neighbors", VersionMeta.Version224a, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'networkLldpNeighborEntry'], ["Get"]),
    "NetworkOperLevel": MoMeta("NetworkOperLevel", "networkOperLevel", "oper-level", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'networkElement'], [u'faultInst'], [None]),
    "NetworkSanNeighborEntry": MoMeta("NetworkSanNeighborEntry", "networkSanNeighborEntry", "if-[local_interface]", VersionMeta.Version223a, "InputOutput", 0x1, [], ["read-only"], [u'networkSanNeighbors'], [], ["Get"]),
    "NetworkSanNeighbors": MoMeta("NetworkSanNeighbors", "networkSanNeighbors", "san-neighbors", VersionMeta.Version223a, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'networkSanNeighborEntry'], ["Get"]),
    "NfsEp": MoMeta("NfsEp", "nfsEp", "nfs-ep", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'nfsMountDef'], [None]),
    "NfsMountDef": MoMeta("NfsMountDef", "nfsMountDef", "nfs-mount-def-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'nfsEp'], [u'eventInst', u'faultInst', u'nfsMountDefFsm', u'nfsMountDefFsmTask'], ["Get"]),
    "NfsMountDefFsm": MoMeta("NfsMountDefFsm", "nfsMountDefFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'nfsMountDef'], [u'nfsMountDefFsmStage'], [None]),
    "NfsMountDefFsmStage": MoMeta("NfsMountDefFsmStage", "nfsMountDefFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'nfsMountDefFsm'], [], [None]),
    "NfsMountDefFsmTask": MoMeta("NfsMountDefFsmTask", "nfsMountDefFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'nfsMountDef'], [], [None]),
    "NfsMountInst": MoMeta("NfsMountInst", "nfsMountInst", "nfs-mount-inst-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'networkElement'], [u'eventInst', u'faultInst', u'nfsMountInstFsm', u'nfsMountInstFsmTask'], ["Get"]),
    "NfsMountInstFsm": MoMeta("NfsMountInstFsm", "nfsMountInstFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'nfsMountInst'], [u'nfsMountInstFsmStage'], [None]),
    "NfsMountInstFsmStage": MoMeta("NfsMountInstFsmStage", "nfsMountInstFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'nfsMountInstFsm'], [], [None]),
    "NfsMountInstFsmTask": MoMeta("NfsMountInstFsmTask", "nfsMountInstFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'nfsMountInst'], [], [None]),
    "NwctrlDefinition": MoMeta("NwctrlDefinition", "nwctrlDefinition", "nwctrl-[name]", VersionMeta.Version102d, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricEthEstcCloud', u'orgOrg', u'policySystemEp'], [u'dpsecMac'], ["Add", "Get", "Remove", "Set"]),
    "ObserveFilter": MoMeta("ObserveFilter", "observeFilter", "filter-[filter_class_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'observeObserved'], [], [None]),
    "ObserveObserved": MoMeta("ObserveObserved", "observeObserved", "observed-[data_src_sys_id]-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'extpolClient', u'extpolController', u'extpolProvider', u'extpolRegistry', u'observeObservedCont'], [u'eventInst', u'faultInst', u'observeFilter', u'observeObservedFsm', u'observeObservedFsmTask'], [None]),
    "ObserveObservedCont": MoMeta("ObserveObservedCont", "observeObservedCont", "observe", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'observeObserved'], [None]),
    "ObserveObservedFsm": MoMeta("ObserveObservedFsm", "observeObservedFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'observeObserved'], [u'observeObservedFsmStage'], [None]),
    "ObserveObservedFsmStage": MoMeta("ObserveObservedFsmStage", "observeObservedFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'observeObservedFsm'], [], [None]),
    "ObserveObservedFsmTask": MoMeta("ObserveObservedFsmTask", "observeObservedFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'observeObserved'], [], [None]),
    "OrgOrg": MoMeta("OrgOrg", "orgOrg", "org-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "org-management"], [u'orgOrg'], [u'aaaEpAuthProfile', u'adaptorHostEthIfProfile', u'adaptorHostFcIfProfile', u'adaptorHostIscsiIfProfile', u'biosVProfile', u'cimcvmediaMountConfigPolicy', u'commSvcPolicy', u'computeAutoconfigPolicy', u'computeBladeDiscPolicy', u'computeBladeInheritPolicy', u'computeChassisConnPolicy', u'computeChassisDiscPolicy', u'computeKvmMgmtPolicy', u'computeMemoryConfigPolicy', u'computePool', u'computePoolingPolicy', u'computePowerSyncPolicy', u'computePsuPolicy', u'computeQual', u'computeScrubPolicy', u'computeServerDiscPolicy', u'computeServerMgmtPolicy', u'cpmaintMaintPolicy', u'diagRunPolicy', u'epqosDefinition', u'epqosDefinitionDelTask', u'equipmentAutoconfigPolicy', u'equipmentChassisInheritPolicy', u'equipmentChassisProfile', u'equipmentPool', u'equipmentPoolingPolicy', u'equipmentQual', u'equipmentTier', u'fabricLacpPolicy', u'fabricLanCloudPolicy', u'fabricMulticastPolicy', u'fabricOrgVlanPolicy', u'fabricUdldPolicy', u'fabricVConProfile', u'fabricVlanGroupReq', u'fabricVlanPermit', u'fabricVlanReq', u'faultSuppressTask', u'fcpoolInitiators', u'firmwareAutoSyncPolicy', u'firmwareCatalogPack', u'firmwareChassisPack', u'firmwareComputeHostPack', u'firmwareComputeMgmtPack', u'firmwareInfraPack', u'hostimgPolicy', u'imgprovPolicy', u'imgsecPolicy', u'ippoolPool', u'iqnpoolPool', u'iscsiAuthProfile', u'lsAgentPolicy', u'lsServer', u'lsTier', u'lsbootPolicy', u'lsmaintMaintPolicy', u'lstorageDiskGroupConfigPolicy', u'lstorageDiskZoningPolicy', u'lstorageProfile', u'macpoolPool', u'mgmtBackupExportExtPolicy', u'mgmtBackupPolicy', u'mgmtCfgExportPolicy', u'nwctrlDefinition', u'orgOrg', u'orgSourceMask', u'powerGroupAdditionPolicy', u'powerMgmtPolicy', u'powerPlacement', u'powerPolicy', u'solPolicy', u'statsThresholdPolicy', u'storageConnectionPolicy', u'storageLocalDiskConfigPolicy', u'sysdebugMEpLogPolicy', u'topInfoSyncPolicy', u'trigTest', u'uuidpoolPool', u'vmLifeCyclePolicy', u'vnicDynamicConPolicy', u'vnicFcGroupTempl', u'vnicIScsiInitAutoConfigPolicy', u'vnicLanConnPolicy', u'vnicLanConnTempl', u'vnicSanConnPolicy', u'vnicSanConnTempl', u'vnicUsnicConPolicy', u'vnicVhbaBehPolicy', u'vnicVmqConPolicy', u'vnicVnicBehPolicy'], ["Add", "Get", "Remove", "Set"]),
    "OrgSourceMask": MoMeta("OrgSourceMask", "orgSourceMask", "src-mask", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [], [None]),
    "OsARPLinkMonitoringPolicy": MoMeta("OsARPLinkMonitoringPolicy", "osARPLinkMonitoringPolicy", "link-mon-pol", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'osEthBondIntf'], [u'osARPTarget'], [None]),
    "OsARPTarget": MoMeta("OsARPTarget", "osARPTarget", "arp-target-[name]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'osARPLinkMonitoringPolicy'], [], [None]),
    "OsAgent": MoMeta("OsAgent", "osAgent", "agent", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], ["Get"]),
    "OsEthBondIntf": MoMeta("OsEthBondIntf", "osEthBondIntf", "bond-intf-[name]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'osInstance'], [u'osARPLinkMonitoringPolicy', u'osEthBondModeActiveBackup', u'osEthBondModeBalancedALB', u'osEthBondModeBalancedRR', u'osEthBondModeBalancedTLB', u'osEthBondModeBalancedXOR', u'osEthBondModeBroadcast', u'osEthIntf', u'osMiiLinkMonitoringPolicy'], [None]),
    "OsEthBondModeActiveBackup": MoMeta("OsEthBondModeActiveBackup", "osEthBondModeActiveBackup", "eth-bond-mode", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'osEthBondIntf'], [u'osPrimarySlave'], [None]),
    "OsEthBondModeBalancedALB": MoMeta("OsEthBondModeBalancedALB", "osEthBondModeBalancedALB", "eth-bond-mode", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'osEthBondIntf'], [u'osPrimarySlave'], [None]),
    "OsEthBondModeBalancedRR": MoMeta("OsEthBondModeBalancedRR", "osEthBondModeBalancedRR", "eth-bond-mode", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'osEthBondIntf'], [u'osPrimarySlave'], [None]),
    "OsEthBondModeBalancedTLB": MoMeta("OsEthBondModeBalancedTLB", "osEthBondModeBalancedTLB", "eth-bond-mode", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'osEthBondIntf'], [u'osPrimarySlave'], [None]),
    "OsEthBondModeBalancedXOR": MoMeta("OsEthBondModeBalancedXOR", "osEthBondModeBalancedXOR", "eth-bond-mode", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'osEthBondIntf'], [u'osPrimarySlave'], [None]),
    "OsEthBondModeBroadcast": MoMeta("OsEthBondModeBroadcast", "osEthBondModeBroadcast", "eth-bond-mode", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'osEthBondIntf'], [u'osPrimarySlave'], [None]),
    "OsEthIntf": MoMeta("OsEthIntf", "osEthIntf", "intf-[name]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'osEthBondIntf', u'osInstance'], [], [None]),
    "OsInstance": MoMeta("OsInstance", "osInstance", "os", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'osEthBondIntf', u'osEthIntf'], ["Get"]),
    "OsMiiLinkMonitoringPolicy": MoMeta("OsMiiLinkMonitoringPolicy", "osMiiLinkMonitoringPolicy", "link-mon-pol", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'osEthBondIntf'], [], [None]),
    "OsPrimarySlave": MoMeta("OsPrimarySlave", "osPrimarySlave", "slave-intf-[name]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'osEthBondModeActiveBackup', u'osEthBondModeBalancedALB', u'osEthBondModeBalancedRR', u'osEthBondModeBalancedTLB', u'osEthBondModeBalancedXOR', u'osEthBondModeBroadcast'], [], [None]),
    "PciEquipSlot": MoMeta("PciEquipSlot", "pciEquipSlot", "equipped-slot-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], ["Get"]),
    "PciUnit": MoMeta("PciUnit", "pciUnit", "unit-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], ["Get"]),
    "PkiCertReq": MoMeta("PkiCertReq", "pkiCertReq", "certreq", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'pkiKeyRing'], [], ["Add", "Get", "Remove", "Set"]),
    "PkiEp": MoMeta("PkiEp", "pkiEp", "pki-ext", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [u'eventInst', u'faultInst', u'pkiEpFsm', u'pkiEpFsmTask', u'pkiKeyRing', u'pkiTP'], ["Get"]),
    "PkiEpFsm": MoMeta("PkiEpFsm", "pkiEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'pkiEp'], [u'pkiEpFsmStage'], [None]),
    "PkiEpFsmStage": MoMeta("PkiEpFsmStage", "pkiEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'pkiEpFsm'], [], [None]),
    "PkiEpFsmTask": MoMeta("PkiEpFsmTask", "pkiEpFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'pkiEp'], [], [None]),
    "PkiKeyRing": MoMeta("PkiKeyRing", "pkiKeyRing", "keyring-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'pkiEp'], [u'faultInst', u'pkiCertReq'], ["Add", "Get", "Remove", "Set"]),
    "PkiTP": MoMeta("PkiTP", "pkiTP", "tp-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["aaa", "admin"], [u'pkiEp'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "PolicyCentraleSync": MoMeta("PolicyCentraleSync", "policyCentraleSync", "centrale-sync", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [u'policyControlEp'], [], [None]),
    "PolicyCommunication": MoMeta("PolicyCommunication", "policyCommunication", "comm-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyConfigBackup": MoMeta("PolicyConfigBackup", "policyConfigBackup", "cfg-backup-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "operations"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyControlEp": MoMeta("PolicyControlEp", "policyControlEp", "control-ep-[type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'eventInst', u'faultInst', u'policyCentraleSync', u'policyCommunication', u'policyConfigBackup', u'policyControlEpFsm', u'policyControlEpFsmTask', u'policyDateTime', u'policyDiscovery', u'policyDns', u'policyEquipment', u'policyFault', u'policyIdResolvePolicy', u'policyInfraFirmware', u'policyMEp', u'policyMonitoring', u'policyPortConfig', u'policyPowerMgmt', u'policyPsu', u'policySecurity', u'policyStorageAutoConfig'], ["Add", "Get", "Remove", "Set"]),
    "PolicyControlEpFsm": MoMeta("PolicyControlEpFsm", "policyControlEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'policyControlEp'], [u'policyControlEpFsmStage'], [None]),
    "PolicyControlEpFsmStage": MoMeta("PolicyControlEpFsmStage", "policyControlEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'policyControlEpFsm'], [], [None]),
    "PolicyControlEpFsmTask": MoMeta("PolicyControlEpFsmTask", "policyControlEpFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'policyControlEp'], [], [None]),
    "PolicyControlledInstance": MoMeta("PolicyControlledInstance", "policyControlledInstance", "ctrlled-[type]-inst-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'policyCommunication', u'policyConfigBackup', u'policyDateTime', u'policyDiscovery', u'policyDns', u'policyEquipment', u'policyFault', u'policyInfraFirmware', u'policyMEp', u'policyMonitoring', u'policyPortConfig', u'policyPowerMgmt', u'policyPsu', u'policySecurity', u'policyStorageAutoConfig'], [], [None]),
    "PolicyControlledType": MoMeta("PolicyControlledType", "policyControlledType", "ctrlled-type-[type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'policyCommunication', u'policyConfigBackup', u'policyDateTime', u'policyDiscovery', u'policyDns', u'policyEquipment', u'policyFault', u'policyInfraFirmware', u'policyMEp', u'policyMonitoring', u'policyPortConfig', u'policyPowerMgmt', u'policyPsu', u'policySecurity', u'policyStorageAutoConfig'], [u'eventInst', u'faultInst', u'policyControlledTypeFsm', u'policyControlledTypeFsmTask'], [None]),
    "PolicyControlledTypeFsm": MoMeta("PolicyControlledTypeFsm", "policyControlledTypeFsm", "fsm", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], [u'policyControlledType'], [u'policyControlledTypeFsmStage'], [None]),
    "PolicyControlledTypeFsmStage": MoMeta("PolicyControlledTypeFsmStage", "policyControlledTypeFsmStage", "stage-[name]", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], [u'policyControlledTypeFsm'], [], [None]),
    "PolicyControlledTypeFsmTask": MoMeta("PolicyControlledTypeFsmTask", "policyControlledTypeFsmTask", "task-[item]", VersionMeta.Version212a, "OutputOnly", 0x1, [], [""], [u'policyControlledType'], [], [None]),
    "PolicyDateTime": MoMeta("PolicyDateTime", "policyDateTime", "datetime-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyDigest": MoMeta("PolicyDigest", "policyDigest", "policy-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "PolicyDiscovery": MoMeta("PolicyDiscovery", "policyDiscovery", "discovery-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], [None]),
    "PolicyDns": MoMeta("PolicyDns", "policyDns", "dns-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyElement": MoMeta("PolicyElement", "policyElement", "element-[converted_dn]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], [u'policyLocalMap'], [u'policyRefReq'], [None]),
    "PolicyEquipment": MoMeta("PolicyEquipment", "policyEquipment", "equipment-ctrl", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], [None]),
    "PolicyFault": MoMeta("PolicyFault", "policyFault", "fault-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "fault"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyIdResolvePolicy": MoMeta("PolicyIdResolvePolicy", "policyIdResolvePolicy", "id-policy", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "operations"], [u'policyControlEp'], [], ["Get", "Set"]),
    "PolicyInfraFirmware": MoMeta("PolicyInfraFirmware", "policyInfraFirmware", "fabric-fw-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "operations"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyLocalMap": MoMeta("PolicyLocalMap", "policyLocalMap", "localmap", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], [u'policyPolicyEp'], [u'policyElement'], [None]),
    "PolicyMEp": MoMeta("PolicyMEp", "policyMEp", "mep-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "operations"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyMonitoring": MoMeta("PolicyMonitoring", "policyMonitoring", "monitoring-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "operations"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyPolicyEp": MoMeta("PolicyPolicyEp", "policyPolicyEp", "policy-ep", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'policyLocalMap', u'policyPolicyScopeCont', u'policySystemEp'], [None]),
    "PolicyPolicyRequestor": MoMeta("PolicyPolicyRequestor", "policyPolicyRequestor", "requestor-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'policyPolicyScope'], [], [None]),
    "PolicyPolicyScope": MoMeta("PolicyPolicyScope", "policyPolicyScope", "scope-[policy_type]-[resolve_type]-[policy_name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'policyPolicyScopeContext'], [u'eventInst', u'faultInst', u'policyPolicyRequestor', u'policyPolicyScopeFsm', u'policyPolicyScopeFsmTask'], [None]),
    "PolicyPolicyScopeCont": MoMeta("PolicyPolicyScopeCont", "policyPolicyScopeCont", "scope-cont-[app_type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'extpolClient', u'extpolController', u'extpolProvider', u'extpolRegistry', u'policyPolicyEp'], [u'policyPolicyScopeContext'], [None]),
    "PolicyPolicyScopeContext": MoMeta("PolicyPolicyScopeContext", "policyPolicyScopeContext", "context-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'policyPolicyScopeCont'], [u'policyPolicyScope'], [None]),
    "PolicyPolicyScopeFsm": MoMeta("PolicyPolicyScopeFsm", "policyPolicyScopeFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'policyPolicyScope'], [u'policyPolicyScopeFsmStage'], [None]),
    "PolicyPolicyScopeFsmStage": MoMeta("PolicyPolicyScopeFsmStage", "policyPolicyScopeFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'policyPolicyScopeFsm'], [], [None]),
    "PolicyPolicyScopeFsmTask": MoMeta("PolicyPolicyScopeFsmTask", "policyPolicyScopeFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'policyPolicyScope'], [], [None]),
    "PolicyPortConfig": MoMeta("PolicyPortConfig", "policyPortConfig", "portconfig-ctrl", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], [None]),
    "PolicyPowerMgmt": MoMeta("PolicyPowerMgmt", "policyPowerMgmt", "powermgmt-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "power-mgmt"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyPsu": MoMeta("PolicyPsu", "policyPsu", "psu-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyRefReq": MoMeta("PolicyRefReq", "policyRefReq", "refreq-[ref_converted_dn]", VersionMeta.Version212a, "InputOutput", 0x1, [], ["admin"], [u'policyElement'], [], [None]),
    "PolicySecurity": MoMeta("PolicySecurity", "policySecurity", "security-ctrl", VersionMeta.Version211a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyStorageAutoConfig": MoMeta("PolicyStorageAutoConfig", "policyStorageAutoConfig", "storage-autoconfig-ctrl", VersionMeta.Version302a, "InputOutput", 0x1, [], ["admin", "ls-storage", "pn-policy"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], [None]),
    "PolicySystemEp": MoMeta("PolicySystemEp", "policySystemEp", "system-policies", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'policyPolicyEp'], [u'adaptorHostEthIfProfile', u'lsbootPolicy', u'nwctrlDefinition', u'powerPolicy', u'solPolicy'], [None]),
    "PortDomainEp": MoMeta("PortDomainEp", "portDomainEp", "domain-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'etherPIo', u'etherServerIntFIo', u'etherSwitchIntFIo', u'fcPIo'], [], ["Get"]),
    "PortGroup": MoMeta("PortGroup", "portGroup", "[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'equipmentIOCard', u'equipmentSharedIOModule', u'equipmentSwitchCard', u'equipmentSwitchIOCard'], [u'etherPIo', u'etherServerIntFIo', u'etherServerIntFIoPc', u'etherSwitchIntFIo', u'etherSwitchIntFIoPc', u'fcPIo', u'portSubGroup'], ["Get"]),
    "PortPIoFsm": MoMeta("PortPIoFsm", "portPIoFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'etherPIo', u'fcPIo'], [u'portPIoFsmStage'], [None]),
    "PortPIoFsmStage": MoMeta("PortPIoFsmStage", "portPIoFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'portPIoFsm'], [], [None]),
    "PortPIoFsmTask": MoMeta("PortPIoFsmTask", "portPIoFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], [u'etherPIo', u'fcPIo'], [], [None]),
    "PortSubGroup": MoMeta("PortSubGroup", "portSubGroup", "aggr-port-[aggr_port_id]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'portGroup'], [u'etherPIo', u'fcPIo'], [None]),
    "PortTrustMode": MoMeta("PortTrustMode", "portTrustMode", "trust-mode", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'etherServerIntFIo', u'fabricPathEp', u'swAccessEp'], [], ["Get"]),
    "PowerBudget": MoMeta("PowerBudget", "powerBudget", "budget", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "power-mgmt"], [u'computeBlade', u'computeExtBoard', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'equipmentFex', u'networkElement'], [u'faultInst', u'powerProfiledPower'], ["Get", "Set"]),
    "PowerChassisMember": MoMeta("PowerChassisMember", "powerChassisMember", "ch-member-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "power-mgmt", "read-only"], [u'powerGroup'], [u'faultInst'], ["Add", "Get", "Remove"]),
    "PowerEp": MoMeta("PowerEp", "powerEp", "power-ep", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "power-mgmt"], [u'topSystem'], [u'powerGroup', u'powerPrioWght'], ["Get"]),
    "PowerFIMember": MoMeta("PowerFIMember", "powerFIMember", "fi-member-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "power-mgmt", "read-only"], [u'powerGroup'], [], [None]),
    "PowerFexMember": MoMeta("PowerFexMember", "powerFexMember", "fex-member-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "power-mgmt", "read-only"], [u'powerGroup'], [], [None]),
    "PowerGroup": MoMeta("PowerGroup", "powerGroup", "group-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "power-mgmt"], [u'powerEp'], [u'faultInst', u'powerChassisMember', u'powerFIMember', u'powerFexMember', u'powerRackUnitMember'], ["Add", "Get", "Remove", "Set"]),
    "PowerGroupAdditionPolicy": MoMeta("PowerGroupAdditionPolicy", "powerGroupAdditionPolicy", "group-add-policy", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "power-mgmt"], [u'orgOrg'], [], ["Get"]),
    "PowerGroupQual": MoMeta("PowerGroupQual", "powerGroupQual", "power-group-[group_name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computeQual'], [], ["Add", "Get", "Remove"]),
    "PowerGroupStats": MoMeta("PowerGroupStats", "powerGroupStats", "stats", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], [u'powerGroupStatsHist'], ["Get"]),
    "PowerGroupStatsHist": MoMeta("PowerGroupStatsHist", "powerGroupStatsHist", "[id]", VersionMeta.Version141i, "OutputOnly", 0x1, [], ["read-only"], [u'powerGroupStats'], [], ["Get"]),
    "PowerMgmtPolicy": MoMeta("PowerMgmtPolicy", "powerMgmtPolicy", "pwr-mgmt-policy", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "power-mgmt"], [u'orgOrg'], [], ["Get", "Set"]),
    "PowerPlacement": MoMeta("PowerPlacement", "powerPlacement", "placement-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy"], [u'orgOrg'], [], ["Get"]),
    "PowerPolicy": MoMeta("PowerPolicy", "powerPolicy", "power-policy-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy"], [u'orgOrg', u'policySystemEp'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "PowerPrioWght": MoMeta("PowerPrioWght", "powerPrioWght", "weight-[prio]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "power-mgmt"], [u'powerEp'], [], ["Get"]),
    "PowerProfiledPower": MoMeta("PowerProfiledPower", "powerProfiledPower", "prof-power", VersionMeta.Version302a, "InputOutput", 0x1, [], ["admin", "power-mgmt"], [u'powerBudget'], [], ["Get"]),
    "PowerRackUnitMember": MoMeta("PowerRackUnitMember", "powerRackUnitMember", "ru-member-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "power-mgmt", "read-only"], [u'powerGroup'], [], ["Get"]),
    "ProcDoer": MoMeta("ProcDoer", "procDoer", "doer[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'procManager'], [], ["Get"]),
    "ProcManager": MoMeta("ProcManager", "procManager", "proc-info", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'procDoer', u'procPrt', u'procPrtCounts', u'procStimulusCounts', u'procSvc', u'procTxCounts'], ["Get"]),
    "ProcPrt": MoMeta("ProcPrt", "procPrt", "prt[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'procManager'], [], ["Get"]),
    "ProcPrtCounts": MoMeta("ProcPrtCounts", "procPrtCounts", "prt", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'procManager'], [], ["Get"]),
    "ProcStimulusCounts": MoMeta("ProcStimulusCounts", "procStimulusCounts", "stim", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "read-only"], [u'procManager', u'procSvc'], [], ["Get"]),
    "ProcSvc": MoMeta("ProcSvc", "procSvc", "svc-[name]", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], [u'procManager'], [u'procStimulusCounts', u'procTxCounts'], ["Get"]),
    "ProcTxCounts": MoMeta("ProcTxCounts", "procTxCounts", "tx", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "read-only"], [u'procManager', u'procSvc'], [], ["Get"]),
    "ProcessorCore": MoMeta("ProcessorCore", "processorCore", "core-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'processorUnit'], [u'processorThread'], [None]),
    "ProcessorEnvStats": MoMeta("ProcessorEnvStats", "processorEnvStats", "env-stats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'processorUnit'], [u'processorEnvStatsHist'], ["Get"]),
    "ProcessorEnvStatsHist": MoMeta("ProcessorEnvStatsHist", "processorEnvStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'processorEnvStats'], [], ["Get"]),
    "ProcessorErrorStats": MoMeta("ProcessorErrorStats", "processorErrorStats", "error-stats", VersionMeta.Version131c, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'processorUnit'], [], ["Get"]),
    "ProcessorQual": MoMeta("ProcessorQual", "processorQual", "cpu", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "ProcessorRuntime": MoMeta("ProcessorRuntime", "processorRuntime", "cpu-rt", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBlade'], [u'processorRuntimeHist'], ["Get"]),
    "ProcessorRuntimeHist": MoMeta("ProcessorRuntimeHist", "processorRuntimeHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'processorRuntime'], [], ["Get"]),
    "ProcessorThread": MoMeta("ProcessorThread", "processorThread", "thr-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'processorCore'], [], ["Get"]),
    "ProcessorUnit": MoMeta("ProcessorUnit", "processorUnit", "cpu-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard'], [u'faultInst', u'processorCore', u'processorEnvStats', u'processorErrorStats'], ["Get"]),
    "ProcessorUnitAssocCtx": MoMeta("ProcessorUnitAssocCtx", "processorUnitAssocCtx", "procunit-assoc-ctx", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'lsServerAssocCtx'], [], ["Get"]),
    "QosclassDefinition": MoMeta("QosclassDefinition", "qosclassDefinition", "classes", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], [u'fabricLanCloud'], [u'eventInst', u'faultInst', u'qosclassDefinitionFsm', u'qosclassDefinitionFsmTask', u'qosclassEthBE', u'qosclassEthClassified', u'qosclassFc'], ["Get", "Set"]),
    "QosclassDefinitionFsm": MoMeta("QosclassDefinitionFsm", "qosclassDefinitionFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'qosclassDefinition'], [u'qosclassDefinitionFsmStage'], [None]),
    "QosclassDefinitionFsmStage": MoMeta("QosclassDefinitionFsmStage", "qosclassDefinitionFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'qosclassDefinitionFsm'], [], [None]),
    "QosclassDefinitionFsmTask": MoMeta("QosclassDefinitionFsmTask", "qosclassDefinitionFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'qosclassDefinition'], [], [None]),
    "QosclassEthBE": MoMeta("QosclassEthBE", "qosclassEthBE", "class-best-effort", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], [u'qosclassDefinition'], [], ["Get", "Set"]),
    "QosclassEthClassified": MoMeta("QosclassEthClassified", "qosclassEthClassified", "class-[priority]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], [u'qosclassDefinition'], [], ["Get", "Set"]),
    "QosclassFc": MoMeta("QosclassFc", "qosclassFc", "class-fc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], [u'qosclassDefinition'], [], ["Get", "Set"]),
    "QueryresultDependency": MoMeta("QueryresultDependency", "queryresultDependency", "dependency-[ref_converted_dn]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
    "QueryresultUsage": MoMeta("QueryresultUsage", "queryresultUsage", "usage-[ref_converted_dn]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
    "SecurityUnit": MoMeta("SecurityUnit", "securityUnit", "security-unit-[id]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard'], [], [None]),
    "SesDiskSlotEp": MoMeta("SesDiskSlotEp", "sesDiskSlotEp", "disk-slot-ep-[enc_id]-id-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'sesEnclosure'], [], [None]),
    "SesEnclosure": MoMeta("SesEnclosure", "sesEnclosure", "ses-enc-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'equipmentChassis'], [u'sesDiskSlotEp'], [None]),
    "SolConfig": MoMeta("SolConfig", "solConfig", "sol", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server"], [u'lsServer'], [], ["Add", "Get", "Remove", "Set"]),
    "SolIf": MoMeta("SolIf", "solIf", "sol-if", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], ["Get"]),
    "SolPolicy": MoMeta("SolPolicy", "solPolicy", "sol-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config-policy"], [u'orgOrg', u'policySystemEp'], [], ["Add", "Get", "Remove", "Set"]),
    "StatsCollectionPolicy": MoMeta("StatsCollectionPolicy", "statsCollectionPolicy", "coll-policy-[name]", VersionMeta.Version102d, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsHolder'], [u'eventInst', u'faultInst', u'statsCollectionPolicyFsm', u'statsCollectionPolicyFsmTask'], ["Get", "Set"]),
    "StatsCollectionPolicyFsm": MoMeta("StatsCollectionPolicyFsm", "statsCollectionPolicyFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'statsCollectionPolicy'], [u'statsCollectionPolicyFsmStage'], [None]),
    "StatsCollectionPolicyFsmStage": MoMeta("StatsCollectionPolicyFsmStage", "statsCollectionPolicyFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'statsCollectionPolicyFsm'], [], [None]),
    "StatsCollectionPolicyFsmTask": MoMeta("StatsCollectionPolicyFsmTask", "statsCollectionPolicyFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'statsCollectionPolicy'], [], [None]),
    "StatsHolder": MoMeta("StatsHolder", "statsHolder", "stats", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'topRoot'], [u'statsCollectionPolicy'], ["Get"]),
    "StatsThr32Definition": MoMeta("StatsThr32Definition", "statsThr32Definition", "[prop_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsThresholdClass'], [u'statsThr32Value', u'statsThr64Value', u'statsThrFloatValue'], ["Add", "Get", "Set"]),
    "StatsThr32Value": MoMeta("StatsThr32Value", "statsThr32Value", "[direction]-[severity]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsThr32Definition', u'statsThr64Definition', u'statsThrFloatDefinition'], [], ["Add", "Get", "Set"]),
    "StatsThr64Definition": MoMeta("StatsThr64Definition", "statsThr64Definition", "[prop_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsThresholdClass'], [u'statsThr32Value', u'statsThr64Value', u'statsThrFloatValue'], ["Add", "Get", "Set"]),
    "StatsThr64Value": MoMeta("StatsThr64Value", "statsThr64Value", "[direction]-[severity]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsThr32Definition', u'statsThr64Definition', u'statsThrFloatDefinition'], [], ["Add", "Get", "Set"]),
    "StatsThrFloatDefinition": MoMeta("StatsThrFloatDefinition", "statsThrFloatDefinition", "[prop_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsThresholdClass'], [u'statsThr32Value', u'statsThr64Value', u'statsThrFloatValue'], ["Get"]),
    "StatsThrFloatValue": MoMeta("StatsThrFloatValue", "statsThrFloatValue", "[direction]-[severity]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsThr32Definition', u'statsThr64Definition', u'statsThrFloatDefinition'], [], ["Get"]),
    "StatsThresholdClass": MoMeta("StatsThresholdClass", "statsThresholdClass", "[stats_class_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsThresholdPolicy'], [u'statsThr32Definition', u'statsThr64Definition', u'statsThrFloatDefinition'], ["Add", "Get", "Remove", "Set"]),
    "StatsThresholdPolicy": MoMeta("StatsThresholdPolicy", "statsThresholdPolicy", "thr-policy-[name]", VersionMeta.Version102d, "InputOutput", 0x1, [], ["admin", "operations"], [u'fabricCabling', u'fabricDceSrv', u'fabricEthEstcCloud', u'fabricFcEstcCloud', u'fabricLanCloud', u'fabricLanMonCloud', u'fabricSanCloud', u'fabricSanMonCloud', u'orgOrg'], [u'statsThresholdClass'], ["Add", "Get", "Remove", "Set"]),
    "StorageAuthKey": MoMeta("StorageAuthKey", "storageAuthKey", "key-[type]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'storageIScsiTargetIf'], [], [None]),
    "StorageConnectionDef": MoMeta("StorageConnectionDef", "storageConnectionDef", "storage-conndef", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], [u'vnicFcGroupDef'], [u'faultInst', u'storageFcTargetEp'], ["Add", "Get", "Remove", "Set"]),
    "StorageConnectionPolicy": MoMeta("StorageConnectionPolicy", "storageConnectionPolicy", "storage-connpolicy-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], [u'orgOrg'], [u'faultInst', u'storageFcTargetEp'], ["Add", "Get", "Remove", "Set"]),
    "StorageController": MoMeta("StorageController", "storageController", "storage-[type]-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'computeBoard', u'equipmentChassis'], [u'faultInst', u'firmwareBootDefinition', u'firmwareRunning', u'lstorageControllerDef', u'mgmtController', u'storageDrive', u'storageEmbeddedStorage', u'storageEnclosure', u'storageLocalDisk', u'storageLocalDiskConfigDef', u'storageLocalDiskEp', u'storageLocalLun', u'storageMezzFlashLife', u'storageNvmeStats', u'storageOnboardDevice', u'storageOperation', u'storageRaidBattery', u'storageVirtualDrive', u'storageVirtualDriveEp'], ["Get"]),
    "StorageControllerEp": MoMeta("StorageControllerEp", "storageControllerEp", "controller-ep-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'storageLocalDisk', u'storageVirtualDrive'], [], [None]),
    "StorageControllerRef": MoMeta("StorageControllerRef", "storageControllerRef", "server-[server_id]-controller-[controller_type]-[controller_id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'storageEnclosureDiskSlotEp'], [], [None]),
    "StorageDiskEnvStats": MoMeta("StorageDiskEnvStats", "storageDiskEnvStats", "disk-env-stats", VersionMeta.Version302a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'storageLocalDisk'], [u'storageDiskEnvStatsHist'], [None]),
    "StorageDiskEnvStatsHist": MoMeta("StorageDiskEnvStatsHist", "storageDiskEnvStatsHist", "[id]", VersionMeta.Version302a, "OutputOnly", 0x1, [], ["read-only"], [u'storageDiskEnvStats'], [], [None]),
    "StorageDomainEp": MoMeta("StorageDomainEp", "storageDomainEp", "storage-ep", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'storageSystem'], [None]),
    "StorageDrive": MoMeta("StorageDrive", "storageDrive", "drive-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'storageController'], [], ["Get"]),
    "StorageEmbeddedStorage": MoMeta("StorageEmbeddedStorage", "storageEmbeddedStorage", "embedded-storage", VersionMeta.Version911z, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageController'], [], [None]),
    "StorageEnclosure": MoMeta("StorageEnclosure", "storageEnclosure", "enc-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'storageController'], [u'eventInst', u'faultInst', u'storageEnclosureDiskSlotEp', u'storageEnclosureFsm', u'storageEnclosureFsmTask', u'storageHddMotherBoardTempStats', u'storageLocalDisk'], ["Get"]),
    "StorageEnclosureCap": MoMeta("StorageEnclosureCap", "storageEnclosureCap", "physical-holder-[type]", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'equipmentChassisCapProvider'], [u'storageHwRevisionModifier'], [None]),
    "StorageEnclosureDiskSlotEp": MoMeta("StorageEnclosureDiskSlotEp", "storageEnclosureDiskSlotEp", "disk-slot-[id]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'storageEnclosure'], [u'faultInst', u'storageControllerRef'], [None]),
    "StorageEnclosureFsm": MoMeta("StorageEnclosureFsm", "storageEnclosureFsm", "fsm", VersionMeta.Version911z, "OutputOnly", 0x1, [], [""], [u'storageEnclosure'], [u'storageEnclosureFsmStage'], [None]),
    "StorageEnclosureFsmStage": MoMeta("StorageEnclosureFsmStage", "storageEnclosureFsmStage", "stage-[name]", VersionMeta.Version911z, "OutputOnly", 0x1, [], [""], [u'storageEnclosureFsm'], [], [None]),
    "StorageEnclosureFsmTask": MoMeta("StorageEnclosureFsmTask", "storageEnclosureFsmTask", "task-[item]", VersionMeta.Version911z, "OutputOnly", 0x1, [], [""], [u'storageEnclosure'], [], [None]),
    "StorageEnclosureLocalDiskConfig": MoMeta("StorageEnclosureLocalDiskConfig", "storageEnclosureLocalDiskConfig", "enc-disk-config-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [], [u'storageSasPort'], [None]),
    "StorageEpUser": MoMeta("StorageEpUser", "storageEpUser", "user-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'initiatorFcInitiatorEp', u'initiatorIScsiInitiatorEp'], [u'aaaCimcSession'], [None]),
    "StorageEtherIf": MoMeta("StorageEtherIf", "storageEtherIf", "ether-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'storageIScsiTargetIf'], [u'ipServiceIf'], [None]),
    "StorageFcIf": MoMeta("StorageFcIf", "storageFcIf", "fc-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'storageFcTargetIf'], [], [None]),
    "StorageFcTargetEp": MoMeta("StorageFcTargetEp", "storageFcTargetEp", "fc-target-ep-[targetwwpn]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], [u'storageConnectionDef', u'storageConnectionPolicy'], [u'storageVsanRef'], ["Add", "Get", "Remove", "Set"]),
    "StorageFcTargetIf": MoMeta("StorageFcTargetIf", "storageFcTargetIf", "fc-tgt-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], [u'storageFcIf'], [None]),
    "StorageFlexFlashCard": MoMeta("StorageFlexFlashCard", "storageFlexFlashCard", "card-[slot_number]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'storageFlexFlashController'], [u'faultInst', u'storageFlexFlashDrive'], ["Get"]),
    "StorageFlexFlashController": MoMeta("StorageFlexFlashController", "storageFlexFlashController", "storage-flexflash-[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin"], [u'computeBoard'], [u'eventInst', u'faultInst', u'firmwareRunning', u'storageFlexFlashCard', u'storageFlexFlashControllerFsm', u'storageFlexFlashControllerFsmTask', u'storageFlexFlashVirtualDrive', u'storageLocalDiskConfigDef'], ["Get"]),
    "StorageFlexFlashControllerFsm": MoMeta("StorageFlexFlashControllerFsm", "storageFlexFlashControllerFsm", "fsm", VersionMeta.Version223a, "OutputOnly", 0x1, [], [""], [u'storageFlexFlashController'], [u'storageFlexFlashControllerFsmStage'], [None]),
    "StorageFlexFlashControllerFsmStage": MoMeta("StorageFlexFlashControllerFsmStage", "storageFlexFlashControllerFsmStage", "stage-[name]", VersionMeta.Version223a, "OutputOnly", 0x1, [], [""], [u'storageFlexFlashControllerFsm'], [], [None]),
    "StorageFlexFlashControllerFsmTask": MoMeta("StorageFlexFlashControllerFsmTask", "storageFlexFlashControllerFsmTask", "task-[item]", VersionMeta.Version223a, "OutputOnly", 0x1, [], [""], [u'storageFlexFlashController'], [], [None]),
    "StorageFlexFlashDrive": MoMeta("StorageFlexFlashDrive", "storageFlexFlashDrive", "drive-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'storageFlexFlashCard'], [u'faultInst'], ["Get"]),
    "StorageFlexFlashVirtualDrive": MoMeta("StorageFlexFlashVirtualDrive", "storageFlexFlashVirtualDrive", "vd-[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'storageFlexFlashController'], [u'faultInst'], ["Get"]),
    "StorageHddMotherBoardTempStats": MoMeta("StorageHddMotherBoardTempStats", "storageHddMotherBoardTempStats", "hdd-mobo-temp-stats", VersionMeta.Version911z, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'storageEnclosure'], [u'storageHddMotherBoardTempStatsHist'], [None]),
    "StorageHddMotherBoardTempStatsHist": MoMeta("StorageHddMotherBoardTempStatsHist", "storageHddMotherBoardTempStatsHist", "[id]", VersionMeta.Version911z, "OutputOnly", 0x1, [], ["read-only"], [u'storageHddMotherBoardTempStats'], [], [None]),
    "StorageHwRevisionModifier": MoMeta("StorageHwRevisionModifier", "storageHwRevisionModifier", "hw-rev-modifier-[hw_type]", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider', u'storageEnclosureCap'], [], [None]),
    "StorageIScsiTargetIf": MoMeta("StorageIScsiTargetIf", "storageIScsiTargetIf", "iscsi-tgt-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'storageNodeEp'], [u'initiatorLunEp', u'storageAuthKey', u'storageEtherIf'], [None]),
    "StorageIniGroup": MoMeta("StorageIniGroup", "storageIniGroup", "grp-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'lsServer', u'vnicSanConnPolicy'], [u'faultInst', u'storageInitiator', u'vnicFcGroupDef'], ["Add", "Get", "Remove", "Set"]),
    "StorageInitiator": MoMeta("StorageInitiator", "storageInitiator", "ini-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageIniGroup'], [u'faultInst'], ["Add", "Get", "Remove"]),
    "StorageItem": MoMeta("StorageItem", "storageItem", "stor-part-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'faultInst'], ["Get"]),
    "StorageLocalDisk": MoMeta("StorageLocalDisk", "storageLocalDisk", "disk-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageController', u'storageEnclosure'], [u'equipmentLocatorLed', u'eventInst', u'faultInst', u'firmwareBootDefinition', u'firmwareRunning', u'mgmtController', u'storageControllerEp', u'storageDiskEnvStats', u'storageLocalDiskFsm', u'storageLocalDiskFsmTask', u'storageLocalDiskPartition', u'storageOperation', u'storageSasPort'], ["Get"]),
    "StorageLocalDiskConfigDef": MoMeta("StorageLocalDiskConfigDef", "storageLocalDiskConfigDef", "local-disk-config", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lsServer', u'lstorageDasScsiLun', u'storageController', u'storageFlexFlashController'], [u'storageLocalDiskPartition'], ["Add", "Get", "Remove", "Set"]),
    "StorageLocalDiskConfigPolicy": MoMeta("StorageLocalDiskConfigPolicy", "storageLocalDiskConfigPolicy", "local-disk-config-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'orgOrg'], [u'storageLocalDiskPartition'], ["Add", "Get", "Remove", "Set"]),
    "StorageLocalDiskEp": MoMeta("StorageLocalDiskEp", "storageLocalDiskEp", "disk-ep-[enc_id]-id-[id]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'storageController'], [], [None]),
    "StorageLocalDiskFsm": MoMeta("StorageLocalDiskFsm", "storageLocalDiskFsm", "fsm", VersionMeta.Version911z, "OutputOnly", 0x1, [], [""], [u'storageLocalDisk'], [u'storageLocalDiskFsmStage'], [None]),
    "StorageLocalDiskFsmStage": MoMeta("StorageLocalDiskFsmStage", "storageLocalDiskFsmStage", "stage-[name]", VersionMeta.Version911z, "OutputOnly", 0x1, [], [""], [u'storageLocalDiskFsm'], [], [None]),
    "StorageLocalDiskFsmTask": MoMeta("StorageLocalDiskFsmTask", "storageLocalDiskFsmTask", "task-[item]", VersionMeta.Version911z, "OutputOnly", 0x1, [], [""], [u'storageLocalDisk'], [], [None]),
    "StorageLocalDiskPartition": MoMeta("StorageLocalDiskPartition", "storageLocalDiskPartition", "partition-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'storageLocalDisk', u'storageLocalDiskConfigDef', u'storageLocalDiskConfigPolicy'], [], ["Get"]),
    "StorageLocalDiskSlotEp": MoMeta("StorageLocalDiskSlotEp", "storageLocalDiskSlotEp", "disk-[id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard'], [u'faultInst'], ["Get"]),
    "StorageLocalLun": MoMeta("StorageLocalLun", "storageLocalLun", "lun-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'storageController'], [], ["Get"]),
    "StorageLunDisk": MoMeta("StorageLunDisk", "storageLunDisk", "disk-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'storageVirtualDrive'], [], ["Get"]),
    "StorageLunResourceSelectionLog": MoMeta("StorageLunResourceSelectionLog", "storageLunResourceSelectionLog", "selection-log-[order]", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageVirtualDriveRef'], [], [None]),
    "StorageMezzFlashLife": MoMeta("StorageMezzFlashLife", "storageMezzFlashLife", "flash-life-", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], [u'storageController'], [u'faultInst'], ["Get"]),
    "StorageNodeEp": MoMeta("StorageNodeEp", "storageNodeEp", "node-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'initiatorGroupEp'], [u'storageIScsiTargetIf'], [None]),
    "StorageNvmeStats": MoMeta("StorageNvmeStats", "storageNvmeStats", "nvme-stats", VersionMeta.Version911z, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'storageController'], [u'storageNvmeStatsHist'], [None]),
    "StorageNvmeStatsHist": MoMeta("StorageNvmeStatsHist", "storageNvmeStatsHist", "[id]", VersionMeta.Version911z, "OutputOnly", 0x1, [], ["read-only"], [u'storageNvmeStats'], [], [None]),
    "StorageOnboardDevice": MoMeta("StorageOnboardDevice", "storageOnboardDevice", "onboard-device-[device_type]-[id]", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageController', u'storageSasExpander'], [u'firmwareBootDefinition', u'firmwareRunning', u'firmwareUpdatable'], [None]),
    "StorageOperation": MoMeta("StorageOperation", "storageOperation", "op-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'storageController', u'storageLocalDisk', u'storageRaidBattery', u'storageVirtualDrive'], [], [None]),
    "StorageQual": MoMeta("StorageQual", "storageQual", "local-storage", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "StorageRaidBattery": MoMeta("StorageRaidBattery", "storageRaidBattery", "raid-battery", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], [u'storageController'], [u'faultInst', u'storageOperation', u'storageTransportableFlashModule'], ["Get"]),
    "StorageSasExpander": MoMeta("StorageSasExpander", "storageSasExpander", "sas-expander-[id]", VersionMeta.Version226a, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard', u'equipmentChassis'], [u'faultInst', u'firmwareBootDefinition', u'firmwareRunning', u'mgmtController', u'storageOnboardDevice', u'storageSasUpLink'], [None]),
    "StorageSasLinkDescriptor": MoMeta("StorageSasLinkDescriptor", "storageSasLinkDescriptor", "sas-link-desc-server-[server_id]-controller-[controller_type]-[controller_id]-id-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'equipmentChassisCapProvider'], [], [None]),
    "StorageSasPort": MoMeta("StorageSasPort", "storageSasPort", "sas-port-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'storageEnclosureLocalDiskConfig', u'storageLocalDisk'], [], [None]),
    "StorageSasPortDescriptor": MoMeta("StorageSasPortDescriptor", "storageSasPortDescriptor", "sas-port-desc-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], [""], [u'equipmentChassisCapProvider'], [], [None]),
    "StorageSasUpLink": MoMeta("StorageSasUpLink", "storageSasUpLink", "sas-uplink-server-[server_id]-controller-[controller_type]-[controller_id]-id-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'storageSasExpander'], [], [None]),
    "StorageScsiLunRef": MoMeta("StorageScsiLunRef", "storageScsiLunRef", "scsi-lun-ref-[id]", VersionMeta.Version224a, "InputOutput", 0x1, [], ["read-only"], [u'storageVirtualDrive'], [], [None]),
    "StorageSystem": MoMeta("StorageSystem", "storageSystem", "system", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'storageDomainEp'], [u'eventInst', u'faultInst', u'initiatorRequestorEp', u'storageSystemFsm', u'storageSystemFsmTask'], [None]),
    "StorageSystemFsm": MoMeta("StorageSystemFsm", "storageSystemFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'storageSystem'], [u'storageSystemFsmStage'], [None]),
    "StorageSystemFsmStage": MoMeta("StorageSystemFsmStage", "storageSystemFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'storageSystemFsm'], [], [None]),
    "StorageSystemFsmTask": MoMeta("StorageSystemFsmTask", "storageSystemFsmTask", "task-[item]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'storageSystem'], [], [None]),
    "StorageTransportableFlashModule": MoMeta("StorageTransportableFlashModule", "storageTransportableFlashModule", "flash-module", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [u'storageRaidBattery'], [], ["Get"]),
    "StorageVDMemberEp": MoMeta("StorageVDMemberEp", "storageVDMemberEp", "member-[id]", VersionMeta.Version224a, "InputOutput", 0x1, [], ["read-only"], [u'storageVirtualDrive'], [u'faultInst'], ["Get"]),
    "StorageVirtualDrive": MoMeta("StorageVirtualDrive", "storageVirtualDrive", "vd-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageController', u'storageVirtualDriveContainer'], [u'faultInst', u'storageControllerEp', u'storageLunDisk', u'storageOperation', u'storageScsiLunRef', u'storageVDMemberEp'], [None]),
    "StorageVirtualDriveContainer": MoMeta("StorageVirtualDriveContainer", "storageVirtualDriveContainer", "vd-container-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis'], [u'storageVirtualDrive'], [None]),
    "StorageVirtualDriveEp": MoMeta("StorageVirtualDriveEp", "storageVirtualDriveEp", "vd-ep-[container_id]-id-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'storageController'], [], [None]),
    "StorageVirtualDriveRef": MoMeta("StorageVirtualDriveRef", "storageVirtualDriveRef", "vdrive-ref-[lun_item_name]", VersionMeta.Version224a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'lsServer'], [u'lstorageDiskGroupConfigDef', u'storageLunResourceSelectionLog'], ["Get"]),
    "StorageVsanRef": MoMeta("StorageVsanRef", "storageVsanRef", "vsan-ref", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], [u'fabricFcUserZone', u'storageFcTargetEp'], [u'faultInst'], ["Add", "Get", "Set"]),
    "SwAccessDomain": MoMeta("SwAccessDomain", "swAccessDomain", "access-eth", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'eventInst', u'faultInst', u'swAccessDomainFsm', u'swAccessDomainFsmTask', u'swAccessEp', u'swSubGroup'], ["Get"]),
    "SwAccessDomainFsm": MoMeta("SwAccessDomainFsm", "swAccessDomainFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'swAccessDomain'], [u'swAccessDomainFsmStage'], [None]),
    "SwAccessDomainFsmStage": MoMeta("SwAccessDomainFsmStage", "swAccessDomainFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'swAccessDomainFsm'], [], [None]),
    "SwAccessDomainFsmTask": MoMeta("SwAccessDomainFsmTask", "swAccessDomainFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'swAccessDomain'], [], [None]),
    "SwAccessEp": MoMeta("SwAccessEp", "swAccessEp", "ep-slot-[slot_id]port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'swAccessDomain', u'swSubGroup'], [u'portTrustMode', u'swUlan'], ["Get"]),
    "SwCardEnvStats": MoMeta("SwCardEnvStats", "swCardEnvStats", "cardenvstats", VersionMeta.Version211a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'networkElement'], [u'swCardEnvStatsHist'], ["Get"]),
    "SwCardEnvStatsHist": MoMeta("SwCardEnvStatsHist", "swCardEnvStatsHist", "[id]", VersionMeta.Version211a, "OutputOnly", 0x1, [], ["read-only"], [u'swCardEnvStats'], [], ["Get"]),
    "SwCmclan": MoMeta("SwCmclan", "swCmclan", "vlan-cmc[id]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'dcxVc'], [], [None]),
    "SwEnvStats": MoMeta("SwEnvStats", "swEnvStats", "envstats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'networkElement'], [u'swEnvStatsHist'], ["Get"]),
    "SwEnvStatsHist": MoMeta("SwEnvStatsHist", "swEnvStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'swEnvStats'], [], ["Get"]),
    "SwEthEstcEp": MoMeta("SwEthEstcEp", "swEthEstcEp", "ethestc-ep-slot-[slot_id]port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'swEthLanBorder', u'swSubGroup'], [u'swEthTargetEp', u'swVlan'], ["Get"]),
    "SwEthEstcPc": MoMeta("SwEthEstcPc", "swEthEstcPc", "pc-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'swEthLanBorder', u'swEthMon'], [u'swEthTargetEp', u'swVlan'], ["Get"]),
    "SwEthLanBorder": MoMeta("SwEthLanBorder", "swEthLanBorder", "border-eth", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'eventInst', u'faultInst', u'swEthEstcEp', u'swEthEstcPc', u'swEthLanBorderFsm', u'swEthLanBorderFsmTask', u'swEthLanEp', u'swEthLanPc', u'swSubGroup', u'swVlan', u'swVlanGroup'], ["Get"]),
    "SwEthLanBorderFsm": MoMeta("SwEthLanBorderFsm", "swEthLanBorderFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'swEthLanBorder'], [u'swEthLanBorderFsmStage'], [None]),
    "SwEthLanBorderFsmStage": MoMeta("SwEthLanBorderFsmStage", "swEthLanBorderFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'swEthLanBorderFsm'], [], [None]),
    "SwEthLanBorderFsmTask": MoMeta("SwEthLanBorderFsmTask", "swEthLanBorderFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'swEthLanBorder'], [], [None]),
    "SwEthLanEp": MoMeta("SwEthLanEp", "swEthLanEp", "ep-slot-[slot_id]port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'swEthLanBorder', u'swSubGroup'], [u'swVlan'], ["Get"]),
    "SwEthLanFlowMon": MoMeta("SwEthLanFlowMon", "swEthLanFlowMon", "ethlanflowmon", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'dcxVc', u'eventInst', u'faultInst', u'swEthLanFlowMonFsm', u'swEthLanFlowMonFsmTask', u'swIpRoute', u'swNetflowExporter', u'swNetflowMonSession', u'swNetflowMonitor', u'swNetflowRecordDef', u'swVirtL3Intf'], [None]),
    "SwEthLanFlowMonFsm": MoMeta("SwEthLanFlowMonFsm", "swEthLanFlowMonFsm", "fsm", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], [u'swEthLanFlowMon'], [u'swEthLanFlowMonFsmStage'], [None]),
    "SwEthLanFlowMonFsmStage": MoMeta("SwEthLanFlowMonFsmStage", "swEthLanFlowMonFsmStage", "stage-[name]", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], [u'swEthLanFlowMonFsm'], [], [None]),
    "SwEthLanFlowMonFsmTask": MoMeta("SwEthLanFlowMonFsmTask", "swEthLanFlowMonFsmTask", "task-[item]", VersionMeta.Version221b, "OutputOnly", 0x1, [], [""], [u'swEthLanFlowMon'], [], [None]),
    "SwEthLanMon": MoMeta("SwEthLanMon", "swEthLanMon", "lanmon-eth", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'swEthMon'], ["Get"]),
    "SwEthLanPc": MoMeta("SwEthLanPc", "swEthLanPc", "pc-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'swEthLanBorder', u'swEthMon'], [u'swVlan'], ["Get"]),
    "SwEthMon": MoMeta("SwEthMon", "swEthMon", "mon-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'swEthLanMon'], [u'dcxVc', u'eventInst', u'faultInst', u'swEthEstcPc', u'swEthLanPc', u'swEthMonDestEp', u'swEthMonFsm', u'swEthMonFsmTask', u'swEthMonSrcEp', u'swSubGroup', u'swVlan'], ["Get"]),
    "SwEthMonDestEp": MoMeta("SwEthMonDestEp", "swEthMonDestEp", "mon-dest-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'swEthMon', u'swFcMon', u'swSubGroup'], [], ["Get"]),
    "SwEthMonFsm": MoMeta("SwEthMonFsm", "swEthMonFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'swEthMon'], [u'swEthMonFsmStage'], [None]),
    "SwEthMonFsmStage": MoMeta("SwEthMonFsmStage", "swEthMonFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'swEthMonFsm'], [], [None]),
    "SwEthMonFsmTask": MoMeta("SwEthMonFsmTask", "swEthMonFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], [u'swEthMon'], [], [None]),
    "SwEthMonSrcEp": MoMeta("SwEthMonSrcEp", "swEthMonSrcEp", "mon-src-[chassis_id]-[slot_id]-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'swEthMon', u'swSubGroup'], [], ["Get"]),
    "SwEthTargetEp": MoMeta("SwEthTargetEp", "swEthTargetEp", "eth-target-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'swEthEstcEp', u'swEthEstcPc'], [u'faultInst'], ["Get"]),
    "SwExtUtility": MoMeta("SwExtUtility", "swExtUtility", "ext", VersionMeta.Version311e, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'eventInst', u'faultInst', u'swExtUtilityFsm', u'swExtUtilityFsmTask', u'swPortBreakout'], [None]),
    "SwExtUtilityFsm": MoMeta("SwExtUtilityFsm", "swExtUtilityFsm", "fsm", VersionMeta.Version311e, "OutputOnly", 0x1, [], [""], [u'swExtUtility'], [u'swExtUtilityFsmStage'], [None]),
    "SwExtUtilityFsmStage": MoMeta("SwExtUtilityFsmStage", "swExtUtilityFsmStage", "stage-[name]", VersionMeta.Version311e, "OutputOnly", 0x1, [], [""], [u'swExtUtilityFsm'], [], [None]),
    "SwExtUtilityFsmTask": MoMeta("SwExtUtilityFsmTask", "swExtUtilityFsmTask", "task-[item]", VersionMeta.Version311e, "OutputOnly", 0x1, [], [""], [u'swExtUtility'], [], [None]),
    "SwFabricZoneNs": MoMeta("SwFabricZoneNs", "swFabricZoneNs", "fabric-zone-ns", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [], [None]),
    "SwFabricZoneNsOverride": MoMeta("SwFabricZoneNsOverride", "swFabricZoneNsOverride", "fabric-zone-override", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'topSysDefaults'], [], [None]),
    "SwFcEndpoint": MoMeta("SwFcEndpoint", "swFcEndpoint", "wwpn-[wwpn]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'swFcUserZone'], [], [None]),
    "SwFcEstcEp": MoMeta("SwFcEstcEp", "swFcEstcEp", "fcestc-ep-slot-[slot_id]port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'swFcSanBorder'], [], ["Get"]),
    "SwFcMon": MoMeta("SwFcMon", "swFcMon", "mon-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'swFcSanMon'], [u'dcxVc', u'eventInst', u'faultInst', u'swEthMonDestEp', u'swFcMonDestEp', u'swFcMonFsm', u'swFcMonFsmTask', u'swFcMonSrcEp', u'swFcSanPc', u'swFcoeSanPc', u'swSubGroup', u'swVsan'], ["Get"]),
    "SwFcMonDestEp": MoMeta("SwFcMonDestEp", "swFcMonDestEp", "mon-dest-[slot_id]-port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'swFcMon'], [], ["Get"]),
    "SwFcMonFsm": MoMeta("SwFcMonFsm", "swFcMonFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'swFcMon'], [u'swFcMonFsmStage'], [None]),
    "SwFcMonFsmStage": MoMeta("SwFcMonFsmStage", "swFcMonFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'swFcMonFsm'], [], [None]),
    "SwFcMonFsmTask": MoMeta("SwFcMonFsmTask", "swFcMonFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], [u'swFcMon'], [], [None]),
    "SwFcMonSrcEp": MoMeta("SwFcMonSrcEp", "swFcMonSrcEp", "mon-src-[chassis_id]-[slot_id]-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'swFcMon'], [], ["Get"]),
    "SwFcSanBorder": MoMeta("SwFcSanBorder", "swFcSanBorder", "border-fc", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'eventInst', u'faultInst', u'swFcEstcEp', u'swFcSanBorderFsm', u'swFcSanBorderFsmTask', u'swFcSanEp', u'swFcSanPc', u'swFcoeEstcEp', u'swFcoeSanEp', u'swFcoeSanPc', u'swSubGroup', u'swVlan', u'swVsan'], ["Get"]),
    "SwFcSanBorderFsm": MoMeta("SwFcSanBorderFsm", "swFcSanBorderFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'swFcSanBorder'], [u'swFcSanBorderFsmStage'], [None]),
    "SwFcSanBorderFsmStage": MoMeta("SwFcSanBorderFsmStage", "swFcSanBorderFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'swFcSanBorderFsm'], [], [None]),
    "SwFcSanBorderFsmTask": MoMeta("SwFcSanBorderFsmTask", "swFcSanBorderFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'swFcSanBorder'], [], [None]),
    "SwFcSanEp": MoMeta("SwFcSanEp", "swFcSanEp", "ep-slot-[slot_id]port-[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'swFcSanBorder'], [], ["Get"]),
    "SwFcSanMon": MoMeta("SwFcSanMon", "swFcSanMon", "sanmon-fc", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'swFcMon'], ["Get"]),
    "SwFcSanPc": MoMeta("SwFcSanPc", "swFcSanPc", "pc-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'swFcMon', u'swFcSanBorder'], [], ["Get"]),
    "SwFcServerZoneGroup": MoMeta("SwFcServerZoneGroup", "swFcServerZoneGroup", "zone-group-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'swFcZoneSet'], [u'swZoneInitiatorMember'], [None]),
    "SwFcUserZone": MoMeta("SwFcUserZone", "swFcUserZone", "zone-[id]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'swFcUserZoneGroup'], [u'swFcEndpoint'], [None]),
    "SwFcUserZoneGroup": MoMeta("SwFcUserZoneGroup", "swFcUserZoneGroup", "user-zone-group-[name]", VersionMeta.Version911z, "InputOutput", 0x1, [], ["read-only"], [u'swFcZoneSet'], [u'swFcUserZone'], [None]),
    "SwFcZone": MoMeta("SwFcZone", "swFcZone", "zone-[identity]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'swZoneInitiatorMember'], [u'swZoneTargetMember'], [None]),
    "SwFcZoneSet": MoMeta("SwFcZoneSet", "swFcZoneSet", "zone-set-default", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'swVsan'], [u'swFcServerZoneGroup', u'swFcUserZoneGroup'], [None]),
    "SwFcoeEstcEp": MoMeta("SwFcoeEstcEp", "swFcoeEstcEp", "fcoeestc-ep-slot-[slot_id]port-[port_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'swFcSanBorder', u'swSubGroup'], [u'dcxFcoeVifEp', u'dcxVifEp', u'swVlan'], ["Get"]),
    "SwFcoeSanEp": MoMeta("SwFcoeSanEp", "swFcoeSanEp", "fcoesan-ep-slot-[slot_id]port-[port_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'swFcSanBorder', u'swSubGroup'], [u'dcxFcoeVifEp', u'dcxVifEp', u'swVlan'], ["Add", "Get", "Remove", "Set"]),
    "SwFcoeSanPc": MoMeta("SwFcoeSanPc", "swFcoeSanPc", "fcoesan-pc-[port_id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'swFcMon', u'swFcSanBorder'], [u'dcxFcoeVifEp', u'dcxVifEp', u'swVlan'], ["Add", "Get", "Remove", "Set"]),
    "SwIpRoute": MoMeta("SwIpRoute", "swIpRoute", "ip-route-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'swEthLanFlowMon'], [], [None]),
    "SwNFExporterRef": MoMeta("SwNFExporterRef", "swNFExporterRef", "nf-exporter-ref-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'swNetflowMonitor'], [], [None]),
    "SwNetflowExporter": MoMeta("SwNetflowExporter", "swNetflowExporter", "flowexporter-netflow-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'swEthLanFlowMon'], [u'swVlan'], [None]),
    "SwNetflowMonSession": MoMeta("SwNetflowMonSession", "swNetflowMonSession", "flowmonsession-netflow-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'swEthLanFlowMon'], [u'swNetflowMonitor', u'swNetflowMonitorRef'], [None]),
    "SwNetflowMonitor": MoMeta("SwNetflowMonitor", "swNetflowMonitor", "flowmonitor-netflow-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'swEthLanFlowMon', u'swNetflowMonSession'], [u'swNFExporterRef'], [None]),
    "SwNetflowMonitorRef": MoMeta("SwNetflowMonitorRef", "swNetflowMonitorRef", "nf-monitor-ref-[name]-[direction]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'dcxVc', u'swNetflowMonSession', u'vnicProfile'], [], [None]),
    "SwNetflowRecordDef": MoMeta("SwNetflowRecordDef", "swNetflowRecordDef", "flowrecord-netflow-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'swEthLanFlowMon'], [], [None]),
    "SwPhys": MoMeta("SwPhys", "swPhys", "phys", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'eventInst', u'faultInst', u'swPhysEtherEp', u'swPhysFcEp', u'swPhysFsm', u'swPhysFsmTask', u'swSubGroup'], ["Get"]),
    "SwPhysEtherEp": MoMeta("SwPhysEtherEp", "swPhysEtherEp", "phys-eth-slot-[slot_id]port-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [u'swPhys', u'swSubGroup'], [], ["Get"]),
    "SwPhysFcEp": MoMeta("SwPhysFcEp", "swPhysFcEp", "phys-fc-slot-[slot_id]port-[port_id]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [u'swPhys', u'swSubGroup'], [], ["Get"]),
    "SwPhysFsm": MoMeta("SwPhysFsm", "swPhysFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'swPhys'], [u'swPhysFsmStage'], [None]),
    "SwPhysFsmStage": MoMeta("SwPhysFsmStage", "swPhysFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'swPhysFsm'], [], [None]),
    "SwPhysFsmTask": MoMeta("SwPhysFsmTask", "swPhysFsmTask", "task-[item]", VersionMeta.Version201m, "OutputOnly", 0x1, [], [""], [u'swPhys'], [], [None]),
    "SwPortBreakout": MoMeta("SwPortBreakout", "swPortBreakout", "breakout-slot-[slot_id]-port-[port_id]", VersionMeta.Version311e, "InputOutput", 0x1, [], ["admin"], [u'swExtUtility'], [], [None]),
    "SwSubGroup": MoMeta("SwSubGroup", "swSubGroup", "slot-[slot_id]-aggr-port-[aggr_port_id]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["read-only"], [u'swAccessDomain', u'swEthLanBorder', u'swEthMon', u'swFcMon', u'swFcSanBorder', u'swPhys'], [u'swAccessEp', u'swEthEstcEp', u'swEthLanEp', u'swEthMonDestEp', u'swEthMonSrcEp', u'swFcoeEstcEp', u'swFcoeSanEp', u'swPhysEtherEp', u'swPhysFcEp'], [None]),
    "SwSystemStats": MoMeta("SwSystemStats", "swSystemStats", "sysstats", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'networkElement'], [u'faultInst', u'swSystemStatsHist'], ["Get"]),
    "SwSystemStatsHist": MoMeta("SwSystemStatsHist", "swSystemStatsHist", "[id]", VersionMeta.Version111j, "OutputOnly", 0x1, [], ["read-only"], [u'swSystemStats'], [], ["Get"]),
    "SwUlan": MoMeta("SwUlan", "swUlan", "vlan-[purpose]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'dcxVc', u'etherServerIntFIo', u'swAccessEp', u'swUtilityDomain'], [], ["Get"]),
    "SwUtilityDomain": MoMeta("SwUtilityDomain", "swUtilityDomain", "utility-eth", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'eventInst', u'faultInst', u'swUlan', u'swUtilityDomainFsm', u'swUtilityDomainFsmTask'], ["Get"]),
    "SwUtilityDomainFsm": MoMeta("SwUtilityDomainFsm", "swUtilityDomainFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'swUtilityDomain'], [u'swUtilityDomainFsmStage'], [None]),
    "SwUtilityDomainFsmStage": MoMeta("SwUtilityDomainFsmStage", "swUtilityDomainFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'swUtilityDomainFsm'], [], [None]),
    "SwUtilityDomainFsmTask": MoMeta("SwUtilityDomainFsmTask", "swUtilityDomainFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'swUtilityDomain'], [], [None]),
    "SwVIFRef": MoMeta("SwVIFRef", "swVIFRef", "vifref-[id]", VersionMeta.Version311e, "InputOutput", 0x1, [], ["read-only"], [u'swVlanGroup'], [], [None]),
    "SwVirtL3Intf": MoMeta("SwVirtL3Intf", "swVirtL3Intf", "l3-vlan-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'swEthLanFlowMon'], [], [None]),
    "SwVlan": MoMeta("SwVlan", "swVlan", "vlan-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'dcxVc', u'swEthEstcEp', u'swEthEstcPc', u'swEthLanBorder', u'swEthLanEp', u'swEthLanPc', u'swEthMon', u'swFcSanBorder', u'swFcoeEstcEp', u'swFcoeSanEp', u'swFcoeSanPc', u'swNetflowExporter', u'vnicInternalProfile', u'vnicRackServerDiscoveryProfile'], [u'fabricNetflowIPv4Addr', u'faultInst'], ["Get"]),
    "SwVlanGroup": MoMeta("SwVlanGroup", "swVlanGroup", "vlan-group-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'swEthLanBorder'], [u'swVIFRef', u'swVlanRef'], [None]),
    "SwVlanPortNs": MoMeta("SwVlanPortNs", "swVlanPortNs", "vlan-port-ns", VersionMeta.Version131c, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'faultInst'], ["Get"]),
    "SwVlanPortNsOverride": MoMeta("SwVlanPortNsOverride", "swVlanPortNsOverride", "vlan-port-override", VersionMeta.Version142b, "InputOutput", 0x1, [], ["admin"], [u'topSysDefaults'], [], ["Get"]),
    "SwVlanRef": MoMeta("SwVlanRef", "swVlanRef", "vlanref-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'swVlanGroup'], [], [None]),
    "SwVsan": MoMeta("SwVsan", "swVsan", "vsan-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'dcxFcoeVifEp', u'dcxVc', u'dcxVifEp', u'swFcMon', u'swFcSanBorder'], [u'swFcZoneSet'], ["Get"]),
    "SwZoneInitiatorMember": MoMeta("SwZoneInitiatorMember", "swZoneInitiatorMember", "initiator-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'swFcServerZoneGroup'], [u'swFcZone'], [None]),
    "SwZoneTargetMember": MoMeta("SwZoneTargetMember", "swZoneTargetMember", "target-[wwpn]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'swFcZone'], [], [None]),
    "SwatAction": MoMeta("SwatAction", "swatAction", "action-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'swatInjection'], [u'swatCondition', u'swatTarget', u'swatTrigger'], ["Get"]),
    "SwatCondition": MoMeta("SwatCondition", "swatCondition", "cond-[var_name]-[operation]-[var_value]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'swatAction', u'swatTrigger'], [], ["Get"]),
    "SwatInjection": MoMeta("SwatInjection", "swatInjection", "inject-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'swatAction'], ["Get"]),
    "SwatResultstats": MoMeta("SwatResultstats", "swatResultstats", "", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [], [], ["Get"]),
    "SwatTarget": MoMeta("SwatTarget", "swatTarget", "target-[var_name]-[var_value]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'swatAction'], [], ["Get"]),
    "SwatTrigger": MoMeta("SwatTrigger", "swatTrigger", "trigger-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'swatAction', u'swatTrigger'], [u'swatCondition', u'swatTrigger'], ["Get"]),
    "SyntheticDirectory": MoMeta("SyntheticDirectory", "syntheticDirectory", "dir-[ino]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'syntheticDirectory', u'topSystem'], [u'syntheticDirectory', u'syntheticFile'], ["Get"]),
    "SyntheticFile": MoMeta("SyntheticFile", "syntheticFile", "file-[ino]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'syntheticDirectory'], [], ["Get"]),
    "SyntheticFileSystem": MoMeta("SyntheticFileSystem", "syntheticFileSystem", "FS-", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [], ["Get"]),
    "SyntheticFsObj": MoMeta("SyntheticFsObj", "syntheticFsObj", "file-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'eventInst', u'faultInst', u'syntheticFsObjFsm', u'syntheticFsObjFsmTask'], ["Get"]),
    "SyntheticFsObjFsm": MoMeta("SyntheticFsObjFsm", "syntheticFsObjFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'syntheticFsObj'], [u'syntheticFsObjFsmStage'], [None]),
    "SyntheticFsObjFsmStage": MoMeta("SyntheticFsObjFsmStage", "syntheticFsObjFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'syntheticFsObjFsm'], [], [None]),
    "SyntheticFsObjFsmTask": MoMeta("SyntheticFsObjFsmTask", "syntheticFsObjFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'syntheticFsObj'], [], [None]),
    "SyntheticTime": MoMeta("SyntheticTime", "syntheticTime", "time-[ts]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [], [], ["Get"]),
    "SysdebugAutoCoreFileExportTarget": MoMeta("SysdebugAutoCoreFileExportTarget", "sysdebugAutoCoreFileExportTarget", "file-export", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugEp'], [u'eventInst', u'faultInst', u'sysdebugAutoCoreFileExportTargetFsm', u'sysdebugAutoCoreFileExportTargetFsmTask'], ["Get", "Set"]),
    "SysdebugAutoCoreFileExportTargetFsm": MoMeta("SysdebugAutoCoreFileExportTargetFsm", "sysdebugAutoCoreFileExportTargetFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'sysdebugAutoCoreFileExportTarget'], [u'sysdebugAutoCoreFileExportTargetFsmStage'], [None]),
    "SysdebugAutoCoreFileExportTargetFsmStage": MoMeta("SysdebugAutoCoreFileExportTargetFsmStage", "sysdebugAutoCoreFileExportTargetFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'sysdebugAutoCoreFileExportTargetFsm'], [], [None]),
    "SysdebugAutoCoreFileExportTargetFsmTask": MoMeta("SysdebugAutoCoreFileExportTargetFsmTask", "sysdebugAutoCoreFileExportTargetFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'sysdebugAutoCoreFileExportTarget'], [], [None]),
    "SysdebugBackupBehavior": MoMeta("SysdebugBackupBehavior", "sysdebugBackupBehavior", "backup", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugMEpLogPolicy'], [], ["Get", "Set"]),
    "SysdebugCore": MoMeta("SysdebugCore", "sysdebugCore", "file-[name]|[switch_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugCoreFileRepository'], [u'eventInst', u'faultInst', u'sysdebugCoreFsm', u'sysdebugCoreFsmTask', u'sysdebugManualCoreFileExportTarget', u'sysfileMutation'], ["Get"]),
    "SysdebugCoreFileRepository": MoMeta("SysdebugCoreFileRepository", "sysdebugCoreFileRepository", "corefiles", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'topSystem'], [u'sysdebugCore', u'sysfileMutation'], ["Get"]),
    "SysdebugCoreFsm": MoMeta("SysdebugCoreFsm", "sysdebugCoreFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'sysdebugCore'], [u'sysdebugCoreFsmStage'], [None]),
    "SysdebugCoreFsmStage": MoMeta("SysdebugCoreFsmStage", "sysdebugCoreFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'sysdebugCoreFsm'], [], [None]),
    "SysdebugCoreFsmTask": MoMeta("SysdebugCoreFsmTask", "sysdebugCoreFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], [u'sysdebugCore'], [], [None]),
    "SysdebugEp": MoMeta("SysdebugEp", "sysdebugEp", "sysdebug", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [u'sysdebugAutoCoreFileExportTarget', u'sysdebugLogControlEp', u'sysdebugLogExportPolicy'], ["Get"]),
    "SysdebugLogControlDestinationFile": MoMeta("SysdebugLogControlDestinationFile", "sysdebugLogControlDestinationFile", "file", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugLogControlDomain'], [], ["Get"]),
    "SysdebugLogControlDestinationSyslog": MoMeta("SysdebugLogControlDestinationSyslog", "sysdebugLogControlDestinationSyslog", "syslog", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugLogControlDomain'], [], ["Get"]),
    "SysdebugLogControlDomain": MoMeta("SysdebugLogControlDomain", "sysdebugLogControlDomain", "domain-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugLogControlEp'], [u'sysdebugLogControlDestinationFile', u'sysdebugLogControlDestinationSyslog', u'sysdebugLogControlModule'], ["Get"]),
    "SysdebugLogControlEp": MoMeta("SysdebugLogControlEp", "sysdebugLogControlEp", "logcontrol", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugEp'], [u'eventInst', u'faultInst', u'sysdebugLogControlDomain', u'sysdebugLogControlEpFsm', u'sysdebugLogControlEpFsmTask'], ["Get"]),
    "SysdebugLogControlEpFsm": MoMeta("SysdebugLogControlEpFsm", "sysdebugLogControlEpFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'sysdebugLogControlEp'], [u'sysdebugLogControlEpFsmStage'], [None]),
    "SysdebugLogControlEpFsmStage": MoMeta("SysdebugLogControlEpFsmStage", "sysdebugLogControlEpFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'sysdebugLogControlEpFsm'], [], [None]),
    "SysdebugLogControlEpFsmTask": MoMeta("SysdebugLogControlEpFsmTask", "sysdebugLogControlEpFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'sysdebugLogControlEp'], [], [None]),
    "SysdebugLogControlModule": MoMeta("SysdebugLogControlModule", "sysdebugLogControlModule", "module-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugLogControlDomain'], [], ["Get"]),
    "SysdebugLogExportPolicy": MoMeta("SysdebugLogExportPolicy", "sysdebugLogExportPolicy", "log-export-policy", VersionMeta.Version222c, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugEp'], [u'eventInst', u'faultInst', u'sysdebugLogExportPolicyFsm', u'sysdebugLogExportPolicyFsmTask', u'sysdebugLogExportStatus'], ["Get", "Set"]),
    "SysdebugLogExportPolicyFsm": MoMeta("SysdebugLogExportPolicyFsm", "sysdebugLogExportPolicyFsm", "fsm", VersionMeta.Version222c, "OutputOnly", 0x1, [], [""], [u'sysdebugLogExportPolicy'], [u'sysdebugLogExportPolicyFsmStage'], [None]),
    "SysdebugLogExportPolicyFsmStage": MoMeta("SysdebugLogExportPolicyFsmStage", "sysdebugLogExportPolicyFsmStage", "stage-[name]", VersionMeta.Version222c, "OutputOnly", 0x1, [], [""], [u'sysdebugLogExportPolicyFsm'], [], [None]),
    "SysdebugLogExportPolicyFsmTask": MoMeta("SysdebugLogExportPolicyFsmTask", "sysdebugLogExportPolicyFsmTask", "task-[item]", VersionMeta.Version222c, "OutputOnly", 0x1, [], [""], [u'sysdebugLogExportPolicy'], [], [None]),
    "SysdebugLogExportStatus": MoMeta("SysdebugLogExportStatus", "sysdebugLogExportStatus", "log-export-status-[switch_id]", VersionMeta.Version222c, "InputOutput", 0x1, [], ["read-only"], [u'sysdebugLogExportPolicy'], [u'faultInst'], ["Get"]),
    "SysdebugMEpLog": MoMeta("SysdebugMEpLog", "sysdebugMEpLog", "log-[type]-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'mgmtController'], [u'faultInst'], ["Get", "Set"]),
    "SysdebugMEpLogPolicy": MoMeta("SysdebugMEpLogPolicy", "sysdebugMEpLogPolicy", "log-[type]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "operations"], [u'orgOrg'], [u'sysdebugBackupBehavior'], ["Get"]),
    "SysdebugManualCoreFileExportTarget": MoMeta("SysdebugManualCoreFileExportTarget", "sysdebugManualCoreFileExportTarget", "export-to-[hostname]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugCore'], [u'eventInst', u'faultInst', u'sysdebugManualCoreFileExportTargetFsm', u'sysdebugManualCoreFileExportTargetFsmTask'], ["Get"]),
    "SysdebugManualCoreFileExportTargetFsm": MoMeta("SysdebugManualCoreFileExportTargetFsm", "sysdebugManualCoreFileExportTargetFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'sysdebugManualCoreFileExportTarget'], [u'sysdebugManualCoreFileExportTargetFsmStage'], [None]),
    "SysdebugManualCoreFileExportTargetFsmStage": MoMeta("SysdebugManualCoreFileExportTargetFsmStage", "sysdebugManualCoreFileExportTargetFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'sysdebugManualCoreFileExportTargetFsm'], [], [None]),
    "SysdebugManualCoreFileExportTargetFsmTask": MoMeta("SysdebugManualCoreFileExportTargetFsmTask", "sysdebugManualCoreFileExportTargetFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'sysdebugManualCoreFileExportTarget'], [], [None]),
    "SysdebugTechSupFileRepository": MoMeta("SysdebugTechSupFileRepository", "sysdebugTechSupFileRepository", "tech-support-files", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "operations"], [u'topSystem'], [u'sysdebugTechSupport'], ["Get"]),
    "SysdebugTechSupport": MoMeta("SysdebugTechSupport", "sysdebugTechSupport", "tech-support-[creation_ts]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugTechSupFileRepository'], [u'eventInst', u'faultInst', u'sysdebugTechSupportCmdOpt', u'sysdebugTechSupportFsm', u'sysdebugTechSupportFsmTask'], ["Add", "Get", "Set"]),
    "SysdebugTechSupportCmdOpt": MoMeta("SysdebugTechSupportCmdOpt", "sysdebugTechSupportCmdOpt", "tech-support-cmd-opt", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugTechSupport'], [], ["Add", "Get", "Set"]),
    "SysdebugTechSupportFsm": MoMeta("SysdebugTechSupportFsm", "sysdebugTechSupportFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'sysdebugTechSupport'], [u'sysdebugTechSupportFsmStage'], [None]),
    "SysdebugTechSupportFsmStage": MoMeta("SysdebugTechSupportFsmStage", "sysdebugTechSupportFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'sysdebugTechSupportFsm'], [], [None]),
    "SysdebugTechSupportFsmTask": MoMeta("SysdebugTechSupportFsmTask", "sysdebugTechSupportFsmTask", "task-[item]", VersionMeta.Version141i, "OutputOnly", 0x1, [], [""], [u'sysdebugTechSupport'], [], [None]),
    "SysfileDigest": MoMeta("SysfileDigest", "sysfileDigest", "filedigest-[name]-[creation_ts]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "SysfileMutation": MoMeta("SysfileMutation", "sysfileMutation", "mutation", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugCore', u'sysdebugCoreFileRepository'], [u'eventInst', u'faultInst', u'sysfileMutationFsm', u'sysfileMutationFsmTask'], ["Add", "Get"]),
    "SysfileMutationFsm": MoMeta("SysfileMutationFsm", "sysfileMutationFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'sysfileMutation'], [u'sysfileMutationFsmStage'], [None]),
    "SysfileMutationFsmStage": MoMeta("SysfileMutationFsmStage", "sysfileMutationFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'sysfileMutationFsm'], [], [None]),
    "SysfileMutationFsmTask": MoMeta("SysfileMutationFsmTask", "sysfileMutationFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'sysfileMutation'], [], [None]),
    "TopInfoPolicy": MoMeta("TopInfoPolicy", "topInfoPolicy", "info-policy", VersionMeta.Version223a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-san-config"], [u'topSystem'], [], ["Get", "Set"]),
    "TopInfoSyncPolicy": MoMeta("TopInfoSyncPolicy", "topInfoSyncPolicy", "info-sync-policy", VersionMeta.Version227b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-san-config"], [u'orgOrg'], [], [None]),
    "TopMetaInf": MoMeta("TopMetaInf", "topMetaInf", "meta", VersionMeta.Version111j, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [], ["Get"]),
    "TopRoot": MoMeta("TopRoot", "topRoot", "", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [], [u'aaaLog', u'apeManager', u'callhomeEp', u'capabilityCatalogue', u'clitestTypeTest', u'clitestTypeTest2', u'computeDefaults', u'dhcpInst', u'eventHolder', u'eventLog', u'extpolEp', u'fabricEp', u'faultHolder', u'fcpoolUniverse', u'gmetaEp', u'identMetaVerse', u'ippoolUniverse', u'iqnpoolUniverse', u'macpoolUniverse', u'morefImportRoot', u'nfsEp', u'observeObservedCont', u'orgOrg', u'policyPolicyEp', u'procManager', u'statsHolder', u'storageDomainEp', u'syntheticFileSystem', u'topMetaInf', u'topSysDefaults', u'topSystem', u'uuidpoolUniverse', u'vmEp'], ["Get"]),
    "TopSysDefaults": MoMeta("TopSysDefaults", "topSysDefaults", "sys-defaults", VersionMeta.Version142b, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'capabilityNetworkLimits', u'capabilityStorageLimits', u'capabilitySystemLimits', u'swFabricZoneNsOverride', u'swVlanPortNsOverride'], ["Get"]),
    "TopSystem": MoMeta("TopSystem", "topSystem", "sys", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'topRoot'], [u'aaaAuthRealm', u'aaaLdapEp', u'aaaRadiusEp', u'aaaSessionInfoTable', u'aaaTacacsPlusEp', u'aaaUserEp', u'commSvcEp', u'computeRackUnit', u'controllerHaController', u'domainEnvironmentFeatureCont', u'domainNetworkFeatureCont', u'domainServerFeatureCont', u'domainStorageFeatureCont', u'equipmentChassis', u'equipmentFex', u'extmgmtIfMonPolicy', u'extvmmEp', u'featureContextEp', u'firmwareCatalogue', u'firmwareStatus', u'firmwareSystem', u'firmwareUpgradeInfo', u'fsmStatus', u'initiatorRequestorEp', u'initiatorRequestorGrpEp', u'licenseEp', u'mgmtAccessPolicy', u'mgmtBackup', u'mgmtBackupPolicyConfig', u'mgmtController', u'mgmtEntity', u'mgmtImporter', u'mgmtIntAuthPolicy', u'networkElement', u'pkiEp', u'policyControlEp', u'powerEp', u'swatInjection', u'syntheticDirectory', u'syntheticFsObj', u'sysdebugCoreFileRepository', u'sysdebugEp', u'sysdebugTechSupFileRepository', u'topInfoPolicy', u'trigLocalSched', u'trigMeta', u'trigSched', u'versionEp'], ["Get", "Set"]),
    "TrigAbsWindow": MoMeta("TrigAbsWindow", "trigAbsWindow", "abs-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'trigLocalSched', u'trigSched'], [], ["Add", "Get", "Remove", "Set"]),
    "TrigClientToken": MoMeta("TrigClientToken", "trigClientToken", "clienttoken-[id]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'trigTriggered'], [], [None]),
    "TrigLocalAbsWindow": MoMeta("TrigLocalAbsWindow", "trigLocalAbsWindow", "local-abs-default", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'trigLocalSched', u'trigSched'], [], ["Add", "Get", "Set"]),
    "TrigLocalSched": MoMeta("TrigLocalSched", "trigLocalSched", "local-sched-default", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin"], [u'computeFwSyncAck', u'cpmaintAck', u'faultSuppressTask', u'firmwareAck', u'firmwareInfra', u'lsmaintAck', u'mgmtBackupPolicyConfig', u'topSystem', u'trigTest'], [u'trigAbsWindow', u'trigLocalAbsWindow', u'trigRecurrWindow'], ["Add", "Get"]),
    "TrigMeta": MoMeta("TrigMeta", "trigMeta", "meta-trig-[sched_name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [u'trigTriggered'], ["Get"]),
    "TrigRecurrWindow": MoMeta("TrigRecurrWindow", "trigRecurrWindow", "recurr-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'trigLocalSched', u'trigSched'], [], ["Add", "Get", "Remove", "Set"]),
    "TrigSched": MoMeta("TrigSched", "trigSched", "sched-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'topSystem'], [u'trigAbsWindow', u'trigLocalAbsWindow', u'trigRecurrWindow'], ["Add", "Get", "Remove", "Set"]),
    "TrigTest": MoMeta("TrigTest", "trigTest", "test-[name]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'faultInst', u'trigLocalSched'], ["Get"]),
    "TrigTriggered": MoMeta("TrigTriggered", "trigTriggered", "trig-[tr_id]", VersionMeta.Version141i, "InputOutput", 0x1, [], ["read-only"], [u'trigMeta'], [u'trigClientToken'], ["Get"]),
    "UuidpoolAddr": MoMeta("UuidpoolAddr", "uuidpoolAddr", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'uuidpoolUniverse'], [u'faultInst', u'uuidpoolPoolable'], ["Get"]),
    "UuidpoolBlock": MoMeta("UuidpoolBlock", "uuidpoolBlock", "block-from-[r_from]-to-[to]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'uuidpoolPool'], [], ["Add", "Get", "Remove"]),
    "UuidpoolFormat": MoMeta("UuidpoolFormat", "uuidpoolFormat", "format-[format]-[mask]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-storage", "ls-storage-policy"], [u'uuidpoolUniverse'], [], ["Get"]),
    "UuidpoolPool": MoMeta("UuidpoolPool", "uuidpoolPool", "uuid-pool-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [u'faultInst', u'uuidpoolBlock', u'uuidpoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "UuidpoolPoolable": MoMeta("UuidpoolPoolable", "uuidpoolPoolable", "pool-[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'uuidpoolAddr'], [], ["Get"]),
    "UuidpoolPooled": MoMeta("UuidpoolPooled", "uuidpoolPooled", "[id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'uuidpoolPool'], [], ["Get"]),
    "UuidpoolUniverse": MoMeta("UuidpoolUniverse", "uuidpoolUniverse", "uuid", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'uuidpoolAddr', u'uuidpoolFormat'], ["Get"]),
    "VersionApplication": MoMeta("VersionApplication", "versionApplication", "application", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'versionEp'], [], [None]),
    "VersionEp": MoMeta("VersionEp", "versionEp", "version", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [u'versionApplication'], [None]),
    "VmComputeEp": MoMeta("VmComputeEp", "vmComputeEp", "computeEp-[uuid]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "read-only"], [u'vmEp'], [u'vmHba', u'vmNic'], ["Get"]),
    "VmDC": MoMeta("VmDC", "vmDC", "dc-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], [u'extvmmProvider', u'vmDCOrg'], [u'vmOrg'], ["Add", "Get", "Remove", "Set"]),
    "VmDCOrg": MoMeta("VmDCOrg", "vmDCOrg", "dc-cont-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], [u'extvmmProvider'], [u'vmDC'], ["Add", "Get", "Remove", "Set"]),
    "VmEp": MoMeta("VmEp", "vmEp", "vmm", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'vmComputeEp', u'vmHv', u'vmInstance'], ["Get"]),
    "VmHba": MoMeta("VmHba", "vmHba", "hba-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "read-only"], [u'vmComputeEp', u'vmHv', u'vmInstance'], [u'vmVsan'], ["Get"]),
    "VmHv": MoMeta("VmHv", "vmHv", "hv-[uuid]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "read-only"], [u'vmEp'], [u'vmHba', u'vmNic'], ["Get"]),
    "VmInstance": MoMeta("VmInstance", "vmInstance", "vm-[uuid]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "read-only"], [u'vmEp'], [u'vmHba', u'vmNic'], ["Get"]),
    "VmLifeCyclePolicy": MoMeta("VmLifeCyclePolicy", "vmLifeCyclePolicy", "vm-lc-policy", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [u'eventInst', u'faultInst', u'vmLifeCyclePolicyFsm', u'vmLifeCyclePolicyFsmTask'], ["Get", "Set"]),
    "VmLifeCyclePolicyFsm": MoMeta("VmLifeCyclePolicyFsm", "vmLifeCyclePolicyFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'vmLifeCyclePolicy'], [u'vmLifeCyclePolicyFsmStage'], [None]),
    "VmLifeCyclePolicyFsmStage": MoMeta("VmLifeCyclePolicyFsmStage", "vmLifeCyclePolicyFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'vmLifeCyclePolicyFsm'], [], [None]),
    "VmLifeCyclePolicyFsmTask": MoMeta("VmLifeCyclePolicyFsmTask", "vmLifeCyclePolicyFsmTask", "task-[item]", VersionMeta.Version201m, "OutputOnly", 0x1, [], [""], [u'vmLifeCyclePolicy'], [], [None]),
    "VmNic": MoMeta("VmNic", "vmNic", "nic-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "read-only"], [u'vmComputeEp', u'vmHv', u'vmInstance'], [u'adaptorEthPortBySizeLargeStats', u'adaptorEthPortBySizeSmallStats', u'adaptorEthPortErrStats', u'adaptorEthPortMcastStats', u'adaptorEthPortOutsizedStats', u'adaptorEthPortStats', u'adaptorFcPortStats', u'adaptorVnicStats', u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'faultInst', u'vmVif', u'vmVlan'], ["Get"]),
    "VmOrg": MoMeta("VmOrg", "vmOrg", "org-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], [u'vmDC'], [u'vmSwitch'], ["Add", "Get", "Remove", "Set"]),
    "VmSwitch": MoMeta("VmSwitch", "vmSwitch", "switch-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], [u'extvmmProvider', u'extvmmSwitchSet', u'vmOrg'], [u'extvmmUpLinkPP', u'vmVnicProfInst'], ["Add", "Get", "Remove", "Set"]),
    "VmVif": MoMeta("VmVif", "vmVif", "sw-[ph_switch_id]vif-[vif_id]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin"], [u'vmNic'], [u'faultInst'], ["Get"]),
    "VmVlan": MoMeta("VmVlan", "vmVlan", "net-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'vmNic'], [], ["Get"]),
    "VmVnicProfCl": MoMeta("VmVnicProfCl", "vmVnicProfCl", "cl-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "ls-network", "pn-policy"], [u'vnicProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "VmVnicProfInst": MoMeta("VmVnicProfInst", "vmVnicProfInst", "vnic-prof-[name]", VersionMeta.Version111j, "InputOutput", 0x1, [], ["read-only"], [u'vmSwitch'], [u'vnicOProfileAlias', u'vnicProfileAlias'], ["Get"]),
    "VmVsan": MoMeta("VmVsan", "vmVsan", "net-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'vmHba'], [], ["Get"]),
    "VnicBootIpPolicy": MoMeta("VnicBootIpPolicy", "vnicBootIpPolicy", "", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [], [], ["Get"]),
    "VnicBootTarget": MoMeta("VnicBootTarget", "vnicBootTarget", "boot-target", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], [u'vnicFc'], [], ["Get"]),
    "VnicConnDef": MoMeta("VnicConnDef", "vnicConnDef", "conn-def", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'lsServer'], [u'faultInst'], ["Add", "Get", "Set"]),
    "VnicDefBeh": MoMeta("VnicDefBeh", "vnicDefBeh", "def-beh-[type]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server"], [u'lsServer'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicDynamicCon": MoMeta("VnicDynamicCon", "vnicDynamicCon", "dynamic-con", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-network-policy", "ls-server"], [u'lsServer'], [], ["Get", "Set"]),
    "VnicDynamicConPolicy": MoMeta("VnicDynamicConPolicy", "vnicDynamicConPolicy", "dynamic-con-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicDynamicConPolicyRef": MoMeta("VnicDynamicConPolicyRef", "vnicDynamicConPolicyRef", "con-ref-[con_policy_name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'vnicEther', u'vnicLanConnTempl'], [u'faultInst'], ["Add", "Get", "Remove"]),
    "VnicDynamicIdUniverse": MoMeta("VnicDynamicIdUniverse", "vnicDynamicIdUniverse", "dynamic-id-universe-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [], [], ["Get"]),
    "VnicDynamicProvider": MoMeta("VnicDynamicProvider", "vnicDynamicProvider", "dynamic-provider-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'vnicProfileSet'], [u'vnicDynamicProviderEp'], ["Get"]),
    "VnicDynamicProviderEp": MoMeta("VnicDynamicProviderEp", "vnicDynamicProviderEp", "ep-[switch_id]-[chassis_id]:[slot_id]:[port_id]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'vnicDynamicProvider'], [], ["Get"]),
    "VnicEthConfig": MoMeta("VnicEthConfig", "vnicEthConfig", "eth-vnic", VersionMeta.Version302a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'vnicIScsiInitAutoConfigPolicy'], [u'faultInst'], [None]),
    "VnicEthLif": MoMeta("VnicEthLif", "vnicEthLif", "eth-lif-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-storage"], [], [], ["Get"]),
    "VnicEther": MoMeta("VnicEther", "vnicEther", "ether-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'lsServer', u'vnicLanConnPolicy'], [u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'fabricNetflowMonSrcEp', u'faultInst', u'vnicDynamicConPolicyRef', u'vnicEtherIf', u'vnicFcOEIf', u'vnicLifVlan', u'vnicMacHistory', u'vnicUsnicConPolicyRef', u'vnicVmqConPolicyRef'], ["Add", "Get", "Remove", "Set"]),
    "VnicEtherIf": MoMeta("VnicEtherIf", "vnicEtherIf", "if-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'extvmmVMNetworkDefinition', u'fabricFlowMonExporterProfile', u'vnicEther', u'vnicIpc', u'vnicLanConnTempl', u'vnicProfile'], [u'fabricNetflowIPv4Addr', u'faultInst', u'vnicIPv4If'], ["Add", "Get", "Remove", "Set"]),
    "VnicFc": MoMeta("VnicFc", "vnicFc", "fc-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], [u'lsServer', u'vnicSanConnPolicy'], [u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'fabricNetflowMonSrcEp', u'faultInst', u'vnicBootTarget', u'vnicFcIf', u'vnicWwpnHistory'], ["Add", "Get", "Remove", "Set"]),
    "VnicFcGroupDef": MoMeta("VnicFcGroupDef", "vnicFcGroupDef", "fc-group", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageIniGroup'], [u'faultInst', u'storageConnectionDef'], ["Add", "Get", "Set"]),
    "VnicFcGroupTempl": MoMeta("VnicFcGroupTempl", "vnicFcGroupTempl", "fc-group-templ-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], [u'orgOrg'], [u'faultInst'], [None]),
    "VnicFcIf": MoMeta("VnicFcIf", "vnicFcIf", "if-default", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin"], [u'vnicFc', u'vnicSanConnTempl'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "VnicFcLif": MoMeta("VnicFcLif", "vnicFcLif", "eth-lif-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [], [u'vnicLifVsan'], ["Get"]),
    "VnicFcNode": MoMeta("VnicFcNode", "vnicFcNode", "fc-node", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], [u'lsServer', u'vnicSanConnPolicy'], [u'faultInst', u'vnicWwnnHistory'], ["Add", "Get", "Remove", "Set"]),
    "VnicFcOEIf": MoMeta("VnicFcOEIf", "vnicFcOEIf", "fcoe", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy", "ls-config", "ls-server", "ls-storage"], [u'vnicEther', u'vnicIpc', u'vnicLanConnTempl'], [], ["Get"]),
    "VnicIPv4Dhcp": MoMeta("VnicIPv4Dhcp", "vnicIPv4Dhcp", "ipv4-dhcp", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'adaptorHostIscsiIf', u'adaptorVlan', u'vnicIPv4If'], [], ["Add", "Get", "Remove"]),
    "VnicIPv4Dns": MoMeta("VnicIPv4Dns", "vnicIPv4Dns", "ipv4-dns-[pref]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'adaptorHostIscsiIf', u'adaptorVlan', u'vnicIPv4If', u'vnicIPv4IscsiAddr', u'vnicIPv4PooledIscsiAddr'], [], ["Get"]),
    "VnicIPv4If": MoMeta("VnicIPv4If", "vnicIPv4If", "ipv4", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'vnicEtherIf', u'vnicIScsiBootVnic', u'vnicVlan'], [u'fabricNetflowIPv4Addr', u'vnicIPv4Dhcp', u'vnicIPv4Dns', u'vnicIPv4IscsiAddr', u'vnicIPv4PooledIscsiAddr', u'vnicIPv4StaticRoute', u'vnicIpV4MgmtPooledAddr', u'vnicIpV4PooledAddr', u'vnicIpV4ProfDerivedAddr', u'vnicIpV4StaticAddr'], ["Add", "Get"]),
    "VnicIPv4IscsiAddr": MoMeta("VnicIPv4IscsiAddr", "vnicIPv4IscsiAddr", "ipv4iscsi", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'adaptorHostIscsiIf', u'adaptorVlan', u'vnicIPv4If', u'vnicIScsi'], [u'vnicIPv4Dns'], ["Add", "Get", "Remove", "Set"]),
    "VnicIPv4PooledIscsiAddr": MoMeta("VnicIPv4PooledIscsiAddr", "vnicIPv4PooledIscsiAddr", "ipv4-pooled-iscsiaddr", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'adaptorHostIscsiIf', u'adaptorVlan', u'vnicIPv4If'], [u'faultInst', u'vnicIPv4Dns', u'vnicIpV4History'], ["Get", "Set"]),
    "VnicIPv4StaticRoute": MoMeta("VnicIPv4StaticRoute", "vnicIPv4StaticRoute", "ipv4-route-[addr]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'adaptorHostIscsiIf', u'adaptorVlan', u'vnicIPv4If'], [], ["Get"]),
    "VnicIPv6If": MoMeta("VnicIPv6If", "vnicIPv6If", "", VersionMeta.Version302a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], [], [u'vnicIpV6StaticAddr'], [None]),
    "VnicIScsi": MoMeta("VnicIScsi", "vnicIScsi", "iscsi-[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'lsServer'], [u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'fabricNetflowMonSrcEp', u'faultInst', u'vnicIPv4IscsiAddr', u'vnicIScsiAutoTargetIf', u'vnicIScsiStaticTargetIf', u'vnicIqnHistory', u'vnicMacHistory', u'vnicVlan'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiAutoTargetIf": MoMeta("VnicIScsiAutoTargetIf", "vnicIScsiAutoTargetIf", "auto", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'adaptorVlan', u'vnicIScsi', u'vnicIScsiBootVnic', u'vnicVlan'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiBootParams": MoMeta("VnicIScsiBootParams", "vnicIScsiBootParams", "iscsi-boot-params", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'lsServer'], [u'vnicIScsiBootVnic'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiBootVnic": MoMeta("VnicIScsiBootVnic", "vnicIScsiBootVnic", "boot-vnic-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'vnicIScsiBootParams'], [u'faultInst', u'vnicIPv4If', u'vnicIScsiAutoTargetIf', u'vnicIScsiStaticTargetIf'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiConfig": MoMeta("VnicIScsiConfig", "vnicIScsiConfig", "iscsi-vnic", VersionMeta.Version302a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'vnicIScsiInitAutoConfigPolicy'], [u'faultInst'], [None]),
    "VnicIScsiInitAutoConfigPolicy": MoMeta("VnicIScsiInitAutoConfigPolicy", "vnicIScsiInitAutoConfigPolicy", "iscsi-init-autoconf-[name]", VersionMeta.Version302a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'orgOrg'], [u'vnicEthConfig', u'vnicIScsiConfig'], [None]),
    "VnicIScsiLCP": MoMeta("VnicIScsiLCP", "vnicIScsiLCP", "iscsi-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'lsServer', u'vnicLanConnPolicy'], [u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'fabricNetflowMonSrcEp', u'faultInst', u'vnicVlan'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiNode": MoMeta("VnicIScsiNode", "vnicIScsiNode", "iscsi-node", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'lsServer', u'vnicLanConnPolicy'], [u'faultInst', u'vnicIqnHistory'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiStaticTargetIf": MoMeta("VnicIScsiStaticTargetIf", "vnicIScsiStaticTargetIf", "[priority]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'adaptorVlan', u'vnicIScsi', u'vnicIScsiBootVnic', u'vnicVlan'], [u'faultInst', u'vnicLun'], ["Add", "Get", "Remove", "Set"]),
    "VnicInternalProfile": MoMeta("VnicInternalProfile", "vnicInternalProfile", "vnic-[name]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [u'vnicProfileSet'], [u'swVlan'], ["Get"]),
    "VnicIpV4History": MoMeta("VnicIpV4History", "vnicIpV4History", "ipv4-history", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [u'vnicIPv4PooledIscsiAddr', u'vnicIpV4MgmtPooledAddr', u'vnicIpV4PooledAddr'], [], [None]),
    "VnicIpV4MgmtPooledAddr": MoMeta("VnicIpV4MgmtPooledAddr", "vnicIpV4MgmtPooledAddr", "ipv4-pooled-addr", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'adaptorHostIscsiIf', u'adaptorVlan', u'lsServer', u'mgmtVnet', u'vnicIPv4If'], [u'faultInst', u'vnicIpV4History'], ["Get", "Remove", "Set"]),
    "VnicIpV4PooledAddr": MoMeta("VnicIpV4PooledAddr", "vnicIpV4PooledAddr", "ipv4-pooled-addr", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'adaptorHostIscsiIf', u'adaptorVlan', u'lsServer', u'mgmtController', u'mgmtVnet', u'vnicIPv4If'], [u'faultInst', u'vnicIpV4History'], ["Get"]),
    "VnicIpV4ProfDerivedAddr": MoMeta("VnicIpV4ProfDerivedAddr", "vnicIpV4ProfDerivedAddr", "ipv4-prof-addr", VersionMeta.Version141i, "InputOutput", 0x1, [], ["admin"], [u'adaptorHostIscsiIf', u'adaptorVlan', u'mgmtController', u'vnicIPv4If'], [], ["Get"]),
    "VnicIpV4StaticAddr": MoMeta("VnicIpV4StaticAddr", "vnicIpV4StaticAddr", "ipv4-static-addr", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'adaptorHostIscsiIf', u'adaptorVlan', u'lsServer', u'lsbootLanImagePath', u'mgmtController', u'mgmtVnet', u'vnicIPv4If'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicIpV6History": MoMeta("VnicIpV6History", "vnicIpV6History", "ipv6-history", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [u'vnicIpV6MgmtPooledAddr'], [], [None]),
    "VnicIpV6MgmtPooledAddr": MoMeta("VnicIpV6MgmtPooledAddr", "vnicIpV6MgmtPooledAddr", "ipv6-pooled-addr", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'mgmtVnet'], [u'faultInst', u'vnicIpV6History'], ["Add", "Get", "Remove", "Set"]),
    "VnicIpV6StaticAddr": MoMeta("VnicIpV6StaticAddr", "vnicIpV6StaticAddr", "ipv6-static-addr", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'mgmtVnet', u'vnicIPv6If'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicIpc": MoMeta("VnicIpc", "vnicIpc", "ipc-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'lsServer'], [u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'fabricNetflowMonSrcEp', u'faultInst', u'vnicEtherIf', u'vnicFcOEIf', u'vnicLifVlan'], ["Get"]),
    "VnicIpcIf": MoMeta("VnicIpcIf", "vnicIpcIf", "if-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [], [], ["Get"]),
    "VnicIqnHistory": MoMeta("VnicIqnHistory", "vnicIqnHistory", "iqn-history", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [u'vnicIScsi', u'vnicIScsiNode'], [], [None]),
    "VnicLanConnPolicy": MoMeta("VnicLanConnPolicy", "vnicLanConnPolicy", "lan-conn-pol-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'orgOrg'], [u'vnicEther', u'vnicIScsiLCP', u'vnicIScsiNode'], ["Add", "Get", "Remove"]),
    "VnicLanConnTempl": MoMeta("VnicLanConnTempl", "vnicLanConnTempl", "lan-conn-templ-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'orgOrg'], [u'faultInst', u'vnicDynamicConPolicyRef', u'vnicEtherIf', u'vnicFcOEIf', u'vnicUsnicConPolicyRef', u'vnicVmqConPolicyRef'], ["Add", "Get", "Remove", "Set"]),
    "VnicLifVlan": MoMeta("VnicLifVlan", "vnicLifVlan", "vlan-[vnet]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'vnicEther', u'vnicIpc'], [], ["Get"]),
    "VnicLifVsan": MoMeta("VnicLifVsan", "vnicLifVsan", "vsan-[vnet]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'vnicFcLif'], [], ["Get"]),
    "VnicLun": MoMeta("VnicLun", "vnicLun", "lun", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], [u'vnicIScsiStaticTargetIf'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicMacHistory": MoMeta("VnicMacHistory", "vnicMacHistory", "mac-history", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [u'vnicEther', u'vnicIScsi'], [], [None]),
    "VnicOProfileAlias": MoMeta("VnicOProfileAlias", "vnicOProfileAlias", "swid-[v_switch_name]alias-[alias]", VersionMeta.Version201m, "InputOutput", 0x1, [], ["read-only"], [u'vmVnicProfInst', u'vnicProfile'], [], ["Get"]),
    "VnicProfile": MoMeta("VnicProfile", "vnicProfile", "vnic-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'vnicProfileSet'], [u'fabricNetflowMonSrcEp', u'faultInst', u'swNetflowMonitorRef', u'vmVnicProfCl', u'vnicEtherIf', u'vnicOProfileAlias', u'vnicProfileAlias'], ["Add", "Get", "Remove", "Set"]),
    "VnicProfileAlias": MoMeta("VnicProfileAlias", "vnicProfileAlias", "uuid-[sw_uuid]alias-[alias]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["read-only"], [u'vmVnicProfInst', u'vnicProfile'], [], ["Get"]),
    "VnicProfileRef": MoMeta("VnicProfileRef", "vnicProfileRef", "vnic-profileref-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "VnicProfileSet": MoMeta("VnicProfileSet", "vnicProfileSet", "profiles", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricLanCloud'], [u'eventInst', u'faultInst', u'vnicDynamicProvider', u'vnicInternalProfile', u'vnicProfile', u'vnicProfileSetFsm', u'vnicProfileSetFsmTask', u'vnicRackServerDiscoveryProfile'], ["Get"]),
    "VnicProfileSetFsm": MoMeta("VnicProfileSetFsm", "vnicProfileSetFsm", "fsm", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'vnicProfileSet'], [u'vnicProfileSetFsmStage'], [None]),
    "VnicProfileSetFsmStage": MoMeta("VnicProfileSetFsmStage", "vnicProfileSetFsmStage", "stage-[name]", VersionMeta.Version211a, "OutputOnly", 0x1, [], [""], [u'vnicProfileSetFsm'], [], [None]),
    "VnicProfileSetFsmTask": MoMeta("VnicProfileSetFsmTask", "vnicProfileSetFsmTask", "task-[item]", VersionMeta.Version111j, "OutputOnly", 0x1, [], [""], [u'vnicProfileSet'], [], [None]),
    "VnicRackServerDiscoveryProfile": MoMeta("VnicRackServerDiscoveryProfile", "vnicRackServerDiscoveryProfile", "vnic-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["read-only"], [u'equipmentChassis', u'vnicProfileSet'], [u'swVlan'], [None]),
    "VnicSanConnPolicy": MoMeta("VnicSanConnPolicy", "vnicSanConnPolicy", "san-conn-pol-[name]", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], [u'orgOrg'], [u'storageIniGroup', u'vnicFc', u'vnicFcNode'], ["Add", "Get", "Remove", "Set"]),
    "VnicSanConnTempl": MoMeta("VnicSanConnTempl", "vnicSanConnTempl", "san-conn-templ-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-storage", "ls-storage-policy"], [u'orgOrg'], [u'faultInst', u'vnicFcIf'], ["Add", "Get", "Remove", "Set"]),
    "VnicScsi": MoMeta("VnicScsi", "vnicScsi", "scsi-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], [u'lsServer'], [u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'fabricNetflowMonSrcEp', u'faultInst'], ["Get"]),
    "VnicScsiIf": MoMeta("VnicScsiIf", "vnicScsiIf", "if-[name]", VersionMeta.Version101e, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], [], [], ["Get"]),
    "VnicUsnicConPolicy": MoMeta("VnicUsnicConPolicy", "vnicUsnicConPolicy", "usnic-con-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-server"], [u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicUsnicConPolicyRef": MoMeta("VnicUsnicConPolicyRef", "vnicUsnicConPolicyRef", "usnic-con-ref", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'vnicEther', u'vnicLanConnTempl'], [u'faultInst'], ["Add", "Get", "Remove"]),
    "VnicVhbaBehPolicy": MoMeta("VnicVhbaBehPolicy", "vnicVhbaBehPolicy", "beh-vhba", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], [u'orgOrg'], [], ["Get", "Set"]),
    "VnicVlan": MoMeta("VnicVlan", "vnicVlan", "vlan", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'vnicIScsi', u'vnicIScsiLCP'], [u'vnicIPv4If', u'vnicIScsiAutoTargetIf', u'vnicIScsiStaticTargetIf'], ["Add", "Get", "Set"]),
    "VnicVmqConPolicy": MoMeta("VnicVmqConPolicy", "vnicVmqConPolicy", "vmq-con-[name]", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-network", "ls-network-policy", "ls-server"], [u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicVmqConPolicyRef": MoMeta("VnicVmqConPolicyRef", "vnicVmqConPolicyRef", "vmq-con-ref", VersionMeta.Version221b, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'vnicEther', u'vnicLanConnTempl'], [u'faultInst'], ["Add", "Get", "Remove"]),
    "VnicVnicBehPolicy": MoMeta("VnicVnicBehPolicy", "vnicVnicBehPolicy", "beh-vnic", VersionMeta.Version211a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'orgOrg'], [], ["Get", "Set"]),
    "VnicWwnnHistory": MoMeta("VnicWwnnHistory", "vnicWwnnHistory", "wwnn-history", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [u'vnicFcNode'], [], [None]),
    "VnicWwpnHistory": MoMeta("VnicWwpnHistory", "vnicWwpnHistory", "wwpn-history", VersionMeta.Version212a, "InputOutput", 0x1, [], ["read-only"], [u'vnicFc'], [], [None]),
}


METHOD_CLASS_ID = frozenset([
    "AaaChangeSelfPassword",
    "AaaCheckComputeAuthToken",
    "AaaCheckComputeExtAccess",
    "AaaGetAuthTokenClient",
    "AaaGetKVMLaunchUrl",
    "AaaGetNComputeAuthTokenByDn",
    "AaaKeepAlive",
    "AaaLogin",
    "AaaLogout",
    "AaaRefresh",
    "AaaTokenLogin",
    "AaaTokenRefresh",
    "ApeBootPnuOs",
    "ApeConfigureCMCLIF",
    "ApeCreateHVVnic",
    "ApeCreateSfish",
    "ApeCreateVMVnic",
    "ApeDeleteHVVnic",
    "ApeDeleteSfish",
    "ApeDeleteVMVnic",
    "ApeGetAdaptorConnectivity",
    "ApeGetApeFirmwareActiveSide",
    "ApeGetMcStats",
    "ApeGetNextId",
    "ApeGetPnuOSInventory",
    "ApeGetServerFromIp",
    "ApeGetSwitchApeFru",
    "ApeInjectStimuli",
    "ApeInsertNewChassis",
    "ApeInsertNewFex",
    "ApeInsertNewRack",
    "ApeIssueAdaptorId",
    "ApeIssueChassisId",
    "ApeIssueFexId",
    "ApeIssueRackId",
    "ApeMcGet",
    "ApeMcGetAttribute",
    "ApeMcGetAttributeData",
    "ApeMcGetBiosTokens",
    "ApeMcGetFru",
    "ApeMcGetParam",
    "ApeMcGetReading",
    "ApeMcGetSdr",
    "ApeMcGetSmbios",
    "ApeMcSet",
    "ApeMcSetAttributeData",
    "ApeMcSetParam",
    "ApeMuxOffline",
    "ApeRemoveDevice",
    "ApeSetAdaptorFirmwareVersion",
    "ApeSetApeSensorReading",
    "ApeSetFlexFlashControllerFirmwareVersion",
    "ApeSetFlexFlashControllerState",
    "ApeSetFlexFlashVirtualRaidInformation",
    "ApeSetMcStats",
    "ApeSetServerLifeCycle",
    "ApeSetSwitchInventory",
    "ApeSetVmediaMounts",
    "ApeTriggerSwInv",
    "ApeUpdateApeFirmwareActiveSide",
    "ApeUpdateApeFirmwareParamTable",
    "ApeUpdateBIOSFirmwareVersion",
    "ApeUpdateStorageCtlrFirmwareVersion",
    "ComputeGetInventory",
    "ConfigCheckCompatibility",
    "ConfigCheckConformance",
    "ConfigCheckFirmwareUpdatable",
    "ConfigConfFiltered",
    "ConfigConfMo",
    "ConfigConfMoGroup",
    "ConfigConfMos",
    "ConfigConfRename",
    "ConfigCountClass",
    "ConfigEstimateConfMos",
    "ConfigEstimateImpact",
    "ConfigFindDependencies",
    "ConfigFindDnsByClassId",
    "ConfigFindHostPackDependencies",
    "ConfigFindPermitted",
    "ConfigGetEstimateImpact",
    "ConfigGetRemotePolicies",
    "ConfigGetXmlFile",
    "ConfigGetXmlFileStr",
    "ConfigInstallAllImpact",
    "ConfigMoChangeEvent",
    "ConfigRefreshIdentity",
    "ConfigReleaseResolveContext",
    "ConfigRenewResolveContext",
    "ConfigResolveChildren",
    "ConfigResolveChildrenSorted",
    "ConfigResolveClass",
    "ConfigResolveClassSorted",
    "ConfigResolveClasses",
    "ConfigResolveClassesSorted",
    "ConfigResolveContext",
    "ConfigResolveDn",
    "ConfigResolveDns",
    "ConfigResolveParent",
    "ConfigScope",
    "EquipmentClone",
    "EquipmentInstantiateNNamedTemplate",
    "EquipmentInstantiateNTemplate",
    "EquipmentInstantiateTemplate",
    "EquipmentResolveTemplates",
    "EquipmentTemplatise",
    "EventRegisterEventChannel",
    "EventRegisterEventChannelResp",
    "EventSendEvent",
    "EventSendHeartbeat",
    "EventSubscribe",
    "EventUnRegisterEventChannel",
    "EventUnsubscribe",
    "FaultAckFault",
    "FaultAckFaults",
    "FaultResolveFault",
    "FsmDebugAction",
    "LoggingSyncOcns",
    "LsClone",
    "LsInstantiateNNamedTemplate",
    "LsInstantiateNTemplate",
    "LsInstantiateTemplate",
    "LsResolveTemplates",
    "LsTemplatise",
    "LstorageCreateZoningFromInv",
    "MethodResolveVessel",
    "MethodVessel",
    "MgmtResolveBackupFilenames",
    "OrgResolveElements",
    "OrgResolveLogicalParents",
    "PolicyResolveNames",
    "PolicySetCentraleStorage",
    "PoolResolveInScope",
    "StatsClearInterval",
    "StatsResolveThresholdPolicy",
    "StatsSubscribe",
    "SwatExample",
    "SwatGetstats",
    "SwatInject",
    "SyntheticFSObjInventory",
    "SyntheticFSObjInventoryB",
    "SyntheticTestTx",
    "TrigPerformTokenAction",
])


OTHER_TYPE_CLASS_ID = {
    "Method": "ucsbasetype",
    "MethodSet": "ucsbasetype",
    "AllbitsFilter": "ucsfiltertype",
    "AndFilter": "ucsfiltertype",
    "AnybitFilter": "ucsfiltertype",
    "BwFilter": "ucsfiltertype",
    "ClassId": "ucsbasetype",
    "ClassIdSet": "ucsbasetype",
    "ConfigConfig": "ucsbasetype",
    "ConfigMap": "ucsbasetype",
    "ConfigSet": "ucsbasetype",
    "Dn": "ucsbasetype",
    "DnSet": "ucsbasetype",
    "EqFilter": "ucsfiltertype",
    "FilterFilter": "ucsbasetype",
    "GeFilter": "ucsfiltertype",
    "GtFilter": "ucsfiltertype",
    "Id": "ucsbasetype",
    "IdSet": "ucsbasetype",
    "LeFilter": "ucsfiltertype",
    "LtFilter": "ucsfiltertype",
    "NeFilter": "ucsfiltertype",
    "NotFilter": "ucsfiltertype",
    "OrFilter": "ucsfiltertype",
    "Pair": "ucsbasetype",
    "WcardFilter": "ucsfiltertype",
}
