"""This module contains the general information for StatsThr32Definition ManagedObject."""

from ...ucsmo import ManagedObject
from ...ucscoremeta import MoPropertyMeta, MoMeta
from ...ucsmeta import VersionMeta


class StatsThr32DefinitionConsts:
    AUTO_RECOVERY_DISABLED = "disabled"
    AUTO_RECOVERY_ENABLED = "enabled"
    ERROR_DISABLE_FI_PORT_FALSE = "false"
    ERROR_DISABLE_FI_PORT_NO = "no"
    ERROR_DISABLE_FI_PORT_TRUE = "true"
    ERROR_DISABLE_FI_PORT_YES = "yes"
    INT_ID_NONE = "none"
    POLICY_OWNER_LOCAL = "local"
    POLICY_OWNER_PENDING_POLICY = "pending-policy"
    POLICY_OWNER_POLICY = "policy"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSGREATER_THAN_OR_EQUAL_TO9216_DELTA = "adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216Delta"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSGREATER_THAN_OR_EQUAL_TO9216_DELTA_AVG = "adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216DeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSGREATER_THAN_OR_EQUAL_TO9216_DELTA_MAX = "adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216DeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSGREATER_THAN_OR_EQUAL_TO9216_DELTA_MIN = "adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216DeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN2048_DELTA = "adaptorEthPortBySizeLargeStatslessThan2048Delta"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN2048_DELTA_AVG = "adaptorEthPortBySizeLargeStatslessThan2048DeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN2048_DELTA_MAX = "adaptorEthPortBySizeLargeStatslessThan2048DeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN2048_DELTA_MIN = "adaptorEthPortBySizeLargeStatslessThan2048DeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN4096_DELTA = "adaptorEthPortBySizeLargeStatslessThan4096Delta"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN4096_DELTA_AVG = "adaptorEthPortBySizeLargeStatslessThan4096DeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN4096_DELTA_MAX = "adaptorEthPortBySizeLargeStatslessThan4096DeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN4096_DELTA_MIN = "adaptorEthPortBySizeLargeStatslessThan4096DeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN8192_DELTA = "adaptorEthPortBySizeLargeStatslessThan8192Delta"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN8192_DELTA_AVG = "adaptorEthPortBySizeLargeStatslessThan8192DeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN8192_DELTA_MAX = "adaptorEthPortBySizeLargeStatslessThan8192DeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN8192_DELTA_MIN = "adaptorEthPortBySizeLargeStatslessThan8192DeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN9216_DELTA = "adaptorEthPortBySizeLargeStatslessThan9216Delta"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN9216_DELTA_AVG = "adaptorEthPortBySizeLargeStatslessThan9216DeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN9216_DELTA_MAX = "adaptorEthPortBySizeLargeStatslessThan9216DeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN9216_DELTA_MIN = "adaptorEthPortBySizeLargeStatslessThan9216DeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN_OR_EQUAL_TO1518_DELTA = "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518Delta"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN_OR_EQUAL_TO1518_DELTA_AVG = "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518DeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN_OR_EQUAL_TO1518_DELTA_MAX = "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518DeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN_OR_EQUAL_TO1518_DELTA_MIN = "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518DeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSNO_BREAKDOWN_GREATER_THAN1518_DELTA = "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518Delta"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSNO_BREAKDOWN_GREATER_THAN1518_DELTA_AVG = "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518DeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSNO_BREAKDOWN_GREATER_THAN1518_DELTA_MAX = "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518DeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSNO_BREAKDOWN_GREATER_THAN1518_DELTA_MIN = "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518DeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSEQUALS64_DELTA = "adaptorEthPortBySizeSmallStatsequals64Delta"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSEQUALS64_DELTA_AVG = "adaptorEthPortBySizeSmallStatsequals64DeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSEQUALS64_DELTA_MAX = "adaptorEthPortBySizeSmallStatsequals64DeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSEQUALS64_DELTA_MIN = "adaptorEthPortBySizeSmallStatsequals64DeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN1024_DELTA = "adaptorEthPortBySizeSmallStatslessThan1024Delta"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN1024_DELTA_AVG = "adaptorEthPortBySizeSmallStatslessThan1024DeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN1024_DELTA_MAX = "adaptorEthPortBySizeSmallStatslessThan1024DeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN1024_DELTA_MIN = "adaptorEthPortBySizeSmallStatslessThan1024DeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN128_DELTA = "adaptorEthPortBySizeSmallStatslessThan128Delta"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN128_DELTA_AVG = "adaptorEthPortBySizeSmallStatslessThan128DeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN128_DELTA_MAX = "adaptorEthPortBySizeSmallStatslessThan128DeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN128_DELTA_MIN = "adaptorEthPortBySizeSmallStatslessThan128DeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN256_DELTA = "adaptorEthPortBySizeSmallStatslessThan256Delta"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN256_DELTA_AVG = "adaptorEthPortBySizeSmallStatslessThan256DeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN256_DELTA_MAX = "adaptorEthPortBySizeSmallStatslessThan256DeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN256_DELTA_MIN = "adaptorEthPortBySizeSmallStatslessThan256DeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN512_DELTA = "adaptorEthPortBySizeSmallStatslessThan512Delta"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN512_DELTA_AVG = "adaptorEthPortBySizeSmallStatslessThan512DeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN512_DELTA_MAX = "adaptorEthPortBySizeSmallStatslessThan512DeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN512_DELTA_MIN = "adaptorEthPortBySizeSmallStatslessThan512DeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN64_DELTA = "adaptorEthPortBySizeSmallStatslessThan64Delta"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN64_DELTA_AVG = "adaptorEthPortBySizeSmallStatslessThan64DeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN64_DELTA_MAX = "adaptorEthPortBySizeSmallStatslessThan64DeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN64_DELTA_MIN = "adaptorEthPortBySizeSmallStatslessThan64DeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_CRC_PACKETS_DELTA = "adaptorEthPortErrStatsbadCrcPacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_CRC_PACKETS_DELTA_AVG = "adaptorEthPortErrStatsbadCrcPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_CRC_PACKETS_DELTA_MAX = "adaptorEthPortErrStatsbadCrcPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_CRC_PACKETS_DELTA_MIN = "adaptorEthPortErrStatsbadCrcPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_LENGTH_PACKETS_DELTA = "adaptorEthPortErrStatsbadLengthPacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_LENGTH_PACKETS_DELTA_AVG = "adaptorEthPortErrStatsbadLengthPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_LENGTH_PACKETS_DELTA_MAX = "adaptorEthPortErrStatsbadLengthPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_LENGTH_PACKETS_DELTA_MIN = "adaptorEthPortErrStatsbadLengthPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSMAC_DISCARDED_PACKETS_DELTA = "adaptorEthPortErrStatsmacDiscardedPacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSMAC_DISCARDED_PACKETS_DELTA_AVG = "adaptorEthPortErrStatsmacDiscardedPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSMAC_DISCARDED_PACKETS_DELTA_MAX = "adaptorEthPortErrStatsmacDiscardedPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSMAC_DISCARDED_PACKETS_DELTA_MIN = "adaptorEthPortErrStatsmacDiscardedPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSBROADCAST_PACKETS_DELTA = "adaptorEthPortMcastStatsbroadcastPacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSBROADCAST_PACKETS_DELTA_AVG = "adaptorEthPortMcastStatsbroadcastPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSBROADCAST_PACKETS_DELTA_MAX = "adaptorEthPortMcastStatsbroadcastPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSBROADCAST_PACKETS_DELTA_MIN = "adaptorEthPortMcastStatsbroadcastPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSMULTICAST_PACKETS_DELTA = "adaptorEthPortMcastStatsmulticastPacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSMULTICAST_PACKETS_DELTA_AVG = "adaptorEthPortMcastStatsmulticastPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSMULTICAST_PACKETS_DELTA_MAX = "adaptorEthPortMcastStatsmulticastPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSMULTICAST_PACKETS_DELTA_MIN = "adaptorEthPortMcastStatsmulticastPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSUNICAST_PACKETS_DELTA = "adaptorEthPortMcastStatsunicastPacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSUNICAST_PACKETS_DELTA_AVG = "adaptorEthPortMcastStatsunicastPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSUNICAST_PACKETS_DELTA_MAX = "adaptorEthPortMcastStatsunicastPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSUNICAST_PACKETS_DELTA_MIN = "adaptorEthPortMcastStatsunicastPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_BAD_CRC_PACKETS_DELTA = "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_PACKETS_DELTA = "adaptorEthPortOutsizedStatsoversizedPacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_PACKETS_DELTA_AVG = "adaptorEthPortOutsizedStatsoversizedPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_PACKETS_DELTA_MAX = "adaptorEthPortOutsizedStatsoversizedPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_PACKETS_DELTA_MIN = "adaptorEthPortOutsizedStatsoversizedPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_BAD_CRC_PACKETS_DELTA = "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_STATSGOOD_PACKETS_DELTA = "adaptorEthPortStatsgoodPacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_STATSGOOD_PACKETS_DELTA_AVG = "adaptorEthPortStatsgoodPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_STATSGOOD_PACKETS_DELTA_MAX = "adaptorEthPortStatsgoodPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_STATSGOOD_PACKETS_DELTA_MIN = "adaptorEthPortStatsgoodPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_STATSPAUSE_PACKETS_DELTA = "adaptorEthPortStatspausePacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_STATSPAUSE_PACKETS_DELTA_AVG = "adaptorEthPortStatspausePacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_STATSPAUSE_PACKETS_DELTA_MAX = "adaptorEthPortStatspausePacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_STATSPAUSE_PACKETS_DELTA_MIN = "adaptorEthPortStatspausePacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_STATSPER_PRIORITY_PAUSE_PACKETS_DELTA = "adaptorEthPortStatsperPriorityPausePacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_STATSPER_PRIORITY_PAUSE_PACKETS_DELTA_AVG = "adaptorEthPortStatsperPriorityPausePacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_STATSPER_PRIORITY_PAUSE_PACKETS_DELTA_MAX = "adaptorEthPortStatsperPriorityPausePacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_STATSPER_PRIORITY_PAUSE_PACKETS_DELTA_MIN = "adaptorEthPortStatsperPriorityPausePacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_STATSPPP_PACKETS_DELTA = "adaptorEthPortStatspppPacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_STATSPPP_PACKETS_DELTA_AVG = "adaptorEthPortStatspppPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_STATSPPP_PACKETS_DELTA_MAX = "adaptorEthPortStatspppPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_STATSPPP_PACKETS_DELTA_MIN = "adaptorEthPortStatspppPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_STATSTOTAL_PACKETS_DELTA = "adaptorEthPortStatstotalPacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_STATSTOTAL_PACKETS_DELTA_AVG = "adaptorEthPortStatstotalPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_STATSTOTAL_PACKETS_DELTA_MAX = "adaptorEthPortStatstotalPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_STATSTOTAL_PACKETS_DELTA_MIN = "adaptorEthPortStatstotalPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETH_PORT_STATSVLAN_PACKETS_DELTA = "adaptorEthPortStatsvlanPacketsDelta"
    PROP_ID_ADAPTOR_ETH_PORT_STATSVLAN_PACKETS_DELTA_AVG = "adaptorEthPortStatsvlanPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETH_PORT_STATSVLAN_PACKETS_DELTA_MAX = "adaptorEthPortStatsvlanPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETH_PORT_STATSVLAN_PACKETS_DELTA_MIN = "adaptorEthPortStatsvlanPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_BYTES_DELTA = "adaptorEtherIfStatsrxBytesDelta"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_BYTES_DELTA_AVG = "adaptorEtherIfStatsrxBytesDeltaAvg"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_BYTES_DELTA_MAX = "adaptorEtherIfStatsrxBytesDeltaMax"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_BYTES_DELTA_MIN = "adaptorEtherIfStatsrxBytesDeltaMin"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_DROPPED_DELTA = "adaptorEtherIfStatsrxDroppedDelta"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_DROPPED_DELTA_AVG = "adaptorEtherIfStatsrxDroppedDeltaAvg"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_DROPPED_DELTA_MAX = "adaptorEtherIfStatsrxDroppedDeltaMax"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_DROPPED_DELTA_MIN = "adaptorEtherIfStatsrxDroppedDeltaMin"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_ERRORS_DELTA = "adaptorEtherIfStatsrxErrorsDelta"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_ERRORS_DELTA_AVG = "adaptorEtherIfStatsrxErrorsDeltaAvg"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_ERRORS_DELTA_MAX = "adaptorEtherIfStatsrxErrorsDeltaMax"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_ERRORS_DELTA_MIN = "adaptorEtherIfStatsrxErrorsDeltaMin"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_PACKETS_DELTA = "adaptorEtherIfStatsrxPacketsDelta"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_PACKETS_DELTA_AVG = "adaptorEtherIfStatsrxPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_PACKETS_DELTA_MAX = "adaptorEtherIfStatsrxPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETHER_IF_STATSRX_PACKETS_DELTA_MIN = "adaptorEtherIfStatsrxPacketsDeltaMin"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_BYTES_DELTA = "adaptorEtherIfStatstxBytesDelta"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_BYTES_DELTA_AVG = "adaptorEtherIfStatstxBytesDeltaAvg"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_BYTES_DELTA_MAX = "adaptorEtherIfStatstxBytesDeltaMax"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_BYTES_DELTA_MIN = "adaptorEtherIfStatstxBytesDeltaMin"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_DROPPED_DELTA = "adaptorEtherIfStatstxDroppedDelta"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_DROPPED_DELTA_AVG = "adaptorEtherIfStatstxDroppedDeltaAvg"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_DROPPED_DELTA_MAX = "adaptorEtherIfStatstxDroppedDeltaMax"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_DROPPED_DELTA_MIN = "adaptorEtherIfStatstxDroppedDeltaMin"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_ERRORS_DELTA = "adaptorEtherIfStatstxErrorsDelta"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_ERRORS_DELTA_AVG = "adaptorEtherIfStatstxErrorsDeltaAvg"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_ERRORS_DELTA_MAX = "adaptorEtherIfStatstxErrorsDeltaMax"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_ERRORS_DELTA_MIN = "adaptorEtherIfStatstxErrorsDeltaMin"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_PACKETS_DELTA = "adaptorEtherIfStatstxPacketsDelta"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_PACKETS_DELTA_AVG = "adaptorEtherIfStatstxPacketsDeltaAvg"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_PACKETS_DELTA_MAX = "adaptorEtherIfStatstxPacketsDeltaMax"
    PROP_ID_ADAPTOR_ETHER_IF_STATSTX_PACKETS_DELTA_MIN = "adaptorEtherIfStatstxPacketsDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSINVALID_CRCCOUNT_DELTA = "adaptorFcIfEventStatsinvalidCRCCountDelta"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSINVALID_CRCCOUNT_DELTA_AVG = "adaptorFcIfEventStatsinvalidCRCCountDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSINVALID_CRCCOUNT_DELTA_MAX = "adaptorFcIfEventStatsinvalidCRCCountDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSINVALID_CRCCOUNT_DELTA_MIN = "adaptorFcIfEventStatsinvalidCRCCountDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLINK_FAILURE_COUNT_DELTA = "adaptorFcIfEventStatslinkFailureCountDelta"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLINK_FAILURE_COUNT_DELTA_AVG = "adaptorFcIfEventStatslinkFailureCountDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLINK_FAILURE_COUNT_DELTA_MAX = "adaptorFcIfEventStatslinkFailureCountDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLINK_FAILURE_COUNT_DELTA_MIN = "adaptorFcIfEventStatslinkFailureCountDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLIP_COUNT_DELTA = "adaptorFcIfEventStatslipCountDelta"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLIP_COUNT_DELTA_AVG = "adaptorFcIfEventStatslipCountDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLIP_COUNT_DELTA_MAX = "adaptorFcIfEventStatslipCountDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLIP_COUNT_DELTA_MIN = "adaptorFcIfEventStatslipCountDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SIGNAL_COUNT_DELTA = "adaptorFcIfEventStatslossOfSignalCountDelta"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SIGNAL_COUNT_DELTA_AVG = "adaptorFcIfEventStatslossOfSignalCountDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SIGNAL_COUNT_DELTA_MAX = "adaptorFcIfEventStatslossOfSignalCountDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SIGNAL_COUNT_DELTA_MIN = "adaptorFcIfEventStatslossOfSignalCountDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SYNC_COUNT_DELTA = "adaptorFcIfEventStatslossOfSyncCountDelta"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SYNC_COUNT_DELTA_AVG = "adaptorFcIfEventStatslossOfSyncCountDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SYNC_COUNT_DELTA_MAX = "adaptorFcIfEventStatslossOfSyncCountDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SYNC_COUNT_DELTA_MIN = "adaptorFcIfEventStatslossOfSyncCountDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSN_OSCOUNT_DELTA = "adaptorFcIfEventStatsnOSCountDelta"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSN_OSCOUNT_DELTA_AVG = "adaptorFcIfEventStatsnOSCountDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSN_OSCOUNT_DELTA_MAX = "adaptorFcIfEventStatsnOSCountDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSN_OSCOUNT_DELTA_MIN = "adaptorFcIfEventStatsnOSCountDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSECONDS_SINCE_LAST_RESET_DELTA = "adaptorFcIfEventStatssecondsSinceLastResetDelta"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSECONDS_SINCE_LAST_RESET_DELTA_AVG = "adaptorFcIfEventStatssecondsSinceLastResetDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSECONDS_SINCE_LAST_RESET_DELTA_MAX = "adaptorFcIfEventStatssecondsSinceLastResetDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSECONDS_SINCE_LAST_RESET_DELTA_MIN = "adaptorFcIfEventStatssecondsSinceLastResetDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSEQ_PROTOCOL_ERR_COUNT_DELTA = "adaptorFcIfEventStatsseqProtocolErrCountDelta"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSEQ_PROTOCOL_ERR_COUNT_DELTA_AVG = "adaptorFcIfEventStatsseqProtocolErrCountDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSEQ_PROTOCOL_ERR_COUNT_DELTA_MAX = "adaptorFcIfEventStatsseqProtocolErrCountDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSEQ_PROTOCOL_ERR_COUNT_DELTA_MIN = "adaptorFcIfEventStatsseqProtocolErrCountDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSCONTROL_REQUESTS_DELTA = "adaptorFcIfFC4StatscontrolRequestsDelta"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSCONTROL_REQUESTS_DELTA_AVG = "adaptorFcIfFC4StatscontrolRequestsDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSCONTROL_REQUESTS_DELTA_MAX = "adaptorFcIfFC4StatscontrolRequestsDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSCONTROL_REQUESTS_DELTA_MIN = "adaptorFcIfFC4StatscontrolRequestsDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_MEGABYTES_DELTA = "adaptorFcIfFC4StatsinputMegabytesDelta"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_MEGABYTES_DELTA_AVG = "adaptorFcIfFC4StatsinputMegabytesDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_MEGABYTES_DELTA_MAX = "adaptorFcIfFC4StatsinputMegabytesDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_MEGABYTES_DELTA_MIN = "adaptorFcIfFC4StatsinputMegabytesDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_REQUESTS_DELTA = "adaptorFcIfFC4StatsinputRequestsDelta"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_REQUESTS_DELTA_AVG = "adaptorFcIfFC4StatsinputRequestsDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_REQUESTS_DELTA_MAX = "adaptorFcIfFC4StatsinputRequestsDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_REQUESTS_DELTA_MIN = "adaptorFcIfFC4StatsinputRequestsDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_MEGABYTES_DELTA = "adaptorFcIfFC4StatsoutputMegabytesDelta"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_MEGABYTES_DELTA_AVG = "adaptorFcIfFC4StatsoutputMegabytesDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_MEGABYTES_DELTA_MAX = "adaptorFcIfFC4StatsoutputMegabytesDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_MEGABYTES_DELTA_MIN = "adaptorFcIfFC4StatsoutputMegabytesDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_REQUESTS_DELTA = "adaptorFcIfFC4StatsoutputRequestsDelta"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_REQUESTS_DELTA_AVG = "adaptorFcIfFC4StatsoutputRequestsDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_REQUESTS_DELTA_MAX = "adaptorFcIfFC4StatsoutputRequestsDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_REQUESTS_DELTA_MIN = "adaptorFcIfFC4StatsoutputRequestsDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSDUMPED_FRAMES_DELTA = "adaptorFcIfFrameStatsdumpedFramesDelta"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSDUMPED_FRAMES_DELTA_AVG = "adaptorFcIfFrameStatsdumpedFramesDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSDUMPED_FRAMES_DELTA_MAX = "adaptorFcIfFrameStatsdumpedFramesDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSDUMPED_FRAMES_DELTA_MIN = "adaptorFcIfFrameStatsdumpedFramesDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSERROR_FRAMES_DELTA = "adaptorFcIfFrameStatserrorFramesDelta"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSERROR_FRAMES_DELTA_AVG = "adaptorFcIfFrameStatserrorFramesDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSERROR_FRAMES_DELTA_MAX = "adaptorFcIfFrameStatserrorFramesDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSERROR_FRAMES_DELTA_MIN = "adaptorFcIfFrameStatserrorFramesDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSRX_FRAMES_DELTA = "adaptorFcIfFrameStatsrxFramesDelta"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSRX_FRAMES_DELTA_AVG = "adaptorFcIfFrameStatsrxFramesDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSRX_FRAMES_DELTA_MAX = "adaptorFcIfFrameStatsrxFramesDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSRX_FRAMES_DELTA_MIN = "adaptorFcIfFrameStatsrxFramesDeltaMin"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSTX_FRAMES_DELTA = "adaptorFcIfFrameStatstxFramesDelta"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSTX_FRAMES_DELTA_AVG = "adaptorFcIfFrameStatstxFramesDeltaAvg"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSTX_FRAMES_DELTA_MAX = "adaptorFcIfFrameStatstxFramesDeltaMax"
    PROP_ID_ADAPTOR_FC_IF_FRAME_STATSTX_FRAMES_DELTA_MIN = "adaptorFcIfFrameStatstxFramesDeltaMin"
    PROP_ID_ADAPTOR_FC_PORT_STATSRX_BAD_FRAMES_DELTA = "adaptorFcPortStatsrxBadFramesDelta"
    PROP_ID_ADAPTOR_FC_PORT_STATSRX_BAD_FRAMES_DELTA_AVG = "adaptorFcPortStatsrxBadFramesDeltaAvg"
    PROP_ID_ADAPTOR_FC_PORT_STATSRX_BAD_FRAMES_DELTA_MAX = "adaptorFcPortStatsrxBadFramesDeltaMax"
    PROP_ID_ADAPTOR_FC_PORT_STATSRX_BAD_FRAMES_DELTA_MIN = "adaptorFcPortStatsrxBadFramesDeltaMin"
    PROP_ID_ADAPTOR_FC_PORT_STATSRX_FRAMES_DELTA = "adaptorFcPortStatsrxFramesDelta"
    PROP_ID_ADAPTOR_FC_PORT_STATSRX_FRAMES_DELTA_AVG = "adaptorFcPortStatsrxFramesDeltaAvg"
    PROP_ID_ADAPTOR_FC_PORT_STATSRX_FRAMES_DELTA_MAX = "adaptorFcPortStatsrxFramesDeltaMax"
    PROP_ID_ADAPTOR_FC_PORT_STATSRX_FRAMES_DELTA_MIN = "adaptorFcPortStatsrxFramesDeltaMin"
    PROP_ID_ADAPTOR_FC_PORT_STATSTX_BAD_FRAMES_DELTA = "adaptorFcPortStatstxBadFramesDelta"
    PROP_ID_ADAPTOR_FC_PORT_STATSTX_BAD_FRAMES_DELTA_AVG = "adaptorFcPortStatstxBadFramesDeltaAvg"
    PROP_ID_ADAPTOR_FC_PORT_STATSTX_BAD_FRAMES_DELTA_MAX = "adaptorFcPortStatstxBadFramesDeltaMax"
    PROP_ID_ADAPTOR_FC_PORT_STATSTX_BAD_FRAMES_DELTA_MIN = "adaptorFcPortStatstxBadFramesDeltaMin"
    PROP_ID_ADAPTOR_FC_PORT_STATSTX_FRAMES_DELTA = "adaptorFcPortStatstxFramesDelta"
    PROP_ID_ADAPTOR_FC_PORT_STATSTX_FRAMES_DELTA_AVG = "adaptorFcPortStatstxFramesDeltaAvg"
    PROP_ID_ADAPTOR_FC_PORT_STATSTX_FRAMES_DELTA_MAX = "adaptorFcPortStatstxFramesDeltaMax"
    PROP_ID_ADAPTOR_FC_PORT_STATSTX_FRAMES_DELTA_MIN = "adaptorFcPortStatstxFramesDeltaMin"
    PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSCORRECTABLE_ERRORS_DELTA = "adaptorMenloBaseErrorStatscorrectableErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloBaseErrorStatscorrectableErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloBaseErrorStatscorrectableErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloBaseErrorStatscorrectableErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA = "adaptorMenloBaseErrorStatsuncorrectableErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloBaseErrorStatsuncorrectableErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloBaseErrorStatsuncorrectableErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloBaseErrorStatsuncorrectableErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_CFCDELTA = "adaptorMenloDcePortStatsrxPauseCFCDelta"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_CFCDELTA_AVG = "adaptorMenloDcePortStatsrxPauseCFCDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_CFCDELTA_MAX = "adaptorMenloDcePortStatsrxPauseCFCDeltaMax"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_CFCDELTA_MIN = "adaptorMenloDcePortStatsrxPauseCFCDeltaMin"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_PFCDELTA = "adaptorMenloDcePortStatsrxPausePFCDelta"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_PFCDELTA_AVG = "adaptorMenloDcePortStatsrxPausePFCDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_PFCDELTA_MAX = "adaptorMenloDcePortStatsrxPausePFCDeltaMax"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_PFCDELTA_MIN = "adaptorMenloDcePortStatsrxPausePFCDeltaMin"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_CFCDELTA = "adaptorMenloDcePortStatstxPauseCFCDelta"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_CFCDELTA_AVG = "adaptorMenloDcePortStatstxPauseCFCDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_CFCDELTA_MAX = "adaptorMenloDcePortStatstxPauseCFCDeltaMax"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_CFCDELTA_MIN = "adaptorMenloDcePortStatstxPauseCFCDeltaMin"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_PFCDELTA = "adaptorMenloDcePortStatstxPausePFCDelta"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_PFCDELTA_AVG = "adaptorMenloDcePortStatstxPausePFCDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_PFCDELTA_MAX = "adaptorMenloDcePortStatstxPausePFCDeltaMax"
    PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_PFCDELTA_MIN = "adaptorMenloDcePortStatstxPausePFCDeltaMin"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSCORRECTABLE_ERRORS_DELTA = "adaptorMenloEthErrorStatscorrectableErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloEthErrorStatscorrectableErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloEthErrorStatscorrectableErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloEthErrorStatscorrectableErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSDROP_ACL_DELTA = "adaptorMenloEthErrorStatsdropAclDelta"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSDROP_ACL_DELTA_AVG = "adaptorMenloEthErrorStatsdropAclDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSDROP_ACL_DELTA_MAX = "adaptorMenloEthErrorStatsdropAclDeltaMax"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSDROP_ACL_DELTA_MIN = "adaptorMenloEthErrorStatsdropAclDeltaMin"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPOP_ERRORS_DELTA = "adaptorMenloEthErrorStatspopErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPOP_ERRORS_DELTA_AVG = "adaptorMenloEthErrorStatspopErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPOP_ERRORS_DELTA_MAX = "adaptorMenloEthErrorStatspopErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPOP_ERRORS_DELTA_MIN = "adaptorMenloEthErrorStatspopErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPUSH_ERRORS_DELTA = "adaptorMenloEthErrorStatspushErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPUSH_ERRORS_DELTA_AVG = "adaptorMenloEthErrorStatspushErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPUSH_ERRORS_DELTA_MAX = "adaptorMenloEthErrorStatspushErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPUSH_ERRORS_DELTA_MIN = "adaptorMenloEthErrorStatspushErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA = "adaptorMenloEthErrorStatsuncorrectableErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloEthErrorStatsuncorrectableErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloEthErrorStatsuncorrectableErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloEthErrorStatsuncorrectableErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_OVERRUN_DELTA = "adaptorMenloEthStatsdropOverrunDelta"
    PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_OVERRUN_DELTA_AVG = "adaptorMenloEthStatsdropOverrunDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_OVERRUN_DELTA_MAX = "adaptorMenloEthStatsdropOverrunDeltaMax"
    PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_OVERRUN_DELTA_MIN = "adaptorMenloEthStatsdropOverrunDeltaMin"
    PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_RUNT_DELTA = "adaptorMenloEthStatsdropRuntDelta"
    PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_RUNT_DELTA_AVG = "adaptorMenloEthStatsdropRuntDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_RUNT_DELTA_MAX = "adaptorMenloEthStatsdropRuntDeltaMax"
    PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_RUNT_DELTA_MIN = "adaptorMenloEthStatsdropRuntDeltaMin"
    PROP_ID_ADAPTOR_MENLO_ETH_STATSTRUNCATE_OVERRUN_DELTA = "adaptorMenloEthStatstruncateOverrunDelta"
    PROP_ID_ADAPTOR_MENLO_ETH_STATSTRUNCATE_OVERRUN_DELTA_AVG = "adaptorMenloEthStatstruncateOverrunDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_ETH_STATSTRUNCATE_OVERRUN_DELTA_MAX = "adaptorMenloEthStatstruncateOverrunDeltaMax"
    PROP_ID_ADAPTOR_MENLO_ETH_STATSTRUNCATE_OVERRUN_DELTA_MIN = "adaptorMenloEthStatstruncateOverrunDeltaMin"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSCORRECTABLE_ERRORS_DELTA = "adaptorMenloFcErrorStatscorrectableErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloFcErrorStatscorrectableErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloFcErrorStatscorrectableErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloFcErrorStatscorrectableErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPOP_ERRORS_DELTA = "adaptorMenloFcErrorStatspopErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPOP_ERRORS_DELTA_AVG = "adaptorMenloFcErrorStatspopErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPOP_ERRORS_DELTA_MAX = "adaptorMenloFcErrorStatspopErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPOP_ERRORS_DELTA_MIN = "adaptorMenloFcErrorStatspopErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPUSH_ERRORS_DELTA = "adaptorMenloFcErrorStatspushErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPUSH_ERRORS_DELTA_AVG = "adaptorMenloFcErrorStatspushErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPUSH_ERRORS_DELTA_MAX = "adaptorMenloFcErrorStatspushErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPUSH_ERRORS_DELTA_MIN = "adaptorMenloFcErrorStatspushErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA = "adaptorMenloFcErrorStatsuncorrectableErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloFcErrorStatsuncorrectableErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloFcErrorStatsuncorrectableErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloFcErrorStatsuncorrectableErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_ACL_DELTA = "adaptorMenloFcStatsdropAclDelta"
    PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_ACL_DELTA_AVG = "adaptorMenloFcStatsdropAclDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_ACL_DELTA_MAX = "adaptorMenloFcStatsdropAclDeltaMax"
    PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_ACL_DELTA_MIN = "adaptorMenloFcStatsdropAclDeltaMin"
    PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_OVERRUN_DELTA = "adaptorMenloFcStatsdropOverrunDelta"
    PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_OVERRUN_DELTA_AVG = "adaptorMenloFcStatsdropOverrunDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_OVERRUN_DELTA_MAX = "adaptorMenloFcStatsdropOverrunDeltaMax"
    PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_OVERRUN_DELTA_MIN = "adaptorMenloFcStatsdropOverrunDeltaMin"
    PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_RUNT_DELTA = "adaptorMenloFcStatsdropRuntDelta"
    PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_RUNT_DELTA_AVG = "adaptorMenloFcStatsdropRuntDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_RUNT_DELTA_MAX = "adaptorMenloFcStatsdropRuntDeltaMax"
    PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_RUNT_DELTA_MIN = "adaptorMenloFcStatsdropRuntDeltaMin"
    PROP_ID_ADAPTOR_MENLO_FC_STATSTRUNCATE_OVERRUN_DELTA = "adaptorMenloFcStatstruncateOverrunDelta"
    PROP_ID_ADAPTOR_MENLO_FC_STATSTRUNCATE_OVERRUN_DELTA_AVG = "adaptorMenloFcStatstruncateOverrunDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_FC_STATSTRUNCATE_OVERRUN_DELTA_MAX = "adaptorMenloFcStatstruncateOverrunDeltaMax"
    PROP_ID_ADAPTOR_MENLO_FC_STATSTRUNCATE_OVERRUN_DELTA_MIN = "adaptorMenloFcStatstruncateOverrunDeltaMin"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_CFCDELTA = "adaptorMenloHostPortStatsrxPauseCFCDelta"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_CFCDELTA_AVG = "adaptorMenloHostPortStatsrxPauseCFCDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_CFCDELTA_MAX = "adaptorMenloHostPortStatsrxPauseCFCDeltaMax"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_CFCDELTA_MIN = "adaptorMenloHostPortStatsrxPauseCFCDeltaMin"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_PFCDELTA = "adaptorMenloHostPortStatsrxPausePFCDelta"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_PFCDELTA_AVG = "adaptorMenloHostPortStatsrxPausePFCDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_PFCDELTA_MAX = "adaptorMenloHostPortStatsrxPausePFCDeltaMax"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_PFCDELTA_MIN = "adaptorMenloHostPortStatsrxPausePFCDeltaMin"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_CFCDELTA = "adaptorMenloHostPortStatstxPauseCFCDelta"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_CFCDELTA_AVG = "adaptorMenloHostPortStatstxPauseCFCDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_CFCDELTA_MAX = "adaptorMenloHostPortStatstxPauseCFCDeltaMax"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_CFCDELTA_MIN = "adaptorMenloHostPortStatstxPauseCFCDeltaMin"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_PFCDELTA = "adaptorMenloHostPortStatstxPausePFCDelta"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_PFCDELTA_AVG = "adaptorMenloHostPortStatstxPausePFCDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_PFCDELTA_MAX = "adaptorMenloHostPortStatstxPausePFCDeltaMax"
    PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_PFCDELTA_MIN = "adaptorMenloHostPortStatstxPausePFCDeltaMin"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSCORRECTABLE_ERRORS_DELTA = "adaptorMenloMcpuErrorStatscorrectableErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloMcpuErrorStatscorrectableErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloMcpuErrorStatscorrectableErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloMcpuErrorStatscorrectableErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPOP_ERRORS_DELTA = "adaptorMenloMcpuErrorStatspopErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPOP_ERRORS_DELTA_AVG = "adaptorMenloMcpuErrorStatspopErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPOP_ERRORS_DELTA_MAX = "adaptorMenloMcpuErrorStatspopErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPOP_ERRORS_DELTA_MIN = "adaptorMenloMcpuErrorStatspopErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPUSH_ERRORS_DELTA = "adaptorMenloMcpuErrorStatspushErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPUSH_ERRORS_DELTA_AVG = "adaptorMenloMcpuErrorStatspushErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPUSH_ERRORS_DELTA_MAX = "adaptorMenloMcpuErrorStatspushErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPUSH_ERRORS_DELTA_MIN = "adaptorMenloMcpuErrorStatspushErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA = "adaptorMenloMcpuErrorStatsuncorrectableErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloMcpuErrorStatsuncorrectableErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloMcpuErrorStatsuncorrectableErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloMcpuErrorStatsuncorrectableErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_ACL_DELTA = "adaptorMenloMcpuStatsdropAclDelta"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_ACL_DELTA_AVG = "adaptorMenloMcpuStatsdropAclDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_ACL_DELTA_MAX = "adaptorMenloMcpuStatsdropAclDeltaMax"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_ACL_DELTA_MIN = "adaptorMenloMcpuStatsdropAclDeltaMin"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_OVERRUN_DELTA = "adaptorMenloMcpuStatsdropOverrunDelta"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_OVERRUN_DELTA_AVG = "adaptorMenloMcpuStatsdropOverrunDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_OVERRUN_DELTA_MAX = "adaptorMenloMcpuStatsdropOverrunDeltaMax"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_OVERRUN_DELTA_MIN = "adaptorMenloMcpuStatsdropOverrunDeltaMin"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_RUNT_DELTA = "adaptorMenloMcpuStatsdropRuntDelta"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_RUNT_DELTA_AVG = "adaptorMenloMcpuStatsdropRuntDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_RUNT_DELTA_MAX = "adaptorMenloMcpuStatsdropRuntDeltaMax"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_RUNT_DELTA_MIN = "adaptorMenloMcpuStatsdropRuntDeltaMin"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSTRUNCATE_OVERRUN_DELTA = "adaptorMenloMcpuStatstruncateOverrunDelta"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSTRUNCATE_OVERRUN_DELTA_AVG = "adaptorMenloMcpuStatstruncateOverrunDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSTRUNCATE_OVERRUN_DELTA_MAX = "adaptorMenloMcpuStatstruncateOverrunDeltaMax"
    PROP_ID_ADAPTOR_MENLO_MCPU_STATSTRUNCATE_OVERRUN_DELTA_MIN = "adaptorMenloMcpuStatstruncateOverrunDeltaMin"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_CMD_DELTA = "adaptorMenloNetEgStatsdropCmdDelta"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_CMD_DELTA_AVG = "adaptorMenloNetEgStatsdropCmdDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_CMD_DELTA_MAX = "adaptorMenloNetEgStatsdropCmdDeltaMax"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_CMD_DELTA_MIN = "adaptorMenloNetEgStatsdropCmdDeltaMin"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_CFG_INVALID_DELTA = "adaptorMenloNetEgStatsdropLifCfgInvalidDelta"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_CFG_INVALID_DELTA_AVG = "adaptorMenloNetEgStatsdropLifCfgInvalidDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_CFG_INVALID_DELTA_MAX = "adaptorMenloNetEgStatsdropLifCfgInvalidDeltaMax"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_CFG_INVALID_DELTA_MIN = "adaptorMenloNetEgStatsdropLifCfgInvalidDeltaMin"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_MAP_NO_HIT_DELTA = "adaptorMenloNetEgStatsdropLifMapNoHitDelta"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_MAP_NO_HIT_DELTA_AVG = "adaptorMenloNetEgStatsdropLifMapNoHitDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_MAP_NO_HIT_DELTA_MAX = "adaptorMenloNetEgStatsdropLifMapNoHitDeltaMax"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_MAP_NO_HIT_DELTA_MIN = "adaptorMenloNetEgStatsdropLifMapNoHitDeltaMin"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_SRC_BIND_DELTA = "adaptorMenloNetEgStatsdropSrcBindDelta"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_SRC_BIND_DELTA_AVG = "adaptorMenloNetEgStatsdropSrcBindDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_SRC_BIND_DELTA_MAX = "adaptorMenloNetEgStatsdropSrcBindDeltaMax"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_SRC_BIND_DELTA_MIN = "adaptorMenloNetEgStatsdropSrcBindDeltaMin"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSLEARN_REQ_DROP_DELTA = "adaptorMenloNetEgStatslearnReqDropDelta"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSLEARN_REQ_DROP_DELTA_AVG = "adaptorMenloNetEgStatslearnReqDropDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSLEARN_REQ_DROP_DELTA_MAX = "adaptorMenloNetEgStatslearnReqDropDeltaMax"
    PROP_ID_ADAPTOR_MENLO_NET_EG_STATSLEARN_REQ_DROP_DELTA_MIN = "adaptorMenloNetEgStatslearnReqDropDeltaMin"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_LIF_INVALID_DELTA = "adaptorMenloNetInStatsdropFcLifInvalidDelta"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_LIF_INVALID_DELTA_AVG = "adaptorMenloNetInStatsdropFcLifInvalidDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_LIF_INVALID_DELTA_MAX = "adaptorMenloNetInStatsdropFcLifInvalidDeltaMax"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_LIF_INVALID_DELTA_MIN = "adaptorMenloNetInStatsdropFcLifInvalidDeltaMin"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_MULTICAST_DELTA = "adaptorMenloNetInStatsdropFcMulticastDelta"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_MULTICAST_DELTA_AVG = "adaptorMenloNetInStatsdropFcMulticastDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_MULTICAST_DELTA_MAX = "adaptorMenloNetInStatsdropFcMulticastDeltaMax"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_MULTICAST_DELTA_MIN = "adaptorMenloNetInStatsdropFcMulticastDeltaMin"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_NULL_PIF_DELTA = "adaptorMenloNetInStatsdropNullPifDelta"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_NULL_PIF_DELTA_AVG = "adaptorMenloNetInStatsdropNullPifDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_NULL_PIF_DELTA_MAX = "adaptorMenloNetInStatsdropNullPifDeltaMax"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_NULL_PIF_DELTA_MIN = "adaptorMenloNetInStatsdropNullPifDeltaMin"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSFWD_LOOKUP_NO_HIT_DELTA = "adaptorMenloNetInStatsfwdLookupNoHitDelta"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSFWD_LOOKUP_NO_HIT_DELTA_AVG = "adaptorMenloNetInStatsfwdLookupNoHitDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSFWD_LOOKUP_NO_HIT_DELTA_MAX = "adaptorMenloNetInStatsfwdLookupNoHitDeltaMax"
    PROP_ID_ADAPTOR_MENLO_NET_IN_STATSFWD_LOOKUP_NO_HIT_DELTA_MIN = "adaptorMenloNetInStatsfwdLookupNoHitDeltaMin"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSCORRECTABLE_ERRORS_DELTA = "adaptorMenloQErrorStatscorrectableErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloQErrorStatscorrectableErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloQErrorStatscorrectableErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloQErrorStatscorrectableErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSPOP_ERRORS_DELTA = "adaptorMenloQErrorStatspopErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSPOP_ERRORS_DELTA_AVG = "adaptorMenloQErrorStatspopErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSPOP_ERRORS_DELTA_MAX = "adaptorMenloQErrorStatspopErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSPOP_ERRORS_DELTA_MIN = "adaptorMenloQErrorStatspopErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSPUSH_ERRORS_DELTA = "adaptorMenloQErrorStatspushErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSPUSH_ERRORS_DELTA_AVG = "adaptorMenloQErrorStatspushErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSPUSH_ERRORS_DELTA_MAX = "adaptorMenloQErrorStatspushErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSPUSH_ERRORS_DELTA_MIN = "adaptorMenloQErrorStatspushErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSUNCORRECTABLE_ERRORS_DELTA = "adaptorMenloQErrorStatsuncorrectableErrorsDelta"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSUNCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloQErrorStatsuncorrectableErrorsDeltaAvg"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloQErrorStatsuncorrectableErrorsDeltaMax"
    PROP_ID_ADAPTOR_MENLO_QERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloQErrorStatsuncorrectableErrorsDeltaMin"
    PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N0_DELTA = "adaptorMenloQStatsdropOverrunN0Delta"
    PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N0_DELTA_AVG = "adaptorMenloQStatsdropOverrunN0DeltaAvg"
    PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N0_DELTA_MAX = "adaptorMenloQStatsdropOverrunN0DeltaMax"
    PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N0_DELTA_MIN = "adaptorMenloQStatsdropOverrunN0DeltaMin"
    PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N1_DELTA = "adaptorMenloQStatsdropOverrunN1Delta"
    PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N1_DELTA_AVG = "adaptorMenloQStatsdropOverrunN1DeltaAvg"
    PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N1_DELTA_MAX = "adaptorMenloQStatsdropOverrunN1DeltaMax"
    PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N1_DELTA_MIN = "adaptorMenloQStatsdropOverrunN1DeltaMin"
    PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N0_DELTA = "adaptorMenloQStatstruncateOverrunN0Delta"
    PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N0_DELTA_AVG = "adaptorMenloQStatstruncateOverrunN0DeltaAvg"
    PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N0_DELTA_MAX = "adaptorMenloQStatstruncateOverrunN0DeltaMax"
    PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N0_DELTA_MIN = "adaptorMenloQStatstruncateOverrunN0DeltaMin"
    PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N1_DELTA = "adaptorMenloQStatstruncateOverrunN1Delta"
    PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N1_DELTA_AVG = "adaptorMenloQStatstruncateOverrunN1DeltaAvg"
    PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N1_DELTA_MAX = "adaptorMenloQStatstruncateOverrunN1DeltaMax"
    PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N1_DELTA_MIN = "adaptorMenloQStatstruncateOverrunN1DeltaMin"
    PROP_ID_ADAPTOR_VNIC_STATSBYTES_RX_DELTA = "adaptorVnicStatsbytesRxDelta"
    PROP_ID_ADAPTOR_VNIC_STATSBYTES_RX_DELTA_AVG = "adaptorVnicStatsbytesRxDeltaAvg"
    PROP_ID_ADAPTOR_VNIC_STATSBYTES_RX_DELTA_MAX = "adaptorVnicStatsbytesRxDeltaMax"
    PROP_ID_ADAPTOR_VNIC_STATSBYTES_RX_DELTA_MIN = "adaptorVnicStatsbytesRxDeltaMin"
    PROP_ID_ADAPTOR_VNIC_STATSBYTES_TX_DELTA = "adaptorVnicStatsbytesTxDelta"
    PROP_ID_ADAPTOR_VNIC_STATSBYTES_TX_DELTA_AVG = "adaptorVnicStatsbytesTxDeltaAvg"
    PROP_ID_ADAPTOR_VNIC_STATSBYTES_TX_DELTA_MAX = "adaptorVnicStatsbytesTxDeltaMax"
    PROP_ID_ADAPTOR_VNIC_STATSBYTES_TX_DELTA_MIN = "adaptorVnicStatsbytesTxDeltaMin"
    PROP_ID_ADAPTOR_VNIC_STATSDROPPED_RX_DELTA = "adaptorVnicStatsdroppedRxDelta"
    PROP_ID_ADAPTOR_VNIC_STATSDROPPED_RX_DELTA_AVG = "adaptorVnicStatsdroppedRxDeltaAvg"
    PROP_ID_ADAPTOR_VNIC_STATSDROPPED_RX_DELTA_MAX = "adaptorVnicStatsdroppedRxDeltaMax"
    PROP_ID_ADAPTOR_VNIC_STATSDROPPED_RX_DELTA_MIN = "adaptorVnicStatsdroppedRxDeltaMin"
    PROP_ID_ADAPTOR_VNIC_STATSDROPPED_TX_DELTA = "adaptorVnicStatsdroppedTxDelta"
    PROP_ID_ADAPTOR_VNIC_STATSDROPPED_TX_DELTA_AVG = "adaptorVnicStatsdroppedTxDeltaAvg"
    PROP_ID_ADAPTOR_VNIC_STATSDROPPED_TX_DELTA_MAX = "adaptorVnicStatsdroppedTxDeltaMax"
    PROP_ID_ADAPTOR_VNIC_STATSDROPPED_TX_DELTA_MIN = "adaptorVnicStatsdroppedTxDeltaMin"
    PROP_ID_ADAPTOR_VNIC_STATSERRORS_RX_DELTA = "adaptorVnicStatserrorsRxDelta"
    PROP_ID_ADAPTOR_VNIC_STATSERRORS_RX_DELTA_AVG = "adaptorVnicStatserrorsRxDeltaAvg"
    PROP_ID_ADAPTOR_VNIC_STATSERRORS_RX_DELTA_MAX = "adaptorVnicStatserrorsRxDeltaMax"
    PROP_ID_ADAPTOR_VNIC_STATSERRORS_RX_DELTA_MIN = "adaptorVnicStatserrorsRxDeltaMin"
    PROP_ID_ADAPTOR_VNIC_STATSERRORS_TX_DELTA = "adaptorVnicStatserrorsTxDelta"
    PROP_ID_ADAPTOR_VNIC_STATSERRORS_TX_DELTA_AVG = "adaptorVnicStatserrorsTxDeltaAvg"
    PROP_ID_ADAPTOR_VNIC_STATSERRORS_TX_DELTA_MAX = "adaptorVnicStatserrorsTxDeltaMax"
    PROP_ID_ADAPTOR_VNIC_STATSERRORS_TX_DELTA_MIN = "adaptorVnicStatserrorsTxDeltaMin"
    PROP_ID_ADAPTOR_VNIC_STATSPACKETS_RX_DELTA = "adaptorVnicStatspacketsRxDelta"
    PROP_ID_ADAPTOR_VNIC_STATSPACKETS_RX_DELTA_AVG = "adaptorVnicStatspacketsRxDeltaAvg"
    PROP_ID_ADAPTOR_VNIC_STATSPACKETS_RX_DELTA_MAX = "adaptorVnicStatspacketsRxDeltaMax"
    PROP_ID_ADAPTOR_VNIC_STATSPACKETS_RX_DELTA_MIN = "adaptorVnicStatspacketsRxDeltaMin"
    PROP_ID_ADAPTOR_VNIC_STATSPACKETS_TX_DELTA = "adaptorVnicStatspacketsTxDelta"
    PROP_ID_ADAPTOR_VNIC_STATSPACKETS_TX_DELTA_AVG = "adaptorVnicStatspacketsTxDeltaAvg"
    PROP_ID_ADAPTOR_VNIC_STATSPACKETS_TX_DELTA_MAX = "adaptorVnicStatspacketsTxDeltaMax"
    PROP_ID_ADAPTOR_VNIC_STATSPACKETS_TX_DELTA_MIN = "adaptorVnicStatspacketsTxDeltaMin"
    PROP_ID_COMPUTE_IOHUB_ENV_STATSTEMPERATURE = "computeIOHubEnvStatstemperature"
    PROP_ID_COMPUTE_IOHUB_ENV_STATSTEMPERATURE_AVG = "computeIOHubEnvStatstemperatureAvg"
    PROP_ID_COMPUTE_IOHUB_ENV_STATSTEMPERATURE_MAX = "computeIOHubEnvStatstemperatureMax"
    PROP_ID_COMPUTE_IOHUB_ENV_STATSTEMPERATURE_MIN = "computeIOHubEnvStatstemperatureMin"
    PROP_ID_COMPUTE_MB_POWER_STATSCONSUMED_POWER = "computeMbPowerStatsconsumedPower"
    PROP_ID_COMPUTE_MB_POWER_STATSCONSUMED_POWER_AVG = "computeMbPowerStatsconsumedPowerAvg"
    PROP_ID_COMPUTE_MB_POWER_STATSCONSUMED_POWER_MAX = "computeMbPowerStatsconsumedPowerMax"
    PROP_ID_COMPUTE_MB_POWER_STATSCONSUMED_POWER_MIN = "computeMbPowerStatsconsumedPowerMin"
    PROP_ID_COMPUTE_MB_POWER_STATSINPUT_CURRENT = "computeMbPowerStatsinputCurrent"
    PROP_ID_COMPUTE_MB_POWER_STATSINPUT_CURRENT_AVG = "computeMbPowerStatsinputCurrentAvg"
    PROP_ID_COMPUTE_MB_POWER_STATSINPUT_CURRENT_MAX = "computeMbPowerStatsinputCurrentMax"
    PROP_ID_COMPUTE_MB_POWER_STATSINPUT_CURRENT_MIN = "computeMbPowerStatsinputCurrentMin"
    PROP_ID_COMPUTE_MB_POWER_STATSINPUT_VOLTAGE = "computeMbPowerStatsinputVoltage"
    PROP_ID_COMPUTE_MB_POWER_STATSINPUT_VOLTAGE_AVG = "computeMbPowerStatsinputVoltageAvg"
    PROP_ID_COMPUTE_MB_POWER_STATSINPUT_VOLTAGE_MAX = "computeMbPowerStatsinputVoltageMax"
    PROP_ID_COMPUTE_MB_POWER_STATSINPUT_VOLTAGE_MIN = "computeMbPowerStatsinputVoltageMin"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_IO = "computeMbTempStatsfmTempSenIo"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_IO_AVG = "computeMbTempStatsfmTempSenIoAvg"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_IO_MAX = "computeMbTempStatsfmTempSenIoMax"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_IO_MIN = "computeMbTempStatsfmTempSenIoMin"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR = "computeMbTempStatsfmTempSenRear"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_AVG = "computeMbTempStatsfmTempSenRearAvg"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_L = "computeMbTempStatsfmTempSenRearL"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_LAVG = "computeMbTempStatsfmTempSenRearLAvg"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_LMAX = "computeMbTempStatsfmTempSenRearLMax"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_LMIN = "computeMbTempStatsfmTempSenRearLMin"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_MAX = "computeMbTempStatsfmTempSenRearMax"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_MIN = "computeMbTempStatsfmTempSenRearMin"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_R = "computeMbTempStatsfmTempSenRearR"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_RAVG = "computeMbTempStatsfmTempSenRearRAvg"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_RMAX = "computeMbTempStatsfmTempSenRearRMax"
    PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_RMIN = "computeMbTempStatsfmTempSenRearRMin"
    PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS = "computePCIeFatalCompletionStatsAbortErrors"
    PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS = "computePCIeFatalCompletionStatsTimeoutErrors"
    PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATSUNEXPECTED_ERRORS = "computePCIeFatalCompletionStatsunexpectedErrors"
    PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATSDLLP_ERRORS = "computePCIeFatalProtocolStatsdllpErrors"
    PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATSFLOW_CONTROL_ERRORS = "computePCIeFatalProtocolStatsflowControlErrors"
    PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATSBUFFER_OVERFLOW_ERRORS = "computePCIeFatalReceiveStatsbufferOverflowErrors"
    PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATSERR_FATAL_ERRORS = "computePCIeFatalReceiveStatserrFatalErrors"
    PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATSERR_NON_FATAL_ERRORS = "computePCIeFatalReceiveStatserrNonFatalErrors"
    PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATSUNSUPPORTED_REQUEST_ERRORS = "computePCIeFatalReceiveStatsunsupportedRequestErrors"
    PROP_ID_COMPUTE_PCIE_FATAL_STATSACS_VIOLATION_ERRORS = "computePCIeFatalStatsacsViolationErrors"
    PROP_ID_COMPUTE_PCIE_FATAL_STATSMALFORMED_TLPERRORS = "computePCIeFatalStatsmalformedTLPErrors"
    PROP_ID_COMPUTE_PCIE_FATAL_STATSPOISONED_TLPERRORS = "computePCIeFatalStatspoisonedTLPErrors"
    PROP_ID_COMPUTE_PCIE_FATAL_STATSSURPRISE_LINK_DOWN_ERRORS = "computePCIeFatalStatssurpriseLinkDownErrors"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSAMBIENT_TEMP = "computeRackUnitMbTempStatsambientTemp"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSAMBIENT_TEMP_AVG = "computeRackUnitMbTempStatsambientTempAvg"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSAMBIENT_TEMP_MAX = "computeRackUnitMbTempStatsambientTempMax"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSAMBIENT_TEMP_MIN = "computeRackUnitMbTempStatsambientTempMin"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSFRONT_TEMP = "computeRackUnitMbTempStatsfrontTemp"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSFRONT_TEMP_AVG = "computeRackUnitMbTempStatsfrontTempAvg"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSFRONT_TEMP_MAX = "computeRackUnitMbTempStatsfrontTempMax"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSFRONT_TEMP_MIN = "computeRackUnitMbTempStatsfrontTempMin"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH1_TEMP = "computeRackUnitMbTempStatsioh1Temp"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH1_TEMP_AVG = "computeRackUnitMbTempStatsioh1TempAvg"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH1_TEMP_MAX = "computeRackUnitMbTempStatsioh1TempMax"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH1_TEMP_MIN = "computeRackUnitMbTempStatsioh1TempMin"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH2_TEMP = "computeRackUnitMbTempStatsioh2Temp"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH2_TEMP_AVG = "computeRackUnitMbTempStatsioh2TempAvg"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH2_TEMP_MAX = "computeRackUnitMbTempStatsioh2TempMax"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH2_TEMP_MIN = "computeRackUnitMbTempStatsioh2TempMin"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSREAR_TEMP = "computeRackUnitMbTempStatsrearTemp"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSREAR_TEMP_AVG = "computeRackUnitMbTempStatsrearTempAvg"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSREAR_TEMP_MAX = "computeRackUnitMbTempStatsrearTempMax"
    PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSREAR_TEMP_MIN = "computeRackUnitMbTempStatsrearTempMin"
    PROP_ID_EQUIPMENT_CHASSIS_STATS_CHASSIS_I2_CERRORS = "equipmentChassisStatsChassisI2CErrors"
    PROP_ID_EQUIPMENT_CHASSIS_STATS_CHASSIS_I2_CERRORS_AVG = "equipmentChassisStatsChassisI2CErrorsAvg"
    PROP_ID_EQUIPMENT_CHASSIS_STATS_CHASSIS_I2_CERRORS_MAX = "equipmentChassisStatsChassisI2CErrorsMax"
    PROP_ID_EQUIPMENT_CHASSIS_STATS_CHASSIS_I2_CERRORS_MIN = "equipmentChassisStatsChassisI2CErrorsMin"
    PROP_ID_EQUIPMENT_CHASSIS_STATSINPUT_POWER = "equipmentChassisStatsinputPower"
    PROP_ID_EQUIPMENT_CHASSIS_STATSINPUT_POWER_AVG = "equipmentChassisStatsinputPowerAvg"
    PROP_ID_EQUIPMENT_CHASSIS_STATSINPUT_POWER_MAX = "equipmentChassisStatsinputPowerMax"
    PROP_ID_EQUIPMENT_CHASSIS_STATSINPUT_POWER_MIN = "equipmentChassisStatsinputPowerMin"
    PROP_ID_EQUIPMENT_CHASSIS_STATSOUTPUT_POWER = "equipmentChassisStatsoutputPower"
    PROP_ID_EQUIPMENT_CHASSIS_STATSOUTPUT_POWER_AVG = "equipmentChassisStatsoutputPowerAvg"
    PROP_ID_EQUIPMENT_CHASSIS_STATSOUTPUT_POWER_MAX = "equipmentChassisStatsoutputPowerMax"
    PROP_ID_EQUIPMENT_CHASSIS_STATSOUTPUT_POWER_MIN = "equipmentChassisStatsoutputPowerMin"
    PROP_ID_EQUIPMENT_FAN_MODULE_STATS_FAN_MODULE_I2_CERRORS = "equipmentFanModuleStatsFanModuleI2CErrors"
    PROP_ID_EQUIPMENT_FAN_MODULE_STATS_FAN_MODULE_I2_CERRORS_AVG = "equipmentFanModuleStatsFanModuleI2CErrorsAvg"
    PROP_ID_EQUIPMENT_FAN_MODULE_STATS_FAN_MODULE_I2_CERRORS_MAX = "equipmentFanModuleStatsFanModuleI2CErrorsMax"
    PROP_ID_EQUIPMENT_FAN_MODULE_STATS_FAN_MODULE_I2_CERRORS_MIN = "equipmentFanModuleStatsFanModuleI2CErrorsMin"
    PROP_ID_EQUIPMENT_FAN_MODULE_STATSAMBIENT_TEMP = "equipmentFanModuleStatsambientTemp"
    PROP_ID_EQUIPMENT_FAN_MODULE_STATSAMBIENT_TEMP_AVG = "equipmentFanModuleStatsambientTempAvg"
    PROP_ID_EQUIPMENT_FAN_MODULE_STATSAMBIENT_TEMP_MAX = "equipmentFanModuleStatsambientTempMax"
    PROP_ID_EQUIPMENT_FAN_MODULE_STATSAMBIENT_TEMP_MIN = "equipmentFanModuleStatsambientTempMin"
    PROP_ID_EQUIPMENT_FAN_STATSSPEED = "equipmentFanStatsspeed"
    PROP_ID_EQUIPMENT_FAN_STATSSPEED_AVG = "equipmentFanStatsspeedAvg"
    PROP_ID_EQUIPMENT_FAN_STATSSPEED_MAX = "equipmentFanStatsspeedMax"
    PROP_ID_EQUIPMENT_FAN_STATSSPEED_MIN = "equipmentFanStatsspeedMin"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSDIE1 = "equipmentFexEnvStatsdie1"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSDIE1_AVG = "equipmentFexEnvStatsdie1Avg"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSDIE1_MAX = "equipmentFexEnvStatsdie1Max"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSDIE1_MIN = "equipmentFexEnvStatsdie1Min"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET = "equipmentFexEnvStatsinlet"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET1 = "equipmentFexEnvStatsinlet1"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET1_AVG = "equipmentFexEnvStatsinlet1Avg"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET1_MAX = "equipmentFexEnvStatsinlet1Max"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET1_MIN = "equipmentFexEnvStatsinlet1Min"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET_AVG = "equipmentFexEnvStatsinletAvg"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET_MAX = "equipmentFexEnvStatsinletMax"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET_MIN = "equipmentFexEnvStatsinletMin"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET1 = "equipmentFexEnvStatsoutlet1"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET1_AVG = "equipmentFexEnvStatsoutlet1Avg"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET1_MAX = "equipmentFexEnvStatsoutlet1Max"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET1_MIN = "equipmentFexEnvStatsoutlet1Min"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET2 = "equipmentFexEnvStatsoutlet2"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET2_AVG = "equipmentFexEnvStatsoutlet2Avg"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET2_MAX = "equipmentFexEnvStatsoutlet2Max"
    PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET2_MIN = "equipmentFexEnvStatsoutlet2Min"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER = "equipmentFexPowerSummaryModulePower"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER_AVG = "equipmentFexPowerSummaryModulePowerAvg"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER_MAX = "equipmentFexPowerSummaryModulePowerMax"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER_MIN = "equipmentFexPowerSummaryModulePowerMin"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYAVAILABLE_POWER = "equipmentFexPowerSummaryavailablePower"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYAVAILABLE_POWER_AVG = "equipmentFexPowerSummaryavailablePowerAvg"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYAVAILABLE_POWER_MAX = "equipmentFexPowerSummaryavailablePowerMax"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYAVAILABLE_POWER_MIN = "equipmentFexPowerSummaryavailablePowerMin"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYRESERVED_POWER = "equipmentFexPowerSummaryreservedPower"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYRESERVED_POWER_AVG = "equipmentFexPowerSummaryreservedPowerAvg"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYRESERVED_POWER_MAX = "equipmentFexPowerSummaryreservedPowerMax"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYRESERVED_POWER_MIN = "equipmentFexPowerSummaryreservedPowerMin"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYTOTAL_POWER = "equipmentFexPowerSummarytotalPower"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYTOTAL_POWER_AVG = "equipmentFexPowerSummarytotalPowerAvg"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYTOTAL_POWER_MAX = "equipmentFexPowerSummarytotalPowerMax"
    PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYTOTAL_POWER_MIN = "equipmentFexPowerSummarytotalPowerMin"
    PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSCURRENT = "equipmentFexPsuInputStatscurrent"
    PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSCURRENT_AVG = "equipmentFexPsuInputStatscurrentAvg"
    PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSCURRENT_MAX = "equipmentFexPsuInputStatscurrentMax"
    PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSCURRENT_MIN = "equipmentFexPsuInputStatscurrentMin"
    PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSPOWER = "equipmentFexPsuInputStatspower"
    PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSPOWER_AVG = "equipmentFexPsuInputStatspowerAvg"
    PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSPOWER_MAX = "equipmentFexPsuInputStatspowerMax"
    PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSPOWER_MIN = "equipmentFexPsuInputStatspowerMin"
    PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSVOLTAGE = "equipmentFexPsuInputStatsvoltage"
    PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSVOLTAGE_AVG = "equipmentFexPsuInputStatsvoltageAvg"
    PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSVOLTAGE_MAX = "equipmentFexPsuInputStatsvoltageMax"
    PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSVOLTAGE_MIN = "equipmentFexPsuInputStatsvoltageMin"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSKERNEL_MEM_FREE = "equipmentFexSystemStatskernelMemFree"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSKERNEL_MEM_FREE_AVG = "equipmentFexSystemStatskernelMemFreeAvg"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSKERNEL_MEM_FREE_MAX = "equipmentFexSystemStatskernelMemFreeMax"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSKERNEL_MEM_FREE_MIN = "equipmentFexSystemStatskernelMemFreeMin"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSKERNEL_MEM_TOTAL = "equipmentFexSystemStatskernelMemTotal"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSKERNEL_MEM_TOTAL_AVG = "equipmentFexSystemStatskernelMemTotalAvg"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSKERNEL_MEM_TOTAL_MAX = "equipmentFexSystemStatskernelMemTotalMax"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSKERNEL_MEM_TOTAL_MIN = "equipmentFexSystemStatskernelMemTotalMin"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSLOAD = "equipmentFexSystemStatsload"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSLOAD_AVG = "equipmentFexSystemStatsloadAvg"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSLOAD_MAX = "equipmentFexSystemStatsloadMax"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSLOAD_MIN = "equipmentFexSystemStatsloadMin"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSMEM_AVAILABLE = "equipmentFexSystemStatsmemAvailable"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSMEM_AVAILABLE_AVG = "equipmentFexSystemStatsmemAvailableAvg"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSMEM_AVAILABLE_MAX = "equipmentFexSystemStatsmemAvailableMax"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSMEM_AVAILABLE_MIN = "equipmentFexSystemStatsmemAvailableMin"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSMEM_CACHED = "equipmentFexSystemStatsmemCached"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSMEM_CACHED_AVG = "equipmentFexSystemStatsmemCachedAvg"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSMEM_CACHED_MAX = "equipmentFexSystemStatsmemCachedMax"
    PROP_ID_EQUIPMENT_FEX_SYSTEM_STATSMEM_CACHED_MIN = "equipmentFexSystemStatsmemCachedMin"
    PROP_ID_EQUIPMENT_IOCARD_STATS_IOM_I2_CERRORS = "equipmentIOCardStatsIomI2CErrors"
    PROP_ID_EQUIPMENT_IOCARD_STATS_IOM_I2_CERRORS_AVG = "equipmentIOCardStatsIomI2CErrorsAvg"
    PROP_ID_EQUIPMENT_IOCARD_STATS_IOM_I2_CERRORS_MAX = "equipmentIOCardStatsIomI2CErrorsMax"
    PROP_ID_EQUIPMENT_IOCARD_STATS_IOM_I2_CERRORS_MIN = "equipmentIOCardStatsIomI2CErrorsMin"
    PROP_ID_EQUIPMENT_IOCARD_STATSAMBIENT_TEMP = "equipmentIOCardStatsambientTemp"
    PROP_ID_EQUIPMENT_IOCARD_STATSAMBIENT_TEMP_AVG = "equipmentIOCardStatsambientTempAvg"
    PROP_ID_EQUIPMENT_IOCARD_STATSAMBIENT_TEMP_MAX = "equipmentIOCardStatsambientTempMax"
    PROP_ID_EQUIPMENT_IOCARD_STATSAMBIENT_TEMP_MIN = "equipmentIOCardStatsambientTempMin"
    PROP_ID_EQUIPMENT_IOCARD_STATSDIMM_TEMP = "equipmentIOCardStatsdimmTemp"
    PROP_ID_EQUIPMENT_IOCARD_STATSDIMM_TEMP_AVG = "equipmentIOCardStatsdimmTempAvg"
    PROP_ID_EQUIPMENT_IOCARD_STATSDIMM_TEMP_MAX = "equipmentIOCardStatsdimmTempMax"
    PROP_ID_EQUIPMENT_IOCARD_STATSDIMM_TEMP_MIN = "equipmentIOCardStatsdimmTempMin"
    PROP_ID_EQUIPMENT_IOCARD_STATSPROC_TEMP = "equipmentIOCardStatsprocTemp"
    PROP_ID_EQUIPMENT_IOCARD_STATSPROC_TEMP_AVG = "equipmentIOCardStatsprocTempAvg"
    PROP_ID_EQUIPMENT_IOCARD_STATSPROC_TEMP_MAX = "equipmentIOCardStatsprocTempMax"
    PROP_ID_EQUIPMENT_IOCARD_STATSPROC_TEMP_MIN = "equipmentIOCardStatsprocTempMin"
    PROP_ID_EQUIPMENT_IOCARD_STATSTEMP = "equipmentIOCardStatstemp"
    PROP_ID_EQUIPMENT_IOCARD_STATSTEMP_AVG = "equipmentIOCardStatstempAvg"
    PROP_ID_EQUIPMENT_IOCARD_STATSTEMP_MAX = "equipmentIOCardStatstempMax"
    PROP_ID_EQUIPMENT_IOCARD_STATSTEMP_MIN = "equipmentIOCardStatstempMin"
    PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSDRIVE_PERCENTAGE = "equipmentNetworkElementFanStatsdrivePercentage"
    PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSDRIVE_PERCENTAGE_AVG = "equipmentNetworkElementFanStatsdrivePercentageAvg"
    PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSDRIVE_PERCENTAGE_MAX = "equipmentNetworkElementFanStatsdrivePercentageMax"
    PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSDRIVE_PERCENTAGE_MIN = "equipmentNetworkElementFanStatsdrivePercentageMin"
    PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSSPEED = "equipmentNetworkElementFanStatsspeed"
    PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSSPEED_AVG = "equipmentNetworkElementFanStatsspeedAvg"
    PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSSPEED_MAX = "equipmentNetworkElementFanStatsspeedMax"
    PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSSPEED_MIN = "equipmentNetworkElementFanStatsspeedMin"
    PROP_ID_EQUIPMENT_PSU_INPUT_STATSCURRENT = "equipmentPsuInputStatscurrent"
    PROP_ID_EQUIPMENT_PSU_INPUT_STATSCURRENT_AVG = "equipmentPsuInputStatscurrentAvg"
    PROP_ID_EQUIPMENT_PSU_INPUT_STATSCURRENT_MAX = "equipmentPsuInputStatscurrentMax"
    PROP_ID_EQUIPMENT_PSU_INPUT_STATSCURRENT_MIN = "equipmentPsuInputStatscurrentMin"
    PROP_ID_EQUIPMENT_PSU_INPUT_STATSPOWER = "equipmentPsuInputStatspower"
    PROP_ID_EQUIPMENT_PSU_INPUT_STATSPOWER_AVG = "equipmentPsuInputStatspowerAvg"
    PROP_ID_EQUIPMENT_PSU_INPUT_STATSPOWER_MAX = "equipmentPsuInputStatspowerMax"
    PROP_ID_EQUIPMENT_PSU_INPUT_STATSPOWER_MIN = "equipmentPsuInputStatspowerMin"
    PROP_ID_EQUIPMENT_PSU_INPUT_STATSVOLTAGE = "equipmentPsuInputStatsvoltage"
    PROP_ID_EQUIPMENT_PSU_INPUT_STATSVOLTAGE_AVG = "equipmentPsuInputStatsvoltageAvg"
    PROP_ID_EQUIPMENT_PSU_INPUT_STATSVOLTAGE_MAX = "equipmentPsuInputStatsvoltageMax"
    PROP_ID_EQUIPMENT_PSU_INPUT_STATSVOLTAGE_MIN = "equipmentPsuInputStatsvoltageMin"
    PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSCURRENT = "equipmentPsuOutputStatscurrent"
    PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSCURRENT_AVG = "equipmentPsuOutputStatscurrentAvg"
    PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSCURRENT_MAX = "equipmentPsuOutputStatscurrentMax"
    PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSCURRENT_MIN = "equipmentPsuOutputStatscurrentMin"
    PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSPOWER = "equipmentPsuOutputStatspower"
    PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSPOWER_AVG = "equipmentPsuOutputStatspowerAvg"
    PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSPOWER_MAX = "equipmentPsuOutputStatspowerMax"
    PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSPOWER_MIN = "equipmentPsuOutputStatspowerMin"
    PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSVOLTAGE = "equipmentPsuOutputStatsvoltage"
    PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSVOLTAGE_AVG = "equipmentPsuOutputStatsvoltageAvg"
    PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSVOLTAGE_MAX = "equipmentPsuOutputStatsvoltageMax"
    PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSVOLTAGE_MIN = "equipmentPsuOutputStatsvoltageMin"
    PROP_ID_EQUIPMENT_PSU_STATS_PSU_I2_CERRORS = "equipmentPsuStatsPsuI2CErrors"
    PROP_ID_EQUIPMENT_PSU_STATS_PSU_I2_CERRORS_AVG = "equipmentPsuStatsPsuI2CErrorsAvg"
    PROP_ID_EQUIPMENT_PSU_STATS_PSU_I2_CERRORS_MAX = "equipmentPsuStatsPsuI2CErrorsMax"
    PROP_ID_EQUIPMENT_PSU_STATS_PSU_I2_CERRORS_MIN = "equipmentPsuStatsPsuI2CErrorsMin"
    PROP_ID_EQUIPMENT_PSU_STATSAMBIENT_TEMP = "equipmentPsuStatsambientTemp"
    PROP_ID_EQUIPMENT_PSU_STATSAMBIENT_TEMP_AVG = "equipmentPsuStatsambientTempAvg"
    PROP_ID_EQUIPMENT_PSU_STATSAMBIENT_TEMP_MAX = "equipmentPsuStatsambientTempMax"
    PROP_ID_EQUIPMENT_PSU_STATSAMBIENT_TEMP_MIN = "equipmentPsuStatsambientTempMin"
    PROP_ID_EQUIPMENT_PSU_STATSINPUT210V = "equipmentPsuStatsinput210v"
    PROP_ID_EQUIPMENT_PSU_STATSINPUT210V_AVG = "equipmentPsuStatsinput210vAvg"
    PROP_ID_EQUIPMENT_PSU_STATSINPUT210V_MAX = "equipmentPsuStatsinput210vMax"
    PROP_ID_EQUIPMENT_PSU_STATSINPUT210V_MIN = "equipmentPsuStatsinput210vMin"
    PROP_ID_EQUIPMENT_PSU_STATSINPUT_POWER = "equipmentPsuStatsinputPower"
    PROP_ID_EQUIPMENT_PSU_STATSINPUT_POWER_AVG = "equipmentPsuStatsinputPowerAvg"
    PROP_ID_EQUIPMENT_PSU_STATSINPUT_POWER_MAX = "equipmentPsuStatsinputPowerMax"
    PROP_ID_EQUIPMENT_PSU_STATSINPUT_POWER_MIN = "equipmentPsuStatsinputPowerMin"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT12V = "equipmentPsuStatsoutput12v"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT12V_AVG = "equipmentPsuStatsoutput12vAvg"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT12V_MAX = "equipmentPsuStatsoutput12vMax"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT12V_MIN = "equipmentPsuStatsoutput12vMin"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT3V3 = "equipmentPsuStatsoutput3v3"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT3V3_AVG = "equipmentPsuStatsoutput3v3Avg"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT3V3_MAX = "equipmentPsuStatsoutput3v3Max"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT3V3_MIN = "equipmentPsuStatsoutput3v3Min"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_CURRENT = "equipmentPsuStatsoutputCurrent"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_CURRENT_AVG = "equipmentPsuStatsoutputCurrentAvg"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_CURRENT_MAX = "equipmentPsuStatsoutputCurrentMax"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_CURRENT_MIN = "equipmentPsuStatsoutputCurrentMin"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_POWER = "equipmentPsuStatsoutputPower"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_POWER_AVG = "equipmentPsuStatsoutputPowerAvg"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_POWER_MAX = "equipmentPsuStatsoutputPowerMax"
    PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_POWER_MIN = "equipmentPsuStatsoutputPowerMin"
    PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATSSPEED = "equipmentRackUnitFanStatsspeed"
    PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATSSPEED_AVG = "equipmentRackUnitFanStatsspeedAvg"
    PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATSSPEED_MAX = "equipmentRackUnitFanStatsspeedMax"
    PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATSSPEED_MIN = "equipmentRackUnitFanStatsspeedMin"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSAMBIENT_TEMP = "equipmentRackUnitPsuStatsambientTemp"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSAMBIENT_TEMP_AVG = "equipmentRackUnitPsuStatsambientTempAvg"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSAMBIENT_TEMP_MAX = "equipmentRackUnitPsuStatsambientTempMax"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSAMBIENT_TEMP_MIN = "equipmentRackUnitPsuStatsambientTempMin"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_POWER = "equipmentRackUnitPsuStatsinputPower"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_POWER_AVG = "equipmentRackUnitPsuStatsinputPowerAvg"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_POWER_MAX = "equipmentRackUnitPsuStatsinputPowerMax"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_POWER_MIN = "equipmentRackUnitPsuStatsinputPowerMin"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_VOLTAGE = "equipmentRackUnitPsuStatsinputVoltage"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_VOLTAGE_AVG = "equipmentRackUnitPsuStatsinputVoltageAvg"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_VOLTAGE_MAX = "equipmentRackUnitPsuStatsinputVoltageMax"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_VOLTAGE_MIN = "equipmentRackUnitPsuStatsinputVoltageMin"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_CURRENT = "equipmentRackUnitPsuStatsoutputCurrent"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_CURRENT_AVG = "equipmentRackUnitPsuStatsoutputCurrentAvg"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_CURRENT_MAX = "equipmentRackUnitPsuStatsoutputCurrentMax"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_CURRENT_MIN = "equipmentRackUnitPsuStatsoutputCurrentMin"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_POWER = "equipmentRackUnitPsuStatsoutputPower"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_POWER_AVG = "equipmentRackUnitPsuStatsoutputPowerAvg"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_POWER_MAX = "equipmentRackUnitPsuStatsoutputPowerMax"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_POWER_MIN = "equipmentRackUnitPsuStatsoutputPowerMin"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_VOLTAGE = "equipmentRackUnitPsuStatsoutputVoltage"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_VOLTAGE_AVG = "equipmentRackUnitPsuStatsoutputVoltageAvg"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_VOLTAGE_MAX = "equipmentRackUnitPsuStatsoutputVoltageMax"
    PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_VOLTAGE_MIN = "equipmentRackUnitPsuStatsoutputVoltageMin"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSCMC_TEMP = "equipmentSiocTempStatscmcTemp"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSCMC_TEMP_AVG = "equipmentSiocTempStatscmcTempAvg"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSCMC_TEMP_MAX = "equipmentSiocTempStatscmcTempMax"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSCMC_TEMP_MIN = "equipmentSiocTempStatscmcTempMin"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSFRONT_TEMP = "equipmentSiocTempStatsfrontTemp"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSFRONT_TEMP_AVG = "equipmentSiocTempStatsfrontTempAvg"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSFRONT_TEMP_MAX = "equipmentSiocTempStatsfrontTempMax"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSFRONT_TEMP_MIN = "equipmentSiocTempStatsfrontTempMin"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSMID_TEMP = "equipmentSiocTempStatsmidTemp"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSMID_TEMP_AVG = "equipmentSiocTempStatsmidTempAvg"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSMID_TEMP_MAX = "equipmentSiocTempStatsmidTempMax"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSMID_TEMP_MIN = "equipmentSiocTempStatsmidTempMin"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSREAR_TEMP = "equipmentSiocTempStatsrearTemp"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSREAR_TEMP_AVG = "equipmentSiocTempStatsrearTempAvg"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSREAR_TEMP_MAX = "equipmentSiocTempStatsrearTempMax"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSREAR_TEMP_MIN = "equipmentSiocTempStatsrearTempMin"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSVIC_TEMP = "equipmentSiocTempStatsvicTemp"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSVIC_TEMP_AVG = "equipmentSiocTempStatsvicTempAvg"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSVIC_TEMP_MAX = "equipmentSiocTempStatsvicTempMax"
    PROP_ID_EQUIPMENT_SIOC_TEMP_STATSVIC_TEMP_MIN = "equipmentSiocTempStatsvicTempMin"
    PROP_ID_ETHER_ERR_STATSALIGN_DELTA = "etherErrStatsalignDelta"
    PROP_ID_ETHER_ERR_STATSALIGN_DELTA_AVG = "etherErrStatsalignDeltaAvg"
    PROP_ID_ETHER_ERR_STATSALIGN_DELTA_MAX = "etherErrStatsalignDeltaMax"
    PROP_ID_ETHER_ERR_STATSALIGN_DELTA_MIN = "etherErrStatsalignDeltaMin"
    PROP_ID_ETHER_ERR_STATSDEFERRED_TX_DELTA = "etherErrStatsdeferredTxDelta"
    PROP_ID_ETHER_ERR_STATSDEFERRED_TX_DELTA_AVG = "etherErrStatsdeferredTxDeltaAvg"
    PROP_ID_ETHER_ERR_STATSDEFERRED_TX_DELTA_MAX = "etherErrStatsdeferredTxDeltaMax"
    PROP_ID_ETHER_ERR_STATSDEFERRED_TX_DELTA_MIN = "etherErrStatsdeferredTxDeltaMin"
    PROP_ID_ETHER_ERR_STATSFCS_DELTA = "etherErrStatsfcsDelta"
    PROP_ID_ETHER_ERR_STATSFCS_DELTA_AVG = "etherErrStatsfcsDeltaAvg"
    PROP_ID_ETHER_ERR_STATSFCS_DELTA_MAX = "etherErrStatsfcsDeltaMax"
    PROP_ID_ETHER_ERR_STATSFCS_DELTA_MIN = "etherErrStatsfcsDeltaMin"
    PROP_ID_ETHER_ERR_STATSINT_MAC_RX_DELTA = "etherErrStatsintMacRxDelta"
    PROP_ID_ETHER_ERR_STATSINT_MAC_RX_DELTA_AVG = "etherErrStatsintMacRxDeltaAvg"
    PROP_ID_ETHER_ERR_STATSINT_MAC_RX_DELTA_MAX = "etherErrStatsintMacRxDeltaMax"
    PROP_ID_ETHER_ERR_STATSINT_MAC_RX_DELTA_MIN = "etherErrStatsintMacRxDeltaMin"
    PROP_ID_ETHER_ERR_STATSINT_MAC_TX_DELTA = "etherErrStatsintMacTxDelta"
    PROP_ID_ETHER_ERR_STATSINT_MAC_TX_DELTA_AVG = "etherErrStatsintMacTxDeltaAvg"
    PROP_ID_ETHER_ERR_STATSINT_MAC_TX_DELTA_MAX = "etherErrStatsintMacTxDeltaMax"
    PROP_ID_ETHER_ERR_STATSINT_MAC_TX_DELTA_MIN = "etherErrStatsintMacTxDeltaMin"
    PROP_ID_ETHER_ERR_STATSOUT_DISCARD_DELTA = "etherErrStatsoutDiscardDelta"
    PROP_ID_ETHER_ERR_STATSOUT_DISCARD_DELTA_AVG = "etherErrStatsoutDiscardDeltaAvg"
    PROP_ID_ETHER_ERR_STATSOUT_DISCARD_DELTA_MAX = "etherErrStatsoutDiscardDeltaMax"
    PROP_ID_ETHER_ERR_STATSOUT_DISCARD_DELTA_MIN = "etherErrStatsoutDiscardDeltaMin"
    PROP_ID_ETHER_ERR_STATSRCV_DELTA = "etherErrStatsrcvDelta"
    PROP_ID_ETHER_ERR_STATSRCV_DELTA_AVG = "etherErrStatsrcvDeltaAvg"
    PROP_ID_ETHER_ERR_STATSRCV_DELTA_MAX = "etherErrStatsrcvDeltaMax"
    PROP_ID_ETHER_ERR_STATSRCV_DELTA_MIN = "etherErrStatsrcvDeltaMin"
    PROP_ID_ETHER_ERR_STATSUNDER_SIZE_DELTA = "etherErrStatsunderSizeDelta"
    PROP_ID_ETHER_ERR_STATSUNDER_SIZE_DELTA_AVG = "etherErrStatsunderSizeDeltaAvg"
    PROP_ID_ETHER_ERR_STATSUNDER_SIZE_DELTA_MAX = "etherErrStatsunderSizeDeltaMax"
    PROP_ID_ETHER_ERR_STATSUNDER_SIZE_DELTA_MIN = "etherErrStatsunderSizeDeltaMin"
    PROP_ID_ETHER_ERR_STATSXMIT_DELTA = "etherErrStatsxmitDelta"
    PROP_ID_ETHER_ERR_STATSXMIT_DELTA_AVG = "etherErrStatsxmitDeltaAvg"
    PROP_ID_ETHER_ERR_STATSXMIT_DELTA_MAX = "etherErrStatsxmitDeltaMax"
    PROP_ID_ETHER_ERR_STATSXMIT_DELTA_MIN = "etherErrStatsxmitDeltaMin"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_RX_DELTA = "etherFcoeInterfaceStatsbytesRxDelta"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_RX_DELTA_AVG = "etherFcoeInterfaceStatsbytesRxDeltaAvg"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_RX_DELTA_MAX = "etherFcoeInterfaceStatsbytesRxDeltaMax"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_RX_DELTA_MIN = "etherFcoeInterfaceStatsbytesRxDeltaMin"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_TX_DELTA = "etherFcoeInterfaceStatsbytesTxDelta"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_TX_DELTA_AVG = "etherFcoeInterfaceStatsbytesTxDeltaAvg"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_TX_DELTA_MAX = "etherFcoeInterfaceStatsbytesTxDeltaMax"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_TX_DELTA_MIN = "etherFcoeInterfaceStatsbytesTxDeltaMin"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_RX_DELTA = "etherFcoeInterfaceStatsdroppedRxDelta"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_RX_DELTA_AVG = "etherFcoeInterfaceStatsdroppedRxDeltaAvg"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_RX_DELTA_MAX = "etherFcoeInterfaceStatsdroppedRxDeltaMax"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_RX_DELTA_MIN = "etherFcoeInterfaceStatsdroppedRxDeltaMin"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_TX_DELTA = "etherFcoeInterfaceStatsdroppedTxDelta"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_TX_DELTA_AVG = "etherFcoeInterfaceStatsdroppedTxDeltaAvg"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_TX_DELTA_MAX = "etherFcoeInterfaceStatsdroppedTxDeltaMax"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_TX_DELTA_MIN = "etherFcoeInterfaceStatsdroppedTxDeltaMin"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_RX_DELTA = "etherFcoeInterfaceStatserrorsRxDelta"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_RX_DELTA_AVG = "etherFcoeInterfaceStatserrorsRxDeltaAvg"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_RX_DELTA_MAX = "etherFcoeInterfaceStatserrorsRxDeltaMax"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_RX_DELTA_MIN = "etherFcoeInterfaceStatserrorsRxDeltaMin"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_TX_DELTA = "etherFcoeInterfaceStatserrorsTxDelta"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_TX_DELTA_AVG = "etherFcoeInterfaceStatserrorsTxDeltaAvg"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_TX_DELTA_MAX = "etherFcoeInterfaceStatserrorsTxDeltaMax"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_TX_DELTA_MIN = "etherFcoeInterfaceStatserrorsTxDeltaMin"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_RX_DELTA = "etherFcoeInterfaceStatspacketsRxDelta"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_RX_DELTA_AVG = "etherFcoeInterfaceStatspacketsRxDeltaAvg"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_RX_DELTA_MAX = "etherFcoeInterfaceStatspacketsRxDeltaMax"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_RX_DELTA_MIN = "etherFcoeInterfaceStatspacketsRxDeltaMin"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_TX_DELTA = "etherFcoeInterfaceStatspacketsTxDelta"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_TX_DELTA_AVG = "etherFcoeInterfaceStatspacketsTxDeltaAvg"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_TX_DELTA_MAX = "etherFcoeInterfaceStatspacketsTxDeltaMax"
    PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_TX_DELTA_MIN = "etherFcoeInterfaceStatspacketsTxDeltaMin"
    PROP_ID_ETHER_LOSS_STATS_SQETEST_DELTA = "etherLossStatsSQETestDelta"
    PROP_ID_ETHER_LOSS_STATS_SQETEST_DELTA_AVG = "etherLossStatsSQETestDeltaAvg"
    PROP_ID_ETHER_LOSS_STATS_SQETEST_DELTA_MAX = "etherLossStatsSQETestDeltaMax"
    PROP_ID_ETHER_LOSS_STATS_SQETEST_DELTA_MIN = "etherLossStatsSQETestDeltaMin"
    PROP_ID_ETHER_LOSS_STATSCARRIER_SENSE_DELTA = "etherLossStatscarrierSenseDelta"
    PROP_ID_ETHER_LOSS_STATSCARRIER_SENSE_DELTA_AVG = "etherLossStatscarrierSenseDeltaAvg"
    PROP_ID_ETHER_LOSS_STATSCARRIER_SENSE_DELTA_MAX = "etherLossStatscarrierSenseDeltaMax"
    PROP_ID_ETHER_LOSS_STATSCARRIER_SENSE_DELTA_MIN = "etherLossStatscarrierSenseDeltaMin"
    PROP_ID_ETHER_LOSS_STATSEXCESS_COLLISION_DELTA = "etherLossStatsexcessCollisionDelta"
    PROP_ID_ETHER_LOSS_STATSEXCESS_COLLISION_DELTA_AVG = "etherLossStatsexcessCollisionDeltaAvg"
    PROP_ID_ETHER_LOSS_STATSEXCESS_COLLISION_DELTA_MAX = "etherLossStatsexcessCollisionDeltaMax"
    PROP_ID_ETHER_LOSS_STATSEXCESS_COLLISION_DELTA_MIN = "etherLossStatsexcessCollisionDeltaMin"
    PROP_ID_ETHER_LOSS_STATSGIANTS_DELTA = "etherLossStatsgiantsDelta"
    PROP_ID_ETHER_LOSS_STATSGIANTS_DELTA_AVG = "etherLossStatsgiantsDeltaAvg"
    PROP_ID_ETHER_LOSS_STATSGIANTS_DELTA_MAX = "etherLossStatsgiantsDeltaMax"
    PROP_ID_ETHER_LOSS_STATSGIANTS_DELTA_MIN = "etherLossStatsgiantsDeltaMin"
    PROP_ID_ETHER_LOSS_STATSLATE_COLLISION_DELTA = "etherLossStatslateCollisionDelta"
    PROP_ID_ETHER_LOSS_STATSLATE_COLLISION_DELTA_AVG = "etherLossStatslateCollisionDeltaAvg"
    PROP_ID_ETHER_LOSS_STATSLATE_COLLISION_DELTA_MAX = "etherLossStatslateCollisionDeltaMax"
    PROP_ID_ETHER_LOSS_STATSLATE_COLLISION_DELTA_MIN = "etherLossStatslateCollisionDeltaMin"
    PROP_ID_ETHER_LOSS_STATSMULTI_COLLISION_DELTA = "etherLossStatsmultiCollisionDelta"
    PROP_ID_ETHER_LOSS_STATSMULTI_COLLISION_DELTA_AVG = "etherLossStatsmultiCollisionDeltaAvg"
    PROP_ID_ETHER_LOSS_STATSMULTI_COLLISION_DELTA_MAX = "etherLossStatsmultiCollisionDeltaMax"
    PROP_ID_ETHER_LOSS_STATSMULTI_COLLISION_DELTA_MIN = "etherLossStatsmultiCollisionDeltaMin"
    PROP_ID_ETHER_LOSS_STATSSINGLE_COLLISION_DELTA = "etherLossStatssingleCollisionDelta"
    PROP_ID_ETHER_LOSS_STATSSINGLE_COLLISION_DELTA_AVG = "etherLossStatssingleCollisionDeltaAvg"
    PROP_ID_ETHER_LOSS_STATSSINGLE_COLLISION_DELTA_MAX = "etherLossStatssingleCollisionDeltaMax"
    PROP_ID_ETHER_LOSS_STATSSINGLE_COLLISION_DELTA_MIN = "etherLossStatssingleCollisionDeltaMin"
    PROP_ID_ETHER_LOSS_STATSSYMBOL_DELTA = "etherLossStatssymbolDelta"
    PROP_ID_ETHER_LOSS_STATSSYMBOL_DELTA_AVG = "etherLossStatssymbolDeltaAvg"
    PROP_ID_ETHER_LOSS_STATSSYMBOL_DELTA_MAX = "etherLossStatssymbolDeltaMax"
    PROP_ID_ETHER_LOSS_STATSSYMBOL_DELTA_MIN = "etherLossStatssymbolDeltaMin"
    PROP_ID_ETHER_NI_ERR_STATSCRC_DELTA = "etherNiErrStatscrcDelta"
    PROP_ID_ETHER_NI_ERR_STATSCRC_DELTA_AVG = "etherNiErrStatscrcDeltaAvg"
    PROP_ID_ETHER_NI_ERR_STATSCRC_DELTA_MAX = "etherNiErrStatscrcDeltaMax"
    PROP_ID_ETHER_NI_ERR_STATSCRC_DELTA_MIN = "etherNiErrStatscrcDeltaMin"
    PROP_ID_ETHER_NI_ERR_STATSFRAME_TX_DELTA = "etherNiErrStatsframeTxDelta"
    PROP_ID_ETHER_NI_ERR_STATSFRAME_TX_DELTA_AVG = "etherNiErrStatsframeTxDeltaAvg"
    PROP_ID_ETHER_NI_ERR_STATSFRAME_TX_DELTA_MAX = "etherNiErrStatsframeTxDeltaMax"
    PROP_ID_ETHER_NI_ERR_STATSFRAME_TX_DELTA_MIN = "etherNiErrStatsframeTxDeltaMin"
    PROP_ID_ETHER_NI_ERR_STATSIN_RANGE_DELTA = "etherNiErrStatsinRangeDelta"
    PROP_ID_ETHER_NI_ERR_STATSIN_RANGE_DELTA_AVG = "etherNiErrStatsinRangeDeltaAvg"
    PROP_ID_ETHER_NI_ERR_STATSIN_RANGE_DELTA_MAX = "etherNiErrStatsinRangeDeltaMax"
    PROP_ID_ETHER_NI_ERR_STATSIN_RANGE_DELTA_MIN = "etherNiErrStatsinRangeDeltaMin"
    PROP_ID_ETHER_NI_ERR_STATSTOO_LONG_DELTA = "etherNiErrStatstooLongDelta"
    PROP_ID_ETHER_NI_ERR_STATSTOO_LONG_DELTA_AVG = "etherNiErrStatstooLongDeltaAvg"
    PROP_ID_ETHER_NI_ERR_STATSTOO_LONG_DELTA_MAX = "etherNiErrStatstooLongDeltaMax"
    PROP_ID_ETHER_NI_ERR_STATSTOO_LONG_DELTA_MIN = "etherNiErrStatstooLongDeltaMin"
    PROP_ID_ETHER_NI_ERR_STATSTOO_SHORT_DELTA = "etherNiErrStatstooShortDelta"
    PROP_ID_ETHER_NI_ERR_STATSTOO_SHORT_DELTA_AVG = "etherNiErrStatstooShortDeltaAvg"
    PROP_ID_ETHER_NI_ERR_STATSTOO_SHORT_DELTA_MAX = "etherNiErrStatstooShortDeltaMax"
    PROP_ID_ETHER_NI_ERR_STATSTOO_SHORT_DELTA_MIN = "etherNiErrStatstooShortDeltaMin"
    PROP_ID_ETHER_PAUSE_STATSRECV_PAUSE_DELTA = "etherPauseStatsrecvPauseDelta"
    PROP_ID_ETHER_PAUSE_STATSRECV_PAUSE_DELTA_AVG = "etherPauseStatsrecvPauseDeltaAvg"
    PROP_ID_ETHER_PAUSE_STATSRECV_PAUSE_DELTA_MAX = "etherPauseStatsrecvPauseDeltaMax"
    PROP_ID_ETHER_PAUSE_STATSRECV_PAUSE_DELTA_MIN = "etherPauseStatsrecvPauseDeltaMin"
    PROP_ID_ETHER_PAUSE_STATSRESETS_DELTA = "etherPauseStatsresetsDelta"
    PROP_ID_ETHER_PAUSE_STATSRESETS_DELTA_AVG = "etherPauseStatsresetsDeltaAvg"
    PROP_ID_ETHER_PAUSE_STATSRESETS_DELTA_MAX = "etherPauseStatsresetsDeltaMax"
    PROP_ID_ETHER_PAUSE_STATSRESETS_DELTA_MIN = "etherPauseStatsresetsDeltaMin"
    PROP_ID_ETHER_PAUSE_STATSXMIT_PAUSE_DELTA = "etherPauseStatsxmitPauseDelta"
    PROP_ID_ETHER_PAUSE_STATSXMIT_PAUSE_DELTA_AVG = "etherPauseStatsxmitPauseDeltaAvg"
    PROP_ID_ETHER_PAUSE_STATSXMIT_PAUSE_DELTA_MAX = "etherPauseStatsxmitPauseDeltaMax"
    PROP_ID_ETHER_PAUSE_STATSXMIT_PAUSE_DELTA_MIN = "etherPauseStatsxmitPauseDeltaMin"
    PROP_ID_ETHER_RX_STATSBROADCAST_PACKETS_DELTA = "etherRxStatsbroadcastPacketsDelta"
    PROP_ID_ETHER_RX_STATSBROADCAST_PACKETS_DELTA_AVG = "etherRxStatsbroadcastPacketsDeltaAvg"
    PROP_ID_ETHER_RX_STATSBROADCAST_PACKETS_DELTA_MAX = "etherRxStatsbroadcastPacketsDeltaMax"
    PROP_ID_ETHER_RX_STATSBROADCAST_PACKETS_DELTA_MIN = "etherRxStatsbroadcastPacketsDeltaMin"
    PROP_ID_ETHER_RX_STATSJUMBO_PACKETS_DELTA = "etherRxStatsjumboPacketsDelta"
    PROP_ID_ETHER_RX_STATSJUMBO_PACKETS_DELTA_AVG = "etherRxStatsjumboPacketsDeltaAvg"
    PROP_ID_ETHER_RX_STATSJUMBO_PACKETS_DELTA_MAX = "etherRxStatsjumboPacketsDeltaMax"
    PROP_ID_ETHER_RX_STATSJUMBO_PACKETS_DELTA_MIN = "etherRxStatsjumboPacketsDeltaMin"
    PROP_ID_ETHER_RX_STATSMULTICAST_PACKETS_DELTA = "etherRxStatsmulticastPacketsDelta"
    PROP_ID_ETHER_RX_STATSMULTICAST_PACKETS_DELTA_AVG = "etherRxStatsmulticastPacketsDeltaAvg"
    PROP_ID_ETHER_RX_STATSMULTICAST_PACKETS_DELTA_MAX = "etherRxStatsmulticastPacketsDeltaMax"
    PROP_ID_ETHER_RX_STATSMULTICAST_PACKETS_DELTA_MIN = "etherRxStatsmulticastPacketsDeltaMin"
    PROP_ID_ETHER_RX_STATSTOTAL_BYTES_DELTA = "etherRxStatstotalBytesDelta"
    PROP_ID_ETHER_RX_STATSTOTAL_BYTES_DELTA_AVG = "etherRxStatstotalBytesDeltaAvg"
    PROP_ID_ETHER_RX_STATSTOTAL_BYTES_DELTA_MAX = "etherRxStatstotalBytesDeltaMax"
    PROP_ID_ETHER_RX_STATSTOTAL_BYTES_DELTA_MIN = "etherRxStatstotalBytesDeltaMin"
    PROP_ID_ETHER_RX_STATSTOTAL_PACKETS_DELTA = "etherRxStatstotalPacketsDelta"
    PROP_ID_ETHER_RX_STATSTOTAL_PACKETS_DELTA_AVG = "etherRxStatstotalPacketsDeltaAvg"
    PROP_ID_ETHER_RX_STATSTOTAL_PACKETS_DELTA_MAX = "etherRxStatstotalPacketsDeltaMax"
    PROP_ID_ETHER_RX_STATSTOTAL_PACKETS_DELTA_MIN = "etherRxStatstotalPacketsDeltaMin"
    PROP_ID_ETHER_RX_STATSUNICAST_PACKETS_DELTA = "etherRxStatsunicastPacketsDelta"
    PROP_ID_ETHER_RX_STATSUNICAST_PACKETS_DELTA_AVG = "etherRxStatsunicastPacketsDeltaAvg"
    PROP_ID_ETHER_RX_STATSUNICAST_PACKETS_DELTA_MAX = "etherRxStatsunicastPacketsDeltaMax"
    PROP_ID_ETHER_RX_STATSUNICAST_PACKETS_DELTA_MIN = "etherRxStatsunicastPacketsDeltaMin"
    PROP_ID_ETHER_TX_STATSBROADCAST_PACKETS_DELTA = "etherTxStatsbroadcastPacketsDelta"
    PROP_ID_ETHER_TX_STATSBROADCAST_PACKETS_DELTA_AVG = "etherTxStatsbroadcastPacketsDeltaAvg"
    PROP_ID_ETHER_TX_STATSBROADCAST_PACKETS_DELTA_MAX = "etherTxStatsbroadcastPacketsDeltaMax"
    PROP_ID_ETHER_TX_STATSBROADCAST_PACKETS_DELTA_MIN = "etherTxStatsbroadcastPacketsDeltaMin"
    PROP_ID_ETHER_TX_STATSJUMBO_PACKETS_DELTA = "etherTxStatsjumboPacketsDelta"
    PROP_ID_ETHER_TX_STATSJUMBO_PACKETS_DELTA_AVG = "etherTxStatsjumboPacketsDeltaAvg"
    PROP_ID_ETHER_TX_STATSJUMBO_PACKETS_DELTA_MAX = "etherTxStatsjumboPacketsDeltaMax"
    PROP_ID_ETHER_TX_STATSJUMBO_PACKETS_DELTA_MIN = "etherTxStatsjumboPacketsDeltaMin"
    PROP_ID_ETHER_TX_STATSMULTICAST_PACKETS_DELTA = "etherTxStatsmulticastPacketsDelta"
    PROP_ID_ETHER_TX_STATSMULTICAST_PACKETS_DELTA_AVG = "etherTxStatsmulticastPacketsDeltaAvg"
    PROP_ID_ETHER_TX_STATSMULTICAST_PACKETS_DELTA_MAX = "etherTxStatsmulticastPacketsDeltaMax"
    PROP_ID_ETHER_TX_STATSMULTICAST_PACKETS_DELTA_MIN = "etherTxStatsmulticastPacketsDeltaMin"
    PROP_ID_ETHER_TX_STATSTOTAL_BYTES_DELTA = "etherTxStatstotalBytesDelta"
    PROP_ID_ETHER_TX_STATSTOTAL_BYTES_DELTA_AVG = "etherTxStatstotalBytesDeltaAvg"
    PROP_ID_ETHER_TX_STATSTOTAL_BYTES_DELTA_MAX = "etherTxStatstotalBytesDeltaMax"
    PROP_ID_ETHER_TX_STATSTOTAL_BYTES_DELTA_MIN = "etherTxStatstotalBytesDeltaMin"
    PROP_ID_ETHER_TX_STATSTOTAL_PACKETS_DELTA = "etherTxStatstotalPacketsDelta"
    PROP_ID_ETHER_TX_STATSTOTAL_PACKETS_DELTA_AVG = "etherTxStatstotalPacketsDeltaAvg"
    PROP_ID_ETHER_TX_STATSTOTAL_PACKETS_DELTA_MAX = "etherTxStatstotalPacketsDeltaMax"
    PROP_ID_ETHER_TX_STATSTOTAL_PACKETS_DELTA_MIN = "etherTxStatstotalPacketsDeltaMin"
    PROP_ID_ETHER_TX_STATSUNICAST_PACKETS_DELTA = "etherTxStatsunicastPacketsDelta"
    PROP_ID_ETHER_TX_STATSUNICAST_PACKETS_DELTA_AVG = "etherTxStatsunicastPacketsDeltaAvg"
    PROP_ID_ETHER_TX_STATSUNICAST_PACKETS_DELTA_MAX = "etherTxStatsunicastPacketsDeltaMax"
    PROP_ID_ETHER_TX_STATSUNICAST_PACKETS_DELTA_MIN = "etherTxStatsunicastPacketsDeltaMin"
    PROP_ID_FC_ERR_STATSCRC_RX_DELTA = "fcErrStatscrcRxDelta"
    PROP_ID_FC_ERR_STATSCRC_RX_DELTA_AVG = "fcErrStatscrcRxDeltaAvg"
    PROP_ID_FC_ERR_STATSCRC_RX_DELTA_MAX = "fcErrStatscrcRxDeltaMax"
    PROP_ID_FC_ERR_STATSCRC_RX_DELTA_MIN = "fcErrStatscrcRxDeltaMin"
    PROP_ID_FC_ERR_STATSDISCARD_RX_DELTA = "fcErrStatsdiscardRxDelta"
    PROP_ID_FC_ERR_STATSDISCARD_RX_DELTA_AVG = "fcErrStatsdiscardRxDeltaAvg"
    PROP_ID_FC_ERR_STATSDISCARD_RX_DELTA_MAX = "fcErrStatsdiscardRxDeltaMax"
    PROP_ID_FC_ERR_STATSDISCARD_RX_DELTA_MIN = "fcErrStatsdiscardRxDeltaMin"
    PROP_ID_FC_ERR_STATSDISCARD_TX_DELTA = "fcErrStatsdiscardTxDelta"
    PROP_ID_FC_ERR_STATSDISCARD_TX_DELTA_AVG = "fcErrStatsdiscardTxDeltaAvg"
    PROP_ID_FC_ERR_STATSDISCARD_TX_DELTA_MAX = "fcErrStatsdiscardTxDeltaMax"
    PROP_ID_FC_ERR_STATSDISCARD_TX_DELTA_MIN = "fcErrStatsdiscardTxDeltaMin"
    PROP_ID_FC_ERR_STATSLINK_FAILURES_DELTA = "fcErrStatslinkFailuresDelta"
    PROP_ID_FC_ERR_STATSLINK_FAILURES_DELTA_AVG = "fcErrStatslinkFailuresDeltaAvg"
    PROP_ID_FC_ERR_STATSLINK_FAILURES_DELTA_MAX = "fcErrStatslinkFailuresDeltaMax"
    PROP_ID_FC_ERR_STATSLINK_FAILURES_DELTA_MIN = "fcErrStatslinkFailuresDeltaMin"
    PROP_ID_FC_ERR_STATSRX_DELTA = "fcErrStatsrxDelta"
    PROP_ID_FC_ERR_STATSRX_DELTA_AVG = "fcErrStatsrxDeltaAvg"
    PROP_ID_FC_ERR_STATSRX_DELTA_MAX = "fcErrStatsrxDeltaMax"
    PROP_ID_FC_ERR_STATSRX_DELTA_MIN = "fcErrStatsrxDeltaMin"
    PROP_ID_FC_ERR_STATSSIGNAL_LOSSES_DELTA = "fcErrStatssignalLossesDelta"
    PROP_ID_FC_ERR_STATSSIGNAL_LOSSES_DELTA_AVG = "fcErrStatssignalLossesDeltaAvg"
    PROP_ID_FC_ERR_STATSSIGNAL_LOSSES_DELTA_MAX = "fcErrStatssignalLossesDeltaMax"
    PROP_ID_FC_ERR_STATSSIGNAL_LOSSES_DELTA_MIN = "fcErrStatssignalLossesDeltaMin"
    PROP_ID_FC_ERR_STATSSYNC_LOSSES_DELTA = "fcErrStatssyncLossesDelta"
    PROP_ID_FC_ERR_STATSSYNC_LOSSES_DELTA_AVG = "fcErrStatssyncLossesDeltaAvg"
    PROP_ID_FC_ERR_STATSSYNC_LOSSES_DELTA_MAX = "fcErrStatssyncLossesDeltaMax"
    PROP_ID_FC_ERR_STATSSYNC_LOSSES_DELTA_MIN = "fcErrStatssyncLossesDeltaMin"
    PROP_ID_FC_ERR_STATSTOO_LONG_RX_DELTA = "fcErrStatstooLongRxDelta"
    PROP_ID_FC_ERR_STATSTOO_LONG_RX_DELTA_AVG = "fcErrStatstooLongRxDeltaAvg"
    PROP_ID_FC_ERR_STATSTOO_LONG_RX_DELTA_MAX = "fcErrStatstooLongRxDeltaMax"
    PROP_ID_FC_ERR_STATSTOO_LONG_RX_DELTA_MIN = "fcErrStatstooLongRxDeltaMin"
    PROP_ID_FC_ERR_STATSTOO_SHORT_RX_DELTA = "fcErrStatstooShortRxDelta"
    PROP_ID_FC_ERR_STATSTOO_SHORT_RX_DELTA_AVG = "fcErrStatstooShortRxDeltaAvg"
    PROP_ID_FC_ERR_STATSTOO_SHORT_RX_DELTA_MAX = "fcErrStatstooShortRxDeltaMax"
    PROP_ID_FC_ERR_STATSTOO_SHORT_RX_DELTA_MIN = "fcErrStatstooShortRxDeltaMin"
    PROP_ID_FC_ERR_STATSTX_DELTA = "fcErrStatstxDelta"
    PROP_ID_FC_ERR_STATSTX_DELTA_AVG = "fcErrStatstxDeltaAvg"
    PROP_ID_FC_ERR_STATSTX_DELTA_MAX = "fcErrStatstxDeltaMax"
    PROP_ID_FC_ERR_STATSTX_DELTA_MIN = "fcErrStatstxDeltaMin"
    PROP_ID_FC_STATSBYTES_RX_DELTA = "fcStatsbytesRxDelta"
    PROP_ID_FC_STATSBYTES_RX_DELTA_AVG = "fcStatsbytesRxDeltaAvg"
    PROP_ID_FC_STATSBYTES_RX_DELTA_MAX = "fcStatsbytesRxDeltaMax"
    PROP_ID_FC_STATSBYTES_RX_DELTA_MIN = "fcStatsbytesRxDeltaMin"
    PROP_ID_FC_STATSBYTES_TX_DELTA = "fcStatsbytesTxDelta"
    PROP_ID_FC_STATSBYTES_TX_DELTA_AVG = "fcStatsbytesTxDeltaAvg"
    PROP_ID_FC_STATSBYTES_TX_DELTA_MAX = "fcStatsbytesTxDeltaMax"
    PROP_ID_FC_STATSBYTES_TX_DELTA_MIN = "fcStatsbytesTxDeltaMin"
    PROP_ID_FC_STATSPACKETS_RX_DELTA = "fcStatspacketsRxDelta"
    PROP_ID_FC_STATSPACKETS_RX_DELTA_AVG = "fcStatspacketsRxDeltaAvg"
    PROP_ID_FC_STATSPACKETS_RX_DELTA_MAX = "fcStatspacketsRxDeltaMax"
    PROP_ID_FC_STATSPACKETS_RX_DELTA_MIN = "fcStatspacketsRxDeltaMin"
    PROP_ID_FC_STATSPACKETS_TX_DELTA = "fcStatspacketsTxDelta"
    PROP_ID_FC_STATSPACKETS_TX_DELTA_AVG = "fcStatspacketsTxDeltaAvg"
    PROP_ID_FC_STATSPACKETS_TX_DELTA_MAX = "fcStatspacketsTxDeltaMax"
    PROP_ID_FC_STATSPACKETS_TX_DELTA_MIN = "fcStatspacketsTxDeltaMin"
    PROP_ID_MEMORY_ARRAY_ENV_STATSINPUT_CURRENT = "memoryArrayEnvStatsinputCurrent"
    PROP_ID_MEMORY_ARRAY_ENV_STATSINPUT_CURRENT_AVG = "memoryArrayEnvStatsinputCurrentAvg"
    PROP_ID_MEMORY_ARRAY_ENV_STATSINPUT_CURRENT_MAX = "memoryArrayEnvStatsinputCurrentMax"
    PROP_ID_MEMORY_ARRAY_ENV_STATSINPUT_CURRENT_MIN = "memoryArrayEnvStatsinputCurrentMin"
    PROP_ID_MEMORY_BUFFER_UNIT_ENV_STATSTEMPERATURE = "memoryBufferUnitEnvStatstemperature"
    PROP_ID_MEMORY_BUFFER_UNIT_ENV_STATSTEMPERATURE_AVG = "memoryBufferUnitEnvStatstemperatureAvg"
    PROP_ID_MEMORY_BUFFER_UNIT_ENV_STATSTEMPERATURE_MAX = "memoryBufferUnitEnvStatstemperatureMax"
    PROP_ID_MEMORY_BUFFER_UNIT_ENV_STATSTEMPERATURE_MIN = "memoryBufferUnitEnvStatstemperatureMin"
    PROP_ID_MEMORY_ERROR_STATSADDRESS_PARITY_ERRORS = "memoryErrorStatsaddressParityErrors"
    PROP_ID_MEMORY_ERROR_STATSECC_MULTIBIT_ERRORS = "memoryErrorStatseccMultibitErrors"
    PROP_ID_MEMORY_ERROR_STATSECC_SINGLEBIT_ERRORS = "memoryErrorStatseccSinglebitErrors"
    PROP_ID_MEMORY_ERROR_STATSMISMATCH_ERRORS = "memoryErrorStatsmismatchErrors"
    PROP_ID_MEMORY_RUNTIMEAVAILABLE = "memoryRuntimeavailable"
    PROP_ID_MEMORY_RUNTIMEAVAILABLE_AVG = "memoryRuntimeavailableAvg"
    PROP_ID_MEMORY_RUNTIMEAVAILABLE_MAX = "memoryRuntimeavailableMax"
    PROP_ID_MEMORY_RUNTIMEAVAILABLE_MIN = "memoryRuntimeavailableMin"
    PROP_ID_MEMORY_RUNTIMECACHED = "memoryRuntimecached"
    PROP_ID_MEMORY_RUNTIMECACHED_AVG = "memoryRuntimecachedAvg"
    PROP_ID_MEMORY_RUNTIMECACHED_MAX = "memoryRuntimecachedMax"
    PROP_ID_MEMORY_RUNTIMECACHED_MIN = "memoryRuntimecachedMin"
    PROP_ID_MEMORY_RUNTIMETOTAL = "memoryRuntimetotal"
    PROP_ID_MEMORY_RUNTIMETOTAL_AVG = "memoryRuntimetotalAvg"
    PROP_ID_MEMORY_RUNTIMETOTAL_MAX = "memoryRuntimetotalMax"
    PROP_ID_MEMORY_RUNTIMETOTAL_MIN = "memoryRuntimetotalMin"
    PROP_ID_MEMORY_UNIT_ENV_STATSTEMPERATURE = "memoryUnitEnvStatstemperature"
    PROP_ID_MEMORY_UNIT_ENV_STATSTEMPERATURE_AVG = "memoryUnitEnvStatstemperatureAvg"
    PROP_ID_MEMORY_UNIT_ENV_STATSTEMPERATURE_MAX = "memoryUnitEnvStatstemperatureMax"
    PROP_ID_MEMORY_UNIT_ENV_STATSTEMPERATURE_MIN = "memoryUnitEnvStatstemperatureMin"
    PROP_ID_POWER_GROUP_STATSPOWER = "powerGroupStatspower"
    PROP_ID_POWER_GROUP_STATSPOWER_AVG = "powerGroupStatspowerAvg"
    PROP_ID_POWER_GROUP_STATSPOWER_MAX = "powerGroupStatspowerMax"
    PROP_ID_POWER_GROUP_STATSPOWER_MIN = "powerGroupStatspowerMin"
    PROP_ID_PROCESSOR_ENV_STATSINPUT_CURRENT = "processorEnvStatsinputCurrent"
    PROP_ID_PROCESSOR_ENV_STATSINPUT_CURRENT_AVG = "processorEnvStatsinputCurrentAvg"
    PROP_ID_PROCESSOR_ENV_STATSINPUT_CURRENT_MAX = "processorEnvStatsinputCurrentMax"
    PROP_ID_PROCESSOR_ENV_STATSINPUT_CURRENT_MIN = "processorEnvStatsinputCurrentMin"
    PROP_ID_PROCESSOR_ENV_STATSTEMPERATURE = "processorEnvStatstemperature"
    PROP_ID_PROCESSOR_ENV_STATSTEMPERATURE_AVG = "processorEnvStatstemperatureAvg"
    PROP_ID_PROCESSOR_ENV_STATSTEMPERATURE_MAX = "processorEnvStatstemperatureMax"
    PROP_ID_PROCESSOR_ENV_STATSTEMPERATURE_MIN = "processorEnvStatstemperatureMin"
    PROP_ID_PROCESSOR_ERROR_STATSMIRRORING_INTER_SOCK_ERRORS = "processorErrorStatsmirroringInterSockErrors"
    PROP_ID_PROCESSOR_ERROR_STATSMIRRORING_INTRA_SOCK_ERRORS = "processorErrorStatsmirroringIntraSockErrors"
    PROP_ID_PROCESSOR_ERROR_STATSSMI_LINK_CORR_ERRORS = "processorErrorStatssmiLinkCorrErrors"
    PROP_ID_PROCESSOR_ERROR_STATSSMI_LINK_UNCORR_ERRORS = "processorErrorStatssmiLinkUncorrErrors"
    PROP_ID_PROCESSOR_ERROR_STATSSPARING_ERRORS = "processorErrorStatssparingErrors"
    PROP_ID_PROCESSOR_RUNTIMELOAD = "processorRuntimeload"
    PROP_ID_PROCESSOR_RUNTIMELOAD_AVG = "processorRuntimeloadAvg"
    PROP_ID_PROCESSOR_RUNTIMELOAD_MAX = "processorRuntimeloadMax"
    PROP_ID_PROCESSOR_RUNTIMELOAD_MIN = "processorRuntimeloadMin"
    PROP_ID_STORAGE_DISK_ENV_STATSTEMPERATURE = "storageDiskEnvStatstemperature"
    PROP_ID_STORAGE_DISK_ENV_STATSTEMPERATURE_AVG = "storageDiskEnvStatstemperatureAvg"
    PROP_ID_STORAGE_DISK_ENV_STATSTEMPERATURE_MAX = "storageDiskEnvStatstemperatureMax"
    PROP_ID_STORAGE_DISK_ENV_STATSTEMPERATURE_MIN = "storageDiskEnvStatstemperatureMin"
    PROP_ID_STORAGE_DISK_ENV_STATSWEAR_PERCENTAGE = "storageDiskEnvStatswearPercentage"
    PROP_ID_STORAGE_DISK_ENV_STATSWEAR_PERCENTAGE_AVG = "storageDiskEnvStatswearPercentageAvg"
    PROP_ID_STORAGE_DISK_ENV_STATSWEAR_PERCENTAGE_MAX = "storageDiskEnvStatswearPercentageMax"
    PROP_ID_STORAGE_DISK_ENV_STATSWEAR_PERCENTAGE_MIN = "storageDiskEnvStatswearPercentageMin"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSLEFT_INLET_TEMP = "storageHddMotherBoardTempStatsleftInletTemp"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSLEFT_INLET_TEMP_AVG = "storageHddMotherBoardTempStatsleftInletTempAvg"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSLEFT_INLET_TEMP_MAX = "storageHddMotherBoardTempStatsleftInletTempMax"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSLEFT_INLET_TEMP_MIN = "storageHddMotherBoardTempStatsleftInletTempMin"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSLEFT_OUTLET_TEMP = "storageHddMotherBoardTempStatsleftOutletTemp"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSLEFT_OUTLET_TEMP_AVG = "storageHddMotherBoardTempStatsleftOutletTempAvg"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSLEFT_OUTLET_TEMP_MAX = "storageHddMotherBoardTempStatsleftOutletTempMax"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSLEFT_OUTLET_TEMP_MIN = "storageHddMotherBoardTempStatsleftOutletTempMin"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSRIGHT_INLET_TEMP = "storageHddMotherBoardTempStatsrightInletTemp"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSRIGHT_INLET_TEMP_AVG = "storageHddMotherBoardTempStatsrightInletTempAvg"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSRIGHT_INLET_TEMP_MAX = "storageHddMotherBoardTempStatsrightInletTempMax"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSRIGHT_INLET_TEMP_MIN = "storageHddMotherBoardTempStatsrightInletTempMin"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSRIGHT_OUTLET_TEMP = "storageHddMotherBoardTempStatsrightOutletTemp"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSRIGHT_OUTLET_TEMP_AVG = "storageHddMotherBoardTempStatsrightOutletTempAvg"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSRIGHT_OUTLET_TEMP_MAX = "storageHddMotherBoardTempStatsrightOutletTempMax"
    PROP_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATSRIGHT_OUTLET_TEMP_MIN = "storageHddMotherBoardTempStatsrightOutletTempMin"
    PROP_ID_STORAGE_NVME_STATSDRIVE_LIFE_USED_PERCENTAGE = "storageNvmeStatsdriveLifeUsedPercentage"
    PROP_ID_STORAGE_NVME_STATSDRIVE_LIFE_USED_PERCENTAGE_AVG = "storageNvmeStatsdriveLifeUsedPercentageAvg"
    PROP_ID_STORAGE_NVME_STATSDRIVE_LIFE_USED_PERCENTAGE_MAX = "storageNvmeStatsdriveLifeUsedPercentageMax"
    PROP_ID_STORAGE_NVME_STATSDRIVE_LIFE_USED_PERCENTAGE_MIN = "storageNvmeStatsdriveLifeUsedPercentageMin"
    PROP_ID_STORAGE_NVME_STATSTEMPERATURE = "storageNvmeStatstemperature"
    PROP_ID_STORAGE_NVME_STATSTEMPERATURE_AVG = "storageNvmeStatstemperatureAvg"
    PROP_ID_STORAGE_NVME_STATSTEMPERATURE_MAX = "storageNvmeStatstemperatureMax"
    PROP_ID_STORAGE_NVME_STATSTEMPERATURE_MIN = "storageNvmeStatstemperatureMin"
    PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET1 = "swCardEnvStatsSlotOutlet1"
    PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET1_AVG = "swCardEnvStatsSlotOutlet1Avg"
    PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET1_MAX = "swCardEnvStatsSlotOutlet1Max"
    PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET1_MIN = "swCardEnvStatsSlotOutlet1Min"
    PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET2 = "swCardEnvStatsSlotOutlet2"
    PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET2_AVG = "swCardEnvStatsSlotOutlet2Avg"
    PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET2_MAX = "swCardEnvStatsSlotOutlet2Max"
    PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET2_MIN = "swCardEnvStatsSlotOutlet2Min"
    PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET3 = "swCardEnvStatsSlotOutlet3"
    PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET3_AVG = "swCardEnvStatsSlotOutlet3Avg"
    PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET3_MAX = "swCardEnvStatsSlotOutlet3Max"
    PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET3_MIN = "swCardEnvStatsSlotOutlet3Min"
    PROP_ID_SW_ENV_STATSDONNER = "swEnvStatsdonner"
    PROP_ID_SW_ENV_STATSDONNER_AVG = "swEnvStatsdonnerAvg"
    PROP_ID_SW_ENV_STATSDONNER_MAX = "swEnvStatsdonnerMax"
    PROP_ID_SW_ENV_STATSDONNER_MIN = "swEnvStatsdonnerMin"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET1 = "swEnvStatsfanCtrlrInlet1"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET1_AVG = "swEnvStatsfanCtrlrInlet1Avg"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET1_MAX = "swEnvStatsfanCtrlrInlet1Max"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET1_MIN = "swEnvStatsfanCtrlrInlet1Min"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET2 = "swEnvStatsfanCtrlrInlet2"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET2_AVG = "swEnvStatsfanCtrlrInlet2Avg"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET2_MAX = "swEnvStatsfanCtrlrInlet2Max"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET2_MIN = "swEnvStatsfanCtrlrInlet2Min"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET3 = "swEnvStatsfanCtrlrInlet3"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET3_AVG = "swEnvStatsfanCtrlrInlet3Avg"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET3_MAX = "swEnvStatsfanCtrlrInlet3Max"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET3_MIN = "swEnvStatsfanCtrlrInlet3Min"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET4 = "swEnvStatsfanCtrlrInlet4"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET4_AVG = "swEnvStatsfanCtrlrInlet4Avg"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET4_MAX = "swEnvStatsfanCtrlrInlet4Max"
    PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET4_MIN = "swEnvStatsfanCtrlrInlet4Min"
    PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET1 = "swEnvStatsmainBoardOutlet1"
    PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET1_AVG = "swEnvStatsmainBoardOutlet1Avg"
    PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET1_MAX = "swEnvStatsmainBoardOutlet1Max"
    PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET1_MIN = "swEnvStatsmainBoardOutlet1Min"
    PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET2 = "swEnvStatsmainBoardOutlet2"
    PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET2_AVG = "swEnvStatsmainBoardOutlet2Avg"
    PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET2_MAX = "swEnvStatsmainBoardOutlet2Max"
    PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET2_MIN = "swEnvStatsmainBoardOutlet2Min"
    PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET1 = "swEnvStatspsuCtrlrInlet1"
    PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET1_AVG = "swEnvStatspsuCtrlrInlet1Avg"
    PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET1_MAX = "swEnvStatspsuCtrlrInlet1Max"
    PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET1_MIN = "swEnvStatspsuCtrlrInlet1Min"
    PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET2 = "swEnvStatspsuCtrlrInlet2"
    PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET2_AVG = "swEnvStatspsuCtrlrInlet2Avg"
    PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET2_MAX = "swEnvStatspsuCtrlrInlet2Max"
    PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET2_MIN = "swEnvStatspsuCtrlrInlet2Min"
    PROP_ID_SW_ENV_STATSTD2 = "swEnvStatstd2"
    PROP_ID_SW_ENV_STATSTD2_AVG = "swEnvStatstd2Avg"
    PROP_ID_SW_ENV_STATSTD2_MAX = "swEnvStatstd2Max"
    PROP_ID_SW_ENV_STATSTD2_MIN = "swEnvStatstd2Min"
    PROP_ID_SW_ENV_STATSTIBURON = "swEnvStatstiburon"
    PROP_ID_SW_ENV_STATSTIBURON_AVG = "swEnvStatstiburonAvg"
    PROP_ID_SW_ENV_STATSTIBURON_MAX = "swEnvStatstiburonMax"
    PROP_ID_SW_ENV_STATSTIBURON_MIN = "swEnvStatstiburonMin"
    PROP_ID_SW_SYSTEM_STATS_CORRECTABLE_PARITY_ERROR = "swSystemStatsCorrectableParityError"
    PROP_ID_SW_SYSTEM_STATS_CORRECTABLE_PARITY_ERROR_AVG = "swSystemStatsCorrectableParityErrorAvg"
    PROP_ID_SW_SYSTEM_STATS_CORRECTABLE_PARITY_ERROR_MAX = "swSystemStatsCorrectableParityErrorMax"
    PROP_ID_SW_SYSTEM_STATS_CORRECTABLE_PARITY_ERROR_MIN = "swSystemStatsCorrectableParityErrorMin"
    PROP_ID_SW_SYSTEM_STATSKERNEL_MEM_FREE = "swSystemStatskernelMemFree"
    PROP_ID_SW_SYSTEM_STATSKERNEL_MEM_FREE_AVG = "swSystemStatskernelMemFreeAvg"
    PROP_ID_SW_SYSTEM_STATSKERNEL_MEM_FREE_MAX = "swSystemStatskernelMemFreeMax"
    PROP_ID_SW_SYSTEM_STATSKERNEL_MEM_FREE_MIN = "swSystemStatskernelMemFreeMin"
    PROP_ID_SW_SYSTEM_STATSKERNEL_MEM_TOTAL = "swSystemStatskernelMemTotal"
    PROP_ID_SW_SYSTEM_STATSKERNEL_MEM_TOTAL_AVG = "swSystemStatskernelMemTotalAvg"
    PROP_ID_SW_SYSTEM_STATSKERNEL_MEM_TOTAL_MAX = "swSystemStatskernelMemTotalMax"
    PROP_ID_SW_SYSTEM_STATSKERNEL_MEM_TOTAL_MIN = "swSystemStatskernelMemTotalMin"
    PROP_ID_SW_SYSTEM_STATSLOAD = "swSystemStatsload"
    PROP_ID_SW_SYSTEM_STATSLOAD_AVG = "swSystemStatsloadAvg"
    PROP_ID_SW_SYSTEM_STATSLOAD_MAX = "swSystemStatsloadMax"
    PROP_ID_SW_SYSTEM_STATSLOAD_MIN = "swSystemStatsloadMin"
    PROP_ID_SW_SYSTEM_STATSMEM_AVAILABLE = "swSystemStatsmemAvailable"
    PROP_ID_SW_SYSTEM_STATSMEM_AVAILABLE_AVG = "swSystemStatsmemAvailableAvg"
    PROP_ID_SW_SYSTEM_STATSMEM_AVAILABLE_MAX = "swSystemStatsmemAvailableMax"
    PROP_ID_SW_SYSTEM_STATSMEM_AVAILABLE_MIN = "swSystemStatsmemAvailableMin"
    PROP_ID_SW_SYSTEM_STATSMEM_CACHED = "swSystemStatsmemCached"
    PROP_ID_SW_SYSTEM_STATSMEM_CACHED_AVG = "swSystemStatsmemCachedAvg"
    PROP_ID_SW_SYSTEM_STATSMEM_CACHED_MAX = "swSystemStatsmemCachedMax"
    PROP_ID_SW_SYSTEM_STATSMEM_CACHED_MIN = "swSystemStatsmemCachedMin"
    PROP_ID_UNSPECIFIED = "unspecified"
    PROP_TYPE_FLOAT = "float"
    PROP_TYPE_UINT32 = "uint32"
    PROP_TYPE_UINT64 = "uint64"


class StatsThr32Definition(ManagedObject):
    """This is StatsThr32Definition class."""

    consts = StatsThr32DefinitionConsts()
    naming_props = set([u'propId'])

    mo_meta = MoMeta("StatsThr32Definition", "statsThr32Definition", "[prop_id]", VersionMeta.Version101e, "InputOutput", 0x1fff, [], ["admin", "operations"], [u'statsThresholdClass'], [u'statsThr32Value', u'statsThr64Value', u'statsThrFloatValue'], ["Add", "Get", "Set"])

    prop_meta = {
        "auto_recovery": MoPropertyMeta("auto_recovery", "autoRecovery", "string", VersionMeta.Version224a, MoPropertyMeta.READ_WRITE, 0x2, None, None, None, ["disabled", "enabled"], []), 
        "auto_recovery_time": MoPropertyMeta("auto_recovery_time", "autoRecoveryTime", "ushort", VersionMeta.Version224a, MoPropertyMeta.READ_WRITE, 0x4, None, None, None, [], []), 
        "child_action": MoPropertyMeta("child_action", "childAction", "string", VersionMeta.Version101e, MoPropertyMeta.INTERNAL, 0x8, None, None, r"""((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], []), 
        "descr": MoPropertyMeta("descr", "descr", "string", VersionMeta.Version101e, MoPropertyMeta.READ_WRITE, 0x10, None, None, r"""[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], []), 
        "dn": MoPropertyMeta("dn", "dn", "string", VersionMeta.Version101e, MoPropertyMeta.READ_ONLY, 0x20, 0, 256, None, [], []), 
        "error_disable_fi_port": MoPropertyMeta("error_disable_fi_port", "errorDisableFiPort", "string", VersionMeta.Version224a, MoPropertyMeta.READ_WRITE, 0x40, None, None, None, ["false", "no", "true", "yes"], []), 
        "int_id": MoPropertyMeta("int_id", "intId", "string", VersionMeta.Version101e, MoPropertyMeta.INTERNAL, None, None, None, None, ["none"], ["0-4294967295"]), 
        "name": MoPropertyMeta("name", "name", "string", VersionMeta.Version101e, MoPropertyMeta.READ_WRITE, 0x80, None, None, r"""[\-\.:_a-zA-Z0-9]{0,16}""", [], []), 
        "normal_value": MoPropertyMeta("normal_value", "normalValue", "uint", VersionMeta.Version101e, MoPropertyMeta.READ_WRITE, 0x100, None, None, None, [], []), 
        "policy_level": MoPropertyMeta("policy_level", "policyLevel", "uint", VersionMeta.Version211a, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "policy_owner": MoPropertyMeta("policy_owner", "policyOwner", "string", VersionMeta.Version211a, MoPropertyMeta.READ_WRITE, 0x200, None, None, None, ["local", "pending-policy", "policy"], []), 
        "prop_id": MoPropertyMeta("prop_id", "propId", "string", VersionMeta.Version101e, MoPropertyMeta.NAMING, 0x400, None, None, None, ["adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216Delta", "adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216DeltaAvg", "adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216DeltaMax", "adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216DeltaMin", "adaptorEthPortBySizeLargeStatslessThan2048Delta", "adaptorEthPortBySizeLargeStatslessThan2048DeltaAvg", "adaptorEthPortBySizeLargeStatslessThan2048DeltaMax", "adaptorEthPortBySizeLargeStatslessThan2048DeltaMin", "adaptorEthPortBySizeLargeStatslessThan4096Delta", "adaptorEthPortBySizeLargeStatslessThan4096DeltaAvg", "adaptorEthPortBySizeLargeStatslessThan4096DeltaMax", "adaptorEthPortBySizeLargeStatslessThan4096DeltaMin", "adaptorEthPortBySizeLargeStatslessThan8192Delta", "adaptorEthPortBySizeLargeStatslessThan8192DeltaAvg", "adaptorEthPortBySizeLargeStatslessThan8192DeltaMax", "adaptorEthPortBySizeLargeStatslessThan8192DeltaMin", "adaptorEthPortBySizeLargeStatslessThan9216Delta", "adaptorEthPortBySizeLargeStatslessThan9216DeltaAvg", "adaptorEthPortBySizeLargeStatslessThan9216DeltaMax", "adaptorEthPortBySizeLargeStatslessThan9216DeltaMin", "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518Delta", "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518DeltaAvg", "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518DeltaMax", "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518DeltaMin", "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518Delta", "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518DeltaAvg", "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518DeltaMax", "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518DeltaMin", "adaptorEthPortBySizeSmallStatsequals64Delta", "adaptorEthPortBySizeSmallStatsequals64DeltaAvg", "adaptorEthPortBySizeSmallStatsequals64DeltaMax", "adaptorEthPortBySizeSmallStatsequals64DeltaMin", "adaptorEthPortBySizeSmallStatslessThan1024Delta", "adaptorEthPortBySizeSmallStatslessThan1024DeltaAvg", "adaptorEthPortBySizeSmallStatslessThan1024DeltaMax", "adaptorEthPortBySizeSmallStatslessThan1024DeltaMin", "adaptorEthPortBySizeSmallStatslessThan128Delta", "adaptorEthPortBySizeSmallStatslessThan128DeltaAvg", "adaptorEthPortBySizeSmallStatslessThan128DeltaMax", "adaptorEthPortBySizeSmallStatslessThan128DeltaMin", "adaptorEthPortBySizeSmallStatslessThan256Delta", "adaptorEthPortBySizeSmallStatslessThan256DeltaAvg", "adaptorEthPortBySizeSmallStatslessThan256DeltaMax", "adaptorEthPortBySizeSmallStatslessThan256DeltaMin", "adaptorEthPortBySizeSmallStatslessThan512Delta", "adaptorEthPortBySizeSmallStatslessThan512DeltaAvg", "adaptorEthPortBySizeSmallStatslessThan512DeltaMax", "adaptorEthPortBySizeSmallStatslessThan512DeltaMin", "adaptorEthPortBySizeSmallStatslessThan64Delta", "adaptorEthPortBySizeSmallStatslessThan64DeltaAvg", "adaptorEthPortBySizeSmallStatslessThan64DeltaMax", "adaptorEthPortBySizeSmallStatslessThan64DeltaMin", "adaptorEthPortErrStatsbadCrcPacketsDelta", "adaptorEthPortErrStatsbadCrcPacketsDeltaAvg", "adaptorEthPortErrStatsbadCrcPacketsDeltaMax", "adaptorEthPortErrStatsbadCrcPacketsDeltaMin", "adaptorEthPortErrStatsbadLengthPacketsDelta", "adaptorEthPortErrStatsbadLengthPacketsDeltaAvg", "adaptorEthPortErrStatsbadLengthPacketsDeltaMax", "adaptorEthPortErrStatsbadLengthPacketsDeltaMin", "adaptorEthPortErrStatsmacDiscardedPacketsDelta", "adaptorEthPortErrStatsmacDiscardedPacketsDeltaAvg", "adaptorEthPortErrStatsmacDiscardedPacketsDeltaMax", "adaptorEthPortErrStatsmacDiscardedPacketsDeltaMin", "adaptorEthPortMcastStatsbroadcastPacketsDelta", "adaptorEthPortMcastStatsbroadcastPacketsDeltaAvg", "adaptorEthPortMcastStatsbroadcastPacketsDeltaMax", "adaptorEthPortMcastStatsbroadcastPacketsDeltaMin", "adaptorEthPortMcastStatsmulticastPacketsDelta", "adaptorEthPortMcastStatsmulticastPacketsDeltaAvg", "adaptorEthPortMcastStatsmulticastPacketsDeltaMax", "adaptorEthPortMcastStatsmulticastPacketsDeltaMin", "adaptorEthPortMcastStatsunicastPacketsDelta", "adaptorEthPortMcastStatsunicastPacketsDeltaAvg", "adaptorEthPortMcastStatsunicastPacketsDeltaMax", "adaptorEthPortMcastStatsunicastPacketsDeltaMin", "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDelta", "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDeltaAvg", "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDeltaMax", "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDeltaMin", "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDelta", "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDeltaAvg", "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDeltaMax", "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDeltaMin", "adaptorEthPortOutsizedStatsoversizedPacketsDelta", "adaptorEthPortOutsizedStatsoversizedPacketsDeltaAvg", "adaptorEthPortOutsizedStatsoversizedPacketsDeltaMax", "adaptorEthPortOutsizedStatsoversizedPacketsDeltaMin", "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDelta", "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDeltaAvg", "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDeltaMax", "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDeltaMin", "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDelta", "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDeltaAvg", "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDeltaMax", "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDeltaMin", "adaptorEthPortStatsgoodPacketsDelta", "adaptorEthPortStatsgoodPacketsDeltaAvg", "adaptorEthPortStatsgoodPacketsDeltaMax", "adaptorEthPortStatsgoodPacketsDeltaMin", "adaptorEthPortStatspausePacketsDelta", "adaptorEthPortStatspausePacketsDeltaAvg", "adaptorEthPortStatspausePacketsDeltaMax", "adaptorEthPortStatspausePacketsDeltaMin", "adaptorEthPortStatsperPriorityPausePacketsDelta", "adaptorEthPortStatsperPriorityPausePacketsDeltaAvg", "adaptorEthPortStatsperPriorityPausePacketsDeltaMax", "adaptorEthPortStatsperPriorityPausePacketsDeltaMin", "adaptorEthPortStatspppPacketsDelta", "adaptorEthPortStatspppPacketsDeltaAvg", "adaptorEthPortStatspppPacketsDeltaMax", "adaptorEthPortStatspppPacketsDeltaMin", "adaptorEthPortStatstotalPacketsDelta", "adaptorEthPortStatstotalPacketsDeltaAvg", "adaptorEthPortStatstotalPacketsDeltaMax", "adaptorEthPortStatstotalPacketsDeltaMin", "adaptorEthPortStatsvlanPacketsDelta", "adaptorEthPortStatsvlanPacketsDeltaAvg", "adaptorEthPortStatsvlanPacketsDeltaMax", "adaptorEthPortStatsvlanPacketsDeltaMin", "adaptorEtherIfStatsrxBytesDelta", "adaptorEtherIfStatsrxBytesDeltaAvg", "adaptorEtherIfStatsrxBytesDeltaMax", "adaptorEtherIfStatsrxBytesDeltaMin", "adaptorEtherIfStatsrxDroppedDelta", "adaptorEtherIfStatsrxDroppedDeltaAvg", "adaptorEtherIfStatsrxDroppedDeltaMax", "adaptorEtherIfStatsrxDroppedDeltaMin", "adaptorEtherIfStatsrxErrorsDelta", "adaptorEtherIfStatsrxErrorsDeltaAvg", "adaptorEtherIfStatsrxErrorsDeltaMax", "adaptorEtherIfStatsrxErrorsDeltaMin", "adaptorEtherIfStatsrxPacketsDelta", "adaptorEtherIfStatsrxPacketsDeltaAvg", "adaptorEtherIfStatsrxPacketsDeltaMax", "adaptorEtherIfStatsrxPacketsDeltaMin", "adaptorEtherIfStatstxBytesDelta", "adaptorEtherIfStatstxBytesDeltaAvg", "adaptorEtherIfStatstxBytesDeltaMax", "adaptorEtherIfStatstxBytesDeltaMin", "adaptorEtherIfStatstxDroppedDelta", "adaptorEtherIfStatstxDroppedDeltaAvg", "adaptorEtherIfStatstxDroppedDeltaMax", "adaptorEtherIfStatstxDroppedDeltaMin", "adaptorEtherIfStatstxErrorsDelta", "adaptorEtherIfStatstxErrorsDeltaAvg", "adaptorEtherIfStatstxErrorsDeltaMax", "adaptorEtherIfStatstxErrorsDeltaMin", "adaptorEtherIfStatstxPacketsDelta", "adaptorEtherIfStatstxPacketsDeltaAvg", "adaptorEtherIfStatstxPacketsDeltaMax", "adaptorEtherIfStatstxPacketsDeltaMin", "adaptorFcIfEventStatsinvalidCRCCountDelta", "adaptorFcIfEventStatsinvalidCRCCountDeltaAvg", "adaptorFcIfEventStatsinvalidCRCCountDeltaMax", "adaptorFcIfEventStatsinvalidCRCCountDeltaMin", "adaptorFcIfEventStatslinkFailureCountDelta", "adaptorFcIfEventStatslinkFailureCountDeltaAvg", "adaptorFcIfEventStatslinkFailureCountDeltaMax", "adaptorFcIfEventStatslinkFailureCountDeltaMin", "adaptorFcIfEventStatslipCountDelta", "adaptorFcIfEventStatslipCountDeltaAvg", "adaptorFcIfEventStatslipCountDeltaMax", "adaptorFcIfEventStatslipCountDeltaMin", "adaptorFcIfEventStatslossOfSignalCountDelta", "adaptorFcIfEventStatslossOfSignalCountDeltaAvg", "adaptorFcIfEventStatslossOfSignalCountDeltaMax", "adaptorFcIfEventStatslossOfSignalCountDeltaMin", "adaptorFcIfEventStatslossOfSyncCountDelta", "adaptorFcIfEventStatslossOfSyncCountDeltaAvg", "adaptorFcIfEventStatslossOfSyncCountDeltaMax", "adaptorFcIfEventStatslossOfSyncCountDeltaMin", "adaptorFcIfEventStatsnOSCountDelta", "adaptorFcIfEventStatsnOSCountDeltaAvg", "adaptorFcIfEventStatsnOSCountDeltaMax", "adaptorFcIfEventStatsnOSCountDeltaMin", "adaptorFcIfEventStatssecondsSinceLastResetDelta", "adaptorFcIfEventStatssecondsSinceLastResetDeltaAvg", "adaptorFcIfEventStatssecondsSinceLastResetDeltaMax", "adaptorFcIfEventStatssecondsSinceLastResetDeltaMin", "adaptorFcIfEventStatsseqProtocolErrCountDelta", "adaptorFcIfEventStatsseqProtocolErrCountDeltaAvg", "adaptorFcIfEventStatsseqProtocolErrCountDeltaMax", "adaptorFcIfEventStatsseqProtocolErrCountDeltaMin", "adaptorFcIfFC4StatscontrolRequestsDelta", "adaptorFcIfFC4StatscontrolRequestsDeltaAvg", "adaptorFcIfFC4StatscontrolRequestsDeltaMax", "adaptorFcIfFC4StatscontrolRequestsDeltaMin", "adaptorFcIfFC4StatsinputMegabytesDelta", "adaptorFcIfFC4StatsinputMegabytesDeltaAvg", "adaptorFcIfFC4StatsinputMegabytesDeltaMax", "adaptorFcIfFC4StatsinputMegabytesDeltaMin", "adaptorFcIfFC4StatsinputRequestsDelta", "adaptorFcIfFC4StatsinputRequestsDeltaAvg", "adaptorFcIfFC4StatsinputRequestsDeltaMax", "adaptorFcIfFC4StatsinputRequestsDeltaMin", "adaptorFcIfFC4StatsoutputMegabytesDelta", "adaptorFcIfFC4StatsoutputMegabytesDeltaAvg", "adaptorFcIfFC4StatsoutputMegabytesDeltaMax", "adaptorFcIfFC4StatsoutputMegabytesDeltaMin", "adaptorFcIfFC4StatsoutputRequestsDelta", "adaptorFcIfFC4StatsoutputRequestsDeltaAvg", "adaptorFcIfFC4StatsoutputRequestsDeltaMax", "adaptorFcIfFC4StatsoutputRequestsDeltaMin", "adaptorFcIfFrameStatsdumpedFramesDelta", "adaptorFcIfFrameStatsdumpedFramesDeltaAvg", "adaptorFcIfFrameStatsdumpedFramesDeltaMax", "adaptorFcIfFrameStatsdumpedFramesDeltaMin", "adaptorFcIfFrameStatserrorFramesDelta", "adaptorFcIfFrameStatserrorFramesDeltaAvg", "adaptorFcIfFrameStatserrorFramesDeltaMax", "adaptorFcIfFrameStatserrorFramesDeltaMin", "adaptorFcIfFrameStatsrxFramesDelta", "adaptorFcIfFrameStatsrxFramesDeltaAvg", "adaptorFcIfFrameStatsrxFramesDeltaMax", "adaptorFcIfFrameStatsrxFramesDeltaMin", "adaptorFcIfFrameStatstxFramesDelta", "adaptorFcIfFrameStatstxFramesDeltaAvg", "adaptorFcIfFrameStatstxFramesDeltaMax", "adaptorFcIfFrameStatstxFramesDeltaMin", "adaptorFcPortStatsrxBadFramesDelta", "adaptorFcPortStatsrxBadFramesDeltaAvg", "adaptorFcPortStatsrxBadFramesDeltaMax", "adaptorFcPortStatsrxBadFramesDeltaMin", "adaptorFcPortStatsrxFramesDelta", "adaptorFcPortStatsrxFramesDeltaAvg", "adaptorFcPortStatsrxFramesDeltaMax", "adaptorFcPortStatsrxFramesDeltaMin", "adaptorFcPortStatstxBadFramesDelta", "adaptorFcPortStatstxBadFramesDeltaAvg", "adaptorFcPortStatstxBadFramesDeltaMax", "adaptorFcPortStatstxBadFramesDeltaMin", "adaptorFcPortStatstxFramesDelta", "adaptorFcPortStatstxFramesDeltaAvg", "adaptorFcPortStatstxFramesDeltaMax", "adaptorFcPortStatstxFramesDeltaMin", "adaptorMenloBaseErrorStatscorrectableErrorsDelta", "adaptorMenloBaseErrorStatscorrectableErrorsDeltaAvg", "adaptorMenloBaseErrorStatscorrectableErrorsDeltaMax", "adaptorMenloBaseErrorStatscorrectableErrorsDeltaMin", "adaptorMenloBaseErrorStatsuncorrectableErrorsDelta", "adaptorMenloBaseErrorStatsuncorrectableErrorsDeltaAvg", "adaptorMenloBaseErrorStatsuncorrectableErrorsDeltaMax", "adaptorMenloBaseErrorStatsuncorrectableErrorsDeltaMin", "adaptorMenloDcePortStatsrxPauseCFCDelta", "adaptorMenloDcePortStatsrxPauseCFCDeltaAvg", "adaptorMenloDcePortStatsrxPauseCFCDeltaMax", "adaptorMenloDcePortStatsrxPauseCFCDeltaMin", "adaptorMenloDcePortStatsrxPausePFCDelta", "adaptorMenloDcePortStatsrxPausePFCDeltaAvg", "adaptorMenloDcePortStatsrxPausePFCDeltaMax", "adaptorMenloDcePortStatsrxPausePFCDeltaMin", "adaptorMenloDcePortStatstxPauseCFCDelta", "adaptorMenloDcePortStatstxPauseCFCDeltaAvg", "adaptorMenloDcePortStatstxPauseCFCDeltaMax", "adaptorMenloDcePortStatstxPauseCFCDeltaMin", "adaptorMenloDcePortStatstxPausePFCDelta", "adaptorMenloDcePortStatstxPausePFCDeltaAvg", "adaptorMenloDcePortStatstxPausePFCDeltaMax", "adaptorMenloDcePortStatstxPausePFCDeltaMin", "adaptorMenloEthErrorStatscorrectableErrorsDelta", "adaptorMenloEthErrorStatscorrectableErrorsDeltaAvg", "adaptorMenloEthErrorStatscorrectableErrorsDeltaMax", "adaptorMenloEthErrorStatscorrectableErrorsDeltaMin", "adaptorMenloEthErrorStatsdropAclDelta", "adaptorMenloEthErrorStatsdropAclDeltaAvg", "adaptorMenloEthErrorStatsdropAclDeltaMax", "adaptorMenloEthErrorStatsdropAclDeltaMin", "adaptorMenloEthErrorStatspopErrorsDelta", "adaptorMenloEthErrorStatspopErrorsDeltaAvg", "adaptorMenloEthErrorStatspopErrorsDeltaMax", "adaptorMenloEthErrorStatspopErrorsDeltaMin", "adaptorMenloEthErrorStatspushErrorsDelta", "adaptorMenloEthErrorStatspushErrorsDeltaAvg", "adaptorMenloEthErrorStatspushErrorsDeltaMax", "adaptorMenloEthErrorStatspushErrorsDeltaMin", "adaptorMenloEthErrorStatsuncorrectableErrorsDelta", "adaptorMenloEthErrorStatsuncorrectableErrorsDeltaAvg", "adaptorMenloEthErrorStatsuncorrectableErrorsDeltaMax", "adaptorMenloEthErrorStatsuncorrectableErrorsDeltaMin", "adaptorMenloEthStatsdropOverrunDelta", "adaptorMenloEthStatsdropOverrunDeltaAvg", "adaptorMenloEthStatsdropOverrunDeltaMax", "adaptorMenloEthStatsdropOverrunDeltaMin", "adaptorMenloEthStatsdropRuntDelta", "adaptorMenloEthStatsdropRuntDeltaAvg", "adaptorMenloEthStatsdropRuntDeltaMax", "adaptorMenloEthStatsdropRuntDeltaMin", "adaptorMenloEthStatstruncateOverrunDelta", "adaptorMenloEthStatstruncateOverrunDeltaAvg", "adaptorMenloEthStatstruncateOverrunDeltaMax", "adaptorMenloEthStatstruncateOverrunDeltaMin", "adaptorMenloFcErrorStatscorrectableErrorsDelta", "adaptorMenloFcErrorStatscorrectableErrorsDeltaAvg", "adaptorMenloFcErrorStatscorrectableErrorsDeltaMax", "adaptorMenloFcErrorStatscorrectableErrorsDeltaMin", "adaptorMenloFcErrorStatspopErrorsDelta", "adaptorMenloFcErrorStatspopErrorsDeltaAvg", "adaptorMenloFcErrorStatspopErrorsDeltaMax", "adaptorMenloFcErrorStatspopErrorsDeltaMin", "adaptorMenloFcErrorStatspushErrorsDelta", "adaptorMenloFcErrorStatspushErrorsDeltaAvg", "adaptorMenloFcErrorStatspushErrorsDeltaMax", "adaptorMenloFcErrorStatspushErrorsDeltaMin", "adaptorMenloFcErrorStatsuncorrectableErrorsDelta", "adaptorMenloFcErrorStatsuncorrectableErrorsDeltaAvg", "adaptorMenloFcErrorStatsuncorrectableErrorsDeltaMax", "adaptorMenloFcErrorStatsuncorrectableErrorsDeltaMin", "adaptorMenloFcStatsdropAclDelta", "adaptorMenloFcStatsdropAclDeltaAvg", "adaptorMenloFcStatsdropAclDeltaMax", "adaptorMenloFcStatsdropAclDeltaMin", "adaptorMenloFcStatsdropOverrunDelta", "adaptorMenloFcStatsdropOverrunDeltaAvg", "adaptorMenloFcStatsdropOverrunDeltaMax", "adaptorMenloFcStatsdropOverrunDeltaMin", "adaptorMenloFcStatsdropRuntDelta", "adaptorMenloFcStatsdropRuntDeltaAvg", "adaptorMenloFcStatsdropRuntDeltaMax", "adaptorMenloFcStatsdropRuntDeltaMin", "adaptorMenloFcStatstruncateOverrunDelta", "adaptorMenloFcStatstruncateOverrunDeltaAvg", "adaptorMenloFcStatstruncateOverrunDeltaMax", "adaptorMenloFcStatstruncateOverrunDeltaMin", "adaptorMenloHostPortStatsrxPauseCFCDelta", "adaptorMenloHostPortStatsrxPauseCFCDeltaAvg", "adaptorMenloHostPortStatsrxPauseCFCDeltaMax", "adaptorMenloHostPortStatsrxPauseCFCDeltaMin", "adaptorMenloHostPortStatsrxPausePFCDelta", "adaptorMenloHostPortStatsrxPausePFCDeltaAvg", "adaptorMenloHostPortStatsrxPausePFCDeltaMax", "adaptorMenloHostPortStatsrxPausePFCDeltaMin", "adaptorMenloHostPortStatstxPauseCFCDelta", "adaptorMenloHostPortStatstxPauseCFCDeltaAvg", "adaptorMenloHostPortStatstxPauseCFCDeltaMax", "adaptorMenloHostPortStatstxPauseCFCDeltaMin", "adaptorMenloHostPortStatstxPausePFCDelta", "adaptorMenloHostPortStatstxPausePFCDeltaAvg", "adaptorMenloHostPortStatstxPausePFCDeltaMax", "adaptorMenloHostPortStatstxPausePFCDeltaMin", "adaptorMenloMcpuErrorStatscorrectableErrorsDelta", "adaptorMenloMcpuErrorStatscorrectableErrorsDeltaAvg", "adaptorMenloMcpuErrorStatscorrectableErrorsDeltaMax", "adaptorMenloMcpuErrorStatscorrectableErrorsDeltaMin", "adaptorMenloMcpuErrorStatspopErrorsDelta", "adaptorMenloMcpuErrorStatspopErrorsDeltaAvg", "adaptorMenloMcpuErrorStatspopErrorsDeltaMax", "adaptorMenloMcpuErrorStatspopErrorsDeltaMin", "adaptorMenloMcpuErrorStatspushErrorsDelta", "adaptorMenloMcpuErrorStatspushErrorsDeltaAvg", "adaptorMenloMcpuErrorStatspushErrorsDeltaMax", "adaptorMenloMcpuErrorStatspushErrorsDeltaMin", "adaptorMenloMcpuErrorStatsuncorrectableErrorsDelta", "adaptorMenloMcpuErrorStatsuncorrectableErrorsDeltaAvg", "adaptorMenloMcpuErrorStatsuncorrectableErrorsDeltaMax", "adaptorMenloMcpuErrorStatsuncorrectableErrorsDeltaMin", "adaptorMenloMcpuStatsdropAclDelta", "adaptorMenloMcpuStatsdropAclDeltaAvg", "adaptorMenloMcpuStatsdropAclDeltaMax", "adaptorMenloMcpuStatsdropAclDeltaMin", "adaptorMenloMcpuStatsdropOverrunDelta", "adaptorMenloMcpuStatsdropOverrunDeltaAvg", "adaptorMenloMcpuStatsdropOverrunDeltaMax", "adaptorMenloMcpuStatsdropOverrunDeltaMin", "adaptorMenloMcpuStatsdropRuntDelta", "adaptorMenloMcpuStatsdropRuntDeltaAvg", "adaptorMenloMcpuStatsdropRuntDeltaMax", "adaptorMenloMcpuStatsdropRuntDeltaMin", "adaptorMenloMcpuStatstruncateOverrunDelta", "adaptorMenloMcpuStatstruncateOverrunDeltaAvg", "adaptorMenloMcpuStatstruncateOverrunDeltaMax", "adaptorMenloMcpuStatstruncateOverrunDeltaMin", "adaptorMenloNetEgStatsdropCmdDelta", "adaptorMenloNetEgStatsdropCmdDeltaAvg", "adaptorMenloNetEgStatsdropCmdDeltaMax", "adaptorMenloNetEgStatsdropCmdDeltaMin", "adaptorMenloNetEgStatsdropLifCfgInvalidDelta", "adaptorMenloNetEgStatsdropLifCfgInvalidDeltaAvg", "adaptorMenloNetEgStatsdropLifCfgInvalidDeltaMax", "adaptorMenloNetEgStatsdropLifCfgInvalidDeltaMin", "adaptorMenloNetEgStatsdropLifMapNoHitDelta", "adaptorMenloNetEgStatsdropLifMapNoHitDeltaAvg", "adaptorMenloNetEgStatsdropLifMapNoHitDeltaMax", "adaptorMenloNetEgStatsdropLifMapNoHitDeltaMin", "adaptorMenloNetEgStatsdropSrcBindDelta", "adaptorMenloNetEgStatsdropSrcBindDeltaAvg", "adaptorMenloNetEgStatsdropSrcBindDeltaMax", "adaptorMenloNetEgStatsdropSrcBindDeltaMin", "adaptorMenloNetEgStatslearnReqDropDelta", "adaptorMenloNetEgStatslearnReqDropDeltaAvg", "adaptorMenloNetEgStatslearnReqDropDeltaMax", "adaptorMenloNetEgStatslearnReqDropDeltaMin", "adaptorMenloNetInStatsdropFcLifInvalidDelta", "adaptorMenloNetInStatsdropFcLifInvalidDeltaAvg", "adaptorMenloNetInStatsdropFcLifInvalidDeltaMax", "adaptorMenloNetInStatsdropFcLifInvalidDeltaMin", "adaptorMenloNetInStatsdropFcMulticastDelta", "adaptorMenloNetInStatsdropFcMulticastDeltaAvg", "adaptorMenloNetInStatsdropFcMulticastDeltaMax", "adaptorMenloNetInStatsdropFcMulticastDeltaMin", "adaptorMenloNetInStatsdropNullPifDelta", "adaptorMenloNetInStatsdropNullPifDeltaAvg", "adaptorMenloNetInStatsdropNullPifDeltaMax", "adaptorMenloNetInStatsdropNullPifDeltaMin", "adaptorMenloNetInStatsfwdLookupNoHitDelta", "adaptorMenloNetInStatsfwdLookupNoHitDeltaAvg", "adaptorMenloNetInStatsfwdLookupNoHitDeltaMax", "adaptorMenloNetInStatsfwdLookupNoHitDeltaMin", "adaptorMenloQErrorStatscorrectableErrorsDelta", "adaptorMenloQErrorStatscorrectableErrorsDeltaAvg", "adaptorMenloQErrorStatscorrectableErrorsDeltaMax", "adaptorMenloQErrorStatscorrectableErrorsDeltaMin", "adaptorMenloQErrorStatspopErrorsDelta", "adaptorMenloQErrorStatspopErrorsDeltaAvg", "adaptorMenloQErrorStatspopErrorsDeltaMax", "adaptorMenloQErrorStatspopErrorsDeltaMin", "adaptorMenloQErrorStatspushErrorsDelta", "adaptorMenloQErrorStatspushErrorsDeltaAvg", "adaptorMenloQErrorStatspushErrorsDeltaMax", "adaptorMenloQErrorStatspushErrorsDeltaMin", "adaptorMenloQErrorStatsuncorrectableErrorsDelta", "adaptorMenloQErrorStatsuncorrectableErrorsDeltaAvg", "adaptorMenloQErrorStatsuncorrectableErrorsDeltaMax", "adaptorMenloQErrorStatsuncorrectableErrorsDeltaMin", "adaptorMenloQStatsdropOverrunN0Delta", "adaptorMenloQStatsdropOverrunN0DeltaAvg", "adaptorMenloQStatsdropOverrunN0DeltaMax", "adaptorMenloQStatsdropOverrunN0DeltaMin", "adaptorMenloQStatsdropOverrunN1Delta", "adaptorMenloQStatsdropOverrunN1DeltaAvg", "adaptorMenloQStatsdropOverrunN1DeltaMax", "adaptorMenloQStatsdropOverrunN1DeltaMin", "adaptorMenloQStatstruncateOverrunN0Delta", "adaptorMenloQStatstruncateOverrunN0DeltaAvg", "adaptorMenloQStatstruncateOverrunN0DeltaMax", "adaptorMenloQStatstruncateOverrunN0DeltaMin", "adaptorMenloQStatstruncateOverrunN1Delta", "adaptorMenloQStatstruncateOverrunN1DeltaAvg", "adaptorMenloQStatstruncateOverrunN1DeltaMax", "adaptorMenloQStatstruncateOverrunN1DeltaMin", "adaptorVnicStatsbytesRxDelta", "adaptorVnicStatsbytesRxDeltaAvg", "adaptorVnicStatsbytesRxDeltaMax", "adaptorVnicStatsbytesRxDeltaMin", "adaptorVnicStatsbytesTxDelta", "adaptorVnicStatsbytesTxDeltaAvg", "adaptorVnicStatsbytesTxDeltaMax", "adaptorVnicStatsbytesTxDeltaMin", "adaptorVnicStatsdroppedRxDelta", "adaptorVnicStatsdroppedRxDeltaAvg", "adaptorVnicStatsdroppedRxDeltaMax", "adaptorVnicStatsdroppedRxDeltaMin", "adaptorVnicStatsdroppedTxDelta", "adaptorVnicStatsdroppedTxDeltaAvg", "adaptorVnicStatsdroppedTxDeltaMax", "adaptorVnicStatsdroppedTxDeltaMin", "adaptorVnicStatserrorsRxDelta", "adaptorVnicStatserrorsRxDeltaAvg", "adaptorVnicStatserrorsRxDeltaMax", "adaptorVnicStatserrorsRxDeltaMin", "adaptorVnicStatserrorsTxDelta", "adaptorVnicStatserrorsTxDeltaAvg", "adaptorVnicStatserrorsTxDeltaMax", "adaptorVnicStatserrorsTxDeltaMin", "adaptorVnicStatspacketsRxDelta", "adaptorVnicStatspacketsRxDeltaAvg", "adaptorVnicStatspacketsRxDeltaMax", "adaptorVnicStatspacketsRxDeltaMin", "adaptorVnicStatspacketsTxDelta", "adaptorVnicStatspacketsTxDeltaAvg", "adaptorVnicStatspacketsTxDeltaMax", "adaptorVnicStatspacketsTxDeltaMin", "computeIOHubEnvStatstemperature", "computeIOHubEnvStatstemperatureAvg", "computeIOHubEnvStatstemperatureMax", "computeIOHubEnvStatstemperatureMin", "computeMbPowerStatsconsumedPower", "computeMbPowerStatsconsumedPowerAvg", "computeMbPowerStatsconsumedPowerMax", "computeMbPowerStatsconsumedPowerMin", "computeMbPowerStatsinputCurrent", "computeMbPowerStatsinputCurrentAvg", "computeMbPowerStatsinputCurrentMax", "computeMbPowerStatsinputCurrentMin", "computeMbPowerStatsinputVoltage", "computeMbPowerStatsinputVoltageAvg", "computeMbPowerStatsinputVoltageMax", "computeMbPowerStatsinputVoltageMin", "computeMbTempStatsfmTempSenIo", "computeMbTempStatsfmTempSenIoAvg", "computeMbTempStatsfmTempSenIoMax", "computeMbTempStatsfmTempSenIoMin", "computeMbTempStatsfmTempSenRear", "computeMbTempStatsfmTempSenRearAvg", "computeMbTempStatsfmTempSenRearL", "computeMbTempStatsfmTempSenRearLAvg", "computeMbTempStatsfmTempSenRearLMax", "computeMbTempStatsfmTempSenRearLMin", "computeMbTempStatsfmTempSenRearMax", "computeMbTempStatsfmTempSenRearMin", "computeMbTempStatsfmTempSenRearR", "computeMbTempStatsfmTempSenRearRAvg", "computeMbTempStatsfmTempSenRearRMax", "computeMbTempStatsfmTempSenRearRMin", "computePCIeFatalCompletionStatsAbortErrors", "computePCIeFatalCompletionStatsTimeoutErrors", "computePCIeFatalCompletionStatsunexpectedErrors", "computePCIeFatalProtocolStatsdllpErrors", "computePCIeFatalProtocolStatsflowControlErrors", "computePCIeFatalReceiveStatsbufferOverflowErrors", "computePCIeFatalReceiveStatserrFatalErrors", "computePCIeFatalReceiveStatserrNonFatalErrors", "computePCIeFatalReceiveStatsunsupportedRequestErrors", "computePCIeFatalStatsacsViolationErrors", "computePCIeFatalStatsmalformedTLPErrors", "computePCIeFatalStatspoisonedTLPErrors", "computePCIeFatalStatssurpriseLinkDownErrors", "computeRackUnitMbTempStatsambientTemp", "computeRackUnitMbTempStatsambientTempAvg", "computeRackUnitMbTempStatsambientTempMax", "computeRackUnitMbTempStatsambientTempMin", "computeRackUnitMbTempStatsfrontTemp", "computeRackUnitMbTempStatsfrontTempAvg", "computeRackUnitMbTempStatsfrontTempMax", "computeRackUnitMbTempStatsfrontTempMin", "computeRackUnitMbTempStatsioh1Temp", "computeRackUnitMbTempStatsioh1TempAvg", "computeRackUnitMbTempStatsioh1TempMax", "computeRackUnitMbTempStatsioh1TempMin", "computeRackUnitMbTempStatsioh2Temp", "computeRackUnitMbTempStatsioh2TempAvg", "computeRackUnitMbTempStatsioh2TempMax", "computeRackUnitMbTempStatsioh2TempMin", "computeRackUnitMbTempStatsrearTemp", "computeRackUnitMbTempStatsrearTempAvg", "computeRackUnitMbTempStatsrearTempMax", "computeRackUnitMbTempStatsrearTempMin", "equipmentChassisStatsChassisI2CErrors", "equipmentChassisStatsChassisI2CErrorsAvg", "equipmentChassisStatsChassisI2CErrorsMax", "equipmentChassisStatsChassisI2CErrorsMin", "equipmentChassisStatsinputPower", "equipmentChassisStatsinputPowerAvg", "equipmentChassisStatsinputPowerMax", "equipmentChassisStatsinputPowerMin", "equipmentChassisStatsoutputPower", "equipmentChassisStatsoutputPowerAvg", "equipmentChassisStatsoutputPowerMax", "equipmentChassisStatsoutputPowerMin", "equipmentFanModuleStatsFanModuleI2CErrors", "equipmentFanModuleStatsFanModuleI2CErrorsAvg", "equipmentFanModuleStatsFanModuleI2CErrorsMax", "equipmentFanModuleStatsFanModuleI2CErrorsMin", "equipmentFanModuleStatsambientTemp", "equipmentFanModuleStatsambientTempAvg", "equipmentFanModuleStatsambientTempMax", "equipmentFanModuleStatsambientTempMin", "equipmentFanStatsspeed", "equipmentFanStatsspeedAvg", "equipmentFanStatsspeedMax", "equipmentFanStatsspeedMin", "equipmentFexEnvStatsdie1", "equipmentFexEnvStatsdie1Avg", "equipmentFexEnvStatsdie1Max", "equipmentFexEnvStatsdie1Min", "equipmentFexEnvStatsinlet", "equipmentFexEnvStatsinlet1", "equipmentFexEnvStatsinlet1Avg", "equipmentFexEnvStatsinlet1Max", "equipmentFexEnvStatsinlet1Min", "equipmentFexEnvStatsinletAvg", "equipmentFexEnvStatsinletMax", "equipmentFexEnvStatsinletMin", "equipmentFexEnvStatsoutlet1", "equipmentFexEnvStatsoutlet1Avg", "equipmentFexEnvStatsoutlet1Max", "equipmentFexEnvStatsoutlet1Min", "equipmentFexEnvStatsoutlet2", "equipmentFexEnvStatsoutlet2Avg", "equipmentFexEnvStatsoutlet2Max", "equipmentFexEnvStatsoutlet2Min", "equipmentFexPowerSummaryModulePower", "equipmentFexPowerSummaryModulePowerAvg", "equipmentFexPowerSummaryModulePowerMax", "equipmentFexPowerSummaryModulePowerMin", "equipmentFexPowerSummaryavailablePower", "equipmentFexPowerSummaryavailablePowerAvg", "equipmentFexPowerSummaryavailablePowerMax", "equipmentFexPowerSummaryavailablePowerMin", "equipmentFexPowerSummaryreservedPower", "equipmentFexPowerSummaryreservedPowerAvg", "equipmentFexPowerSummaryreservedPowerMax", "equipmentFexPowerSummaryreservedPowerMin", "equipmentFexPowerSummarytotalPower", "equipmentFexPowerSummarytotalPowerAvg", "equipmentFexPowerSummarytotalPowerMax", "equipmentFexPowerSummarytotalPowerMin", "equipmentFexPsuInputStatscurrent", "equipmentFexPsuInputStatscurrentAvg", "equipmentFexPsuInputStatscurrentMax", "equipmentFexPsuInputStatscurrentMin", "equipmentFexPsuInputStatspower", "equipmentFexPsuInputStatspowerAvg", "equipmentFexPsuInputStatspowerMax", "equipmentFexPsuInputStatspowerMin", "equipmentFexPsuInputStatsvoltage", "equipmentFexPsuInputStatsvoltageAvg", "equipmentFexPsuInputStatsvoltageMax", "equipmentFexPsuInputStatsvoltageMin", "equipmentFexSystemStatskernelMemFree", "equipmentFexSystemStatskernelMemFreeAvg", "equipmentFexSystemStatskernelMemFreeMax", "equipmentFexSystemStatskernelMemFreeMin", "equipmentFexSystemStatskernelMemTotal", "equipmentFexSystemStatskernelMemTotalAvg", "equipmentFexSystemStatskernelMemTotalMax", "equipmentFexSystemStatskernelMemTotalMin", "equipmentFexSystemStatsload", "equipmentFexSystemStatsloadAvg", "equipmentFexSystemStatsloadMax", "equipmentFexSystemStatsloadMin", "equipmentFexSystemStatsmemAvailable", "equipmentFexSystemStatsmemAvailableAvg", "equipmentFexSystemStatsmemAvailableMax", "equipmentFexSystemStatsmemAvailableMin", "equipmentFexSystemStatsmemCached", "equipmentFexSystemStatsmemCachedAvg", "equipmentFexSystemStatsmemCachedMax", "equipmentFexSystemStatsmemCachedMin", "equipmentIOCardStatsIomI2CErrors", "equipmentIOCardStatsIomI2CErrorsAvg", "equipmentIOCardStatsIomI2CErrorsMax", "equipmentIOCardStatsIomI2CErrorsMin", "equipmentIOCardStatsambientTemp", "equipmentIOCardStatsambientTempAvg", "equipmentIOCardStatsambientTempMax", "equipmentIOCardStatsambientTempMin", "equipmentIOCardStatsdimmTemp", "equipmentIOCardStatsdimmTempAvg", "equipmentIOCardStatsdimmTempMax", "equipmentIOCardStatsdimmTempMin", "equipmentIOCardStatsprocTemp", "equipmentIOCardStatsprocTempAvg", "equipmentIOCardStatsprocTempMax", "equipmentIOCardStatsprocTempMin", "equipmentIOCardStatstemp", "equipmentIOCardStatstempAvg", "equipmentIOCardStatstempMax", "equipmentIOCardStatstempMin", "equipmentNetworkElementFanStatsdrivePercentage", "equipmentNetworkElementFanStatsdrivePercentageAvg", "equipmentNetworkElementFanStatsdrivePercentageMax", "equipmentNetworkElementFanStatsdrivePercentageMin", "equipmentNetworkElementFanStatsspeed", "equipmentNetworkElementFanStatsspeedAvg", "equipmentNetworkElementFanStatsspeedMax", "equipmentNetworkElementFanStatsspeedMin", "equipmentPsuInputStatscurrent", "equipmentPsuInputStatscurrentAvg", "equipmentPsuInputStatscurrentMax", "equipmentPsuInputStatscurrentMin", "equipmentPsuInputStatspower", "equipmentPsuInputStatspowerAvg", "equipmentPsuInputStatspowerMax", "equipmentPsuInputStatspowerMin", "equipmentPsuInputStatsvoltage", "equipmentPsuInputStatsvoltageAvg", "equipmentPsuInputStatsvoltageMax", "equipmentPsuInputStatsvoltageMin", "equipmentPsuOutputStatscurrent", "equipmentPsuOutputStatscurrentAvg", "equipmentPsuOutputStatscurrentMax", "equipmentPsuOutputStatscurrentMin", "equipmentPsuOutputStatspower", "equipmentPsuOutputStatspowerAvg", "equipmentPsuOutputStatspowerMax", "equipmentPsuOutputStatspowerMin", "equipmentPsuOutputStatsvoltage", "equipmentPsuOutputStatsvoltageAvg", "equipmentPsuOutputStatsvoltageMax", "equipmentPsuOutputStatsvoltageMin", "equipmentPsuStatsPsuI2CErrors", "equipmentPsuStatsPsuI2CErrorsAvg", "equipmentPsuStatsPsuI2CErrorsMax", "equipmentPsuStatsPsuI2CErrorsMin", "equipmentPsuStatsambientTemp", "equipmentPsuStatsambientTempAvg", "equipmentPsuStatsambientTempMax", "equipmentPsuStatsambientTempMin", "equipmentPsuStatsinput210v", "equipmentPsuStatsinput210vAvg", "equipmentPsuStatsinput210vMax", "equipmentPsuStatsinput210vMin", "equipmentPsuStatsinputPower", "equipmentPsuStatsinputPowerAvg", "equipmentPsuStatsinputPowerMax", "equipmentPsuStatsinputPowerMin", "equipmentPsuStatsoutput12v", "equipmentPsuStatsoutput12vAvg", "equipmentPsuStatsoutput12vMax", "equipmentPsuStatsoutput12vMin", "equipmentPsuStatsoutput3v3", "equipmentPsuStatsoutput3v3Avg", "equipmentPsuStatsoutput3v3Max", "equipmentPsuStatsoutput3v3Min", "equipmentPsuStatsoutputCurrent", "equipmentPsuStatsoutputCurrentAvg", "equipmentPsuStatsoutputCurrentMax", "equipmentPsuStatsoutputCurrentMin", "equipmentPsuStatsoutputPower", "equipmentPsuStatsoutputPowerAvg", "equipmentPsuStatsoutputPowerMax", "equipmentPsuStatsoutputPowerMin", "equipmentRackUnitFanStatsspeed", "equipmentRackUnitFanStatsspeedAvg", "equipmentRackUnitFanStatsspeedMax", "equipmentRackUnitFanStatsspeedMin", "equipmentRackUnitPsuStatsambientTemp", "equipmentRackUnitPsuStatsambientTempAvg", "equipmentRackUnitPsuStatsambientTempMax", "equipmentRackUnitPsuStatsambientTempMin", "equipmentRackUnitPsuStatsinputPower", "equipmentRackUnitPsuStatsinputPowerAvg", "equipmentRackUnitPsuStatsinputPowerMax", "equipmentRackUnitPsuStatsinputPowerMin", "equipmentRackUnitPsuStatsinputVoltage", "equipmentRackUnitPsuStatsinputVoltageAvg", "equipmentRackUnitPsuStatsinputVoltageMax", "equipmentRackUnitPsuStatsinputVoltageMin", "equipmentRackUnitPsuStatsoutputCurrent", "equipmentRackUnitPsuStatsoutputCurrentAvg", "equipmentRackUnitPsuStatsoutputCurrentMax", "equipmentRackUnitPsuStatsoutputCurrentMin", "equipmentRackUnitPsuStatsoutputPower", "equipmentRackUnitPsuStatsoutputPowerAvg", "equipmentRackUnitPsuStatsoutputPowerMax", "equipmentRackUnitPsuStatsoutputPowerMin", "equipmentRackUnitPsuStatsoutputVoltage", "equipmentRackUnitPsuStatsoutputVoltageAvg", "equipmentRackUnitPsuStatsoutputVoltageMax", "equipmentRackUnitPsuStatsoutputVoltageMin", "equipmentSiocTempStatscmcTemp", "equipmentSiocTempStatscmcTempAvg", "equipmentSiocTempStatscmcTempMax", "equipmentSiocTempStatscmcTempMin", "equipmentSiocTempStatsfrontTemp", "equipmentSiocTempStatsfrontTempAvg", "equipmentSiocTempStatsfrontTempMax", "equipmentSiocTempStatsfrontTempMin", "equipmentSiocTempStatsmidTemp", "equipmentSiocTempStatsmidTempAvg", "equipmentSiocTempStatsmidTempMax", "equipmentSiocTempStatsmidTempMin", "equipmentSiocTempStatsrearTemp", "equipmentSiocTempStatsrearTempAvg", "equipmentSiocTempStatsrearTempMax", "equipmentSiocTempStatsrearTempMin", "equipmentSiocTempStatsvicTemp", "equipmentSiocTempStatsvicTempAvg", "equipmentSiocTempStatsvicTempMax", "equipmentSiocTempStatsvicTempMin", "etherErrStatsalignDelta", "etherErrStatsalignDeltaAvg", "etherErrStatsalignDeltaMax", "etherErrStatsalignDeltaMin", "etherErrStatsdeferredTxDelta", "etherErrStatsdeferredTxDeltaAvg", "etherErrStatsdeferredTxDeltaMax", "etherErrStatsdeferredTxDeltaMin", "etherErrStatsfcsDelta", "etherErrStatsfcsDeltaAvg", "etherErrStatsfcsDeltaMax", "etherErrStatsfcsDeltaMin", "etherErrStatsintMacRxDelta", "etherErrStatsintMacRxDeltaAvg", "etherErrStatsintMacRxDeltaMax", "etherErrStatsintMacRxDeltaMin", "etherErrStatsintMacTxDelta", "etherErrStatsintMacTxDeltaAvg", "etherErrStatsintMacTxDeltaMax", "etherErrStatsintMacTxDeltaMin", "etherErrStatsoutDiscardDelta", "etherErrStatsoutDiscardDeltaAvg", "etherErrStatsoutDiscardDeltaMax", "etherErrStatsoutDiscardDeltaMin", "etherErrStatsrcvDelta", "etherErrStatsrcvDeltaAvg", "etherErrStatsrcvDeltaMax", "etherErrStatsrcvDeltaMin", "etherErrStatsunderSizeDelta", "etherErrStatsunderSizeDeltaAvg", "etherErrStatsunderSizeDeltaMax", "etherErrStatsunderSizeDeltaMin", "etherErrStatsxmitDelta", "etherErrStatsxmitDeltaAvg", "etherErrStatsxmitDeltaMax", "etherErrStatsxmitDeltaMin", "etherFcoeInterfaceStatsbytesRxDelta", "etherFcoeInterfaceStatsbytesRxDeltaAvg", "etherFcoeInterfaceStatsbytesRxDeltaMax", "etherFcoeInterfaceStatsbytesRxDeltaMin", "etherFcoeInterfaceStatsbytesTxDelta", "etherFcoeInterfaceStatsbytesTxDeltaAvg", "etherFcoeInterfaceStatsbytesTxDeltaMax", "etherFcoeInterfaceStatsbytesTxDeltaMin", "etherFcoeInterfaceStatsdroppedRxDelta", "etherFcoeInterfaceStatsdroppedRxDeltaAvg", "etherFcoeInterfaceStatsdroppedRxDeltaMax", "etherFcoeInterfaceStatsdroppedRxDeltaMin", "etherFcoeInterfaceStatsdroppedTxDelta", "etherFcoeInterfaceStatsdroppedTxDeltaAvg", "etherFcoeInterfaceStatsdroppedTxDeltaMax", "etherFcoeInterfaceStatsdroppedTxDeltaMin", "etherFcoeInterfaceStatserrorsRxDelta", "etherFcoeInterfaceStatserrorsRxDeltaAvg", "etherFcoeInterfaceStatserrorsRxDeltaMax", "etherFcoeInterfaceStatserrorsRxDeltaMin", "etherFcoeInterfaceStatserrorsTxDelta", "etherFcoeInterfaceStatserrorsTxDeltaAvg", "etherFcoeInterfaceStatserrorsTxDeltaMax", "etherFcoeInterfaceStatserrorsTxDeltaMin", "etherFcoeInterfaceStatspacketsRxDelta", "etherFcoeInterfaceStatspacketsRxDeltaAvg", "etherFcoeInterfaceStatspacketsRxDeltaMax", "etherFcoeInterfaceStatspacketsRxDeltaMin", "etherFcoeInterfaceStatspacketsTxDelta", "etherFcoeInterfaceStatspacketsTxDeltaAvg", "etherFcoeInterfaceStatspacketsTxDeltaMax", "etherFcoeInterfaceStatspacketsTxDeltaMin", "etherLossStatsSQETestDelta", "etherLossStatsSQETestDeltaAvg", "etherLossStatsSQETestDeltaMax", "etherLossStatsSQETestDeltaMin", "etherLossStatscarrierSenseDelta", "etherLossStatscarrierSenseDeltaAvg", "etherLossStatscarrierSenseDeltaMax", "etherLossStatscarrierSenseDeltaMin", "etherLossStatsexcessCollisionDelta", "etherLossStatsexcessCollisionDeltaAvg", "etherLossStatsexcessCollisionDeltaMax", "etherLossStatsexcessCollisionDeltaMin", "etherLossStatsgiantsDelta", "etherLossStatsgiantsDeltaAvg", "etherLossStatsgiantsDeltaMax", "etherLossStatsgiantsDeltaMin", "etherLossStatslateCollisionDelta", "etherLossStatslateCollisionDeltaAvg", "etherLossStatslateCollisionDeltaMax", "etherLossStatslateCollisionDeltaMin", "etherLossStatsmultiCollisionDelta", "etherLossStatsmultiCollisionDeltaAvg", "etherLossStatsmultiCollisionDeltaMax", "etherLossStatsmultiCollisionDeltaMin", "etherLossStatssingleCollisionDelta", "etherLossStatssingleCollisionDeltaAvg", "etherLossStatssingleCollisionDeltaMax", "etherLossStatssingleCollisionDeltaMin", "etherLossStatssymbolDelta", "etherLossStatssymbolDeltaAvg", "etherLossStatssymbolDeltaMax", "etherLossStatssymbolDeltaMin", "etherNiErrStatscrcDelta", "etherNiErrStatscrcDeltaAvg", "etherNiErrStatscrcDeltaMax", "etherNiErrStatscrcDeltaMin", "etherNiErrStatsframeTxDelta", "etherNiErrStatsframeTxDeltaAvg", "etherNiErrStatsframeTxDeltaMax", "etherNiErrStatsframeTxDeltaMin", "etherNiErrStatsinRangeDelta", "etherNiErrStatsinRangeDeltaAvg", "etherNiErrStatsinRangeDeltaMax", "etherNiErrStatsinRangeDeltaMin", "etherNiErrStatstooLongDelta", "etherNiErrStatstooLongDeltaAvg", "etherNiErrStatstooLongDeltaMax", "etherNiErrStatstooLongDeltaMin", "etherNiErrStatstooShortDelta", "etherNiErrStatstooShortDeltaAvg", "etherNiErrStatstooShortDeltaMax", "etherNiErrStatstooShortDeltaMin", "etherPauseStatsrecvPauseDelta", "etherPauseStatsrecvPauseDeltaAvg", "etherPauseStatsrecvPauseDeltaMax", "etherPauseStatsrecvPauseDeltaMin", "etherPauseStatsresetsDelta", "etherPauseStatsresetsDeltaAvg", "etherPauseStatsresetsDeltaMax", "etherPauseStatsresetsDeltaMin", "etherPauseStatsxmitPauseDelta", "etherPauseStatsxmitPauseDeltaAvg", "etherPauseStatsxmitPauseDeltaMax", "etherPauseStatsxmitPauseDeltaMin", "etherRxStatsbroadcastPacketsDelta", "etherRxStatsbroadcastPacketsDeltaAvg", "etherRxStatsbroadcastPacketsDeltaMax", "etherRxStatsbroadcastPacketsDeltaMin", "etherRxStatsjumboPacketsDelta", "etherRxStatsjumboPacketsDeltaAvg", "etherRxStatsjumboPacketsDeltaMax", "etherRxStatsjumboPacketsDeltaMin", "etherRxStatsmulticastPacketsDelta", "etherRxStatsmulticastPacketsDeltaAvg", "etherRxStatsmulticastPacketsDeltaMax", "etherRxStatsmulticastPacketsDeltaMin", "etherRxStatstotalBytesDelta", "etherRxStatstotalBytesDeltaAvg", "etherRxStatstotalBytesDeltaMax", "etherRxStatstotalBytesDeltaMin", "etherRxStatstotalPacketsDelta", "etherRxStatstotalPacketsDeltaAvg", "etherRxStatstotalPacketsDeltaMax", "etherRxStatstotalPacketsDeltaMin", "etherRxStatsunicastPacketsDelta", "etherRxStatsunicastPacketsDeltaAvg", "etherRxStatsunicastPacketsDeltaMax", "etherRxStatsunicastPacketsDeltaMin", "etherTxStatsbroadcastPacketsDelta", "etherTxStatsbroadcastPacketsDeltaAvg", "etherTxStatsbroadcastPacketsDeltaMax", "etherTxStatsbroadcastPacketsDeltaMin", "etherTxStatsjumboPacketsDelta", "etherTxStatsjumboPacketsDeltaAvg", "etherTxStatsjumboPacketsDeltaMax", "etherTxStatsjumboPacketsDeltaMin", "etherTxStatsmulticastPacketsDelta", "etherTxStatsmulticastPacketsDeltaAvg", "etherTxStatsmulticastPacketsDeltaMax", "etherTxStatsmulticastPacketsDeltaMin", "etherTxStatstotalBytesDelta", "etherTxStatstotalBytesDeltaAvg", "etherTxStatstotalBytesDeltaMax", "etherTxStatstotalBytesDeltaMin", "etherTxStatstotalPacketsDelta", "etherTxStatstotalPacketsDeltaAvg", "etherTxStatstotalPacketsDeltaMax", "etherTxStatstotalPacketsDeltaMin", "etherTxStatsunicastPacketsDelta", "etherTxStatsunicastPacketsDeltaAvg", "etherTxStatsunicastPacketsDeltaMax", "etherTxStatsunicastPacketsDeltaMin", "fcErrStatscrcRxDelta", "fcErrStatscrcRxDeltaAvg", "fcErrStatscrcRxDeltaMax", "fcErrStatscrcRxDeltaMin", "fcErrStatsdiscardRxDelta", "fcErrStatsdiscardRxDeltaAvg", "fcErrStatsdiscardRxDeltaMax", "fcErrStatsdiscardRxDeltaMin", "fcErrStatsdiscardTxDelta", "fcErrStatsdiscardTxDeltaAvg", "fcErrStatsdiscardTxDeltaMax", "fcErrStatsdiscardTxDeltaMin", "fcErrStatslinkFailuresDelta", "fcErrStatslinkFailuresDeltaAvg", "fcErrStatslinkFailuresDeltaMax", "fcErrStatslinkFailuresDeltaMin", "fcErrStatsrxDelta", "fcErrStatsrxDeltaAvg", "fcErrStatsrxDeltaMax", "fcErrStatsrxDeltaMin", "fcErrStatssignalLossesDelta", "fcErrStatssignalLossesDeltaAvg", "fcErrStatssignalLossesDeltaMax", "fcErrStatssignalLossesDeltaMin", "fcErrStatssyncLossesDelta", "fcErrStatssyncLossesDeltaAvg", "fcErrStatssyncLossesDeltaMax", "fcErrStatssyncLossesDeltaMin", "fcErrStatstooLongRxDelta", "fcErrStatstooLongRxDeltaAvg", "fcErrStatstooLongRxDeltaMax", "fcErrStatstooLongRxDeltaMin", "fcErrStatstooShortRxDelta", "fcErrStatstooShortRxDeltaAvg", "fcErrStatstooShortRxDeltaMax", "fcErrStatstooShortRxDeltaMin", "fcErrStatstxDelta", "fcErrStatstxDeltaAvg", "fcErrStatstxDeltaMax", "fcErrStatstxDeltaMin", "fcStatsbytesRxDelta", "fcStatsbytesRxDeltaAvg", "fcStatsbytesRxDeltaMax", "fcStatsbytesRxDeltaMin", "fcStatsbytesTxDelta", "fcStatsbytesTxDeltaAvg", "fcStatsbytesTxDeltaMax", "fcStatsbytesTxDeltaMin", "fcStatspacketsRxDelta", "fcStatspacketsRxDeltaAvg", "fcStatspacketsRxDeltaMax", "fcStatspacketsRxDeltaMin", "fcStatspacketsTxDelta", "fcStatspacketsTxDeltaAvg", "fcStatspacketsTxDeltaMax", "fcStatspacketsTxDeltaMin", "memoryArrayEnvStatsinputCurrent", "memoryArrayEnvStatsinputCurrentAvg", "memoryArrayEnvStatsinputCurrentMax", "memoryArrayEnvStatsinputCurrentMin", "memoryBufferUnitEnvStatstemperature", "memoryBufferUnitEnvStatstemperatureAvg", "memoryBufferUnitEnvStatstemperatureMax", "memoryBufferUnitEnvStatstemperatureMin", "memoryErrorStatsaddressParityErrors", "memoryErrorStatseccMultibitErrors", "memoryErrorStatseccSinglebitErrors", "memoryErrorStatsmismatchErrors", "memoryRuntimeavailable", "memoryRuntimeavailableAvg", "memoryRuntimeavailableMax", "memoryRuntimeavailableMin", "memoryRuntimecached", "memoryRuntimecachedAvg", "memoryRuntimecachedMax", "memoryRuntimecachedMin", "memoryRuntimetotal", "memoryRuntimetotalAvg", "memoryRuntimetotalMax", "memoryRuntimetotalMin", "memoryUnitEnvStatstemperature", "memoryUnitEnvStatstemperatureAvg", "memoryUnitEnvStatstemperatureMax", "memoryUnitEnvStatstemperatureMin", "powerGroupStatspower", "powerGroupStatspowerAvg", "powerGroupStatspowerMax", "powerGroupStatspowerMin", "processorEnvStatsinputCurrent", "processorEnvStatsinputCurrentAvg", "processorEnvStatsinputCurrentMax", "processorEnvStatsinputCurrentMin", "processorEnvStatstemperature", "processorEnvStatstemperatureAvg", "processorEnvStatstemperatureMax", "processorEnvStatstemperatureMin", "processorErrorStatsmirroringInterSockErrors", "processorErrorStatsmirroringIntraSockErrors", "processorErrorStatssmiLinkCorrErrors", "processorErrorStatssmiLinkUncorrErrors", "processorErrorStatssparingErrors", "processorRuntimeload", "processorRuntimeloadAvg", "processorRuntimeloadMax", "processorRuntimeloadMin", "storageDiskEnvStatstemperature", "storageDiskEnvStatstemperatureAvg", "storageDiskEnvStatstemperatureMax", "storageDiskEnvStatstemperatureMin", "storageDiskEnvStatswearPercentage", "storageDiskEnvStatswearPercentageAvg", "storageDiskEnvStatswearPercentageMax", "storageDiskEnvStatswearPercentageMin", "storageHddMotherBoardTempStatsleftInletTemp", "storageHddMotherBoardTempStatsleftInletTempAvg", "storageHddMotherBoardTempStatsleftInletTempMax", "storageHddMotherBoardTempStatsleftInletTempMin", "storageHddMotherBoardTempStatsleftOutletTemp", "storageHddMotherBoardTempStatsleftOutletTempAvg", "storageHddMotherBoardTempStatsleftOutletTempMax", "storageHddMotherBoardTempStatsleftOutletTempMin", "storageHddMotherBoardTempStatsrightInletTemp", "storageHddMotherBoardTempStatsrightInletTempAvg", "storageHddMotherBoardTempStatsrightInletTempMax", "storageHddMotherBoardTempStatsrightInletTempMin", "storageHddMotherBoardTempStatsrightOutletTemp", "storageHddMotherBoardTempStatsrightOutletTempAvg", "storageHddMotherBoardTempStatsrightOutletTempMax", "storageHddMotherBoardTempStatsrightOutletTempMin", "storageNvmeStatsdriveLifeUsedPercentage", "storageNvmeStatsdriveLifeUsedPercentageAvg", "storageNvmeStatsdriveLifeUsedPercentageMax", "storageNvmeStatsdriveLifeUsedPercentageMin", "storageNvmeStatstemperature", "storageNvmeStatstemperatureAvg", "storageNvmeStatstemperatureMax", "storageNvmeStatstemperatureMin", "swCardEnvStatsSlotOutlet1", "swCardEnvStatsSlotOutlet1Avg", "swCardEnvStatsSlotOutlet1Max", "swCardEnvStatsSlotOutlet1Min", "swCardEnvStatsSlotOutlet2", "swCardEnvStatsSlotOutlet2Avg", "swCardEnvStatsSlotOutlet2Max", "swCardEnvStatsSlotOutlet2Min", "swCardEnvStatsSlotOutlet3", "swCardEnvStatsSlotOutlet3Avg", "swCardEnvStatsSlotOutlet3Max", "swCardEnvStatsSlotOutlet3Min", "swEnvStatsdonner", "swEnvStatsdonnerAvg", "swEnvStatsdonnerMax", "swEnvStatsdonnerMin", "swEnvStatsfanCtrlrInlet1", "swEnvStatsfanCtrlrInlet1Avg", "swEnvStatsfanCtrlrInlet1Max", "swEnvStatsfanCtrlrInlet1Min", "swEnvStatsfanCtrlrInlet2", "swEnvStatsfanCtrlrInlet2Avg", "swEnvStatsfanCtrlrInlet2Max", "swEnvStatsfanCtrlrInlet2Min", "swEnvStatsfanCtrlrInlet3", "swEnvStatsfanCtrlrInlet3Avg", "swEnvStatsfanCtrlrInlet3Max", "swEnvStatsfanCtrlrInlet3Min", "swEnvStatsfanCtrlrInlet4", "swEnvStatsfanCtrlrInlet4Avg", "swEnvStatsfanCtrlrInlet4Max", "swEnvStatsfanCtrlrInlet4Min", "swEnvStatsmainBoardOutlet1", "swEnvStatsmainBoardOutlet1Avg", "swEnvStatsmainBoardOutlet1Max", "swEnvStatsmainBoardOutlet1Min", "swEnvStatsmainBoardOutlet2", "swEnvStatsmainBoardOutlet2Avg", "swEnvStatsmainBoardOutlet2Max", "swEnvStatsmainBoardOutlet2Min", "swEnvStatspsuCtrlrInlet1", "swEnvStatspsuCtrlrInlet1Avg", "swEnvStatspsuCtrlrInlet1Max", "swEnvStatspsuCtrlrInlet1Min", "swEnvStatspsuCtrlrInlet2", "swEnvStatspsuCtrlrInlet2Avg", "swEnvStatspsuCtrlrInlet2Max", "swEnvStatspsuCtrlrInlet2Min", "swEnvStatstd2", "swEnvStatstd2Avg", "swEnvStatstd2Max", "swEnvStatstd2Min", "swEnvStatstiburon", "swEnvStatstiburonAvg", "swEnvStatstiburonMax", "swEnvStatstiburonMin", "swSystemStatsCorrectableParityError", "swSystemStatsCorrectableParityErrorAvg", "swSystemStatsCorrectableParityErrorMax", "swSystemStatsCorrectableParityErrorMin", "swSystemStatskernelMemFree", "swSystemStatskernelMemFreeAvg", "swSystemStatskernelMemFreeMax", "swSystemStatskernelMemFreeMin", "swSystemStatskernelMemTotal", "swSystemStatskernelMemTotalAvg", "swSystemStatskernelMemTotalMax", "swSystemStatskernelMemTotalMin", "swSystemStatsload", "swSystemStatsloadAvg", "swSystemStatsloadMax", "swSystemStatsloadMin", "swSystemStatsmemAvailable", "swSystemStatsmemAvailableAvg", "swSystemStatsmemAvailableMax", "swSystemStatsmemAvailableMin", "swSystemStatsmemCached", "swSystemStatsmemCachedAvg", "swSystemStatsmemCachedMax", "swSystemStatsmemCachedMin", "unspecified"], []), 
        "prop_type": MoPropertyMeta("prop_type", "propType", "string", VersionMeta.Version101e, MoPropertyMeta.READ_ONLY, None, None, None, None, ["float", "uint32", "uint64"], []), 
        "rn": MoPropertyMeta("rn", "rn", "string", VersionMeta.Version101e, MoPropertyMeta.READ_ONLY, 0x800, 0, 256, None, [], []), 
        "sacl": MoPropertyMeta("sacl", "sacl", "string", VersionMeta.Version302a, MoPropertyMeta.READ_ONLY, None, None, None, r"""((none|del|mod|addchild|cascade),){0,4}(none|del|mod|addchild|cascade){0,1}""", [], []), 
        "status": MoPropertyMeta("status", "status", "string", VersionMeta.Version101e, MoPropertyMeta.READ_WRITE, 0x1000, None, None, r"""((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], []), 
    }

    prop_map = {
        "autoRecovery": "auto_recovery", 
        "autoRecoveryTime": "auto_recovery_time", 
        "childAction": "child_action", 
        "descr": "descr", 
        "dn": "dn", 
        "errorDisableFiPort": "error_disable_fi_port", 
        "intId": "int_id", 
        "name": "name", 
        "normalValue": "normal_value", 
        "policyLevel": "policy_level", 
        "policyOwner": "policy_owner", 
        "propId": "prop_id", 
        "propType": "prop_type", 
        "rn": "rn", 
        "sacl": "sacl", 
        "status": "status", 
    }

    def __init__(self, parent_mo_or_dn, prop_id, **kwargs):
        self._dirty_mask = 0
        self.prop_id = prop_id
        self.auto_recovery = None
        self.auto_recovery_time = None
        self.child_action = None
        self.descr = None
        self.error_disable_fi_port = None
        self.int_id = None
        self.name = None
        self.normal_value = None
        self.policy_level = None
        self.policy_owner = None
        self.prop_type = None
        self.sacl = None
        self.status = None

        ManagedObject.__init__(self, "StatsThr32Definition", parent_mo_or_dn, **kwargs)
