"""This module contains the general information for GmetaClass ManagedObject."""

from ...ucsmo import ManagedObject
from ...ucscoremeta import MoPropertyMeta, MoMeta
from ...ucsmeta import VersionMeta


class GmetaClassConsts:
    EP_CLASS_ID_AAA_AUTH_METHOD = "aaaAuthMethod"
    EP_CLASS_ID_AAA_AUTH_REALM = "aaaAuthRealm"
    EP_CLASS_ID_AAA_AUTH_REALM_FSM = "aaaAuthRealmFsm"
    EP_CLASS_ID_AAA_AUTH_REALM_FSM_STAGE = "aaaAuthRealmFsmStage"
    EP_CLASS_ID_AAA_BANNER = "aaaBanner"
    EP_CLASS_ID_AAA_CIMC_SESSION = "aaaCimcSession"
    EP_CLASS_ID_AAA_CONFIG = "aaaConfig"
    EP_CLASS_ID_AAA_CONSOLE_AUTH = "aaaConsoleAuth"
    EP_CLASS_ID_AAA_DEFAULT_AUTH = "aaaDefaultAuth"
    EP_CLASS_ID_AAA_DEFINITION = "aaaDefinition"
    EP_CLASS_ID_AAA_DOMAIN = "aaaDomain"
    EP_CLASS_ID_AAA_DOMAIN_AUTH = "aaaDomainAuth"
    EP_CLASS_ID_AAA_EP = "aaaEp"
    EP_CLASS_ID_AAA_EP_AUTH_PROFILE = "aaaEpAuthProfile"
    EP_CLASS_ID_AAA_EP_FSM = "aaaEpFsm"
    EP_CLASS_ID_AAA_EP_FSM_STAGE = "aaaEpFsmStage"
    EP_CLASS_ID_AAA_EP_FSM_TASK = "aaaEpFsmTask"
    EP_CLASS_ID_AAA_EP_LOGIN = "aaaEpLogin"
    EP_CLASS_ID_AAA_EP_USER = "aaaEpUser"
    EP_CLASS_ID_AAA_EXT_MGMT_CUT_THRU_TKN = "aaaExtMgmtCutThruTkn"
    EP_CLASS_ID_AAA_ITEM = "aaaItem"
    EP_CLASS_ID_AAA_LDAP_EP = "aaaLdapEp"
    EP_CLASS_ID_AAA_LDAP_EP_FSM = "aaaLdapEpFsm"
    EP_CLASS_ID_AAA_LDAP_EP_FSM_STAGE = "aaaLdapEpFsmStage"
    EP_CLASS_ID_AAA_LDAP_GROUP = "aaaLdapGroup"
    EP_CLASS_ID_AAA_LDAP_GROUP_RULE = "aaaLdapGroupRule"
    EP_CLASS_ID_AAA_LDAP_PROVIDER = "aaaLdapProvider"
    EP_CLASS_ID_AAA_LOCALE = "aaaLocale"
    EP_CLASS_ID_AAA_LOG = "aaaLog"
    EP_CLASS_ID_AAA_MOD_LR = "aaaModLR"
    EP_CLASS_ID_AAA_ORG = "aaaOrg"
    EP_CLASS_ID_AAA_PRE_LOGIN_BANNER = "aaaPreLoginBanner"
    EP_CLASS_ID_AAA_PROVIDER = "aaaProvider"
    EP_CLASS_ID_AAA_PROVIDER_GROUP = "aaaProviderGroup"
    EP_CLASS_ID_AAA_PROVIDER_REF = "aaaProviderRef"
    EP_CLASS_ID_AAA_PWD_PROFILE = "aaaPwdProfile"
    EP_CLASS_ID_AAA_RADIUS_EP = "aaaRadiusEp"
    EP_CLASS_ID_AAA_RADIUS_EP_FSM = "aaaRadiusEpFsm"
    EP_CLASS_ID_AAA_RADIUS_EP_FSM_STAGE = "aaaRadiusEpFsmStage"
    EP_CLASS_ID_AAA_RADIUS_PROVIDER = "aaaRadiusProvider"
    EP_CLASS_ID_AAA_REALM = "aaaRealm"
    EP_CLASS_ID_AAA_REALM_FSM = "aaaRealmFsm"
    EP_CLASS_ID_AAA_REALM_FSM_STAGE = "aaaRealmFsmStage"
    EP_CLASS_ID_AAA_REALM_FSM_TASK = "aaaRealmFsmTask"
    EP_CLASS_ID_AAA_REMOTE_USER = "aaaRemoteUser"
    EP_CLASS_ID_AAA_ROLE = "aaaRole"
    EP_CLASS_ID_AAA_SESSION = "aaaSession"
    EP_CLASS_ID_AAA_SESSION_INFO = "aaaSessionInfo"
    EP_CLASS_ID_AAA_SESSION_INFO_TABLE = "aaaSessionInfoTable"
    EP_CLASS_ID_AAA_SESSION_LR = "aaaSessionLR"
    EP_CLASS_ID_AAA_SHELL_LOGIN = "aaaShellLogin"
    EP_CLASS_ID_AAA_SSH_AUTH = "aaaSshAuth"
    EP_CLASS_ID_AAA_SYSTEM_USER = "aaaSystemUser"
    EP_CLASS_ID_AAA_TACACS_PLUS_EP = "aaaTacacsPlusEp"
    EP_CLASS_ID_AAA_TACACS_PLUS_EP_FSM = "aaaTacacsPlusEpFsm"
    EP_CLASS_ID_AAA_TACACS_PLUS_EP_FSM_STAGE = "aaaTacacsPlusEpFsmStage"
    EP_CLASS_ID_AAA_TACACS_PLUS_PROVIDER = "aaaTacacsPlusProvider"
    EP_CLASS_ID_AAA_USER = "aaaUser"
    EP_CLASS_ID_AAA_USER_ACTION = "aaaUserAction"
    EP_CLASS_ID_AAA_USER_DATA = "aaaUserData"
    EP_CLASS_ID_AAA_USER_EP = "aaaUserEp"
    EP_CLASS_ID_AAA_USER_EP_FSM = "aaaUserEpFsm"
    EP_CLASS_ID_AAA_USER_EP_FSM_STAGE = "aaaUserEpFsmStage"
    EP_CLASS_ID_AAA_USER_EP_FSM_TASK = "aaaUserEpFsmTask"
    EP_CLASS_ID_AAA_USER_GROUP = "aaaUserGroup"
    EP_CLASS_ID_AAA_USER_LOCALE = "aaaUserLocale"
    EP_CLASS_ID_AAA_USER_LOGIN = "aaaUserLogin"
    EP_CLASS_ID_AAA_USER_ROLE = "aaaUserRole"
    EP_CLASS_ID_AAA_WEB_LOGIN = "aaaWebLogin"
    EP_CLASS_ID_ADAPTOR_BEH_CAP = "adaptorBehCap"
    EP_CLASS_ID_ADAPTOR_CIO_EP = "adaptorCIoEp"
    EP_CLASS_ID_ADAPTOR_CAP_DEF = "adaptorCapDef"
    EP_CLASS_ID_ADAPTOR_CAP_QUAL = "adaptorCapQual"
    EP_CLASS_ID_ADAPTOR_CAP_SPEC = "adaptorCapSpec"
    EP_CLASS_ID_ADAPTOR_DIAG_CAP = "adaptorDiagCap"
    EP_CLASS_ID_ADAPTOR_DYNAMIC_CONFIG_CAP = "adaptorDynamicConfigCap"
    EP_CLASS_ID_ADAPTOR_ETH_ADV_FILTER_PROFILE = "adaptorEthAdvFilterProfile"
    EP_CLASS_ID_ADAPTOR_ETH_ARFS_PROFILE = "adaptorEthArfsProfile"
    EP_CLASS_ID_ADAPTOR_ETH_COMP_QUEUE_PROFILE = "adaptorEthCompQueueProfile"
    EP_CLASS_ID_ADAPTOR_ETH_FAILOVER_PROFILE = "adaptorEthFailoverProfile"
    EP_CLASS_ID_ADAPTOR_ETH_INTERRUPT_PROFILE = "adaptorEthInterruptProfile"
    EP_CLASS_ID_ADAPTOR_ETH_INTERRUPT_SCALING_PROFILE = "adaptorEthInterruptScalingProfile"
    EP_CLASS_ID_ADAPTOR_ETH_NVGREPROFILE = "adaptorEthNVGREProfile"
    EP_CLASS_ID_ADAPTOR_ETH_OFFLOAD_PROFILE = "adaptorEthOffloadProfile"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS = "adaptorEthPortBySizeLargeStats"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST = "adaptorEthPortBySizeLargeStatsHist"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS = "adaptorEthPortBySizeSmallStats"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST = "adaptorEthPortBySizeSmallStatsHist"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_ERR_STATS = "adaptorEthPortErrStats"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST = "adaptorEthPortErrStatsHist"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_MCAST_STATS = "adaptorEthPortMcastStats"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST = "adaptorEthPortMcastStatsHist"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS = "adaptorEthPortOutsizedStats"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST = "adaptorEthPortOutsizedStatsHist"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_STATS = "adaptorEthPortStats"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_STATS_HIST = "adaptorEthPortStatsHist"
    EP_CLASS_ID_ADAPTOR_ETH_QUEUE_PROFILE = "adaptorEthQueueProfile"
    EP_CLASS_ID_ADAPTOR_ETH_RECV_QUEUE_PROFILE = "adaptorEthRecvQueueProfile"
    EP_CLASS_ID_ADAPTOR_ETH_RO_CEPROFILE = "adaptorEthRoCEProfile"
    EP_CLASS_ID_ADAPTOR_ETH_VX_LANPROFILE = "adaptorEthVxLANProfile"
    EP_CLASS_ID_ADAPTOR_ETH_WORK_QUEUE_PROFILE = "adaptorEthWorkQueueProfile"
    EP_CLASS_ID_ADAPTOR_ETHER_IF_STATS = "adaptorEtherIfStats"
    EP_CLASS_ID_ADAPTOR_ETHER_IF_STATS_HIST = "adaptorEtherIfStatsHist"
    EP_CLASS_ID_ADAPTOR_EXT_ETH_IF = "adaptorExtEthIf"
    EP_CLASS_ID_ADAPTOR_EXT_ETH_IF_FSM = "adaptorExtEthIfFsm"
    EP_CLASS_ID_ADAPTOR_EXT_ETH_IF_FSM_STAGE = "adaptorExtEthIfFsmStage"
    EP_CLASS_ID_ADAPTOR_EXT_ETH_IF_FSM_TASK = "adaptorExtEthIfFsmTask"
    EP_CLASS_ID_ADAPTOR_EXT_ETH_IF_PC = "adaptorExtEthIfPc"
    EP_CLASS_ID_ADAPTOR_EXT_ETH_IF_PC_EP = "adaptorExtEthIfPcEp"
    EP_CLASS_ID_ADAPTOR_EXT_IF = "adaptorExtIf"
    EP_CLASS_ID_ADAPTOR_EXT_IF_EP = "adaptorExtIfEp"
    EP_CLASS_ID_ADAPTOR_EXT_IF_PC = "adaptorExtIfPc"
    EP_CLASS_ID_ADAPTOR_EXT_IP_V6_RSS_HASH_PROFILE = "adaptorExtIpV6RssHashProfile"
    EP_CLASS_ID_ADAPTOR_EXTERNAL_EP = "adaptorExternalEp"
    EP_CLASS_ID_ADAPTOR_EXTERNAL_PC = "adaptorExternalPc"
    EP_CLASS_ID_ADAPTOR_FAMILY_TYPE_DEF = "adaptorFamilyTypeDef"
    EP_CLASS_ID_ADAPTOR_FC_CDB_WORK_QUEUE_PROFILE = "adaptorFcCdbWorkQueueProfile"
    EP_CLASS_ID_ADAPTOR_FC_ERROR_RECOVERY_PROFILE = "adaptorFcErrorRecoveryProfile"
    EP_CLASS_ID_ADAPTOR_FC_FNIC_PROFILE = "adaptorFcFnicProfile"
    EP_CLASS_ID_ADAPTOR_FC_IF_EVENT_STATS = "adaptorFcIfEventStats"
    EP_CLASS_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST = "adaptorFcIfEventStatsHist"
    EP_CLASS_ID_ADAPTOR_FC_IF_FC4_STATS = "adaptorFcIfFC4Stats"
    EP_CLASS_ID_ADAPTOR_FC_IF_FC4_STATS_HIST = "adaptorFcIfFC4StatsHist"
    EP_CLASS_ID_ADAPTOR_FC_IF_FRAME_STATS = "adaptorFcIfFrameStats"
    EP_CLASS_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST = "adaptorFcIfFrameStatsHist"
    EP_CLASS_ID_ADAPTOR_FC_INTERRUPT_PROFILE = "adaptorFcInterruptProfile"
    EP_CLASS_ID_ADAPTOR_FC_LOGI_PROFILE = "adaptorFcLogiProfile"
    EP_CLASS_ID_ADAPTOR_FC_OEIF = "adaptorFcOEIf"
    EP_CLASS_ID_ADAPTOR_FC_PORT_FLOGI_PROFILE = "adaptorFcPortFLogiProfile"
    EP_CLASS_ID_ADAPTOR_FC_PORT_PLOGI_PROFILE = "adaptorFcPortPLogiProfile"
    EP_CLASS_ID_ADAPTOR_FC_PORT_PROFILE = "adaptorFcPortProfile"
    EP_CLASS_ID_ADAPTOR_FC_PORT_STATS = "adaptorFcPortStats"
    EP_CLASS_ID_ADAPTOR_FC_PORT_STATS_HIST = "adaptorFcPortStatsHist"
    EP_CLASS_ID_ADAPTOR_FC_QUEUE_PROFILE = "adaptorFcQueueProfile"
    EP_CLASS_ID_ADAPTOR_FC_RECV_QUEUE_PROFILE = "adaptorFcRecvQueueProfile"
    EP_CLASS_ID_ADAPTOR_FC_WORK_QUEUE_PROFILE = "adaptorFcWorkQueueProfile"
    EP_CLASS_ID_ADAPTOR_FRU_CAP_PROVIDER = "adaptorFruCapProvider"
    EP_CLASS_ID_ADAPTOR_FRU_CAP_REF = "adaptorFruCapRef"
    EP_CLASS_ID_ADAPTOR_FW_CAP_PROVIDER = "adaptorFwCapProvider"
    EP_CLASS_ID_ADAPTOR_HOST_ETH_IF = "adaptorHostEthIf"
    EP_CLASS_ID_ADAPTOR_HOST_ETH_IF_FSM = "adaptorHostEthIfFsm"
    EP_CLASS_ID_ADAPTOR_HOST_ETH_IF_FSM_STAGE = "adaptorHostEthIfFsmStage"
    EP_CLASS_ID_ADAPTOR_HOST_ETH_IF_FSM_TASK = "adaptorHostEthIfFsmTask"
    EP_CLASS_ID_ADAPTOR_HOST_ETH_IF_PROFILE = "adaptorHostEthIfProfile"
    EP_CLASS_ID_ADAPTOR_HOST_FC_IF = "adaptorHostFcIf"
    EP_CLASS_ID_ADAPTOR_HOST_FC_IF_FSM = "adaptorHostFcIfFsm"
    EP_CLASS_ID_ADAPTOR_HOST_FC_IF_FSM_STAGE = "adaptorHostFcIfFsmStage"
    EP_CLASS_ID_ADAPTOR_HOST_FC_IF_FSM_TASK = "adaptorHostFcIfFsmTask"
    EP_CLASS_ID_ADAPTOR_HOST_FC_IF_PROFILE = "adaptorHostFcIfProfile"
    EP_CLASS_ID_ADAPTOR_HOST_IF = "adaptorHostIf"
    EP_CLASS_ID_ADAPTOR_HOST_IF_CONFIG = "adaptorHostIfConfig"
    EP_CLASS_ID_ADAPTOR_HOST_IF_CONN_DEF = "adaptorHostIfConnDef"
    EP_CLASS_ID_ADAPTOR_HOST_IF_PROFILE = "adaptorHostIfProfile"
    EP_CLASS_ID_ADAPTOR_HOST_ISCSI_IF = "adaptorHostIscsiIf"
    EP_CLASS_ID_ADAPTOR_HOST_ISCSI_IF_PROFILE = "adaptorHostIscsiIfProfile"
    EP_CLASS_ID_ADAPTOR_HOST_MGMT_CAP = "adaptorHostMgmtCap"
    EP_CLASS_ID_ADAPTOR_HOST_PORT = "adaptorHostPort"
    EP_CLASS_ID_ADAPTOR_HOST_PORT_CAP = "adaptorHostPortCap"
    EP_CLASS_ID_ADAPTOR_HOST_SCSI_IF = "adaptorHostScsiIf"
    EP_CLASS_ID_ADAPTOR_HOST_SCSI_LUN_REF = "adaptorHostScsiLunRef"
    EP_CLASS_ID_ADAPTOR_HOST_SERVICE_ETH_IF = "adaptorHostServiceEthIf"
    EP_CLASS_ID_ADAPTOR_HOST_VNIC_HW_ADDR_CAP = "adaptorHostVnicHwAddrCap"
    EP_CLASS_ID_ADAPTOR_HOSTETH_HW_ADDR_CAP = "adaptorHostethHwAddrCap"
    EP_CLASS_ID_ADAPTOR_HOSTFC_HW_ADDR_CAP = "adaptorHostfcHwAddrCap"
    EP_CLASS_ID_ADAPTOR_HW_ADDR_CAP = "adaptorHwAddrCap"
    EP_CLASS_ID_ADAPTOR_ISCSI_CAP = "adaptorIScsiCap"
    EP_CLASS_ID_ADAPTOR_IP_V4_RSS_HASH_PROFILE = "adaptorIpV4RssHashProfile"
    EP_CLASS_ID_ADAPTOR_IP_V6_RSS_HASH_PROFILE = "adaptorIpV6RssHashProfile"
    EP_CLASS_ID_ADAPTOR_ISCSI_AUTH = "adaptorIscsiAuth"
    EP_CLASS_ID_ADAPTOR_ISCSI_PROT = "adaptorIscsiProt"
    EP_CLASS_ID_ADAPTOR_ISCSI_TARGET_IF = "adaptorIscsiTargetIf"
    EP_CLASS_ID_ADAPTOR_LAN_CAP = "adaptorLanCap"
    EP_CLASS_ID_ADAPTOR_LLDP_CAP = "adaptorLldpCap"
    EP_CLASS_ID_ADAPTOR_MENLO_BASE_ERROR_STATS = "adaptorMenloBaseErrorStats"
    EP_CLASS_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST = "adaptorMenloBaseErrorStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_DCE_PORT_STATS = "adaptorMenloDcePortStats"
    EP_CLASS_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST = "adaptorMenloDcePortStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_ETH_ERROR_STATS = "adaptorMenloEthErrorStats"
    EP_CLASS_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST = "adaptorMenloEthErrorStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_ETH_STATS = "adaptorMenloEthStats"
    EP_CLASS_ID_ADAPTOR_MENLO_ETH_STATS_HIST = "adaptorMenloEthStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_FC_ERROR_STATS = "adaptorMenloFcErrorStats"
    EP_CLASS_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST = "adaptorMenloFcErrorStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_FC_STATS = "adaptorMenloFcStats"
    EP_CLASS_ID_ADAPTOR_MENLO_FC_STATS_HIST = "adaptorMenloFcStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_HOST_PORT_STATS = "adaptorMenloHostPortStats"
    EP_CLASS_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST = "adaptorMenloHostPortStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS = "adaptorMenloMcpuErrorStats"
    EP_CLASS_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST = "adaptorMenloMcpuErrorStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_MCPU_STATS = "adaptorMenloMcpuStats"
    EP_CLASS_ID_ADAPTOR_MENLO_MCPU_STATS_HIST = "adaptorMenloMcpuStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_NET_EG_STATS = "adaptorMenloNetEgStats"
    EP_CLASS_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST = "adaptorMenloNetEgStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_NET_IN_STATS = "adaptorMenloNetInStats"
    EP_CLASS_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST = "adaptorMenloNetInStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_QERROR_STATS = "adaptorMenloQErrorStats"
    EP_CLASS_ID_ADAPTOR_MENLO_QERROR_STATS_HIST = "adaptorMenloQErrorStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_QSTATS = "adaptorMenloQStats"
    EP_CLASS_ID_ADAPTOR_MENLO_QSTATS_HIST = "adaptorMenloQStatsHist"
    EP_CLASS_ID_ADAPTOR_MGMT_CAP = "adaptorMgmtCap"
    EP_CLASS_ID_ADAPTOR_MGMT_VNIC_ETH_CONFIG = "adaptorMgmtVnicEthConfig"
    EP_CLASS_ID_ADAPTOR_NW_MGMT_CAP = "adaptorNwMgmtCap"
    EP_CLASS_ID_ADAPTOR_NW_STATS_MGMT_CAP = "adaptorNwStatsMgmtCap"
    EP_CLASS_ID_ADAPTOR_PIO_EP = "adaptorPIoEp"
    EP_CLASS_ID_ADAPTOR_PROFILE_ITEM = "adaptorProfileItem"
    EP_CLASS_ID_ADAPTOR_PROTOCOL_PROFILE = "adaptorProtocolProfile"
    EP_CLASS_ID_ADAPTOR_QUAL = "adaptorQual"
    EP_CLASS_ID_ADAPTOR_QUEUE_PROFILE = "adaptorQueueProfile"
    EP_CLASS_ID_ADAPTOR_RNIC_CAP_SPEC = "adaptorRnicCapSpec"
    EP_CLASS_ID_ADAPTOR_RSS_HASH_PROFILE = "adaptorRssHashProfile"
    EP_CLASS_ID_ADAPTOR_RSS_PROFILE = "adaptorRssProfile"
    EP_CLASS_ID_ADAPTOR_SAN_CAP = "adaptorSanCap"
    EP_CLASS_ID_ADAPTOR_TCP_IP_RSS_HASH_PROFILE = "adaptorTcpIpRssHashProfile"
    EP_CLASS_ID_ADAPTOR_UNIT = "adaptorUnit"
    EP_CLASS_ID_ADAPTOR_UNIT_ASSOC_CTX = "adaptorUnitAssocCtx"
    EP_CLASS_ID_ADAPTOR_UNIT_EXTN = "adaptorUnitExtn"
    EP_CLASS_ID_ADAPTOR_UPLINK_HW_ADDR_CAP = "adaptorUplinkHwAddrCap"
    EP_CLASS_ID_ADAPTOR_UPLINK_PORT_STATS = "adaptorUplinkPortStats"
    EP_CLASS_ID_ADAPTOR_USNIC_CONN_DEF = "adaptorUsnicConnDef"
    EP_CLASS_ID_ADAPTOR_VLAN = "adaptorVlan"
    EP_CLASS_ID_ADAPTOR_VNIC_STATS = "adaptorVnicStats"
    EP_CLASS_ID_ADAPTOR_VNIC_STATS_HIST = "adaptorVnicStatsHist"
    EP_CLASS_ID_ADAPTOR_VSAN = "adaptorVsan"
    EP_CLASS_ID_APE_ADAPTER = "apeAdapter"
    EP_CLASS_ID_APE_ADAPTER_VNIC = "apeAdapterVnic"
    EP_CLASS_ID_APE_ATTRIBUTE = "apeAttribute"
    EP_CLASS_ID_APE_BOOT_METHOD = "apeBootMethod"
    EP_CLASS_ID_APE_CONTROLLER_CHASSIS = "apeControllerChassis"
    EP_CLASS_ID_APE_CONTROLLER_EEPROM = "apeControllerEeprom"
    EP_CLASS_ID_APE_CONTROLLER_MANAGER = "apeControllerManager"
    EP_CLASS_ID_APE_DCOS_AG_MANAGER = "apeDcosAgManager"
    EP_CLASS_ID_APE_FRU = "apeFru"
    EP_CLASS_ID_APE_HOST_AGENT = "apeHostAgent"
    EP_CLASS_ID_APE_LANBOOT = "apeLANBoot"
    EP_CLASS_ID_APE_LOCAL_DISK_BOOT = "apeLocalDiskBoot"
    EP_CLASS_ID_APE_MANAGER = "apeManager"
    EP_CLASS_ID_APE_MC = "apeMc"
    EP_CLASS_ID_APE_MC_STATS = "apeMcStats"
    EP_CLASS_ID_APE_MC_TABLE = "apeMcTable"
    EP_CLASS_ID_APE_MENLO = "apeMenlo"
    EP_CLASS_ID_APE_MENLO_VNIC = "apeMenloVnic"
    EP_CLASS_ID_APE_MENLO_VNIC_STATS = "apeMenloVnicStats"
    EP_CLASS_ID_APE_NIC_AG_MANAGER = "apeNicAgManager"
    EP_CLASS_ID_APE_PALO = "apePalo"
    EP_CLASS_ID_APE_PALO_VNIC = "apePaloVnic"
    EP_CLASS_ID_APE_PALO_VNIC_STATS = "apePaloVnicStats"
    EP_CLASS_ID_APE_PARAM = "apeParam"
    EP_CLASS_ID_APE_READING = "apeReading"
    EP_CLASS_ID_APE_SANBOOT = "apeSANBoot"
    EP_CLASS_ID_APE_SDR = "apeSdr"
    EP_CLASS_ID_APE_SWITCH_FIRMWARE_INV = "apeSwitchFirmwareInv"
    EP_CLASS_ID_APE_VIRTUAL_MEDIA_BOOT = "apeVirtualMediaBoot"
    EP_CLASS_ID_APE_VNIC_STATS = "apeVnicStats"
    EP_CLASS_ID_BIOS_AREF = "biosARef"
    EP_CLASS_ID_BIOS_BOT = "biosBOT"
    EP_CLASS_ID_BIOS_BOOT_DEV = "biosBootDev"
    EP_CLASS_ID_BIOS_BOOT_DEV_GRP = "biosBootDevGrp"
    EP_CLASS_ID_BIOS_FEATURE_REF = "biosFeatureRef"
    EP_CLASS_ID_BIOS_PARAMETER_REF = "biosParameterRef"
    EP_CLASS_ID_BIOS_REF = "biosRef"
    EP_CLASS_ID_BIOS_SETTING_REF = "biosSettingRef"
    EP_CLASS_ID_BIOS_SETTINGS = "biosSettings"
    EP_CLASS_ID_BIOS_UNIT = "biosUnit"
    EP_CLASS_ID_BIOS_VFEAT = "biosVFeat"
    EP_CLASS_ID_BIOS_VIDENTITY_PARAMS = "biosVIdentityParams"
    EP_CLASS_ID_BIOS_VPROFILE = "biosVProfile"
    EP_CLASS_ID_BIOS_VF_ACPI10_SUPPORT = "biosVfACPI10Support"
    EP_CLASS_ID_BIOS_VF_ASPMSUPPORT = "biosVfASPMSupport"
    EP_CLASS_ID_BIOS_VF_ALL_USBDEVICES = "biosVfAllUSBDevices"
    EP_CLASS_ID_BIOS_VF_ALTITUDE = "biosVfAltitude"
    EP_CLASS_ID_BIOS_VF_ASSERT_NMION_PERR = "biosVfAssertNMIOnPERR"
    EP_CLASS_ID_BIOS_VF_ASSERT_NMION_SERR = "biosVfAssertNMIOnSERR"
    EP_CLASS_ID_BIOS_VF_BOOT_OPTION_RETRY = "biosVfBootOptionRetry"
    EP_CLASS_ID_BIOS_VF_CPUHARDWARE_POWER_MANAGEMENT = "biosVfCPUHardwarePowerManagement"
    EP_CLASS_ID_BIOS_VF_CPUPERFORMANCE = "biosVfCPUPerformance"
    EP_CLASS_ID_BIOS_VF_CPUPOWER_MANAGEMENT = "biosVfCPUPowerManagement"
    EP_CLASS_ID_BIOS_VF_CONSISTENT_DEVICE_NAME_CONTROL = "biosVfConsistentDeviceNameControl"
    EP_CLASS_ID_BIOS_VF_CONSOLE_REDIRECTION = "biosVfConsoleRedirection"
    EP_CLASS_ID_BIOS_VF_CORE_MULTI_PROCESSING = "biosVfCoreMultiProcessing"
    EP_CLASS_ID_BIOS_VF_DDR3_VOLTAGE_SELECTION = "biosVfDDR3VoltageSelection"
    EP_CLASS_ID_BIOS_VF_DRAMCLOCK_THROTTLING = "biosVfDRAMClockThrottling"
    EP_CLASS_ID_BIOS_VF_DIRECT_CACHE_ACCESS = "biosVfDirectCacheAccess"
    EP_CLASS_ID_BIOS_VF_DRAM_REFRESH_RATE = "biosVfDramRefreshRate"
    EP_CLASS_ID_BIOS_VF_ENERGY_PERFORMANCE_TUNING = "biosVfEnergyPerformanceTuning"
    EP_CLASS_ID_BIOS_VF_ENHANCED_INTEL_SPEED_STEP_TECH = "biosVfEnhancedIntelSpeedStepTech"
    EP_CLASS_ID_BIOS_VF_ENHANCED_POWER_CAPPING_SUPPORT = "biosVfEnhancedPowerCappingSupport"
    EP_CLASS_ID_BIOS_VF_EXECUTE_DISABLE_BIT = "biosVfExecuteDisableBit"
    EP_CLASS_ID_BIOS_VF_FRB2_TIMER = "biosVfFRB2Timer"
    EP_CLASS_ID_BIOS_VF_FREQUENCY_FLOOR_OVERRIDE = "biosVfFrequencyFloorOverride"
    EP_CLASS_ID_BIOS_VF_FRONT_PANEL_LOCKOUT = "biosVfFrontPanelLockout"
    EP_CLASS_ID_BIOS_VF_IOEMEZZ1_OPTION_ROM = "biosVfIOEMezz1OptionROM"
    EP_CLASS_ID_BIOS_VF_IOENVME1_OPTION_ROM = "biosVfIOENVMe1OptionROM"
    EP_CLASS_ID_BIOS_VF_IOENVME2_OPTION_ROM = "biosVfIOENVMe2OptionROM"
    EP_CLASS_ID_BIOS_VF_IOESLOT1_OPTION_ROM = "biosVfIOESlot1OptionROM"
    EP_CLASS_ID_BIOS_VF_IOESLOT2_OPTION_ROM = "biosVfIOESlot2OptionROM"
    EP_CLASS_ID_BIOS_VF_INTEGRATED_GRAPHICS = "biosVfIntegratedGraphics"
    EP_CLASS_ID_BIOS_VF_INTEGRATED_GRAPHICS_APERTURE_SIZE = "biosVfIntegratedGraphicsApertureSize"
    EP_CLASS_ID_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE = "biosVfIntelEntrySASRAIDModule"
    EP_CLASS_ID_BIOS_VF_INTEL_HYPER_THREADING_TECH = "biosVfIntelHyperThreadingTech"
    EP_CLASS_ID_BIOS_VF_INTEL_TRUSTED_EXECUTION_TECHNOLOGY = "biosVfIntelTrustedExecutionTechnology"
    EP_CLASS_ID_BIOS_VF_INTEL_TURBO_BOOST_TECH = "biosVfIntelTurboBoostTech"
    EP_CLASS_ID_BIOS_VF_INTEL_VTFOR_DIRECTED_IO = "biosVfIntelVTForDirectedIO"
    EP_CLASS_ID_BIOS_VF_INTEL_VIRTUALIZATION_TECHNOLOGY = "biosVfIntelVirtualizationTechnology"
    EP_CLASS_ID_BIOS_VF_INTERLEAVE_CONFIGURATION = "biosVfInterleaveConfiguration"
    EP_CLASS_ID_BIOS_VF_LOCAL_X2_APIC = "biosVfLocalX2Apic"
    EP_CLASS_ID_BIOS_VF_LV_DIMMSUPPORT = "biosVfLvDIMMSupport"
    EP_CLASS_ID_BIOS_VF_MAX_VARIABLE_MTRRSETTING = "biosVfMaxVariableMTRRSetting"
    EP_CLASS_ID_BIOS_VF_MAXIMUM_MEMORY_BELOW4_GB = "biosVfMaximumMemoryBelow4GB"
    EP_CLASS_ID_BIOS_VF_MEMORY_MAPPED_IOABOVE4_GB = "biosVfMemoryMappedIOAbove4GB"
    EP_CLASS_ID_BIOS_VF_MIRRORING_MODE = "biosVfMirroringMode"
    EP_CLASS_ID_BIOS_VF_NUMAOPTIMIZED = "biosVfNUMAOptimized"
    EP_CLASS_ID_BIOS_VF_OSBOOT_WATCHDOG_TIMER = "biosVfOSBootWatchdogTimer"
    EP_CLASS_ID_BIOS_VF_OSBOOT_WATCHDOG_TIMER_POLICY = "biosVfOSBootWatchdogTimerPolicy"
    EP_CLASS_ID_BIOS_VF_OSBOOT_WATCHDOG_TIMER_TIMEOUT = "biosVfOSBootWatchdogTimerTimeout"
    EP_CLASS_ID_BIOS_VF_ONBOARD_GRAPHICS = "biosVfOnboardGraphics"
    EP_CLASS_ID_BIOS_VF_ONBOARD_SATACONTROLLER = "biosVfOnboardSATAController"
    EP_CLASS_ID_BIOS_VF_ONBOARD_STORAGE = "biosVfOnboardStorage"
    EP_CLASS_ID_BIOS_VF_OPTION_ROMENABLE = "biosVfOptionROMEnable"
    EP_CLASS_ID_BIOS_VF_OPTION_ROMLOAD = "biosVfOptionROMLoad"
    EP_CLASS_ID_BIOS_VF_OUT_OF_BAND_MANAGEMENT = "biosVfOutOfBandManagement"
    EP_CLASS_ID_BIOS_VF_PCHSATAMODE = "biosVfPCHSATAMode"
    EP_CLASS_ID_BIOS_VF_PCILOMPORTS_CONFIGURATION = "biosVfPCILOMPortsConfiguration"
    EP_CLASS_ID_BIOS_VF_PCIROMCLP = "biosVfPCIROMCLP"
    EP_CLASS_ID_BIOS_VF_PCISLOT_LINK_SPEED = "biosVfPCISlotLinkSpeed"
    EP_CLASS_ID_BIOS_VF_PCISLOT_OPTION_ROMENABLE = "biosVfPCISlotOptionROMEnable"
    EP_CLASS_ID_BIOS_VF_POSTERROR_PAUSE = "biosVfPOSTErrorPause"
    EP_CLASS_ID_BIOS_VF_PSTATECOORDINATION = "biosVfPSTATECoordination"
    EP_CLASS_ID_BIOS_VF_PACKAGE_CSTATE_LIMIT = "biosVfPackageCStateLimit"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_C1_E = "biosVfProcessorC1E"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_C3_REPORT = "biosVfProcessorC3Report"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_C6_REPORT = "biosVfProcessorC6Report"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_C7_REPORT = "biosVfProcessorC7Report"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_CMCI = "biosVfProcessorCMCI"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_CSTATE = "biosVfProcessorCState"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_ENERGY_CONFIGURATION = "biosVfProcessorEnergyConfiguration"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_PREFETCH_CONFIG = "biosVfProcessorPrefetchConfig"
    EP_CLASS_ID_BIOS_VF_QPILINK_FREQUENCY_SELECT = "biosVfQPILinkFrequencySelect"
    EP_CLASS_ID_BIOS_VF_QPISNOOP_MODE = "biosVfQPISnoopMode"
    EP_CLASS_ID_BIOS_VF_QUIET_BOOT = "biosVfQuietBoot"
    EP_CLASS_ID_BIOS_VF_REDIRECTION_AFTER_BIOSPOST = "biosVfRedirectionAfterBIOSPOST"
    EP_CLASS_ID_BIOS_VF_RESUME_ON_ACPOWER_LOSS = "biosVfResumeOnACPowerLoss"
    EP_CLASS_ID_BIOS_VF_SBMEZZ1_OPTION_ROM = "biosVfSBMezz1OptionROM"
    EP_CLASS_ID_BIOS_VF_SBNVME1_OPTION_ROM = "biosVfSBNVMe1OptionROM"
    EP_CLASS_ID_BIOS_VF_SIOC1_OPTION_ROM = "biosVfSIOC1OptionROM"
    EP_CLASS_ID_BIOS_VF_SIOC2_OPTION_ROM = "biosVfSIOC2OptionROM"
    EP_CLASS_ID_BIOS_VF_SCRUB_POLICIES = "biosVfScrubPolicies"
    EP_CLASS_ID_BIOS_VF_SELECT_MEMORY_RASCONFIGURATION = "biosVfSelectMemoryRASConfiguration"
    EP_CLASS_ID_BIOS_VF_SERIAL_PORT_AENABLE = "biosVfSerialPortAEnable"
    EP_CLASS_ID_BIOS_VF_SPARING_MODE = "biosVfSparingMode"
    EP_CLASS_ID_BIOS_VF_SRIOV_CONFIG = "biosVfSriovConfig"
    EP_CLASS_ID_BIOS_VF_TPMPENDING_OPERATION = "biosVfTPMPendingOperation"
    EP_CLASS_ID_BIOS_VF_TPMSUPPORT = "biosVfTPMSupport"
    EP_CLASS_ID_BIOS_VF_TRUSTED_PLATFORM_MODULE = "biosVfTrustedPlatformModule"
    EP_CLASS_ID_BIOS_VF_UCSMBOOT_MODE_CONTROL = "biosVfUCSMBootModeControl"
    EP_CLASS_ID_BIOS_VF_UCSMBOOT_ORDER_RULE_CONTROL = "biosVfUCSMBootOrderRuleControl"
    EP_CLASS_ID_BIOS_VF_UEFIOSUSE_LEGACY_VIDEO = "biosVfUEFIOSUseLegacyVideo"
    EP_CLASS_ID_BIOS_VF_USBBOOT_CONFIG = "biosVfUSBBootConfig"
    EP_CLASS_ID_BIOS_VF_USBCONFIGURATION = "biosVfUSBConfiguration"
    EP_CLASS_ID_BIOS_VF_USBFRONT_PANEL_ACCESS_LOCK = "biosVfUSBFrontPanelAccessLock"
    EP_CLASS_ID_BIOS_VF_USBPORT_CONFIGURATION = "biosVfUSBPortConfiguration"
    EP_CLASS_ID_BIOS_VF_USBSYSTEM_IDLE_POWER_OPTIMIZING_SETTING = "biosVfUSBSystemIdlePowerOptimizingSetting"
    EP_CLASS_ID_BIOS_VF_VGAPRIORITY = "biosVfVGAPriority"
    EP_CLASS_ID_BIOS_VF_WORKLOAD_CONFIGURATION = "biosVfWorkloadConfiguration"
    EP_CLASS_ID_BMC_SELCOUNTER = "bmcSELCounter"
    EP_CLASS_ID_CALLHOME_ANONYMOUS_REPORTING = "callhomeAnonymousReporting"
    EP_CLASS_ID_CALLHOME_DEST = "callhomeDest"
    EP_CLASS_ID_CALLHOME_EP = "callhomeEp"
    EP_CLASS_ID_CALLHOME_EP_FSM = "callhomeEpFsm"
    EP_CLASS_ID_CALLHOME_EP_FSM_STAGE = "callhomeEpFsmStage"
    EP_CLASS_ID_CALLHOME_EP_FSM_TASK = "callhomeEpFsmTask"
    EP_CLASS_ID_CALLHOME_ITEM = "callhomeItem"
    EP_CLASS_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY = "callhomePeriodicSystemInventory"
    EP_CLASS_ID_CALLHOME_POLICY = "callhomePolicy"
    EP_CLASS_ID_CALLHOME_PROFILE = "callhomeProfile"
    EP_CLASS_ID_CALLHOME_SMTP = "callhomeSmtp"
    EP_CLASS_ID_CALLHOME_SOURCE = "callhomeSource"
    EP_CLASS_ID_CALLHOME_TEST_ALERT = "callhomeTestAlert"
    EP_CLASS_ID_CAPABILITY_CATALOGUE = "capabilityCatalogue"
    EP_CLASS_ID_CAPABILITY_CATALOGUE_FSM = "capabilityCatalogueFsm"
    EP_CLASS_ID_CAPABILITY_CATALOGUE_FSM_STAGE = "capabilityCatalogueFsmStage"
    EP_CLASS_ID_CAPABILITY_CATALOGUE_FSM_TASK = "capabilityCatalogueFsmTask"
    EP_CLASS_ID_CAPABILITY_DEF = "capabilityDef"
    EP_CLASS_ID_CAPABILITY_EP = "capabilityEp"
    EP_CLASS_ID_CAPABILITY_FEATURE_LIMITS = "capabilityFeatureLimits"
    EP_CLASS_ID_CAPABILITY_ITEM = "capabilityItem"
    EP_CLASS_ID_CAPABILITY_MGMT_EXTENSION = "capabilityMgmtExtension"
    EP_CLASS_ID_CAPABILITY_MGMT_EXTENSION_FSM = "capabilityMgmtExtensionFsm"
    EP_CLASS_ID_CAPABILITY_MGMT_EXTENSION_FSM_STAGE = "capabilityMgmtExtensionFsmStage"
    EP_CLASS_ID_CAPABILITY_MGMT_EXTENSION_FSM_TASK = "capabilityMgmtExtensionFsmTask"
    EP_CLASS_ID_CAPABILITY_NETWORK_LIMITS = "capabilityNetworkLimits"
    EP_CLASS_ID_CAPABILITY_PROVIDER = "capabilityProvider"
    EP_CLASS_ID_CAPABILITY_STORAGE_LIMITS = "capabilityStorageLimits"
    EP_CLASS_ID_CAPABILITY_SYSTEM_LIMITS = "capabilitySystemLimits"
    EP_CLASS_ID_CAPABILITY_UPDATE = "capabilityUpdate"
    EP_CLASS_ID_CAPABILITY_UPDATER = "capabilityUpdater"
    EP_CLASS_ID_CAPABILITY_UPDATER_FSM = "capabilityUpdaterFsm"
    EP_CLASS_ID_CAPABILITY_UPDATER_FSM_STAGE = "capabilityUpdaterFsmStage"
    EP_CLASS_ID_CAPABILITY_UPDATER_FSM_TASK = "capabilityUpdaterFsmTask"
    EP_CLASS_ID_CHANGE_CHANGED_OBJECT_REF = "changeChangedObjectRef"
    EP_CLASS_ID_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY = "cimcvmediaActualMountEntry"
    EP_CLASS_ID_CIMCVMEDIA_ACTUAL_MOUNT_LIST = "cimcvmediaActualMountList"
    EP_CLASS_ID_CIMCVMEDIA_CONFIG_MOUNT_ENTRY = "cimcvmediaConfigMountEntry"
    EP_CLASS_ID_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY = "cimcvmediaExtMgmtRuleEntry"
    EP_CLASS_ID_CIMCVMEDIA_ITEM = "cimcvmediaItem"
    EP_CLASS_ID_CIMCVMEDIA_MOUNT_CONFIG = "cimcvmediaMountConfig"
    EP_CLASS_ID_CIMCVMEDIA_MOUNT_CONFIG_DEF = "cimcvmediaMountConfigDef"
    EP_CLASS_ID_CIMCVMEDIA_MOUNT_CONFIG_POLICY = "cimcvmediaMountConfigPolicy"
    EP_CLASS_ID_CIMCVMEDIA_MOUNT_INFO = "cimcvmediaMountInfo"
    EP_CLASS_ID_CLITEST_TYPE_TEST = "clitestTypeTest"
    EP_CLASS_ID_CLITEST_TYPE_TEST2 = "clitestTypeTest2"
    EP_CLASS_ID_CLITEST_TYPE_TEST_CHILD = "clitestTypeTestChild"
    EP_CLASS_ID_CLITEST_TYPE_TEST_PARENT = "clitestTypeTestParent"
    EP_CLASS_ID_COMM_CIMC_WEB_SERVICE = "commCimcWebService"
    EP_CLASS_ID_COMM_CIMXML = "commCimxml"
    EP_CLASS_ID_COMM_CLIENT = "commClient"
    EP_CLASS_ID_COMM_CLIENT_ITEM = "commClientItem"
    EP_CLASS_ID_COMM_DATE_TIME = "commDateTime"
    EP_CLASS_ID_COMM_DEFINITION = "commDefinition"
    EP_CLASS_ID_COMM_DNS = "commDns"
    EP_CLASS_ID_COMM_DNS_PROVIDER = "commDnsProvider"
    EP_CLASS_ID_COMM_EVT_CHANNEL = "commEvtChannel"
    EP_CLASS_ID_COMM_HTTP = "commHttp"
    EP_CLASS_ID_COMM_HTTPS = "commHttps"
    EP_CLASS_ID_COMM_ITEM = "commItem"
    EP_CLASS_ID_COMM_LOCALE = "commLocale"
    EP_CLASS_ID_COMM_NTP_PROVIDER = "commNtpProvider"
    EP_CLASS_ID_COMM_SHELL = "commShell"
    EP_CLASS_ID_COMM_SHELL_SVC_LIMITS = "commShellSvcLimits"
    EP_CLASS_ID_COMM_SMASH_CLP = "commSmashCLP"
    EP_CLASS_ID_COMM_SNMP = "commSnmp"
    EP_CLASS_ID_COMM_SNMP_TRAP = "commSnmpTrap"
    EP_CLASS_ID_COMM_SNMP_USER = "commSnmpUser"
    EP_CLASS_ID_COMM_SSH = "commSsh"
    EP_CLASS_ID_COMM_SVC = "commSvc"
    EP_CLASS_ID_COMM_SVC_CHANNEL = "commSvcChannel"
    EP_CLASS_ID_COMM_SVC_EP = "commSvcEp"
    EP_CLASS_ID_COMM_SVC_EP_FSM = "commSvcEpFsm"
    EP_CLASS_ID_COMM_SVC_EP_FSM_STAGE = "commSvcEpFsmStage"
    EP_CLASS_ID_COMM_SVC_EP_FSM_TASK = "commSvcEpFsmTask"
    EP_CLASS_ID_COMM_SVC_LIMITS = "commSvcLimits"
    EP_CLASS_ID_COMM_SVC_POLICY = "commSvcPolicy"
    EP_CLASS_ID_COMM_SYSLOG = "commSyslog"
    EP_CLASS_ID_COMM_SYSLOG_CLIENT = "commSyslogClient"
    EP_CLASS_ID_COMM_SYSLOG_CONSOLE = "commSyslogConsole"
    EP_CLASS_ID_COMM_SYSLOG_FILE = "commSyslogFile"
    EP_CLASS_ID_COMM_SYSLOG_MONITOR = "commSyslogMonitor"
    EP_CLASS_ID_COMM_SYSLOG_SOURCE = "commSyslogSource"
    EP_CLASS_ID_COMM_TELNET = "commTelnet"
    EP_CLASS_ID_COMM_WEB = "commWeb"
    EP_CLASS_ID_COMM_WEB_CHANNEL = "commWebChannel"
    EP_CLASS_ID_COMM_WEB_SVC_LIMITS = "commWebSvcLimits"
    EP_CLASS_ID_COMM_WSMAN = "commWsman"
    EP_CLASS_ID_COMM_XML_CL_CONN_POLICY = "commXmlClConnPolicy"
    EP_CLASS_ID_COMPUTE_ABOARD = "computeABoard"
    EP_CLASS_ID_COMPUTE_ACHASSIS_DISC_POLICY = "computeAChassisDiscPolicy"
    EP_CLASS_ID_COMPUTE_AUTOCONFIG_POLICY = "computeAutoconfigPolicy"
    EP_CLASS_ID_COMPUTE_BEH_CAP = "computeBehCap"
    EP_CLASS_ID_COMPUTE_BLADE = "computeBlade"
    EP_CLASS_ID_COMPUTE_BLADE_DISC_POLICY = "computeBladeDiscPolicy"
    EP_CLASS_ID_COMPUTE_BLADE_EP = "computeBladeEp"
    EP_CLASS_ID_COMPUTE_BLADE_FSM = "computeBladeFsm"
    EP_CLASS_ID_COMPUTE_BLADE_FSM_STAGE = "computeBladeFsmStage"
    EP_CLASS_ID_COMPUTE_BLADE_FSM_TASK = "computeBladeFsmTask"
    EP_CLASS_ID_COMPUTE_BLADE_INHERIT_POLICY = "computeBladeInheritPolicy"
    EP_CLASS_ID_COMPUTE_BLADE_POS_QUAL = "computeBladePosQual"
    EP_CLASS_ID_COMPUTE_BOARD = "computeBoard"
    EP_CLASS_ID_COMPUTE_BOARD_CONNECTOR = "computeBoardConnector"
    EP_CLASS_ID_COMPUTE_BOARD_CONTROLLER = "computeBoardController"
    EP_CLASS_ID_COMPUTE_CARTRIDGE = "computeCartridge"
    EP_CLASS_ID_COMPUTE_CHASSIS_CONN_POLICY = "computeChassisConnPolicy"
    EP_CLASS_ID_COMPUTE_CHASSIS_DISC_POLICY = "computeChassisDiscPolicy"
    EP_CLASS_ID_COMPUTE_CHASSIS_QUAL = "computeChassisQual"
    EP_CLASS_ID_COMPUTE_COMPUTE_DISC_POLICY = "computeComputeDiscPolicy"
    EP_CLASS_ID_COMPUTE_CONFIG_POLICY = "computeConfigPolicy"
    EP_CLASS_ID_COMPUTE_CONSTRAINT_DEF = "computeConstraintDef"
    EP_CLASS_ID_COMPUTE_CONTAINER = "computeContainer"
    EP_CLASS_ID_COMPUTE_DEFAULTS = "computeDefaults"
    EP_CLASS_ID_COMPUTE_DISC_POLICY = "computeDiscPolicy"
    EP_CLASS_ID_COMPUTE_EXT_BOARD = "computeExtBoard"
    EP_CLASS_ID_COMPUTE_FACTORY_RESET_OPERATION = "computeFactoryResetOperation"
    EP_CLASS_ID_COMPUTE_FW_SYNC_ACK = "computeFwSyncAck"
    EP_CLASS_ID_COMPUTE_HEALTH_LED_SENSOR_ALARM = "computeHealthLedSensorAlarm"
    EP_CLASS_ID_COMPUTE_IOHUB = "computeIOHub"
    EP_CLASS_ID_COMPUTE_IOHUB_ENV_STATS = "computeIOHubEnvStats"
    EP_CLASS_ID_COMPUTE_IOHUB_ENV_STATS_HIST = "computeIOHubEnvStatsHist"
    EP_CLASS_ID_COMPUTE_INIT_CONFIG_POLICY = "computeInitConfigPolicy"
    EP_CLASS_ID_COMPUTE_INSTANCE_ID_QUAL = "computeInstanceIdQual"
    EP_CLASS_ID_COMPUTE_ITEM = "computeItem"
    EP_CLASS_ID_COMPUTE_KVM_MGMT_POLICY = "computeKvmMgmtPolicy"
    EP_CLASS_ID_COMPUTE_LOGICAL = "computeLogical"
    EP_CLASS_ID_COMPUTE_MB_POWER_STATS = "computeMbPowerStats"
    EP_CLASS_ID_COMPUTE_MB_POWER_STATS_HIST = "computeMbPowerStatsHist"
    EP_CLASS_ID_COMPUTE_MB_TEMP_STATS = "computeMbTempStats"
    EP_CLASS_ID_COMPUTE_MB_TEMP_STATS_HIST = "computeMbTempStatsHist"
    EP_CLASS_ID_COMPUTE_MEMORY_CONFIG_POLICY = "computeMemoryConfigPolicy"
    EP_CLASS_ID_COMPUTE_MEMORY_CONFIGURATION = "computeMemoryConfiguration"
    EP_CLASS_ID_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF = "computeMemoryUnitConstraintDef"
    EP_CLASS_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS = "computePCIeFatalCompletionStats"
    EP_CLASS_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS = "computePCIeFatalProtocolStats"
    EP_CLASS_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS = "computePCIeFatalReceiveStats"
    EP_CLASS_ID_COMPUTE_PCIE_FATAL_STATS = "computePCIeFatalStats"
    EP_CLASS_ID_COMPUTE_PARTITION = "computePartition"
    EP_CLASS_ID_COMPUTE_PCI_CAP = "computePciCap"
    EP_CLASS_ID_COMPUTE_PCI_SLOT_SCAN_DEF = "computePciSlotScanDef"
    EP_CLASS_ID_COMPUTE_PHYSICAL = "computePhysical"
    EP_CLASS_ID_COMPUTE_PHYSICAL_ASSOC_CTX = "computePhysicalAssocCtx"
    EP_CLASS_ID_COMPUTE_PHYSICAL_FSM = "computePhysicalFsm"
    EP_CLASS_ID_COMPUTE_PHYSICAL_FSM_STAGE = "computePhysicalFsmStage"
    EP_CLASS_ID_COMPUTE_PHYSICAL_FSM_TASK = "computePhysicalFsmTask"
    EP_CLASS_ID_COMPUTE_PHYSICAL_QUAL = "computePhysicalQual"
    EP_CLASS_ID_COMPUTE_PLATFORM = "computePlatform"
    EP_CLASS_ID_COMPUTE_PNU_OSIMAGE = "computePnuOSImage"
    EP_CLASS_ID_COMPUTE_POOL = "computePool"
    EP_CLASS_ID_COMPUTE_POOL_POLICY_REF = "computePoolPolicyRef"
    EP_CLASS_ID_COMPUTE_POOLABLE = "computePoolable"
    EP_CLASS_ID_COMPUTE_POOLED = "computePooled"
    EP_CLASS_ID_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT = "computePooledEnclosureComputeSlot"
    EP_CLASS_ID_COMPUTE_POOLED_PHYSICAL = "computePooledPhysical"
    EP_CLASS_ID_COMPUTE_POOLED_RACK_UNIT = "computePooledRackUnit"
    EP_CLASS_ID_COMPUTE_POOLED_SLOT = "computePooledSlot"
    EP_CLASS_ID_COMPUTE_POOLING_POLICY = "computePoolingPolicy"
    EP_CLASS_ID_COMPUTE_POWER_SYNC_DEF = "computePowerSyncDef"
    EP_CLASS_ID_COMPUTE_POWER_SYNC_POLICY = "computePowerSyncPolicy"
    EP_CLASS_ID_COMPUTE_PSU_CONTROL = "computePsuControl"
    EP_CLASS_ID_COMPUTE_PSU_DEF = "computePsuDef"
    EP_CLASS_ID_COMPUTE_PSU_POLICY = "computePsuPolicy"
    EP_CLASS_ID_COMPUTE_QUAL = "computeQual"
    EP_CLASS_ID_COMPUTE_QUAL_BASE = "computeQualBase"
    EP_CLASS_ID_COMPUTE_QUAL_ITEM = "computeQualItem"
    EP_CLASS_ID_COMPUTE_QUALIFIED_POLICY = "computeQualifiedPolicy"
    EP_CLASS_ID_COMPUTE_RACK_POS_QUAL = "computeRackPosQual"
    EP_CLASS_ID_COMPUTE_RACK_QUAL = "computeRackQual"
    EP_CLASS_ID_COMPUTE_RACK_UNIT = "computeRackUnit"
    EP_CLASS_ID_COMPUTE_RACK_UNIT_FSM = "computeRackUnitFsm"
    EP_CLASS_ID_COMPUTE_RACK_UNIT_FSM_STAGE = "computeRackUnitFsmStage"
    EP_CLASS_ID_COMPUTE_RACK_UNIT_FSM_TASK = "computeRackUnitFsmTask"
    EP_CLASS_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS = "computeRackUnitMbTempStats"
    EP_CLASS_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST = "computeRackUnitMbTempStatsHist"
    EP_CLASS_ID_COMPUTE_RTC_BATTERY = "computeRtcBattery"
    EP_CLASS_ID_COMPUTE_SCRUB_POLICY = "computeScrubPolicy"
    EP_CLASS_ID_COMPUTE_SERVER = "computeServer"
    EP_CLASS_ID_COMPUTE_SERVER_DISC_POLICY = "computeServerDiscPolicy"
    EP_CLASS_ID_COMPUTE_SERVER_DISC_POLICY_FSM = "computeServerDiscPolicyFsm"
    EP_CLASS_ID_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE = "computeServerDiscPolicyFsmStage"
    EP_CLASS_ID_COMPUTE_SERVER_DISC_POLICY_FSM_TASK = "computeServerDiscPolicyFsmTask"
    EP_CLASS_ID_COMPUTE_SERVER_MGMT_POLICY = "computeServerMgmtPolicy"
    EP_CLASS_ID_COMPUTE_SERVER_TYPE_CAP = "computeServerTypeCap"
    EP_CLASS_ID_COMPUTE_SERVER_UNIT = "computeServerUnit"
    EP_CLASS_ID_COMPUTE_SERVER_UNIT_FSM = "computeServerUnitFsm"
    EP_CLASS_ID_COMPUTE_SERVER_UNIT_FSM_STAGE = "computeServerUnitFsmStage"
    EP_CLASS_ID_COMPUTE_SERVER_UNIT_FSM_TASK = "computeServerUnitFsmTask"
    EP_CLASS_ID_COMPUTE_SLOT_ENTITY = "computeSlotEntity"
    EP_CLASS_ID_COMPUTE_SLOT_QUAL = "computeSlotQual"
    EP_CLASS_ID_COMPUTE_VIRTUAL = "computeVirtual"
    EP_CLASS_ID_COMPUTE_VIRTUAL_CONTAINER = "computeVirtualContainer"
    EP_CLASS_ID_CONDITION_IMMUTABLE = "conditionImmutable"
    EP_CLASS_ID_CONDITION_INFO = "conditionInfo"
    EP_CLASS_ID_CONDITION_LOG = "conditionLog"
    EP_CLASS_ID_CONDITION_LOGGABLE = "conditionLoggable"
    EP_CLASS_ID_CONDITION_MULTI_INSTANCE_IMMUTABLE = "conditionMultiInstanceImmutable"
    EP_CLASS_ID_CONDITION_MUTABLE = "conditionMutable"
    EP_CLASS_ID_CONDITION_POLICY = "conditionPolicy"
    EP_CLASS_ID_CONDITION_REPORTABLE = "conditionReportable"
    EP_CLASS_ID_CONFIG_IMPACT = "configImpact"
    EP_CLASS_ID_CONFIG_IMPACT_RESPONSE = "configImpactResponse"
    EP_CLASS_ID_CONFIG_MANAGED_EP_IMPACT_RESPONSE = "configManagedEpImpactResponse"
    EP_CLASS_ID_CONFIG_SORTER = "configSorter"
    EP_CLASS_ID_CONTROLLER_HA_CONTROLLER = "controllerHaController"
    EP_CLASS_ID_CONTROLLER_OPERATIONAL_VERSION_HOLDER = "controllerOperationalVersionHolder"
    EP_CLASS_ID_CONTROLLER_PREFERED_VERSION_HOLDER = "controllerPreferedVersionHolder"
    EP_CLASS_ID_CPMAINT_ACK = "cpmaintAck"
    EP_CLASS_ID_CPMAINT_MAINT_POLICY = "cpmaintMaintPolicy"
    EP_CLASS_ID_DCX_FCOE_VIF_EP = "dcxFcoeVifEp"
    EP_CLASS_ID_DCX_NS = "dcxNs"
    EP_CLASS_ID_DCX_UNIVERSE = "dcxUniverse"
    EP_CLASS_ID_DCX_VIF = "dcxVIf"
    EP_CLASS_ID_DCX_VC = "dcxVc"
    EP_CLASS_ID_DCX_VIF_EP = "dcxVifEp"
    EP_CLASS_ID_DHCP_ACQUIRED = "dhcpAcquired"
    EP_CLASS_ID_DHCP_INST = "dhcpInst"
    EP_CLASS_ID_DHCP_LEASE = "dhcpLease"
    EP_CLASS_ID_DIAG_BLADE_TEST = "diagBladeTest"
    EP_CLASS_ID_DIAG_CTRL = "diagCtrl"
    EP_CLASS_ID_DIAG_NETWORK_TEST = "diagNetworkTest"
    EP_CLASS_ID_DIAG_RSLT = "diagRslt"
    EP_CLASS_ID_DIAG_RUN_POLICY = "diagRunPolicy"
    EP_CLASS_ID_DIAG_SRV_CAP_PROVIDER = "diagSrvCapProvider"
    EP_CLASS_ID_DIAG_SRV_CTRL = "diagSrvCtrl"
    EP_CLASS_ID_DIAG_TEST = "diagTest"
    EP_CLASS_ID_DOMAIN_ENVIRONMENT_FEATURE = "domainEnvironmentFeature"
    EP_CLASS_ID_DOMAIN_ENVIRONMENT_FEATURE_CONT = "domainEnvironmentFeatureCont"
    EP_CLASS_ID_DOMAIN_ENVIRONMENT_PARAM = "domainEnvironmentParam"
    EP_CLASS_ID_DOMAIN_FEATURE = "domainFeature"
    EP_CLASS_ID_DOMAIN_FEATURE_CONT = "domainFeatureCont"
    EP_CLASS_ID_DOMAIN_NETWORK_FEATURE = "domainNetworkFeature"
    EP_CLASS_ID_DOMAIN_NETWORK_FEATURE_CONT = "domainNetworkFeatureCont"
    EP_CLASS_ID_DOMAIN_NETWORK_PARAM = "domainNetworkParam"
    EP_CLASS_ID_DOMAIN_PARAMETER = "domainParameter"
    EP_CLASS_ID_DOMAIN_SERVER_FEATURE = "domainServerFeature"
    EP_CLASS_ID_DOMAIN_SERVER_FEATURE_CONT = "domainServerFeatureCont"
    EP_CLASS_ID_DOMAIN_SERVER_PARAM = "domainServerParam"
    EP_CLASS_ID_DOMAIN_STORAGE_FEATURE = "domainStorageFeature"
    EP_CLASS_ID_DOMAIN_STORAGE_FEATURE_CONT = "domainStorageFeatureCont"
    EP_CLASS_ID_DOMAIN_STORAGE_PARAM = "domainStorageParam"
    EP_CLASS_ID_DPSEC_MAC = "dpsecMac"
    EP_CLASS_ID_DUPE_SCOPE = "dupeScope"
    EP_CLASS_ID_DUPE_SCOPE_RESULT = "dupeScopeResult"
    EP_CLASS_ID_EPQOS_DEFINITION = "epqosDefinition"
    EP_CLASS_ID_EPQOS_DEFINITION_DEL_TASK = "epqosDefinitionDelTask"
    EP_CLASS_ID_EPQOS_DEFINITION_DEL_TASK_FSM = "epqosDefinitionDelTaskFsm"
    EP_CLASS_ID_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE = "epqosDefinitionDelTaskFsmStage"
    EP_CLASS_ID_EPQOS_DEFINITION_DEL_TASK_FSM_TASK = "epqosDefinitionDelTaskFsmTask"
    EP_CLASS_ID_EPQOS_DEFINITION_FSM = "epqosDefinitionFsm"
    EP_CLASS_ID_EPQOS_DEFINITION_FSM_STAGE = "epqosDefinitionFsmStage"
    EP_CLASS_ID_EPQOS_DEFINITION_FSM_TASK = "epqosDefinitionFsmTask"
    EP_CLASS_ID_EPQOS_EGRESS = "epqosEgress"
    EP_CLASS_ID_EPQOS_ITEM = "epqosItem"
    EP_CLASS_ID_EQUIPMENT_ADAPTOR_CONN_DEF = "equipmentAdaptorConnDef"
    EP_CLASS_ID_EQUIPMENT_ADAPTOR_DEF = "equipmentAdaptorDef"
    EP_CLASS_ID_EQUIPMENT_ADVANCED_BOOT_ORDER = "equipmentAdvancedBootOrder"
    EP_CLASS_ID_EQUIPMENT_ASSOC_CTX = "equipmentAssocCtx"
    EP_CLASS_ID_EQUIPMENT_AUTOCONFIG_POLICY = "equipmentAutoconfigPolicy"
    EP_CLASS_ID_EQUIPMENT_BASE_BOARD_CAP_PROVIDER = "equipmentBaseBoardCapProvider"
    EP_CLASS_ID_EQUIPMENT_BEACON_CAP_PROVIDER = "equipmentBeaconCapProvider"
    EP_CLASS_ID_EQUIPMENT_BEACON_LED = "equipmentBeaconLed"
    EP_CLASS_ID_EQUIPMENT_BEACON_LED_FSM = "equipmentBeaconLedFsm"
    EP_CLASS_ID_EQUIPMENT_BEACON_LED_FSM_STAGE = "equipmentBeaconLedFsmStage"
    EP_CLASS_ID_EQUIPMENT_BEACON_LED_FSM_TASK = "equipmentBeaconLedFsmTask"
    EP_CLASS_ID_EQUIPMENT_BEH_CAP = "equipmentBehCap"
    EP_CLASS_ID_EQUIPMENT_BINDING = "equipmentBinding"
    EP_CLASS_ID_EQUIPMENT_BIOS_DEF = "equipmentBiosDef"
    EP_CLASS_ID_EQUIPMENT_BLADE_AGLIBRARY = "equipmentBladeAGLibrary"
    EP_CLASS_ID_EQUIPMENT_BLADE_AGGREGATION_CAP_REF = "equipmentBladeAggregationCapRef"
    EP_CLASS_ID_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER = "equipmentBladeBiosCapProvider"
    EP_CLASS_ID_EQUIPMENT_BLADE_CAP_PROVIDER = "equipmentBladeCapProvider"
    EP_CLASS_ID_EQUIPMENT_BLADE_CAP_PROVIDER_TYPE_DEF = "equipmentBladeCapProviderTypeDef"
    EP_CLASS_ID_EQUIPMENT_BLADE_CONN_DEF = "equipmentBladeConnDef"
    EP_CLASS_ID_EQUIPMENT_BLADE_IOMCONN_DEF = "equipmentBladeIOMConnDef"
    EP_CLASS_ID_EQUIPMENT_BLADE_SWITCH_CONN_DEF = "equipmentBladeSwitchConnDef"
    EP_CLASS_ID_EQUIPMENT_BOARD_CONTROLLER_DEF = "equipmentBoardControllerDef"
    EP_CLASS_ID_EQUIPMENT_BOOT_DEVICE_CONSTRAINTS = "equipmentBootDeviceConstraints"
    EP_CLASS_ID_EQUIPMENT_BREAKOUT_CAP = "equipmentBreakoutCap"
    EP_CLASS_ID_EQUIPMENT_CAP_MOD_SPEC = "equipmentCapModSpec"
    EP_CLASS_ID_EQUIPMENT_CARD = "equipmentCard"
    EP_CLASS_ID_EQUIPMENT_CARTRIDGE_CAP_PROVIDER = "equipmentCartridgeCapProvider"
    EP_CLASS_ID_EQUIPMENT_CATALOG_CAP_PROVIDER = "equipmentCatalogCapProvider"
    EP_CLASS_ID_EQUIPMENT_CHASSIS = "equipmentChassis"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_ASSOC_CTX = "equipmentChassisAssocCtx"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER = "equipmentChassisCapProvider"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_FSM = "equipmentChassisFsm"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_FSM_STAGE = "equipmentChassisFsmStage"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_FSM_TASK = "equipmentChassisFsmTask"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_INHERIT_POLICY = "equipmentChassisInheritPolicy"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_ISSUES = "equipmentChassisIssues"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_POS_QUAL = "equipmentChassisPosQual"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE = "equipmentChassisProfile"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_ASSOC_CTX = "equipmentChassisProfileAssocCtx"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_BINDING = "equipmentChassisProfileBinding"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_FSM = "equipmentChassisProfileFsm"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE = "equipmentChassisProfileFsmStage"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_FSM_TASK = "equipmentChassisProfileFsmTask"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_QUAL = "equipmentChassisQual"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_STATS = "equipmentChassisStats"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_STATS_HIST = "equipmentChassisStatsHist"
    EP_CLASS_ID_EQUIPMENT_CIMC_VMEDIA = "equipmentCimcVmedia"
    EP_CLASS_ID_EQUIPMENT_CISCO_OS_OPEN_GATE = "equipmentCiscoOsOpenGate"
    EP_CLASS_ID_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER = "equipmentComputePhysicalCapProvider"
    EP_CLASS_ID_EQUIPMENT_CONFIG_POLICY = "equipmentConfigPolicy"
    EP_CLASS_ID_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER = "equipmentDbgPluginCapProvider"
    EP_CLASS_ID_EQUIPMENT_DIMM_ENTRY = "equipmentDimmEntry"
    EP_CLASS_ID_EQUIPMENT_DIMM_MAPPING = "equipmentDimmMapping"
    EP_CLASS_ID_EQUIPMENT_DISCOVERY_CAP = "equipmentDiscoveryCap"
    EP_CLASS_ID_EQUIPMENT_DOWNGRADE_CONSTRAINT = "equipmentDowngradeConstraint"
    EP_CLASS_ID_EQUIPMENT_EMBEDDED_STORAGE_DEF = "equipmentEmbeddedStorageDef"
    EP_CLASS_ID_EQUIPMENT_ENV_SENSOR = "equipmentEnvSensor"
    EP_CLASS_ID_EQUIPMENT_FAN = "equipmentFan"
    EP_CLASS_ID_EQUIPMENT_FAN_MODULE = "equipmentFanModule"
    EP_CLASS_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER = "equipmentFanModuleCapProvider"
    EP_CLASS_ID_EQUIPMENT_FAN_MODULE_DEF = "equipmentFanModuleDef"
    EP_CLASS_ID_EQUIPMENT_FAN_MODULE_STATS = "equipmentFanModuleStats"
    EP_CLASS_ID_EQUIPMENT_FAN_MODULE_STATS_HIST = "equipmentFanModuleStatsHist"
    EP_CLASS_ID_EQUIPMENT_FAN_STATS = "equipmentFanStats"
    EP_CLASS_ID_EQUIPMENT_FAN_STATS_HIST = "equipmentFanStatsHist"
    EP_CLASS_ID_EQUIPMENT_FEX = "equipmentFex"
    EP_CLASS_ID_EQUIPMENT_FEX_CAP_PROVIDER = "equipmentFexCapProvider"
    EP_CLASS_ID_EQUIPMENT_FEX_ENV_STATS = "equipmentFexEnvStats"
    EP_CLASS_ID_EQUIPMENT_FEX_ENV_STATS_HIST = "equipmentFexEnvStatsHist"
    EP_CLASS_ID_EQUIPMENT_FEX_FSM = "equipmentFexFsm"
    EP_CLASS_ID_EQUIPMENT_FEX_FSM_STAGE = "equipmentFexFsmStage"
    EP_CLASS_ID_EQUIPMENT_FEX_FSM_TASK = "equipmentFexFsmTask"
    EP_CLASS_ID_EQUIPMENT_FEX_POWER_SUMMARY = "equipmentFexPowerSummary"
    EP_CLASS_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST = "equipmentFexPowerSummaryHist"
    EP_CLASS_ID_EQUIPMENT_FEX_PSU_INPUT_STATS = "equipmentFexPsuInputStats"
    EP_CLASS_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST = "equipmentFexPsuInputStatsHist"
    EP_CLASS_ID_EQUIPMENT_FEX_SYSTEM_STATS = "equipmentFexSystemStats"
    EP_CLASS_ID_EQUIPMENT_FEX_SYSTEM_STATS_HIST = "equipmentFexSystemStatsHist"
    EP_CLASS_ID_EQUIPMENT_FIRMWARE_CONSTRAINT = "equipmentFirmwareConstraint"
    EP_CLASS_ID_EQUIPMENT_FLASH_LIFE = "equipmentFlashLife"
    EP_CLASS_ID_EQUIPMENT_FRU_CAP_PROVIDER = "equipmentFruCapProvider"
    EP_CLASS_ID_EQUIPMENT_GEM_CAP_PROVIDER = "equipmentGemCapProvider"
    EP_CLASS_ID_EQUIPMENT_GEM_PORT_CAP = "equipmentGemPortCap"
    EP_CLASS_ID_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER = "equipmentGraphicsCardCapProvider"
    EP_CLASS_ID_EQUIPMENT_GRAPHICS_CARD_CAP_REF = "equipmentGraphicsCardCapRef"
    EP_CLASS_ID_EQUIPMENT_HDDFAULT_MON_DEF = "equipmentHDDFaultMonDef"
    EP_CLASS_ID_EQUIPMENT_HEALTH_LED = "equipmentHealthLed"
    EP_CLASS_ID_EQUIPMENT_HOLDER = "equipmentHolder"
    EP_CLASS_ID_EQUIPMENT_HOLDER_CAP_PROVIDER = "equipmentHolderCapProvider"
    EP_CLASS_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER = "equipmentHostIfCapProvider"
    EP_CLASS_ID_EQUIPMENT_HW_CAP_DERIVATIVE_PROVIDER = "equipmentHwCapDerivativeProvider"
    EP_CLASS_ID_EQUIPMENT_HW_CAP_PROVIDER = "equipmentHwCapProvider"
    EP_CLASS_ID_EQUIPMENT_HW_REVISION_MODIFIER = "equipmentHwRevisionModifier"
    EP_CLASS_ID_EQUIPMENT_IOCARD = "equipmentIOCard"
    EP_CLASS_ID_EQUIPMENT_IOCARD_BASE = "equipmentIOCardBase"
    EP_CLASS_ID_EQUIPMENT_IOCARD_BASE_FSM = "equipmentIOCardBaseFsm"
    EP_CLASS_ID_EQUIPMENT_IOCARD_BASE_FSM_STAGE = "equipmentIOCardBaseFsmStage"
    EP_CLASS_ID_EQUIPMENT_IOCARD_BASE_FSM_TASK = "equipmentIOCardBaseFsmTask"
    EP_CLASS_ID_EQUIPMENT_IOCARD_CAP_PROVIDER = "equipmentIOCardCapProvider"
    EP_CLASS_ID_EQUIPMENT_IOCARD_FSM = "equipmentIOCardFsm"
    EP_CLASS_ID_EQUIPMENT_IOCARD_FSM_STAGE = "equipmentIOCardFsmStage"
    EP_CLASS_ID_EQUIPMENT_IOCARD_FSM_TASK = "equipmentIOCardFsmTask"
    EP_CLASS_ID_EQUIPMENT_IOCARD_STATS = "equipmentIOCardStats"
    EP_CLASS_ID_EQUIPMENT_IOCARD_STATS_HIST = "equipmentIOCardStatsHist"
    EP_CLASS_ID_EQUIPMENT_IOCARD_TYPE_DEF = "equipmentIOCardTypeDef"
    EP_CLASS_ID_EQUIPMENT_IOEXPANDER = "equipmentIOExpander"
    EP_CLASS_ID_EQUIPMENT_IOEXPANDER_CAP_PROVIDER = "equipmentIOExpanderCapProvider"
    EP_CLASS_ID_EQUIPMENT_INBAND_MGMT_CAP = "equipmentInbandMgmtCap"
    EP_CLASS_ID_EQUIPMENT_INDICATOR_LED = "equipmentIndicatorLed"
    EP_CLASS_ID_EQUIPMENT_INIT_CONFIG_POLICY = "equipmentInitConfigPolicy"
    EP_CLASS_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER = "equipmentIntegratedComponentCapProvider"
    EP_CLASS_ID_EQUIPMENT_ITEM = "equipmentItem"
    EP_CLASS_ID_EQUIPMENT_KVM_MGMT_CAP = "equipmentKvmMgmtCap"
    EP_CLASS_ID_EQUIPMENT_LED = "equipmentLed"
    EP_CLASS_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER = "equipmentLocalDiskCapProvider"
    EP_CLASS_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER = "equipmentLocalDiskControllerCapProvider"
    EP_CLASS_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_REF = "equipmentLocalDiskControllerCapRef"
    EP_CLASS_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF = "equipmentLocalDiskControllerDef"
    EP_CLASS_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_TYPE_DEF = "equipmentLocalDiskControllerTypeDef"
    EP_CLASS_ID_EQUIPMENT_LOCAL_DISK_DEF = "equipmentLocalDiskDef"
    EP_CLASS_ID_EQUIPMENT_LOCATOR_LED = "equipmentLocatorLed"
    EP_CLASS_ID_EQUIPMENT_LOCATOR_LED_FSM = "equipmentLocatorLedFsm"
    EP_CLASS_ID_EQUIPMENT_LOCATOR_LED_FSM_STAGE = "equipmentLocatorLedFsmStage"
    EP_CLASS_ID_EQUIPMENT_LOCATOR_LED_FSM_TASK = "equipmentLocatorLedFsmTask"
    EP_CLASS_ID_EQUIPMENT_MANUFACTURING_DEF = "equipmentManufacturingDef"
    EP_CLASS_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER = "equipmentMemoryUnitCapProvider"
    EP_CLASS_ID_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF = "equipmentMemoryUnitDiscoveryModifierDef"
    EP_CLASS_ID_EQUIPMENT_MGMT_CAP_PROVIDER = "equipmentMgmtCapProvider"
    EP_CLASS_ID_EQUIPMENT_MGMT_EXT_CAP_PROVIDER = "equipmentMgmtExtCapProvider"
    EP_CLASS_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS = "equipmentNetworkElementFanStats"
    EP_CLASS_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST = "equipmentNetworkElementFanStatsHist"
    EP_CLASS_ID_EQUIPMENT_NON_COPPER_PASSIVE_CAP = "equipmentNonCopperPassiveCap"
    EP_CLASS_ID_EQUIPMENT_ONBOARD_DEVICE_DEF = "equipmentOnboardDeviceDef"
    EP_CLASS_ID_EQUIPMENT_POST = "equipmentPOST"
    EP_CLASS_ID_EQUIPMENT_POSTCODE = "equipmentPOSTCode"
    EP_CLASS_ID_EQUIPMENT_POSTCODE_CONTAINER = "equipmentPOSTCodeContainer"
    EP_CLASS_ID_EQUIPMENT_POSTCODE_DATA = "equipmentPOSTCodeData"
    EP_CLASS_ID_EQUIPMENT_POSTCODE_REPORTER = "equipmentPOSTCodeReporter"
    EP_CLASS_ID_EQUIPMENT_POSTCODE_TEMPLATE = "equipmentPOSTCodeTemplate"
    EP_CLASS_ID_EQUIPMENT_PCI_DEF = "equipmentPciDef"
    EP_CLASS_ID_EQUIPMENT_PCI_SLOT_ID_ENTRY = "equipmentPciSlotIdEntry"
    EP_CLASS_ID_EQUIPMENT_PCI_SLOT_ID_MAPPING = "equipmentPciSlotIdMapping"
    EP_CLASS_ID_EQUIPMENT_PCI_SLOT_SUB_OEMID_ENTRY = "equipmentPciSlotSubOEMIdEntry"
    EP_CLASS_ID_EQUIPMENT_PFC_MMU_CAP = "equipmentPfcMmuCap"
    EP_CLASS_ID_EQUIPMENT_PHYS_DEVICES_PER_BOARD = "equipmentPhysDevicesPerBoard"
    EP_CLASS_ID_EQUIPMENT_PHYSICAL_DEF = "equipmentPhysicalDef"
    EP_CLASS_ID_EQUIPMENT_PHYSICAL_QUAL = "equipmentPhysicalQual"
    EP_CLASS_ID_EQUIPMENT_PICTURE = "equipmentPicture"
    EP_CLASS_ID_EQUIPMENT_POOL = "equipmentPool"
    EP_CLASS_ID_EQUIPMENT_POOL_POLICY_REF = "equipmentPoolPolicyRef"
    EP_CLASS_ID_EQUIPMENT_POOLABLE = "equipmentPoolable"
    EP_CLASS_ID_EQUIPMENT_POOLED = "equipmentPooled"
    EP_CLASS_ID_EQUIPMENT_POOLED_CHASSIS = "equipmentPooledChassis"
    EP_CLASS_ID_EQUIPMENT_POOLED_PHYSICAL = "equipmentPooledPhysical"
    EP_CLASS_ID_EQUIPMENT_POOLING_POLICY = "equipmentPoolingPolicy"
    EP_CLASS_ID_EQUIPMENT_PORT_CAP = "equipmentPortCap"
    EP_CLASS_ID_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF = "equipmentPortGroupAggregationDef"
    EP_CLASS_ID_EQUIPMENT_PORT_GROUP_DEF = "equipmentPortGroupDef"
    EP_CLASS_ID_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF = "equipmentPortGroupSwComplexDef"
    EP_CLASS_ID_EQUIPMENT_PORT_SW_COMPLEX_REF = "equipmentPortSwComplexRef"
    EP_CLASS_ID_EQUIPMENT_POWER_CAP_DEF = "equipmentPowerCapDef"
    EP_CLASS_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER = "equipmentProcessorUnitCapProvider"
    EP_CLASS_ID_EQUIPMENT_PROCESSOR_UNIT_DEF = "equipmentProcessorUnitDef"
    EP_CLASS_ID_EQUIPMENT_PSU = "equipmentPsu"
    EP_CLASS_ID_EQUIPMENT_PSU_CAP_PROVIDER = "equipmentPsuCapProvider"
    EP_CLASS_ID_EQUIPMENT_PSU_DEF = "equipmentPsuDef"
    EP_CLASS_ID_EQUIPMENT_PSU_FSM = "equipmentPsuFsm"
    EP_CLASS_ID_EQUIPMENT_PSU_FSM_STAGE = "equipmentPsuFsmStage"
    EP_CLASS_ID_EQUIPMENT_PSU_FSM_TASK = "equipmentPsuFsmTask"
    EP_CLASS_ID_EQUIPMENT_PSU_INPUT_STATS = "equipmentPsuInputStats"
    EP_CLASS_ID_EQUIPMENT_PSU_INPUT_STATS_HIST = "equipmentPsuInputStatsHist"
    EP_CLASS_ID_EQUIPMENT_PSU_OUTPUT_STATS = "equipmentPsuOutputStats"
    EP_CLASS_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST = "equipmentPsuOutputStatsHist"
    EP_CLASS_ID_EQUIPMENT_PSU_STATS = "equipmentPsuStats"
    EP_CLASS_ID_EQUIPMENT_PSU_STATS_HIST = "equipmentPsuStatsHist"
    EP_CLASS_ID_EQUIPMENT_QUAL = "equipmentQual"
    EP_CLASS_ID_EQUIPMENT_QUAL_BASE = "equipmentQualBase"
    EP_CLASS_ID_EQUIPMENT_QUAL_ITEM = "equipmentQualItem"
    EP_CLASS_ID_EQUIPMENT_QUALIFIED_POLICY = "equipmentQualifiedPolicy"
    EP_CLASS_ID_EQUIPMENT_RACK_FAN_MODULE_DEF = "equipmentRackFanModuleDef"
    EP_CLASS_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER = "equipmentRackUnitCapProvider"
    EP_CLASS_ID_EQUIPMENT_RACK_UNIT_FAN_STATS = "equipmentRackUnitFanStats"
    EP_CLASS_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST = "equipmentRackUnitFanStatsHist"
    EP_CLASS_ID_EQUIPMENT_RACK_UNIT_PSU_STATS = "equipmentRackUnitPsuStats"
    EP_CLASS_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST = "equipmentRackUnitPsuStatsHist"
    EP_CLASS_ID_EQUIPMENT_RAID_DEF = "equipmentRaidDef"
    EP_CLASS_ID_EQUIPMENT_REQUIREMENT = "equipmentRequirement"
    EP_CLASS_ID_EQUIPMENT_SECURE_BOOT = "equipmentSecureBoot"
    EP_CLASS_ID_EQUIPMENT_SECURE_CONTROLLER = "equipmentSecureController"
    EP_CLASS_ID_EQUIPMENT_SECURITY_UNIT_CAP_PROVIDER = "equipmentSecurityUnitCapProvider"
    EP_CLASS_ID_EQUIPMENT_SERVER_CORRECT_UUID_BEHAVIOR = "equipmentServerCorrectUuidBehavior"
    EP_CLASS_ID_EQUIPMENT_SERVER_FEATURE_CAP = "equipmentServerFeatureCap"
    EP_CLASS_ID_EQUIPMENT_SERVER_PORT_CAP_PROVIDER = "equipmentServerPortCapProvider"
    EP_CLASS_ID_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER = "equipmentServerUnitCapProvider"
    EP_CLASS_ID_EQUIPMENT_SERVICE_DEF = "equipmentServiceDef"
    EP_CLASS_ID_EQUIPMENT_SHARED_IOMODULE = "equipmentSharedIOModule"
    EP_CLASS_ID_EQUIPMENT_SIOC_TEMP_STATS = "equipmentSiocTempStats"
    EP_CLASS_ID_EQUIPMENT_SIOC_TEMP_STATS_HIST = "equipmentSiocTempStatsHist"
    EP_CLASS_ID_EQUIPMENT_SLOT_ARRAY = "equipmentSlotArray"
    EP_CLASS_ID_EQUIPMENT_SLOT_ARRAY_REF = "equipmentSlotArrayRef"
    EP_CLASS_ID_EQUIPMENT_SLOT_ENCLOSURE = "equipmentSlotEnclosure"
    EP_CLASS_ID_EQUIPMENT_STATEFUL = "equipmentStateful"
    EP_CLASS_ID_EQUIPMENT_STATEFUL_BLADE_COMP = "equipmentStatefulBladeComp"
    EP_CLASS_ID_EQUIPMENT_STATEFUL_CH_COMP = "equipmentStatefulChComp"
    EP_CLASS_ID_EQUIPMENT_STORAGE_CONTROLLER_CONFIG = "equipmentStorageControllerConfig"
    EP_CLASS_ID_EQUIPMENT_STORAGE_CONTROLLER_SLOT_DEF = "equipmentStorageControllerSlotDef"
    EP_CLASS_ID_EQUIPMENT_STORAGE_ENC_CAP_PROVIDER = "equipmentStorageEncCapProvider"
    EP_CLASS_ID_EQUIPMENT_STORAGE_LIMIT_CAP = "equipmentStorageLimitCap"
    EP_CLASS_ID_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_PROVIDER = "equipmentStorageSasExpanderCapProvider"
    EP_CLASS_ID_EQUIPMENT_STORAGE_SAS_EXPANDER_CAP_REF = "equipmentStorageSasExpanderCapRef"
    EP_CLASS_ID_EQUIPMENT_STORAGE_SAS_EXPANDER_DEF = "equipmentStorageSasExpanderDef"
    EP_CLASS_ID_EQUIPMENT_SWITCH_CAP = "equipmentSwitchCap"
    EP_CLASS_ID_EQUIPMENT_SWITCH_CAP_PROVIDER = "equipmentSwitchCapProvider"
    EP_CLASS_ID_EQUIPMENT_SWITCH_CARD = "equipmentSwitchCard"
    EP_CLASS_ID_EQUIPMENT_SWITCH_IOCARD = "equipmentSwitchIOCard"
    EP_CLASS_ID_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER = "equipmentSwitchIOCardCapProvider"
    EP_CLASS_ID_EQUIPMENT_SWITCH_IOCARD_FSM = "equipmentSwitchIOCardFsm"
    EP_CLASS_ID_EQUIPMENT_SWITCH_IOCARD_FSM_STAGE = "equipmentSwitchIOCardFsmStage"
    EP_CLASS_ID_EQUIPMENT_SWITCH_IOCARD_FSM_TASK = "equipmentSwitchIOCardFsmTask"
    EP_CLASS_ID_EQUIPMENT_SWITCH_TYPE_DEF = "equipmentSwitchTypeDef"
    EP_CLASS_ID_EQUIPMENT_SYSTEM_IOCONTROLLER = "equipmentSystemIOController"
    EP_CLASS_ID_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM = "equipmentSystemIOControllerFsm"
    EP_CLASS_ID_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_STAGE = "equipmentSystemIOControllerFsmStage"
    EP_CLASS_ID_EQUIPMENT_SYSTEM_IOCONTROLLER_FSM_TASK = "equipmentSystemIOControllerFsmTask"
    EP_CLASS_ID_EQUIPMENT_TIER = "equipmentTier"
    EP_CLASS_ID_EQUIPMENT_TPM = "equipmentTpm"
    EP_CLASS_ID_EQUIPMENT_TPM_CAP_PROVIDER = "equipmentTpmCapProvider"
    EP_CLASS_ID_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER = "equipmentUnifiedPortCapProvider"
    EP_CLASS_ID_EQUIPMENT_UUID_FEATURE_CAP = "equipmentUuidFeatureCap"
    EP_CLASS_ID_EQUIPMENT_VERSION_CONSTRAINT = "equipmentVersionConstraint"
    EP_CLASS_ID_EQUIPMENT_XCVR = "equipmentXcvr"
    EP_CLASS_ID_ETHER_CIO_EP = "etherCIoEp"
    EP_CLASS_ID_ETHER_CONFIG = "etherConfig"
    EP_CLASS_ID_ETHER_ERR_STATS = "etherErrStats"
    EP_CLASS_ID_ETHER_ERR_STATS_HIST = "etherErrStatsHist"
    EP_CLASS_ID_ETHER_EXTERNAL_EP = "etherExternalEp"
    EP_CLASS_ID_ETHER_EXTERNAL_PC = "etherExternalPc"
    EP_CLASS_ID_ETHER_FCOE_INTERFACE_STATS = "etherFcoeInterfaceStats"
    EP_CLASS_ID_ETHER_FCOE_INTERFACE_STATS_HIST = "etherFcoeInterfaceStatsHist"
    EP_CLASS_ID_ETHER_IF_CONFIG = "etherIfConfig"
    EP_CLASS_ID_ETHER_INT_FIO_EP = "etherIntFIoEp"
    EP_CLASS_ID_ETHER_INTERNAL_PC = "etherInternalPc"
    EP_CLASS_ID_ETHER_LOSS_STATS = "etherLossStats"
    EP_CLASS_ID_ETHER_LOSS_STATS_HIST = "etherLossStatsHist"
    EP_CLASS_ID_ETHER_NI_ERR_STATS = "etherNiErrStats"
    EP_CLASS_ID_ETHER_NI_ERR_STATS_HIST = "etherNiErrStatsHist"
    EP_CLASS_ID_ETHER_NIC_IF_CONFIG = "etherNicIfConfig"
    EP_CLASS_ID_ETHER_PIO = "etherPIo"
    EP_CLASS_ID_ETHER_PIO_END_POINT = "etherPIoEndPoint"
    EP_CLASS_ID_ETHER_PIO_EP = "etherPIoEp"
    EP_CLASS_ID_ETHER_PIO_FSM = "etherPIoFsm"
    EP_CLASS_ID_ETHER_PIO_FSM_STAGE = "etherPIoFsmStage"
    EP_CLASS_ID_ETHER_PAUSE_STATS = "etherPauseStats"
    EP_CLASS_ID_ETHER_PAUSE_STATS_HIST = "etherPauseStatsHist"
    EP_CLASS_ID_ETHER_PC = "etherPc"
    EP_CLASS_ID_ETHER_PORT_CHAN_ID_ELEM = "etherPortChanIdElem"
    EP_CLASS_ID_ETHER_PORT_CHAN_ID_UNIVERSE = "etherPortChanIdUniverse"
    EP_CLASS_ID_ETHER_RX_STATS = "etherRxStats"
    EP_CLASS_ID_ETHER_RX_STATS_HIST = "etherRxStatsHist"
    EP_CLASS_ID_ETHER_SERVER_INT_FIO = "etherServerIntFIo"
    EP_CLASS_ID_ETHER_SERVER_INT_FIO_FSM = "etherServerIntFIoFsm"
    EP_CLASS_ID_ETHER_SERVER_INT_FIO_FSM_STAGE = "etherServerIntFIoFsmStage"
    EP_CLASS_ID_ETHER_SERVER_INT_FIO_FSM_TASK = "etherServerIntFIoFsmTask"
    EP_CLASS_ID_ETHER_SERVER_INT_FIO_PC = "etherServerIntFIoPc"
    EP_CLASS_ID_ETHER_SERVER_INT_FIO_PC_EP = "etherServerIntFIoPcEp"
    EP_CLASS_ID_ETHER_SW_IF_CONFIG = "etherSwIfConfig"
    EP_CLASS_ID_ETHER_SWITCH_INT_FIO = "etherSwitchIntFIo"
    EP_CLASS_ID_ETHER_SWITCH_INT_FIO_PC = "etherSwitchIntFIoPc"
    EP_CLASS_ID_ETHER_SWITCH_INT_FIO_PC_EP = "etherSwitchIntFIoPcEp"
    EP_CLASS_ID_ETHER_TX_STATS = "etherTxStats"
    EP_CLASS_ID_ETHER_TX_STATS_HIST = "etherTxStatsHist"
    EP_CLASS_ID_EVENT_EP_CTRL = "eventEpCtrl"
    EP_CLASS_ID_EVENT_HOLDER = "eventHolder"
    EP_CLASS_ID_EVENT_INST = "eventInst"
    EP_CLASS_ID_EVENT_LOG = "eventLog"
    EP_CLASS_ID_EVENT_POLICY = "eventPolicy"
    EP_CLASS_ID_EVENT_RECORD = "eventRecord"
    EP_CLASS_ID_EXTMGMT_ARP_TARGETS = "extmgmtArpTargets"
    EP_CLASS_ID_EXTMGMT_GATEWAY_PING = "extmgmtGatewayPing"
    EP_CLASS_ID_EXTMGMT_IF = "extmgmtIf"
    EP_CLASS_ID_EXTMGMT_IF_MON_POLICY = "extmgmtIfMonPolicy"
    EP_CLASS_ID_EXTMGMT_MII_STATUS = "extmgmtMiiStatus"
    EP_CLASS_ID_EXTMGMT_NDISC_TARGETS = "extmgmtNdiscTargets"
    EP_CLASS_ID_EXTPOL_CLIENT = "extpolClient"
    EP_CLASS_ID_EXTPOL_CLIENT_CONT = "extpolClientCont"
    EP_CLASS_ID_EXTPOL_CONNECTOR = "extpolConnector"
    EP_CLASS_ID_EXTPOL_CONNECTOR_CONTAINER = "extpolConnectorContainer"
    EP_CLASS_ID_EXTPOL_CONTROLLER = "extpolController"
    EP_CLASS_ID_EXTPOL_CONTROLLER_CONT = "extpolControllerCont"
    EP_CLASS_ID_EXTPOL_EP = "extpolEp"
    EP_CLASS_ID_EXTPOL_EP_FSM = "extpolEpFsm"
    EP_CLASS_ID_EXTPOL_EP_FSM_STAGE = "extpolEpFsmStage"
    EP_CLASS_ID_EXTPOL_EP_FSM_TASK = "extpolEpFsmTask"
    EP_CLASS_ID_EXTPOL_PROVIDER = "extpolProvider"
    EP_CLASS_ID_EXTPOL_PROVIDER_CONT = "extpolProviderCont"
    EP_CLASS_ID_EXTPOL_PROVIDER_FSM = "extpolProviderFsm"
    EP_CLASS_ID_EXTPOL_PROVIDER_FSM_STAGE = "extpolProviderFsmStage"
    EP_CLASS_ID_EXTPOL_PROVIDER_FSM_TASK = "extpolProviderFsmTask"
    EP_CLASS_ID_EXTPOL_REGISTRY = "extpolRegistry"
    EP_CLASS_ID_EXTPOL_REGISTRY_FSM = "extpolRegistryFsm"
    EP_CLASS_ID_EXTPOL_REGISTRY_FSM_STAGE = "extpolRegistryFsmStage"
    EP_CLASS_ID_EXTPOL_REGISTRY_FSM_TASK = "extpolRegistryFsmTask"
    EP_CLASS_ID_EXTPOL_SVC = "extpolSvc"
    EP_CLASS_ID_EXTPOL_SYSTEM_CONTEXT = "extpolSystemContext"
    EP_CLASS_ID_EXTVMM_EP = "extvmmEp"
    EP_CLASS_ID_EXTVMM_EP_FSM = "extvmmEpFsm"
    EP_CLASS_ID_EXTVMM_EP_FSM_STAGE = "extvmmEpFsmStage"
    EP_CLASS_ID_EXTVMM_EP_FSM_TASK = "extvmmEpFsmTask"
    EP_CLASS_ID_EXTVMM_FNDREFERENCE = "extvmmFNDReference"
    EP_CLASS_ID_EXTVMM_FABRIC_NETWORK = "extvmmFabricNetwork"
    EP_CLASS_ID_EXTVMM_FABRIC_NETWORK_DEFINITION = "extvmmFabricNetworkDefinition"
    EP_CLASS_ID_EXTVMM_KEY_INST = "extvmmKeyInst"
    EP_CLASS_ID_EXTVMM_KEY_RING = "extvmmKeyRing"
    EP_CLASS_ID_EXTVMM_KEY_STORE = "extvmmKeyStore"
    EP_CLASS_ID_EXTVMM_KEY_STORE_FSM = "extvmmKeyStoreFsm"
    EP_CLASS_ID_EXTVMM_KEY_STORE_FSM_STAGE = "extvmmKeyStoreFsmStage"
    EP_CLASS_ID_EXTVMM_KEY_STORE_FSM_TASK = "extvmmKeyStoreFsmTask"
    EP_CLASS_ID_EXTVMM_MASTER_EXT_KEY = "extvmmMasterExtKey"
    EP_CLASS_ID_EXTVMM_MASTER_EXT_KEY_FSM = "extvmmMasterExtKeyFsm"
    EP_CLASS_ID_EXTVMM_MASTER_EXT_KEY_FSM_STAGE = "extvmmMasterExtKeyFsmStage"
    EP_CLASS_ID_EXTVMM_MASTER_EXT_KEY_FSM_TASK = "extvmmMasterExtKeyFsmTask"
    EP_CLASS_ID_EXTVMM_NETWORK_SETS = "extvmmNetworkSets"
    EP_CLASS_ID_EXTVMM_NETWORK_SETS_FSM = "extvmmNetworkSetsFsm"
    EP_CLASS_ID_EXTVMM_NETWORK_SETS_FSM_STAGE = "extvmmNetworkSetsFsmStage"
    EP_CLASS_ID_EXTVMM_NETWORK_SETS_FSM_TASK = "extvmmNetworkSetsFsmTask"
    EP_CLASS_ID_EXTVMM_PROVIDER = "extvmmProvider"
    EP_CLASS_ID_EXTVMM_PROVIDER_FSM = "extvmmProviderFsm"
    EP_CLASS_ID_EXTVMM_PROVIDER_FSM_STAGE = "extvmmProviderFsmStage"
    EP_CLASS_ID_EXTVMM_PROVIDER_FSM_TASK = "extvmmProviderFsmTask"
    EP_CLASS_ID_EXTVMM_SWITCH_DEL_TASK = "extvmmSwitchDelTask"
    EP_CLASS_ID_EXTVMM_SWITCH_DEL_TASK_FSM = "extvmmSwitchDelTaskFsm"
    EP_CLASS_ID_EXTVMM_SWITCH_DEL_TASK_FSM_STAGE = "extvmmSwitchDelTaskFsmStage"
    EP_CLASS_ID_EXTVMM_SWITCH_DEL_TASK_FSM_TASK = "extvmmSwitchDelTaskFsmTask"
    EP_CLASS_ID_EXTVMM_SWITCH_SET = "extvmmSwitchSet"
    EP_CLASS_ID_EXTVMM_UP_LINK_PP = "extvmmUpLinkPP"
    EP_CLASS_ID_EXTVMM_VMNDREF = "extvmmVMNDRef"
    EP_CLASS_ID_EXTVMM_VMNETWORK = "extvmmVMNetwork"
    EP_CLASS_ID_EXTVMM_VMNETWORK_DEFINITION = "extvmmVMNetworkDefinition"
    EP_CLASS_ID_EXTVMM_VMNETWORK_SETS = "extvmmVMNetworkSets"
    EP_CLASS_ID_FABRIC_ADCE_SW_SRV_EP = "fabricADceSwSrvEp"
    EP_CLASS_ID_FABRIC_AETH_ESTC_EP = "fabricAEthEstcEp"
    EP_CLASS_ID_FABRIC_AETH_LAN_EP = "fabricAEthLanEp"
    EP_CLASS_ID_FABRIC_AFC_ESTC_EP = "fabricAFcEstcEp"
    EP_CLASS_ID_FABRIC_AFC_SAN_EP = "fabricAFcSanEp"
    EP_CLASS_ID_FABRIC_AFCOE_ESTC_EP = "fabricAFcoeEstcEp"
    EP_CLASS_ID_FABRIC_AFCOE_SAN_EP = "fabricAFcoeSanEp"
    EP_CLASS_ID_FABRIC_AVLAN = "fabricAVlan"
    EP_CLASS_ID_FABRIC_AVSAN = "fabricAVsan"
    EP_CLASS_ID_FABRIC_BHVLAN = "fabricBHVlan"
    EP_CLASS_ID_FABRIC_BREAKOUT = "fabricBreakout"
    EP_CLASS_ID_FABRIC_CIO_EP = "fabricCIoEp"
    EP_CLASS_ID_FABRIC_CABLING = "fabricCabling"
    EP_CLASS_ID_FABRIC_CABLING_SW = "fabricCablingSw"
    EP_CLASS_ID_FABRIC_CARTRIDGE_PH_EP = "fabricCartridgePhEp"
    EP_CLASS_ID_FABRIC_CARTRIDGE_SLOT_EP = "fabricCartridgeSlotEp"
    EP_CLASS_ID_FABRIC_CARTRIDGE_SLOT_EP_FSM = "fabricCartridgeSlotEpFsm"
    EP_CLASS_ID_FABRIC_CARTRIDGE_SLOT_EP_FSM_STAGE = "fabricCartridgeSlotEpFsmStage"
    EP_CLASS_ID_FABRIC_CARTRIDGE_SLOT_EP_FSM_TASK = "fabricCartridgeSlotEpFsmTask"
    EP_CLASS_ID_FABRIC_CDP_LINK_POLICY = "fabricCdpLinkPolicy"
    EP_CLASS_ID_FABRIC_CHANGED_OBJECT_REF = "fabricChangedObjectRef"
    EP_CLASS_ID_FABRIC_CHASSIS_EP = "fabricChassisEp"
    EP_CLASS_ID_FABRIC_CLOUD = "fabricCloud"
    EP_CLASS_ID_FABRIC_COMPUTE_EP = "fabricComputeEp"
    EP_CLASS_ID_FABRIC_COMPUTE_MSLOT_EP = "fabricComputeMSlotEp"
    EP_CLASS_ID_FABRIC_COMPUTE_MSLOT_EP_FSM = "fabricComputeMSlotEpFsm"
    EP_CLASS_ID_FABRIC_COMPUTE_MSLOT_EP_FSM_STAGE = "fabricComputeMSlotEpFsmStage"
    EP_CLASS_ID_FABRIC_COMPUTE_MSLOT_EP_FSM_TASK = "fabricComputeMSlotEpFsmTask"
    EP_CLASS_ID_FABRIC_COMPUTE_PH_EP = "fabricComputePhEp"
    EP_CLASS_ID_FABRIC_COMPUTE_SLOT_EP = "fabricComputeSlotEp"
    EP_CLASS_ID_FABRIC_COMPUTE_SLOT_EP_FSM = "fabricComputeSlotEpFsm"
    EP_CLASS_ID_FABRIC_COMPUTE_SLOT_EP_FSM_STAGE = "fabricComputeSlotEpFsmStage"
    EP_CLASS_ID_FABRIC_COMPUTE_SLOT_EP_FSM_TASK = "fabricComputeSlotEpFsmTask"
    EP_CLASS_ID_FABRIC_DCE_SRV = "fabricDceSrv"
    EP_CLASS_ID_FABRIC_DCE_SW_SRV = "fabricDceSwSrv"
    EP_CLASS_ID_FABRIC_DCE_SW_SRV_EP = "fabricDceSwSrvEp"
    EP_CLASS_ID_FABRIC_DCE_SW_SRV_PC = "fabricDceSwSrvPc"
    EP_CLASS_ID_FABRIC_DCE_SW_SRV_PC_EP = "fabricDceSwSrvPcEp"
    EP_CLASS_ID_FABRIC_DOMAIN = "fabricDomain"
    EP_CLASS_ID_FABRIC_EP = "fabricEp"
    EP_CLASS_ID_FABRIC_EP_MGR = "fabricEpMgr"
    EP_CLASS_ID_FABRIC_EP_MGR_FSM = "fabricEpMgrFsm"
    EP_CLASS_ID_FABRIC_EP_MGR_FSM_STAGE = "fabricEpMgrFsmStage"
    EP_CLASS_ID_FABRIC_EP_MGR_FSM_TASK = "fabricEpMgrFsmTask"
    EP_CLASS_ID_FABRIC_EP_VLAN = "fabricEpVlan"
    EP_CLASS_ID_FABRIC_EP_VSAN = "fabricEpVsan"
    EP_CLASS_ID_FABRIC_EQUIPMENT_EP = "fabricEquipmentEp"
    EP_CLASS_ID_FABRIC_ESTC_EP = "fabricEstcEp"
    EP_CLASS_ID_FABRIC_ESTC_PC = "fabricEstcPc"
    EP_CLASS_ID_FABRIC_ETH_CDP_POLICY = "fabricEthCdpPolicy"
    EP_CLASS_ID_FABRIC_ETH_ESTC = "fabricEthEstc"
    EP_CLASS_ID_FABRIC_ETH_ESTC_CLOUD = "fabricEthEstcCloud"
    EP_CLASS_ID_FABRIC_ETH_ESTC_EP = "fabricEthEstcEp"
    EP_CLASS_ID_FABRIC_ETH_ESTC_PC = "fabricEthEstcPc"
    EP_CLASS_ID_FABRIC_ETH_ESTC_PC_EP = "fabricEthEstcPcEp"
    EP_CLASS_ID_FABRIC_ETH_FLOW_MON_LAN = "fabricEthFlowMonLan"
    EP_CLASS_ID_FABRIC_ETH_FLOW_MON_SRC_REF = "fabricEthFlowMonSrcRef"
    EP_CLASS_ID_FABRIC_ETH_LAN = "fabricEthLan"
    EP_CLASS_ID_FABRIC_ETH_LAN_EP = "fabricEthLanEp"
    EP_CLASS_ID_FABRIC_ETH_LAN_FLOW_MON = "fabricEthLanFlowMon"
    EP_CLASS_ID_FABRIC_ETH_LAN_FLOW_MON_COLLECTOR = "fabricEthLanFlowMonCollector"
    EP_CLASS_ID_FABRIC_ETH_LAN_FLOW_MON_EXPORTER = "fabricEthLanFlowMonExporter"
    EP_CLASS_ID_FABRIC_ETH_LAN_FLOW_MON_SRC_EP = "fabricEthLanFlowMonSrcEp"
    EP_CLASS_ID_FABRIC_ETH_LAN_FLOW_MONITOR = "fabricEthLanFlowMonitor"
    EP_CLASS_ID_FABRIC_ETH_LAN_FLOW_MONITORING = "fabricEthLanFlowMonitoring"
    EP_CLASS_ID_FABRIC_ETH_LAN_PC = "fabricEthLanPc"
    EP_CLASS_ID_FABRIC_ETH_LAN_PC_EP = "fabricEthLanPcEp"
    EP_CLASS_ID_FABRIC_ETH_LINK_POLICY = "fabricEthLinkPolicy"
    EP_CLASS_ID_FABRIC_ETH_LINK_PROFILE = "fabricEthLinkProfile"
    EP_CLASS_ID_FABRIC_ETH_MON = "fabricEthMon"
    EP_CLASS_ID_FABRIC_ETH_MON_DEST_EP = "fabricEthMonDestEp"
    EP_CLASS_ID_FABRIC_ETH_MON_FILT_EP = "fabricEthMonFiltEp"
    EP_CLASS_ID_FABRIC_ETH_MON_FILT_REF = "fabricEthMonFiltRef"
    EP_CLASS_ID_FABRIC_ETH_MON_LAN = "fabricEthMonLan"
    EP_CLASS_ID_FABRIC_ETH_MON_SRC_EP = "fabricEthMonSrcEp"
    EP_CLASS_ID_FABRIC_ETH_MON_SRC_REF = "fabricEthMonSrcRef"
    EP_CLASS_ID_FABRIC_ETH_TARGET_EP = "fabricEthTargetEp"
    EP_CLASS_ID_FABRIC_ETH_UDLD_POLICY = "fabricEthUdldPolicy"
    EP_CLASS_ID_FABRIC_ETH_VLAN_PC = "fabricEthVlanPc"
    EP_CLASS_ID_FABRIC_ETH_VLAN_PORT_EP = "fabricEthVlanPortEp"
    EP_CLASS_ID_FABRIC_EXTERNAL = "fabricExternal"
    EP_CLASS_ID_FABRIC_EXTERNAL_EP = "fabricExternalEp"
    EP_CLASS_ID_FABRIC_EXTERNAL_ESTC = "fabricExternalEstc"
    EP_CLASS_ID_FABRIC_EXTERNAL_PC = "fabricExternalPc"
    EP_CLASS_ID_FABRIC_FC_ENDPOINT = "fabricFcEndpoint"
    EP_CLASS_ID_FABRIC_FC_ESTC = "fabricFcEstc"
    EP_CLASS_ID_FABRIC_FC_ESTC_CLOUD = "fabricFcEstcCloud"
    EP_CLASS_ID_FABRIC_FC_ESTC_EP = "fabricFcEstcEp"
    EP_CLASS_ID_FABRIC_FC_MON = "fabricFcMon"
    EP_CLASS_ID_FABRIC_FC_MON_DEST_EP = "fabricFcMonDestEp"
    EP_CLASS_ID_FABRIC_FC_MON_FILT_EP = "fabricFcMonFiltEp"
    EP_CLASS_ID_FABRIC_FC_MON_FILT_REF = "fabricFcMonFiltRef"
    EP_CLASS_ID_FABRIC_FC_MON_SAN = "fabricFcMonSan"
    EP_CLASS_ID_FABRIC_FC_MON_SRC_EP = "fabricFcMonSrcEp"
    EP_CLASS_ID_FABRIC_FC_MON_SRC_REF = "fabricFcMonSrcRef"
    EP_CLASS_ID_FABRIC_FC_SAN = "fabricFcSan"
    EP_CLASS_ID_FABRIC_FC_SAN_EP = "fabricFcSanEp"
    EP_CLASS_ID_FABRIC_FC_SAN_PC = "fabricFcSanPc"
    EP_CLASS_ID_FABRIC_FC_SAN_PC_EP = "fabricFcSanPcEp"
    EP_CLASS_ID_FABRIC_FC_USER_ZONE = "fabricFcUserZone"
    EP_CLASS_ID_FABRIC_FC_VSAN_PC = "fabricFcVsanPc"
    EP_CLASS_ID_FABRIC_FC_VSAN_PORT_EP = "fabricFcVsanPortEp"
    EP_CLASS_ID_FABRIC_FC_ZONE_PROFILE = "fabricFcZoneProfile"
    EP_CLASS_ID_FABRIC_FCOE_ESTC_EP = "fabricFcoeEstcEp"
    EP_CLASS_ID_FABRIC_FCOE_SAN_EP = "fabricFcoeSanEp"
    EP_CLASS_ID_FABRIC_FCOE_SAN_PC = "fabricFcoeSanPc"
    EP_CLASS_ID_FABRIC_FCOE_SAN_PC_EP = "fabricFcoeSanPcEp"
    EP_CLASS_ID_FABRIC_FCOE_VSAN_PC = "fabricFcoeVsanPc"
    EP_CLASS_ID_FABRIC_FCOE_VSAN_PORT_EP = "fabricFcoeVsanPortEp"
    EP_CLASS_ID_FABRIC_FLOW_MON = "fabricFlowMon"
    EP_CLASS_ID_FABRIC_FLOW_MON_COLLECTOR = "fabricFlowMonCollector"
    EP_CLASS_ID_FABRIC_FLOW_MON_DEFINITION = "fabricFlowMonDefinition"
    EP_CLASS_ID_FABRIC_FLOW_MON_EXPORTER = "fabricFlowMonExporter"
    EP_CLASS_ID_FABRIC_FLOW_MON_EXPORTER_PROFILE = "fabricFlowMonExporterProfile"
    EP_CLASS_ID_FABRIC_FLOW_MON_ITEM = "fabricFlowMonItem"
    EP_CLASS_ID_FABRIC_FLOW_MON_SRC_EP = "fabricFlowMonSrcEp"
    EP_CLASS_ID_FABRIC_FLOW_MON_SRC_REF = "fabricFlowMonSrcRef"
    EP_CLASS_ID_FABRIC_FLOW_MONITOR = "fabricFlowMonitor"
    EP_CLASS_ID_FABRIC_FLOW_MONITORING_CATEGORY = "fabricFlowMonitoringCategory"
    EP_CLASS_ID_FABRIC_IF = "fabricIf"
    EP_CLASS_ID_FABRIC_INTERNAL = "fabricInternal"
    EP_CLASS_ID_FABRIC_INTERNAL_DCE_SRV = "fabricInternalDceSrv"
    EP_CLASS_ID_FABRIC_INTERNAL_EP = "fabricInternalEp"
    EP_CLASS_ID_FABRIC_INTERNAL_PC = "fabricInternalPc"
    EP_CLASS_ID_FABRIC_LACP_POLICY = "fabricLacpPolicy"
    EP_CLASS_ID_FABRIC_LAN = "fabricLan"
    EP_CLASS_ID_FABRIC_LAN_ACCESS_MGR = "fabricLanAccessMgr"
    EP_CLASS_ID_FABRIC_LAN_CLOUD = "fabricLanCloud"
    EP_CLASS_ID_FABRIC_LAN_CLOUD_FSM = "fabricLanCloudFsm"
    EP_CLASS_ID_FABRIC_LAN_CLOUD_FSM_STAGE = "fabricLanCloudFsmStage"
    EP_CLASS_ID_FABRIC_LAN_CLOUD_FSM_TASK = "fabricLanCloudFsmTask"
    EP_CLASS_ID_FABRIC_LAN_CLOUD_POLICY = "fabricLanCloudPolicy"
    EP_CLASS_ID_FABRIC_LAN_EP = "fabricLanEp"
    EP_CLASS_ID_FABRIC_LAN_FLOW_MON = "fabricLanFlowMon"
    EP_CLASS_ID_FABRIC_LAN_FLOW_MON_COLLECTOR = "fabricLanFlowMonCollector"
    EP_CLASS_ID_FABRIC_LAN_FLOW_MON_EXPORTER = "fabricLanFlowMonExporter"
    EP_CLASS_ID_FABRIC_LAN_FLOW_MON_SRC_EP = "fabricLanFlowMonSrcEp"
    EP_CLASS_ID_FABRIC_LAN_FLOW_MONITOR = "fabricLanFlowMonitor"
    EP_CLASS_ID_FABRIC_LAN_MON_CLOUD = "fabricLanMonCloud"
    EP_CLASS_ID_FABRIC_LAN_PC = "fabricLanPc"
    EP_CLASS_ID_FABRIC_LAN_PIN_GROUP = "fabricLanPinGroup"
    EP_CLASS_ID_FABRIC_LAN_PIN_TARGET = "fabricLanPinTarget"
    EP_CLASS_ID_FABRIC_LAST_ACKED_SLOT = "fabricLastAckedSlot"
    EP_CLASS_ID_FABRIC_LINK_POLICY = "fabricLinkPolicy"
    EP_CLASS_ID_FABRIC_LOCALE = "fabricLocale"
    EP_CLASS_ID_FABRIC_MON = "fabricMon"
    EP_CLASS_ID_FABRIC_MON_DEST_EP = "fabricMonDestEp"
    EP_CLASS_ID_FABRIC_MON_FILT_REF = "fabricMonFiltRef"
    EP_CLASS_ID_FABRIC_MON_SRC_EP = "fabricMonSrcEp"
    EP_CLASS_ID_FABRIC_MON_SRC_FILT_EP = "fabricMonSrcFiltEp"
    EP_CLASS_ID_FABRIC_MON_SRC_REF = "fabricMonSrcRef"
    EP_CLASS_ID_FABRIC_MULTICAST_POLICY = "fabricMulticastPolicy"
    EP_CLASS_ID_FABRIC_NET_GROUP = "fabricNetGroup"
    EP_CLASS_ID_FABRIC_NETFLOW_COLLECTOR = "fabricNetflowCollector"
    EP_CLASS_ID_FABRIC_NETFLOW_IPV4_ADDR = "fabricNetflowIPv4Addr"
    EP_CLASS_ID_FABRIC_NETFLOW_MON_EXPORTER = "fabricNetflowMonExporter"
    EP_CLASS_ID_FABRIC_NETFLOW_MON_EXPORTER_REF = "fabricNetflowMonExporterRef"
    EP_CLASS_ID_FABRIC_NETFLOW_MON_SESSION = "fabricNetflowMonSession"
    EP_CLASS_ID_FABRIC_NETFLOW_MON_SRC_EP = "fabricNetflowMonSrcEp"
    EP_CLASS_ID_FABRIC_NETFLOW_MON_SRC_REF = "fabricNetflowMonSrcRef"
    EP_CLASS_ID_FABRIC_NETFLOW_MONITOR = "fabricNetflowMonitor"
    EP_CLASS_ID_FABRIC_NETFLOW_MONITOR_REF = "fabricNetflowMonitorRef"
    EP_CLASS_ID_FABRIC_NETFLOW_TIMEOUT_POLICY = "fabricNetflowTimeoutPolicy"
    EP_CLASS_ID_FABRIC_ORG_VLAN_POLICY = "fabricOrgVlanPolicy"
    EP_CLASS_ID_FABRIC_PIO_EP = "fabricPIoEp"
    EP_CLASS_ID_FABRIC_PATH = "fabricPath"
    EP_CLASS_ID_FABRIC_PATH_CONN = "fabricPathConn"
    EP_CLASS_ID_FABRIC_PATH_EP = "fabricPathEp"
    EP_CLASS_ID_FABRIC_PIN_GROUP = "fabricPinGroup"
    EP_CLASS_ID_FABRIC_PIN_TARGET = "fabricPinTarget"
    EP_CLASS_ID_FABRIC_POOLABLE_VLAN = "fabricPoolableVlan"
    EP_CLASS_ID_FABRIC_POOLED_VLAN = "fabricPooledVlan"
    EP_CLASS_ID_FABRIC_SAN = "fabricSan"
    EP_CLASS_ID_FABRIC_SAN_CLOUD = "fabricSanCloud"
    EP_CLASS_ID_FABRIC_SAN_CLOUD_FSM = "fabricSanCloudFsm"
    EP_CLASS_ID_FABRIC_SAN_CLOUD_FSM_STAGE = "fabricSanCloudFsmStage"
    EP_CLASS_ID_FABRIC_SAN_CLOUD_FSM_TASK = "fabricSanCloudFsmTask"
    EP_CLASS_ID_FABRIC_SAN_EP = "fabricSanEp"
    EP_CLASS_ID_FABRIC_SAN_MON_CLOUD = "fabricSanMonCloud"
    EP_CLASS_ID_FABRIC_SAN_PC = "fabricSanPc"
    EP_CLASS_ID_FABRIC_SAN_PIN_GROUP = "fabricSanPinGroup"
    EP_CLASS_ID_FABRIC_SAN_PIN_TARGET = "fabricSanPinTarget"
    EP_CLASS_ID_FABRIC_SUB_GROUP = "fabricSubGroup"
    EP_CLASS_ID_FABRIC_SW_CH_EP = "fabricSwChEp"
    EP_CLASS_ID_FABRIC_SW_CH_PH_EP = "fabricSwChPhEp"
    EP_CLASS_ID_FABRIC_SW_SRV_EP = "fabricSwSrvEp"
    EP_CLASS_ID_FABRIC_SW_SRV_PC = "fabricSwSrvPc"
    EP_CLASS_ID_FABRIC_SW_SUB_GROUP = "fabricSwSubGroup"
    EP_CLASS_ID_FABRIC_TARGET_EP = "fabricTargetEp"
    EP_CLASS_ID_FABRIC_UDLD_LINK_POLICY = "fabricUdldLinkPolicy"
    EP_CLASS_ID_FABRIC_UDLD_POLICY = "fabricUdldPolicy"
    EP_CLASS_ID_FABRIC_VCON = "fabricVCon"
    EP_CLASS_ID_FABRIC_VCON_PROFILE = "fabricVConProfile"
    EP_CLASS_ID_FABRIC_VLAN = "fabricVlan"
    EP_CLASS_ID_FABRIC_VLAN_EP = "fabricVlanEp"
    EP_CLASS_ID_FABRIC_VLAN_GROUP_REQ = "fabricVlanGroupReq"
    EP_CLASS_ID_FABRIC_VLAN_PERMIT = "fabricVlanPermit"
    EP_CLASS_ID_FABRIC_VLAN_REQ = "fabricVlanReq"
    EP_CLASS_ID_FABRIC_VNET_EP = "fabricVnetEp"
    EP_CLASS_ID_FABRIC_VNET_EP_SYNC_EP = "fabricVnetEpSyncEp"
    EP_CLASS_ID_FABRIC_VNET_EP_SYNC_EP_FSM = "fabricVnetEpSyncEpFsm"
    EP_CLASS_ID_FABRIC_VNET_EP_SYNC_EP_FSM_STAGE = "fabricVnetEpSyncEpFsmStage"
    EP_CLASS_ID_FABRIC_VNET_EP_SYNC_EP_FSM_TASK = "fabricVnetEpSyncEpFsmTask"
    EP_CLASS_ID_FABRIC_VNET_GROUP_REQ = "fabricVnetGroupReq"
    EP_CLASS_ID_FABRIC_VNET_PERMIT = "fabricVnetPermit"
    EP_CLASS_ID_FABRIC_VNET_REQ = "fabricVnetReq"
    EP_CLASS_ID_FABRIC_VSAN = "fabricVsan"
    EP_CLASS_ID_FABRIC_VSAN_EP = "fabricVsanEp"
    EP_CLASS_ID_FABRIC_VSAN_MEMBERSHIP = "fabricVsanMembership"
    EP_CLASS_ID_FABRIC_ZONE_ID_UNIVERSE = "fabricZoneIdUniverse"
    EP_CLASS_ID_FAULT_AFFECTED_CLASS = "faultAffectedClass"
    EP_CLASS_ID_FAULT_BASE_HOLDER = "faultBaseHolder"
    EP_CLASS_ID_FAULT_BASE_POLICY = "faultBasePolicy"
    EP_CLASS_ID_FAULT_HOLDER = "faultHolder"
    EP_CLASS_ID_FAULT_INST = "faultInst"
    EP_CLASS_ID_FAULT_LOCAL_TYPED_HOLDER = "faultLocalTypedHolder"
    EP_CLASS_ID_FAULT_POLICY = "faultPolicy"
    EP_CLASS_ID_FAULT_SUPPRESS_POLICY = "faultSuppressPolicy"
    EP_CLASS_ID_FAULT_SUPPRESS_POLICY_ITEM = "faultSuppressPolicyItem"
    EP_CLASS_ID_FAULT_SUPPRESS_TASK = "faultSuppressTask"
    EP_CLASS_ID_FC_CONFIG = "fcConfig"
    EP_CLASS_ID_FC_ERR_STATS = "fcErrStats"
    EP_CLASS_ID_FC_ERR_STATS_HIST = "fcErrStatsHist"
    EP_CLASS_ID_FC_IF_CONFIG = "fcIfConfig"
    EP_CLASS_ID_FC_NIC_IF_CONFIG = "fcNicIfConfig"
    EP_CLASS_ID_FC_PIO = "fcPIo"
    EP_CLASS_ID_FC_PIO_FSM = "fcPIoFsm"
    EP_CLASS_ID_FC_PIO_FSM_STAGE = "fcPIoFsmStage"
    EP_CLASS_ID_FC_STATS = "fcStats"
    EP_CLASS_ID_FC_STATS_HIST = "fcStatsHist"
    EP_CLASS_ID_FC_SW_IF_CONFIG = "fcSwIfConfig"
    EP_CLASS_ID_FCPOOL_ADDR = "fcpoolAddr"
    EP_CLASS_ID_FCPOOL_BLOCK = "fcpoolBlock"
    EP_CLASS_ID_FCPOOL_BOOT_TARGET = "fcpoolBootTarget"
    EP_CLASS_ID_FCPOOL_FORMAT = "fcpoolFormat"
    EP_CLASS_ID_FCPOOL_INITIATOR = "fcpoolInitiator"
    EP_CLASS_ID_FCPOOL_INITIATOR_EP = "fcpoolInitiatorEp"
    EP_CLASS_ID_FCPOOL_INITIATORS = "fcpoolInitiators"
    EP_CLASS_ID_FCPOOL_POOLABLE = "fcpoolPoolable"
    EP_CLASS_ID_FCPOOL_UNIVERSE = "fcpoolUniverse"
    EP_CLASS_ID_FEATURE_BASE_REF = "featureBaseRef"
    EP_CLASS_ID_FEATURE_CONTEXT_EP = "featureContextEp"
    EP_CLASS_ID_FEATURE_DEFINITION = "featureDefinition"
    EP_CLASS_ID_FEATURE_DEFINITION_INSTANCE = "featureDefinitionInstance"
    EP_CLASS_ID_FEATURE_DEFINITION_REF = "featureDefinitionRef"
    EP_CLASS_ID_FEATURE_FRU_CAP_PROVIDER_INSTANCE = "featureFruCapProviderInstance"
    EP_CLASS_ID_FEATURE_FRU_CAP_PROVIDER_REF = "featureFruCapProviderRef"
    EP_CLASS_ID_FEATURE_PROVIDER = "featureProvider"
    EP_CLASS_ID_FEATURE_PROVIDER_INSTANCE = "featureProviderInstance"
    EP_CLASS_ID_FIRMWARE_ABUNDLE_TYPE_CAP_PROVIDER = "firmwareABundleTypeCapProvider"
    EP_CLASS_ID_FIRMWARE_ACOMPONENT_SPEC = "firmwareAComponentSpec"
    EP_CLASS_ID_FIRMWARE_ACONSTRAINT = "firmwareAConstraint"
    EP_CLASS_ID_FIRMWARE_AEXCLUDE_COMPONENT = "firmwareAExcludeComponent"
    EP_CLASS_ID_FIRMWARE_ACK = "firmwareAck"
    EP_CLASS_ID_FIRMWARE_ACTIVITY = "firmwareActivity"
    EP_CLASS_ID_FIRMWARE_AUTO_SYNC_POLICY = "firmwareAutoSyncPolicy"
    EP_CLASS_ID_FIRMWARE_BLADE = "firmwareBlade"
    EP_CLASS_ID_FIRMWARE_BOOT_DEFINITION = "firmwareBootDefinition"
    EP_CLASS_ID_FIRMWARE_BOOT_UNIT = "firmwareBootUnit"
    EP_CLASS_ID_FIRMWARE_BUNDLE_INFO = "firmwareBundleInfo"
    EP_CLASS_ID_FIRMWARE_BUNDLE_INFO_DIGEST = "firmwareBundleInfoDigest"
    EP_CLASS_ID_FIRMWARE_BUNDLE_TYPE = "firmwareBundleType"
    EP_CLASS_ID_FIRMWARE_BUNDLE_TYPE_CAP_PROVIDER = "firmwareBundleTypeCapProvider"
    EP_CLASS_ID_FIRMWARE_CAP_PROVIDER = "firmwareCapProvider"
    EP_CLASS_ID_FIRMWARE_CATALOG_PACK = "firmwareCatalogPack"
    EP_CLASS_ID_FIRMWARE_CATALOGUE = "firmwareCatalogue"
    EP_CLASS_ID_FIRMWARE_CHASSIS_COMPONENT_SPEC = "firmwareChassisComponentSpec"
    EP_CLASS_ID_FIRMWARE_CHASSIS_PACK = "firmwareChassisPack"
    EP_CLASS_ID_FIRMWARE_COMP_ITEM = "firmwareCompItem"
    EP_CLASS_ID_FIRMWARE_COMP_SOURCE = "firmwareCompSource"
    EP_CLASS_ID_FIRMWARE_COMP_TARGET = "firmwareCompTarget"
    EP_CLASS_ID_FIRMWARE_COMPONENT_SPEC = "firmwareComponentSpec"
    EP_CLASS_ID_FIRMWARE_COMPUTE_HOST_PACK = "firmwareComputeHostPack"
    EP_CLASS_ID_FIRMWARE_COMPUTE_MGMT_PACK = "firmwareComputeMgmtPack"
    EP_CLASS_ID_FIRMWARE_COMPUTE_PACK = "firmwareComputePack"
    EP_CLASS_ID_FIRMWARE_CONSTRAINTS = "firmwareConstraints"
    EP_CLASS_ID_FIRMWARE_DEPENDENCY = "firmwareDependency"
    EP_CLASS_ID_FIRMWARE_DIST_IMAGE = "firmwareDistImage"
    EP_CLASS_ID_FIRMWARE_DISTRIBUTABLE = "firmwareDistributable"
    EP_CLASS_ID_FIRMWARE_DISTRIBUTABLE_FSM = "firmwareDistributableFsm"
    EP_CLASS_ID_FIRMWARE_DISTRIBUTABLE_FSM_STAGE = "firmwareDistributableFsmStage"
    EP_CLASS_ID_FIRMWARE_DISTRIBUTABLE_FSM_TASK = "firmwareDistributableFsmTask"
    EP_CLASS_ID_FIRMWARE_DOWNLOADER = "firmwareDownloader"
    EP_CLASS_ID_FIRMWARE_DOWNLOADER_FSM = "firmwareDownloaderFsm"
    EP_CLASS_ID_FIRMWARE_DOWNLOADER_FSM_STAGE = "firmwareDownloaderFsmStage"
    EP_CLASS_ID_FIRMWARE_DOWNLOADER_FSM_TASK = "firmwareDownloaderFsmTask"
    EP_CLASS_ID_FIRMWARE_EXCLUDE_CHASSIS_COMPONENT = "firmwareExcludeChassisComponent"
    EP_CLASS_ID_FIRMWARE_EXCLUDE_SERVER_COMPONENT = "firmwareExcludeServerComponent"
    EP_CLASS_ID_FIRMWARE_FILE_UNIT = "firmwareFileUnit"
    EP_CLASS_ID_FIRMWARE_HOST = "firmwareHost"
    EP_CLASS_ID_FIRMWARE_HOST_PACK_MOD_IMPACT = "firmwareHostPackModImpact"
    EP_CLASS_ID_FIRMWARE_IMAGE = "firmwareImage"
    EP_CLASS_ID_FIRMWARE_IMAGE_FSM = "firmwareImageFsm"
    EP_CLASS_ID_FIRMWARE_IMAGE_FSM_STAGE = "firmwareImageFsmStage"
    EP_CLASS_ID_FIRMWARE_IMAGE_FSM_TASK = "firmwareImageFsmTask"
    EP_CLASS_ID_FIRMWARE_IMAGE_LOCK = "firmwareImageLock"
    EP_CLASS_ID_FIRMWARE_INFRA = "firmwareInfra"
    EP_CLASS_ID_FIRMWARE_INFRA_PACK = "firmwareInfraPack"
    EP_CLASS_ID_FIRMWARE_INSTALL_IMPACT = "firmwareInstallImpact"
    EP_CLASS_ID_FIRMWARE_INSTALLABLE = "firmwareInstallable"
    EP_CLASS_ID_FIRMWARE_PCHSTORAGE_CONFIG_CONSTRAINT = "firmwarePCHStorageConfigConstraint"
    EP_CLASS_ID_FIRMWARE_PACK = "firmwarePack"
    EP_CLASS_ID_FIRMWARE_PACK_ITEM = "firmwarePackItem"
    EP_CLASS_ID_FIRMWARE_PLATFORM_BUNDLE_TYPE_CAP_PROVIDER = "firmwarePlatformBundleTypeCapProvider"
    EP_CLASS_ID_FIRMWARE_PROCESSOR_TYPE_CONSTRAINT = "firmwareProcessorTypeConstraint"
    EP_CLASS_ID_FIRMWARE_RACK = "firmwareRack"
    EP_CLASS_ID_FIRMWARE_RACK_POWER_CAP_CONSTRAINT = "firmwareRackPowerCapConstraint"
    EP_CLASS_ID_FIRMWARE_RUNNING = "firmwareRunning"
    EP_CLASS_ID_FIRMWARE_SERVER_TYPE_CONSTRAINT = "firmwareServerTypeConstraint"
    EP_CLASS_ID_FIRMWARE_SPEC = "firmwareSpec"
    EP_CLASS_ID_FIRMWARE_STATUS = "firmwareStatus"
    EP_CLASS_ID_FIRMWARE_SYSTEM = "firmwareSystem"
    EP_CLASS_ID_FIRMWARE_SYSTEM_COMP_CHECK_RESULT = "firmwareSystemCompCheckResult"
    EP_CLASS_ID_FIRMWARE_SYSTEM_FSM = "firmwareSystemFsm"
    EP_CLASS_ID_FIRMWARE_SYSTEM_FSM_STAGE = "firmwareSystemFsmStage"
    EP_CLASS_ID_FIRMWARE_SYSTEM_FSM_TASK = "firmwareSystemFsmTask"
    EP_CLASS_ID_FIRMWARE_TPMCONSTRAINT = "firmwareTPMConstraint"
    EP_CLASS_ID_FIRMWARE_TYPE = "firmwareType"
    EP_CLASS_ID_FIRMWARE_UCSC_INFO = "firmwareUcscInfo"
    EP_CLASS_ID_FIRMWARE_UNIT = "firmwareUnit"
    EP_CLASS_ID_FIRMWARE_UPDATABLE = "firmwareUpdatable"
    EP_CLASS_ID_FIRMWARE_UPGRADE_CONSTRAINT = "firmwareUpgradeConstraint"
    EP_CLASS_ID_FIRMWARE_UPGRADE_DETAIL = "firmwareUpgradeDetail"
    EP_CLASS_ID_FIRMWARE_UPGRADE_INFO = "firmwareUpgradeInfo"
    EP_CLASS_ID_FIRMWARE_VIC_SLOT_CONSTRAINT = "firmwareVicSlotConstraint"
    EP_CLASS_ID_FIRMWARE_VNIC_CDN_CONSTRAINT = "firmwareVnicCdnConstraint"
    EP_CLASS_ID_FLOWCTRL_DEFINITION = "flowctrlDefinition"
    EP_CLASS_ID_FLOWCTRL_ITEM = "flowctrlItem"
    EP_CLASS_ID_FSM_FSM = "fsmFsm"
    EP_CLASS_ID_FSM_STAGE = "fsmStage"
    EP_CLASS_ID_FSM_STATUS = "fsmStatus"
    EP_CLASS_ID_FSM_TASK = "fsmTask"
    EP_CLASS_ID_GMETA_CLASS = "gmetaClass"
    EP_CLASS_ID_GMETA_EP = "gmetaEp"
    EP_CLASS_ID_GMETA_HOLDER = "gmetaHolder"
    EP_CLASS_ID_GMETA_HOLDER_FSM = "gmetaHolderFsm"
    EP_CLASS_ID_GMETA_HOLDER_FSM_STAGE = "gmetaHolderFsmStage"
    EP_CLASS_ID_GMETA_HOLDER_FSM_TASK = "gmetaHolderFsmTask"
    EP_CLASS_ID_GMETA_POLICY_MAP_ELEMENT = "gmetaPolicyMapElement"
    EP_CLASS_ID_GMETA_POLICY_MAP_HOLDER = "gmetaPolicyMapHolder"
    EP_CLASS_ID_GMETA_PROP = "gmetaProp"
    EP_CLASS_ID_GRAPHICS_CARD = "graphicsCard"
    EP_CLASS_ID_GRAPHICS_CONTROLLER = "graphicsController"
    EP_CLASS_ID_HOSTIMG_POLICY = "hostimgPolicy"
    EP_CLASS_ID_HOSTIMG_TARGET = "hostimgTarget"
    EP_CLASS_ID_IDENT_IDENT_CTX = "identIdentCtx"
    EP_CLASS_ID_IDENT_IDENT_REQUEST = "identIdentRequest"
    EP_CLASS_ID_IDENT_IDENT_REQUEST_FSM = "identIdentRequestFsm"
    EP_CLASS_ID_IDENT_IDENT_REQUEST_FSM_STAGE = "identIdentRequestFsmStage"
    EP_CLASS_ID_IDENT_IDENT_REQUEST_FSM_TASK = "identIdentRequestFsmTask"
    EP_CLASS_ID_IDENT_META_SYSTEM = "identMetaSystem"
    EP_CLASS_ID_IDENT_META_SYSTEM_FSM = "identMetaSystemFsm"
    EP_CLASS_ID_IDENT_META_SYSTEM_FSM_STAGE = "identMetaSystemFsmStage"
    EP_CLASS_ID_IDENT_META_SYSTEM_FSM_TASK = "identMetaSystemFsmTask"
    EP_CLASS_ID_IDENT_META_VERSE = "identMetaVerse"
    EP_CLASS_ID_IDENT_REQUEST_EP = "identRequestEp"
    EP_CLASS_ID_IDENT_SYS_INFO = "identSysInfo"
    EP_CLASS_ID_IMGPROV_POLICY = "imgprovPolicy"
    EP_CLASS_ID_IMGPROV_TARGET = "imgprovTarget"
    EP_CLASS_ID_IMGSEC_KEY = "imgsecKey"
    EP_CLASS_ID_IMGSEC_POLICY = "imgsecPolicy"
    EP_CLASS_ID_INITIATOR_EP = "initiatorEp"
    EP_CLASS_ID_INITIATOR_FC_INITIATOR_EP = "initiatorFcInitiatorEp"
    EP_CLASS_ID_INITIATOR_GROUP_EP = "initiatorGroupEp"
    EP_CLASS_ID_INITIATOR_ISCSI_INITIATOR_EP = "initiatorIScsiInitiatorEp"
    EP_CLASS_ID_INITIATOR_INITIATOR_EP = "initiatorInitiatorEp"
    EP_CLASS_ID_INITIATOR_LUN_EP = "initiatorLunEp"
    EP_CLASS_ID_INITIATOR_MEMBER_EP = "initiatorMemberEp"
    EP_CLASS_ID_INITIATOR_REQUESTOR_EP = "initiatorRequestorEp"
    EP_CLASS_ID_INITIATOR_REQUESTOR_GRP_EP = "initiatorRequestorGrpEp"
    EP_CLASS_ID_INITIATOR_STORE_EP = "initiatorStoreEp"
    EP_CLASS_ID_INITIATOR_UNIT_EP = "initiatorUnitEp"
    EP_CLASS_ID_IP_DNS_SUFFIX = "ipDnsSuffix"
    EP_CLASS_ID_IP_IPV4_DNS = "ipIPv4Dns"
    EP_CLASS_ID_IP_IPV4_WINS_SERVER = "ipIPv4WinsServer"
    EP_CLASS_ID_IP_IP_V4_ADDR = "ipIpV4Addr"
    EP_CLASS_ID_IP_IP_V4_STATIC_ADDR = "ipIpV4StaticAddr"
    EP_CLASS_ID_IP_IP_V4_STATIC_TARGET_ADDR = "ipIpV4StaticTargetAddr"
    EP_CLASS_ID_IP_SERVICE_IF = "ipServiceIf"
    EP_CLASS_ID_IPPOOL_ADDR = "ippoolAddr"
    EP_CLASS_ID_IPPOOL_BLOCK = "ippoolBlock"
    EP_CLASS_ID_IPPOOL_IP_V6_ADDR = "ippoolIpV6Addr"
    EP_CLASS_ID_IPPOOL_IP_V6_BLOCK = "ippoolIpV6Block"
    EP_CLASS_ID_IPPOOL_IP_V6_POOLED = "ippoolIpV6Pooled"
    EP_CLASS_ID_IPPOOL_POOL = "ippoolPool"
    EP_CLASS_ID_IPPOOL_POOLABLE = "ippoolPoolable"
    EP_CLASS_ID_IPPOOL_POOLED = "ippoolPooled"
    EP_CLASS_ID_IPPOOL_UNIVERSE = "ippoolUniverse"
    EP_CLASS_ID_IQNPOOL_ABS_BLOCK = "iqnpoolAbsBlock"
    EP_CLASS_ID_IQNPOOL_ADDR = "iqnpoolAddr"
    EP_CLASS_ID_IQNPOOL_BLOCK = "iqnpoolBlock"
    EP_CLASS_ID_IQNPOOL_FORMAT = "iqnpoolFormat"
    EP_CLASS_ID_IQNPOOL_POOL = "iqnpoolPool"
    EP_CLASS_ID_IQNPOOL_POOLABLE = "iqnpoolPoolable"
    EP_CLASS_ID_IQNPOOL_POOLED = "iqnpoolPooled"
    EP_CLASS_ID_IQNPOOL_TRANSPORT_BLOCK = "iqnpoolTransportBlock"
    EP_CLASS_ID_IQNPOOL_UNIVERSE = "iqnpoolUniverse"
    EP_CLASS_ID_ISCSI_AUTH_PROFILE = "iscsiAuthProfile"
    EP_CLASS_ID_LICENSE_CAP_PROVIDER = "licenseCapProvider"
    EP_CLASS_ID_LICENSE_CONTENTS = "licenseContents"
    EP_CLASS_ID_LICENSE_DOWNLOADER = "licenseDownloader"
    EP_CLASS_ID_LICENSE_DOWNLOADER_FSM = "licenseDownloaderFsm"
    EP_CLASS_ID_LICENSE_DOWNLOADER_FSM_STAGE = "licenseDownloaderFsmStage"
    EP_CLASS_ID_LICENSE_DOWNLOADER_FSM_TASK = "licenseDownloaderFsmTask"
    EP_CLASS_ID_LICENSE_EP = "licenseEp"
    EP_CLASS_ID_LICENSE_FEATURE = "licenseFeature"
    EP_CLASS_ID_LICENSE_FEATURE_CAP_PROVIDER = "licenseFeatureCapProvider"
    EP_CLASS_ID_LICENSE_FEATURE_LINE = "licenseFeatureLine"
    EP_CLASS_ID_LICENSE_FILE = "licenseFile"
    EP_CLASS_ID_LICENSE_FILE_FSM = "licenseFileFsm"
    EP_CLASS_ID_LICENSE_FILE_FSM_STAGE = "licenseFileFsmStage"
    EP_CLASS_ID_LICENSE_FILE_FSM_TASK = "licenseFileFsmTask"
    EP_CLASS_ID_LICENSE_INSTANCE = "licenseInstance"
    EP_CLASS_ID_LICENSE_INSTANCE_FSM = "licenseInstanceFsm"
    EP_CLASS_ID_LICENSE_INSTANCE_FSM_STAGE = "licenseInstanceFsmStage"
    EP_CLASS_ID_LICENSE_INSTANCE_FSM_TASK = "licenseInstanceFsmTask"
    EP_CLASS_ID_LICENSE_PROP = "licenseProp"
    EP_CLASS_ID_LICENSE_SERVER_HOST_ID = "licenseServerHostId"
    EP_CLASS_ID_LICENSE_SOURCE = "licenseSource"
    EP_CLASS_ID_LICENSE_SOURCE_FILE = "licenseSourceFile"
    EP_CLASS_ID_LICENSE_TARGET = "licenseTarget"
    EP_CLASS_ID_LLDP_ACQUIRED = "lldpAcquired"
    EP_CLASS_ID_LS_AGENT_POLICY = "lsAgentPolicy"
    EP_CLASS_ID_LS_BINDING = "lsBinding"
    EP_CLASS_ID_LS_COMPUTE_BINDING = "lsComputeBinding"
    EP_CLASS_ID_LS_FC_LOCALE = "lsFcLocale"
    EP_CLASS_ID_LS_FC_ZONE = "lsFcZone"
    EP_CLASS_ID_LS_FC_ZONE_GROUP = "lsFcZoneGroup"
    EP_CLASS_ID_LS_FC_ZONE_MEMBER = "lsFcZoneMember"
    EP_CLASS_ID_LS_IDENTITY_INFO = "lsIdentityInfo"
    EP_CLASS_ID_LS_ISSUES = "lsIssues"
    EP_CLASS_ID_LS_POWER = "lsPower"
    EP_CLASS_ID_LS_REQUIREMENT = "lsRequirement"
    EP_CLASS_ID_LS_SERVER = "lsServer"
    EP_CLASS_ID_LS_SERVER_ASSOC_CTX = "lsServerAssocCtx"
    EP_CLASS_ID_LS_SERVER_EXTENSION = "lsServerExtension"
    EP_CLASS_ID_LS_SERVER_FSM = "lsServerFsm"
    EP_CLASS_ID_LS_SERVER_FSM_STAGE = "lsServerFsmStage"
    EP_CLASS_ID_LS_SERVER_FSM_TASK = "lsServerFsmTask"
    EP_CLASS_ID_LS_TIER = "lsTier"
    EP_CLASS_ID_LS_UUID_HISTORY = "lsUuidHistory"
    EP_CLASS_ID_LS_VCON_ASSIGN = "lsVConAssign"
    EP_CLASS_ID_LS_VERSION_BEH = "lsVersionBeh"
    EP_CLASS_ID_LS_ZONE_INITIATOR_MEMBER = "lsZoneInitiatorMember"
    EP_CLASS_ID_LS_ZONE_TARGET_MEMBER = "lsZoneTargetMember"
    EP_CLASS_ID_LSBOOT_ADEF = "lsbootADef"
    EP_CLASS_ID_LSBOOT_BOOT_SECURITY = "lsbootBootSecurity"
    EP_CLASS_ID_LSBOOT_CATEGORY = "lsbootCategory"
    EP_CLASS_ID_LSBOOT_DEF = "lsbootDef"
    EP_CLASS_ID_LSBOOT_DEFAULT_LOCAL_IMAGE = "lsbootDefaultLocalImage"
    EP_CLASS_ID_LSBOOT_EFISHELL = "lsbootEFIShell"
    EP_CLASS_ID_LSBOOT_EMBEDDED_LOCAL_DISK_IMAGE = "lsbootEmbeddedLocalDiskImage"
    EP_CLASS_ID_LSBOOT_EMBEDDED_LOCAL_DISK_IMAGE_PATH = "lsbootEmbeddedLocalDiskImagePath"
    EP_CLASS_ID_LSBOOT_EMBEDDED_LOCAL_LUN_IMAGE = "lsbootEmbeddedLocalLunImage"
    EP_CLASS_ID_LSBOOT_ISCSI = "lsbootIScsi"
    EP_CLASS_ID_LSBOOT_ISCSI_IMAGE_PATH = "lsbootIScsiImagePath"
    EP_CLASS_ID_LSBOOT_IMAGE = "lsbootImage"
    EP_CLASS_ID_LSBOOT_IMAGE_PATH = "lsbootImagePath"
    EP_CLASS_ID_LSBOOT_ITEM = "lsbootItem"
    EP_CLASS_ID_LSBOOT_LAN = "lsbootLan"
    EP_CLASS_ID_LSBOOT_LAN_IMAGE_PATH = "lsbootLanImagePath"
    EP_CLASS_ID_LSBOOT_LOCAL_DISK_IMAGE = "lsbootLocalDiskImage"
    EP_CLASS_ID_LSBOOT_LOCAL_DISK_IMAGE_PATH = "lsbootLocalDiskImagePath"
    EP_CLASS_ID_LSBOOT_LOCAL_HDD_IMAGE = "lsbootLocalHddImage"
    EP_CLASS_ID_LSBOOT_LOCAL_IMAGE = "lsbootLocalImage"
    EP_CLASS_ID_LSBOOT_LOCAL_LUN_IMAGE_PATH = "lsbootLocalLunImagePath"
    EP_CLASS_ID_LSBOOT_LOCAL_MEDIA_ITEM = "lsbootLocalMediaItem"
    EP_CLASS_ID_LSBOOT_LOCAL_STORAGE = "lsbootLocalStorage"
    EP_CLASS_ID_LSBOOT_POLICY = "lsbootPolicy"
    EP_CLASS_ID_LSBOOT_REMOTE_IMAGE = "lsbootRemoteImage"
    EP_CLASS_ID_LSBOOT_SAN = "lsbootSan"
    EP_CLASS_ID_LSBOOT_SAN_CAT_SAN_IMAGE = "lsbootSanCatSanImage"
    EP_CLASS_ID_LSBOOT_SAN_CAT_SAN_IMAGE_PATH = "lsbootSanCatSanImagePath"
    EP_CLASS_ID_LSBOOT_SAN_IMAGE = "lsbootSanImage"
    EP_CLASS_ID_LSBOOT_SAN_IMAGE_PATH = "lsbootSanImagePath"
    EP_CLASS_ID_LSBOOT_STORAGE = "lsbootStorage"
    EP_CLASS_ID_LSBOOT_UEFIBOOT_PARAM = "lsbootUEFIBootParam"
    EP_CLASS_ID_LSBOOT_USB_EXTERNAL_IMAGE = "lsbootUsbExternalImage"
    EP_CLASS_ID_LSBOOT_USB_FLASH_STORAGE_IMAGE = "lsbootUsbFlashStorageImage"
    EP_CLASS_ID_LSBOOT_USB_INTERNAL_IMAGE = "lsbootUsbInternalImage"
    EP_CLASS_ID_LSBOOT_VIRTUAL_MEDIA = "lsbootVirtualMedia"
    EP_CLASS_ID_LSMAINT_ACK = "lsmaintAck"
    EP_CLASS_ID_LSMAINT_MAINT_POLICY = "lsmaintMaintPolicy"
    EP_CLASS_ID_LSTORAGE_ASLOT = "lstorageASlot"
    EP_CLASS_ID_LSTORAGE_CONTROLLER_DEF = "lstorageControllerDef"
    EP_CLASS_ID_LSTORAGE_CONTROLLER_MODE_CONFIG = "lstorageControllerModeConfig"
    EP_CLASS_ID_LSTORAGE_CONTROLLER_QUALIFIER = "lstorageControllerQualifier"
    EP_CLASS_ID_LSTORAGE_CONTROLLER_REF = "lstorageControllerRef"
    EP_CLASS_ID_LSTORAGE_DAS_SCSI_LUN = "lstorageDasScsiLun"
    EP_CLASS_ID_LSTORAGE_DISK_GROUP_CONFIG = "lstorageDiskGroupConfig"
    EP_CLASS_ID_LSTORAGE_DISK_GROUP_CONFIG_DEF = "lstorageDiskGroupConfigDef"
    EP_CLASS_ID_LSTORAGE_DISK_GROUP_CONFIG_POLICY = "lstorageDiskGroupConfigPolicy"
    EP_CLASS_ID_LSTORAGE_DISK_GROUP_QUALIFIER = "lstorageDiskGroupQualifier"
    EP_CLASS_ID_LSTORAGE_DISK_SLOT = "lstorageDiskSlot"
    EP_CLASS_ID_LSTORAGE_DISK_ZONING_CONFIG = "lstorageDiskZoningConfig"
    EP_CLASS_ID_LSTORAGE_DISK_ZONING_CONFIG_DEF = "lstorageDiskZoningConfigDef"
    EP_CLASS_ID_LSTORAGE_DISK_ZONING_POLICY = "lstorageDiskZoningPolicy"
    EP_CLASS_ID_LSTORAGE_ITEM = "lstorageItem"
    EP_CLASS_ID_LSTORAGE_LOCAL_DISK_CONFIG_REF = "lstorageLocalDiskConfigRef"
    EP_CLASS_ID_LSTORAGE_LOCAL_DISK_REF = "lstorageLocalDiskRef"
    EP_CLASS_ID_LSTORAGE_PROFILE = "lstorageProfile"
    EP_CLASS_ID_LSTORAGE_PROFILE_BASE = "lstorageProfileBase"
    EP_CLASS_ID_LSTORAGE_PROFILE_BINDING = "lstorageProfileBinding"
    EP_CLASS_ID_LSTORAGE_PROFILE_BINDING_BASE = "lstorageProfileBindingBase"
    EP_CLASS_ID_LSTORAGE_PROFILE_DEF = "lstorageProfileDef"
    EP_CLASS_ID_LSTORAGE_SCSI_LUN = "lstorageScsiLun"
    EP_CLASS_ID_LSTORAGE_VIRTUAL_DRIVE_DEF = "lstorageVirtualDriveDef"
    EP_CLASS_ID_MACPOOL_ADDR = "macpoolAddr"
    EP_CLASS_ID_MACPOOL_BLOCK = "macpoolBlock"
    EP_CLASS_ID_MACPOOL_FORMAT = "macpoolFormat"
    EP_CLASS_ID_MACPOOL_POOL = "macpoolPool"
    EP_CLASS_ID_MACPOOL_POOLABLE = "macpoolPoolable"
    EP_CLASS_ID_MACPOOL_POOLED = "macpoolPooled"
    EP_CLASS_ID_MACPOOL_UNIVERSE = "macpoolUniverse"
    EP_CLASS_ID_MEMORY_ARRAY = "memoryArray"
    EP_CLASS_ID_MEMORY_ARRAY_ENV_STATS = "memoryArrayEnvStats"
    EP_CLASS_ID_MEMORY_ARRAY_ENV_STATS_HIST = "memoryArrayEnvStatsHist"
    EP_CLASS_ID_MEMORY_BUFFER_UNIT = "memoryBufferUnit"
    EP_CLASS_ID_MEMORY_BUFFER_UNIT_ENV_STATS = "memoryBufferUnitEnvStats"
    EP_CLASS_ID_MEMORY_BUFFER_UNIT_ENV_STATS_HIST = "memoryBufferUnitEnvStatsHist"
    EP_CLASS_ID_MEMORY_ERROR_STATS = "memoryErrorStats"
    EP_CLASS_ID_MEMORY_QUAL = "memoryQual"
    EP_CLASS_ID_MEMORY_RUNTIME = "memoryRuntime"
    EP_CLASS_ID_MEMORY_RUNTIME_HIST = "memoryRuntimeHist"
    EP_CLASS_ID_MEMORY_UNIT = "memoryUnit"
    EP_CLASS_ID_MEMORY_UNIT_ENV_STATS = "memoryUnitEnvStats"
    EP_CLASS_ID_MEMORY_UNIT_ENV_STATS_HIST = "memoryUnitEnvStatsHist"
    EP_CLASS_ID_MGMT_ASECURE_BOOT = "mgmtASecureBoot"
    EP_CLASS_ID_MGMT_ACCESS_POLICY = "mgmtAccessPolicy"
    EP_CLASS_ID_MGMT_ACCESS_POLICY_ITEM = "mgmtAccessPolicyItem"
    EP_CLASS_ID_MGMT_ACCESS_PORT = "mgmtAccessPort"
    EP_CLASS_ID_MGMT_BACKUP = "mgmtBackup"
    EP_CLASS_ID_MGMT_BACKUP_EXPORT_EXT_POLICY = "mgmtBackupExportExtPolicy"
    EP_CLASS_ID_MGMT_BACKUP_FSM = "mgmtBackupFsm"
    EP_CLASS_ID_MGMT_BACKUP_FSM_STAGE = "mgmtBackupFsmStage"
    EP_CLASS_ID_MGMT_BACKUP_FSM_TASK = "mgmtBackupFsmTask"
    EP_CLASS_ID_MGMT_BACKUP_POLICY = "mgmtBackupPolicy"
    EP_CLASS_ID_MGMT_BACKUP_POLICY_CONFIG = "mgmtBackupPolicyConfig"
    EP_CLASS_ID_MGMT_BACKUP_POLICY_FSM = "mgmtBackupPolicyFsm"
    EP_CLASS_ID_MGMT_BACKUP_POLICY_FSM_STAGE = "mgmtBackupPolicyFsmStage"
    EP_CLASS_ID_MGMT_CFG_EXPORT_POLICY = "mgmtCfgExportPolicy"
    EP_CLASS_ID_MGMT_CFG_EXPORT_POLICY_FSM = "mgmtCfgExportPolicyFsm"
    EP_CLASS_ID_MGMT_CFG_EXPORT_POLICY_FSM_STAGE = "mgmtCfgExportPolicyFsmStage"
    EP_CLASS_ID_MGMT_CIMC_INTERFACE = "mgmtCimcInterface"
    EP_CLASS_ID_MGMT_CIMC_SECURE_BOOT = "mgmtCimcSecureBoot"
    EP_CLASS_ID_MGMT_CMC_SECURE_BOOT = "mgmtCmcSecureBoot"
    EP_CLASS_ID_MGMT_CONNECTION = "mgmtConnection"
    EP_CLASS_ID_MGMT_CONTROLLER = "mgmtController"
    EP_CLASS_ID_MGMT_CONTROLLER_FSM = "mgmtControllerFsm"
    EP_CLASS_ID_MGMT_CONTROLLER_FSM_STAGE = "mgmtControllerFsmStage"
    EP_CLASS_ID_MGMT_CONTROLLER_FSM_TASK = "mgmtControllerFsmTask"
    EP_CLASS_ID_MGMT_ENTITY = "mgmtEntity"
    EP_CLASS_ID_MGMT_EXPORT_POLICY = "mgmtExportPolicy"
    EP_CLASS_ID_MGMT_EXPORT_POLICY_FSM = "mgmtExportPolicyFsm"
    EP_CLASS_ID_MGMT_EXPORT_POLICY_FSM_STAGE = "mgmtExportPolicyFsmStage"
    EP_CLASS_ID_MGMT_EXPORT_POLICY_FSM_TASK = "mgmtExportPolicyFsmTask"
    EP_CLASS_ID_MGMT_HEALTH_ATTR = "mgmtHealthAttr"
    EP_CLASS_ID_MGMT_HEALTH_STATUS = "mgmtHealthStatus"
    EP_CLASS_ID_MGMT_IPV6_ADDR = "mgmtIPv6Addr"
    EP_CLASS_ID_MGMT_IPV6_IF_ADDR = "mgmtIPv6IfAddr"
    EP_CLASS_ID_MGMT_IPV6_IF_ADDR_FSM = "mgmtIPv6IfAddrFsm"
    EP_CLASS_ID_MGMT_IPV6_IF_ADDR_FSM_STAGE = "mgmtIPv6IfAddrFsmStage"
    EP_CLASS_ID_MGMT_IPV6_IF_ADDR_FSM_TASK = "mgmtIPv6IfAddrFsmTask"
    EP_CLASS_ID_MGMT_IPV6_IF_CONFIG = "mgmtIPv6IfConfig"
    EP_CLASS_ID_MGMT_IF = "mgmtIf"
    EP_CLASS_ID_MGMT_IF_FSM = "mgmtIfFsm"
    EP_CLASS_ID_MGMT_IF_FSM_STAGE = "mgmtIfFsmStage"
    EP_CLASS_ID_MGMT_IF_FSM_TASK = "mgmtIfFsmTask"
    EP_CLASS_ID_MGMT_IMPORTER = "mgmtImporter"
    EP_CLASS_ID_MGMT_IMPORTER_FSM = "mgmtImporterFsm"
    EP_CLASS_ID_MGMT_IMPORTER_FSM_STAGE = "mgmtImporterFsmStage"
    EP_CLASS_ID_MGMT_IMPORTER_FSM_TASK = "mgmtImporterFsmTask"
    EP_CLASS_ID_MGMT_INBAND_PROFILE = "mgmtInbandProfile"
    EP_CLASS_ID_MGMT_INT_AUTH_POLICY = "mgmtIntAuthPolicy"
    EP_CLASS_ID_MGMT_INTERFACE = "mgmtInterface"
    EP_CLASS_ID_MGMT_MGMT_DB_STATE = "mgmtMgmtDbState"
    EP_CLASS_ID_MGMT_PMON_ENTRY = "mgmtPmonEntry"
    EP_CLASS_ID_MGMT_PROF_DERIVED_INTERFACE = "mgmtProfDerivedInterface"
    EP_CLASS_ID_MGMT_VNET = "mgmtVnet"
    EP_CLASS_ID_MO_TOP_PROPS = "moTopProps"
    EP_CLASS_ID_MOREF_FRU_REF = "morefFruRef"
    EP_CLASS_ID_MOREF_IMPORT_ROOT = "morefImportRoot"
    EP_CLASS_ID_MOREF_IMPORT_ROOT_FSM = "morefImportRootFsm"
    EP_CLASS_ID_MOREF_IMPORT_ROOT_FSM_STAGE = "morefImportRootFsmStage"
    EP_CLASS_ID_MOREF_IMPORT_ROOT_FSM_TASK = "morefImportRootFsmTask"
    EP_CLASS_ID_MOREF_PROP = "morefProp"
    EP_CLASS_ID_MOREF_REF = "morefRef"
    EP_CLASS_ID_NAMING_NAMED_IDENTIFIED_OBJECT = "namingNamedIdentifiedObject"
    EP_CLASS_ID_NAMING_NAMED_OBJECT = "namingNamedObject"
    EP_CLASS_ID_NETWORK_ALAN_NEIGHBOR_ENTRY = "networkALanNeighborEntry"
    EP_CLASS_ID_NETWORK_ANEIGHBOR_ENTRY = "networkANeighborEntry"
    EP_CLASS_ID_NETWORK_CIO_EP = "networkCIoEp"
    EP_CLASS_ID_NETWORK_CONN = "networkConn"
    EP_CLASS_ID_NETWORK_DOMAIN_EP = "networkDomainEp"
    EP_CLASS_ID_NETWORK_ELEMENT = "networkElement"
    EP_CLASS_ID_NETWORK_EP = "networkEp"
    EP_CLASS_ID_NETWORK_IF_EP = "networkIfEp"
    EP_CLASS_ID_NETWORK_IF_STATS = "networkIfStats"
    EP_CLASS_ID_NETWORK_LAN_NEIGHBOR_ENTRY = "networkLanNeighborEntry"
    EP_CLASS_ID_NETWORK_LAN_NEIGHBORS = "networkLanNeighbors"
    EP_CLASS_ID_NETWORK_LLDP_NEIGHBOR_ENTRY = "networkLldpNeighborEntry"
    EP_CLASS_ID_NETWORK_LLDP_NEIGHBORS = "networkLldpNeighbors"
    EP_CLASS_ID_NETWORK_OPER_LEVEL = "networkOperLevel"
    EP_CLASS_ID_NETWORK_PIO_EP = "networkPIoEp"
    EP_CLASS_ID_NETWORK_PHYS_EP = "networkPhysEp"
    EP_CLASS_ID_NETWORK_SAN_NEIGHBOR_ENTRY = "networkSanNeighborEntry"
    EP_CLASS_ID_NETWORK_SAN_NEIGHBORS = "networkSanNeighbors"
    EP_CLASS_ID_NETWORK_VNET_EP = "networkVnetEp"
    EP_CLASS_ID_NETWORKRULE_DEFINITION = "networkruleDefinition"
    EP_CLASS_ID_NETWORKRULE_ITEM = "networkruleItem"
    EP_CLASS_ID_NETWORKRULE_REQUIREMENT = "networkruleRequirement"
    EP_CLASS_ID_NFS_EP = "nfsEp"
    EP_CLASS_ID_NFS_MOUNT_DEF = "nfsMountDef"
    EP_CLASS_ID_NFS_MOUNT_DEF_FSM = "nfsMountDefFsm"
    EP_CLASS_ID_NFS_MOUNT_DEF_FSM_STAGE = "nfsMountDefFsmStage"
    EP_CLASS_ID_NFS_MOUNT_DEF_FSM_TASK = "nfsMountDefFsmTask"
    EP_CLASS_ID_NFS_MOUNT_INST = "nfsMountInst"
    EP_CLASS_ID_NFS_MOUNT_INST_FSM = "nfsMountInstFsm"
    EP_CLASS_ID_NFS_MOUNT_INST_FSM_STAGE = "nfsMountInstFsmStage"
    EP_CLASS_ID_NFS_MOUNT_INST_FSM_TASK = "nfsMountInstFsmTask"
    EP_CLASS_ID_NWCTRL_DEFINITION = "nwctrlDefinition"
    EP_CLASS_ID_OBSERVE_FILTER = "observeFilter"
    EP_CLASS_ID_OBSERVE_OBSERVED = "observeObserved"
    EP_CLASS_ID_OBSERVE_OBSERVED_CONT = "observeObservedCont"
    EP_CLASS_ID_OBSERVE_OBSERVED_FSM = "observeObservedFsm"
    EP_CLASS_ID_OBSERVE_OBSERVED_FSM_STAGE = "observeObservedFsmStage"
    EP_CLASS_ID_OBSERVE_OBSERVED_FSM_TASK = "observeObservedFsmTask"
    EP_CLASS_ID_ORG_ORG = "orgOrg"
    EP_CLASS_ID_ORG_SOURCE_MASK = "orgSourceMask"
    EP_CLASS_ID_OS_ARPLINK_MONITORING_POLICY = "osARPLinkMonitoringPolicy"
    EP_CLASS_ID_OS_ARPTARGET = "osARPTarget"
    EP_CLASS_ID_OS_AGENT = "osAgent"
    EP_CLASS_ID_OS_ETH_BOND_INTF = "osEthBondIntf"
    EP_CLASS_ID_OS_ETH_BOND_MODE = "osEthBondMode"
    EP_CLASS_ID_OS_ETH_BOND_MODE_ACTIVE_BACKUP = "osEthBondModeActiveBackup"
    EP_CLASS_ID_OS_ETH_BOND_MODE_BALANCED_ALB = "osEthBondModeBalancedALB"
    EP_CLASS_ID_OS_ETH_BOND_MODE_BALANCED_RR = "osEthBondModeBalancedRR"
    EP_CLASS_ID_OS_ETH_BOND_MODE_BALANCED_TLB = "osEthBondModeBalancedTLB"
    EP_CLASS_ID_OS_ETH_BOND_MODE_BALANCED_XOR = "osEthBondModeBalancedXOR"
    EP_CLASS_ID_OS_ETH_BOND_MODE_BROADCAST = "osEthBondModeBroadcast"
    EP_CLASS_ID_OS_ETH_BOND_MODE_LB = "osEthBondModeLB"
    EP_CLASS_ID_OS_ETH_INTF = "osEthIntf"
    EP_CLASS_ID_OS_INSTANCE = "osInstance"
    EP_CLASS_ID_OS_INTF = "osIntf"
    EP_CLASS_ID_OS_LINK_MONITORING_POLICY = "osLinkMonitoringPolicy"
    EP_CLASS_ID_OS_MII_LINK_MONITORING_POLICY = "osMiiLinkMonitoringPolicy"
    EP_CLASS_ID_OS_PRIMARY_SLAVE = "osPrimarySlave"
    EP_CLASS_ID_PCI_CARD = "pciCard"
    EP_CLASS_ID_PCI_EQUIP_SLOT = "pciEquipSlot"
    EP_CLASS_ID_PCI_UNIT = "pciUnit"
    EP_CLASS_ID_PKI_CERT_REQ = "pkiCertReq"
    EP_CLASS_ID_PKI_DEFINITION = "pkiDefinition"
    EP_CLASS_ID_PKI_EP = "pkiEp"
    EP_CLASS_ID_PKI_EP_FSM = "pkiEpFsm"
    EP_CLASS_ID_PKI_EP_FSM_STAGE = "pkiEpFsmStage"
    EP_CLASS_ID_PKI_EP_FSM_TASK = "pkiEpFsmTask"
    EP_CLASS_ID_PKI_ITEM = "pkiItem"
    EP_CLASS_ID_PKI_KEY_RING = "pkiKeyRing"
    EP_CLASS_ID_PKI_TP = "pkiTP"
    EP_CLASS_ID_POLICY_BINDING = "policyBinding"
    EP_CLASS_ID_POLICY_CENTRALE_SYNC = "policyCentraleSync"
    EP_CLASS_ID_POLICY_COMMUNICATION = "policyCommunication"
    EP_CLASS_ID_POLICY_CONFIG_BACKUP = "policyConfigBackup"
    EP_CLASS_ID_POLICY_CONTROL = "policyControl"
    EP_CLASS_ID_POLICY_CONTROL_EP = "policyControlEp"
    EP_CLASS_ID_POLICY_CONTROL_EP_FSM = "policyControlEpFsm"
    EP_CLASS_ID_POLICY_CONTROL_EP_FSM_STAGE = "policyControlEpFsmStage"
    EP_CLASS_ID_POLICY_CONTROL_EP_FSM_TASK = "policyControlEpFsmTask"
    EP_CLASS_ID_POLICY_CONTROLLED = "policyControlled"
    EP_CLASS_ID_POLICY_CONTROLLED_INSTANCE = "policyControlledInstance"
    EP_CLASS_ID_POLICY_CONTROLLED_TYPE = "policyControlledType"
    EP_CLASS_ID_POLICY_CONTROLLED_TYPE_FSM = "policyControlledTypeFsm"
    EP_CLASS_ID_POLICY_CONTROLLED_TYPE_FSM_STAGE = "policyControlledTypeFsmStage"
    EP_CLASS_ID_POLICY_CONTROLLED_TYPE_FSM_TASK = "policyControlledTypeFsmTask"
    EP_CLASS_ID_POLICY_DATE_TIME = "policyDateTime"
    EP_CLASS_ID_POLICY_DEFINITION = "policyDefinition"
    EP_CLASS_ID_POLICY_DIGEST = "policyDigest"
    EP_CLASS_ID_POLICY_DISCOVERY = "policyDiscovery"
    EP_CLASS_ID_POLICY_DNS = "policyDns"
    EP_CLASS_ID_POLICY_ELEMENT = "policyElement"
    EP_CLASS_ID_POLICY_EQUIPMENT = "policyEquipment"
    EP_CLASS_ID_POLICY_FAULT = "policyFault"
    EP_CLASS_ID_POLICY_HOLDER = "policyHolder"
    EP_CLASS_ID_POLICY_ID_RESOLVE_POLICY = "policyIdResolvePolicy"
    EP_CLASS_ID_POLICY_INFRA_FIRMWARE = "policyInfraFirmware"
    EP_CLASS_ID_POLICY_ITEM = "policyItem"
    EP_CLASS_ID_POLICY_LOCAL_MAP = "policyLocalMap"
    EP_CLASS_ID_POLICY_MEP = "policyMEp"
    EP_CLASS_ID_POLICY_MONITORING = "policyMonitoring"
    EP_CLASS_ID_POLICY_OBJECT = "policyObject"
    EP_CLASS_ID_POLICY_POLICY_EP = "policyPolicyEp"
    EP_CLASS_ID_POLICY_POLICY_REQUESTOR = "policyPolicyRequestor"
    EP_CLASS_ID_POLICY_POLICY_SCOPE = "policyPolicyScope"
    EP_CLASS_ID_POLICY_POLICY_SCOPE_CONT = "policyPolicyScopeCont"
    EP_CLASS_ID_POLICY_POLICY_SCOPE_CONTEXT = "policyPolicyScopeContext"
    EP_CLASS_ID_POLICY_POLICY_SCOPE_FSM = "policyPolicyScopeFsm"
    EP_CLASS_ID_POLICY_POLICY_SCOPE_FSM_STAGE = "policyPolicyScopeFsmStage"
    EP_CLASS_ID_POLICY_POLICY_SCOPE_FSM_TASK = "policyPolicyScopeFsmTask"
    EP_CLASS_ID_POLICY_PORT_CONFIG = "policyPortConfig"
    EP_CLASS_ID_POLICY_POWER_MGMT = "policyPowerMgmt"
    EP_CLASS_ID_POLICY_PSU = "policyPsu"
    EP_CLASS_ID_POLICY_REF_REQ = "policyRefReq"
    EP_CLASS_ID_POLICY_SECURITY = "policySecurity"
    EP_CLASS_ID_POLICY_STORAGE_AUTO_CONFIG = "policyStorageAutoConfig"
    EP_CLASS_ID_POLICY_SYSTEM_EP = "policySystemEp"
    EP_CLASS_ID_POOL_ELEMENT = "poolElement"
    EP_CLASS_ID_POOL_POOL = "poolPool"
    EP_CLASS_ID_POOL_POOL_MEMBER = "poolPoolMember"
    EP_CLASS_ID_POOL_POOLABLE = "poolPoolable"
    EP_CLASS_ID_POOL_UNIVERSE = "poolUniverse"
    EP_CLASS_ID_PORT_DOMAIN_EP = "portDomainEp"
    EP_CLASS_ID_PORT_GROUP = "portGroup"
    EP_CLASS_ID_PORT_INT_FIO = "portIntFIo"
    EP_CLASS_ID_PORT_PIO = "portPIo"
    EP_CLASS_ID_PORT_PIO_FSM = "portPIoFsm"
    EP_CLASS_ID_PORT_PIO_FSM_STAGE = "portPIoFsmStage"
    EP_CLASS_ID_PORT_PIO_FSM_TASK = "portPIoFsmTask"
    EP_CLASS_ID_PORT_PHYS_SWITCH_IO = "portPhysSwitchIo"
    EP_CLASS_ID_PORT_SERVER_INT_FIO = "portServerIntFIo"
    EP_CLASS_ID_PORT_SUB_GROUP = "portSubGroup"
    EP_CLASS_ID_PORT_SWITCH_INT_FIO = "portSwitchIntFIo"
    EP_CLASS_ID_PORT_TRUST_MODE = "portTrustMode"
    EP_CLASS_ID_POWER_ABUDGET = "powerABudget"
    EP_CLASS_ID_POWER_AGROUP = "powerAGroup"
    EP_CLASS_ID_POWER_BUDGET = "powerBudget"
    EP_CLASS_ID_POWER_CHASSIS_MEMBER = "powerChassisMember"
    EP_CLASS_ID_POWER_EP = "powerEp"
    EP_CLASS_ID_POWER_FIMEMBER = "powerFIMember"
    EP_CLASS_ID_POWER_FEX_MEMBER = "powerFexMember"
    EP_CLASS_ID_POWER_GROUP = "powerGroup"
    EP_CLASS_ID_POWER_GROUP_ADDITION_POLICY = "powerGroupAdditionPolicy"
    EP_CLASS_ID_POWER_GROUP_MEMBER = "powerGroupMember"
    EP_CLASS_ID_POWER_GROUP_QUAL = "powerGroupQual"
    EP_CLASS_ID_POWER_GROUP_STATS = "powerGroupStats"
    EP_CLASS_ID_POWER_GROUP_STATS_HIST = "powerGroupStatsHist"
    EP_CLASS_ID_POWER_MGMT_POLICY = "powerMgmtPolicy"
    EP_CLASS_ID_POWER_PLACEMENT = "powerPlacement"
    EP_CLASS_ID_POWER_POLICY = "powerPolicy"
    EP_CLASS_ID_POWER_PRIO_WGHT = "powerPrioWght"
    EP_CLASS_ID_POWER_PROFILED_POWER = "powerProfiledPower"
    EP_CLASS_ID_POWER_RACK_UNIT_MEMBER = "powerRackUnitMember"
    EP_CLASS_ID_PROC_DOER = "procDoer"
    EP_CLASS_ID_PROC_MANAGER = "procManager"
    EP_CLASS_ID_PROC_PROC_COUNTS = "procProcCounts"
    EP_CLASS_ID_PROC_PROCS = "procProcs"
    EP_CLASS_ID_PROC_PRT = "procPrt"
    EP_CLASS_ID_PROC_PRT_COUNTS = "procPrtCounts"
    EP_CLASS_ID_PROC_STIMULUS_COUNTS = "procStimulusCounts"
    EP_CLASS_ID_PROC_SVC = "procSvc"
    EP_CLASS_ID_PROC_TX_COUNTS = "procTxCounts"
    EP_CLASS_ID_PROCESSOR_COMPONENT = "processorComponent"
    EP_CLASS_ID_PROCESSOR_CORE = "processorCore"
    EP_CLASS_ID_PROCESSOR_ENV_STATS = "processorEnvStats"
    EP_CLASS_ID_PROCESSOR_ENV_STATS_HIST = "processorEnvStatsHist"
    EP_CLASS_ID_PROCESSOR_ERROR_STATS = "processorErrorStats"
    EP_CLASS_ID_PROCESSOR_QUAL = "processorQual"
    EP_CLASS_ID_PROCESSOR_RUNTIME = "processorRuntime"
    EP_CLASS_ID_PROCESSOR_RUNTIME_HIST = "processorRuntimeHist"
    EP_CLASS_ID_PROCESSOR_THREAD = "processorThread"
    EP_CLASS_ID_PROCESSOR_UNIT = "processorUnit"
    EP_CLASS_ID_PROCESSOR_UNIT_ASSOC_CTX = "processorUnitAssocCtx"
    EP_CLASS_ID_QOS_DEFINITION = "qosDefinition"
    EP_CLASS_ID_QOS_ITEM = "qosItem"
    EP_CLASS_ID_QOSCLASS_DEFINITION = "qosclassDefinition"
    EP_CLASS_ID_QOSCLASS_DEFINITION_FSM = "qosclassDefinitionFsm"
    EP_CLASS_ID_QOSCLASS_DEFINITION_FSM_STAGE = "qosclassDefinitionFsmStage"
    EP_CLASS_ID_QOSCLASS_DEFINITION_FSM_TASK = "qosclassDefinitionFsmTask"
    EP_CLASS_ID_QOSCLASS_ETH = "qosclassEth"
    EP_CLASS_ID_QOSCLASS_ETH_BE = "qosclassEthBE"
    EP_CLASS_ID_QOSCLASS_ETH_CLASSIFIED = "qosclassEthClassified"
    EP_CLASS_ID_QOSCLASS_FC = "qosclassFc"
    EP_CLASS_ID_QOSCLASS_ITEM = "qosclassItem"
    EP_CLASS_ID_QUERYRESULT_DEPENDENCY = "queryresultDependency"
    EP_CLASS_ID_QUERYRESULT_ITEM = "queryresultItem"
    EP_CLASS_ID_QUERYRESULT_USAGE = "queryresultUsage"
    EP_CLASS_ID_RULE_DEFINITION = "ruleDefinition"
    EP_CLASS_ID_RULE_ITEM = "ruleItem"
    EP_CLASS_ID_RULE_REQUIREMENT = "ruleRequirement"
    EP_CLASS_ID_RULE_SIZE_REQUIREMENT = "ruleSizeRequirement"
    EP_CLASS_ID_SECURITY_UNIT = "securityUnit"
    EP_CLASS_ID_SES_DISK_SLOT_EP = "sesDiskSlotEp"
    EP_CLASS_ID_SES_ENCLOSURE = "sesEnclosure"
    EP_CLASS_ID_SOL_CONFIG = "solConfig"
    EP_CLASS_ID_SOL_DEF = "solDef"
    EP_CLASS_ID_SOL_IF = "solIf"
    EP_CLASS_ID_SOL_POLICY = "solPolicy"
    EP_CLASS_ID_STATS_COLLECTION_POLICY = "statsCollectionPolicy"
    EP_CLASS_ID_STATS_COLLECTION_POLICY_FSM = "statsCollectionPolicyFsm"
    EP_CLASS_ID_STATS_COLLECTION_POLICY_FSM_STAGE = "statsCollectionPolicyFsmStage"
    EP_CLASS_ID_STATS_COLLECTION_POLICY_FSM_TASK = "statsCollectionPolicyFsmTask"
    EP_CLASS_ID_STATS_CURR = "statsCurr"
    EP_CLASS_ID_STATS_HIST = "statsHist"
    EP_CLASS_ID_STATS_HOLDER = "statsHolder"
    EP_CLASS_ID_STATS_ITEM = "statsItem"
    EP_CLASS_ID_STATS_THR32_DEFINITION = "statsThr32Definition"
    EP_CLASS_ID_STATS_THR32_VALUE = "statsThr32Value"
    EP_CLASS_ID_STATS_THR64_DEFINITION = "statsThr64Definition"
    EP_CLASS_ID_STATS_THR64_VALUE = "statsThr64Value"
    EP_CLASS_ID_STATS_THR_FLOAT_DEFINITION = "statsThrFloatDefinition"
    EP_CLASS_ID_STATS_THR_FLOAT_VALUE = "statsThrFloatValue"
    EP_CLASS_ID_STATS_THRESHOLD_CLASS = "statsThresholdClass"
    EP_CLASS_ID_STATS_THRESHOLD_DEFINITION = "statsThresholdDefinition"
    EP_CLASS_ID_STATS_THRESHOLD_POLICY = "statsThresholdPolicy"
    EP_CLASS_ID_STATS_THRESHOLD_VALUE = "statsThresholdValue"
    EP_CLASS_ID_STORAGE_ADEF = "storageADef"
    EP_CLASS_ID_STORAGE_ADISK_EP = "storageADiskEp"
    EP_CLASS_ID_STORAGE_ADISK_SLOT_EP = "storageADiskSlotEp"
    EP_CLASS_ID_STORAGE_ALUN = "storageALun"
    EP_CLASS_ID_STORAGE_ALUN_REF_BASE = "storageALunRefBase"
    EP_CLASS_ID_STORAGE_ASLOT = "storageASlot"
    EP_CLASS_ID_STORAGE_AUTH_KEY = "storageAuthKey"
    EP_CLASS_ID_STORAGE_CONNECTION_DEF = "storageConnectionDef"
    EP_CLASS_ID_STORAGE_CONNECTION_POLICY = "storageConnectionPolicy"
    EP_CLASS_ID_STORAGE_CONTROLLER = "storageController"
    EP_CLASS_ID_STORAGE_CONTROLLER_BASE = "storageControllerBase"
    EP_CLASS_ID_STORAGE_CONTROLLER_EP = "storageControllerEp"
    EP_CLASS_ID_STORAGE_CONTROLLER_REF = "storageControllerRef"
    EP_CLASS_ID_STORAGE_DEVICE = "storageDevice"
    EP_CLASS_ID_STORAGE_DISK_ENV_STATS = "storageDiskEnvStats"
    EP_CLASS_ID_STORAGE_DISK_ENV_STATS_HIST = "storageDiskEnvStatsHist"
    EP_CLASS_ID_STORAGE_DOMAIN_EP = "storageDomainEp"
    EP_CLASS_ID_STORAGE_DRIVE = "storageDrive"
    EP_CLASS_ID_STORAGE_EMBEDDED_STORAGE = "storageEmbeddedStorage"
    EP_CLASS_ID_STORAGE_ENCLOSURE = "storageEnclosure"
    EP_CLASS_ID_STORAGE_ENCLOSURE_CAP = "storageEnclosureCap"
    EP_CLASS_ID_STORAGE_ENCLOSURE_DISK_SLOT_EP = "storageEnclosureDiskSlotEp"
    EP_CLASS_ID_STORAGE_ENCLOSURE_FSM = "storageEnclosureFsm"
    EP_CLASS_ID_STORAGE_ENCLOSURE_FSM_STAGE = "storageEnclosureFsmStage"
    EP_CLASS_ID_STORAGE_ENCLOSURE_FSM_TASK = "storageEnclosureFsmTask"
    EP_CLASS_ID_STORAGE_ENCLOSURE_LOCAL_DISK_CONFIG = "storageEnclosureLocalDiskConfig"
    EP_CLASS_ID_STORAGE_EP = "storageEp"
    EP_CLASS_ID_STORAGE_EP_USER = "storageEpUser"
    EP_CLASS_ID_STORAGE_ETHER_IF = "storageEtherIf"
    EP_CLASS_ID_STORAGE_FC_IF = "storageFcIf"
    EP_CLASS_ID_STORAGE_FC_TARGET_EP = "storageFcTargetEp"
    EP_CLASS_ID_STORAGE_FC_TARGET_IF = "storageFcTargetIf"
    EP_CLASS_ID_STORAGE_FLEX_FLASH_CARD = "storageFlexFlashCard"
    EP_CLASS_ID_STORAGE_FLEX_FLASH_CONTROLLER = "storageFlexFlashController"
    EP_CLASS_ID_STORAGE_FLEX_FLASH_CONTROLLER_FSM = "storageFlexFlashControllerFsm"
    EP_CLASS_ID_STORAGE_FLEX_FLASH_CONTROLLER_FSM_STAGE = "storageFlexFlashControllerFsmStage"
    EP_CLASS_ID_STORAGE_FLEX_FLASH_CONTROLLER_FSM_TASK = "storageFlexFlashControllerFsmTask"
    EP_CLASS_ID_STORAGE_FLEX_FLASH_DRIVE = "storageFlexFlashDrive"
    EP_CLASS_ID_STORAGE_FLEX_FLASH_VIRTUAL_DRIVE = "storageFlexFlashVirtualDrive"
    EP_CLASS_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATS = "storageHddMotherBoardTempStats"
    EP_CLASS_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATS_HIST = "storageHddMotherBoardTempStatsHist"
    EP_CLASS_ID_STORAGE_HW_REVISION_MODIFIER = "storageHwRevisionModifier"
    EP_CLASS_ID_STORAGE_ISCSI_TARGET_IF = "storageIScsiTargetIf"
    EP_CLASS_ID_STORAGE_INI_GROUP = "storageIniGroup"
    EP_CLASS_ID_STORAGE_INITIATOR = "storageInitiator"
    EP_CLASS_ID_STORAGE_ITEM = "storageItem"
    EP_CLASS_ID_STORAGE_L2_IF = "storageL2If"
    EP_CLASS_ID_STORAGE_LOCAL_DISK = "storageLocalDisk"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_BASE = "storageLocalDiskBase"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_CONFIG = "storageLocalDiskConfig"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_CONFIG_DEF = "storageLocalDiskConfigDef"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_CONFIG_POLICY = "storageLocalDiskConfigPolicy"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_EP = "storageLocalDiskEp"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_FSM = "storageLocalDiskFsm"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_FSM_STAGE = "storageLocalDiskFsmStage"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_FSM_TASK = "storageLocalDiskFsmTask"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_PARTITION = "storageLocalDiskPartition"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_SLOT_EP = "storageLocalDiskSlotEp"
    EP_CLASS_ID_STORAGE_LOCAL_LUN = "storageLocalLun"
    EP_CLASS_ID_STORAGE_LOGICAL = "storageLogical"
    EP_CLASS_ID_STORAGE_LUN_DISK = "storageLunDisk"
    EP_CLASS_ID_STORAGE_LUN_RESOURCE_SELECTION_LOG = "storageLunResourceSelectionLog"
    EP_CLASS_ID_STORAGE_MEZZ_FLASH_LIFE = "storageMezzFlashLife"
    EP_CLASS_ID_STORAGE_NODE_EP = "storageNodeEp"
    EP_CLASS_ID_STORAGE_NVME_STATS = "storageNvmeStats"
    EP_CLASS_ID_STORAGE_NVME_STATS_HIST = "storageNvmeStatsHist"
    EP_CLASS_ID_STORAGE_ONBOARD_DEVICE = "storageOnboardDevice"
    EP_CLASS_ID_STORAGE_OPERATION = "storageOperation"
    EP_CLASS_ID_STORAGE_PHYSICAL = "storagePhysical"
    EP_CLASS_ID_STORAGE_QUAL = "storageQual"
    EP_CLASS_ID_STORAGE_RAID_BATTERY = "storageRaidBattery"
    EP_CLASS_ID_STORAGE_SAS_EXPANDER = "storageSasExpander"
    EP_CLASS_ID_STORAGE_SAS_LINK_DESCRIPTOR = "storageSasLinkDescriptor"
    EP_CLASS_ID_STORAGE_SAS_PHY_LINK = "storageSasPhyLink"
    EP_CLASS_ID_STORAGE_SAS_PORT = "storageSasPort"
    EP_CLASS_ID_STORAGE_SAS_PORT_DESCRIPTOR = "storageSasPortDescriptor"
    EP_CLASS_ID_STORAGE_SAS_UP_LINK = "storageSasUpLink"
    EP_CLASS_ID_STORAGE_SCSI_LUN_REF = "storageScsiLunRef"
    EP_CLASS_ID_STORAGE_SYSTEM = "storageSystem"
    EP_CLASS_ID_STORAGE_SYSTEM_FSM = "storageSystemFsm"
    EP_CLASS_ID_STORAGE_SYSTEM_FSM_STAGE = "storageSystemFsmStage"
    EP_CLASS_ID_STORAGE_SYSTEM_FSM_TASK = "storageSystemFsmTask"
    EP_CLASS_ID_STORAGE_TARGET = "storageTarget"
    EP_CLASS_ID_STORAGE_TARGET_IF = "storageTargetIf"
    EP_CLASS_ID_STORAGE_TRANSPORT_IF = "storageTransportIf"
    EP_CLASS_ID_STORAGE_TRANSPORTABLE_FLASH_MODULE = "storageTransportableFlashModule"
    EP_CLASS_ID_STORAGE_UNIT = "storageUnit"
    EP_CLASS_ID_STORAGE_VDMEMBER_EP = "storageVDMemberEp"
    EP_CLASS_ID_STORAGE_VIRTUAL_DRIVE = "storageVirtualDrive"
    EP_CLASS_ID_STORAGE_VIRTUAL_DRIVE_CONTAINER = "storageVirtualDriveContainer"
    EP_CLASS_ID_STORAGE_VIRTUAL_DRIVE_EP = "storageVirtualDriveEp"
    EP_CLASS_ID_STORAGE_VIRTUAL_DRIVE_REF = "storageVirtualDriveRef"
    EP_CLASS_ID_STORAGE_VSAN_REF = "storageVsanRef"
    EP_CLASS_ID_SW_ACCESS_DOMAIN = "swAccessDomain"
    EP_CLASS_ID_SW_ACCESS_DOMAIN_FSM = "swAccessDomainFsm"
    EP_CLASS_ID_SW_ACCESS_DOMAIN_FSM_STAGE = "swAccessDomainFsmStage"
    EP_CLASS_ID_SW_ACCESS_DOMAIN_FSM_TASK = "swAccessDomainFsmTask"
    EP_CLASS_ID_SW_ACCESS_EP = "swAccessEp"
    EP_CLASS_ID_SW_BORDER_DOMAIN = "swBorderDomain"
    EP_CLASS_ID_SW_BORDER_EP = "swBorderEp"
    EP_CLASS_ID_SW_BORDER_PC = "swBorderPc"
    EP_CLASS_ID_SW_CIO_EP = "swCIoEp"
    EP_CLASS_ID_SW_CARD_ENV_STATS = "swCardEnvStats"
    EP_CLASS_ID_SW_CARD_ENV_STATS_HIST = "swCardEnvStatsHist"
    EP_CLASS_ID_SW_CMCLAN = "swCmclan"
    EP_CLASS_ID_SW_DOMAIN = "swDomain"
    EP_CLASS_ID_SW_ENV_STATS = "swEnvStats"
    EP_CLASS_ID_SW_ENV_STATS_HIST = "swEnvStatsHist"
    EP_CLASS_ID_SW_ESTC_EP = "swEstcEp"
    EP_CLASS_ID_SW_ETH_ESTC_EP = "swEthEstcEp"
    EP_CLASS_ID_SW_ETH_ESTC_PC = "swEthEstcPc"
    EP_CLASS_ID_SW_ETH_FLOW_MON_SESSION = "swEthFlowMonSession"
    EP_CLASS_ID_SW_ETH_LAN_BORDER = "swEthLanBorder"
    EP_CLASS_ID_SW_ETH_LAN_BORDER_FSM = "swEthLanBorderFsm"
    EP_CLASS_ID_SW_ETH_LAN_BORDER_FSM_STAGE = "swEthLanBorderFsmStage"
    EP_CLASS_ID_SW_ETH_LAN_BORDER_FSM_TASK = "swEthLanBorderFsmTask"
    EP_CLASS_ID_SW_ETH_LAN_EP = "swEthLanEp"
    EP_CLASS_ID_SW_ETH_LAN_FLOW_MON = "swEthLanFlowMon"
    EP_CLASS_ID_SW_ETH_LAN_FLOW_MON_EXPORTER = "swEthLanFlowMonExporter"
    EP_CLASS_ID_SW_ETH_LAN_FLOW_MON_FSM = "swEthLanFlowMonFsm"
    EP_CLASS_ID_SW_ETH_LAN_FLOW_MON_FSM_STAGE = "swEthLanFlowMonFsmStage"
    EP_CLASS_ID_SW_ETH_LAN_FLOW_MON_FSM_TASK = "swEthLanFlowMonFsmTask"
    EP_CLASS_ID_SW_ETH_LAN_FLOW_MONITOR = "swEthLanFlowMonitor"
    EP_CLASS_ID_SW_ETH_LAN_FLOW_RECORD_DEF = "swEthLanFlowRecordDef"
    EP_CLASS_ID_SW_ETH_LAN_MON = "swEthLanMon"
    EP_CLASS_ID_SW_ETH_LAN_PC = "swEthLanPc"
    EP_CLASS_ID_SW_ETH_MON = "swEthMon"
    EP_CLASS_ID_SW_ETH_MON_DEST_EP = "swEthMonDestEp"
    EP_CLASS_ID_SW_ETH_MON_FSM = "swEthMonFsm"
    EP_CLASS_ID_SW_ETH_MON_FSM_STAGE = "swEthMonFsmStage"
    EP_CLASS_ID_SW_ETH_MON_FSM_TASK = "swEthMonFsmTask"
    EP_CLASS_ID_SW_ETH_MON_SRC_EP = "swEthMonSrcEp"
    EP_CLASS_ID_SW_ETH_TARGET_EP = "swEthTargetEp"
    EP_CLASS_ID_SW_EXT_UTILITY = "swExtUtility"
    EP_CLASS_ID_SW_EXT_UTILITY_FSM = "swExtUtilityFsm"
    EP_CLASS_ID_SW_EXT_UTILITY_FSM_STAGE = "swExtUtilityFsmStage"
    EP_CLASS_ID_SW_EXT_UTILITY_FSM_TASK = "swExtUtilityFsmTask"
    EP_CLASS_ID_SW_FABRIC_ZONE_NS = "swFabricZoneNs"
    EP_CLASS_ID_SW_FABRIC_ZONE_NS_OVERRIDE = "swFabricZoneNsOverride"
    EP_CLASS_ID_SW_FC_ENDPOINT = "swFcEndpoint"
    EP_CLASS_ID_SW_FC_ESTC_EP = "swFcEstcEp"
    EP_CLASS_ID_SW_FC_MON = "swFcMon"
    EP_CLASS_ID_SW_FC_MON_DEST_EP = "swFcMonDestEp"
    EP_CLASS_ID_SW_FC_MON_FSM = "swFcMonFsm"
    EP_CLASS_ID_SW_FC_MON_FSM_STAGE = "swFcMonFsmStage"
    EP_CLASS_ID_SW_FC_MON_FSM_TASK = "swFcMonFsmTask"
    EP_CLASS_ID_SW_FC_MON_SRC_EP = "swFcMonSrcEp"
    EP_CLASS_ID_SW_FC_SAN_BORDER = "swFcSanBorder"
    EP_CLASS_ID_SW_FC_SAN_BORDER_FSM = "swFcSanBorderFsm"
    EP_CLASS_ID_SW_FC_SAN_BORDER_FSM_STAGE = "swFcSanBorderFsmStage"
    EP_CLASS_ID_SW_FC_SAN_BORDER_FSM_TASK = "swFcSanBorderFsmTask"
    EP_CLASS_ID_SW_FC_SAN_EP = "swFcSanEp"
    EP_CLASS_ID_SW_FC_SAN_MON = "swFcSanMon"
    EP_CLASS_ID_SW_FC_SAN_PC = "swFcSanPc"
    EP_CLASS_ID_SW_FC_SERVER_ZONE_GROUP = "swFcServerZoneGroup"
    EP_CLASS_ID_SW_FC_USER_ZONE = "swFcUserZone"
    EP_CLASS_ID_SW_FC_USER_ZONE_GROUP = "swFcUserZoneGroup"
    EP_CLASS_ID_SW_FC_ZONE = "swFcZone"
    EP_CLASS_ID_SW_FC_ZONE_MEMBER = "swFcZoneMember"
    EP_CLASS_ID_SW_FC_ZONE_SET = "swFcZoneSet"
    EP_CLASS_ID_SW_FCOE_ESTC_EP = "swFcoeEstcEp"
    EP_CLASS_ID_SW_FCOE_SAN_EP = "swFcoeSanEp"
    EP_CLASS_ID_SW_FCOE_SAN_PC = "swFcoeSanPc"
    EP_CLASS_ID_SW_FLOW_MON_EXPORTER = "swFlowMonExporter"
    EP_CLASS_ID_SW_FLOW_MONITOR = "swFlowMonitor"
    EP_CLASS_ID_SW_FLOW_RECORD_DEF = "swFlowRecordDef"
    EP_CLASS_ID_SW_IP_ROUTE = "swIpRoute"
    EP_CLASS_ID_SW_LAN_BORDER = "swLanBorder"
    EP_CLASS_ID_SW_LAN_EP = "swLanEp"
    EP_CLASS_ID_SW_LAN_MON = "swLanMon"
    EP_CLASS_ID_SW_LAN_PC = "swLanPc"
    EP_CLASS_ID_SW_MON = "swMon"
    EP_CLASS_ID_SW_MON_DEST_EP = "swMonDestEp"
    EP_CLASS_ID_SW_MON_DOMAIN = "swMonDomain"
    EP_CLASS_ID_SW_MON_SRC_EP = "swMonSrcEp"
    EP_CLASS_ID_SW_NFEXPORTER_REF = "swNFExporterRef"
    EP_CLASS_ID_SW_NETFLOW_EXPORTER = "swNetflowExporter"
    EP_CLASS_ID_SW_NETFLOW_MON_SESSION = "swNetflowMonSession"
    EP_CLASS_ID_SW_NETFLOW_MONITOR = "swNetflowMonitor"
    EP_CLASS_ID_SW_NETFLOW_MONITOR_REF = "swNetflowMonitorRef"
    EP_CLASS_ID_SW_NETFLOW_RECORD_DEF = "swNetflowRecordDef"
    EP_CLASS_ID_SW_PIO_EP = "swPIoEp"
    EP_CLASS_ID_SW_PHYS = "swPhys"
    EP_CLASS_ID_SW_PHYS_ETHER_EP = "swPhysEtherEp"
    EP_CLASS_ID_SW_PHYS_FC_EP = "swPhysFcEp"
    EP_CLASS_ID_SW_PHYS_FSM = "swPhysFsm"
    EP_CLASS_ID_SW_PHYS_FSM_STAGE = "swPhysFsmStage"
    EP_CLASS_ID_SW_PHYS_FSM_TASK = "swPhysFsmTask"
    EP_CLASS_ID_SW_PORT_BREAKOUT = "swPortBreakout"
    EP_CLASS_ID_SW_SAN_BORDER = "swSanBorder"
    EP_CLASS_ID_SW_SAN_EP = "swSanEp"
    EP_CLASS_ID_SW_SAN_MON = "swSanMon"
    EP_CLASS_ID_SW_SAN_PC = "swSanPc"
    EP_CLASS_ID_SW_SUB_GROUP = "swSubGroup"
    EP_CLASS_ID_SW_SYSTEM_STATS = "swSystemStats"
    EP_CLASS_ID_SW_SYSTEM_STATS_HIST = "swSystemStatsHist"
    EP_CLASS_ID_SW_TARGET_EP = "swTargetEp"
    EP_CLASS_ID_SW_ULAN = "swUlan"
    EP_CLASS_ID_SW_UTILITY_DOMAIN = "swUtilityDomain"
    EP_CLASS_ID_SW_UTILITY_DOMAIN_FSM = "swUtilityDomainFsm"
    EP_CLASS_ID_SW_UTILITY_DOMAIN_FSM_STAGE = "swUtilityDomainFsmStage"
    EP_CLASS_ID_SW_UTILITY_DOMAIN_FSM_TASK = "swUtilityDomainFsmTask"
    EP_CLASS_ID_SW_VIFREF = "swVIFRef"
    EP_CLASS_ID_SW_VIRT_L3_INTF = "swVirtL3Intf"
    EP_CLASS_ID_SW_VLAN = "swVlan"
    EP_CLASS_ID_SW_VLAN_GROUP = "swVlanGroup"
    EP_CLASS_ID_SW_VLAN_PORT_NS = "swVlanPortNs"
    EP_CLASS_ID_SW_VLAN_PORT_NS_OVERRIDE = "swVlanPortNsOverride"
    EP_CLASS_ID_SW_VLAN_REF = "swVlanRef"
    EP_CLASS_ID_SW_VSAN = "swVsan"
    EP_CLASS_ID_SW_ZONE_INITIATOR_MEMBER = "swZoneInitiatorMember"
    EP_CLASS_ID_SW_ZONE_TARGET_MEMBER = "swZoneTargetMember"
    EP_CLASS_ID_SWAT_ACTION = "swatAction"
    EP_CLASS_ID_SWAT_CONDITION = "swatCondition"
    EP_CLASS_ID_SWAT_INJECTION = "swatInjection"
    EP_CLASS_ID_SWAT_RESULTSTATS = "swatResultstats"
    EP_CLASS_ID_SWAT_TARGET = "swatTarget"
    EP_CLASS_ID_SWAT_TRIGGER = "swatTrigger"
    EP_CLASS_ID_SYNTHETIC_DIRECTORY = "syntheticDirectory"
    EP_CLASS_ID_SYNTHETIC_FILE = "syntheticFile"
    EP_CLASS_ID_SYNTHETIC_FILE_SYSTEM = "syntheticFileSystem"
    EP_CLASS_ID_SYNTHETIC_FS_OBJ = "syntheticFsObj"
    EP_CLASS_ID_SYNTHETIC_FS_OBJ_FSM = "syntheticFsObjFsm"
    EP_CLASS_ID_SYNTHETIC_FS_OBJ_FSM_STAGE = "syntheticFsObjFsmStage"
    EP_CLASS_ID_SYNTHETIC_FS_OBJ_FSM_TASK = "syntheticFsObjFsmTask"
    EP_CLASS_ID_SYNTHETIC_TIME = "syntheticTime"
    EP_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET = "sysdebugAutoCoreFileExportTarget"
    EP_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM = "sysdebugAutoCoreFileExportTargetFsm"
    EP_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM_STAGE = "sysdebugAutoCoreFileExportTargetFsmStage"
    EP_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM_TASK = "sysdebugAutoCoreFileExportTargetFsmTask"
    EP_CLASS_ID_SYSDEBUG_BACKUP_BEHAVIOR = "sysdebugBackupBehavior"
    EP_CLASS_ID_SYSDEBUG_CORE = "sysdebugCore"
    EP_CLASS_ID_SYSDEBUG_CORE_FILE_EXPORT_TARGET = "sysdebugCoreFileExportTarget"
    EP_CLASS_ID_SYSDEBUG_CORE_FILE_REPOSITORY = "sysdebugCoreFileRepository"
    EP_CLASS_ID_SYSDEBUG_CORE_FSM = "sysdebugCoreFsm"
    EP_CLASS_ID_SYSDEBUG_CORE_FSM_STAGE = "sysdebugCoreFsmStage"
    EP_CLASS_ID_SYSDEBUG_CORE_FSM_TASK = "sysdebugCoreFsmTask"
    EP_CLASS_ID_SYSDEBUG_EP = "sysdebugEp"
    EP_CLASS_ID_SYSDEBUG_EXPORTER = "sysdebugExporter"
    EP_CLASS_ID_SYSDEBUG_FILE = "sysdebugFile"
    EP_CLASS_ID_SYSDEBUG_LOG_BEHAVIOR = "sysdebugLogBehavior"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_DESTINATION_FILE = "sysdebugLogControlDestinationFile"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_DESTINATION_SYSLOG = "sysdebugLogControlDestinationSyslog"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_DOMAIN = "sysdebugLogControlDomain"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP = "sysdebugLogControlEp"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP_FSM = "sysdebugLogControlEpFsm"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP_FSM_STAGE = "sysdebugLogControlEpFsmStage"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP_FSM_TASK = "sysdebugLogControlEpFsmTask"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_MODULE = "sysdebugLogControlModule"
    EP_CLASS_ID_SYSDEBUG_LOG_EXPORT_POLICY = "sysdebugLogExportPolicy"
    EP_CLASS_ID_SYSDEBUG_LOG_EXPORT_POLICY_FSM = "sysdebugLogExportPolicyFsm"
    EP_CLASS_ID_SYSDEBUG_LOG_EXPORT_POLICY_FSM_STAGE = "sysdebugLogExportPolicyFsmStage"
    EP_CLASS_ID_SYSDEBUG_LOG_EXPORT_POLICY_FSM_TASK = "sysdebugLogExportPolicyFsmTask"
    EP_CLASS_ID_SYSDEBUG_LOG_EXPORT_STATUS = "sysdebugLogExportStatus"
    EP_CLASS_ID_SYSDEBUG_MEP_LOG = "sysdebugMEpLog"
    EP_CLASS_ID_SYSDEBUG_MEP_LOG_DEF = "sysdebugMEpLogDef"
    EP_CLASS_ID_SYSDEBUG_MEP_LOG_POLICY = "sysdebugMEpLogPolicy"
    EP_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET = "sysdebugManualCoreFileExportTarget"
    EP_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM = "sysdebugManualCoreFileExportTargetFsm"
    EP_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM_STAGE = "sysdebugManualCoreFileExportTargetFsmStage"
    EP_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM_TASK = "sysdebugManualCoreFileExportTargetFsmTask"
    EP_CLASS_ID_SYSDEBUG_REPOSITORY = "sysdebugRepository"
    EP_CLASS_ID_SYSDEBUG_TECH_SUP_FILE_REPOSITORY = "sysdebugTechSupFileRepository"
    EP_CLASS_ID_SYSDEBUG_TECH_SUPPORT = "sysdebugTechSupport"
    EP_CLASS_ID_SYSDEBUG_TECH_SUPPORT_CMD_OPT = "sysdebugTechSupportCmdOpt"
    EP_CLASS_ID_SYSDEBUG_TECH_SUPPORT_FSM = "sysdebugTechSupportFsm"
    EP_CLASS_ID_SYSDEBUG_TECH_SUPPORT_FSM_STAGE = "sysdebugTechSupportFsmStage"
    EP_CLASS_ID_SYSDEBUG_TECH_SUPPORT_FSM_TASK = "sysdebugTechSupportFsmTask"
    EP_CLASS_ID_SYSFILE_DIGEST = "sysfileDigest"
    EP_CLASS_ID_SYSFILE_EP = "sysfileEp"
    EP_CLASS_ID_SYSFILE_EXPORTER = "sysfileExporter"
    EP_CLASS_ID_SYSFILE_IMPORTER = "sysfileImporter"
    EP_CLASS_ID_SYSFILE_INSTANCE = "sysfileInstance"
    EP_CLASS_ID_SYSFILE_MUTATION = "sysfileMutation"
    EP_CLASS_ID_SYSFILE_MUTATION_FSM = "sysfileMutationFsm"
    EP_CLASS_ID_SYSFILE_MUTATION_FSM_STAGE = "sysfileMutationFsmStage"
    EP_CLASS_ID_SYSFILE_MUTATION_FSM_TASK = "sysfileMutationFsmTask"
    EP_CLASS_ID_SYSFILE_REPOSITORY = "sysfileRepository"
    EP_CLASS_ID_TOP_INFO_POLICY = "topInfoPolicy"
    EP_CLASS_ID_TOP_INFO_SYNC_POLICY = "topInfoSyncPolicy"
    EP_CLASS_ID_TOP_META_INF = "topMetaInf"
    EP_CLASS_ID_TOP_ROOT = "topRoot"
    EP_CLASS_ID_TOP_SYS_DEFAULTS = "topSysDefaults"
    EP_CLASS_ID_TOP_SYSTEM = "topSystem"
    EP_CLASS_ID_TRIG_ABS_WINDOW = "trigAbsWindow"
    EP_CLASS_ID_TRIG_ACK = "trigAck"
    EP_CLASS_ID_TRIG_BASE_ABS_WINDOW = "trigBaseAbsWindow"
    EP_CLASS_ID_TRIG_BASE_RECURR_WINDOW = "trigBaseRecurrWindow"
    EP_CLASS_ID_TRIG_BASE_SCHED = "trigBaseSched"
    EP_CLASS_ID_TRIG_CLIENT_TOKEN = "trigClientToken"
    EP_CLASS_ID_TRIG_CONF_ACK = "trigConfAck"
    EP_CLASS_ID_TRIG_INST = "trigInst"
    EP_CLASS_ID_TRIG_LOCAL_ABS_WINDOW = "trigLocalAbsWindow"
    EP_CLASS_ID_TRIG_LOCAL_SCHED = "trigLocalSched"
    EP_CLASS_ID_TRIG_META = "trigMeta"
    EP_CLASS_ID_TRIG_RECURR_WINDOW = "trigRecurrWindow"
    EP_CLASS_ID_TRIG_RES_ACK = "trigResAck"
    EP_CLASS_ID_TRIG_SCHED = "trigSched"
    EP_CLASS_ID_TRIG_SCHED_WINDOW = "trigSchedWindow"
    EP_CLASS_ID_TRIG_TEST = "trigTest"
    EP_CLASS_ID_TRIG_TOKEN = "trigToken"
    EP_CLASS_ID_TRIG_TRIGGERABLE = "trigTriggerable"
    EP_CLASS_ID_TRIG_TRIGGERED = "trigTriggered"
    EP_CLASS_ID_TRIG_WINDOW = "trigWindow"
    EP_CLASS_ID_UNSPECIFIED = "unspecified"
    EP_CLASS_ID_UUIDPOOL_ADDR = "uuidpoolAddr"
    EP_CLASS_ID_UUIDPOOL_BLOCK = "uuidpoolBlock"
    EP_CLASS_ID_UUIDPOOL_FORMAT = "uuidpoolFormat"
    EP_CLASS_ID_UUIDPOOL_POOL = "uuidpoolPool"
    EP_CLASS_ID_UUIDPOOL_POOLABLE = "uuidpoolPoolable"
    EP_CLASS_ID_UUIDPOOL_POOLED = "uuidpoolPooled"
    EP_CLASS_ID_UUIDPOOL_UNIVERSE = "uuidpoolUniverse"
    EP_CLASS_ID_VERSION_APPLICATION = "versionApplication"
    EP_CLASS_ID_VERSION_EP = "versionEp"
    EP_CLASS_ID_VERSION_VERSION = "versionVersion"
    EP_CLASS_ID_VM_ADAPTOR = "vmAdaptor"
    EP_CLASS_ID_VM_CLIENT_CONTAINER = "vmClientContainer"
    EP_CLASS_ID_VM_COMPUTE_EP = "vmComputeEp"
    EP_CLASS_ID_VM_CONT = "vmCont"
    EP_CLASS_ID_VM_DC = "vmDC"
    EP_CLASS_ID_VM_DCORG = "vmDCOrg"
    EP_CLASS_ID_VM_DIR_CONT = "vmDirCont"
    EP_CLASS_ID_VM_EP = "vmEp"
    EP_CLASS_ID_VM_HBA = "vmHba"
    EP_CLASS_ID_VM_HV = "vmHv"
    EP_CLASS_ID_VM_INSTANCE = "vmInstance"
    EP_CLASS_ID_VM_LIFE_CYCLE_POLICY = "vmLifeCyclePolicy"
    EP_CLASS_ID_VM_LIFE_CYCLE_POLICY_FSM = "vmLifeCyclePolicyFsm"
    EP_CLASS_ID_VM_LIFE_CYCLE_POLICY_FSM_STAGE = "vmLifeCyclePolicyFsmStage"
    EP_CLASS_ID_VM_LIFE_CYCLE_POLICY_FSM_TASK = "vmLifeCyclePolicyFsmTask"
    EP_CLASS_ID_VM_NIC = "vmNic"
    EP_CLASS_ID_VM_ORG = "vmOrg"
    EP_CLASS_ID_VM_SWITCH = "vmSwitch"
    EP_CLASS_ID_VM_VIF = "vmVif"
    EP_CLASS_ID_VM_VIRTUAL = "vmVirtual"
    EP_CLASS_ID_VM_VLAN = "vmVlan"
    EP_CLASS_ID_VM_VNIC_PROF_CL = "vmVnicProfCl"
    EP_CLASS_ID_VM_VNIC_PROF_INST = "vmVnicProfInst"
    EP_CLASS_ID_VM_VSAN = "vmVsan"
    EP_CLASS_ID_VNIC_ABEH = "vnicABeh"
    EP_CLASS_ID_VNIC_AETHER_IF = "vnicAEtherIf"
    EP_CLASS_ID_VNIC_AFC_IF = "vnicAFcIf"
    EP_CLASS_ID_VNIC_AGROUP = "vnicAGroup"
    EP_CLASS_ID_VNIC_AIPC_IF = "vnicAIpcIf"
    EP_CLASS_ID_VNIC_ASCSI_IF = "vnicAScsiIf"
    EP_CLASS_ID_VNIC_BOOT_IP_POLICY = "vnicBootIpPolicy"
    EP_CLASS_ID_VNIC_BOOT_TARGET = "vnicBootTarget"
    EP_CLASS_ID_VNIC_CON_POLICY_REF = "vnicConPolicyRef"
    EP_CLASS_ID_VNIC_CON_REQ = "vnicConReq"
    EP_CLASS_ID_VNIC_CONN_DEF = "vnicConnDef"
    EP_CLASS_ID_VNIC_CONNECTION = "vnicConnection"
    EP_CLASS_ID_VNIC_DEF_BEH = "vnicDefBeh"
    EP_CLASS_ID_VNIC_DYNAMIC_CON = "vnicDynamicCon"
    EP_CLASS_ID_VNIC_DYNAMIC_CON_POLICY = "vnicDynamicConPolicy"
    EP_CLASS_ID_VNIC_DYNAMIC_CON_POLICY_REF = "vnicDynamicConPolicyRef"
    EP_CLASS_ID_VNIC_DYNAMIC_CON_REQ = "vnicDynamicConReq"
    EP_CLASS_ID_VNIC_DYNAMIC_ID_UNIVERSE = "vnicDynamicIdUniverse"
    EP_CLASS_ID_VNIC_DYNAMIC_PROVIDER = "vnicDynamicProvider"
    EP_CLASS_ID_VNIC_DYNAMIC_PROVIDER_EP = "vnicDynamicProviderEp"
    EP_CLASS_ID_VNIC_ETH_CONFIG = "vnicEthConfig"
    EP_CLASS_ID_VNIC_ETH_LIF = "vnicEthLif"
    EP_CLASS_ID_VNIC_ETHER = "vnicEther"
    EP_CLASS_ID_VNIC_ETHER_BASE = "vnicEtherBase"
    EP_CLASS_ID_VNIC_ETHER_BASE_IF = "vnicEtherBaseIf"
    EP_CLASS_ID_VNIC_ETHER_IF = "vnicEtherIf"
    EP_CLASS_ID_VNIC_FC = "vnicFc"
    EP_CLASS_ID_VNIC_FC_BASE = "vnicFcBase"
    EP_CLASS_ID_VNIC_FC_GROUP_DEF = "vnicFcGroupDef"
    EP_CLASS_ID_VNIC_FC_GROUP_TEMPL = "vnicFcGroupTempl"
    EP_CLASS_ID_VNIC_FC_IF = "vnicFcIf"
    EP_CLASS_ID_VNIC_FC_LIF = "vnicFcLif"
    EP_CLASS_ID_VNIC_FC_NODE = "vnicFcNode"
    EP_CLASS_ID_VNIC_FC_OEIF = "vnicFcOEIf"
    EP_CLASS_ID_VNIC_IPIF = "vnicIPIf"
    EP_CLASS_ID_VNIC_IPV4_DHCP = "vnicIPv4Dhcp"
    EP_CLASS_ID_VNIC_IPV4_DNS = "vnicIPv4Dns"
    EP_CLASS_ID_VNIC_IPV4_IF = "vnicIPv4If"
    EP_CLASS_ID_VNIC_IPV4_ISCSI_ADDR = "vnicIPv4IscsiAddr"
    EP_CLASS_ID_VNIC_IPV4_POOLED_ISCSI_ADDR = "vnicIPv4PooledIscsiAddr"
    EP_CLASS_ID_VNIC_IPV4_STATIC_ROUTE = "vnicIPv4StaticRoute"
    EP_CLASS_ID_VNIC_IPV6_IF = "vnicIPv6If"
    EP_CLASS_ID_VNIC_ISCSI = "vnicIScsi"
    EP_CLASS_ID_VNIC_ISCSI_AUTO_TARGET_IF = "vnicIScsiAutoTargetIf"
    EP_CLASS_ID_VNIC_ISCSI_BASE = "vnicIScsiBase"
    EP_CLASS_ID_VNIC_ISCSI_BOOT_PARAMS = "vnicIScsiBootParams"
    EP_CLASS_ID_VNIC_ISCSI_BOOT_VNIC = "vnicIScsiBootVnic"
    EP_CLASS_ID_VNIC_ISCSI_CONFIG = "vnicIScsiConfig"
    EP_CLASS_ID_VNIC_ISCSI_INIT_AUTO_CONFIG_POLICY = "vnicIScsiInitAutoConfigPolicy"
    EP_CLASS_ID_VNIC_ISCSI_LCP = "vnicIScsiLCP"
    EP_CLASS_ID_VNIC_ISCSI_NODE = "vnicIScsiNode"
    EP_CLASS_ID_VNIC_ISCSI_STATIC_TARGET_IF = "vnicIScsiStaticTargetIf"
    EP_CLASS_ID_VNIC_ISCSI_TARGET_IF = "vnicIScsiTargetIf"
    EP_CLASS_ID_VNIC_IF = "vnicIf"
    EP_CLASS_ID_VNIC_IF_ROLE = "vnicIfRole"
    EP_CLASS_ID_VNIC_INITIATOR_AUTO_CONFIG_POLICY = "vnicInitiatorAutoConfigPolicy"
    EP_CLASS_ID_VNIC_INTERNAL_PROFILE = "vnicInternalProfile"
    EP_CLASS_ID_VNIC_IP_ADDR = "vnicIpAddr"
    EP_CLASS_ID_VNIC_IP_V4_ADDR = "vnicIpV4Addr"
    EP_CLASS_ID_VNIC_IP_V4_ADDR_CONF = "vnicIpV4AddrConf"
    EP_CLASS_ID_VNIC_IP_V4_ADDR_EXPL_CONF = "vnicIpV4AddrExplConf"
    EP_CLASS_ID_VNIC_IP_V4_HISTORY = "vnicIpV4History"
    EP_CLASS_ID_VNIC_IP_V4_MGMT_POOLED_ADDR = "vnicIpV4MgmtPooledAddr"
    EP_CLASS_ID_VNIC_IP_V4_POOLED_ADDR = "vnicIpV4PooledAddr"
    EP_CLASS_ID_VNIC_IP_V4_PROF_DERIVED_ADDR = "vnicIpV4ProfDerivedAddr"
    EP_CLASS_ID_VNIC_IP_V4_STATIC_ADDR = "vnicIpV4StaticAddr"
    EP_CLASS_ID_VNIC_IP_V6_ADDR = "vnicIpV6Addr"
    EP_CLASS_ID_VNIC_IP_V6_ADDR_CONF = "vnicIpV6AddrConf"
    EP_CLASS_ID_VNIC_IP_V6_ADDR_EXPL_CONF = "vnicIpV6AddrExplConf"
    EP_CLASS_ID_VNIC_IP_V6_HISTORY = "vnicIpV6History"
    EP_CLASS_ID_VNIC_IP_V6_MGMT_POOLED_ADDR = "vnicIpV6MgmtPooledAddr"
    EP_CLASS_ID_VNIC_IP_V6_STATIC_ADDR = "vnicIpV6StaticAddr"
    EP_CLASS_ID_VNIC_IPC = "vnicIpc"
    EP_CLASS_ID_VNIC_IPC_IF = "vnicIpcIf"
    EP_CLASS_ID_VNIC_IQN_HISTORY = "vnicIqnHistory"
    EP_CLASS_ID_VNIC_L2_IF = "vnicL2If"
    EP_CLASS_ID_VNIC_L2_LIF = "vnicL2Lif"
    EP_CLASS_ID_VNIC_L3_IF = "vnicL3If"
    EP_CLASS_ID_VNIC_LAN_CONN_POLICY = "vnicLanConnPolicy"
    EP_CLASS_ID_VNIC_LAN_CONN_TEMPL = "vnicLanConnTempl"
    EP_CLASS_ID_VNIC_LIF_VLAN = "vnicLifVlan"
    EP_CLASS_ID_VNIC_LIF_VSAN = "vnicLifVsan"
    EP_CLASS_ID_VNIC_LUN = "vnicLun"
    EP_CLASS_ID_VNIC_MAC_HISTORY = "vnicMacHistory"
    EP_CLASS_ID_VNIC_NIC_CONN = "vnicNicConn"
    EP_CLASS_ID_VNIC_OPROFILE_ALIAS = "vnicOProfileAlias"
    EP_CLASS_ID_VNIC_PROFILE = "vnicProfile"
    EP_CLASS_ID_VNIC_PROFILE_ALIAS = "vnicProfileAlias"
    EP_CLASS_ID_VNIC_PROFILE_REF = "vnicProfileRef"
    EP_CLASS_ID_VNIC_PROFILE_SET = "vnicProfileSet"
    EP_CLASS_ID_VNIC_PROFILE_SET_FSM = "vnicProfileSetFsm"
    EP_CLASS_ID_VNIC_PROFILE_SET_FSM_STAGE = "vnicProfileSetFsmStage"
    EP_CLASS_ID_VNIC_PROFILE_SET_FSM_TASK = "vnicProfileSetFsmTask"
    EP_CLASS_ID_VNIC_RACK_SERVER_DISCOVERY_PROFILE = "vnicRackServerDiscoveryProfile"
    EP_CLASS_ID_VNIC_SAN_CONN_POLICY = "vnicSanConnPolicy"
    EP_CLASS_ID_VNIC_SAN_CONN_TEMPL = "vnicSanConnTempl"
    EP_CLASS_ID_VNIC_SCSI = "vnicScsi"
    EP_CLASS_ID_VNIC_SCSI_IF = "vnicScsiIf"
    EP_CLASS_ID_VNIC_TEMPL = "vnicTempl"
    EP_CLASS_ID_VNIC_USNIC_CON_POLICY = "vnicUsnicConPolicy"
    EP_CLASS_ID_VNIC_USNIC_CON_POLICY_REF = "vnicUsnicConPolicyRef"
    EP_CLASS_ID_VNIC_USNIC_CON_REQ = "vnicUsnicConReq"
    EP_CLASS_ID_VNIC_VPROFILE_ALIAS = "vnicVProfileAlias"
    EP_CLASS_ID_VNIC_VHBA_BEH_POLICY = "vnicVhbaBehPolicy"
    EP_CLASS_ID_VNIC_VLAN = "vnicVlan"
    EP_CLASS_ID_VNIC_VMQ_CON_POLICY = "vnicVmqConPolicy"
    EP_CLASS_ID_VNIC_VMQ_CON_POLICY_REF = "vnicVmqConPolicyRef"
    EP_CLASS_ID_VNIC_VMQ_CON_REQ = "vnicVmqConReq"
    EP_CLASS_ID_VNIC_VNIC = "vnicVnic"
    EP_CLASS_ID_VNIC_VNIC_BEH_POLICY = "vnicVnicBehPolicy"
    EP_CLASS_ID_VNIC_WWNN_HISTORY = "vnicWwnnHistory"
    EP_CLASS_ID_VNIC_WWPN_HISTORY = "vnicWwpnHistory"


class GmetaClass(ManagedObject):
    """This is GmetaClass class."""

    consts = GmetaClassConsts()
    naming_props = set([u'id'])

    mo_meta = MoMeta("GmetaClass", "gmetaClass", "class-[id]", VersionMeta.Version212a, "InputOutput", 0x7f, [], ["admin"], [u'gmetaHolder'], [u'gmetaProp'], [None])

    prop_meta = {
        "admin_prop_mask": MoPropertyMeta("admin_prop_mask", "adminPropMask", "ulong", VersionMeta.Version212a, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "child_action": MoPropertyMeta("child_action", "childAction", "string", VersionMeta.Version212a, MoPropertyMeta.INTERNAL, 0x2, None, None, r"""((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], []), 
        "dn": MoPropertyMeta("dn", "dn", "string", VersionMeta.Version212a, MoPropertyMeta.READ_ONLY, 0x4, 0, 256, None, [], []), 
        "ep_class_id": MoPropertyMeta("ep_class_id", "epClassId", "string", VersionMeta.Version212a, MoPropertyMeta.READ_ONLY, None, None, None, None, ["aaaAuthMethod", "aaaAuthRealm", "aaaAuthRealmFsm", "aaaAuthRealmFsmStage", "aaaBanner", "aaaCimcSession", "aaaConfig", "aaaConsoleAuth", "aaaDefaultAuth", "aaaDefinition", "aaaDomain", "aaaDomainAuth", "aaaEp", "aaaEpAuthProfile", "aaaEpFsm", "aaaEpFsmStage", "aaaEpFsmTask", "aaaEpLogin", "aaaEpUser", "aaaExtMgmtCutThruTkn", "aaaItem", "aaaLdapEp", "aaaLdapEpFsm", "aaaLdapEpFsmStage", "aaaLdapGroup", "aaaLdapGroupRule", "aaaLdapProvider", "aaaLocale", "aaaLog", "aaaModLR", "aaaOrg", "aaaPreLoginBanner", "aaaProvider", "aaaProviderGroup", "aaaProviderRef", "aaaPwdProfile", "aaaRadiusEp", "aaaRadiusEpFsm", "aaaRadiusEpFsmStage", "aaaRadiusProvider", "aaaRealm", "aaaRealmFsm", "aaaRealmFsmStage", "aaaRealmFsmTask", "aaaRemoteUser", "aaaRole", "aaaSession", "aaaSessionInfo", "aaaSessionInfoTable", "aaaSessionLR", "aaaShellLogin", "aaaSshAuth", "aaaSystemUser", "aaaTacacsPlusEp", "aaaTacacsPlusEpFsm", "aaaTacacsPlusEpFsmStage", "aaaTacacsPlusProvider", "aaaUser", "aaaUserAction", "aaaUserData", "aaaUserEp", "aaaUserEpFsm", "aaaUserEpFsmStage", "aaaUserEpFsmTask", "aaaUserGroup", "aaaUserLocale", "aaaUserLogin", "aaaUserRole", "aaaWebLogin", "adaptorBehCap", "adaptorCIoEp", "adaptorCapDef", "adaptorCapQual", "adaptorCapSpec", "adaptorDiagCap", "adaptorDynamicConfigCap", "adaptorEthAdvFilterProfile", "adaptorEthArfsProfile", "adaptorEthCompQueueProfile", "adaptorEthFailoverProfile", "adaptorEthInterruptProfile", "adaptorEthInterruptScalingProfile", "adaptorEthNVGREProfile", "adaptorEthOffloadProfile", "adaptorEthPortBySizeLargeStats", "adaptorEthPortBySizeLargeStatsHist", "adaptorEthPortBySizeSmallStats", "adaptorEthPortBySizeSmallStatsHist", "adaptorEthPortErrStats", "adaptorEthPortErrStatsHist", "adaptorEthPortMcastStats", "adaptorEthPortMcastStatsHist", "adaptorEthPortOutsizedStats", "adaptorEthPortOutsizedStatsHist", "adaptorEthPortStats", "adaptorEthPortStatsHist", "adaptorEthQueueProfile", "adaptorEthRecvQueueProfile", "adaptorEthRoCEProfile", "adaptorEthVxLANProfile", "adaptorEthWorkQueueProfile", "adaptorEtherIfStats", "adaptorEtherIfStatsHist", "adaptorExtEthIf", "adaptorExtEthIfFsm", "adaptorExtEthIfFsmStage", "adaptorExtEthIfFsmTask", "adaptorExtEthIfPc", "adaptorExtEthIfPcEp", "adaptorExtIf", "adaptorExtIfEp", "adaptorExtIfPc", "adaptorExtIpV6RssHashProfile", "adaptorExternalEp", "adaptorExternalPc", "adaptorFamilyTypeDef", "adaptorFcCdbWorkQueueProfile", "adaptorFcErrorRecoveryProfile", "adaptorFcFnicProfile", "adaptorFcIfEventStats", "adaptorFcIfEventStatsHist", "adaptorFcIfFC4Stats", "adaptorFcIfFC4StatsHist", "adaptorFcIfFrameStats", "adaptorFcIfFrameStatsHist", "adaptorFcInterruptProfile", "adaptorFcLogiProfile", "adaptorFcOEIf", "adaptorFcPortFLogiProfile", "adaptorFcPortPLogiProfile", "adaptorFcPortProfile", "adaptorFcPortStats", "adaptorFcPortStatsHist", "adaptorFcQueueProfile", "adaptorFcRecvQueueProfile", "adaptorFcWorkQueueProfile", "adaptorFruCapProvider", "adaptorFruCapRef", "adaptorFwCapProvider", "adaptorHostEthIf", "adaptorHostEthIfFsm", "adaptorHostEthIfFsmStage", "adaptorHostEthIfFsmTask", "adaptorHostEthIfProfile", "adaptorHostFcIf", "adaptorHostFcIfFsm", "adaptorHostFcIfFsmStage", "adaptorHostFcIfFsmTask", "adaptorHostFcIfProfile", "adaptorHostIf", "adaptorHostIfConfig", "adaptorHostIfConnDef", "adaptorHostIfProfile", "adaptorHostIscsiIf", "adaptorHostIscsiIfProfile", "adaptorHostMgmtCap", "adaptorHostPort", "adaptorHostPortCap", "adaptorHostScsiIf", "adaptorHostScsiLunRef", "adaptorHostServiceEthIf", "adaptorHostVnicHwAddrCap", "adaptorHostethHwAddrCap", "adaptorHostfcHwAddrCap", "adaptorHwAddrCap", "adaptorIScsiCap", "adaptorIpV4RssHashProfile", "adaptorIpV6RssHashProfile", "adaptorIscsiAuth", "adaptorIscsiProt", "adaptorIscsiTargetIf", "adaptorLanCap", "adaptorLldpCap", "adaptorMenloBaseErrorStats", "adaptorMenloBaseErrorStatsHist", "adaptorMenloDcePortStats", "adaptorMenloDcePortStatsHist", "adaptorMenloEthErrorStats", "adaptorMenloEthErrorStatsHist", "adaptorMenloEthStats", "adaptorMenloEthStatsHist", "adaptorMenloFcErrorStats", "adaptorMenloFcErrorStatsHist", "adaptorMenloFcStats", "adaptorMenloFcStatsHist", "adaptorMenloHostPortStats", "adaptorMenloHostPortStatsHist", "adaptorMenloMcpuErrorStats", "adaptorMenloMcpuErrorStatsHist", "adaptorMenloMcpuStats", "adaptorMenloMcpuStatsHist", "adaptorMenloNetEgStats", "adaptorMenloNetEgStatsHist", "adaptorMenloNetInStats", "adaptorMenloNetInStatsHist", "adaptorMenloQErrorStats", "adaptorMenloQErrorStatsHist", "adaptorMenloQStats", "adaptorMenloQStatsHist", "adaptorMgmtCap", "adaptorMgmtVnicEthConfig", "adaptorNwMgmtCap", "adaptorNwStatsMgmtCap", "adaptorPIoEp", "adaptorProfileItem", "adaptorProtocolProfile", "adaptorQual", "adaptorQueueProfile", "adaptorRnicCapSpec", "adaptorRssHashProfile", "adaptorRssProfile", "adaptorSanCap", "adaptorTcpIpRssHashProfile", "adaptorUnit", "adaptorUnitAssocCtx", "adaptorUnitExtn", "adaptorUplinkHwAddrCap", "adaptorUplinkPortStats", "adaptorUsnicConnDef", "adaptorVlan", "adaptorVnicStats", "adaptorVnicStatsHist", "adaptorVsan", "apeAdapter", "apeAdapterVnic", "apeAttribute", "apeBootMethod", "apeControllerChassis", "apeControllerEeprom", "apeControllerManager", "apeDcosAgManager", "apeFru", "apeHostAgent", "apeLANBoot", "apeLocalDiskBoot", "apeManager", "apeMc", "apeMcStats", "apeMcTable", "apeMenlo", "apeMenloVnic", "apeMenloVnicStats", "apeNicAgManager", "apePalo", "apePaloVnic", "apePaloVnicStats", "apeParam", "apeReading", "apeSANBoot", "apeSdr", "apeSwitchFirmwareInv", "apeVirtualMediaBoot", "apeVnicStats", "biosARef", "biosBOT", "biosBootDev", "biosBootDevGrp", "biosFeatureRef", "biosParameterRef", "biosRef", "biosSettingRef", "biosSettings", "biosUnit", "biosVFeat", "biosVIdentityParams", "biosVProfile", "biosVfACPI10Support", "biosVfASPMSupport", "biosVfAllUSBDevices", "biosVfAltitude", "biosVfAssertNMIOnPERR", "biosVfAssertNMIOnSERR", "biosVfBootOptionRetry", "biosVfCPUHardwarePowerManagement", "biosVfCPUPerformance", "biosVfCPUPowerManagement", "biosVfConsistentDeviceNameControl", "biosVfConsoleRedirection", "biosVfCoreMultiProcessing", "biosVfDDR3VoltageSelection", "biosVfDRAMClockThrottling", "biosVfDirectCacheAccess", "biosVfDramRefreshRate", "biosVfEnergyPerformanceTuning", "biosVfEnhancedIntelSpeedStepTech", "biosVfEnhancedPowerCappingSupport", "biosVfExecuteDisableBit", "biosVfFRB2Timer", "biosVfFrequencyFloorOverride", "biosVfFrontPanelLockout", "biosVfIOEMezz1OptionROM", "biosVfIOENVMe1OptionROM", "biosVfIOENVMe2OptionROM", "biosVfIOESlot1OptionROM", "biosVfIOESlot2OptionROM", "biosVfIntegratedGraphics", "biosVfIntegratedGraphicsApertureSize", "biosVfIntelEntrySASRAIDModule", "biosVfIntelHyperThreadingTech", "biosVfIntelTrustedExecutionTechnology", "biosVfIntelTurboBoostTech", "biosVfIntelVTForDirectedIO", "biosVfIntelVirtualizationTechnology", "biosVfInterleaveConfiguration", "biosVfLocalX2Apic", "biosVfLvDIMMSupport", "biosVfMaxVariableMTRRSetting", "biosVfMaximumMemoryBelow4GB", "biosVfMemoryMappedIOAbove4GB", "biosVfMirroringMode", "biosVfNUMAOptimized", "biosVfOSBootWatchdogTimer", "biosVfOSBootWatchdogTimerPolicy", "biosVfOSBootWatchdogTimerTimeout", "biosVfOnboardGraphics", "biosVfOnboardSATAController", "biosVfOnboardStorage", "biosVfOptionROMEnable", "biosVfOptionROMLoad", "biosVfOutOfBandManagement", "biosVfPCHSATAMode", "biosVfPCILOMPortsConfiguration", "biosVfPCIROMCLP", "biosVfPCISlotLinkSpeed", "biosVfPCISlotOptionROMEnable", "biosVfPOSTErrorPause", "biosVfPSTATECoordination", "biosVfPackageCStateLimit", "biosVfProcessorC1E", "biosVfProcessorC3Report", "biosVfProcessorC6Report", "biosVfProcessorC7Report", "biosVfProcessorCMCI", "biosVfProcessorCState", "biosVfProcessorEnergyConfiguration", "biosVfProcessorPrefetchConfig", "biosVfQPILinkFrequencySelect", "biosVfQPISnoopMode", "biosVfQuietBoot", "biosVfRedirectionAfterBIOSPOST", "biosVfResumeOnACPowerLoss", "biosVfSBMezz1OptionROM", "biosVfSBNVMe1OptionROM", "biosVfSIOC1OptionROM", "biosVfSIOC2OptionROM", "biosVfScrubPolicies", "biosVfSelectMemoryRASConfiguration", "biosVfSerialPortAEnable", "biosVfSparingMode", "biosVfSriovConfig", "biosVfTPMPendingOperation", "biosVfTPMSupport", "biosVfTrustedPlatformModule", "biosVfUCSMBootModeControl", "biosVfUCSMBootOrderRuleControl", "biosVfUEFIOSUseLegacyVideo", "biosVfUSBBootConfig", "biosVfUSBConfiguration", "biosVfUSBFrontPanelAccessLock", "biosVfUSBPortConfiguration", "biosVfUSBSystemIdlePowerOptimizingSetting", "biosVfVGAPriority", "biosVfWorkloadConfiguration", "bmcSELCounter", "callhomeAnonymousReporting", "callhomeDest", "callhomeEp", "callhomeEpFsm", "callhomeEpFsmStage", "callhomeEpFsmTask", "callhomeItem", "callhomePeriodicSystemInventory", "callhomePolicy", "callhomeProfile", "callhomeSmtp", "callhomeSource", "callhomeTestAlert", "capabilityCatalogue", "capabilityCatalogueFsm", "capabilityCatalogueFsmStage", "capabilityCatalogueFsmTask", "capabilityDef", "capabilityEp", "capabilityFeatureLimits", "capabilityItem", "capabilityMgmtExtension", "capabilityMgmtExtensionFsm", "capabilityMgmtExtensionFsmStage", "capabilityMgmtExtensionFsmTask", "capabilityNetworkLimits", "capabilityProvider", "capabilityStorageLimits", "capabilitySystemLimits", "capabilityUpdate", "capabilityUpdater", "capabilityUpdaterFsm", "capabilityUpdaterFsmStage", "capabilityUpdaterFsmTask", "changeChangedObjectRef", "cimcvmediaActualMountEntry", "cimcvmediaActualMountList", "cimcvmediaConfigMountEntry", "cimcvmediaExtMgmtRuleEntry", "cimcvmediaItem", "cimcvmediaMountConfig", "cimcvmediaMountConfigDef", "cimcvmediaMountConfigPolicy", "cimcvmediaMountInfo", "clitestTypeTest", "clitestTypeTest2", "clitestTypeTestChild", "clitestTypeTestParent", "commCimcWebService", "commCimxml", "commClient", "commClientItem", "commDateTime", "commDefinition", "commDns", "commDnsProvider", "commEvtChannel", "commHttp", "commHttps", "commItem", "commLocale", "commNtpProvider", "commShell", "commShellSvcLimits", "commSmashCLP", "commSnmp", "commSnmpTrap", "commSnmpUser", "commSsh", "commSvc", "commSvcChannel", "commSvcEp", "commSvcEpFsm", "commSvcEpFsmStage", "commSvcEpFsmTask", "commSvcLimits", "commSvcPolicy", "commSyslog", "commSyslogClient", "commSyslogConsole", "commSyslogFile", "commSyslogMonitor", "commSyslogSource", "commTelnet", "commWeb", "commWebChannel", "commWebSvcLimits", "commWsman", "commXmlClConnPolicy", "computeABoard", "computeAChassisDiscPolicy", "computeAutoconfigPolicy", "computeBehCap", "computeBlade", "computeBladeDiscPolicy", "computeBladeEp", "computeBladeFsm", "computeBladeFsmStage", "computeBladeFsmTask", "computeBladeInheritPolicy", "computeBladePosQual", "computeBoard", "computeBoardConnector", "computeBoardController", "computeCartridge", "computeChassisConnPolicy", "computeChassisDiscPolicy", "computeChassisQual", "computeComputeDiscPolicy", "computeConfigPolicy", "computeConstraintDef", "computeContainer", "computeDefaults", "computeDiscPolicy", "computeExtBoard", "computeFactoryResetOperation", "computeFwSyncAck", "computeHealthLedSensorAlarm", "computeIOHub", "computeIOHubEnvStats", "computeIOHubEnvStatsHist", "computeInitConfigPolicy", "computeInstanceIdQual", "computeItem", "computeKvmMgmtPolicy", "computeLogical", "computeMbPowerStats", "computeMbPowerStatsHist", "computeMbTempStats", "computeMbTempStatsHist", "computeMemoryConfigPolicy", "computeMemoryConfiguration", "computeMemoryUnitConstraintDef", "computePCIeFatalCompletionStats", "computePCIeFatalProtocolStats", "computePCIeFatalReceiveStats", "computePCIeFatalStats", "computePartition", "computePciCap", "computePciSlotScanDef", "computePhysical", "computePhysicalAssocCtx", "computePhysicalFsm", "computePhysicalFsmStage", "computePhysicalFsmTask", "computePhysicalQual", "computePlatform", "computePnuOSImage", "computePool", "computePoolPolicyRef", "computePoolable", "computePooled", "computePooledEnclosureComputeSlot", "computePooledPhysical", "computePooledRackUnit", "computePooledSlot", "computePoolingPolicy", "computePowerSyncDef", "computePowerSyncPolicy", "computePsuControl", "computePsuDef", "computePsuPolicy", "computeQual", "computeQualBase", "computeQualItem", "computeQualifiedPolicy", "computeRackPosQual", "computeRackQual", "computeRackUnit", "computeRackUnitFsm", "computeRackUnitFsmStage", "computeRackUnitFsmTask", "computeRackUnitMbTempStats", "computeRackUnitMbTempStatsHist", "computeRtcBattery", "computeScrubPolicy", "computeServer", "computeServerDiscPolicy", "computeServerDiscPolicyFsm", "computeServerDiscPolicyFsmStage", "computeServerDiscPolicyFsmTask", "computeServerMgmtPolicy", "computeServerTypeCap", "computeServerUnit", "computeServerUnitFsm", "computeServerUnitFsmStage", "computeServerUnitFsmTask", "computeSlotEntity", "computeSlotQual", "computeVirtual", "computeVirtualContainer", "conditionImmutable", "conditionInfo", "conditionLog", "conditionLoggable", "conditionMultiInstanceImmutable", "conditionMutable", "conditionPolicy", "conditionReportable", "configImpact", "configImpactResponse", "configManagedEpImpactResponse", "configSorter", "controllerHaController", "controllerOperationalVersionHolder", "controllerPreferedVersionHolder", "cpmaintAck", "cpmaintMaintPolicy", "dcxFcoeVifEp", "dcxNs", "dcxUniverse", "dcxVIf", "dcxVc", "dcxVifEp", "dhcpAcquired", "dhcpInst", "dhcpLease", "diagBladeTest", "diagCtrl", "diagNetworkTest", "diagRslt", "diagRunPolicy", "diagSrvCapProvider", "diagSrvCtrl", "diagTest", "domainEnvironmentFeature", "domainEnvironmentFeatureCont", "domainEnvironmentParam", "domainFeature", "domainFeatureCont", "domainNetworkFeature", "domainNetworkFeatureCont", "domainNetworkParam", "domainParameter", "domainServerFeature", "domainServerFeatureCont", "domainServerParam", "domainStorageFeature", "domainStorageFeatureCont", "domainStorageParam", "dpsecMac", "dupeScope", "dupeScopeResult", "epqosDefinition", "epqosDefinitionDelTask", "epqosDefinitionDelTaskFsm", "epqosDefinitionDelTaskFsmStage", "epqosDefinitionDelTaskFsmTask", "epqosDefinitionFsm", "epqosDefinitionFsmStage", "epqosDefinitionFsmTask", "epqosEgress", "epqosItem", "equipmentAdaptorConnDef", "equipmentAdaptorDef", "equipmentAdvancedBootOrder", "equipmentAssocCtx", "equipmentAutoconfigPolicy", "equipmentBaseBoardCapProvider", "equipmentBeaconCapProvider", "equipmentBeaconLed", "equipmentBeaconLedFsm", "equipmentBeaconLedFsmStage", "equipmentBeaconLedFsmTask", "equipmentBehCap", "equipmentBinding", "equipmentBiosDef", "equipmentBladeAGLibrary", "equipmentBladeAggregationCapRef", "equipmentBladeBiosCapProvider", "equipmentBladeCapProvider", "equipmentBladeCapProviderTypeDef", "equipmentBladeConnDef", "equipmentBladeIOMConnDef", "equipmentBladeSwitchConnDef", "equipmentBoardControllerDef", "equipmentBootDeviceConstraints", "equipmentBreakoutCap", "equipmentCapModSpec", "equipmentCard", "equipmentCartridgeCapProvider", "equipmentCatalogCapProvider", "equipmentChassis", "equipmentChassisAssocCtx", "equipmentChassisCapProvider", "equipmentChassisFsm", "equipmentChassisFsmStage", "equipmentChassisFsmTask", "equipmentChassisInheritPolicy", "equipmentChassisIssues", "equipmentChassisPosQual", "equipmentChassisProfile", "equipmentChassisProfileAssocCtx", "equipmentChassisProfileBinding", "equipmentChassisProfileFsm", "equipmentChassisProfileFsmStage", "equipmentChassisProfileFsmTask", "equipmentChassisQual", "equipmentChassisStats", "equipmentChassisStatsHist", "equipmentCimcVmedia", "equipmentCiscoOsOpenGate", "equipmentComputePhysicalCapProvider", "equipmentConfigPolicy", "equipmentDbgPluginCapProvider", "equipmentDimmEntry", "equipmentDimmMapping", "equipmentDiscoveryCap", "equipmentDowngradeConstraint", "equipmentEmbeddedStorageDef", "equipmentEnvSensor", "equipmentFan", "equipmentFanModule", "equipmentFanModuleCapProvider", "equipmentFanModuleDef", "equipmentFanModuleStats", "equipmentFanModuleStatsHist", "equipmentFanStats", "equipmentFanStatsHist", "equipmentFex", "equipmentFexCapProvider", "equipmentFexEnvStats", "equipmentFexEnvStatsHist", "equipmentFexFsm", "equipmentFexFsmStage", "equipmentFexFsmTask", "equipmentFexPowerSummary", "equipmentFexPowerSummaryHist", "equipmentFexPsuInputStats", "equipmentFexPsuInputStatsHist", "equipmentFexSystemStats", "equipmentFexSystemStatsHist", "equipmentFirmwareConstraint", "equipmentFlashLife", "equipmentFruCapProvider", "equipmentGemCapProvider", "equipmentGemPortCap", "equipmentGraphicsCardCapProvider", "equipmentGraphicsCardCapRef", "equipmentHDDFaultMonDef", "equipmentHealthLed", "equipmentHolder", "equipmentHolderCapProvider", "equipmentHostIfCapProvider", "equipmentHwCapDerivativeProvider", "equipmentHwCapProvider", "equipmentHwRevisionModifier", "equipmentIOCard", "equipmentIOCardBase", "equipmentIOCardBaseFsm", "equipmentIOCardBaseFsmStage", "equipmentIOCardBaseFsmTask", "equipmentIOCardCapProvider", "equipmentIOCardFsm", "equipmentIOCardFsmStage", "equipmentIOCardFsmTask", "equipmentIOCardStats", "equipmentIOCardStatsHist", "equipmentIOCardTypeDef", "equipmentIOExpander", "equipmentIOExpanderCapProvider", "equipmentInbandMgmtCap", "equipmentIndicatorLed", "equipmentInitConfigPolicy", "equipmentIntegratedComponentCapProvider", "equipmentItem", "equipmentKvmMgmtCap", "equipmentLed", "equipmentLocalDiskCapProvider", "equipmentLocalDiskControllerCapProvider", "equipmentLocalDiskControllerCapRef", "equipmentLocalDiskControllerDef", "equipmentLocalDiskControllerTypeDef", "equipmentLocalDiskDef", "equipmentLocatorLed", "equipmentLocatorLedFsm", "equipmentLocatorLedFsmStage", "equipmentLocatorLedFsmTask", "equipmentManufacturingDef", "equipmentMemoryUnitCapProvider", "equipmentMemoryUnitDiscoveryModifierDef", "equipmentMgmtCapProvider", "equipmentMgmtExtCapProvider", "equipmentNetworkElementFanStats", "equipmentNetworkElementFanStatsHist", "equipmentNonCopperPassiveCap", "equipmentOnboardDeviceDef", "equipmentPOST", "equipmentPOSTCode", "equipmentPOSTCodeContainer", "equipmentPOSTCodeData", "equipmentPOSTCodeReporter", "equipmentPOSTCodeTemplate", "equipmentPciDef", "equipmentPciSlotIdEntry", "equipmentPciSlotIdMapping", "equipmentPciSlotSubOEMIdEntry", "equipmentPfcMmuCap", "equipmentPhysDevicesPerBoard", "equipmentPhysicalDef", "equipmentPhysicalQual", "equipmentPicture", "equipmentPool", "equipmentPoolPolicyRef", "equipmentPoolable", "equipmentPooled", "equipmentPooledChassis", "equipmentPooledPhysical", "equipmentPoolingPolicy", "equipmentPortCap", "equipmentPortGroupAggregationDef", "equipmentPortGroupDef", "equipmentPortGroupSwComplexDef", "equipmentPortSwComplexRef", "equipmentPowerCapDef", "equipmentProcessorUnitCapProvider", "equipmentProcessorUnitDef", "equipmentPsu", "equipmentPsuCapProvider", "equipmentPsuDef", "equipmentPsuFsm", "equipmentPsuFsmStage", "equipmentPsuFsmTask", "equipmentPsuInputStats", "equipmentPsuInputStatsHist", "equipmentPsuOutputStats", "equipmentPsuOutputStatsHist", "equipmentPsuStats", "equipmentPsuStatsHist", "equipmentQual", "equipmentQualBase", "equipmentQualItem", "equipmentQualifiedPolicy", "equipmentRackFanModuleDef", "equipmentRackUnitCapProvider", "equipmentRackUnitFanStats", "equipmentRackUnitFanStatsHist", "equipmentRackUnitPsuStats", "equipmentRackUnitPsuStatsHist", "equipmentRaidDef", "equipmentRequirement", "equipmentSecureBoot", "equipmentSecureController", "equipmentSecurityUnitCapProvider", "equipmentServerCorrectUuidBehavior", "equipmentServerFeatureCap", "equipmentServerPortCapProvider", "equipmentServerUnitCapProvider", "equipmentServiceDef", "equipmentSharedIOModule", "equipmentSiocTempStats", "equipmentSiocTempStatsHist", "equipmentSlotArray", "equipmentSlotArrayRef", "equipmentSlotEnclosure", "equipmentStateful", "equipmentStatefulBladeComp", "equipmentStatefulChComp", "equipmentStorageControllerConfig", "equipmentStorageControllerSlotDef", "equipmentStorageEncCapProvider", "equipmentStorageLimitCap", "equipmentStorageSasExpanderCapProvider", "equipmentStorageSasExpanderCapRef", "equipmentStorageSasExpanderDef", "equipmentSwitchCap", "equipmentSwitchCapProvider", "equipmentSwitchCard", "equipmentSwitchIOCard", "equipmentSwitchIOCardCapProvider", "equipmentSwitchIOCardFsm", "equipmentSwitchIOCardFsmStage", "equipmentSwitchIOCardFsmTask", "equipmentSwitchTypeDef", "equipmentSystemIOController", "equipmentSystemIOControllerFsm", "equipmentSystemIOControllerFsmStage", "equipmentSystemIOControllerFsmTask", "equipmentTier", "equipmentTpm", "equipmentTpmCapProvider", "equipmentUnifiedPortCapProvider", "equipmentUuidFeatureCap", "equipmentVersionConstraint", "equipmentXcvr", "etherCIoEp", "etherConfig", "etherErrStats", "etherErrStatsHist", "etherExternalEp", "etherExternalPc", "etherFcoeInterfaceStats", "etherFcoeInterfaceStatsHist", "etherIfConfig", "etherIntFIoEp", "etherInternalPc", "etherLossStats", "etherLossStatsHist", "etherNiErrStats", "etherNiErrStatsHist", "etherNicIfConfig", "etherPIo", "etherPIoEndPoint", "etherPIoEp", "etherPIoFsm", "etherPIoFsmStage", "etherPauseStats", "etherPauseStatsHist", "etherPc", "etherPortChanIdElem", "etherPortChanIdUniverse", "etherRxStats", "etherRxStatsHist", "etherServerIntFIo", "etherServerIntFIoFsm", "etherServerIntFIoFsmStage", "etherServerIntFIoFsmTask", "etherServerIntFIoPc", "etherServerIntFIoPcEp", "etherSwIfConfig", "etherSwitchIntFIo", "etherSwitchIntFIoPc", "etherSwitchIntFIoPcEp", "etherTxStats", "etherTxStatsHist", "eventEpCtrl", "eventHolder", "eventInst", "eventLog", "eventPolicy", "eventRecord", "extmgmtArpTargets", "extmgmtGatewayPing", "extmgmtIf", "extmgmtIfMonPolicy", "extmgmtMiiStatus", "extmgmtNdiscTargets", "extpolClient", "extpolClientCont", "extpolConnector", "extpolConnectorContainer", "extpolController", "extpolControllerCont", "extpolEp", "extpolEpFsm", "extpolEpFsmStage", "extpolEpFsmTask", "extpolProvider", "extpolProviderCont", "extpolProviderFsm", "extpolProviderFsmStage", "extpolProviderFsmTask", "extpolRegistry", "extpolRegistryFsm", "extpolRegistryFsmStage", "extpolRegistryFsmTask", "extpolSvc", "extpolSystemContext", "extvmmEp", "extvmmEpFsm", "extvmmEpFsmStage", "extvmmEpFsmTask", "extvmmFNDReference", "extvmmFabricNetwork", "extvmmFabricNetworkDefinition", "extvmmKeyInst", "extvmmKeyRing", "extvmmKeyStore", "extvmmKeyStoreFsm", "extvmmKeyStoreFsmStage", "extvmmKeyStoreFsmTask", "extvmmMasterExtKey", "extvmmMasterExtKeyFsm", "extvmmMasterExtKeyFsmStage", "extvmmMasterExtKeyFsmTask", "extvmmNetworkSets", "extvmmNetworkSetsFsm", "extvmmNetworkSetsFsmStage", "extvmmNetworkSetsFsmTask", "extvmmProvider", "extvmmProviderFsm", "extvmmProviderFsmStage", "extvmmProviderFsmTask", "extvmmSwitchDelTask", "extvmmSwitchDelTaskFsm", "extvmmSwitchDelTaskFsmStage", "extvmmSwitchDelTaskFsmTask", "extvmmSwitchSet", "extvmmUpLinkPP", "extvmmVMNDRef", "extvmmVMNetwork", "extvmmVMNetworkDefinition", "extvmmVMNetworkSets", "fabricADceSwSrvEp", "fabricAEthEstcEp", "fabricAEthLanEp", "fabricAFcEstcEp", "fabricAFcSanEp", "fabricAFcoeEstcEp", "fabricAFcoeSanEp", "fabricAVlan", "fabricAVsan", "fabricBHVlan", "fabricBreakout", "fabricCIoEp", "fabricCabling", "fabricCablingSw", "fabricCartridgePhEp", "fabricCartridgeSlotEp", "fabricCartridgeSlotEpFsm", "fabricCartridgeSlotEpFsmStage", "fabricCartridgeSlotEpFsmTask", "fabricCdpLinkPolicy", "fabricChangedObjectRef", "fabricChassisEp", "fabricCloud", "fabricComputeEp", "fabricComputeMSlotEp", "fabricComputeMSlotEpFsm", "fabricComputeMSlotEpFsmStage", "fabricComputeMSlotEpFsmTask", "fabricComputePhEp", "fabricComputeSlotEp", "fabricComputeSlotEpFsm", "fabricComputeSlotEpFsmStage", "fabricComputeSlotEpFsmTask", "fabricDceSrv", "fabricDceSwSrv", "fabricDceSwSrvEp", "fabricDceSwSrvPc", "fabricDceSwSrvPcEp", "fabricDomain", "fabricEp", "fabricEpMgr", "fabricEpMgrFsm", "fabricEpMgrFsmStage", "fabricEpMgrFsmTask", "fabricEpVlan", "fabricEpVsan", "fabricEquipmentEp", "fabricEstcEp", "fabricEstcPc", "fabricEthCdpPolicy", "fabricEthEstc", "fabricEthEstcCloud", "fabricEthEstcEp", "fabricEthEstcPc", "fabricEthEstcPcEp", "fabricEthFlowMonLan", "fabricEthFlowMonSrcRef", "fabricEthLan", "fabricEthLanEp", "fabricEthLanFlowMon", "fabricEthLanFlowMonCollector", "fabricEthLanFlowMonExporter", "fabricEthLanFlowMonSrcEp", "fabricEthLanFlowMonitor", "fabricEthLanFlowMonitoring", "fabricEthLanPc", "fabricEthLanPcEp", "fabricEthLinkPolicy", "fabricEthLinkProfile", "fabricEthMon", "fabricEthMonDestEp", "fabricEthMonFiltEp", "fabricEthMonFiltRef", "fabricEthMonLan", "fabricEthMonSrcEp", "fabricEthMonSrcRef", "fabricEthTargetEp", "fabricEthUdldPolicy", "fabricEthVlanPc", "fabricEthVlanPortEp", "fabricExternal", "fabricExternalEp", "fabricExternalEstc", "fabricExternalPc", "fabricFcEndpoint", "fabricFcEstc", "fabricFcEstcCloud", "fabricFcEstcEp", "fabricFcMon", "fabricFcMonDestEp", "fabricFcMonFiltEp", "fabricFcMonFiltRef", "fabricFcMonSan", "fabricFcMonSrcEp", "fabricFcMonSrcRef", "fabricFcSan", "fabricFcSanEp", "fabricFcSanPc", "fabricFcSanPcEp", "fabricFcUserZone", "fabricFcVsanPc", "fabricFcVsanPortEp", "fabricFcZoneProfile", "fabricFcoeEstcEp", "fabricFcoeSanEp", "fabricFcoeSanPc", "fabricFcoeSanPcEp", "fabricFcoeVsanPc", "fabricFcoeVsanPortEp", "fabricFlowMon", "fabricFlowMonCollector", "fabricFlowMonDefinition", "fabricFlowMonExporter", "fabricFlowMonExporterProfile", "fabricFlowMonItem", "fabricFlowMonSrcEp", "fabricFlowMonSrcRef", "fabricFlowMonitor", "fabricFlowMonitoringCategory", "fabricIf", "fabricInternal", "fabricInternalDceSrv", "fabricInternalEp", "fabricInternalPc", "fabricLacpPolicy", "fabricLan", "fabricLanAccessMgr", "fabricLanCloud", "fabricLanCloudFsm", "fabricLanCloudFsmStage", "fabricLanCloudFsmTask", "fabricLanCloudPolicy", "fabricLanEp", "fabricLanFlowMon", "fabricLanFlowMonCollector", "fabricLanFlowMonExporter", "fabricLanFlowMonSrcEp", "fabricLanFlowMonitor", "fabricLanMonCloud", "fabricLanPc", "fabricLanPinGroup", "fabricLanPinTarget", "fabricLastAckedSlot", "fabricLinkPolicy", "fabricLocale", "fabricMon", "fabricMonDestEp", "fabricMonFiltRef", "fabricMonSrcEp", "fabricMonSrcFiltEp", "fabricMonSrcRef", "fabricMulticastPolicy", "fabricNetGroup", "fabricNetflowCollector", "fabricNetflowIPv4Addr", "fabricNetflowMonExporter", "fabricNetflowMonExporterRef", "fabricNetflowMonSession", "fabricNetflowMonSrcEp", "fabricNetflowMonSrcRef", "fabricNetflowMonitor", "fabricNetflowMonitorRef", "fabricNetflowTimeoutPolicy", "fabricOrgVlanPolicy", "fabricPIoEp", "fabricPath", "fabricPathConn", "fabricPathEp", "fabricPinGroup", "fabricPinTarget", "fabricPoolableVlan", "fabricPooledVlan", "fabricSan", "fabricSanCloud", "fabricSanCloudFsm", "fabricSanCloudFsmStage", "fabricSanCloudFsmTask", "fabricSanEp", "fabricSanMonCloud", "fabricSanPc", "fabricSanPinGroup", "fabricSanPinTarget", "fabricSubGroup", "fabricSwChEp", "fabricSwChPhEp", "fabricSwSrvEp", "fabricSwSrvPc", "fabricSwSubGroup", "fabricTargetEp", "fabricUdldLinkPolicy", "fabricUdldPolicy", "fabricVCon", "fabricVConProfile", "fabricVlan", "fabricVlanEp", "fabricVlanGroupReq", "fabricVlanPermit", "fabricVlanReq", "fabricVnetEp", "fabricVnetEpSyncEp", "fabricVnetEpSyncEpFsm", "fabricVnetEpSyncEpFsmStage", "fabricVnetEpSyncEpFsmTask", "fabricVnetGroupReq", "fabricVnetPermit", "fabricVnetReq", "fabricVsan", "fabricVsanEp", "fabricVsanMembership", "fabricZoneIdUniverse", "faultAffectedClass", "faultBaseHolder", "faultBasePolicy", "faultHolder", "faultInst", "faultLocalTypedHolder", "faultPolicy", "faultSuppressPolicy", "faultSuppressPolicyItem", "faultSuppressTask", "fcConfig", "fcErrStats", "fcErrStatsHist", "fcIfConfig", "fcNicIfConfig", "fcPIo", "fcPIoFsm", "fcPIoFsmStage", "fcStats", "fcStatsHist", "fcSwIfConfig", "fcpoolAddr", "fcpoolBlock", "fcpoolBootTarget", "fcpoolFormat", "fcpoolInitiator", "fcpoolInitiatorEp", "fcpoolInitiators", "fcpoolPoolable", "fcpoolUniverse", "featureBaseRef", "featureContextEp", "featureDefinition", "featureDefinitionInstance", "featureDefinitionRef", "featureFruCapProviderInstance", "featureFruCapProviderRef", "featureProvider", "featureProviderInstance", "firmwareABundleTypeCapProvider", "firmwareAComponentSpec", "firmwareAConstraint", "firmwareAExcludeComponent", "firmwareAck", "firmwareActivity", "firmwareAutoSyncPolicy", "firmwareBlade", "firmwareBootDefinition", "firmwareBootUnit", "firmwareBundleInfo", "firmwareBundleInfoDigest", "firmwareBundleType", "firmwareBundleTypeCapProvider", "firmwareCapProvider", "firmwareCatalogPack", "firmwareCatalogue", "firmwareChassisComponentSpec", "firmwareChassisPack", "firmwareCompItem", "firmwareCompSource", "firmwareCompTarget", "firmwareComponentSpec", "firmwareComputeHostPack", "firmwareComputeMgmtPack", "firmwareComputePack", "firmwareConstraints", "firmwareDependency", "firmwareDistImage", "firmwareDistributable", "firmwareDistributableFsm", "firmwareDistributableFsmStage", "firmwareDistributableFsmTask", "firmwareDownloader", "firmwareDownloaderFsm", "firmwareDownloaderFsmStage", "firmwareDownloaderFsmTask", "firmwareExcludeChassisComponent", "firmwareExcludeServerComponent", "firmwareFileUnit", "firmwareHost", "firmwareHostPackModImpact", "firmwareImage", "firmwareImageFsm", "firmwareImageFsmStage", "firmwareImageFsmTask", "firmwareImageLock", "firmwareInfra", "firmwareInfraPack", "firmwareInstallImpact", "firmwareInstallable", "firmwarePCHStorageConfigConstraint", "firmwarePack", "firmwarePackItem", "firmwarePlatformBundleTypeCapProvider", "firmwareProcessorTypeConstraint", "firmwareRack", "firmwareRackPowerCapConstraint", "firmwareRunning", "firmwareServerTypeConstraint", "firmwareSpec", "firmwareStatus", "firmwareSystem", "firmwareSystemCompCheckResult", "firmwareSystemFsm", "firmwareSystemFsmStage", "firmwareSystemFsmTask", "firmwareTPMConstraint", "firmwareType", "firmwareUcscInfo", "firmwareUnit", "firmwareUpdatable", "firmwareUpgradeConstraint", "firmwareUpgradeDetail", "firmwareUpgradeInfo", "firmwareVicSlotConstraint", "firmwareVnicCdnConstraint", "flowctrlDefinition", "flowctrlItem", "fsmFsm", "fsmStage", "fsmStatus", "fsmTask", "gmetaClass", "gmetaEp", "gmetaHolder", "gmetaHolderFsm", "gmetaHolderFsmStage", "gmetaHolderFsmTask", "gmetaPolicyMapElement", "gmetaPolicyMapHolder", "gmetaProp", "graphicsCard", "graphicsController", "hostimgPolicy", "hostimgTarget", "identIdentCtx", "identIdentRequest", "identIdentRequestFsm", "identIdentRequestFsmStage", "identIdentRequestFsmTask", "identMetaSystem", "identMetaSystemFsm", "identMetaSystemFsmStage", "identMetaSystemFsmTask", "identMetaVerse", "identRequestEp", "identSysInfo", "imgprovPolicy", "imgprovTarget", "imgsecKey", "imgsecPolicy", "initiatorEp", "initiatorFcInitiatorEp", "initiatorGroupEp", "initiatorIScsiInitiatorEp", "initiatorInitiatorEp", "initiatorLunEp", "initiatorMemberEp", "initiatorRequestorEp", "initiatorRequestorGrpEp", "initiatorStoreEp", "initiatorUnitEp", "ipDnsSuffix", "ipIPv4Dns", "ipIPv4WinsServer", "ipIpV4Addr", "ipIpV4StaticAddr", "ipIpV4StaticTargetAddr", "ipServiceIf", "ippoolAddr", "ippoolBlock", "ippoolIpV6Addr", "ippoolIpV6Block", "ippoolIpV6Pooled", "ippoolPool", "ippoolPoolable", "ippoolPooled", "ippoolUniverse", "iqnpoolAbsBlock", "iqnpoolAddr", "iqnpoolBlock", "iqnpoolFormat", "iqnpoolPool", "iqnpoolPoolable", "iqnpoolPooled", "iqnpoolTransportBlock", "iqnpoolUniverse", "iscsiAuthProfile", "licenseCapProvider", "licenseContents", "licenseDownloader", "licenseDownloaderFsm", "licenseDownloaderFsmStage", "licenseDownloaderFsmTask", "licenseEp", "licenseFeature", "licenseFeatureCapProvider", "licenseFeatureLine", "licenseFile", "licenseFileFsm", "licenseFileFsmStage", "licenseFileFsmTask", "licenseInstance", "licenseInstanceFsm", "licenseInstanceFsmStage", "licenseInstanceFsmTask", "licenseProp", "licenseServerHostId", "licenseSource", "licenseSourceFile", "licenseTarget", "lldpAcquired", "lsAgentPolicy", "lsBinding", "lsComputeBinding", "lsFcLocale", "lsFcZone", "lsFcZoneGroup", "lsFcZoneMember", "lsIdentityInfo", "lsIssues", "lsPower", "lsRequirement", "lsServer", "lsServerAssocCtx", "lsServerExtension", "lsServerFsm", "lsServerFsmStage", "lsServerFsmTask", "lsTier", "lsUuidHistory", "lsVConAssign", "lsVersionBeh", "lsZoneInitiatorMember", "lsZoneTargetMember", "lsbootADef", "lsbootBootSecurity", "lsbootCategory", "lsbootDef", "lsbootDefaultLocalImage", "lsbootEFIShell", "lsbootEmbeddedLocalDiskImage", "lsbootEmbeddedLocalDiskImagePath", "lsbootEmbeddedLocalLunImage", "lsbootIScsi", "lsbootIScsiImagePath", "lsbootImage", "lsbootImagePath", "lsbootItem", "lsbootLan", "lsbootLanImagePath", "lsbootLocalDiskImage", "lsbootLocalDiskImagePath", "lsbootLocalHddImage", "lsbootLocalImage", "lsbootLocalLunImagePath", "lsbootLocalMediaItem", "lsbootLocalStorage", "lsbootPolicy", "lsbootRemoteImage", "lsbootSan", "lsbootSanCatSanImage", "lsbootSanCatSanImagePath", "lsbootSanImage", "lsbootSanImagePath", "lsbootStorage", "lsbootUEFIBootParam", "lsbootUsbExternalImage", "lsbootUsbFlashStorageImage", "lsbootUsbInternalImage", "lsbootVirtualMedia", "lsmaintAck", "lsmaintMaintPolicy", "lstorageASlot", "lstorageControllerDef", "lstorageControllerModeConfig", "lstorageControllerQualifier", "lstorageControllerRef", "lstorageDasScsiLun", "lstorageDiskGroupConfig", "lstorageDiskGroupConfigDef", "lstorageDiskGroupConfigPolicy", "lstorageDiskGroupQualifier", "lstorageDiskSlot", "lstorageDiskZoningConfig", "lstorageDiskZoningConfigDef", "lstorageDiskZoningPolicy", "lstorageItem", "lstorageLocalDiskConfigRef", "lstorageLocalDiskRef", "lstorageProfile", "lstorageProfileBase", "lstorageProfileBinding", "lstorageProfileBindingBase", "lstorageProfileDef", "lstorageScsiLun", "lstorageVirtualDriveDef", "macpoolAddr", "macpoolBlock", "macpoolFormat", "macpoolPool", "macpoolPoolable", "macpoolPooled", "macpoolUniverse", "memoryArray", "memoryArrayEnvStats", "memoryArrayEnvStatsHist", "memoryBufferUnit", "memoryBufferUnitEnvStats", "memoryBufferUnitEnvStatsHist", "memoryErrorStats", "memoryQual", "memoryRuntime", "memoryRuntimeHist", "memoryUnit", "memoryUnitEnvStats", "memoryUnitEnvStatsHist", "mgmtASecureBoot", "mgmtAccessPolicy", "mgmtAccessPolicyItem", "mgmtAccessPort", "mgmtBackup", "mgmtBackupExportExtPolicy", "mgmtBackupFsm", "mgmtBackupFsmStage", "mgmtBackupFsmTask", "mgmtBackupPolicy", "mgmtBackupPolicyConfig", "mgmtBackupPolicyFsm", "mgmtBackupPolicyFsmStage", "mgmtCfgExportPolicy", "mgmtCfgExportPolicyFsm", "mgmtCfgExportPolicyFsmStage", "mgmtCimcInterface", "mgmtCimcSecureBoot", "mgmtCmcSecureBoot", "mgmtConnection", "mgmtController", "mgmtControllerFsm", "mgmtControllerFsmStage", "mgmtControllerFsmTask", "mgmtEntity", "mgmtExportPolicy", "mgmtExportPolicyFsm", "mgmtExportPolicyFsmStage", "mgmtExportPolicyFsmTask", "mgmtHealthAttr", "mgmtHealthStatus", "mgmtIPv6Addr", "mgmtIPv6IfAddr", "mgmtIPv6IfAddrFsm", "mgmtIPv6IfAddrFsmStage", "mgmtIPv6IfAddrFsmTask", "mgmtIPv6IfConfig", "mgmtIf", "mgmtIfFsm", "mgmtIfFsmStage", "mgmtIfFsmTask", "mgmtImporter", "mgmtImporterFsm", "mgmtImporterFsmStage", "mgmtImporterFsmTask", "mgmtInbandProfile", "mgmtIntAuthPolicy", "mgmtInterface", "mgmtMgmtDbState", "mgmtPmonEntry", "mgmtProfDerivedInterface", "mgmtVnet", "moTopProps", "morefFruRef", "morefImportRoot", "morefImportRootFsm", "morefImportRootFsmStage", "morefImportRootFsmTask", "morefProp", "morefRef", "namingNamedIdentifiedObject", "namingNamedObject", "networkALanNeighborEntry", "networkANeighborEntry", "networkCIoEp", "networkConn", "networkDomainEp", "networkElement", "networkEp", "networkIfEp", "networkIfStats", "networkLanNeighborEntry", "networkLanNeighbors", "networkLldpNeighborEntry", "networkLldpNeighbors", "networkOperLevel", "networkPIoEp", "networkPhysEp", "networkSanNeighborEntry", "networkSanNeighbors", "networkVnetEp", "networkruleDefinition", "networkruleItem", "networkruleRequirement", "nfsEp", "nfsMountDef", "nfsMountDefFsm", "nfsMountDefFsmStage", "nfsMountDefFsmTask", "nfsMountInst", "nfsMountInstFsm", "nfsMountInstFsmStage", "nfsMountInstFsmTask", "nwctrlDefinition", "observeFilter", "observeObserved", "observeObservedCont", "observeObservedFsm", "observeObservedFsmStage", "observeObservedFsmTask", "orgOrg", "orgSourceMask", "osARPLinkMonitoringPolicy", "osARPTarget", "osAgent", "osEthBondIntf", "osEthBondMode", "osEthBondModeActiveBackup", "osEthBondModeBalancedALB", "osEthBondModeBalancedRR", "osEthBondModeBalancedTLB", "osEthBondModeBalancedXOR", "osEthBondModeBroadcast", "osEthBondModeLB", "osEthIntf", "osInstance", "osIntf", "osLinkMonitoringPolicy", "osMiiLinkMonitoringPolicy", "osPrimarySlave", "pciCard", "pciEquipSlot", "pciUnit", "pkiCertReq", "pkiDefinition", "pkiEp", "pkiEpFsm", "pkiEpFsmStage", "pkiEpFsmTask", "pkiItem", "pkiKeyRing", "pkiTP", "policyBinding", "policyCentraleSync", "policyCommunication", "policyConfigBackup", "policyControl", "policyControlEp", "policyControlEpFsm", "policyControlEpFsmStage", "policyControlEpFsmTask", "policyControlled", "policyControlledInstance", "policyControlledType", "policyControlledTypeFsm", "policyControlledTypeFsmStage", "policyControlledTypeFsmTask", "policyDateTime", "policyDefinition", "policyDigest", "policyDiscovery", "policyDns", "policyElement", "policyEquipment", "policyFault", "policyHolder", "policyIdResolvePolicy", "policyInfraFirmware", "policyItem", "policyLocalMap", "policyMEp", "policyMonitoring", "policyObject", "policyPolicyEp", "policyPolicyRequestor", "policyPolicyScope", "policyPolicyScopeCont", "policyPolicyScopeContext", "policyPolicyScopeFsm", "policyPolicyScopeFsmStage", "policyPolicyScopeFsmTask", "policyPortConfig", "policyPowerMgmt", "policyPsu", "policyRefReq", "policySecurity", "policyStorageAutoConfig", "policySystemEp", "poolElement", "poolPool", "poolPoolMember", "poolPoolable", "poolUniverse", "portDomainEp", "portGroup", "portIntFIo", "portPIo", "portPIoFsm", "portPIoFsmStage", "portPIoFsmTask", "portPhysSwitchIo", "portServerIntFIo", "portSubGroup", "portSwitchIntFIo", "portTrustMode", "powerABudget", "powerAGroup", "powerBudget", "powerChassisMember", "powerEp", "powerFIMember", "powerFexMember", "powerGroup", "powerGroupAdditionPolicy", "powerGroupMember", "powerGroupQual", "powerGroupStats", "powerGroupStatsHist", "powerMgmtPolicy", "powerPlacement", "powerPolicy", "powerPrioWght", "powerProfiledPower", "powerRackUnitMember", "procDoer", "procManager", "procProcCounts", "procProcs", "procPrt", "procPrtCounts", "procStimulusCounts", "procSvc", "procTxCounts", "processorComponent", "processorCore", "processorEnvStats", "processorEnvStatsHist", "processorErrorStats", "processorQual", "processorRuntime", "processorRuntimeHist", "processorThread", "processorUnit", "processorUnitAssocCtx", "qosDefinition", "qosItem", "qosclassDefinition", "qosclassDefinitionFsm", "qosclassDefinitionFsmStage", "qosclassDefinitionFsmTask", "qosclassEth", "qosclassEthBE", "qosclassEthClassified", "qosclassFc", "qosclassItem", "queryresultDependency", "queryresultItem", "queryresultUsage", "ruleDefinition", "ruleItem", "ruleRequirement", "ruleSizeRequirement", "securityUnit", "sesDiskSlotEp", "sesEnclosure", "solConfig", "solDef", "solIf", "solPolicy", "statsCollectionPolicy", "statsCollectionPolicyFsm", "statsCollectionPolicyFsmStage", "statsCollectionPolicyFsmTask", "statsCurr", "statsHist", "statsHolder", "statsItem", "statsThr32Definition", "statsThr32Value", "statsThr64Definition", "statsThr64Value", "statsThrFloatDefinition", "statsThrFloatValue", "statsThresholdClass", "statsThresholdDefinition", "statsThresholdPolicy", "statsThresholdValue", "storageADef", "storageADiskEp", "storageADiskSlotEp", "storageALun", "storageALunRefBase", "storageASlot", "storageAuthKey", "storageConnectionDef", "storageConnectionPolicy", "storageController", "storageControllerBase", "storageControllerEp", "storageControllerRef", "storageDevice", "storageDiskEnvStats", "storageDiskEnvStatsHist", "storageDomainEp", "storageDrive", "storageEmbeddedStorage", "storageEnclosure", "storageEnclosureCap", "storageEnclosureDiskSlotEp", "storageEnclosureFsm", "storageEnclosureFsmStage", "storageEnclosureFsmTask", "storageEnclosureLocalDiskConfig", "storageEp", "storageEpUser", "storageEtherIf", "storageFcIf", "storageFcTargetEp", "storageFcTargetIf", "storageFlexFlashCard", "storageFlexFlashController", "storageFlexFlashControllerFsm", "storageFlexFlashControllerFsmStage", "storageFlexFlashControllerFsmTask", "storageFlexFlashDrive", "storageFlexFlashVirtualDrive", "storageHddMotherBoardTempStats", "storageHddMotherBoardTempStatsHist", "storageHwRevisionModifier", "storageIScsiTargetIf", "storageIniGroup", "storageInitiator", "storageItem", "storageL2If", "storageLocalDisk", "storageLocalDiskBase", "storageLocalDiskConfig", "storageLocalDiskConfigDef", "storageLocalDiskConfigPolicy", "storageLocalDiskEp", "storageLocalDiskFsm", "storageLocalDiskFsmStage", "storageLocalDiskFsmTask", "storageLocalDiskPartition", "storageLocalDiskSlotEp", "storageLocalLun", "storageLogical", "storageLunDisk", "storageLunResourceSelectionLog", "storageMezzFlashLife", "storageNodeEp", "storageNvmeStats", "storageNvmeStatsHist", "storageOnboardDevice", "storageOperation", "storagePhysical", "storageQual", "storageRaidBattery", "storageSasExpander", "storageSasLinkDescriptor", "storageSasPhyLink", "storageSasPort", "storageSasPortDescriptor", "storageSasUpLink", "storageScsiLunRef", "storageSystem", "storageSystemFsm", "storageSystemFsmStage", "storageSystemFsmTask", "storageTarget", "storageTargetIf", "storageTransportIf", "storageTransportableFlashModule", "storageUnit", "storageVDMemberEp", "storageVirtualDrive", "storageVirtualDriveContainer", "storageVirtualDriveEp", "storageVirtualDriveRef", "storageVsanRef", "swAccessDomain", "swAccessDomainFsm", "swAccessDomainFsmStage", "swAccessDomainFsmTask", "swAccessEp", "swBorderDomain", "swBorderEp", "swBorderPc", "swCIoEp", "swCardEnvStats", "swCardEnvStatsHist", "swCmclan", "swDomain", "swEnvStats", "swEnvStatsHist", "swEstcEp", "swEthEstcEp", "swEthEstcPc", "swEthFlowMonSession", "swEthLanBorder", "swEthLanBorderFsm", "swEthLanBorderFsmStage", "swEthLanBorderFsmTask", "swEthLanEp", "swEthLanFlowMon", "swEthLanFlowMonExporter", "swEthLanFlowMonFsm", "swEthLanFlowMonFsmStage", "swEthLanFlowMonFsmTask", "swEthLanFlowMonitor", "swEthLanFlowRecordDef", "swEthLanMon", "swEthLanPc", "swEthMon", "swEthMonDestEp", "swEthMonFsm", "swEthMonFsmStage", "swEthMonFsmTask", "swEthMonSrcEp", "swEthTargetEp", "swExtUtility", "swExtUtilityFsm", "swExtUtilityFsmStage", "swExtUtilityFsmTask", "swFabricZoneNs", "swFabricZoneNsOverride", "swFcEndpoint", "swFcEstcEp", "swFcMon", "swFcMonDestEp", "swFcMonFsm", "swFcMonFsmStage", "swFcMonFsmTask", "swFcMonSrcEp", "swFcSanBorder", "swFcSanBorderFsm", "swFcSanBorderFsmStage", "swFcSanBorderFsmTask", "swFcSanEp", "swFcSanMon", "swFcSanPc", "swFcServerZoneGroup", "swFcUserZone", "swFcUserZoneGroup", "swFcZone", "swFcZoneMember", "swFcZoneSet", "swFcoeEstcEp", "swFcoeSanEp", "swFcoeSanPc", "swFlowMonExporter", "swFlowMonitor", "swFlowRecordDef", "swIpRoute", "swLanBorder", "swLanEp", "swLanMon", "swLanPc", "swMon", "swMonDestEp", "swMonDomain", "swMonSrcEp", "swNFExporterRef", "swNetflowExporter", "swNetflowMonSession", "swNetflowMonitor", "swNetflowMonitorRef", "swNetflowRecordDef", "swPIoEp", "swPhys", "swPhysEtherEp", "swPhysFcEp", "swPhysFsm", "swPhysFsmStage", "swPhysFsmTask", "swPortBreakout", "swSanBorder", "swSanEp", "swSanMon", "swSanPc", "swSubGroup", "swSystemStats", "swSystemStatsHist", "swTargetEp", "swUlan", "swUtilityDomain", "swUtilityDomainFsm", "swUtilityDomainFsmStage", "swUtilityDomainFsmTask", "swVIFRef", "swVirtL3Intf", "swVlan", "swVlanGroup", "swVlanPortNs", "swVlanPortNsOverride", "swVlanRef", "swVsan", "swZoneInitiatorMember", "swZoneTargetMember", "swatAction", "swatCondition", "swatInjection", "swatResultstats", "swatTarget", "swatTrigger", "syntheticDirectory", "syntheticFile", "syntheticFileSystem", "syntheticFsObj", "syntheticFsObjFsm", "syntheticFsObjFsmStage", "syntheticFsObjFsmTask", "syntheticTime", "sysdebugAutoCoreFileExportTarget", "sysdebugAutoCoreFileExportTargetFsm", "sysdebugAutoCoreFileExportTargetFsmStage", "sysdebugAutoCoreFileExportTargetFsmTask", "sysdebugBackupBehavior", "sysdebugCore", "sysdebugCoreFileExportTarget", "sysdebugCoreFileRepository", "sysdebugCoreFsm", "sysdebugCoreFsmStage", "sysdebugCoreFsmTask", "sysdebugEp", "sysdebugExporter", "sysdebugFile", "sysdebugLogBehavior", "sysdebugLogControlDestinationFile", "sysdebugLogControlDestinationSyslog", "sysdebugLogControlDomain", "sysdebugLogControlEp", "sysdebugLogControlEpFsm", "sysdebugLogControlEpFsmStage", "sysdebugLogControlEpFsmTask", "sysdebugLogControlModule", "sysdebugLogExportPolicy", "sysdebugLogExportPolicyFsm", "sysdebugLogExportPolicyFsmStage", "sysdebugLogExportPolicyFsmTask", "sysdebugLogExportStatus", "sysdebugMEpLog", "sysdebugMEpLogDef", "sysdebugMEpLogPolicy", "sysdebugManualCoreFileExportTarget", "sysdebugManualCoreFileExportTargetFsm", "sysdebugManualCoreFileExportTargetFsmStage", "sysdebugManualCoreFileExportTargetFsmTask", "sysdebugRepository", "sysdebugTechSupFileRepository", "sysdebugTechSupport", "sysdebugTechSupportCmdOpt", "sysdebugTechSupportFsm", "sysdebugTechSupportFsmStage", "sysdebugTechSupportFsmTask", "sysfileDigest", "sysfileEp", "sysfileExporter", "sysfileImporter", "sysfileInstance", "sysfileMutation", "sysfileMutationFsm", "sysfileMutationFsmStage", "sysfileMutationFsmTask", "sysfileRepository", "topInfoPolicy", "topInfoSyncPolicy", "topMetaInf", "topRoot", "topSysDefaults", "topSystem", "trigAbsWindow", "trigAck", "trigBaseAbsWindow", "trigBaseRecurrWindow", "trigBaseSched", "trigClientToken", "trigConfAck", "trigInst", "trigLocalAbsWindow", "trigLocalSched", "trigMeta", "trigRecurrWindow", "trigResAck", "trigSched", "trigSchedWindow", "trigTest", "trigToken", "trigTriggerable", "trigTriggered", "trigWindow", "unspecified", "uuidpoolAddr", "uuidpoolBlock", "uuidpoolFormat", "uuidpoolPool", "uuidpoolPoolable", "uuidpoolPooled", "uuidpoolUniverse", "versionApplication", "versionEp", "versionVersion", "vmAdaptor", "vmClientContainer", "vmComputeEp", "vmCont", "vmDC", "vmDCOrg", "vmDirCont", "vmEp", "vmHba", "vmHv", "vmInstance", "vmLifeCyclePolicy", "vmLifeCyclePolicyFsm", "vmLifeCyclePolicyFsmStage", "vmLifeCyclePolicyFsmTask", "vmNic", "vmOrg", "vmSwitch", "vmVif", "vmVirtual", "vmVlan", "vmVnicProfCl", "vmVnicProfInst", "vmVsan", "vnicABeh", "vnicAEtherIf", "vnicAFcIf", "vnicAGroup", "vnicAIpcIf", "vnicAScsiIf", "vnicBootIpPolicy", "vnicBootTarget", "vnicConPolicyRef", "vnicConReq", "vnicConnDef", "vnicConnection", "vnicDefBeh", "vnicDynamicCon", "vnicDynamicConPolicy", "vnicDynamicConPolicyRef", "vnicDynamicConReq", "vnicDynamicIdUniverse", "vnicDynamicProvider", "vnicDynamicProviderEp", "vnicEthConfig", "vnicEthLif", "vnicEther", "vnicEtherBase", "vnicEtherBaseIf", "vnicEtherIf", "vnicFc", "vnicFcBase", "vnicFcGroupDef", "vnicFcGroupTempl", "vnicFcIf", "vnicFcLif", "vnicFcNode", "vnicFcOEIf", "vnicIPIf", "vnicIPv4Dhcp", "vnicIPv4Dns", "vnicIPv4If", "vnicIPv4IscsiAddr", "vnicIPv4PooledIscsiAddr", "vnicIPv4StaticRoute", "vnicIPv6If", "vnicIScsi", "vnicIScsiAutoTargetIf", "vnicIScsiBase", "vnicIScsiBootParams", "vnicIScsiBootVnic", "vnicIScsiConfig", "vnicIScsiInitAutoConfigPolicy", "vnicIScsiLCP", "vnicIScsiNode", "vnicIScsiStaticTargetIf", "vnicIScsiTargetIf", "vnicIf", "vnicIfRole", "vnicInitiatorAutoConfigPolicy", "vnicInternalProfile", "vnicIpAddr", "vnicIpV4Addr", "vnicIpV4AddrConf", "vnicIpV4AddrExplConf", "vnicIpV4History", "vnicIpV4MgmtPooledAddr", "vnicIpV4PooledAddr", "vnicIpV4ProfDerivedAddr", "vnicIpV4StaticAddr", "vnicIpV6Addr", "vnicIpV6AddrConf", "vnicIpV6AddrExplConf", "vnicIpV6History", "vnicIpV6MgmtPooledAddr", "vnicIpV6StaticAddr", "vnicIpc", "vnicIpcIf", "vnicIqnHistory", "vnicL2If", "vnicL2Lif", "vnicL3If", "vnicLanConnPolicy", "vnicLanConnTempl", "vnicLifVlan", "vnicLifVsan", "vnicLun", "vnicMacHistory", "vnicNicConn", "vnicOProfileAlias", "vnicProfile", "vnicProfileAlias", "vnicProfileRef", "vnicProfileSet", "vnicProfileSetFsm", "vnicProfileSetFsmStage", "vnicProfileSetFsmTask", "vnicRackServerDiscoveryProfile", "vnicSanConnPolicy", "vnicSanConnTempl", "vnicScsi", "vnicScsiIf", "vnicTempl", "vnicUsnicConPolicy", "vnicUsnicConPolicyRef", "vnicUsnicConReq", "vnicVProfileAlias", "vnicVhbaBehPolicy", "vnicVlan", "vnicVmqConPolicy", "vnicVmqConPolicyRef", "vnicVmqConReq", "vnicVnic", "vnicVnicBehPolicy", "vnicWwnnHistory", "vnicWwpnHistory"], []), 
        "id": MoPropertyMeta("id", "id", "uint", VersionMeta.Version212a, MoPropertyMeta.NAMING, 0x8, None, None, None, [], []), 
        "name": MoPropertyMeta("name", "name", "string", VersionMeta.Version212a, MoPropertyMeta.CREATE_ONLY, 0x10, 0, 510, None, [], []), 
        "oper_prop_mask": MoPropertyMeta("oper_prop_mask", "operPropMask", "ulong", VersionMeta.Version212a, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "rn": MoPropertyMeta("rn", "rn", "string", VersionMeta.Version212a, MoPropertyMeta.READ_ONLY, 0x20, 0, 256, None, [], []), 
        "sacl": MoPropertyMeta("sacl", "sacl", "string", VersionMeta.Version302a, MoPropertyMeta.READ_ONLY, None, None, None, r"""((none|del|mod|addchild|cascade),){0,4}(none|del|mod|addchild|cascade){0,1}""", [], []), 
        "status": MoPropertyMeta("status", "status", "string", VersionMeta.Version212a, MoPropertyMeta.READ_WRITE, 0x40, None, None, r"""((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], []), 
    }

    prop_map = {
        "adminPropMask": "admin_prop_mask", 
        "childAction": "child_action", 
        "dn": "dn", 
        "epClassId": "ep_class_id", 
        "id": "id", 
        "name": "name", 
        "operPropMask": "oper_prop_mask", 
        "rn": "rn", 
        "sacl": "sacl", 
        "status": "status", 
    }

    def __init__(self, parent_mo_or_dn, id, **kwargs):
        self._dirty_mask = 0
        self.id = id
        self.admin_prop_mask = None
        self.child_action = None
        self.ep_class_id = None
        self.name = None
        self.oper_prop_mask = None
        self.sacl = None
        self.status = None

        ManagedObject.__init__(self, "GmetaClass", parent_mo_or_dn, **kwargs)
