"""This module contains the general information for ComputeRackUnit ManagedObject."""

from ...ucsmo import ManagedObject
from ...ucscoremeta import MoPropertyMeta, MoMeta
from ...ucsmeta import VersionMeta


class ComputeRackUnitConsts:
    ADMIN_POWER_ADMIN_DOWN = "admin-down"
    ADMIN_POWER_ADMIN_UP = "admin-up"
    ADMIN_POWER_BMC_RESET_IMMEDIATE = "bmc-reset-immediate"
    ADMIN_POWER_BMC_RESET_WAIT = "bmc-reset-wait"
    ADMIN_POWER_CMOS_RESET_IMMEDIATE = "cmos-reset-immediate"
    ADMIN_POWER_CYCLE_IMMEDIATE = "cycle-immediate"
    ADMIN_POWER_CYCLE_WAIT = "cycle-wait"
    ADMIN_POWER_DIAGNOSTIC_INTERRUPT = "diagnostic-interrupt"
    ADMIN_POWER_HARD_RESET_IMMEDIATE = "hard-reset-immediate"
    ADMIN_POWER_HARD_RESET_WAIT = "hard-reset-wait"
    ADMIN_POWER_IPMI_RESET = "ipmi-reset"
    ADMIN_POWER_KVM_RESET = "kvm-reset"
    ADMIN_POWER_POLICY = "policy"
    ADMIN_STATE_IN_MAINTENANCE = "in-maintenance"
    ADMIN_STATE_IN_SERVICE = "in-service"
    ADMIN_STATE_OUT_OF_SERVICE = "out-of-service"
    ASSOCIATION_ASSOCIATED = "associated"
    ASSOCIATION_ESTABLISHING = "establishing"
    ASSOCIATION_FAILED = "failed"
    ASSOCIATION_NONE = "none"
    ASSOCIATION_REMOVING = "removing"
    ASSOCIATION_THROTTLED = "throttled"
    AVAILABILITY_AVAILABLE = "available"
    AVAILABILITY_UNAVAILABLE = "unavailable"
    CHECK_POINT_DEEP_CHECKPOINT = "deep-checkpoint"
    CHECK_POINT_DISCOVERED = "discovered"
    CHECK_POINT_REMOVING = "removing"
    CHECK_POINT_SHALLOW_CHECKPOINT = "shallow-checkpoint"
    CHECK_POINT_UNKNOWN = "unknown"
    DISCOVERY_COMPLETE = "complete"
    DISCOVERY_DIAGNOSTICS_COMPLETE = "diagnostics-complete"
    DISCOVERY_DIAGNOSTICS_FAILED = "diagnostics-failed"
    DISCOVERY_DIAGNOSTICS_IN_PROGRESS = "diagnostics-in-progress"
    DISCOVERY_EFIDIAGNOSTICS_IN_PROGRESS = "efidiagnostics-in-progress"
    DISCOVERY_FAILED = "failed"
    DISCOVERY_FRU_IDENTITY_INDETERMINATE = "fru-identity-indeterminate"
    DISCOVERY_FRU_NOT_READY = "fru-not-ready"
    DISCOVERY_FRU_STATE_INDETERMINATE = "fru-state-indeterminate"
    DISCOVERY_ILLEGAL_FRU = "illegal-fru"
    DISCOVERY_IN_PROGRESS = "in-progress"
    DISCOVERY_INSUFFICIENTLY_EQUIPPED = "insufficiently-equipped"
    DISCOVERY_INVALID_ADAPTOR_IOCARD = "invalid-adaptor-iocard"
    DISCOVERY_MALFORMED_FRU_INFO = "malformed-fru-info"
    DISCOVERY_RETRY = "retry"
    DISCOVERY_THROTTLED = "throttled"
    DISCOVERY_UNDISCOVERED = "undiscovered"
    DISCOVERY_USER_ACKNOWLEDGED = "user-acknowledged"
    DISCOVERY_WAITING_FOR_MGMT_ACK = "waiting-for-mgmt-ack"
    DISCOVERY_WAITING_FOR_USER_ACK = "waiting-for-user-ack"
    FAN_SPEED_POLICY_FAULT_NO = "no"
    FAN_SPEED_POLICY_FAULT_YES = "yes"
    FSM_PREV_ACTIVATE_ADAPTOR_ACTIVATE_LOCAL = "ActivateAdaptorActivateLocal"
    FSM_PREV_ACTIVATE_ADAPTOR_ACTIVATE_PEER = "ActivateAdaptorActivatePeer"
    FSM_PREV_ACTIVATE_ADAPTOR_BEGIN = "ActivateAdaptorBegin"
    FSM_PREV_ACTIVATE_ADAPTOR_CHECK_POWER_AVAILABILITY = "ActivateAdaptorCheckPowerAvailability"
    FSM_PREV_ACTIVATE_ADAPTOR_DEASSERT_RESET_BYPASS = "ActivateAdaptorDeassertResetBypass"
    FSM_PREV_ACTIVATE_ADAPTOR_FAIL = "ActivateAdaptorFail"
    FSM_PREV_ACTIVATE_ADAPTOR_POWER_DEPLOY_WAIT = "ActivateAdaptorPowerDeployWait"
    FSM_PREV_ACTIVATE_ADAPTOR_POWER_ON = "ActivateAdaptorPowerOn"
    FSM_PREV_ACTIVATE_ADAPTOR_RESET = "ActivateAdaptorReset"
    FSM_PREV_ACTIVATE_ADAPTOR_SUCCESS = "ActivateAdaptorSuccess"
    FSM_PREV_ACTIVATE_BIOSACTIVATE = "ActivateBIOSActivate"
    FSM_PREV_ACTIVATE_BIOSBEGIN = "ActivateBIOSBegin"
    FSM_PREV_ACTIVATE_BIOSCHECK_POWER_AVAILABILITY = "ActivateBIOSCheckPowerAvailability"
    FSM_PREV_ACTIVATE_BIOSCLEAR = "ActivateBIOSClear"
    FSM_PREV_ACTIVATE_BIOSFAIL = "ActivateBIOSFail"
    FSM_PREV_ACTIVATE_BIOSPOLL_ACTIVATE_STATUS = "ActivateBIOSPollActivateStatus"
    FSM_PREV_ACTIVATE_BIOSPOLL_CLEAR_STATUS = "ActivateBIOSPollClearStatus"
    FSM_PREV_ACTIVATE_BIOSPOWER_DEPLOY_WAIT = "ActivateBIOSPowerDeployWait"
    FSM_PREV_ACTIVATE_BIOSPOWER_OFF = "ActivateBIOSPowerOff"
    FSM_PREV_ACTIVATE_BIOSPOWER_ON = "ActivateBIOSPowerOn"
    FSM_PREV_ACTIVATE_BIOSSUCCESS = "ActivateBIOSSuccess"
    FSM_PREV_ACTIVATE_BIOSUPDATE_TOKENS = "ActivateBIOSUpdateTokens"
    FSM_PREV_ADAPTER_RESET_BEGIN = "AdapterResetBegin"
    FSM_PREV_ADAPTER_RESET_DEASSERT_RESET_BYPASS = "AdapterResetDeassertResetBypass"
    FSM_PREV_ADAPTER_RESET_FAIL = "AdapterResetFail"
    FSM_PREV_ADAPTER_RESET_POWER_CYCLE = "AdapterResetPowerCycle"
    FSM_PREV_ADAPTER_RESET_PRE_SANITIZE = "AdapterResetPreSanitize"
    FSM_PREV_ADAPTER_RESET_SANITIZE = "AdapterResetSanitize"
    FSM_PREV_ADAPTER_RESET_SUCCESS = "AdapterResetSuccess"
    FSM_PREV_ASSOCIATE_ACTIVATE_ADAPTOR_NW_FW_LOCAL = "AssociateActivateAdaptorNwFwLocal"
    FSM_PREV_ASSOCIATE_ACTIVATE_ADAPTOR_NW_FW_PEER = "AssociateActivateAdaptorNwFwPeer"
    FSM_PREV_ASSOCIATE_ACTIVATE_BIOS = "AssociateActivateBios"
    FSM_PREV_ASSOCIATE_ACTIVATE_IBMCFW = "AssociateActivateIBMCFw"
    FSM_PREV_ASSOCIATE_BEGIN = "AssociateBegin"
    FSM_PREV_ASSOCIATE_BIOS_IMG_UPDATE = "AssociateBiosImgUpdate"
    FSM_PREV_ASSOCIATE_BIOS_POST_COMPLETION = "AssociateBiosPostCompletion"
    FSM_PREV_ASSOCIATE_BLADE_POWER_OFF = "AssociateBladePowerOff"
    FSM_PREV_ASSOCIATE_BMC_CONFIG_PNU_OS = "AssociateBmcConfigPnuOS"
    FSM_PREV_ASSOCIATE_BMC_PRECONFIG_PNU_OSLOCAL = "AssociateBmcPreconfigPnuOSLocal"
    FSM_PREV_ASSOCIATE_BMC_PRECONFIG_PNU_OSPEER = "AssociateBmcPreconfigPnuOSPeer"
    FSM_PREV_ASSOCIATE_BMC_UNCONFIG_PNU_OS = "AssociateBmcUnconfigPnuOS"
    FSM_PREV_ASSOCIATE_BOOT_HOST = "AssociateBootHost"
    FSM_PREV_ASSOCIATE_BOOT_PNUOS = "AssociateBootPnuos"
    FSM_PREV_ASSOCIATE_BOOT_WAIT = "AssociateBootWait"
    FSM_PREV_ASSOCIATE_CALCULATE_VLAN_GROUP_FOR_HOST_OSLOCAL = "AssociateCalculateVlanGroupForHostOSLocal"
    FSM_PREV_ASSOCIATE_CALCULATE_VLAN_GROUP_FOR_HOST_OSPEER = "AssociateCalculateVlanGroupForHostOSPeer"
    FSM_PREV_ASSOCIATE_CHECK_POWER_AVAILABILITY = "AssociateCheckPowerAvailability"
    FSM_PREV_ASSOCIATE_CISCO_OSOPEN_GATE = "AssociateCiscoOSOpenGate"
    FSM_PREV_ASSOCIATE_CLEAR_BIOS_UPDATE = "AssociateClearBiosUpdate"
    FSM_PREV_ASSOCIATE_CONFIG_CIMC_VMEDIA = "AssociateConfigCimcVMedia"
    FSM_PREV_ASSOCIATE_CONFIG_EXT_MGMT_GW = "AssociateConfigExtMgmtGw"
    FSM_PREV_ASSOCIATE_CONFIG_EXT_MGMT_RULES = "AssociateConfigExtMgmtRules"
    FSM_PREV_ASSOCIATE_CONFIG_FAN_SPEED = "AssociateConfigFanSpeed"
    FSM_PREV_ASSOCIATE_CONFIG_FLEX_FLASH = "AssociateConfigFlexFlash"
    FSM_PREV_ASSOCIATE_CONFIG_SO_L = "AssociateConfigSoL"
    FSM_PREV_ASSOCIATE_CONFIG_USER_ACCESS = "AssociateConfigUserAccess"
    FSM_PREV_ASSOCIATE_CONFIG_UUID = "AssociateConfigUuid"
    FSM_PREV_ASSOCIATE_COPY_REMOTE = "AssociateCopyRemote"
    FSM_PREV_ASSOCIATE_DEASSERT_RESET_BYPASS = "AssociateDeassertResetBypass"
    FSM_PREV_ASSOCIATE_DELETE_CURL_DOWNLOADED_IMAGES = "AssociateDeleteCurlDownloadedImages"
    FSM_PREV_ASSOCIATE_DELETE_IMAGES_REMOTE = "AssociateDeleteImagesRemote"
    FSM_PREV_ASSOCIATE_DOWNLOAD_IMAGES = "AssociateDownloadImages"
    FSM_PREV_ASSOCIATE_FAIL = "AssociateFail"
    FSM_PREV_ASSOCIATE_GRAPHICS_IMAGE_UPDATE = "AssociateGraphicsImageUpdate"
    FSM_PREV_ASSOCIATE_HAG_HOST_OSCONNECT = "AssociateHagHostOSConnect"
    FSM_PREV_ASSOCIATE_HAG_PNU_OSCONNECT = "AssociateHagPnuOSConnect"
    FSM_PREV_ASSOCIATE_HAG_PNU_OSDISCONNECT = "AssociateHagPnuOSDisconnect"
    FSM_PREV_ASSOCIATE_HBA_IMG_UPDATE = "AssociateHbaImgUpdate"
    FSM_PREV_ASSOCIATE_HOST_OSCONFIG = "AssociateHostOSConfig"
    FSM_PREV_ASSOCIATE_HOST_OSIDENT = "AssociateHostOSIdent"
    FSM_PREV_ASSOCIATE_HOST_OSPOLICY = "AssociateHostOSPolicy"
    FSM_PREV_ASSOCIATE_HOST_OSVALIDATE = "AssociateHostOSValidate"
    FSM_PREV_ASSOCIATE_LOCAL_DISK_FW_UPDATE = "AssociateLocalDiskFwUpdate"
    FSM_PREV_ASSOCIATE_MARK_ADAPTER_FOR_REBOOT = "AssociateMarkAdapterForReboot"
    FSM_PREV_ASSOCIATE_NIC_CONFIG_HOST_OSLOCAL = "AssociateNicConfigHostOSLocal"
    FSM_PREV_ASSOCIATE_NIC_CONFIG_HOST_OSPEER = "AssociateNicConfigHostOSPeer"
    FSM_PREV_ASSOCIATE_NIC_CONFIG_PARAMS_HOST_OSLOCAL = "AssociateNicConfigParamsHostOSLocal"
    FSM_PREV_ASSOCIATE_NIC_CONFIG_PARAMS_HOST_OSPEER = "AssociateNicConfigParamsHostOSPeer"
    FSM_PREV_ASSOCIATE_NIC_CONFIG_PNU_OSLOCAL = "AssociateNicConfigPnuOSLocal"
    FSM_PREV_ASSOCIATE_NIC_CONFIG_PNU_OSPEER = "AssociateNicConfigPnuOSPeer"
    FSM_PREV_ASSOCIATE_NIC_CONFIG_SERVICE_INFRA_LOCAL = "AssociateNicConfigServiceInfraLocal"
    FSM_PREV_ASSOCIATE_NIC_CONFIG_SERVICE_INFRA_PEER = "AssociateNicConfigServiceInfraPeer"
    FSM_PREV_ASSOCIATE_NIC_IMG_UPDATE = "AssociateNicImgUpdate"
    FSM_PREV_ASSOCIATE_NIC_UNCONFIG_PNU_OSLOCAL = "AssociateNicUnconfigPnuOSLocal"
    FSM_PREV_ASSOCIATE_NIC_UNCONFIG_PNU_OSPEER = "AssociateNicUnconfigPnuOSPeer"
    FSM_PREV_ASSOCIATE_OOB_POLL_SAS_EXPANDER_ACTIVATE_STATUS = "AssociateOobPollSasExpanderActivateStatus"
    FSM_PREV_ASSOCIATE_OOB_POLL_SAS_EXPANDER_UPDATE_STATUS = "AssociateOobPollSasExpanderUpdateStatus"
    FSM_PREV_ASSOCIATE_OOB_SAS_EXPANDER_IMG_ACTIVATE = "AssociateOobSasExpanderImgActivate"
    FSM_PREV_ASSOCIATE_OOB_SAS_EXPANDER_IMG_UPDATE = "AssociateOobSasExpanderImgUpdate"
    FSM_PREV_ASSOCIATE_OOB_STORAGE_CONFIG = "AssociateOobStorageConfig"
    FSM_PREV_ASSOCIATE_OOB_STORAGE_INVENTORY = "AssociateOobStorageInventory"
    FSM_PREV_ASSOCIATE_PNU_OSCATALOG = "AssociatePnuOSCatalog"
    FSM_PREV_ASSOCIATE_PNU_OSCONFIG = "AssociatePnuOSConfig"
    FSM_PREV_ASSOCIATE_PNU_OSIDENT = "AssociatePnuOSIdent"
    FSM_PREV_ASSOCIATE_PNU_OSINVENTORY = "AssociatePnuOSInventory"
    FSM_PREV_ASSOCIATE_PNU_OSLOCAL_DISK_CONFIG = "AssociatePnuOSLocalDiskConfig"
    FSM_PREV_ASSOCIATE_PNU_OSPOLICY = "AssociatePnuOSPolicy"
    FSM_PREV_ASSOCIATE_PNU_OSSELF_TEST = "AssociatePnuOSSelfTest"
    FSM_PREV_ASSOCIATE_PNU_OSUNLOAD_DRIVERS = "AssociatePnuOSUnloadDrivers"
    FSM_PREV_ASSOCIATE_PNU_OSVALIDATE = "AssociatePnuOSValidate"
    FSM_PREV_ASSOCIATE_POLL_BIOS_ACTIVATE_STATUS = "AssociatePollBiosActivateStatus"
    FSM_PREV_ASSOCIATE_POLL_BIOS_UPDATE_STATUS = "AssociatePollBiosUpdateStatus"
    FSM_PREV_ASSOCIATE_POLL_BOARD_CTRL_POWER_CYCLE = "AssociatePollBoardCtrlPowerCycle"
    FSM_PREV_ASSOCIATE_POLL_BOARD_CTRL_UPDATE_STATUS = "AssociatePollBoardCtrlUpdateStatus"
    FSM_PREV_ASSOCIATE_POLL_CLEAR_BIOS_UPDATE_STATUS = "AssociatePollClearBiosUpdateStatus"
    FSM_PREV_ASSOCIATE_POWER_CYCLE_BOARD = "AssociatePowerCycleBoard"
    FSM_PREV_ASSOCIATE_POWER_DEPLOY_WAIT = "AssociatePowerDeployWait"
    FSM_PREV_ASSOCIATE_POWER_ON = "AssociatePowerOn"
    FSM_PREV_ASSOCIATE_POWER_ON_PRE_CONFIG = "AssociatePowerOnPreConfig"
    FSM_PREV_ASSOCIATE_PRE_SANITIZE = "AssociatePreSanitize"
    FSM_PREV_ASSOCIATE_PREPARE_FOR_BOOT = "AssociatePrepareForBoot"
    FSM_PREV_ASSOCIATE_RESET_IBMC = "AssociateResetIBMC"
    FSM_PREV_ASSOCIATE_SANITIZE = "AssociateSanitize"
    FSM_PREV_ASSOCIATE_SAS_EXPANDER_IMG_UPDATE = "AssociateSasExpanderImgUpdate"
    FSM_PREV_ASSOCIATE_SERIAL_DEBUG_PNU_OSCONNECT = "AssociateSerialDebugPnuOSConnect"
    FSM_PREV_ASSOCIATE_SERIAL_DEBUG_PNU_OSDISCONNECT = "AssociateSerialDebugPnuOSDisconnect"
    FSM_PREV_ASSOCIATE_SOL_REDIRECT_DISABLE = "AssociateSolRedirectDisable"
    FSM_PREV_ASSOCIATE_SOL_REDIRECT_ENABLE = "AssociateSolRedirectEnable"
    FSM_PREV_ASSOCIATE_STORAGE_CTLR_IMG_UPDATE = "AssociateStorageCtlrImgUpdate"
    FSM_PREV_ASSOCIATE_SUCCESS = "AssociateSuccess"
    FSM_PREV_ASSOCIATE_SW_CONFIG_HOST_OSLOCAL = "AssociateSwConfigHostOSLocal"
    FSM_PREV_ASSOCIATE_SW_CONFIG_HOST_OSPEER = "AssociateSwConfigHostOSPeer"
    FSM_PREV_ASSOCIATE_SW_CONFIG_PNU_OSLOCAL = "AssociateSwConfigPnuOSLocal"
    FSM_PREV_ASSOCIATE_SW_CONFIG_PNU_OSPEER = "AssociateSwConfigPnuOSPeer"
    FSM_PREV_ASSOCIATE_SW_CONFIG_PORT_NIV_LOCAL = "AssociateSwConfigPortNivLocal"
    FSM_PREV_ASSOCIATE_SW_CONFIG_PORT_NIV_PEER = "AssociateSwConfigPortNivPeer"
    FSM_PREV_ASSOCIATE_SW_CONFIG_SERVICE_INFRA_LOCAL = "AssociateSwConfigServiceInfraLocal"
    FSM_PREV_ASSOCIATE_SW_CONFIG_SERVICE_INFRA_PEER = "AssociateSwConfigServiceInfraPeer"
    FSM_PREV_ASSOCIATE_SW_UNCONFIG_PNU_OSLOCAL = "AssociateSwUnconfigPnuOSLocal"
    FSM_PREV_ASSOCIATE_SW_UNCONFIG_PNU_OSPEER = "AssociateSwUnconfigPnuOSPeer"
    FSM_PREV_ASSOCIATE_SYNC_POWER_STATE = "AssociateSyncPowerState"
    FSM_PREV_ASSOCIATE_UNCONFIG_CIMC_VMEDIA = "AssociateUnconfigCimcVMedia"
    FSM_PREV_ASSOCIATE_UNCONFIG_EXT_MGMT_GW = "AssociateUnconfigExtMgmtGw"
    FSM_PREV_ASSOCIATE_UNCONFIG_EXT_MGMT_RULES = "AssociateUnconfigExtMgmtRules"
    FSM_PREV_ASSOCIATE_UNLOCK_FIRMWARE_IMAGE = "AssociateUnlockFirmwareImage"
    FSM_PREV_ASSOCIATE_UPDATE_ADAPTOR_NW_FW_LOCAL = "AssociateUpdateAdaptorNwFwLocal"
    FSM_PREV_ASSOCIATE_UPDATE_ADAPTOR_NW_FW_PEER = "AssociateUpdateAdaptorNwFwPeer"
    FSM_PREV_ASSOCIATE_UPDATE_BIOS_REQUEST = "AssociateUpdateBiosRequest"
    FSM_PREV_ASSOCIATE_UPDATE_BOARD_CTRL_REQUEST = "AssociateUpdateBoardCtrlRequest"
    FSM_PREV_ASSOCIATE_UPDATE_IBMCFW = "AssociateUpdateIBMCFw"
    FSM_PREV_ASSOCIATE_VERIFY_FC_ZONE_CONFIG = "AssociateVerifyFcZoneConfig"
    FSM_PREV_ASSOCIATE_WAIT_FOR_ADAPTOR_NW_FW_UPDATE_LOCAL = "AssociateWaitForAdaptorNwFwUpdateLocal"
    FSM_PREV_ASSOCIATE_WAIT_FOR_ADAPTOR_NW_FW_UPDATE_PEER = "AssociateWaitForAdaptorNwFwUpdatePeer"
    FSM_PREV_ASSOCIATE_WAIT_FOR_IBMCFW_UPDATE = "AssociateWaitForIBMCFwUpdate"
    FSM_PREV_BIOS_RECOVERY_BEGIN = "BiosRecoveryBegin"
    FSM_PREV_BIOS_RECOVERY_CHECK_POWER_AVAILABILITY = "BiosRecoveryCheckPowerAvailability"
    FSM_PREV_BIOS_RECOVERY_CLEANUP = "BiosRecoveryCleanup"
    FSM_PREV_BIOS_RECOVERY_FAIL = "BiosRecoveryFail"
    FSM_PREV_BIOS_RECOVERY_POWER_DEPLOY_WAIT = "BiosRecoveryPowerDeployWait"
    FSM_PREV_BIOS_RECOVERY_PRE_SANITIZE = "BiosRecoveryPreSanitize"
    FSM_PREV_BIOS_RECOVERY_RESET = "BiosRecoveryReset"
    FSM_PREV_BIOS_RECOVERY_SANITIZE = "BiosRecoverySanitize"
    FSM_PREV_BIOS_RECOVERY_SETUP_VMEDIA_LOCAL = "BiosRecoverySetupVmediaLocal"
    FSM_PREV_BIOS_RECOVERY_SETUP_VMEDIA_PEER = "BiosRecoverySetupVmediaPeer"
    FSM_PREV_BIOS_RECOVERY_SHUTDOWN = "BiosRecoveryShutdown"
    FSM_PREV_BIOS_RECOVERY_START = "BiosRecoveryStart"
    FSM_PREV_BIOS_RECOVERY_STOP_VMEDIA_LOCAL = "BiosRecoveryStopVMediaLocal"
    FSM_PREV_BIOS_RECOVERY_STOP_VMEDIA_PEER = "BiosRecoveryStopVMediaPeer"
    FSM_PREV_BIOS_RECOVERY_SUCCESS = "BiosRecoverySuccess"
    FSM_PREV_BIOS_RECOVERY_TEARDOWN_VMEDIA_LOCAL = "BiosRecoveryTeardownVmediaLocal"
    FSM_PREV_BIOS_RECOVERY_TEARDOWN_VMEDIA_PEER = "BiosRecoveryTeardownVmediaPeer"
    FSM_PREV_BIOS_RECOVERY_WAIT = "BiosRecoveryWait"
    FSM_PREV_CIMC_SESSION_DELETE_BEGIN = "CimcSessionDeleteBegin"
    FSM_PREV_CIMC_SESSION_DELETE_EXECUTE = "CimcSessionDeleteExecute"
    FSM_PREV_CIMC_SESSION_DELETE_FAIL = "CimcSessionDeleteFail"
    FSM_PREV_CIMC_SESSION_DELETE_SUCCESS = "CimcSessionDeleteSuccess"
    FSM_PREV_CMOS_RESET_BEGIN = "CmosResetBegin"
    FSM_PREV_CMOS_RESET_BLADE_POWER_ON = "CmosResetBladePowerOn"
    FSM_PREV_CMOS_RESET_CHECK_POWER_AVAILABILITY = "CmosResetCheckPowerAvailability"
    FSM_PREV_CMOS_RESET_EXECUTE = "CmosResetExecute"
    FSM_PREV_CMOS_RESET_FAIL = "CmosResetFail"
    FSM_PREV_CMOS_RESET_POWER_DEPLOY_WAIT = "CmosResetPowerDeployWait"
    FSM_PREV_CMOS_RESET_PRE_SANITIZE = "CmosResetPreSanitize"
    FSM_PREV_CMOS_RESET_RECONFIG_BIOS = "CmosResetReconfigBios"
    FSM_PREV_CMOS_RESET_RECONFIG_UUID = "CmosResetReconfigUuid"
    FSM_PREV_CMOS_RESET_SANITIZE = "CmosResetSanitize"
    FSM_PREV_CMOS_RESET_SUCCESS = "CmosResetSuccess"
    FSM_PREV_CONFIG_BOARD_BEGIN = "ConfigBoardBegin"
    FSM_PREV_CONFIG_BOARD_CONFIG_MEMORY_POLICY = "ConfigBoardConfigMemoryPolicy"
    FSM_PREV_CONFIG_BOARD_FAIL = "ConfigBoardFail"
    FSM_PREV_CONFIG_BOARD_SUCCESS = "ConfigBoardSuccess"
    FSM_PREV_CONFIG_SO_LBEGIN = "ConfigSoLBegin"
    FSM_PREV_CONFIG_SO_LEXECUTE = "ConfigSoLExecute"
    FSM_PREV_CONFIG_SO_LFAIL = "ConfigSoLFail"
    FSM_PREV_CONFIG_SO_LSUCCESS = "ConfigSoLSuccess"
    FSM_PREV_CREATE_DHCP_ENTRY_BEGIN = "CreateDhcpEntryBegin"
    FSM_PREV_CREATE_DHCP_ENTRY_EXECUTE_LOCAL = "CreateDhcpEntryExecuteLocal"
    FSM_PREV_CREATE_DHCP_ENTRY_EXECUTE_PEER = "CreateDhcpEntryExecutePeer"
    FSM_PREV_CREATE_DHCP_ENTRY_FAIL = "CreateDhcpEntryFail"
    FSM_PREV_CREATE_DHCP_ENTRY_SUCCESS = "CreateDhcpEntrySuccess"
    FSM_PREV_DECOMMISSION_BEGIN = "DecommissionBegin"
    FSM_PREV_DECOMMISSION_CLEANUP_CIMC = "DecommissionCleanupCIMC"
    FSM_PREV_DECOMMISSION_CLEANUP_PORT_CONFIG_LOCAL = "DecommissionCleanupPortConfigLocal"
    FSM_PREV_DECOMMISSION_CLEANUP_PORT_CONFIG_PEER = "DecommissionCleanupPortConfigPeer"
    FSM_PREV_DECOMMISSION_EXECUTE = "DecommissionExecute"
    FSM_PREV_DECOMMISSION_FAIL = "DecommissionFail"
    FSM_PREV_DECOMMISSION_PRECLEANUP_PORT_CONFIG = "DecommissionPrecleanupPortConfig"
    FSM_PREV_DECOMMISSION_STOP_VMEDIA_LOCAL = "DecommissionStopVMediaLocal"
    FSM_PREV_DECOMMISSION_STOP_VMEDIA_PEER = "DecommissionStopVMediaPeer"
    FSM_PREV_DECOMMISSION_SUCCESS = "DecommissionSuccess"
    FSM_PREV_DECOMMISSION_UNCONFIG_EXT_MGMT_GW = "DecommissionUnconfigExtMgmtGw"
    FSM_PREV_DECOMMISSION_UNCONFIG_EXT_MGMT_RULES = "DecommissionUnconfigExtMgmtRules"
    FSM_PREV_DIAGNOSTIC_INTERRUPT_BEGIN = "DiagnosticInterruptBegin"
    FSM_PREV_DIAGNOSTIC_INTERRUPT_EXECUTE = "DiagnosticInterruptExecute"
    FSM_PREV_DIAGNOSTIC_INTERRUPT_FAIL = "DiagnosticInterruptFail"
    FSM_PREV_DIAGNOSTIC_INTERRUPT_SUCCESS = "DiagnosticInterruptSuccess"
    FSM_PREV_DISASSOCIATE_BEGIN = "DisassociateBegin"
    FSM_PREV_DISASSOCIATE_BIOS_POST_COMPLETION = "DisassociateBiosPostCompletion"
    FSM_PREV_DISASSOCIATE_BMC_CONFIG_PNU_OS = "DisassociateBmcConfigPnuOS"
    FSM_PREV_DISASSOCIATE_BMC_PRECONFIG_PNU_OSLOCAL = "DisassociateBmcPreconfigPnuOSLocal"
    FSM_PREV_DISASSOCIATE_BMC_PRECONFIG_PNU_OSPEER = "DisassociateBmcPreconfigPnuOSPeer"
    FSM_PREV_DISASSOCIATE_BMC_UNCONFIG_PNU_OS = "DisassociateBmcUnconfigPnuOS"
    FSM_PREV_DISASSOCIATE_BOOT_PNUOS = "DisassociateBootPnuos"
    FSM_PREV_DISASSOCIATE_BOOT_WAIT = "DisassociateBootWait"
    FSM_PREV_DISASSOCIATE_CHECK_POWER_AVAILABILITY = "DisassociateCheckPowerAvailability"
    FSM_PREV_DISASSOCIATE_CONFIG_BIOS = "DisassociateConfigBios"
    FSM_PREV_DISASSOCIATE_CONFIG_FLEX_FLASH_SCRUB = "DisassociateConfigFlexFlashScrub"
    FSM_PREV_DISASSOCIATE_CONFIG_KVM_MGMT_DEFAULT_SETTING = "DisassociateConfigKvmMgmtDefaultSetting"
    FSM_PREV_DISASSOCIATE_CONFIG_USER_ACCESS = "DisassociateConfigUserAccess"
    FSM_PREV_DISASSOCIATE_DEASSERT_RESET_BYPASS = "DisassociateDeassertResetBypass"
    FSM_PREV_DISASSOCIATE_FAIL = "DisassociateFail"
    FSM_PREV_DISASSOCIATE_HAG_PNU_OSCONNECT = "DisassociateHagPnuOSConnect"
    FSM_PREV_DISASSOCIATE_HAG_PNU_OSDISCONNECT = "DisassociateHagPnuOSDisconnect"
    FSM_PREV_DISASSOCIATE_HANDLE_POOLING = "DisassociateHandlePooling"
    FSM_PREV_DISASSOCIATE_NIC_CONFIG_PNU_OSLOCAL = "DisassociateNicConfigPnuOSLocal"
    FSM_PREV_DISASSOCIATE_NIC_CONFIG_PNU_OSPEER = "DisassociateNicConfigPnuOSPeer"
    FSM_PREV_DISASSOCIATE_NIC_UNCONFIG_HOST_OSLOCAL = "DisassociateNicUnconfigHostOSLocal"
    FSM_PREV_DISASSOCIATE_NIC_UNCONFIG_HOST_OSPEER = "DisassociateNicUnconfigHostOSPeer"
    FSM_PREV_DISASSOCIATE_NIC_UNCONFIG_PNU_OSLOCAL = "DisassociateNicUnconfigPnuOSLocal"
    FSM_PREV_DISASSOCIATE_NIC_UNCONFIG_PNU_OSPEER = "DisassociateNicUnconfigPnuOSPeer"
    FSM_PREV_DISASSOCIATE_NIC_UNCONFIG_SERVICE_INFRA_LOCAL = "DisassociateNicUnconfigServiceInfraLocal"
    FSM_PREV_DISASSOCIATE_NIC_UNCONFIG_SERVICE_INFRA_PEER = "DisassociateNicUnconfigServiceInfraPeer"
    FSM_PREV_DISASSOCIATE_OOB_DISK_SCRUB = "DisassociateOobDiskScrub"
    FSM_PREV_DISASSOCIATE_PNU_OSCATALOG = "DisassociatePnuOSCatalog"
    FSM_PREV_DISASSOCIATE_PNU_OSIDENT = "DisassociatePnuOSIdent"
    FSM_PREV_DISASSOCIATE_PNU_OSPOLICY = "DisassociatePnuOSPolicy"
    FSM_PREV_DISASSOCIATE_PNU_OSSCRUB = "DisassociatePnuOSScrub"
    FSM_PREV_DISASSOCIATE_PNU_OSSELF_TEST = "DisassociatePnuOSSelfTest"
    FSM_PREV_DISASSOCIATE_PNU_OSUNCONFIG = "DisassociatePnuOSUnconfig"
    FSM_PREV_DISASSOCIATE_PNU_OSVALIDATE = "DisassociatePnuOSValidate"
    FSM_PREV_DISASSOCIATE_POWER_DEPLOY_WAIT = "DisassociatePowerDeployWait"
    FSM_PREV_DISASSOCIATE_POWER_ON = "DisassociatePowerOn"
    FSM_PREV_DISASSOCIATE_PRE_SANITIZE = "DisassociatePreSanitize"
    FSM_PREV_DISASSOCIATE_RESET_SECURE_BOOT_CONFIG = "DisassociateResetSecureBootConfig"
    FSM_PREV_DISASSOCIATE_SANITIZE = "DisassociateSanitize"
    FSM_PREV_DISASSOCIATE_SERIAL_DEBUG_PNU_OSCONNECT = "DisassociateSerialDebugPnuOSConnect"
    FSM_PREV_DISASSOCIATE_SERIAL_DEBUG_PNU_OSDISCONNECT = "DisassociateSerialDebugPnuOSDisconnect"
    FSM_PREV_DISASSOCIATE_SHUTDOWN = "DisassociateShutdown"
    FSM_PREV_DISASSOCIATE_SOL_REDIRECT_DISABLE = "DisassociateSolRedirectDisable"
    FSM_PREV_DISASSOCIATE_SOL_REDIRECT_ENABLE = "DisassociateSolRedirectEnable"
    FSM_PREV_DISASSOCIATE_SUCCESS = "DisassociateSuccess"
    FSM_PREV_DISASSOCIATE_SW_CONFIG_PNU_OSLOCAL = "DisassociateSwConfigPnuOSLocal"
    FSM_PREV_DISASSOCIATE_SW_CONFIG_PNU_OSPEER = "DisassociateSwConfigPnuOSPeer"
    FSM_PREV_DISASSOCIATE_SW_CONFIG_PORT_NIV_LOCAL = "DisassociateSwConfigPortNivLocal"
    FSM_PREV_DISASSOCIATE_SW_CONFIG_PORT_NIV_PEER = "DisassociateSwConfigPortNivPeer"
    FSM_PREV_DISASSOCIATE_SW_UNCONFIG_HOST_OSLOCAL = "DisassociateSwUnconfigHostOSLocal"
    FSM_PREV_DISASSOCIATE_SW_UNCONFIG_HOST_OSPEER = "DisassociateSwUnconfigHostOSPeer"
    FSM_PREV_DISASSOCIATE_SW_UNCONFIG_PNU_OSLOCAL = "DisassociateSwUnconfigPnuOSLocal"
    FSM_PREV_DISASSOCIATE_SW_UNCONFIG_PNU_OSPEER = "DisassociateSwUnconfigPnuOSPeer"
    FSM_PREV_DISASSOCIATE_UNCONFIG_BIOS = "DisassociateUnconfigBios"
    FSM_PREV_DISASSOCIATE_UNCONFIG_CIMC_VMEDIA = "DisassociateUnconfigCimcVMedia"
    FSM_PREV_DISASSOCIATE_UNCONFIG_EXT_MGMT_GW = "DisassociateUnconfigExtMgmtGw"
    FSM_PREV_DISASSOCIATE_UNCONFIG_EXT_MGMT_RULES = "DisassociateUnconfigExtMgmtRules"
    FSM_PREV_DISASSOCIATE_UNCONFIG_FLEX_FLASH = "DisassociateUnconfigFlexFlash"
    FSM_PREV_DISASSOCIATE_UNCONFIG_SO_L = "DisassociateUnconfigSoL"
    FSM_PREV_DISASSOCIATE_UNCONFIG_UUID = "DisassociateUnconfigUuid"
    FSM_PREV_DISASSOCIATE_VERIFY_FC_ZONE_CONFIG = "DisassociateVerifyFcZoneConfig"
    FSM_PREV_DISCOVER_BEGIN = "DiscoverBegin"
    FSM_PREV_DISCOVER_BIOS_POST_COMPLETION = "DiscoverBiosPostCompletion"
    FSM_PREV_DISCOVER_BLADE_POWER_OFF = "DiscoverBladePowerOff"
    FSM_PREV_DISCOVER_BMC_CONFIG_PNU_OS = "DiscoverBmcConfigPnuOS"
    FSM_PREV_DISCOVER_BMC_CONFIGURE_CONN_LOCAL = "DiscoverBmcConfigureConnLocal"
    FSM_PREV_DISCOVER_BMC_CONFIGURE_CONN_PEER = "DiscoverBmcConfigureConnPeer"
    FSM_PREV_DISCOVER_BMC_FACTORY_RESET = "DiscoverBmcFactoryReset"
    FSM_PREV_DISCOVER_BMC_INVENTORY = "DiscoverBmcInventory"
    FSM_PREV_DISCOVER_BMC_PRECONFIG_PNU_OSLOCAL = "DiscoverBmcPreconfigPnuOSLocal"
    FSM_PREV_DISCOVER_BMC_PRECONFIG_PNU_OSPEER = "DiscoverBmcPreconfigPnuOSPeer"
    FSM_PREV_DISCOVER_BMC_PRESENCE = "DiscoverBmcPresence"
    FSM_PREV_DISCOVER_BMC_SHUTDOWN_DISCOVERED = "DiscoverBmcShutdownDiscovered"
    FSM_PREV_DISCOVER_BMC_UNCONFIG_PNU_OS = "DiscoverBmcUnconfigPnuOS"
    FSM_PREV_DISCOVER_BOOT_PNUOS = "DiscoverBootPnuos"
    FSM_PREV_DISCOVER_BOOT_WAIT = "DiscoverBootWait"
    FSM_PREV_DISCOVER_CHECK_POWER_AVAILABILITY = "DiscoverCheckPowerAvailability"
    FSM_PREV_DISCOVER_CONFIG_DISCOVERY_MODE = "DiscoverConfigDiscoveryMode"
    FSM_PREV_DISCOVER_CONFIG_FLEX_FLASH_SCRUB = "DiscoverConfigFlexFlashScrub"
    FSM_PREV_DISCOVER_CONFIG_NIV_MODE = "DiscoverConfigNivMode"
    FSM_PREV_DISCOVER_CONFIG_USER_ACCESS = "DiscoverConfigUserAccess"
    FSM_PREV_DISCOVER_FAIL = "DiscoverFail"
    FSM_PREV_DISCOVER_HAG_CONNECT = "DiscoverHagConnect"
    FSM_PREV_DISCOVER_HAG_DISCONNECT = "DiscoverHagDisconnect"
    FSM_PREV_DISCOVER_HANDLE_POOLING = "DiscoverHandlePooling"
    FSM_PREV_DISCOVER_NIC_CONFIG_PNU_OSLOCAL = "DiscoverNicConfigPnuOSLocal"
    FSM_PREV_DISCOVER_NIC_CONFIG_PNU_OSPEER = "DiscoverNicConfigPnuOSPeer"
    FSM_PREV_DISCOVER_NIC_INVENTORY_LOCAL = "DiscoverNicInventoryLocal"
    FSM_PREV_DISCOVER_NIC_INVENTORY_PEER = "DiscoverNicInventoryPeer"
    FSM_PREV_DISCOVER_OOB_STORAGE_INVENTORY = "DiscoverOobStorageInventory"
    FSM_PREV_DISCOVER_PNU_OSCATALOG = "DiscoverPnuOSCatalog"
    FSM_PREV_DISCOVER_PNU_OSCONN_STATUS = "DiscoverPnuOSConnStatus"
    FSM_PREV_DISCOVER_PNU_OSCONNECTIVITY = "DiscoverPnuOSConnectivity"
    FSM_PREV_DISCOVER_PNU_OSIDENT = "DiscoverPnuOSIdent"
    FSM_PREV_DISCOVER_PNU_OSINVENTORY = "DiscoverPnuOSInventory"
    FSM_PREV_DISCOVER_PNU_OSPOLICY = "DiscoverPnuOSPolicy"
    FSM_PREV_DISCOVER_PNU_OSSCRUB = "DiscoverPnuOSScrub"
    FSM_PREV_DISCOVER_PNU_OSSELF_TEST = "DiscoverPnuOSSelfTest"
    FSM_PREV_DISCOVER_POWER_DEPLOY_WAIT = "DiscoverPowerDeployWait"
    FSM_PREV_DISCOVER_PRE_SANITIZE = "DiscoverPreSanitize"
    FSM_PREV_DISCOVER_READ_SMBIOS = "DiscoverReadSmbios"
    FSM_PREV_DISCOVER_SANITIZE = "DiscoverSanitize"
    FSM_PREV_DISCOVER_SERIAL_DEBUG_CONNECT = "DiscoverSerialDebugConnect"
    FSM_PREV_DISCOVER_SERIAL_DEBUG_DISCONNECT = "DiscoverSerialDebugDisconnect"
    FSM_PREV_DISCOVER_SOL_REDIRECT_DISABLE = "DiscoverSolRedirectDisable"
    FSM_PREV_DISCOVER_SOL_REDIRECT_ENABLE = "DiscoverSolRedirectEnable"
    FSM_PREV_DISCOVER_SUCCESS = "DiscoverSuccess"
    FSM_PREV_DISCOVER_SW_CONFIG_PNU_OSLOCAL = "DiscoverSwConfigPnuOSLocal"
    FSM_PREV_DISCOVER_SW_CONFIG_PNU_OSPEER = "DiscoverSwConfigPnuOSPeer"
    FSM_PREV_DISCOVER_SW_CONFIG_PORT_NIV_LOCAL = "DiscoverSwConfigPortNivLocal"
    FSM_PREV_DISCOVER_SW_CONFIG_PORT_NIV_PEER = "DiscoverSwConfigPortNivPeer"
    FSM_PREV_DISCOVER_SW_CONFIGURE_CONN_LOCAL = "DiscoverSwConfigureConnLocal"
    FSM_PREV_DISCOVER_SW_CONFIGURE_CONN_PEER = "DiscoverSwConfigureConnPeer"
    FSM_PREV_DISCOVER_SW_PNU_OSCONNECTIVITY_LOCAL = "DiscoverSwPnuOSConnectivityLocal"
    FSM_PREV_DISCOVER_SW_PNU_OSCONNECTIVITY_PEER = "DiscoverSwPnuOSConnectivityPeer"
    FSM_PREV_DISCOVER_SW_UNCONFIG_PORT_NIV_LOCAL = "DiscoverSwUnconfigPortNivLocal"
    FSM_PREV_DISCOVER_SW_UNCONFIG_PORT_NIV_PEER = "DiscoverSwUnconfigPortNivPeer"
    FSM_PREV_DISCOVER_UNCONFIG_CIMC_VMEDIA = "DiscoverUnconfigCimcVMedia"
    FSM_PREV_DISCOVER_UNCONFIG_EXT_MGMT_GW = "DiscoverUnconfigExtMgmtGw"
    FSM_PREV_DISCOVER_UNCONFIG_EXT_MGMT_RULES = "DiscoverUnconfigExtMgmtRules"
    FSM_PREV_DISCOVER_WAIT_FOR_CONN_READY = "DiscoverWaitForConnReady"
    FSM_PREV_DISK_ZONING_INVENTORY_BEGIN = "DiskZoningInventoryBegin"
    FSM_PREV_DISK_ZONING_INVENTORY_BOOT_HOST = "DiskZoningInventoryBootHost"
    FSM_PREV_DISK_ZONING_INVENTORY_BOOT_WAIT = "DiskZoningInventoryBootWait"
    FSM_PREV_DISK_ZONING_INVENTORY_FAIL = "DiskZoningInventoryFail"
    FSM_PREV_DISK_ZONING_INVENTORY_PRE_SANITIZE = "DiskZoningInventoryPreSanitize"
    FSM_PREV_DISK_ZONING_INVENTORY_SANITIZE = "DiskZoningInventorySanitize"
    FSM_PREV_DISK_ZONING_INVENTORY_SHUTDOWN = "DiskZoningInventoryShutdown"
    FSM_PREV_DISK_ZONING_INVENTORY_STORAGE_INVENTORY = "DiskZoningInventoryStorageInventory"
    FSM_PREV_DISK_ZONING_INVENTORY_SUCCESS = "DiskZoningInventorySuccess"
    FSM_PREV_ENABLE_CIMC_SECURE_BOOT_ACTIVATE = "EnableCimcSecureBootActivate"
    FSM_PREV_ENABLE_CIMC_SECURE_BOOT_BEGIN = "EnableCimcSecureBootBegin"
    FSM_PREV_ENABLE_CIMC_SECURE_BOOT_FAIL = "EnableCimcSecureBootFail"
    FSM_PREV_ENABLE_CIMC_SECURE_BOOT_POLL_UPDATE_STATUS = "EnableCimcSecureBootPollUpdateStatus"
    FSM_PREV_ENABLE_CIMC_SECURE_BOOT_RESET = "EnableCimcSecureBootReset"
    FSM_PREV_ENABLE_CIMC_SECURE_BOOT_SUCCESS = "EnableCimcSecureBootSuccess"
    FSM_PREV_ENABLE_CIMC_SECURE_BOOT_UPDATE_REQUEST = "EnableCimcSecureBootUpdateRequest"
    FSM_PREV_FLASH_CONTROLLER_BEGIN = "FlashControllerBegin"
    FSM_PREV_FLASH_CONTROLLER_FAIL = "FlashControllerFail"
    FSM_PREV_FLASH_CONTROLLER_SUCCESS = "FlashControllerSuccess"
    FSM_PREV_FLASH_CONTROLLER_UPDATE_FLASH_LIFE = "FlashControllerUpdateFlashLife"
    FSM_PREV_FW_UPGRADE_ACTIVATE_ADAPTOR_NW_FW_LOCAL = "FwUpgradeActivateAdaptorNwFwLocal"
    FSM_PREV_FW_UPGRADE_ACTIVATE_ADAPTOR_NW_FW_PEER = "FwUpgradeActivateAdaptorNwFwPeer"
    FSM_PREV_FW_UPGRADE_ACTIVATE_BIOS = "FwUpgradeActivateBios"
    FSM_PREV_FW_UPGRADE_ACTIVATE_IBMCFW = "FwUpgradeActivateIBMCFw"
    FSM_PREV_FW_UPGRADE_BEGIN = "FwUpgradeBegin"
    FSM_PREV_FW_UPGRADE_BIOS_IMG_UPDATE = "FwUpgradeBiosImgUpdate"
    FSM_PREV_FW_UPGRADE_BIOS_POST_COMPLETION = "FwUpgradeBiosPostCompletion"
    FSM_PREV_FW_UPGRADE_BLADE_POWER_OFF = "FwUpgradeBladePowerOff"
    FSM_PREV_FW_UPGRADE_BMC_CONFIG_PNU_OS = "FwUpgradeBmcConfigPnuOS"
    FSM_PREV_FW_UPGRADE_BMC_PRECONFIG_PNU_OSLOCAL = "FwUpgradeBmcPreconfigPnuOSLocal"
    FSM_PREV_FW_UPGRADE_BMC_PRECONFIG_PNU_OSPEER = "FwUpgradeBmcPreconfigPnuOSPeer"
    FSM_PREV_FW_UPGRADE_BMC_UNCONFIG_PNU_OS = "FwUpgradeBmcUnconfigPnuOS"
    FSM_PREV_FW_UPGRADE_BOOT_PNUOS = "FwUpgradeBootPnuos"
    FSM_PREV_FW_UPGRADE_BOOT_WAIT = "FwUpgradeBootWait"
    FSM_PREV_FW_UPGRADE_CHECK_POWER_AVAILABILITY = "FwUpgradeCheckPowerAvailability"
    FSM_PREV_FW_UPGRADE_CISCO_OSOPEN_GATE = "FwUpgradeCiscoOSOpenGate"
    FSM_PREV_FW_UPGRADE_CLEAR_BIOS_UPDATE = "FwUpgradeClearBiosUpdate"
    FSM_PREV_FW_UPGRADE_COPY_REMOTE = "FwUpgradeCopyRemote"
    FSM_PREV_FW_UPGRADE_DEASSERT_RESET_BYPASS = "FwUpgradeDeassertResetBypass"
    FSM_PREV_FW_UPGRADE_DELETE_CURL_DOWNLOADED_IMAGES = "FwUpgradeDeleteCurlDownloadedImages"
    FSM_PREV_FW_UPGRADE_DELETE_IMAGES_REMOTE = "FwUpgradeDeleteImagesRemote"
    FSM_PREV_FW_UPGRADE_DOWNLOAD_IMAGES = "FwUpgradeDownloadImages"
    FSM_PREV_FW_UPGRADE_FAIL = "FwUpgradeFail"
    FSM_PREV_FW_UPGRADE_GRAPHICS_IMAGE_UPDATE = "FwUpgradeGraphicsImageUpdate"
    FSM_PREV_FW_UPGRADE_HAG_PNU_OSCONNECT = "FwUpgradeHagPnuOSConnect"
    FSM_PREV_FW_UPGRADE_HAG_PNU_OSDISCONNECT = "FwUpgradeHagPnuOSDisconnect"
    FSM_PREV_FW_UPGRADE_HBA_IMG_UPDATE = "FwUpgradeHbaImgUpdate"
    FSM_PREV_FW_UPGRADE_LOCAL_DISK_FW_UPDATE = "FwUpgradeLocalDiskFwUpdate"
    FSM_PREV_FW_UPGRADE_NIC_CONFIG_PNU_OSLOCAL = "FwUpgradeNicConfigPnuOSLocal"
    FSM_PREV_FW_UPGRADE_NIC_CONFIG_PNU_OSPEER = "FwUpgradeNicConfigPnuOSPeer"
    FSM_PREV_FW_UPGRADE_NIC_IMG_UPDATE = "FwUpgradeNicImgUpdate"
    FSM_PREV_FW_UPGRADE_NIC_UNCONFIG_PNU_OSLOCAL = "FwUpgradeNicUnconfigPnuOSLocal"
    FSM_PREV_FW_UPGRADE_NIC_UNCONFIG_PNU_OSPEER = "FwUpgradeNicUnconfigPnuOSPeer"
    FSM_PREV_FW_UPGRADE_OOB_POLL_SAS_EXPANDER_ACTIVATE_STATUS = "FwUpgradeOobPollSasExpanderActivateStatus"
    FSM_PREV_FW_UPGRADE_OOB_POLL_SAS_EXPANDER_UPDATE_STATUS = "FwUpgradeOobPollSasExpanderUpdateStatus"
    FSM_PREV_FW_UPGRADE_OOB_SAS_EXPANDER_IMG_ACTIVATE = "FwUpgradeOobSasExpanderImgActivate"
    FSM_PREV_FW_UPGRADE_OOB_SAS_EXPANDER_IMG_UPDATE = "FwUpgradeOobSasExpanderImgUpdate"
    FSM_PREV_FW_UPGRADE_OOB_STORAGE_INVENTORY = "FwUpgradeOobStorageInventory"
    FSM_PREV_FW_UPGRADE_PNU_OSCATALOG = "FwUpgradePnuOSCatalog"
    FSM_PREV_FW_UPGRADE_PNU_OSCONFIG = "FwUpgradePnuOSConfig"
    FSM_PREV_FW_UPGRADE_PNU_OSIDENT = "FwUpgradePnuOSIdent"
    FSM_PREV_FW_UPGRADE_PNU_OSINVENTORY = "FwUpgradePnuOSInventory"
    FSM_PREV_FW_UPGRADE_PNU_OSPOLICY = "FwUpgradePnuOSPolicy"
    FSM_PREV_FW_UPGRADE_PNU_OSSELF_TEST = "FwUpgradePnuOSSelfTest"
    FSM_PREV_FW_UPGRADE_PNU_OSUNLOAD_DRIVERS = "FwUpgradePnuOSUnloadDrivers"
    FSM_PREV_FW_UPGRADE_PNU_OSVALIDATE = "FwUpgradePnuOSValidate"
    FSM_PREV_FW_UPGRADE_POLL_BIOS_ACTIVATE_STATUS = "FwUpgradePollBiosActivateStatus"
    FSM_PREV_FW_UPGRADE_POLL_BIOS_UPDATE_STATUS = "FwUpgradePollBiosUpdateStatus"
    FSM_PREV_FW_UPGRADE_POLL_BOARD_CTRL_POWER_CYCLE = "FwUpgradePollBoardCtrlPowerCycle"
    FSM_PREV_FW_UPGRADE_POLL_BOARD_CTRL_UPDATE_STATUS = "FwUpgradePollBoardCtrlUpdateStatus"
    FSM_PREV_FW_UPGRADE_POLL_CLEAR_BIOS_UPDATE_STATUS = "FwUpgradePollClearBiosUpdateStatus"
    FSM_PREV_FW_UPGRADE_POWER_CYCLE_BOARD = "FwUpgradePowerCycleBoard"
    FSM_PREV_FW_UPGRADE_POWER_DEPLOY_WAIT = "FwUpgradePowerDeployWait"
    FSM_PREV_FW_UPGRADE_POWER_ON = "FwUpgradePowerOn"
    FSM_PREV_FW_UPGRADE_PRE_SANITIZE = "FwUpgradePreSanitize"
    FSM_PREV_FW_UPGRADE_RESET_IBMC = "FwUpgradeResetIBMC"
    FSM_PREV_FW_UPGRADE_SANITIZE = "FwUpgradeSanitize"
    FSM_PREV_FW_UPGRADE_SAS_EXPANDER_IMG_UPDATE = "FwUpgradeSasExpanderImgUpdate"
    FSM_PREV_FW_UPGRADE_SERIAL_DEBUG_PNU_OSCONNECT = "FwUpgradeSerialDebugPnuOSConnect"
    FSM_PREV_FW_UPGRADE_SERIAL_DEBUG_PNU_OSDISCONNECT = "FwUpgradeSerialDebugPnuOSDisconnect"
    FSM_PREV_FW_UPGRADE_SHUTDOWN = "FwUpgradeShutdown"
    FSM_PREV_FW_UPGRADE_SOL_REDIRECT_DISABLE = "FwUpgradeSolRedirectDisable"
    FSM_PREV_FW_UPGRADE_SOL_REDIRECT_ENABLE = "FwUpgradeSolRedirectEnable"
    FSM_PREV_FW_UPGRADE_STORAGE_CTLR_IMG_UPDATE = "FwUpgradeStorageCtlrImgUpdate"
    FSM_PREV_FW_UPGRADE_SUCCESS = "FwUpgradeSuccess"
    FSM_PREV_FW_UPGRADE_SW_CONFIG_PNU_OSLOCAL = "FwUpgradeSwConfigPnuOSLocal"
    FSM_PREV_FW_UPGRADE_SW_CONFIG_PNU_OSPEER = "FwUpgradeSwConfigPnuOSPeer"
    FSM_PREV_FW_UPGRADE_SW_CONFIG_PORT_NIV_LOCAL = "FwUpgradeSwConfigPortNivLocal"
    FSM_PREV_FW_UPGRADE_SW_CONFIG_PORT_NIV_PEER = "FwUpgradeSwConfigPortNivPeer"
    FSM_PREV_FW_UPGRADE_SW_UNCONFIG_PNU_OSLOCAL = "FwUpgradeSwUnconfigPnuOSLocal"
    FSM_PREV_FW_UPGRADE_SW_UNCONFIG_PNU_OSPEER = "FwUpgradeSwUnconfigPnuOSPeer"
    FSM_PREV_FW_UPGRADE_UNCONFIG_CIMC_VMEDIA = "FwUpgradeUnconfigCimcVMedia"
    FSM_PREV_FW_UPGRADE_UNCONFIG_EXT_MGMT_GW = "FwUpgradeUnconfigExtMgmtGw"
    FSM_PREV_FW_UPGRADE_UNCONFIG_EXT_MGMT_RULES = "FwUpgradeUnconfigExtMgmtRules"
    FSM_PREV_FW_UPGRADE_UNLOCK_FIRMWARE_IMAGE = "FwUpgradeUnlockFirmwareImage"
    FSM_PREV_FW_UPGRADE_UPDATE_ADAPTOR_NW_FW_LOCAL = "FwUpgradeUpdateAdaptorNwFwLocal"
    FSM_PREV_FW_UPGRADE_UPDATE_ADAPTOR_NW_FW_PEER = "FwUpgradeUpdateAdaptorNwFwPeer"
    FSM_PREV_FW_UPGRADE_UPDATE_BIOS_REQUEST = "FwUpgradeUpdateBiosRequest"
    FSM_PREV_FW_UPGRADE_UPDATE_BOARD_CTRL_REQUEST = "FwUpgradeUpdateBoardCtrlRequest"
    FSM_PREV_FW_UPGRADE_UPDATE_IBMCFW = "FwUpgradeUpdateIBMCFw"
    FSM_PREV_FW_UPGRADE_WAIT_FOR_ADAPTOR_NW_FW_UPDATE_LOCAL = "FwUpgradeWaitForAdaptorNwFwUpdateLocal"
    FSM_PREV_FW_UPGRADE_WAIT_FOR_ADAPTOR_NW_FW_UPDATE_PEER = "FwUpgradeWaitForAdaptorNwFwUpdatePeer"
    FSM_PREV_FW_UPGRADE_WAIT_FOR_IBMCFW_UPDATE = "FwUpgradeWaitForIBMCFwUpdate"
    FSM_PREV_HARD_SHUTDOWN_BEGIN = "HardShutdownBegin"
    FSM_PREV_HARD_SHUTDOWN_EXECUTE = "HardShutdownExecute"
    FSM_PREV_HARD_SHUTDOWN_FAIL = "HardShutdownFail"
    FSM_PREV_HARD_SHUTDOWN_SUCCESS = "HardShutdownSuccess"
    FSM_PREV_HARDRESET_BEGIN = "HardresetBegin"
    FSM_PREV_HARDRESET_CHECK_POWER_AVAILABILITY = "HardresetCheckPowerAvailability"
    FSM_PREV_HARDRESET_EXECUTE = "HardresetExecute"
    FSM_PREV_HARDRESET_FAIL = "HardresetFail"
    FSM_PREV_HARDRESET_POWER_DEPLOY_WAIT = "HardresetPowerDeployWait"
    FSM_PREV_HARDRESET_PRE_SANITIZE = "HardresetPreSanitize"
    FSM_PREV_HARDRESET_SANITIZE = "HardresetSanitize"
    FSM_PREV_HARDRESET_SUCCESS = "HardresetSuccess"
    FSM_PREV_OFFLINE_BEGIN = "OfflineBegin"
    FSM_PREV_OFFLINE_CLEANUP_LOCAL = "OfflineCleanupLocal"
    FSM_PREV_OFFLINE_CLEANUP_PEER = "OfflineCleanupPeer"
    FSM_PREV_OFFLINE_FAIL = "OfflineFail"
    FSM_PREV_OFFLINE_SUCCESS = "OfflineSuccess"
    FSM_PREV_OFFLINE_SW_UNCONFIGURE_LOCAL = "OfflineSwUnconfigureLocal"
    FSM_PREV_OFFLINE_SW_UNCONFIGURE_PEER = "OfflineSwUnconfigurePeer"
    FSM_PREV_OOB_STORAGE_ADMIN_CONFIG_BEGIN = "OobStorageAdminConfigBegin"
    FSM_PREV_OOB_STORAGE_ADMIN_CONFIG_BOOT_HOST = "OobStorageAdminConfigBootHost"
    FSM_PREV_OOB_STORAGE_ADMIN_CONFIG_BOOT_WAIT = "OobStorageAdminConfigBootWait"
    FSM_PREV_OOB_STORAGE_ADMIN_CONFIG_FAIL = "OobStorageAdminConfigFail"
    FSM_PREV_OOB_STORAGE_ADMIN_CONFIG_OOB_STORAGE_CONFIG = "OobStorageAdminConfigOobStorageConfig"
    FSM_PREV_OOB_STORAGE_ADMIN_CONFIG_OOB_STORAGE_INVENTORY = "OobStorageAdminConfigOobStorageInventory"
    FSM_PREV_OOB_STORAGE_ADMIN_CONFIG_PRE_SANITIZE = "OobStorageAdminConfigPreSanitize"
    FSM_PREV_OOB_STORAGE_ADMIN_CONFIG_SANITIZE = "OobStorageAdminConfigSanitize"
    FSM_PREV_OOB_STORAGE_ADMIN_CONFIG_SHUTDOWN = "OobStorageAdminConfigShutdown"
    FSM_PREV_OOB_STORAGE_ADMIN_CONFIG_SUCCESS = "OobStorageAdminConfigSuccess"
    FSM_PREV_OOB_STORAGE_ADMIN_CONFIG_TEAR_DOWN_VMEDIA_LOCAL = "OobStorageAdminConfigTearDownVMediaLocal"
    FSM_PREV_OOB_STORAGE_ADMIN_CONFIG_TEAR_DOWN_VMEDIA_PEER = "OobStorageAdminConfigTearDownVMediaPeer"
    FSM_PREV_POWER_CAP_BEGIN = "PowerCapBegin"
    FSM_PREV_POWER_CAP_CONFIG = "PowerCapConfig"
    FSM_PREV_POWER_CAP_FAIL = "PowerCapFail"
    FSM_PREV_POWER_CAP_SUCCESS = "PowerCapSuccess"
    FSM_PREV_POWERCYCLE_BEGIN = "PowercycleBegin"
    FSM_PREV_POWERCYCLE_CHECK_POWER_AVAILABILITY = "PowercycleCheckPowerAvailability"
    FSM_PREV_POWERCYCLE_EXECUTE = "PowercycleExecute"
    FSM_PREV_POWERCYCLE_FAIL = "PowercycleFail"
    FSM_PREV_POWERCYCLE_POWER_DEPLOY_WAIT = "PowercyclePowerDeployWait"
    FSM_PREV_POWERCYCLE_PRE_SANITIZE = "PowercyclePreSanitize"
    FSM_PREV_POWERCYCLE_SANITIZE = "PowercycleSanitize"
    FSM_PREV_POWERCYCLE_SUCCESS = "PowercycleSuccess"
    FSM_PREV_RESET_BMC_BEGIN = "ResetBmcBegin"
    FSM_PREV_RESET_BMC_EXECUTE = "ResetBmcExecute"
    FSM_PREV_RESET_BMC_FAIL = "ResetBmcFail"
    FSM_PREV_RESET_BMC_SUCCESS = "ResetBmcSuccess"
    FSM_PREV_RESET_IPMI_BEGIN = "ResetIpmiBegin"
    FSM_PREV_RESET_IPMI_EXECUTE = "ResetIpmiExecute"
    FSM_PREV_RESET_IPMI_FAIL = "ResetIpmiFail"
    FSM_PREV_RESET_IPMI_SUCCESS = "ResetIpmiSuccess"
    FSM_PREV_RESET_KVM_BEGIN = "ResetKvmBegin"
    FSM_PREV_RESET_KVM_EXECUTE = "ResetKvmExecute"
    FSM_PREV_RESET_KVM_FAIL = "ResetKvmFail"
    FSM_PREV_RESET_KVM_SUCCESS = "ResetKvmSuccess"
    FSM_PREV_RESET_MEMORY_ERRORS_BEGIN = "ResetMemoryErrorsBegin"
    FSM_PREV_RESET_MEMORY_ERRORS_EXECUTE = "ResetMemoryErrorsExecute"
    FSM_PREV_RESET_MEMORY_ERRORS_FAIL = "ResetMemoryErrorsFail"
    FSM_PREV_RESET_MEMORY_ERRORS_SUCCESS = "ResetMemoryErrorsSuccess"
    FSM_PREV_SERVICE_INFRA_DEPLOY_BEGIN = "ServiceInfraDeployBegin"
    FSM_PREV_SERVICE_INFRA_DEPLOY_FAIL = "ServiceInfraDeployFail"
    FSM_PREV_SERVICE_INFRA_DEPLOY_NIC_CONFIG_LOCAL = "ServiceInfraDeployNicConfigLocal"
    FSM_PREV_SERVICE_INFRA_DEPLOY_NIC_CONFIG_PEER = "ServiceInfraDeployNicConfigPeer"
    FSM_PREV_SERVICE_INFRA_DEPLOY_SUCCESS = "ServiceInfraDeploySuccess"
    FSM_PREV_SERVICE_INFRA_DEPLOY_SW_CONFIG_LOCAL = "ServiceInfraDeploySwConfigLocal"
    FSM_PREV_SERVICE_INFRA_DEPLOY_SW_CONFIG_PEER = "ServiceInfraDeploySwConfigPeer"
    FSM_PREV_SERVICE_INFRA_WITHDRAW_BEGIN = "ServiceInfraWithdrawBegin"
    FSM_PREV_SERVICE_INFRA_WITHDRAW_FAIL = "ServiceInfraWithdrawFail"
    FSM_PREV_SERVICE_INFRA_WITHDRAW_NIC_UN_CONFIG_LOCAL = "ServiceInfraWithdrawNicUnConfigLocal"
    FSM_PREV_SERVICE_INFRA_WITHDRAW_NIC_UN_CONFIG_PEER = "ServiceInfraWithdrawNicUnConfigPeer"
    FSM_PREV_SERVICE_INFRA_WITHDRAW_SUCCESS = "ServiceInfraWithdrawSuccess"
    FSM_PREV_SERVICE_INFRA_WITHDRAW_SW_UN_CONFIG_LOCAL = "ServiceInfraWithdrawSwUnConfigLocal"
    FSM_PREV_SERVICE_INFRA_WITHDRAW_SW_UN_CONFIG_PEER = "ServiceInfraWithdrawSwUnConfigPeer"
    FSM_PREV_SOFT_SHUTDOWN_BEGIN = "SoftShutdownBegin"
    FSM_PREV_SOFT_SHUTDOWN_EXECUTE = "SoftShutdownExecute"
    FSM_PREV_SOFT_SHUTDOWN_FAIL = "SoftShutdownFail"
    FSM_PREV_SOFT_SHUTDOWN_SUCCESS = "SoftShutdownSuccess"
    FSM_PREV_SOFTRESET_BEGIN = "SoftresetBegin"
    FSM_PREV_SOFTRESET_CHECK_POWER_AVAILABILITY = "SoftresetCheckPowerAvailability"
    FSM_PREV_SOFTRESET_EXECUTE = "SoftresetExecute"
    FSM_PREV_SOFTRESET_FAIL = "SoftresetFail"
    FSM_PREV_SOFTRESET_POWER_DEPLOY_WAIT = "SoftresetPowerDeployWait"
    FSM_PREV_SOFTRESET_PRE_SANITIZE = "SoftresetPreSanitize"
    FSM_PREV_SOFTRESET_SANITIZE = "SoftresetSanitize"
    FSM_PREV_SOFTRESET_SUCCESS = "SoftresetSuccess"
    FSM_PREV_SW_CONN_UPD_A = "SwConnUpdA"
    FSM_PREV_SW_CONN_UPD_B = "SwConnUpdB"
    FSM_PREV_SW_CONN_UPD_BEGIN = "SwConnUpdBegin"
    FSM_PREV_SW_CONN_UPD_FAIL = "SwConnUpdFail"
    FSM_PREV_SW_CONN_UPD_SUCCESS = "SwConnUpdSuccess"
    FSM_PREV_TURNUP_BEGIN = "TurnupBegin"
    FSM_PREV_TURNUP_CHECK_POWER_AVAILABILITY = "TurnupCheckPowerAvailability"
    FSM_PREV_TURNUP_EXECUTE = "TurnupExecute"
    FSM_PREV_TURNUP_FAIL = "TurnupFail"
    FSM_PREV_TURNUP_POWER_DEPLOY_WAIT = "TurnupPowerDeployWait"
    FSM_PREV_TURNUP_SUCCESS = "TurnupSuccess"
    FSM_PREV_UNCONFIG_SO_LBEGIN = "UnconfigSoLBegin"
    FSM_PREV_UNCONFIG_SO_LEXECUTE = "UnconfigSoLExecute"
    FSM_PREV_UNCONFIG_SO_LFAIL = "UnconfigSoLFail"
    FSM_PREV_UNCONFIG_SO_LSUCCESS = "UnconfigSoLSuccess"
    FSM_PREV_UPDATE_ADAPTOR_BEGIN = "UpdateAdaptorBegin"
    FSM_PREV_UPDATE_ADAPTOR_CHECK_POWER_AVAILABILITY = "UpdateAdaptorCheckPowerAvailability"
    FSM_PREV_UPDATE_ADAPTOR_FAIL = "UpdateAdaptorFail"
    FSM_PREV_UPDATE_ADAPTOR_POLL_UPDATE_STATUS_LOCAL = "UpdateAdaptorPollUpdateStatusLocal"
    FSM_PREV_UPDATE_ADAPTOR_POLL_UPDATE_STATUS_PEER = "UpdateAdaptorPollUpdateStatusPeer"
    FSM_PREV_UPDATE_ADAPTOR_POWER_DEPLOY_WAIT = "UpdateAdaptorPowerDeployWait"
    FSM_PREV_UPDATE_ADAPTOR_POWER_OFF = "UpdateAdaptorPowerOff"
    FSM_PREV_UPDATE_ADAPTOR_POWER_ON = "UpdateAdaptorPowerOn"
    FSM_PREV_UPDATE_ADAPTOR_SUCCESS = "UpdateAdaptorSuccess"
    FSM_PREV_UPDATE_ADAPTOR_UPDATE_REQUEST_LOCAL = "UpdateAdaptorUpdateRequestLocal"
    FSM_PREV_UPDATE_ADAPTOR_UPDATE_REQUEST_PEER = "UpdateAdaptorUpdateRequestPeer"
    FSM_PREV_UPDATE_BIOSBEGIN = "UpdateBIOSBegin"
    FSM_PREV_UPDATE_BIOSCLEAR = "UpdateBIOSClear"
    FSM_PREV_UPDATE_BIOSFAIL = "UpdateBIOSFail"
    FSM_PREV_UPDATE_BIOSPOLL_CLEAR_STATUS = "UpdateBIOSPollClearStatus"
    FSM_PREV_UPDATE_BIOSPOLL_UPDATE_STATUS = "UpdateBIOSPollUpdateStatus"
    FSM_PREV_UPDATE_BIOSSUCCESS = "UpdateBIOSSuccess"
    FSM_PREV_UPDATE_BIOSUPDATE_REQUEST = "UpdateBIOSUpdateRequest"
    FSM_PREV_UPDATE_BOARD_CONTROLLER_BEGIN = "UpdateBoardControllerBegin"
    FSM_PREV_UPDATE_BOARD_CONTROLLER_CHECK_POWER_AVAILABILITY = "UpdateBoardControllerCheckPowerAvailability"
    FSM_PREV_UPDATE_BOARD_CONTROLLER_FAIL = "UpdateBoardControllerFail"
    FSM_PREV_UPDATE_BOARD_CONTROLLER_POLL_BOARD_CTRL_POWER_CYCLE = "UpdateBoardControllerPollBoardCtrlPowerCycle"
    FSM_PREV_UPDATE_BOARD_CONTROLLER_POLL_UPDATE_STATUS = "UpdateBoardControllerPollUpdateStatus"
    FSM_PREV_UPDATE_BOARD_CONTROLLER_POWER_CYCLE_BOARD = "UpdateBoardControllerPowerCycleBoard"
    FSM_PREV_UPDATE_BOARD_CONTROLLER_POWER_DEPLOY_WAIT = "UpdateBoardControllerPowerDeployWait"
    FSM_PREV_UPDATE_BOARD_CONTROLLER_PREPARE_FOR_UPDATE = "UpdateBoardControllerPrepareForUpdate"
    FSM_PREV_UPDATE_BOARD_CONTROLLER_SERVER_POWER_OFF = "UpdateBoardControllerServerPowerOff"
    FSM_PREV_UPDATE_BOARD_CONTROLLER_SERVER_POWER_ON = "UpdateBoardControllerServerPowerOn"
    FSM_PREV_UPDATE_BOARD_CONTROLLER_SUCCESS = "UpdateBoardControllerSuccess"
    FSM_PREV_UPDATE_BOARD_CONTROLLER_UPDATE_REQUEST = "UpdateBoardControllerUpdateRequest"
    FSM_PREV_CLEAR_TPMBEGIN = "clearTPMBegin"
    FSM_PREV_CLEAR_TPMBIOS_POST_COMPLETION = "clearTPMBiosPostCompletion"
    FSM_PREV_CLEAR_TPMBLADE_POWER_OFF = "clearTPMBladePowerOff"
    FSM_PREV_CLEAR_TPMBLADE_POWER_ON = "clearTPMBladePowerOn"
    FSM_PREV_CLEAR_TPMBOOT_HOST = "clearTPMBootHost"
    FSM_PREV_CLEAR_TPMCLEAR = "clearTPMClear"
    FSM_PREV_CLEAR_TPMFAIL = "clearTPMFail"
    FSM_PREV_CLEAR_TPMPRE_SANITIZE = "clearTPMPreSanitize"
    FSM_PREV_CLEAR_TPMREAD_SM_BIOS = "clearTPMReadSmBios"
    FSM_PREV_CLEAR_TPMRECONFIG_BIOS = "clearTPMReconfigBios"
    FSM_PREV_CLEAR_TPMSANITIZE = "clearTPMSanitize"
    FSM_PREV_CLEAR_TPMSETUP_VMEDIA = "clearTPMSetupVmedia"
    FSM_PREV_CLEAR_TPMSTOP_VMEDIA_LOCAL = "clearTPMStopVMediaLocal"
    FSM_PREV_CLEAR_TPMSTOP_VMEDIA_PEER = "clearTPMStopVMediaPeer"
    FSM_PREV_CLEAR_TPMSUCCESS = "clearTPMSuccess"
    FSM_PREV_CLEAR_TPMUNCONFIG_VMEDIA = "clearTPMUnconfigVmedia"
    FSM_PREV_NOP = "nop"
    FSM_PREV_UPDATE_EXT_USERS_BEGIN = "updateExtUsersBegin"
    FSM_PREV_UPDATE_EXT_USERS_DEPLOY = "updateExtUsersDeploy"
    FSM_PREV_UPDATE_EXT_USERS_FAIL = "updateExtUsersFail"
    FSM_PREV_UPDATE_EXT_USERS_SUCCESS = "updateExtUsersSuccess"
    FSM_RMT_INV_ERR_CODE_ERR_2FA_AUTH_RETRY = "ERR-2fa-auth-retry"
    FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_FAILED = "ERR-ACTIVATE-failed"
    FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_IN_PROGRESS = "ERR-ACTIVATE-in-progress"
    FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_RETRY = "ERR-ACTIVATE-retry"
    FSM_RMT_INV_ERR_CODE_ERR_BIOS_TOKENS_OLD_BIOS = "ERR-BIOS-TOKENS-OLD-BIOS"
    FSM_RMT_INV_ERR_CODE_ERR_BIOS_TOKENS_OLD_CIMC = "ERR-BIOS-TOKENS-OLD-CIMC"
    FSM_RMT_INV_ERR_CODE_ERR_BIOS_NETWORK_BOOT_ORDER_NOT_FOUND = "ERR-BIOS-network-boot-order-not-found"
    FSM_RMT_INV_ERR_CODE_ERR_BOARDCTRLUPDATE_IGNORE = "ERR-BOARDCTRLUPDATE-ignore"
    FSM_RMT_INV_ERR_CODE_ERR_DIAG_CANCELLED = "ERR-DIAG-cancelled"
    FSM_RMT_INV_ERR_CODE_ERR_DIAG_FSM_RESTARTED = "ERR-DIAG-fsm-restarted"
    FSM_RMT_INV_ERR_CODE_ERR_DIAG_TEST_FAILED = "ERR-DIAG-test-failed"
    FSM_RMT_INV_ERR_CODE_ERR_DNLD_AUTHENTICATION_FAILURE = "ERR-DNLD-authentication-failure"
    FSM_RMT_INV_ERR_CODE_ERR_DNLD_HOSTKEY_MISMATCH = "ERR-DNLD-hostkey-mismatch"
    FSM_RMT_INV_ERR_CODE_ERR_DNLD_INVALID_IMAGE = "ERR-DNLD-invalid-image"
    FSM_RMT_INV_ERR_CODE_ERR_DNLD_NO_FILE = "ERR-DNLD-no-file"
    FSM_RMT_INV_ERR_CODE_ERR_DNLD_NO_SPACE = "ERR-DNLD-no-space"
    FSM_RMT_INV_ERR_CODE_ERR_DNLD_USB_UNMOUNTED = "ERR-DNLD-usb-unmounted"
    FSM_RMT_INV_ERR_CODE_ERR_DNS_DELETE_ERROR = "ERR-DNS-delete-error"
    FSM_RMT_INV_ERR_CODE_ERR_DNS_GET_ERROR = "ERR-DNS-get-error"
    FSM_RMT_INV_ERR_CODE_ERR_DNS_SET_ERROR = "ERR-DNS-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_IN_PROGRESS = "ERR-Diagnostics-in-progress"
    FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_MEMTEST_IN_PROGRESS = "ERR-Diagnostics-memtest-in-progress"
    FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_NETWORK_IN_PROGRESS = "ERR-Diagnostics-network-in-progress"
    FSM_RMT_INV_ERR_CODE_ERR_FILTER_ILLEGAL_FORMAT = "ERR-FILTER-illegal-format"
    FSM_RMT_INV_ERR_CODE_ERR_FSM_NO_SUCH_STATE = "ERR-FSM-no-such-state"
    FSM_RMT_INV_ERR_CODE_ERR_HOST_FRU_IDENTITY_MISMATCH = "ERR-HOST-fru-identity-mismatch"
    FSM_RMT_INV_ERR_CODE_ERR_HTTP_SET_ERROR = "ERR-HTTP-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_HTTPS_SET_ERROR = "ERR-HTTPS-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_IBMC_ANALYZE_RESULTS = "ERR-IBMC-analyze-results"
    FSM_RMT_INV_ERR_CODE_ERR_IBMC_CONNECT_ERROR = "ERR-IBMC-connect-error"
    FSM_RMT_INV_ERR_CODE_ERR_IBMC_CONNECTOR_INFO_RETRIEVAL_ERROR = "ERR-IBMC-connector-info-retrieval-error"
    FSM_RMT_INV_ERR_CODE_ERR_IBMC_FRU_RETRIEVAL_ERROR = "ERR-IBMC-fru-retrieval-error"
    FSM_RMT_INV_ERR_CODE_ERR_IBMC_INVALID_END_POINT_CONFIG = "ERR-IBMC-invalid-end-point-config"
    FSM_RMT_INV_ERR_CODE_ERR_IBMC_RESULTS_NOT_READY = "ERR-IBMC-results-not-ready"
    FSM_RMT_INV_ERR_CODE_ERR_MAX_SUBSCRIPTIONS_ALLOWED_ERROR = "ERR-MAX-subscriptions-allowed-error"
    FSM_RMT_INV_ERR_CODE_ERR_MO_CONFIG_CHILD_OBJECT_CANT_BE_CONFIGURED = "ERR-MO-CONFIG-child-object-cant-be-configured"
    FSM_RMT_INV_ERR_CODE_ERR_MO_META_NO_SUCH_OBJECT_CLASS = "ERR-MO-META-no-such-object-class"
    FSM_RMT_INV_ERR_CODE_ERR_MO_PROPERTY_NO_SUCH_PROPERTY = "ERR-MO-PROPERTY-no-such-property"
    FSM_RMT_INV_ERR_CODE_ERR_MO_PROPERTY_VALUE_OUT_OF_RANGE = "ERR-MO-PROPERTY-value-out-of-range"
    FSM_RMT_INV_ERR_CODE_ERR_MO_ACCESS_DENIED = "ERR-MO-access-denied"
    FSM_RMT_INV_ERR_CODE_ERR_MO_DELETION_RULE_VIOLATION = "ERR-MO-deletion-rule-violation"
    FSM_RMT_INV_ERR_CODE_ERR_MO_DUPLICATE_OBJECT = "ERR-MO-duplicate-object"
    FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_CONTAINMENT = "ERR-MO-illegal-containment"
    FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_CREATION = "ERR-MO-illegal-creation"
    FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_ITERATOR_STATE = "ERR-MO-illegal-iterator-state"
    FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_OBJECT_LIFECYCLE_TRANSITION = "ERR-MO-illegal-object-lifecycle-transition"
    FSM_RMT_INV_ERR_CODE_ERR_MO_NAMING_RULE_VIOLATION = "ERR-MO-naming-rule-violation"
    FSM_RMT_INV_ERR_CODE_ERR_MO_OBJECT_NOT_FOUND = "ERR-MO-object-not-found"
    FSM_RMT_INV_ERR_CODE_ERR_MO_RESOURCE_ALLOCATION = "ERR-MO-resource-allocation"
    FSM_RMT_INV_ERR_CODE_ERR_NTP_DELETE_ERROR = "ERR-NTP-delete-error"
    FSM_RMT_INV_ERR_CODE_ERR_NTP_GET_ERROR = "ERR-NTP-get-error"
    FSM_RMT_INV_ERR_CODE_ERR_NTP_SET_ERROR = "ERR-NTP-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_POWER_CAP_UNSUPPORTED = "ERR-POWER-CAP-UNSUPPORTED"
    FSM_RMT_INV_ERR_CODE_ERR_POWER_PROFILE_IN_PROGRESS = "ERR-POWER-PROFILE-IN-PROGRESS"
    FSM_RMT_INV_ERR_CODE_ERR_SERVER_MIS_CONNECT = "ERR-SERVER-mis-connect"
    FSM_RMT_INV_ERR_CODE_ERR_SWITCH_INVALID_IF_CONFIG = "ERR-SWITCH-invalid-if-config"
    FSM_RMT_INV_ERR_CODE_ERR_TOKEN_REQUEST_DENIED = "ERR-TOKEN-request-denied"
    FSM_RMT_INV_ERR_CODE_ERR_UNABLE_TO_FETCH_BIOS_SETTINGS = "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS"
    FSM_RMT_INV_ERR_CODE_ERR_UPDATE_FAILED = "ERR-UPDATE-failed"
    FSM_RMT_INV_ERR_CODE_ERR_UPDATE_IN_PROGRESS = "ERR-UPDATE-in-progress"
    FSM_RMT_INV_ERR_CODE_ERR_UPDATE_RETRY = "ERR-UPDATE-retry"
    FSM_RMT_INV_ERR_CODE_ERR_AAA_CONFIG_MODIFY_ERROR = "ERR-aaa-config-modify-error"
    FSM_RMT_INV_ERR_CODE_ERR_ACCT_REALM_SET_ERROR = "ERR-acct-realm-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_ADMIN_PASSWD_SET = "ERR-admin-passwd-set"
    FSM_RMT_INV_ERR_CODE_ERR_AUTH_ISSUE = "ERR-auth-issue"
    FSM_RMT_INV_ERR_CODE_ERR_AUTH_REALM_GET_ERROR = "ERR-auth-realm-get-error"
    FSM_RMT_INV_ERR_CODE_ERR_AUTH_REALM_SET_ERROR = "ERR-auth-realm-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_AUTHENTICATION = "ERR-authentication"
    FSM_RMT_INV_ERR_CODE_ERR_AUTHORIZATION_REQUIRED = "ERR-authorization-required"
    FSM_RMT_INV_ERR_CODE_ERR_CLI_SESSION_LIMIT_REACHED = "ERR-cli-session-limit-reached"
    FSM_RMT_INV_ERR_CODE_ERR_CREATE_KEYRING = "ERR-create-keyring"
    FSM_RMT_INV_ERR_CODE_ERR_CREATE_LOCALE = "ERR-create-locale"
    FSM_RMT_INV_ERR_CODE_ERR_CREATE_ROLE = "ERR-create-role"
    FSM_RMT_INV_ERR_CODE_ERR_CREATE_TP = "ERR-create-tp"
    FSM_RMT_INV_ERR_CODE_ERR_CREATE_USER = "ERR-create-user"
    FSM_RMT_INV_ERR_CODE_ERR_DELETE_LOCALE = "ERR-delete-locale"
    FSM_RMT_INV_ERR_CODE_ERR_DELETE_ROLE = "ERR-delete-role"
    FSM_RMT_INV_ERR_CODE_ERR_DELETE_SESSION = "ERR-delete-session"
    FSM_RMT_INV_ERR_CODE_ERR_DELETE_USER = "ERR-delete-user"
    FSM_RMT_INV_ERR_CODE_ERR_DOWNGRADE_FAIL = "ERR-downgrade-fail"
    FSM_RMT_INV_ERR_CODE_ERR_EFI_DIAGNOSTICS_IN_PROGRESS = "ERR-efi-Diagnostics--in-progress"
    FSM_RMT_INV_ERR_CODE_ERR_ENABLE_MGMT_CONN = "ERR-enable-mgmt-conn"
    FSM_RMT_INV_ERR_CODE_ERR_EP_SET_ERROR = "ERR-ep-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_GET_MAX_HTTP_USER_SESSIONS = "ERR-get-max-http-user-sessions"
    FSM_RMT_INV_ERR_CODE_ERR_HTTP_INITIALIZING = "ERR-http-initializing"
    FSM_RMT_INV_ERR_CODE_ERR_INSUFFICIENTLY_EQUIPPED = "ERR-insufficiently-equipped"
    FSM_RMT_INV_ERR_CODE_ERR_INTERNAL_ERROR = "ERR-internal-error"
    FSM_RMT_INV_ERR_CODE_ERR_LDAP_DELETE_ERROR = "ERR-ldap-delete-error"
    FSM_RMT_INV_ERR_CODE_ERR_LDAP_GET_ERROR = "ERR-ldap-get-error"
    FSM_RMT_INV_ERR_CODE_ERR_LDAP_GROUP_MODIFY_ERROR = "ERR-ldap-group-modify-error"
    FSM_RMT_INV_ERR_CODE_ERR_LDAP_GROUP_SET_ERROR = "ERR-ldap-group-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_LDAP_SET_ERROR = "ERR-ldap-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_LOCALE_SET_ERROR = "ERR-locale-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_MAX_USERID_SESSIONS_REACHED = "ERR-max-userid-sessions-reached"
    FSM_RMT_INV_ERR_CODE_ERR_MISSING_METHOD = "ERR-missing-method"
    FSM_RMT_INV_ERR_CODE_ERR_MODIFY_LOCALE = "ERR-modify-locale"
    FSM_RMT_INV_ERR_CODE_ERR_MODIFY_ROLE = "ERR-modify-role"
    FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER = "ERR-modify-user"
    FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER_LOCALE = "ERR-modify-user-locale"
    FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER_ROLE = "ERR-modify-user-role"
    FSM_RMT_INV_ERR_CODE_ERR_PROVIDER_GROUP_MODIFY_ERROR = "ERR-provider-group-modify-error"
    FSM_RMT_INV_ERR_CODE_ERR_PROVIDER_GROUP_SET_ERROR = "ERR-provider-group-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GET_ERROR = "ERR-radius-get-error"
    FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GLOBAL_SET_ERROR = "ERR-radius-global-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GROUP_SET_ERROR = "ERR-radius-group-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_RADIUS_SET_ERROR = "ERR-radius-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_REQUEST_TIMEOUT = "ERR-request-timeout"
    FSM_RMT_INV_ERR_CODE_ERR_RESET_ADAPTER = "ERR-reset-adapter"
    FSM_RMT_INV_ERR_CODE_ERR_ROLE_SET_ERROR = "ERR-role-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_SECONDARY_NODE = "ERR-secondary-node"
    FSM_RMT_INV_ERR_CODE_ERR_SERVICE_NOT_READY = "ERR-service-not-ready"
    FSM_RMT_INV_ERR_CODE_ERR_SESSION_CACHE_FULL = "ERR-session-cache-full"
    FSM_RMT_INV_ERR_CODE_ERR_SESSION_NOT_FOUND = "ERR-session-not-found"
    FSM_RMT_INV_ERR_CODE_ERR_SET_MIN_PASSPHRASE_LENGTH = "ERR-set-min-passphrase-length"
    FSM_RMT_INV_ERR_CODE_ERR_SET_NETWORK = "ERR-set-network"
    FSM_RMT_INV_ERR_CODE_ERR_SET_PASSWORD_STRENGTH_CHECK = "ERR-set-password-strength-check"
    FSM_RMT_INV_ERR_CODE_ERR_SET_PORT_CHANNEL = "ERR-set-port-channel"
    FSM_RMT_INV_ERR_CODE_ERR_STORE_PRE_LOGIN_BANNER_MSG = "ERR-store-pre-login-banner-msg"
    FSM_RMT_INV_ERR_CODE_ERR_TACACS_ENABLE_ERROR = "ERR-tacacs-enable-error"
    FSM_RMT_INV_ERR_CODE_ERR_TACACS_GLOBAL_SET_ERROR = "ERR-tacacs-global-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_TACACS_GROUP_SET_ERROR = "ERR-tacacs-group-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_TACACS_PLUS_GET_ERROR = "ERR-tacacs-plus-get-error"
    FSM_RMT_INV_ERR_CODE_ERR_TACACS_SET_ERROR = "ERR-tacacs-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_TEST_ERROR_1 = "ERR-test-error-1"
    FSM_RMT_INV_ERR_CODE_ERR_TEST_ERROR_2 = "ERR-test-error-2"
    FSM_RMT_INV_ERR_CODE_ERR_TIMEZONE_SET_ERROR = "ERR-timezone-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_USER_ACCOUNT_EXPIRED = "ERR-user-account-expired"
    FSM_RMT_INV_ERR_CODE_ERR_USER_SET_ERROR = "ERR-user-set-error"
    FSM_RMT_INV_ERR_CODE_ERR_XML_PARSE_ERROR = "ERR-xml-parse-error"
    FSM_RMT_INV_ERR_CODE_NONE = "none"
    FSM_STAMP_NEVER = "never"
    FSM_STATUS_ACTIVATE_ADAPTOR_ACTIVATE_LOCAL = "ActivateAdaptorActivateLocal"
    FSM_STATUS_ACTIVATE_ADAPTOR_ACTIVATE_PEER = "ActivateAdaptorActivatePeer"
    FSM_STATUS_ACTIVATE_ADAPTOR_BEGIN = "ActivateAdaptorBegin"
    FSM_STATUS_ACTIVATE_ADAPTOR_CHECK_POWER_AVAILABILITY = "ActivateAdaptorCheckPowerAvailability"
    FSM_STATUS_ACTIVATE_ADAPTOR_DEASSERT_RESET_BYPASS = "ActivateAdaptorDeassertResetBypass"
    FSM_STATUS_ACTIVATE_ADAPTOR_FAIL = "ActivateAdaptorFail"
    FSM_STATUS_ACTIVATE_ADAPTOR_POWER_DEPLOY_WAIT = "ActivateAdaptorPowerDeployWait"
    FSM_STATUS_ACTIVATE_ADAPTOR_POWER_ON = "ActivateAdaptorPowerOn"
    FSM_STATUS_ACTIVATE_ADAPTOR_RESET = "ActivateAdaptorReset"
    FSM_STATUS_ACTIVATE_ADAPTOR_SUCCESS = "ActivateAdaptorSuccess"
    FSM_STATUS_ACTIVATE_BIOSACTIVATE = "ActivateBIOSActivate"
    FSM_STATUS_ACTIVATE_BIOSBEGIN = "ActivateBIOSBegin"
    FSM_STATUS_ACTIVATE_BIOSCHECK_POWER_AVAILABILITY = "ActivateBIOSCheckPowerAvailability"
    FSM_STATUS_ACTIVATE_BIOSCLEAR = "ActivateBIOSClear"
    FSM_STATUS_ACTIVATE_BIOSFAIL = "ActivateBIOSFail"
    FSM_STATUS_ACTIVATE_BIOSPOLL_ACTIVATE_STATUS = "ActivateBIOSPollActivateStatus"
    FSM_STATUS_ACTIVATE_BIOSPOLL_CLEAR_STATUS = "ActivateBIOSPollClearStatus"
    FSM_STATUS_ACTIVATE_BIOSPOWER_DEPLOY_WAIT = "ActivateBIOSPowerDeployWait"
    FSM_STATUS_ACTIVATE_BIOSPOWER_OFF = "ActivateBIOSPowerOff"
    FSM_STATUS_ACTIVATE_BIOSPOWER_ON = "ActivateBIOSPowerOn"
    FSM_STATUS_ACTIVATE_BIOSSUCCESS = "ActivateBIOSSuccess"
    FSM_STATUS_ACTIVATE_BIOSUPDATE_TOKENS = "ActivateBIOSUpdateTokens"
    FSM_STATUS_ADAPTER_RESET_BEGIN = "AdapterResetBegin"
    FSM_STATUS_ADAPTER_RESET_DEASSERT_RESET_BYPASS = "AdapterResetDeassertResetBypass"
    FSM_STATUS_ADAPTER_RESET_FAIL = "AdapterResetFail"
    FSM_STATUS_ADAPTER_RESET_POWER_CYCLE = "AdapterResetPowerCycle"
    FSM_STATUS_ADAPTER_RESET_PRE_SANITIZE = "AdapterResetPreSanitize"
    FSM_STATUS_ADAPTER_RESET_SANITIZE = "AdapterResetSanitize"
    FSM_STATUS_ADAPTER_RESET_SUCCESS = "AdapterResetSuccess"
    FSM_STATUS_ASSOCIATE_ACTIVATE_ADAPTOR_NW_FW_LOCAL = "AssociateActivateAdaptorNwFwLocal"
    FSM_STATUS_ASSOCIATE_ACTIVATE_ADAPTOR_NW_FW_PEER = "AssociateActivateAdaptorNwFwPeer"
    FSM_STATUS_ASSOCIATE_ACTIVATE_BIOS = "AssociateActivateBios"
    FSM_STATUS_ASSOCIATE_ACTIVATE_IBMCFW = "AssociateActivateIBMCFw"
    FSM_STATUS_ASSOCIATE_BEGIN = "AssociateBegin"
    FSM_STATUS_ASSOCIATE_BIOS_IMG_UPDATE = "AssociateBiosImgUpdate"
    FSM_STATUS_ASSOCIATE_BIOS_POST_COMPLETION = "AssociateBiosPostCompletion"
    FSM_STATUS_ASSOCIATE_BLADE_POWER_OFF = "AssociateBladePowerOff"
    FSM_STATUS_ASSOCIATE_BMC_CONFIG_PNU_OS = "AssociateBmcConfigPnuOS"
    FSM_STATUS_ASSOCIATE_BMC_PRECONFIG_PNU_OSLOCAL = "AssociateBmcPreconfigPnuOSLocal"
    FSM_STATUS_ASSOCIATE_BMC_PRECONFIG_PNU_OSPEER = "AssociateBmcPreconfigPnuOSPeer"
    FSM_STATUS_ASSOCIATE_BMC_UNCONFIG_PNU_OS = "AssociateBmcUnconfigPnuOS"
    FSM_STATUS_ASSOCIATE_BOOT_HOST = "AssociateBootHost"
    FSM_STATUS_ASSOCIATE_BOOT_PNUOS = "AssociateBootPnuos"
    FSM_STATUS_ASSOCIATE_BOOT_WAIT = "AssociateBootWait"
    FSM_STATUS_ASSOCIATE_CALCULATE_VLAN_GROUP_FOR_HOST_OSLOCAL = "AssociateCalculateVlanGroupForHostOSLocal"
    FSM_STATUS_ASSOCIATE_CALCULATE_VLAN_GROUP_FOR_HOST_OSPEER = "AssociateCalculateVlanGroupForHostOSPeer"
    FSM_STATUS_ASSOCIATE_CHECK_POWER_AVAILABILITY = "AssociateCheckPowerAvailability"
    FSM_STATUS_ASSOCIATE_CISCO_OSOPEN_GATE = "AssociateCiscoOSOpenGate"
    FSM_STATUS_ASSOCIATE_CLEAR_BIOS_UPDATE = "AssociateClearBiosUpdate"
    FSM_STATUS_ASSOCIATE_CONFIG_CIMC_VMEDIA = "AssociateConfigCimcVMedia"
    FSM_STATUS_ASSOCIATE_CONFIG_EXT_MGMT_GW = "AssociateConfigExtMgmtGw"
    FSM_STATUS_ASSOCIATE_CONFIG_EXT_MGMT_RULES = "AssociateConfigExtMgmtRules"
    FSM_STATUS_ASSOCIATE_CONFIG_FAN_SPEED = "AssociateConfigFanSpeed"
    FSM_STATUS_ASSOCIATE_CONFIG_FLEX_FLASH = "AssociateConfigFlexFlash"
    FSM_STATUS_ASSOCIATE_CONFIG_SO_L = "AssociateConfigSoL"
    FSM_STATUS_ASSOCIATE_CONFIG_USER_ACCESS = "AssociateConfigUserAccess"
    FSM_STATUS_ASSOCIATE_CONFIG_UUID = "AssociateConfigUuid"
    FSM_STATUS_ASSOCIATE_COPY_REMOTE = "AssociateCopyRemote"
    FSM_STATUS_ASSOCIATE_DEASSERT_RESET_BYPASS = "AssociateDeassertResetBypass"
    FSM_STATUS_ASSOCIATE_DELETE_CURL_DOWNLOADED_IMAGES = "AssociateDeleteCurlDownloadedImages"
    FSM_STATUS_ASSOCIATE_DELETE_IMAGES_REMOTE = "AssociateDeleteImagesRemote"
    FSM_STATUS_ASSOCIATE_DOWNLOAD_IMAGES = "AssociateDownloadImages"
    FSM_STATUS_ASSOCIATE_FAIL = "AssociateFail"
    FSM_STATUS_ASSOCIATE_GRAPHICS_IMAGE_UPDATE = "AssociateGraphicsImageUpdate"
    FSM_STATUS_ASSOCIATE_HAG_HOST_OSCONNECT = "AssociateHagHostOSConnect"
    FSM_STATUS_ASSOCIATE_HAG_PNU_OSCONNECT = "AssociateHagPnuOSConnect"
    FSM_STATUS_ASSOCIATE_HAG_PNU_OSDISCONNECT = "AssociateHagPnuOSDisconnect"
    FSM_STATUS_ASSOCIATE_HBA_IMG_UPDATE = "AssociateHbaImgUpdate"
    FSM_STATUS_ASSOCIATE_HOST_OSCONFIG = "AssociateHostOSConfig"
    FSM_STATUS_ASSOCIATE_HOST_OSIDENT = "AssociateHostOSIdent"
    FSM_STATUS_ASSOCIATE_HOST_OSPOLICY = "AssociateHostOSPolicy"
    FSM_STATUS_ASSOCIATE_HOST_OSVALIDATE = "AssociateHostOSValidate"
    FSM_STATUS_ASSOCIATE_LOCAL_DISK_FW_UPDATE = "AssociateLocalDiskFwUpdate"
    FSM_STATUS_ASSOCIATE_MARK_ADAPTER_FOR_REBOOT = "AssociateMarkAdapterForReboot"
    FSM_STATUS_ASSOCIATE_NIC_CONFIG_HOST_OSLOCAL = "AssociateNicConfigHostOSLocal"
    FSM_STATUS_ASSOCIATE_NIC_CONFIG_HOST_OSPEER = "AssociateNicConfigHostOSPeer"
    FSM_STATUS_ASSOCIATE_NIC_CONFIG_PARAMS_HOST_OSLOCAL = "AssociateNicConfigParamsHostOSLocal"
    FSM_STATUS_ASSOCIATE_NIC_CONFIG_PARAMS_HOST_OSPEER = "AssociateNicConfigParamsHostOSPeer"
    FSM_STATUS_ASSOCIATE_NIC_CONFIG_PNU_OSLOCAL = "AssociateNicConfigPnuOSLocal"
    FSM_STATUS_ASSOCIATE_NIC_CONFIG_PNU_OSPEER = "AssociateNicConfigPnuOSPeer"
    FSM_STATUS_ASSOCIATE_NIC_CONFIG_SERVICE_INFRA_LOCAL = "AssociateNicConfigServiceInfraLocal"
    FSM_STATUS_ASSOCIATE_NIC_CONFIG_SERVICE_INFRA_PEER = "AssociateNicConfigServiceInfraPeer"
    FSM_STATUS_ASSOCIATE_NIC_IMG_UPDATE = "AssociateNicImgUpdate"
    FSM_STATUS_ASSOCIATE_NIC_UNCONFIG_PNU_OSLOCAL = "AssociateNicUnconfigPnuOSLocal"
    FSM_STATUS_ASSOCIATE_NIC_UNCONFIG_PNU_OSPEER = "AssociateNicUnconfigPnuOSPeer"
    FSM_STATUS_ASSOCIATE_OOB_POLL_SAS_EXPANDER_ACTIVATE_STATUS = "AssociateOobPollSasExpanderActivateStatus"
    FSM_STATUS_ASSOCIATE_OOB_POLL_SAS_EXPANDER_UPDATE_STATUS = "AssociateOobPollSasExpanderUpdateStatus"
    FSM_STATUS_ASSOCIATE_OOB_SAS_EXPANDER_IMG_ACTIVATE = "AssociateOobSasExpanderImgActivate"
    FSM_STATUS_ASSOCIATE_OOB_SAS_EXPANDER_IMG_UPDATE = "AssociateOobSasExpanderImgUpdate"
    FSM_STATUS_ASSOCIATE_OOB_STORAGE_CONFIG = "AssociateOobStorageConfig"
    FSM_STATUS_ASSOCIATE_OOB_STORAGE_INVENTORY = "AssociateOobStorageInventory"
    FSM_STATUS_ASSOCIATE_PNU_OSCATALOG = "AssociatePnuOSCatalog"
    FSM_STATUS_ASSOCIATE_PNU_OSCONFIG = "AssociatePnuOSConfig"
    FSM_STATUS_ASSOCIATE_PNU_OSIDENT = "AssociatePnuOSIdent"
    FSM_STATUS_ASSOCIATE_PNU_OSINVENTORY = "AssociatePnuOSInventory"
    FSM_STATUS_ASSOCIATE_PNU_OSLOCAL_DISK_CONFIG = "AssociatePnuOSLocalDiskConfig"
    FSM_STATUS_ASSOCIATE_PNU_OSPOLICY = "AssociatePnuOSPolicy"
    FSM_STATUS_ASSOCIATE_PNU_OSSELF_TEST = "AssociatePnuOSSelfTest"
    FSM_STATUS_ASSOCIATE_PNU_OSUNLOAD_DRIVERS = "AssociatePnuOSUnloadDrivers"
    FSM_STATUS_ASSOCIATE_PNU_OSVALIDATE = "AssociatePnuOSValidate"
    FSM_STATUS_ASSOCIATE_POLL_BIOS_ACTIVATE_STATUS = "AssociatePollBiosActivateStatus"
    FSM_STATUS_ASSOCIATE_POLL_BIOS_UPDATE_STATUS = "AssociatePollBiosUpdateStatus"
    FSM_STATUS_ASSOCIATE_POLL_BOARD_CTRL_POWER_CYCLE = "AssociatePollBoardCtrlPowerCycle"
    FSM_STATUS_ASSOCIATE_POLL_BOARD_CTRL_UPDATE_STATUS = "AssociatePollBoardCtrlUpdateStatus"
    FSM_STATUS_ASSOCIATE_POLL_CLEAR_BIOS_UPDATE_STATUS = "AssociatePollClearBiosUpdateStatus"
    FSM_STATUS_ASSOCIATE_POWER_CYCLE_BOARD = "AssociatePowerCycleBoard"
    FSM_STATUS_ASSOCIATE_POWER_DEPLOY_WAIT = "AssociatePowerDeployWait"
    FSM_STATUS_ASSOCIATE_POWER_ON = "AssociatePowerOn"
    FSM_STATUS_ASSOCIATE_POWER_ON_PRE_CONFIG = "AssociatePowerOnPreConfig"
    FSM_STATUS_ASSOCIATE_PRE_SANITIZE = "AssociatePreSanitize"
    FSM_STATUS_ASSOCIATE_PREPARE_FOR_BOOT = "AssociatePrepareForBoot"
    FSM_STATUS_ASSOCIATE_RESET_IBMC = "AssociateResetIBMC"
    FSM_STATUS_ASSOCIATE_SANITIZE = "AssociateSanitize"
    FSM_STATUS_ASSOCIATE_SAS_EXPANDER_IMG_UPDATE = "AssociateSasExpanderImgUpdate"
    FSM_STATUS_ASSOCIATE_SERIAL_DEBUG_PNU_OSCONNECT = "AssociateSerialDebugPnuOSConnect"
    FSM_STATUS_ASSOCIATE_SERIAL_DEBUG_PNU_OSDISCONNECT = "AssociateSerialDebugPnuOSDisconnect"
    FSM_STATUS_ASSOCIATE_SOL_REDIRECT_DISABLE = "AssociateSolRedirectDisable"
    FSM_STATUS_ASSOCIATE_SOL_REDIRECT_ENABLE = "AssociateSolRedirectEnable"
    FSM_STATUS_ASSOCIATE_STORAGE_CTLR_IMG_UPDATE = "AssociateStorageCtlrImgUpdate"
    FSM_STATUS_ASSOCIATE_SUCCESS = "AssociateSuccess"
    FSM_STATUS_ASSOCIATE_SW_CONFIG_HOST_OSLOCAL = "AssociateSwConfigHostOSLocal"
    FSM_STATUS_ASSOCIATE_SW_CONFIG_HOST_OSPEER = "AssociateSwConfigHostOSPeer"
    FSM_STATUS_ASSOCIATE_SW_CONFIG_PNU_OSLOCAL = "AssociateSwConfigPnuOSLocal"
    FSM_STATUS_ASSOCIATE_SW_CONFIG_PNU_OSPEER = "AssociateSwConfigPnuOSPeer"
    FSM_STATUS_ASSOCIATE_SW_CONFIG_PORT_NIV_LOCAL = "AssociateSwConfigPortNivLocal"
    FSM_STATUS_ASSOCIATE_SW_CONFIG_PORT_NIV_PEER = "AssociateSwConfigPortNivPeer"
    FSM_STATUS_ASSOCIATE_SW_CONFIG_SERVICE_INFRA_LOCAL = "AssociateSwConfigServiceInfraLocal"
    FSM_STATUS_ASSOCIATE_SW_CONFIG_SERVICE_INFRA_PEER = "AssociateSwConfigServiceInfraPeer"
    FSM_STATUS_ASSOCIATE_SW_UNCONFIG_PNU_OSLOCAL = "AssociateSwUnconfigPnuOSLocal"
    FSM_STATUS_ASSOCIATE_SW_UNCONFIG_PNU_OSPEER = "AssociateSwUnconfigPnuOSPeer"
    FSM_STATUS_ASSOCIATE_SYNC_POWER_STATE = "AssociateSyncPowerState"
    FSM_STATUS_ASSOCIATE_UNCONFIG_CIMC_VMEDIA = "AssociateUnconfigCimcVMedia"
    FSM_STATUS_ASSOCIATE_UNCONFIG_EXT_MGMT_GW = "AssociateUnconfigExtMgmtGw"
    FSM_STATUS_ASSOCIATE_UNCONFIG_EXT_MGMT_RULES = "AssociateUnconfigExtMgmtRules"
    FSM_STATUS_ASSOCIATE_UNLOCK_FIRMWARE_IMAGE = "AssociateUnlockFirmwareImage"
    FSM_STATUS_ASSOCIATE_UPDATE_ADAPTOR_NW_FW_LOCAL = "AssociateUpdateAdaptorNwFwLocal"
    FSM_STATUS_ASSOCIATE_UPDATE_ADAPTOR_NW_FW_PEER = "AssociateUpdateAdaptorNwFwPeer"
    FSM_STATUS_ASSOCIATE_UPDATE_BIOS_REQUEST = "AssociateUpdateBiosRequest"
    FSM_STATUS_ASSOCIATE_UPDATE_BOARD_CTRL_REQUEST = "AssociateUpdateBoardCtrlRequest"
    FSM_STATUS_ASSOCIATE_UPDATE_IBMCFW = "AssociateUpdateIBMCFw"
    FSM_STATUS_ASSOCIATE_VERIFY_FC_ZONE_CONFIG = "AssociateVerifyFcZoneConfig"
    FSM_STATUS_ASSOCIATE_WAIT_FOR_ADAPTOR_NW_FW_UPDATE_LOCAL = "AssociateWaitForAdaptorNwFwUpdateLocal"
    FSM_STATUS_ASSOCIATE_WAIT_FOR_ADAPTOR_NW_FW_UPDATE_PEER = "AssociateWaitForAdaptorNwFwUpdatePeer"
    FSM_STATUS_ASSOCIATE_WAIT_FOR_IBMCFW_UPDATE = "AssociateWaitForIBMCFwUpdate"
    FSM_STATUS_BIOS_RECOVERY_BEGIN = "BiosRecoveryBegin"
    FSM_STATUS_BIOS_RECOVERY_CHECK_POWER_AVAILABILITY = "BiosRecoveryCheckPowerAvailability"
    FSM_STATUS_BIOS_RECOVERY_CLEANUP = "BiosRecoveryCleanup"
    FSM_STATUS_BIOS_RECOVERY_FAIL = "BiosRecoveryFail"
    FSM_STATUS_BIOS_RECOVERY_POWER_DEPLOY_WAIT = "BiosRecoveryPowerDeployWait"
    FSM_STATUS_BIOS_RECOVERY_PRE_SANITIZE = "BiosRecoveryPreSanitize"
    FSM_STATUS_BIOS_RECOVERY_RESET = "BiosRecoveryReset"
    FSM_STATUS_BIOS_RECOVERY_SANITIZE = "BiosRecoverySanitize"
    FSM_STATUS_BIOS_RECOVERY_SETUP_VMEDIA_LOCAL = "BiosRecoverySetupVmediaLocal"
    FSM_STATUS_BIOS_RECOVERY_SETUP_VMEDIA_PEER = "BiosRecoverySetupVmediaPeer"
    FSM_STATUS_BIOS_RECOVERY_SHUTDOWN = "BiosRecoveryShutdown"
    FSM_STATUS_BIOS_RECOVERY_START = "BiosRecoveryStart"
    FSM_STATUS_BIOS_RECOVERY_STOP_VMEDIA_LOCAL = "BiosRecoveryStopVMediaLocal"
    FSM_STATUS_BIOS_RECOVERY_STOP_VMEDIA_PEER = "BiosRecoveryStopVMediaPeer"
    FSM_STATUS_BIOS_RECOVERY_SUCCESS = "BiosRecoverySuccess"
    FSM_STATUS_BIOS_RECOVERY_TEARDOWN_VMEDIA_LOCAL = "BiosRecoveryTeardownVmediaLocal"
    FSM_STATUS_BIOS_RECOVERY_TEARDOWN_VMEDIA_PEER = "BiosRecoveryTeardownVmediaPeer"
    FSM_STATUS_BIOS_RECOVERY_WAIT = "BiosRecoveryWait"
    FSM_STATUS_CIMC_SESSION_DELETE_BEGIN = "CimcSessionDeleteBegin"
    FSM_STATUS_CIMC_SESSION_DELETE_EXECUTE = "CimcSessionDeleteExecute"
    FSM_STATUS_CIMC_SESSION_DELETE_FAIL = "CimcSessionDeleteFail"
    FSM_STATUS_CIMC_SESSION_DELETE_SUCCESS = "CimcSessionDeleteSuccess"
    FSM_STATUS_CMOS_RESET_BEGIN = "CmosResetBegin"
    FSM_STATUS_CMOS_RESET_BLADE_POWER_ON = "CmosResetBladePowerOn"
    FSM_STATUS_CMOS_RESET_CHECK_POWER_AVAILABILITY = "CmosResetCheckPowerAvailability"
    FSM_STATUS_CMOS_RESET_EXECUTE = "CmosResetExecute"
    FSM_STATUS_CMOS_RESET_FAIL = "CmosResetFail"
    FSM_STATUS_CMOS_RESET_POWER_DEPLOY_WAIT = "CmosResetPowerDeployWait"
    FSM_STATUS_CMOS_RESET_PRE_SANITIZE = "CmosResetPreSanitize"
    FSM_STATUS_CMOS_RESET_RECONFIG_BIOS = "CmosResetReconfigBios"
    FSM_STATUS_CMOS_RESET_RECONFIG_UUID = "CmosResetReconfigUuid"
    FSM_STATUS_CMOS_RESET_SANITIZE = "CmosResetSanitize"
    FSM_STATUS_CMOS_RESET_SUCCESS = "CmosResetSuccess"
    FSM_STATUS_CONFIG_BOARD_BEGIN = "ConfigBoardBegin"
    FSM_STATUS_CONFIG_BOARD_CONFIG_MEMORY_POLICY = "ConfigBoardConfigMemoryPolicy"
    FSM_STATUS_CONFIG_BOARD_FAIL = "ConfigBoardFail"
    FSM_STATUS_CONFIG_BOARD_SUCCESS = "ConfigBoardSuccess"
    FSM_STATUS_CONFIG_SO_LBEGIN = "ConfigSoLBegin"
    FSM_STATUS_CONFIG_SO_LEXECUTE = "ConfigSoLExecute"
    FSM_STATUS_CONFIG_SO_LFAIL = "ConfigSoLFail"
    FSM_STATUS_CONFIG_SO_LSUCCESS = "ConfigSoLSuccess"
    FSM_STATUS_CREATE_DHCP_ENTRY_BEGIN = "CreateDhcpEntryBegin"
    FSM_STATUS_CREATE_DHCP_ENTRY_EXECUTE_LOCAL = "CreateDhcpEntryExecuteLocal"
    FSM_STATUS_CREATE_DHCP_ENTRY_EXECUTE_PEER = "CreateDhcpEntryExecutePeer"
    FSM_STATUS_CREATE_DHCP_ENTRY_FAIL = "CreateDhcpEntryFail"
    FSM_STATUS_CREATE_DHCP_ENTRY_SUCCESS = "CreateDhcpEntrySuccess"
    FSM_STATUS_DECOMMISSION_BEGIN = "DecommissionBegin"
    FSM_STATUS_DECOMMISSION_CLEANUP_CIMC = "DecommissionCleanupCIMC"
    FSM_STATUS_DECOMMISSION_CLEANUP_PORT_CONFIG_LOCAL = "DecommissionCleanupPortConfigLocal"
    FSM_STATUS_DECOMMISSION_CLEANUP_PORT_CONFIG_PEER = "DecommissionCleanupPortConfigPeer"
    FSM_STATUS_DECOMMISSION_EXECUTE = "DecommissionExecute"
    FSM_STATUS_DECOMMISSION_FAIL = "DecommissionFail"
    FSM_STATUS_DECOMMISSION_PRECLEANUP_PORT_CONFIG = "DecommissionPrecleanupPortConfig"
    FSM_STATUS_DECOMMISSION_STOP_VMEDIA_LOCAL = "DecommissionStopVMediaLocal"
    FSM_STATUS_DECOMMISSION_STOP_VMEDIA_PEER = "DecommissionStopVMediaPeer"
    FSM_STATUS_DECOMMISSION_SUCCESS = "DecommissionSuccess"
    FSM_STATUS_DECOMMISSION_UNCONFIG_EXT_MGMT_GW = "DecommissionUnconfigExtMgmtGw"
    FSM_STATUS_DECOMMISSION_UNCONFIG_EXT_MGMT_RULES = "DecommissionUnconfigExtMgmtRules"
    FSM_STATUS_DIAGNOSTIC_INTERRUPT_BEGIN = "DiagnosticInterruptBegin"
    FSM_STATUS_DIAGNOSTIC_INTERRUPT_EXECUTE = "DiagnosticInterruptExecute"
    FSM_STATUS_DIAGNOSTIC_INTERRUPT_FAIL = "DiagnosticInterruptFail"
    FSM_STATUS_DIAGNOSTIC_INTERRUPT_SUCCESS = "DiagnosticInterruptSuccess"
    FSM_STATUS_DISASSOCIATE_BEGIN = "DisassociateBegin"
    FSM_STATUS_DISASSOCIATE_BIOS_POST_COMPLETION = "DisassociateBiosPostCompletion"
    FSM_STATUS_DISASSOCIATE_BMC_CONFIG_PNU_OS = "DisassociateBmcConfigPnuOS"
    FSM_STATUS_DISASSOCIATE_BMC_PRECONFIG_PNU_OSLOCAL = "DisassociateBmcPreconfigPnuOSLocal"
    FSM_STATUS_DISASSOCIATE_BMC_PRECONFIG_PNU_OSPEER = "DisassociateBmcPreconfigPnuOSPeer"
    FSM_STATUS_DISASSOCIATE_BMC_UNCONFIG_PNU_OS = "DisassociateBmcUnconfigPnuOS"
    FSM_STATUS_DISASSOCIATE_BOOT_PNUOS = "DisassociateBootPnuos"
    FSM_STATUS_DISASSOCIATE_BOOT_WAIT = "DisassociateBootWait"
    FSM_STATUS_DISASSOCIATE_CHECK_POWER_AVAILABILITY = "DisassociateCheckPowerAvailability"
    FSM_STATUS_DISASSOCIATE_CONFIG_BIOS = "DisassociateConfigBios"
    FSM_STATUS_DISASSOCIATE_CONFIG_FLEX_FLASH_SCRUB = "DisassociateConfigFlexFlashScrub"
    FSM_STATUS_DISASSOCIATE_CONFIG_KVM_MGMT_DEFAULT_SETTING = "DisassociateConfigKvmMgmtDefaultSetting"
    FSM_STATUS_DISASSOCIATE_CONFIG_USER_ACCESS = "DisassociateConfigUserAccess"
    FSM_STATUS_DISASSOCIATE_DEASSERT_RESET_BYPASS = "DisassociateDeassertResetBypass"
    FSM_STATUS_DISASSOCIATE_FAIL = "DisassociateFail"
    FSM_STATUS_DISASSOCIATE_HAG_PNU_OSCONNECT = "DisassociateHagPnuOSConnect"
    FSM_STATUS_DISASSOCIATE_HAG_PNU_OSDISCONNECT = "DisassociateHagPnuOSDisconnect"
    FSM_STATUS_DISASSOCIATE_HANDLE_POOLING = "DisassociateHandlePooling"
    FSM_STATUS_DISASSOCIATE_NIC_CONFIG_PNU_OSLOCAL = "DisassociateNicConfigPnuOSLocal"
    FSM_STATUS_DISASSOCIATE_NIC_CONFIG_PNU_OSPEER = "DisassociateNicConfigPnuOSPeer"
    FSM_STATUS_DISASSOCIATE_NIC_UNCONFIG_HOST_OSLOCAL = "DisassociateNicUnconfigHostOSLocal"
    FSM_STATUS_DISASSOCIATE_NIC_UNCONFIG_HOST_OSPEER = "DisassociateNicUnconfigHostOSPeer"
    FSM_STATUS_DISASSOCIATE_NIC_UNCONFIG_PNU_OSLOCAL = "DisassociateNicUnconfigPnuOSLocal"
    FSM_STATUS_DISASSOCIATE_NIC_UNCONFIG_PNU_OSPEER = "DisassociateNicUnconfigPnuOSPeer"
    FSM_STATUS_DISASSOCIATE_NIC_UNCONFIG_SERVICE_INFRA_LOCAL = "DisassociateNicUnconfigServiceInfraLocal"
    FSM_STATUS_DISASSOCIATE_NIC_UNCONFIG_SERVICE_INFRA_PEER = "DisassociateNicUnconfigServiceInfraPeer"
    FSM_STATUS_DISASSOCIATE_OOB_DISK_SCRUB = "DisassociateOobDiskScrub"
    FSM_STATUS_DISASSOCIATE_PNU_OSCATALOG = "DisassociatePnuOSCatalog"
    FSM_STATUS_DISASSOCIATE_PNU_OSIDENT = "DisassociatePnuOSIdent"
    FSM_STATUS_DISASSOCIATE_PNU_OSPOLICY = "DisassociatePnuOSPolicy"
    FSM_STATUS_DISASSOCIATE_PNU_OSSCRUB = "DisassociatePnuOSScrub"
    FSM_STATUS_DISASSOCIATE_PNU_OSSELF_TEST = "DisassociatePnuOSSelfTest"
    FSM_STATUS_DISASSOCIATE_PNU_OSUNCONFIG = "DisassociatePnuOSUnconfig"
    FSM_STATUS_DISASSOCIATE_PNU_OSVALIDATE = "DisassociatePnuOSValidate"
    FSM_STATUS_DISASSOCIATE_POWER_DEPLOY_WAIT = "DisassociatePowerDeployWait"
    FSM_STATUS_DISASSOCIATE_POWER_ON = "DisassociatePowerOn"
    FSM_STATUS_DISASSOCIATE_PRE_SANITIZE = "DisassociatePreSanitize"
    FSM_STATUS_DISASSOCIATE_RESET_SECURE_BOOT_CONFIG = "DisassociateResetSecureBootConfig"
    FSM_STATUS_DISASSOCIATE_SANITIZE = "DisassociateSanitize"
    FSM_STATUS_DISASSOCIATE_SERIAL_DEBUG_PNU_OSCONNECT = "DisassociateSerialDebugPnuOSConnect"
    FSM_STATUS_DISASSOCIATE_SERIAL_DEBUG_PNU_OSDISCONNECT = "DisassociateSerialDebugPnuOSDisconnect"
    FSM_STATUS_DISASSOCIATE_SHUTDOWN = "DisassociateShutdown"
    FSM_STATUS_DISASSOCIATE_SOL_REDIRECT_DISABLE = "DisassociateSolRedirectDisable"
    FSM_STATUS_DISASSOCIATE_SOL_REDIRECT_ENABLE = "DisassociateSolRedirectEnable"
    FSM_STATUS_DISASSOCIATE_SUCCESS = "DisassociateSuccess"
    FSM_STATUS_DISASSOCIATE_SW_CONFIG_PNU_OSLOCAL = "DisassociateSwConfigPnuOSLocal"
    FSM_STATUS_DISASSOCIATE_SW_CONFIG_PNU_OSPEER = "DisassociateSwConfigPnuOSPeer"
    FSM_STATUS_DISASSOCIATE_SW_CONFIG_PORT_NIV_LOCAL = "DisassociateSwConfigPortNivLocal"
    FSM_STATUS_DISASSOCIATE_SW_CONFIG_PORT_NIV_PEER = "DisassociateSwConfigPortNivPeer"
    FSM_STATUS_DISASSOCIATE_SW_UNCONFIG_HOST_OSLOCAL = "DisassociateSwUnconfigHostOSLocal"
    FSM_STATUS_DISASSOCIATE_SW_UNCONFIG_HOST_OSPEER = "DisassociateSwUnconfigHostOSPeer"
    FSM_STATUS_DISASSOCIATE_SW_UNCONFIG_PNU_OSLOCAL = "DisassociateSwUnconfigPnuOSLocal"
    FSM_STATUS_DISASSOCIATE_SW_UNCONFIG_PNU_OSPEER = "DisassociateSwUnconfigPnuOSPeer"
    FSM_STATUS_DISASSOCIATE_UNCONFIG_BIOS = "DisassociateUnconfigBios"
    FSM_STATUS_DISASSOCIATE_UNCONFIG_CIMC_VMEDIA = "DisassociateUnconfigCimcVMedia"
    FSM_STATUS_DISASSOCIATE_UNCONFIG_EXT_MGMT_GW = "DisassociateUnconfigExtMgmtGw"
    FSM_STATUS_DISASSOCIATE_UNCONFIG_EXT_MGMT_RULES = "DisassociateUnconfigExtMgmtRules"
    FSM_STATUS_DISASSOCIATE_UNCONFIG_FLEX_FLASH = "DisassociateUnconfigFlexFlash"
    FSM_STATUS_DISASSOCIATE_UNCONFIG_SO_L = "DisassociateUnconfigSoL"
    FSM_STATUS_DISASSOCIATE_UNCONFIG_UUID = "DisassociateUnconfigUuid"
    FSM_STATUS_DISASSOCIATE_VERIFY_FC_ZONE_CONFIG = "DisassociateVerifyFcZoneConfig"
    FSM_STATUS_DISCOVER_BEGIN = "DiscoverBegin"
    FSM_STATUS_DISCOVER_BIOS_POST_COMPLETION = "DiscoverBiosPostCompletion"
    FSM_STATUS_DISCOVER_BLADE_POWER_OFF = "DiscoverBladePowerOff"
    FSM_STATUS_DISCOVER_BMC_CONFIG_PNU_OS = "DiscoverBmcConfigPnuOS"
    FSM_STATUS_DISCOVER_BMC_CONFIGURE_CONN_LOCAL = "DiscoverBmcConfigureConnLocal"
    FSM_STATUS_DISCOVER_BMC_CONFIGURE_CONN_PEER = "DiscoverBmcConfigureConnPeer"
    FSM_STATUS_DISCOVER_BMC_FACTORY_RESET = "DiscoverBmcFactoryReset"
    FSM_STATUS_DISCOVER_BMC_INVENTORY = "DiscoverBmcInventory"
    FSM_STATUS_DISCOVER_BMC_PRECONFIG_PNU_OSLOCAL = "DiscoverBmcPreconfigPnuOSLocal"
    FSM_STATUS_DISCOVER_BMC_PRECONFIG_PNU_OSPEER = "DiscoverBmcPreconfigPnuOSPeer"
    FSM_STATUS_DISCOVER_BMC_PRESENCE = "DiscoverBmcPresence"
    FSM_STATUS_DISCOVER_BMC_SHUTDOWN_DISCOVERED = "DiscoverBmcShutdownDiscovered"
    FSM_STATUS_DISCOVER_BMC_UNCONFIG_PNU_OS = "DiscoverBmcUnconfigPnuOS"
    FSM_STATUS_DISCOVER_BOOT_PNUOS = "DiscoverBootPnuos"
    FSM_STATUS_DISCOVER_BOOT_WAIT = "DiscoverBootWait"
    FSM_STATUS_DISCOVER_CHECK_POWER_AVAILABILITY = "DiscoverCheckPowerAvailability"
    FSM_STATUS_DISCOVER_CONFIG_DISCOVERY_MODE = "DiscoverConfigDiscoveryMode"
    FSM_STATUS_DISCOVER_CONFIG_FLEX_FLASH_SCRUB = "DiscoverConfigFlexFlashScrub"
    FSM_STATUS_DISCOVER_CONFIG_NIV_MODE = "DiscoverConfigNivMode"
    FSM_STATUS_DISCOVER_CONFIG_USER_ACCESS = "DiscoverConfigUserAccess"
    FSM_STATUS_DISCOVER_FAIL = "DiscoverFail"
    FSM_STATUS_DISCOVER_HAG_CONNECT = "DiscoverHagConnect"
    FSM_STATUS_DISCOVER_HAG_DISCONNECT = "DiscoverHagDisconnect"
    FSM_STATUS_DISCOVER_HANDLE_POOLING = "DiscoverHandlePooling"
    FSM_STATUS_DISCOVER_NIC_CONFIG_PNU_OSLOCAL = "DiscoverNicConfigPnuOSLocal"
    FSM_STATUS_DISCOVER_NIC_CONFIG_PNU_OSPEER = "DiscoverNicConfigPnuOSPeer"
    FSM_STATUS_DISCOVER_NIC_INVENTORY_LOCAL = "DiscoverNicInventoryLocal"
    FSM_STATUS_DISCOVER_NIC_INVENTORY_PEER = "DiscoverNicInventoryPeer"
    FSM_STATUS_DISCOVER_OOB_STORAGE_INVENTORY = "DiscoverOobStorageInventory"
    FSM_STATUS_DISCOVER_PNU_OSCATALOG = "DiscoverPnuOSCatalog"
    FSM_STATUS_DISCOVER_PNU_OSCONN_STATUS = "DiscoverPnuOSConnStatus"
    FSM_STATUS_DISCOVER_PNU_OSCONNECTIVITY = "DiscoverPnuOSConnectivity"
    FSM_STATUS_DISCOVER_PNU_OSIDENT = "DiscoverPnuOSIdent"
    FSM_STATUS_DISCOVER_PNU_OSINVENTORY = "DiscoverPnuOSInventory"
    FSM_STATUS_DISCOVER_PNU_OSPOLICY = "DiscoverPnuOSPolicy"
    FSM_STATUS_DISCOVER_PNU_OSSCRUB = "DiscoverPnuOSScrub"
    FSM_STATUS_DISCOVER_PNU_OSSELF_TEST = "DiscoverPnuOSSelfTest"
    FSM_STATUS_DISCOVER_POWER_DEPLOY_WAIT = "DiscoverPowerDeployWait"
    FSM_STATUS_DISCOVER_PRE_SANITIZE = "DiscoverPreSanitize"
    FSM_STATUS_DISCOVER_READ_SMBIOS = "DiscoverReadSmbios"
    FSM_STATUS_DISCOVER_SANITIZE = "DiscoverSanitize"
    FSM_STATUS_DISCOVER_SERIAL_DEBUG_CONNECT = "DiscoverSerialDebugConnect"
    FSM_STATUS_DISCOVER_SERIAL_DEBUG_DISCONNECT = "DiscoverSerialDebugDisconnect"
    FSM_STATUS_DISCOVER_SOL_REDIRECT_DISABLE = "DiscoverSolRedirectDisable"
    FSM_STATUS_DISCOVER_SOL_REDIRECT_ENABLE = "DiscoverSolRedirectEnable"
    FSM_STATUS_DISCOVER_SUCCESS = "DiscoverSuccess"
    FSM_STATUS_DISCOVER_SW_CONFIG_PNU_OSLOCAL = "DiscoverSwConfigPnuOSLocal"
    FSM_STATUS_DISCOVER_SW_CONFIG_PNU_OSPEER = "DiscoverSwConfigPnuOSPeer"
    FSM_STATUS_DISCOVER_SW_CONFIG_PORT_NIV_LOCAL = "DiscoverSwConfigPortNivLocal"
    FSM_STATUS_DISCOVER_SW_CONFIG_PORT_NIV_PEER = "DiscoverSwConfigPortNivPeer"
    FSM_STATUS_DISCOVER_SW_CONFIGURE_CONN_LOCAL = "DiscoverSwConfigureConnLocal"
    FSM_STATUS_DISCOVER_SW_CONFIGURE_CONN_PEER = "DiscoverSwConfigureConnPeer"
    FSM_STATUS_DISCOVER_SW_PNU_OSCONNECTIVITY_LOCAL = "DiscoverSwPnuOSConnectivityLocal"
    FSM_STATUS_DISCOVER_SW_PNU_OSCONNECTIVITY_PEER = "DiscoverSwPnuOSConnectivityPeer"
    FSM_STATUS_DISCOVER_SW_UNCONFIG_PORT_NIV_LOCAL = "DiscoverSwUnconfigPortNivLocal"
    FSM_STATUS_DISCOVER_SW_UNCONFIG_PORT_NIV_PEER = "DiscoverSwUnconfigPortNivPeer"
    FSM_STATUS_DISCOVER_UNCONFIG_CIMC_VMEDIA = "DiscoverUnconfigCimcVMedia"
    FSM_STATUS_DISCOVER_UNCONFIG_EXT_MGMT_GW = "DiscoverUnconfigExtMgmtGw"
    FSM_STATUS_DISCOVER_UNCONFIG_EXT_MGMT_RULES = "DiscoverUnconfigExtMgmtRules"
    FSM_STATUS_DISCOVER_WAIT_FOR_CONN_READY = "DiscoverWaitForConnReady"
    FSM_STATUS_DISK_ZONING_INVENTORY_BEGIN = "DiskZoningInventoryBegin"
    FSM_STATUS_DISK_ZONING_INVENTORY_BOOT_HOST = "DiskZoningInventoryBootHost"
    FSM_STATUS_DISK_ZONING_INVENTORY_BOOT_WAIT = "DiskZoningInventoryBootWait"
    FSM_STATUS_DISK_ZONING_INVENTORY_FAIL = "DiskZoningInventoryFail"
    FSM_STATUS_DISK_ZONING_INVENTORY_PRE_SANITIZE = "DiskZoningInventoryPreSanitize"
    FSM_STATUS_DISK_ZONING_INVENTORY_SANITIZE = "DiskZoningInventorySanitize"
    FSM_STATUS_DISK_ZONING_INVENTORY_SHUTDOWN = "DiskZoningInventoryShutdown"
    FSM_STATUS_DISK_ZONING_INVENTORY_STORAGE_INVENTORY = "DiskZoningInventoryStorageInventory"
    FSM_STATUS_DISK_ZONING_INVENTORY_SUCCESS = "DiskZoningInventorySuccess"
    FSM_STATUS_ENABLE_CIMC_SECURE_BOOT_ACTIVATE = "EnableCimcSecureBootActivate"
    FSM_STATUS_ENABLE_CIMC_SECURE_BOOT_BEGIN = "EnableCimcSecureBootBegin"
    FSM_STATUS_ENABLE_CIMC_SECURE_BOOT_FAIL = "EnableCimcSecureBootFail"
    FSM_STATUS_ENABLE_CIMC_SECURE_BOOT_POLL_UPDATE_STATUS = "EnableCimcSecureBootPollUpdateStatus"
    FSM_STATUS_ENABLE_CIMC_SECURE_BOOT_RESET = "EnableCimcSecureBootReset"
    FSM_STATUS_ENABLE_CIMC_SECURE_BOOT_SUCCESS = "EnableCimcSecureBootSuccess"
    FSM_STATUS_ENABLE_CIMC_SECURE_BOOT_UPDATE_REQUEST = "EnableCimcSecureBootUpdateRequest"
    FSM_STATUS_FLASH_CONTROLLER_BEGIN = "FlashControllerBegin"
    FSM_STATUS_FLASH_CONTROLLER_FAIL = "FlashControllerFail"
    FSM_STATUS_FLASH_CONTROLLER_SUCCESS = "FlashControllerSuccess"
    FSM_STATUS_FLASH_CONTROLLER_UPDATE_FLASH_LIFE = "FlashControllerUpdateFlashLife"
    FSM_STATUS_FW_UPGRADE_ACTIVATE_ADAPTOR_NW_FW_LOCAL = "FwUpgradeActivateAdaptorNwFwLocal"
    FSM_STATUS_FW_UPGRADE_ACTIVATE_ADAPTOR_NW_FW_PEER = "FwUpgradeActivateAdaptorNwFwPeer"
    FSM_STATUS_FW_UPGRADE_ACTIVATE_BIOS = "FwUpgradeActivateBios"
    FSM_STATUS_FW_UPGRADE_ACTIVATE_IBMCFW = "FwUpgradeActivateIBMCFw"
    FSM_STATUS_FW_UPGRADE_BEGIN = "FwUpgradeBegin"
    FSM_STATUS_FW_UPGRADE_BIOS_IMG_UPDATE = "FwUpgradeBiosImgUpdate"
    FSM_STATUS_FW_UPGRADE_BIOS_POST_COMPLETION = "FwUpgradeBiosPostCompletion"
    FSM_STATUS_FW_UPGRADE_BLADE_POWER_OFF = "FwUpgradeBladePowerOff"
    FSM_STATUS_FW_UPGRADE_BMC_CONFIG_PNU_OS = "FwUpgradeBmcConfigPnuOS"
    FSM_STATUS_FW_UPGRADE_BMC_PRECONFIG_PNU_OSLOCAL = "FwUpgradeBmcPreconfigPnuOSLocal"
    FSM_STATUS_FW_UPGRADE_BMC_PRECONFIG_PNU_OSPEER = "FwUpgradeBmcPreconfigPnuOSPeer"
    FSM_STATUS_FW_UPGRADE_BMC_UNCONFIG_PNU_OS = "FwUpgradeBmcUnconfigPnuOS"
    FSM_STATUS_FW_UPGRADE_BOOT_PNUOS = "FwUpgradeBootPnuos"
    FSM_STATUS_FW_UPGRADE_BOOT_WAIT = "FwUpgradeBootWait"
    FSM_STATUS_FW_UPGRADE_CHECK_POWER_AVAILABILITY = "FwUpgradeCheckPowerAvailability"
    FSM_STATUS_FW_UPGRADE_CISCO_OSOPEN_GATE = "FwUpgradeCiscoOSOpenGate"
    FSM_STATUS_FW_UPGRADE_CLEAR_BIOS_UPDATE = "FwUpgradeClearBiosUpdate"
    FSM_STATUS_FW_UPGRADE_COPY_REMOTE = "FwUpgradeCopyRemote"
    FSM_STATUS_FW_UPGRADE_DEASSERT_RESET_BYPASS = "FwUpgradeDeassertResetBypass"
    FSM_STATUS_FW_UPGRADE_DELETE_CURL_DOWNLOADED_IMAGES = "FwUpgradeDeleteCurlDownloadedImages"
    FSM_STATUS_FW_UPGRADE_DELETE_IMAGES_REMOTE = "FwUpgradeDeleteImagesRemote"
    FSM_STATUS_FW_UPGRADE_DOWNLOAD_IMAGES = "FwUpgradeDownloadImages"
    FSM_STATUS_FW_UPGRADE_FAIL = "FwUpgradeFail"
    FSM_STATUS_FW_UPGRADE_GRAPHICS_IMAGE_UPDATE = "FwUpgradeGraphicsImageUpdate"
    FSM_STATUS_FW_UPGRADE_HAG_PNU_OSCONNECT = "FwUpgradeHagPnuOSConnect"
    FSM_STATUS_FW_UPGRADE_HAG_PNU_OSDISCONNECT = "FwUpgradeHagPnuOSDisconnect"
    FSM_STATUS_FW_UPGRADE_HBA_IMG_UPDATE = "FwUpgradeHbaImgUpdate"
    FSM_STATUS_FW_UPGRADE_LOCAL_DISK_FW_UPDATE = "FwUpgradeLocalDiskFwUpdate"
    FSM_STATUS_FW_UPGRADE_NIC_CONFIG_PNU_OSLOCAL = "FwUpgradeNicConfigPnuOSLocal"
    FSM_STATUS_FW_UPGRADE_NIC_CONFIG_PNU_OSPEER = "FwUpgradeNicConfigPnuOSPeer"
    FSM_STATUS_FW_UPGRADE_NIC_IMG_UPDATE = "FwUpgradeNicImgUpdate"
    FSM_STATUS_FW_UPGRADE_NIC_UNCONFIG_PNU_OSLOCAL = "FwUpgradeNicUnconfigPnuOSLocal"
    FSM_STATUS_FW_UPGRADE_NIC_UNCONFIG_PNU_OSPEER = "FwUpgradeNicUnconfigPnuOSPeer"
    FSM_STATUS_FW_UPGRADE_OOB_POLL_SAS_EXPANDER_ACTIVATE_STATUS = "FwUpgradeOobPollSasExpanderActivateStatus"
    FSM_STATUS_FW_UPGRADE_OOB_POLL_SAS_EXPANDER_UPDATE_STATUS = "FwUpgradeOobPollSasExpanderUpdateStatus"
    FSM_STATUS_FW_UPGRADE_OOB_SAS_EXPANDER_IMG_ACTIVATE = "FwUpgradeOobSasExpanderImgActivate"
    FSM_STATUS_FW_UPGRADE_OOB_SAS_EXPANDER_IMG_UPDATE = "FwUpgradeOobSasExpanderImgUpdate"
    FSM_STATUS_FW_UPGRADE_OOB_STORAGE_INVENTORY = "FwUpgradeOobStorageInventory"
    FSM_STATUS_FW_UPGRADE_PNU_OSCATALOG = "FwUpgradePnuOSCatalog"
    FSM_STATUS_FW_UPGRADE_PNU_OSCONFIG = "FwUpgradePnuOSConfig"
    FSM_STATUS_FW_UPGRADE_PNU_OSIDENT = "FwUpgradePnuOSIdent"
    FSM_STATUS_FW_UPGRADE_PNU_OSINVENTORY = "FwUpgradePnuOSInventory"
    FSM_STATUS_FW_UPGRADE_PNU_OSPOLICY = "FwUpgradePnuOSPolicy"
    FSM_STATUS_FW_UPGRADE_PNU_OSSELF_TEST = "FwUpgradePnuOSSelfTest"
    FSM_STATUS_FW_UPGRADE_PNU_OSUNLOAD_DRIVERS = "FwUpgradePnuOSUnloadDrivers"
    FSM_STATUS_FW_UPGRADE_PNU_OSVALIDATE = "FwUpgradePnuOSValidate"
    FSM_STATUS_FW_UPGRADE_POLL_BIOS_ACTIVATE_STATUS = "FwUpgradePollBiosActivateStatus"
    FSM_STATUS_FW_UPGRADE_POLL_BIOS_UPDATE_STATUS = "FwUpgradePollBiosUpdateStatus"
    FSM_STATUS_FW_UPGRADE_POLL_BOARD_CTRL_POWER_CYCLE = "FwUpgradePollBoardCtrlPowerCycle"
    FSM_STATUS_FW_UPGRADE_POLL_BOARD_CTRL_UPDATE_STATUS = "FwUpgradePollBoardCtrlUpdateStatus"
    FSM_STATUS_FW_UPGRADE_POLL_CLEAR_BIOS_UPDATE_STATUS = "FwUpgradePollClearBiosUpdateStatus"
    FSM_STATUS_FW_UPGRADE_POWER_CYCLE_BOARD = "FwUpgradePowerCycleBoard"
    FSM_STATUS_FW_UPGRADE_POWER_DEPLOY_WAIT = "FwUpgradePowerDeployWait"
    FSM_STATUS_FW_UPGRADE_POWER_ON = "FwUpgradePowerOn"
    FSM_STATUS_FW_UPGRADE_PRE_SANITIZE = "FwUpgradePreSanitize"
    FSM_STATUS_FW_UPGRADE_RESET_IBMC = "FwUpgradeResetIBMC"
    FSM_STATUS_FW_UPGRADE_SANITIZE = "FwUpgradeSanitize"
    FSM_STATUS_FW_UPGRADE_SAS_EXPANDER_IMG_UPDATE = "FwUpgradeSasExpanderImgUpdate"
    FSM_STATUS_FW_UPGRADE_SERIAL_DEBUG_PNU_OSCONNECT = "FwUpgradeSerialDebugPnuOSConnect"
    FSM_STATUS_FW_UPGRADE_SERIAL_DEBUG_PNU_OSDISCONNECT = "FwUpgradeSerialDebugPnuOSDisconnect"
    FSM_STATUS_FW_UPGRADE_SHUTDOWN = "FwUpgradeShutdown"
    FSM_STATUS_FW_UPGRADE_SOL_REDIRECT_DISABLE = "FwUpgradeSolRedirectDisable"
    FSM_STATUS_FW_UPGRADE_SOL_REDIRECT_ENABLE = "FwUpgradeSolRedirectEnable"
    FSM_STATUS_FW_UPGRADE_STORAGE_CTLR_IMG_UPDATE = "FwUpgradeStorageCtlrImgUpdate"
    FSM_STATUS_FW_UPGRADE_SUCCESS = "FwUpgradeSuccess"
    FSM_STATUS_FW_UPGRADE_SW_CONFIG_PNU_OSLOCAL = "FwUpgradeSwConfigPnuOSLocal"
    FSM_STATUS_FW_UPGRADE_SW_CONFIG_PNU_OSPEER = "FwUpgradeSwConfigPnuOSPeer"
    FSM_STATUS_FW_UPGRADE_SW_CONFIG_PORT_NIV_LOCAL = "FwUpgradeSwConfigPortNivLocal"
    FSM_STATUS_FW_UPGRADE_SW_CONFIG_PORT_NIV_PEER = "FwUpgradeSwConfigPortNivPeer"
    FSM_STATUS_FW_UPGRADE_SW_UNCONFIG_PNU_OSLOCAL = "FwUpgradeSwUnconfigPnuOSLocal"
    FSM_STATUS_FW_UPGRADE_SW_UNCONFIG_PNU_OSPEER = "FwUpgradeSwUnconfigPnuOSPeer"
    FSM_STATUS_FW_UPGRADE_UNCONFIG_CIMC_VMEDIA = "FwUpgradeUnconfigCimcVMedia"
    FSM_STATUS_FW_UPGRADE_UNCONFIG_EXT_MGMT_GW = "FwUpgradeUnconfigExtMgmtGw"
    FSM_STATUS_FW_UPGRADE_UNCONFIG_EXT_MGMT_RULES = "FwUpgradeUnconfigExtMgmtRules"
    FSM_STATUS_FW_UPGRADE_UNLOCK_FIRMWARE_IMAGE = "FwUpgradeUnlockFirmwareImage"
    FSM_STATUS_FW_UPGRADE_UPDATE_ADAPTOR_NW_FW_LOCAL = "FwUpgradeUpdateAdaptorNwFwLocal"
    FSM_STATUS_FW_UPGRADE_UPDATE_ADAPTOR_NW_FW_PEER = "FwUpgradeUpdateAdaptorNwFwPeer"
    FSM_STATUS_FW_UPGRADE_UPDATE_BIOS_REQUEST = "FwUpgradeUpdateBiosRequest"
    FSM_STATUS_FW_UPGRADE_UPDATE_BOARD_CTRL_REQUEST = "FwUpgradeUpdateBoardCtrlRequest"
    FSM_STATUS_FW_UPGRADE_UPDATE_IBMCFW = "FwUpgradeUpdateIBMCFw"
    FSM_STATUS_FW_UPGRADE_WAIT_FOR_ADAPTOR_NW_FW_UPDATE_LOCAL = "FwUpgradeWaitForAdaptorNwFwUpdateLocal"
    FSM_STATUS_FW_UPGRADE_WAIT_FOR_ADAPTOR_NW_FW_UPDATE_PEER = "FwUpgradeWaitForAdaptorNwFwUpdatePeer"
    FSM_STATUS_FW_UPGRADE_WAIT_FOR_IBMCFW_UPDATE = "FwUpgradeWaitForIBMCFwUpdate"
    FSM_STATUS_HARD_SHUTDOWN_BEGIN = "HardShutdownBegin"
    FSM_STATUS_HARD_SHUTDOWN_EXECUTE = "HardShutdownExecute"
    FSM_STATUS_HARD_SHUTDOWN_FAIL = "HardShutdownFail"
    FSM_STATUS_HARD_SHUTDOWN_SUCCESS = "HardShutdownSuccess"
    FSM_STATUS_HARDRESET_BEGIN = "HardresetBegin"
    FSM_STATUS_HARDRESET_CHECK_POWER_AVAILABILITY = "HardresetCheckPowerAvailability"
    FSM_STATUS_HARDRESET_EXECUTE = "HardresetExecute"
    FSM_STATUS_HARDRESET_FAIL = "HardresetFail"
    FSM_STATUS_HARDRESET_POWER_DEPLOY_WAIT = "HardresetPowerDeployWait"
    FSM_STATUS_HARDRESET_PRE_SANITIZE = "HardresetPreSanitize"
    FSM_STATUS_HARDRESET_SANITIZE = "HardresetSanitize"
    FSM_STATUS_HARDRESET_SUCCESS = "HardresetSuccess"
    FSM_STATUS_OFFLINE_BEGIN = "OfflineBegin"
    FSM_STATUS_OFFLINE_CLEANUP_LOCAL = "OfflineCleanupLocal"
    FSM_STATUS_OFFLINE_CLEANUP_PEER = "OfflineCleanupPeer"
    FSM_STATUS_OFFLINE_FAIL = "OfflineFail"
    FSM_STATUS_OFFLINE_SUCCESS = "OfflineSuccess"
    FSM_STATUS_OFFLINE_SW_UNCONFIGURE_LOCAL = "OfflineSwUnconfigureLocal"
    FSM_STATUS_OFFLINE_SW_UNCONFIGURE_PEER = "OfflineSwUnconfigurePeer"
    FSM_STATUS_OOB_STORAGE_ADMIN_CONFIG_BEGIN = "OobStorageAdminConfigBegin"
    FSM_STATUS_OOB_STORAGE_ADMIN_CONFIG_BOOT_HOST = "OobStorageAdminConfigBootHost"
    FSM_STATUS_OOB_STORAGE_ADMIN_CONFIG_BOOT_WAIT = "OobStorageAdminConfigBootWait"
    FSM_STATUS_OOB_STORAGE_ADMIN_CONFIG_FAIL = "OobStorageAdminConfigFail"
    FSM_STATUS_OOB_STORAGE_ADMIN_CONFIG_OOB_STORAGE_CONFIG = "OobStorageAdminConfigOobStorageConfig"
    FSM_STATUS_OOB_STORAGE_ADMIN_CONFIG_OOB_STORAGE_INVENTORY = "OobStorageAdminConfigOobStorageInventory"
    FSM_STATUS_OOB_STORAGE_ADMIN_CONFIG_PRE_SANITIZE = "OobStorageAdminConfigPreSanitize"
    FSM_STATUS_OOB_STORAGE_ADMIN_CONFIG_SANITIZE = "OobStorageAdminConfigSanitize"
    FSM_STATUS_OOB_STORAGE_ADMIN_CONFIG_SHUTDOWN = "OobStorageAdminConfigShutdown"
    FSM_STATUS_OOB_STORAGE_ADMIN_CONFIG_SUCCESS = "OobStorageAdminConfigSuccess"
    FSM_STATUS_OOB_STORAGE_ADMIN_CONFIG_TEAR_DOWN_VMEDIA_LOCAL = "OobStorageAdminConfigTearDownVMediaLocal"
    FSM_STATUS_OOB_STORAGE_ADMIN_CONFIG_TEAR_DOWN_VMEDIA_PEER = "OobStorageAdminConfigTearDownVMediaPeer"
    FSM_STATUS_POWER_CAP_BEGIN = "PowerCapBegin"
    FSM_STATUS_POWER_CAP_CONFIG = "PowerCapConfig"
    FSM_STATUS_POWER_CAP_FAIL = "PowerCapFail"
    FSM_STATUS_POWER_CAP_SUCCESS = "PowerCapSuccess"
    FSM_STATUS_POWERCYCLE_BEGIN = "PowercycleBegin"
    FSM_STATUS_POWERCYCLE_CHECK_POWER_AVAILABILITY = "PowercycleCheckPowerAvailability"
    FSM_STATUS_POWERCYCLE_EXECUTE = "PowercycleExecute"
    FSM_STATUS_POWERCYCLE_FAIL = "PowercycleFail"
    FSM_STATUS_POWERCYCLE_POWER_DEPLOY_WAIT = "PowercyclePowerDeployWait"
    FSM_STATUS_POWERCYCLE_PRE_SANITIZE = "PowercyclePreSanitize"
    FSM_STATUS_POWERCYCLE_SANITIZE = "PowercycleSanitize"
    FSM_STATUS_POWERCYCLE_SUCCESS = "PowercycleSuccess"
    FSM_STATUS_RESET_BMC_BEGIN = "ResetBmcBegin"
    FSM_STATUS_RESET_BMC_EXECUTE = "ResetBmcExecute"
    FSM_STATUS_RESET_BMC_FAIL = "ResetBmcFail"
    FSM_STATUS_RESET_BMC_SUCCESS = "ResetBmcSuccess"
    FSM_STATUS_RESET_IPMI_BEGIN = "ResetIpmiBegin"
    FSM_STATUS_RESET_IPMI_EXECUTE = "ResetIpmiExecute"
    FSM_STATUS_RESET_IPMI_FAIL = "ResetIpmiFail"
    FSM_STATUS_RESET_IPMI_SUCCESS = "ResetIpmiSuccess"
    FSM_STATUS_RESET_KVM_BEGIN = "ResetKvmBegin"
    FSM_STATUS_RESET_KVM_EXECUTE = "ResetKvmExecute"
    FSM_STATUS_RESET_KVM_FAIL = "ResetKvmFail"
    FSM_STATUS_RESET_KVM_SUCCESS = "ResetKvmSuccess"
    FSM_STATUS_RESET_MEMORY_ERRORS_BEGIN = "ResetMemoryErrorsBegin"
    FSM_STATUS_RESET_MEMORY_ERRORS_EXECUTE = "ResetMemoryErrorsExecute"
    FSM_STATUS_RESET_MEMORY_ERRORS_FAIL = "ResetMemoryErrorsFail"
    FSM_STATUS_RESET_MEMORY_ERRORS_SUCCESS = "ResetMemoryErrorsSuccess"
    FSM_STATUS_SERVICE_INFRA_DEPLOY_BEGIN = "ServiceInfraDeployBegin"
    FSM_STATUS_SERVICE_INFRA_DEPLOY_FAIL = "ServiceInfraDeployFail"
    FSM_STATUS_SERVICE_INFRA_DEPLOY_NIC_CONFIG_LOCAL = "ServiceInfraDeployNicConfigLocal"
    FSM_STATUS_SERVICE_INFRA_DEPLOY_NIC_CONFIG_PEER = "ServiceInfraDeployNicConfigPeer"
    FSM_STATUS_SERVICE_INFRA_DEPLOY_SUCCESS = "ServiceInfraDeploySuccess"
    FSM_STATUS_SERVICE_INFRA_DEPLOY_SW_CONFIG_LOCAL = "ServiceInfraDeploySwConfigLocal"
    FSM_STATUS_SERVICE_INFRA_DEPLOY_SW_CONFIG_PEER = "ServiceInfraDeploySwConfigPeer"
    FSM_STATUS_SERVICE_INFRA_WITHDRAW_BEGIN = "ServiceInfraWithdrawBegin"
    FSM_STATUS_SERVICE_INFRA_WITHDRAW_FAIL = "ServiceInfraWithdrawFail"
    FSM_STATUS_SERVICE_INFRA_WITHDRAW_NIC_UN_CONFIG_LOCAL = "ServiceInfraWithdrawNicUnConfigLocal"
    FSM_STATUS_SERVICE_INFRA_WITHDRAW_NIC_UN_CONFIG_PEER = "ServiceInfraWithdrawNicUnConfigPeer"
    FSM_STATUS_SERVICE_INFRA_WITHDRAW_SUCCESS = "ServiceInfraWithdrawSuccess"
    FSM_STATUS_SERVICE_INFRA_WITHDRAW_SW_UN_CONFIG_LOCAL = "ServiceInfraWithdrawSwUnConfigLocal"
    FSM_STATUS_SERVICE_INFRA_WITHDRAW_SW_UN_CONFIG_PEER = "ServiceInfraWithdrawSwUnConfigPeer"
    FSM_STATUS_SOFT_SHUTDOWN_BEGIN = "SoftShutdownBegin"
    FSM_STATUS_SOFT_SHUTDOWN_EXECUTE = "SoftShutdownExecute"
    FSM_STATUS_SOFT_SHUTDOWN_FAIL = "SoftShutdownFail"
    FSM_STATUS_SOFT_SHUTDOWN_SUCCESS = "SoftShutdownSuccess"
    FSM_STATUS_SOFTRESET_BEGIN = "SoftresetBegin"
    FSM_STATUS_SOFTRESET_CHECK_POWER_AVAILABILITY = "SoftresetCheckPowerAvailability"
    FSM_STATUS_SOFTRESET_EXECUTE = "SoftresetExecute"
    FSM_STATUS_SOFTRESET_FAIL = "SoftresetFail"
    FSM_STATUS_SOFTRESET_POWER_DEPLOY_WAIT = "SoftresetPowerDeployWait"
    FSM_STATUS_SOFTRESET_PRE_SANITIZE = "SoftresetPreSanitize"
    FSM_STATUS_SOFTRESET_SANITIZE = "SoftresetSanitize"
    FSM_STATUS_SOFTRESET_SUCCESS = "SoftresetSuccess"
    FSM_STATUS_SW_CONN_UPD_A = "SwConnUpdA"
    FSM_STATUS_SW_CONN_UPD_B = "SwConnUpdB"
    FSM_STATUS_SW_CONN_UPD_BEGIN = "SwConnUpdBegin"
    FSM_STATUS_SW_CONN_UPD_FAIL = "SwConnUpdFail"
    FSM_STATUS_SW_CONN_UPD_SUCCESS = "SwConnUpdSuccess"
    FSM_STATUS_TURNUP_BEGIN = "TurnupBegin"
    FSM_STATUS_TURNUP_CHECK_POWER_AVAILABILITY = "TurnupCheckPowerAvailability"
    FSM_STATUS_TURNUP_EXECUTE = "TurnupExecute"
    FSM_STATUS_TURNUP_FAIL = "TurnupFail"
    FSM_STATUS_TURNUP_POWER_DEPLOY_WAIT = "TurnupPowerDeployWait"
    FSM_STATUS_TURNUP_SUCCESS = "TurnupSuccess"
    FSM_STATUS_UNCONFIG_SO_LBEGIN = "UnconfigSoLBegin"
    FSM_STATUS_UNCONFIG_SO_LEXECUTE = "UnconfigSoLExecute"
    FSM_STATUS_UNCONFIG_SO_LFAIL = "UnconfigSoLFail"
    FSM_STATUS_UNCONFIG_SO_LSUCCESS = "UnconfigSoLSuccess"
    FSM_STATUS_UPDATE_ADAPTOR_BEGIN = "UpdateAdaptorBegin"
    FSM_STATUS_UPDATE_ADAPTOR_CHECK_POWER_AVAILABILITY = "UpdateAdaptorCheckPowerAvailability"
    FSM_STATUS_UPDATE_ADAPTOR_FAIL = "UpdateAdaptorFail"
    FSM_STATUS_UPDATE_ADAPTOR_POLL_UPDATE_STATUS_LOCAL = "UpdateAdaptorPollUpdateStatusLocal"
    FSM_STATUS_UPDATE_ADAPTOR_POLL_UPDATE_STATUS_PEER = "UpdateAdaptorPollUpdateStatusPeer"
    FSM_STATUS_UPDATE_ADAPTOR_POWER_DEPLOY_WAIT = "UpdateAdaptorPowerDeployWait"
    FSM_STATUS_UPDATE_ADAPTOR_POWER_OFF = "UpdateAdaptorPowerOff"
    FSM_STATUS_UPDATE_ADAPTOR_POWER_ON = "UpdateAdaptorPowerOn"
    FSM_STATUS_UPDATE_ADAPTOR_SUCCESS = "UpdateAdaptorSuccess"
    FSM_STATUS_UPDATE_ADAPTOR_UPDATE_REQUEST_LOCAL = "UpdateAdaptorUpdateRequestLocal"
    FSM_STATUS_UPDATE_ADAPTOR_UPDATE_REQUEST_PEER = "UpdateAdaptorUpdateRequestPeer"
    FSM_STATUS_UPDATE_BIOSBEGIN = "UpdateBIOSBegin"
    FSM_STATUS_UPDATE_BIOSCLEAR = "UpdateBIOSClear"
    FSM_STATUS_UPDATE_BIOSFAIL = "UpdateBIOSFail"
    FSM_STATUS_UPDATE_BIOSPOLL_CLEAR_STATUS = "UpdateBIOSPollClearStatus"
    FSM_STATUS_UPDATE_BIOSPOLL_UPDATE_STATUS = "UpdateBIOSPollUpdateStatus"
    FSM_STATUS_UPDATE_BIOSSUCCESS = "UpdateBIOSSuccess"
    FSM_STATUS_UPDATE_BIOSUPDATE_REQUEST = "UpdateBIOSUpdateRequest"
    FSM_STATUS_UPDATE_BOARD_CONTROLLER_BEGIN = "UpdateBoardControllerBegin"
    FSM_STATUS_UPDATE_BOARD_CONTROLLER_CHECK_POWER_AVAILABILITY = "UpdateBoardControllerCheckPowerAvailability"
    FSM_STATUS_UPDATE_BOARD_CONTROLLER_FAIL = "UpdateBoardControllerFail"
    FSM_STATUS_UPDATE_BOARD_CONTROLLER_POLL_BOARD_CTRL_POWER_CYCLE = "UpdateBoardControllerPollBoardCtrlPowerCycle"
    FSM_STATUS_UPDATE_BOARD_CONTROLLER_POLL_UPDATE_STATUS = "UpdateBoardControllerPollUpdateStatus"
    FSM_STATUS_UPDATE_BOARD_CONTROLLER_POWER_CYCLE_BOARD = "UpdateBoardControllerPowerCycleBoard"
    FSM_STATUS_UPDATE_BOARD_CONTROLLER_POWER_DEPLOY_WAIT = "UpdateBoardControllerPowerDeployWait"
    FSM_STATUS_UPDATE_BOARD_CONTROLLER_PREPARE_FOR_UPDATE = "UpdateBoardControllerPrepareForUpdate"
    FSM_STATUS_UPDATE_BOARD_CONTROLLER_SERVER_POWER_OFF = "UpdateBoardControllerServerPowerOff"
    FSM_STATUS_UPDATE_BOARD_CONTROLLER_SERVER_POWER_ON = "UpdateBoardControllerServerPowerOn"
    FSM_STATUS_UPDATE_BOARD_CONTROLLER_SUCCESS = "UpdateBoardControllerSuccess"
    FSM_STATUS_UPDATE_BOARD_CONTROLLER_UPDATE_REQUEST = "UpdateBoardControllerUpdateRequest"
    FSM_STATUS_CLEAR_TPMBEGIN = "clearTPMBegin"
    FSM_STATUS_CLEAR_TPMBIOS_POST_COMPLETION = "clearTPMBiosPostCompletion"
    FSM_STATUS_CLEAR_TPMBLADE_POWER_OFF = "clearTPMBladePowerOff"
    FSM_STATUS_CLEAR_TPMBLADE_POWER_ON = "clearTPMBladePowerOn"
    FSM_STATUS_CLEAR_TPMBOOT_HOST = "clearTPMBootHost"
    FSM_STATUS_CLEAR_TPMCLEAR = "clearTPMClear"
    FSM_STATUS_CLEAR_TPMFAIL = "clearTPMFail"
    FSM_STATUS_CLEAR_TPMPRE_SANITIZE = "clearTPMPreSanitize"
    FSM_STATUS_CLEAR_TPMREAD_SM_BIOS = "clearTPMReadSmBios"
    FSM_STATUS_CLEAR_TPMRECONFIG_BIOS = "clearTPMReconfigBios"
    FSM_STATUS_CLEAR_TPMSANITIZE = "clearTPMSanitize"
    FSM_STATUS_CLEAR_TPMSETUP_VMEDIA = "clearTPMSetupVmedia"
    FSM_STATUS_CLEAR_TPMSTOP_VMEDIA_LOCAL = "clearTPMStopVMediaLocal"
    FSM_STATUS_CLEAR_TPMSTOP_VMEDIA_PEER = "clearTPMStopVMediaPeer"
    FSM_STATUS_CLEAR_TPMSUCCESS = "clearTPMSuccess"
    FSM_STATUS_CLEAR_TPMUNCONFIG_VMEDIA = "clearTPMUnconfigVmedia"
    FSM_STATUS_NOP = "nop"
    FSM_STATUS_UPDATE_EXT_USERS_BEGIN = "updateExtUsersBegin"
    FSM_STATUS_UPDATE_EXT_USERS_DEPLOY = "updateExtUsersDeploy"
    FSM_STATUS_UPDATE_EXT_USERS_FAIL = "updateExtUsersFail"
    FSM_STATUS_UPDATE_EXT_USERS_SUCCESS = "updateExtUsersSuccess"
    INT_ID_NONE = "none"
    LC_DECOMMISSION = "decommission"
    LC_DISCOVERED = "discovered"
    LC_MIGRATE = "migrate"
    LC_REDISCOVER = "rediscover"
    LC_REMOVE = "remove"
    LC_RESET_TO_FACTORY = "resetToFactory"
    LC_UNDISCOVERED = "undiscovered"
    LC_UPGRADE_FIRMWARE = "upgrade-firmware"
    LOW_VOLTAGE_MEMORY_LOW_VOLTAGE = "low-voltage"
    LOW_VOLTAGE_MEMORY_NOT_APPLICABLE = "not-applicable"
    LOW_VOLTAGE_MEMORY_REGULAR_VOLTAGE = "regular-voltage"
    MANAGING_INST_A = "A"
    MANAGING_INST_B = "B"
    MANAGING_INST_NONE = "NONE"
    MEMORY_SPEED_NOT_APPLICABLE = "not-applicable"
    MEMORY_SPEED_UNSPECIFIED = "unspecified"
    MFG_TIME_NOT_APPLICABLE = "not-applicable"
    OPER_POWER_DEGRADED = "degraded"
    OPER_POWER_ERROR = "error"
    OPER_POWER_FAILED = "failed"
    OPER_POWER_NOT_SUPPORTED = "not-supported"
    OPER_POWER_OFF = "off"
    OPER_POWER_OFFDUTY = "offduty"
    OPER_POWER_OFFLINE = "offline"
    OPER_POWER_OK = "ok"
    OPER_POWER_ON = "on"
    OPER_POWER_ONLINE = "online"
    OPER_POWER_POWER_SAVE = "power-save"
    OPER_POWER_TEST = "test"
    OPER_POWER_UNKNOWN = "unknown"
    OPER_PWR_TRANS_SRC_SOFTWARE = "software"
    OPER_PWR_TRANS_SRC_SOFTWARE_MCSERVER = "software_mcserver"
    OPER_PWR_TRANS_SRC_UNKNOWN = "unknown"
    OPER_PWR_TRANS_SRC_USER_FP = "user-fp"
    OPER_PWR_TRANS_SRC_USER_UNKNOWN = "user-unknown"
    OPER_STATE_BIOS_RESTORE = "bios-restore"
    OPER_STATE_CMOS_RESET = "cmos-reset"
    OPER_STATE_COMPUTE_FAILED = "compute-failed"
    OPER_STATE_COMPUTE_MISMATCH = "compute-mismatch"
    OPER_STATE_CONFIG = "config"
    OPER_STATE_CONFIG_FAILURE = "config-failure"
    OPER_STATE_DECOMISSIONING = "decomissioning"
    OPER_STATE_DEGRADED = "degraded"
    OPER_STATE_DIAGNOSTICS = "diagnostics"
    OPER_STATE_DIAGNOSTICS_FAILED = "diagnostics-failed"
    OPER_STATE_DISABLED = "disabled"
    OPER_STATE_DISCOVERY = "discovery"
    OPER_STATE_DISCOVERY_FAILED = "discovery-failed"
    OPER_STATE_INACCESSIBLE = "inaccessible"
    OPER_STATE_INDETERMINATE = "indeterminate"
    OPER_STATE_INOPERABLE = "inoperable"
    OPER_STATE_MAINTENANCE = "maintenance"
    OPER_STATE_MAINTENANCE_FAILED = "maintenance-failed"
    OPER_STATE_OK = "ok"
    OPER_STATE_PENDING_REASSOCIATION = "pending-reassociation"
    OPER_STATE_PENDING_REBOOT = "pending-reboot"
    OPER_STATE_POWER_OFF = "power-off"
    OPER_STATE_POWER_PROBLEM = "power-problem"
    OPER_STATE_REMOVED = "removed"
    OPER_STATE_RESTART = "restart"
    OPER_STATE_SVNIC_NOT_PRESENT = "svnic-not-present"
    OPER_STATE_TEST = "test"
    OPER_STATE_TEST_FAILED = "test-failed"
    OPER_STATE_THERMAL_PROBLEM = "thermal-problem"
    OPER_STATE_UNASSOCIATED = "unassociated"
    OPER_STATE_UNCONFIG = "unconfig"
    OPER_STATE_UNCONFIG_FAILED = "unconfig-failed"
    OPER_STATE_VOLTAGE_PROBLEM = "voltage-problem"
    OPERABILITY_ACCESSIBILITY_PROBLEM = "accessibility-problem"
    OPERABILITY_AUTO_UPGRADE = "auto-upgrade"
    OPERABILITY_BACKPLANE_PORT_PROBLEM = "backplane-port-problem"
    OPERABILITY_BIOS_POST_TIMEOUT = "bios-post-timeout"
    OPERABILITY_CHASSIS_LIMIT_EXCEEDED = "chassis-limit-exceeded"
    OPERABILITY_CONFIG = "config"
    OPERABILITY_DECOMISSIONING = "decomissioning"
    OPERABILITY_DEGRADED = "degraded"
    OPERABILITY_DISABLED = "disabled"
    OPERABILITY_DISCOVERY = "discovery"
    OPERABILITY_DISCOVERY_FAILED = "discovery-failed"
    OPERABILITY_EQUIPMENT_PROBLEM = "equipment-problem"
    OPERABILITY_FABRIC_CONN_PROBLEM = "fabric-conn-problem"
    OPERABILITY_FABRIC_UNSUPPORTED_CONN = "fabric-unsupported-conn"
    OPERABILITY_IDENTIFY = "identify"
    OPERABILITY_IDENTITY_UNESTABLISHABLE = "identity-unestablishable"
    OPERABILITY_INOPERABLE = "inoperable"
    OPERABILITY_LINK_ACTIVATE_BLOCKED = "link-activate-blocked"
    OPERABILITY_MALFORMED_FRU = "malformed-fru"
    OPERABILITY_NOT_SUPPORTED = "not-supported"
    OPERABILITY_OPERABLE = "operable"
    OPERABILITY_PEER_COMM_PROBLEM = "peer-comm-problem"
    OPERABILITY_PERFORMANCE_PROBLEM = "performance-problem"
    OPERABILITY_POST_FAILURE = "post-failure"
    OPERABILITY_POWER_PROBLEM = "power-problem"
    OPERABILITY_POWERED_OFF = "powered-off"
    OPERABILITY_REMOVED = "removed"
    OPERABILITY_THERMAL_PROBLEM = "thermal-problem"
    OPERABILITY_UNKNOWN = "unknown"
    OPERABILITY_UPGRADE_PROBLEM = "upgrade-problem"
    OPERABILITY_VOLTAGE_PROBLEM = "voltage-problem"
    POLICY_OWNER_LOCAL = "local"
    POLICY_OWNER_PENDING_POLICY = "pending-policy"
    POLICY_OWNER_POLICY = "policy"
    PRESENCE_EMPTY = "empty"
    PRESENCE_EQUIPPED = "equipped"
    PRESENCE_EQUIPPED_DEPRECATED = "equipped-deprecated"
    PRESENCE_EQUIPPED_IDENTITY_UNESTABLISHABLE = "equipped-identity-unestablishable"
    PRESENCE_EQUIPPED_NOT_PRIMARY = "equipped-not-primary"
    PRESENCE_EQUIPPED_SLAVE = "equipped-slave"
    PRESENCE_EQUIPPED_UNSUPPORTED = "equipped-unsupported"
    PRESENCE_EQUIPPED_WITH_MALFORMED_FRU = "equipped-with-malformed-fru"
    PRESENCE_INACCESSIBLE = "inaccessible"
    PRESENCE_MISMATCH = "mismatch"
    PRESENCE_MISMATCH_IDENTITY_UNESTABLISHABLE = "mismatch-identity-unestablishable"
    PRESENCE_MISMATCH_SLAVE = "mismatch-slave"
    PRESENCE_MISSING = "missing"
    PRESENCE_MISSING_SLAVE = "missing-slave"
    PRESENCE_UNAUTHORIZED = "unauthorized"
    PRESENCE_UNKNOWN = "unknown"
    VERSION_HOLDER_FALSE = "false"
    VERSION_HOLDER_NO = "no"
    VERSION_HOLDER_TRUE = "true"
    VERSION_HOLDER_YES = "yes"


class ComputeRackUnit(ManagedObject):
    """This is ComputeRackUnit class."""

    consts = ComputeRackUnitConsts()
    naming_props = set([u'id'])

    mo_meta = MoMeta("ComputeRackUnit", "computeRackUnit", "rack-unit-[id]", VersionMeta.Version141i, "InputOutput", 0xfff, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'topSystem'], [u'aaaEpAuthProfile', u'aaaEpUser', u'adaptorHostIfConfig', u'adaptorUnit', u'biosUnit', u'biosVIdentityParams', u'cimcvmediaMountConfigDef', u'computeBoard', u'computeBoardController', u'computeExtBoard', u'computeFactoryResetOperation', u'computeFwSyncAck', u'computeKvmMgmtPolicy', u'computeMemoryConfiguration', u'computePhysicalFsm', u'computePhysicalFsmTask', u'computePnuOSImage', u'computePoolable', u'computeRackUnitFsm', u'computeRackUnitFsmTask', u'computeScrubPolicy', u'diagSrvCtrl', u'equipmentBeaconLed', u'equipmentFanModule', u'equipmentHealthLed', u'equipmentIOExpander', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'equipmentPOST', u'equipmentPsu', u'eventInst', u'fabricLocale', u'faultInst', u'faultSuppressTask', u'firmwareImageLock', u'firmwareStatus', u'lsIdentityInfo', u'lsbootDef', u'mgmtController', u'osAgent', u'osInstance', u'pciEquipSlot', u'pciUnit', u'powerBudget', u'solIf', u'storageEnclosure', u'storageVirtualDriveContainer'], ["Get", "Set"])

    prop_meta = {
        "admin_power": MoPropertyMeta("admin_power", "adminPower", "string", VersionMeta.Version141i, MoPropertyMeta.READ_WRITE, 0x2, None, None, None, ["admin-down", "admin-up", "bmc-reset-immediate", "bmc-reset-wait", "cmos-reset-immediate", "cycle-immediate", "cycle-wait", "diagnostic-interrupt", "hard-reset-immediate", "hard-reset-wait", "ipmi-reset", "kvm-reset", "policy"], []), 
        "admin_state": MoPropertyMeta("admin_state", "adminState", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, ["in-maintenance", "in-service", "out-of-service"], []), 
        "assigned_to_dn": MoPropertyMeta("assigned_to_dn", "assignedToDn", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, 0, 256, None, [], []), 
        "association": MoPropertyMeta("association", "association", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, ["associated", "establishing", "failed", "none", "removing", "throttled"], []), 
        "availability": MoPropertyMeta("availability", "availability", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, ["available", "unavailable"], []), 
        "available_memory": MoPropertyMeta("available_memory", "availableMemory", "uint", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "check_point": MoPropertyMeta("check_point", "checkPoint", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, ["deep-checkpoint", "discovered", "removing", "shallow-checkpoint", "unknown"], []), 
        "child_action": MoPropertyMeta("child_action", "childAction", "string", VersionMeta.Version141i, MoPropertyMeta.INTERNAL, 0x4, None, None, r"""((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], []), 
        "conn_path": MoPropertyMeta("conn_path", "connPath", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, r"""((defaultValue|unknown|A|B),){0,3}(defaultValue|unknown|A|B){0,1}""", [], []), 
        "conn_status": MoPropertyMeta("conn_status", "connStatus", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, r"""((defaultValue|unknown|A|B),){0,3}(defaultValue|unknown|A|B){0,1}""", [], []), 
        "descr": MoPropertyMeta("descr", "descr", "string", VersionMeta.Version141i, MoPropertyMeta.READ_WRITE, 0x8, None, None, r"""[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], []), 
        "discovery": MoPropertyMeta("discovery", "discovery", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, ["complete", "diagnostics-complete", "diagnostics-failed", "diagnostics-in-progress", "efidiagnostics-in-progress", "failed", "fru-identity-indeterminate", "fru-not-ready", "fru-state-indeterminate", "illegal-fru", "in-progress", "insufficiently-equipped", "invalid-adaptor-iocard", "malformed-fru-info", "retry", "throttled", "undiscovered", "user-acknowledged", "waiting-for-mgmt-ack", "waiting-for-user-ack"], []), 
        "discovery_status": MoPropertyMeta("discovery_status", "discoveryStatus", "string", VersionMeta.Version251a, MoPropertyMeta.READ_ONLY, None, None, None, r"""((defaultValue|unknown|A|B),){0,3}(defaultValue|unknown|A|B){0,1}""", [], []), 
        "dn": MoPropertyMeta("dn", "dn", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, 0x10, 0, 256, None, [], []), 
        "fan_speed_config_status": MoPropertyMeta("fan_speed_config_status", "fanSpeedConfigStatus", "string", VersionMeta.Version226a, MoPropertyMeta.READ_ONLY, None, 0, 510, None, [], []), 
        "fan_speed_policy_fault": MoPropertyMeta("fan_speed_policy_fault", "fanSpeedPolicyFault", "string", VersionMeta.Version226a, MoPropertyMeta.READ_ONLY, None, None, None, None, ["no", "yes"], []), 
        "flt_aggr": MoPropertyMeta("flt_aggr", "fltAggr", "ulong", VersionMeta.Version141i, MoPropertyMeta.INTERNAL, None, None, None, None, [], []), 
        "fsm_descr": MoPropertyMeta("fsm_descr", "fsmDescr", "string", VersionMeta.Version141i, MoPropertyMeta.INTERNAL, None, None, None, None, [], []), 
        "fsm_flags": MoPropertyMeta("fsm_flags", "fsmFlags", "string", VersionMeta.Version141i, MoPropertyMeta.INTERNAL, None, None, None, None, [], ["0-4294967295"]), 
        "fsm_prev": MoPropertyMeta("fsm_prev", "fsmPrev", "string", VersionMeta.Version141i, MoPropertyMeta.INTERNAL, None, None, None, None, ["ActivateAdaptorActivateLocal", "ActivateAdaptorActivatePeer", "ActivateAdaptorBegin", "ActivateAdaptorCheckPowerAvailability", "ActivateAdaptorDeassertResetBypass", "ActivateAdaptorFail", "ActivateAdaptorPowerDeployWait", "ActivateAdaptorPowerOn", "ActivateAdaptorReset", "ActivateAdaptorSuccess", "ActivateBIOSActivate", "ActivateBIOSBegin", "ActivateBIOSCheckPowerAvailability", "ActivateBIOSClear", "ActivateBIOSFail", "ActivateBIOSPollActivateStatus", "ActivateBIOSPollClearStatus", "ActivateBIOSPowerDeployWait", "ActivateBIOSPowerOff", "ActivateBIOSPowerOn", "ActivateBIOSSuccess", "ActivateBIOSUpdateTokens", "AdapterResetBegin", "AdapterResetDeassertResetBypass", "AdapterResetFail", "AdapterResetPowerCycle", "AdapterResetPreSanitize", "AdapterResetSanitize", "AdapterResetSuccess", "AssociateActivateAdaptorNwFwLocal", "AssociateActivateAdaptorNwFwPeer", "AssociateActivateBios", "AssociateActivateIBMCFw", "AssociateBegin", "AssociateBiosImgUpdate", "AssociateBiosPostCompletion", "AssociateBladePowerOff", "AssociateBmcConfigPnuOS", "AssociateBmcPreconfigPnuOSLocal", "AssociateBmcPreconfigPnuOSPeer", "AssociateBmcUnconfigPnuOS", "AssociateBootHost", "AssociateBootPnuos", "AssociateBootWait", "AssociateCalculateVlanGroupForHostOSLocal", "AssociateCalculateVlanGroupForHostOSPeer", "AssociateCheckPowerAvailability", "AssociateCiscoOSOpenGate", "AssociateClearBiosUpdate", "AssociateConfigCimcVMedia", "AssociateConfigExtMgmtGw", "AssociateConfigExtMgmtRules", "AssociateConfigFanSpeed", "AssociateConfigFlexFlash", "AssociateConfigSoL", "AssociateConfigUserAccess", "AssociateConfigUuid", "AssociateCopyRemote", "AssociateDeassertResetBypass", "AssociateDeleteCurlDownloadedImages", "AssociateDeleteImagesRemote", "AssociateDownloadImages", "AssociateFail", "AssociateGraphicsImageUpdate", "AssociateHagHostOSConnect", "AssociateHagPnuOSConnect", "AssociateHagPnuOSDisconnect", "AssociateHbaImgUpdate", "AssociateHostOSConfig", "AssociateHostOSIdent", "AssociateHostOSPolicy", "AssociateHostOSValidate", "AssociateLocalDiskFwUpdate", "AssociateMarkAdapterForReboot", "AssociateNicConfigHostOSLocal", "AssociateNicConfigHostOSPeer", "AssociateNicConfigParamsHostOSLocal", "AssociateNicConfigParamsHostOSPeer", "AssociateNicConfigPnuOSLocal", "AssociateNicConfigPnuOSPeer", "AssociateNicConfigServiceInfraLocal", "AssociateNicConfigServiceInfraPeer", "AssociateNicImgUpdate", "AssociateNicUnconfigPnuOSLocal", "AssociateNicUnconfigPnuOSPeer", "AssociateOobPollSasExpanderActivateStatus", "AssociateOobPollSasExpanderUpdateStatus", "AssociateOobSasExpanderImgActivate", "AssociateOobSasExpanderImgUpdate", "AssociateOobStorageConfig", "AssociateOobStorageInventory", "AssociatePnuOSCatalog", "AssociatePnuOSConfig", "AssociatePnuOSIdent", "AssociatePnuOSInventory", "AssociatePnuOSLocalDiskConfig", "AssociatePnuOSPolicy", "AssociatePnuOSSelfTest", "AssociatePnuOSUnloadDrivers", "AssociatePnuOSValidate", "AssociatePollBiosActivateStatus", "AssociatePollBiosUpdateStatus", "AssociatePollBoardCtrlPowerCycle", "AssociatePollBoardCtrlUpdateStatus", "AssociatePollClearBiosUpdateStatus", "AssociatePowerCycleBoard", "AssociatePowerDeployWait", "AssociatePowerOn", "AssociatePowerOnPreConfig", "AssociatePreSanitize", "AssociatePrepareForBoot", "AssociateResetIBMC", "AssociateSanitize", "AssociateSasExpanderImgUpdate", "AssociateSerialDebugPnuOSConnect", "AssociateSerialDebugPnuOSDisconnect", "AssociateSolRedirectDisable", "AssociateSolRedirectEnable", "AssociateStorageCtlrImgUpdate", "AssociateSuccess", "AssociateSwConfigHostOSLocal", "AssociateSwConfigHostOSPeer", "AssociateSwConfigPnuOSLocal", "AssociateSwConfigPnuOSPeer", "AssociateSwConfigPortNivLocal", "AssociateSwConfigPortNivPeer", "AssociateSwConfigServiceInfraLocal", "AssociateSwConfigServiceInfraPeer", "AssociateSwUnconfigPnuOSLocal", "AssociateSwUnconfigPnuOSPeer", "AssociateSyncPowerState", "AssociateUnconfigCimcVMedia", "AssociateUnconfigExtMgmtGw", "AssociateUnconfigExtMgmtRules", "AssociateUnlockFirmwareImage", "AssociateUpdateAdaptorNwFwLocal", "AssociateUpdateAdaptorNwFwPeer", "AssociateUpdateBiosRequest", "AssociateUpdateBoardCtrlRequest", "AssociateUpdateIBMCFw", "AssociateVerifyFcZoneConfig", "AssociateWaitForAdaptorNwFwUpdateLocal", "AssociateWaitForAdaptorNwFwUpdatePeer", "AssociateWaitForIBMCFwUpdate", "BiosRecoveryBegin", "BiosRecoveryCheckPowerAvailability", "BiosRecoveryCleanup", "BiosRecoveryFail", "BiosRecoveryPowerDeployWait", "BiosRecoveryPreSanitize", "BiosRecoveryReset", "BiosRecoverySanitize", "BiosRecoverySetupVmediaLocal", "BiosRecoverySetupVmediaPeer", "BiosRecoveryShutdown", "BiosRecoveryStart", "BiosRecoveryStopVMediaLocal", "BiosRecoveryStopVMediaPeer", "BiosRecoverySuccess", "BiosRecoveryTeardownVmediaLocal", "BiosRecoveryTeardownVmediaPeer", "BiosRecoveryWait", "CimcSessionDeleteBegin", "CimcSessionDeleteExecute", "CimcSessionDeleteFail", "CimcSessionDeleteSuccess", "CmosResetBegin", "CmosResetBladePowerOn", "CmosResetCheckPowerAvailability", "CmosResetExecute", "CmosResetFail", "CmosResetPowerDeployWait", "CmosResetPreSanitize", "CmosResetReconfigBios", "CmosResetReconfigUuid", "CmosResetSanitize", "CmosResetSuccess", "ConfigBoardBegin", "ConfigBoardConfigMemoryPolicy", "ConfigBoardFail", "ConfigBoardSuccess", "ConfigSoLBegin", "ConfigSoLExecute", "ConfigSoLFail", "ConfigSoLSuccess", "CreateDhcpEntryBegin", "CreateDhcpEntryExecuteLocal", "CreateDhcpEntryExecutePeer", "CreateDhcpEntryFail", "CreateDhcpEntrySuccess", "DecommissionBegin", "DecommissionCleanupCIMC", "DecommissionCleanupPortConfigLocal", "DecommissionCleanupPortConfigPeer", "DecommissionExecute", "DecommissionFail", "DecommissionPrecleanupPortConfig", "DecommissionStopVMediaLocal", "DecommissionStopVMediaPeer", "DecommissionSuccess", "DecommissionUnconfigExtMgmtGw", "DecommissionUnconfigExtMgmtRules", "DiagnosticInterruptBegin", "DiagnosticInterruptExecute", "DiagnosticInterruptFail", "DiagnosticInterruptSuccess", "DisassociateBegin", "DisassociateBiosPostCompletion", "DisassociateBmcConfigPnuOS", "DisassociateBmcPreconfigPnuOSLocal", "DisassociateBmcPreconfigPnuOSPeer", "DisassociateBmcUnconfigPnuOS", "DisassociateBootPnuos", "DisassociateBootWait", "DisassociateCheckPowerAvailability", "DisassociateConfigBios", "DisassociateConfigFlexFlashScrub", "DisassociateConfigKvmMgmtDefaultSetting", "DisassociateConfigUserAccess", "DisassociateDeassertResetBypass", "DisassociateFail", "DisassociateHagPnuOSConnect", "DisassociateHagPnuOSDisconnect", "DisassociateHandlePooling", "DisassociateNicConfigPnuOSLocal", "DisassociateNicConfigPnuOSPeer", "DisassociateNicUnconfigHostOSLocal", "DisassociateNicUnconfigHostOSPeer", "DisassociateNicUnconfigPnuOSLocal", "DisassociateNicUnconfigPnuOSPeer", "DisassociateNicUnconfigServiceInfraLocal", "DisassociateNicUnconfigServiceInfraPeer", "DisassociateOobDiskScrub", "DisassociatePnuOSCatalog", "DisassociatePnuOSIdent", "DisassociatePnuOSPolicy", "DisassociatePnuOSScrub", "DisassociatePnuOSSelfTest", "DisassociatePnuOSUnconfig", "DisassociatePnuOSValidate", "DisassociatePowerDeployWait", "DisassociatePowerOn", "DisassociatePreSanitize", "DisassociateResetSecureBootConfig", "DisassociateSanitize", "DisassociateSerialDebugPnuOSConnect", "DisassociateSerialDebugPnuOSDisconnect", "DisassociateShutdown", "DisassociateSolRedirectDisable", "DisassociateSolRedirectEnable", "DisassociateSuccess", "DisassociateSwConfigPnuOSLocal", "DisassociateSwConfigPnuOSPeer", "DisassociateSwConfigPortNivLocal", "DisassociateSwConfigPortNivPeer", "DisassociateSwUnconfigHostOSLocal", "DisassociateSwUnconfigHostOSPeer", "DisassociateSwUnconfigPnuOSLocal", "DisassociateSwUnconfigPnuOSPeer", "DisassociateUnconfigBios", "DisassociateUnconfigCimcVMedia", "DisassociateUnconfigExtMgmtGw", "DisassociateUnconfigExtMgmtRules", "DisassociateUnconfigFlexFlash", "DisassociateUnconfigSoL", "DisassociateUnconfigUuid", "DisassociateVerifyFcZoneConfig", "DiscoverBegin", "DiscoverBiosPostCompletion", "DiscoverBladePowerOff", "DiscoverBmcConfigPnuOS", "DiscoverBmcConfigureConnLocal", "DiscoverBmcConfigureConnPeer", "DiscoverBmcFactoryReset", "DiscoverBmcInventory", "DiscoverBmcPreconfigPnuOSLocal", "DiscoverBmcPreconfigPnuOSPeer", "DiscoverBmcPresence", "DiscoverBmcShutdownDiscovered", "DiscoverBmcUnconfigPnuOS", "DiscoverBootPnuos", "DiscoverBootWait", "DiscoverCheckPowerAvailability", "DiscoverConfigDiscoveryMode", "DiscoverConfigFlexFlashScrub", "DiscoverConfigNivMode", "DiscoverConfigUserAccess", "DiscoverFail", "DiscoverHagConnect", "DiscoverHagDisconnect", "DiscoverHandlePooling", "DiscoverNicConfigPnuOSLocal", "DiscoverNicConfigPnuOSPeer", "DiscoverNicInventoryLocal", "DiscoverNicInventoryPeer", "DiscoverOobStorageInventory", "DiscoverPnuOSCatalog", "DiscoverPnuOSConnStatus", "DiscoverPnuOSConnectivity", "DiscoverPnuOSIdent", "DiscoverPnuOSInventory", "DiscoverPnuOSPolicy", "DiscoverPnuOSScrub", "DiscoverPnuOSSelfTest", "DiscoverPowerDeployWait", "DiscoverPreSanitize", "DiscoverReadSmbios", "DiscoverSanitize", "DiscoverSerialDebugConnect", "DiscoverSerialDebugDisconnect", "DiscoverSolRedirectDisable", "DiscoverSolRedirectEnable", "DiscoverSuccess", "DiscoverSwConfigPnuOSLocal", "DiscoverSwConfigPnuOSPeer", "DiscoverSwConfigPortNivLocal", "DiscoverSwConfigPortNivPeer", "DiscoverSwConfigureConnLocal", "DiscoverSwConfigureConnPeer", "DiscoverSwPnuOSConnectivityLocal", "DiscoverSwPnuOSConnectivityPeer", "DiscoverSwUnconfigPortNivLocal", "DiscoverSwUnconfigPortNivPeer", "DiscoverUnconfigCimcVMedia", "DiscoverUnconfigExtMgmtGw", "DiscoverUnconfigExtMgmtRules", "DiscoverWaitForConnReady", "DiskZoningInventoryBegin", "DiskZoningInventoryBootHost", "DiskZoningInventoryBootWait", "DiskZoningInventoryFail", "DiskZoningInventoryPreSanitize", "DiskZoningInventorySanitize", "DiskZoningInventoryShutdown", "DiskZoningInventoryStorageInventory", "DiskZoningInventorySuccess", "EnableCimcSecureBootActivate", "EnableCimcSecureBootBegin", "EnableCimcSecureBootFail", "EnableCimcSecureBootPollUpdateStatus", "EnableCimcSecureBootReset", "EnableCimcSecureBootSuccess", "EnableCimcSecureBootUpdateRequest", "FlashControllerBegin", "FlashControllerFail", "FlashControllerSuccess", "FlashControllerUpdateFlashLife", "FwUpgradeActivateAdaptorNwFwLocal", "FwUpgradeActivateAdaptorNwFwPeer", "FwUpgradeActivateBios", "FwUpgradeActivateIBMCFw", "FwUpgradeBegin", "FwUpgradeBiosImgUpdate", "FwUpgradeBiosPostCompletion", "FwUpgradeBladePowerOff", "FwUpgradeBmcConfigPnuOS", "FwUpgradeBmcPreconfigPnuOSLocal", "FwUpgradeBmcPreconfigPnuOSPeer", "FwUpgradeBmcUnconfigPnuOS", "FwUpgradeBootPnuos", "FwUpgradeBootWait", "FwUpgradeCheckPowerAvailability", "FwUpgradeCiscoOSOpenGate", "FwUpgradeClearBiosUpdate", "FwUpgradeCopyRemote", "FwUpgradeDeassertResetBypass", "FwUpgradeDeleteCurlDownloadedImages", "FwUpgradeDeleteImagesRemote", "FwUpgradeDownloadImages", "FwUpgradeFail", "FwUpgradeGraphicsImageUpdate", "FwUpgradeHagPnuOSConnect", "FwUpgradeHagPnuOSDisconnect", "FwUpgradeHbaImgUpdate", "FwUpgradeLocalDiskFwUpdate", "FwUpgradeNicConfigPnuOSLocal", "FwUpgradeNicConfigPnuOSPeer", "FwUpgradeNicImgUpdate", "FwUpgradeNicUnconfigPnuOSLocal", "FwUpgradeNicUnconfigPnuOSPeer", "FwUpgradeOobPollSasExpanderActivateStatus", "FwUpgradeOobPollSasExpanderUpdateStatus", "FwUpgradeOobSasExpanderImgActivate", "FwUpgradeOobSasExpanderImgUpdate", "FwUpgradeOobStorageInventory", "FwUpgradePnuOSCatalog", "FwUpgradePnuOSConfig", "FwUpgradePnuOSIdent", "FwUpgradePnuOSInventory", "FwUpgradePnuOSPolicy", "FwUpgradePnuOSSelfTest", "FwUpgradePnuOSUnloadDrivers", "FwUpgradePnuOSValidate", "FwUpgradePollBiosActivateStatus", "FwUpgradePollBiosUpdateStatus", "FwUpgradePollBoardCtrlPowerCycle", "FwUpgradePollBoardCtrlUpdateStatus", "FwUpgradePollClearBiosUpdateStatus", "FwUpgradePowerCycleBoard", "FwUpgradePowerDeployWait", "FwUpgradePowerOn", "FwUpgradePreSanitize", "FwUpgradeResetIBMC", "FwUpgradeSanitize", "FwUpgradeSasExpanderImgUpdate", "FwUpgradeSerialDebugPnuOSConnect", "FwUpgradeSerialDebugPnuOSDisconnect", "FwUpgradeShutdown", "FwUpgradeSolRedirectDisable", "FwUpgradeSolRedirectEnable", "FwUpgradeStorageCtlrImgUpdate", "FwUpgradeSuccess", "FwUpgradeSwConfigPnuOSLocal", "FwUpgradeSwConfigPnuOSPeer", "FwUpgradeSwConfigPortNivLocal", "FwUpgradeSwConfigPortNivPeer", "FwUpgradeSwUnconfigPnuOSLocal", "FwUpgradeSwUnconfigPnuOSPeer", "FwUpgradeUnconfigCimcVMedia", "FwUpgradeUnconfigExtMgmtGw", "FwUpgradeUnconfigExtMgmtRules", "FwUpgradeUnlockFirmwareImage", "FwUpgradeUpdateAdaptorNwFwLocal", "FwUpgradeUpdateAdaptorNwFwPeer", "FwUpgradeUpdateBiosRequest", "FwUpgradeUpdateBoardCtrlRequest", "FwUpgradeUpdateIBMCFw", "FwUpgradeWaitForAdaptorNwFwUpdateLocal", "FwUpgradeWaitForAdaptorNwFwUpdatePeer", "FwUpgradeWaitForIBMCFwUpdate", "HardShutdownBegin", "HardShutdownExecute", "HardShutdownFail", "HardShutdownSuccess", "HardresetBegin", "HardresetCheckPowerAvailability", "HardresetExecute", "HardresetFail", "HardresetPowerDeployWait", "HardresetPreSanitize", "HardresetSanitize", "HardresetSuccess", "OfflineBegin", "OfflineCleanupLocal", "OfflineCleanupPeer", "OfflineFail", "OfflineSuccess", "OfflineSwUnconfigureLocal", "OfflineSwUnconfigurePeer", "OobStorageAdminConfigBegin", "OobStorageAdminConfigBootHost", "OobStorageAdminConfigBootWait", "OobStorageAdminConfigFail", "OobStorageAdminConfigOobStorageConfig", "OobStorageAdminConfigOobStorageInventory", "OobStorageAdminConfigPreSanitize", "OobStorageAdminConfigSanitize", "OobStorageAdminConfigShutdown", "OobStorageAdminConfigSuccess", "OobStorageAdminConfigTearDownVMediaLocal", "OobStorageAdminConfigTearDownVMediaPeer", "PowerCapBegin", "PowerCapConfig", "PowerCapFail", "PowerCapSuccess", "PowercycleBegin", "PowercycleCheckPowerAvailability", "PowercycleExecute", "PowercycleFail", "PowercyclePowerDeployWait", "PowercyclePreSanitize", "PowercycleSanitize", "PowercycleSuccess", "ResetBmcBegin", "ResetBmcExecute", "ResetBmcFail", "ResetBmcSuccess", "ResetIpmiBegin", "ResetIpmiExecute", "ResetIpmiFail", "ResetIpmiSuccess", "ResetKvmBegin", "ResetKvmExecute", "ResetKvmFail", "ResetKvmSuccess", "ResetMemoryErrorsBegin", "ResetMemoryErrorsExecute", "ResetMemoryErrorsFail", "ResetMemoryErrorsSuccess", "ServiceInfraDeployBegin", "ServiceInfraDeployFail", "ServiceInfraDeployNicConfigLocal", "ServiceInfraDeployNicConfigPeer", "ServiceInfraDeploySuccess", "ServiceInfraDeploySwConfigLocal", "ServiceInfraDeploySwConfigPeer", "ServiceInfraWithdrawBegin", "ServiceInfraWithdrawFail", "ServiceInfraWithdrawNicUnConfigLocal", "ServiceInfraWithdrawNicUnConfigPeer", "ServiceInfraWithdrawSuccess", "ServiceInfraWithdrawSwUnConfigLocal", "ServiceInfraWithdrawSwUnConfigPeer", "SoftShutdownBegin", "SoftShutdownExecute", "SoftShutdownFail", "SoftShutdownSuccess", "SoftresetBegin", "SoftresetCheckPowerAvailability", "SoftresetExecute", "SoftresetFail", "SoftresetPowerDeployWait", "SoftresetPreSanitize", "SoftresetSanitize", "SoftresetSuccess", "SwConnUpdA", "SwConnUpdB", "SwConnUpdBegin", "SwConnUpdFail", "SwConnUpdSuccess", "TurnupBegin", "TurnupCheckPowerAvailability", "TurnupExecute", "TurnupFail", "TurnupPowerDeployWait", "TurnupSuccess", "UnconfigSoLBegin", "UnconfigSoLExecute", "UnconfigSoLFail", "UnconfigSoLSuccess", "UpdateAdaptorBegin", "UpdateAdaptorCheckPowerAvailability", "UpdateAdaptorFail", "UpdateAdaptorPollUpdateStatusLocal", "UpdateAdaptorPollUpdateStatusPeer", "UpdateAdaptorPowerDeployWait", "UpdateAdaptorPowerOff", "UpdateAdaptorPowerOn", "UpdateAdaptorSuccess", "UpdateAdaptorUpdateRequestLocal", "UpdateAdaptorUpdateRequestPeer", "UpdateBIOSBegin", "UpdateBIOSClear", "UpdateBIOSFail", "UpdateBIOSPollClearStatus", "UpdateBIOSPollUpdateStatus", "UpdateBIOSSuccess", "UpdateBIOSUpdateRequest", "UpdateBoardControllerBegin", "UpdateBoardControllerCheckPowerAvailability", "UpdateBoardControllerFail", "UpdateBoardControllerPollBoardCtrlPowerCycle", "UpdateBoardControllerPollUpdateStatus", "UpdateBoardControllerPowerCycleBoard", "UpdateBoardControllerPowerDeployWait", "UpdateBoardControllerPrepareForUpdate", "UpdateBoardControllerServerPowerOff", "UpdateBoardControllerServerPowerOn", "UpdateBoardControllerSuccess", "UpdateBoardControllerUpdateRequest", "clearTPMBegin", "clearTPMBiosPostCompletion", "clearTPMBladePowerOff", "clearTPMBladePowerOn", "clearTPMBootHost", "clearTPMClear", "clearTPMFail", "clearTPMPreSanitize", "clearTPMReadSmBios", "clearTPMReconfigBios", "clearTPMSanitize", "clearTPMSetupVmedia", "clearTPMStopVMediaLocal", "clearTPMStopVMediaPeer", "clearTPMSuccess", "clearTPMUnconfigVmedia", "nop", "updateExtUsersBegin", "updateExtUsersDeploy", "updateExtUsersFail", "updateExtUsersSuccess"], []), 
        "fsm_progr": MoPropertyMeta("fsm_progr", "fsmProgr", "byte", VersionMeta.Version141i, MoPropertyMeta.INTERNAL, None, None, None, None, [], ["0-100"]), 
        "fsm_rmt_inv_err_code": MoPropertyMeta("fsm_rmt_inv_err_code", "fsmRmtInvErrCode", "string", VersionMeta.Version141i, MoPropertyMeta.INTERNAL, None, None, None, None, ["ERR-2fa-auth-retry", "ERR-ACTIVATE-failed", "ERR-ACTIVATE-in-progress", "ERR-ACTIVATE-retry", "ERR-BIOS-TOKENS-OLD-BIOS", "ERR-BIOS-TOKENS-OLD-CIMC", "ERR-BIOS-network-boot-order-not-found", "ERR-BOARDCTRLUPDATE-ignore", "ERR-DIAG-cancelled", "ERR-DIAG-fsm-restarted", "ERR-DIAG-test-failed", "ERR-DNLD-authentication-failure", "ERR-DNLD-hostkey-mismatch", "ERR-DNLD-invalid-image", "ERR-DNLD-no-file", "ERR-DNLD-no-space", "ERR-DNLD-usb-unmounted", "ERR-DNS-delete-error", "ERR-DNS-get-error", "ERR-DNS-set-error", "ERR-Diagnostics-in-progress", "ERR-Diagnostics-memtest-in-progress", "ERR-Diagnostics-network-in-progress", "ERR-FILTER-illegal-format", "ERR-FSM-no-such-state", "ERR-HOST-fru-identity-mismatch", "ERR-HTTP-set-error", "ERR-HTTPS-set-error", "ERR-IBMC-analyze-results", "ERR-IBMC-connect-error", "ERR-IBMC-connector-info-retrieval-error", "ERR-IBMC-fru-retrieval-error", "ERR-IBMC-invalid-end-point-config", "ERR-IBMC-results-not-ready", "ERR-MAX-subscriptions-allowed-error", "ERR-MO-CONFIG-child-object-cant-be-configured", "ERR-MO-META-no-such-object-class", "ERR-MO-PROPERTY-no-such-property", "ERR-MO-PROPERTY-value-out-of-range", "ERR-MO-access-denied", "ERR-MO-deletion-rule-violation", "ERR-MO-duplicate-object", "ERR-MO-illegal-containment", "ERR-MO-illegal-creation", "ERR-MO-illegal-iterator-state", "ERR-MO-illegal-object-lifecycle-transition", "ERR-MO-naming-rule-violation", "ERR-MO-object-not-found", "ERR-MO-resource-allocation", "ERR-NTP-delete-error", "ERR-NTP-get-error", "ERR-NTP-set-error", "ERR-POWER-CAP-UNSUPPORTED", "ERR-POWER-PROFILE-IN-PROGRESS", "ERR-SERVER-mis-connect", "ERR-SWITCH-invalid-if-config", "ERR-TOKEN-request-denied", "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS", "ERR-UPDATE-failed", "ERR-UPDATE-in-progress", "ERR-UPDATE-retry", "ERR-aaa-config-modify-error", "ERR-acct-realm-set-error", "ERR-admin-passwd-set", "ERR-auth-issue", "ERR-auth-realm-get-error", "ERR-auth-realm-set-error", "ERR-authentication", "ERR-authorization-required", "ERR-cli-session-limit-reached", "ERR-create-keyring", "ERR-create-locale", "ERR-create-role", "ERR-create-tp", "ERR-create-user", "ERR-delete-locale", "ERR-delete-role", "ERR-delete-session", "ERR-delete-user", "ERR-downgrade-fail", "ERR-efi-Diagnostics--in-progress", "ERR-enable-mgmt-conn", "ERR-ep-set-error", "ERR-get-max-http-user-sessions", "ERR-http-initializing", "ERR-insufficiently-equipped", "ERR-internal-error", "ERR-ldap-delete-error", "ERR-ldap-get-error", "ERR-ldap-group-modify-error", "ERR-ldap-group-set-error", "ERR-ldap-set-error", "ERR-locale-set-error", "ERR-max-userid-sessions-reached", "ERR-missing-method", "ERR-modify-locale", "ERR-modify-role", "ERR-modify-user", "ERR-modify-user-locale", "ERR-modify-user-role", "ERR-provider-group-modify-error", "ERR-provider-group-set-error", "ERR-radius-get-error", "ERR-radius-global-set-error", "ERR-radius-group-set-error", "ERR-radius-set-error", "ERR-request-timeout", "ERR-reset-adapter", "ERR-role-set-error", "ERR-secondary-node", "ERR-service-not-ready", "ERR-session-cache-full", "ERR-session-not-found", "ERR-set-min-passphrase-length", "ERR-set-network", "ERR-set-password-strength-check", "ERR-set-port-channel", "ERR-store-pre-login-banner-msg", "ERR-tacacs-enable-error", "ERR-tacacs-global-set-error", "ERR-tacacs-group-set-error", "ERR-tacacs-plus-get-error", "ERR-tacacs-set-error", "ERR-test-error-1", "ERR-test-error-2", "ERR-timezone-set-error", "ERR-user-account-expired", "ERR-user-set-error", "ERR-xml-parse-error", "none"], ["0-4294967295"]), 
        "fsm_rmt_inv_err_descr": MoPropertyMeta("fsm_rmt_inv_err_descr", "fsmRmtInvErrDescr", "string", VersionMeta.Version141i, MoPropertyMeta.INTERNAL, None, 0, 510, None, [], []), 
        "fsm_rmt_inv_rslt": MoPropertyMeta("fsm_rmt_inv_rslt", "fsmRmtInvRslt", "string", VersionMeta.Version141i, MoPropertyMeta.INTERNAL, None, None, None, r"""((defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout),){0,32}(defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout){0,1}""", [], []), 
        "fsm_stage_descr": MoPropertyMeta("fsm_stage_descr", "fsmStageDescr", "string", VersionMeta.Version141i, MoPropertyMeta.INTERNAL, None, None, None, None, [], []), 
        "fsm_stamp": MoPropertyMeta("fsm_stamp", "fsmStamp", "string", VersionMeta.Version141i, MoPropertyMeta.INTERNAL, None, None, None, r"""([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", ["never"], []), 
        "fsm_status": MoPropertyMeta("fsm_status", "fsmStatus", "string", VersionMeta.Version141i, MoPropertyMeta.INTERNAL, None, None, None, None, ["ActivateAdaptorActivateLocal", "ActivateAdaptorActivatePeer", "ActivateAdaptorBegin", "ActivateAdaptorCheckPowerAvailability", "ActivateAdaptorDeassertResetBypass", "ActivateAdaptorFail", "ActivateAdaptorPowerDeployWait", "ActivateAdaptorPowerOn", "ActivateAdaptorReset", "ActivateAdaptorSuccess", "ActivateBIOSActivate", "ActivateBIOSBegin", "ActivateBIOSCheckPowerAvailability", "ActivateBIOSClear", "ActivateBIOSFail", "ActivateBIOSPollActivateStatus", "ActivateBIOSPollClearStatus", "ActivateBIOSPowerDeployWait", "ActivateBIOSPowerOff", "ActivateBIOSPowerOn", "ActivateBIOSSuccess", "ActivateBIOSUpdateTokens", "AdapterResetBegin", "AdapterResetDeassertResetBypass", "AdapterResetFail", "AdapterResetPowerCycle", "AdapterResetPreSanitize", "AdapterResetSanitize", "AdapterResetSuccess", "AssociateActivateAdaptorNwFwLocal", "AssociateActivateAdaptorNwFwPeer", "AssociateActivateBios", "AssociateActivateIBMCFw", "AssociateBegin", "AssociateBiosImgUpdate", "AssociateBiosPostCompletion", "AssociateBladePowerOff", "AssociateBmcConfigPnuOS", "AssociateBmcPreconfigPnuOSLocal", "AssociateBmcPreconfigPnuOSPeer", "AssociateBmcUnconfigPnuOS", "AssociateBootHost", "AssociateBootPnuos", "AssociateBootWait", "AssociateCalculateVlanGroupForHostOSLocal", "AssociateCalculateVlanGroupForHostOSPeer", "AssociateCheckPowerAvailability", "AssociateCiscoOSOpenGate", "AssociateClearBiosUpdate", "AssociateConfigCimcVMedia", "AssociateConfigExtMgmtGw", "AssociateConfigExtMgmtRules", "AssociateConfigFanSpeed", "AssociateConfigFlexFlash", "AssociateConfigSoL", "AssociateConfigUserAccess", "AssociateConfigUuid", "AssociateCopyRemote", "AssociateDeassertResetBypass", "AssociateDeleteCurlDownloadedImages", "AssociateDeleteImagesRemote", "AssociateDownloadImages", "AssociateFail", "AssociateGraphicsImageUpdate", "AssociateHagHostOSConnect", "AssociateHagPnuOSConnect", "AssociateHagPnuOSDisconnect", "AssociateHbaImgUpdate", "AssociateHostOSConfig", "AssociateHostOSIdent", "AssociateHostOSPolicy", "AssociateHostOSValidate", "AssociateLocalDiskFwUpdate", "AssociateMarkAdapterForReboot", "AssociateNicConfigHostOSLocal", "AssociateNicConfigHostOSPeer", "AssociateNicConfigParamsHostOSLocal", "AssociateNicConfigParamsHostOSPeer", "AssociateNicConfigPnuOSLocal", "AssociateNicConfigPnuOSPeer", "AssociateNicConfigServiceInfraLocal", "AssociateNicConfigServiceInfraPeer", "AssociateNicImgUpdate", "AssociateNicUnconfigPnuOSLocal", "AssociateNicUnconfigPnuOSPeer", "AssociateOobPollSasExpanderActivateStatus", "AssociateOobPollSasExpanderUpdateStatus", "AssociateOobSasExpanderImgActivate", "AssociateOobSasExpanderImgUpdate", "AssociateOobStorageConfig", "AssociateOobStorageInventory", "AssociatePnuOSCatalog", "AssociatePnuOSConfig", "AssociatePnuOSIdent", "AssociatePnuOSInventory", "AssociatePnuOSLocalDiskConfig", "AssociatePnuOSPolicy", "AssociatePnuOSSelfTest", "AssociatePnuOSUnloadDrivers", "AssociatePnuOSValidate", "AssociatePollBiosActivateStatus", "AssociatePollBiosUpdateStatus", "AssociatePollBoardCtrlPowerCycle", "AssociatePollBoardCtrlUpdateStatus", "AssociatePollClearBiosUpdateStatus", "AssociatePowerCycleBoard", "AssociatePowerDeployWait", "AssociatePowerOn", "AssociatePowerOnPreConfig", "AssociatePreSanitize", "AssociatePrepareForBoot", "AssociateResetIBMC", "AssociateSanitize", "AssociateSasExpanderImgUpdate", "AssociateSerialDebugPnuOSConnect", "AssociateSerialDebugPnuOSDisconnect", "AssociateSolRedirectDisable", "AssociateSolRedirectEnable", "AssociateStorageCtlrImgUpdate", "AssociateSuccess", "AssociateSwConfigHostOSLocal", "AssociateSwConfigHostOSPeer", "AssociateSwConfigPnuOSLocal", "AssociateSwConfigPnuOSPeer", "AssociateSwConfigPortNivLocal", "AssociateSwConfigPortNivPeer", "AssociateSwConfigServiceInfraLocal", "AssociateSwConfigServiceInfraPeer", "AssociateSwUnconfigPnuOSLocal", "AssociateSwUnconfigPnuOSPeer", "AssociateSyncPowerState", "AssociateUnconfigCimcVMedia", "AssociateUnconfigExtMgmtGw", "AssociateUnconfigExtMgmtRules", "AssociateUnlockFirmwareImage", "AssociateUpdateAdaptorNwFwLocal", "AssociateUpdateAdaptorNwFwPeer", "AssociateUpdateBiosRequest", "AssociateUpdateBoardCtrlRequest", "AssociateUpdateIBMCFw", "AssociateVerifyFcZoneConfig", "AssociateWaitForAdaptorNwFwUpdateLocal", "AssociateWaitForAdaptorNwFwUpdatePeer", "AssociateWaitForIBMCFwUpdate", "BiosRecoveryBegin", "BiosRecoveryCheckPowerAvailability", "BiosRecoveryCleanup", "BiosRecoveryFail", "BiosRecoveryPowerDeployWait", "BiosRecoveryPreSanitize", "BiosRecoveryReset", "BiosRecoverySanitize", "BiosRecoverySetupVmediaLocal", "BiosRecoverySetupVmediaPeer", "BiosRecoveryShutdown", "BiosRecoveryStart", "BiosRecoveryStopVMediaLocal", "BiosRecoveryStopVMediaPeer", "BiosRecoverySuccess", "BiosRecoveryTeardownVmediaLocal", "BiosRecoveryTeardownVmediaPeer", "BiosRecoveryWait", "CimcSessionDeleteBegin", "CimcSessionDeleteExecute", "CimcSessionDeleteFail", "CimcSessionDeleteSuccess", "CmosResetBegin", "CmosResetBladePowerOn", "CmosResetCheckPowerAvailability", "CmosResetExecute", "CmosResetFail", "CmosResetPowerDeployWait", "CmosResetPreSanitize", "CmosResetReconfigBios", "CmosResetReconfigUuid", "CmosResetSanitize", "CmosResetSuccess", "ConfigBoardBegin", "ConfigBoardConfigMemoryPolicy", "ConfigBoardFail", "ConfigBoardSuccess", "ConfigSoLBegin", "ConfigSoLExecute", "ConfigSoLFail", "ConfigSoLSuccess", "CreateDhcpEntryBegin", "CreateDhcpEntryExecuteLocal", "CreateDhcpEntryExecutePeer", "CreateDhcpEntryFail", "CreateDhcpEntrySuccess", "DecommissionBegin", "DecommissionCleanupCIMC", "DecommissionCleanupPortConfigLocal", "DecommissionCleanupPortConfigPeer", "DecommissionExecute", "DecommissionFail", "DecommissionPrecleanupPortConfig", "DecommissionStopVMediaLocal", "DecommissionStopVMediaPeer", "DecommissionSuccess", "DecommissionUnconfigExtMgmtGw", "DecommissionUnconfigExtMgmtRules", "DiagnosticInterruptBegin", "DiagnosticInterruptExecute", "DiagnosticInterruptFail", "DiagnosticInterruptSuccess", "DisassociateBegin", "DisassociateBiosPostCompletion", "DisassociateBmcConfigPnuOS", "DisassociateBmcPreconfigPnuOSLocal", "DisassociateBmcPreconfigPnuOSPeer", "DisassociateBmcUnconfigPnuOS", "DisassociateBootPnuos", "DisassociateBootWait", "DisassociateCheckPowerAvailability", "DisassociateConfigBios", "DisassociateConfigFlexFlashScrub", "DisassociateConfigKvmMgmtDefaultSetting", "DisassociateConfigUserAccess", "DisassociateDeassertResetBypass", "DisassociateFail", "DisassociateHagPnuOSConnect", "DisassociateHagPnuOSDisconnect", "DisassociateHandlePooling", "DisassociateNicConfigPnuOSLocal", "DisassociateNicConfigPnuOSPeer", "DisassociateNicUnconfigHostOSLocal", "DisassociateNicUnconfigHostOSPeer", "DisassociateNicUnconfigPnuOSLocal", "DisassociateNicUnconfigPnuOSPeer", "DisassociateNicUnconfigServiceInfraLocal", "DisassociateNicUnconfigServiceInfraPeer", "DisassociateOobDiskScrub", "DisassociatePnuOSCatalog", "DisassociatePnuOSIdent", "DisassociatePnuOSPolicy", "DisassociatePnuOSScrub", "DisassociatePnuOSSelfTest", "DisassociatePnuOSUnconfig", "DisassociatePnuOSValidate", "DisassociatePowerDeployWait", "DisassociatePowerOn", "DisassociatePreSanitize", "DisassociateResetSecureBootConfig", "DisassociateSanitize", "DisassociateSerialDebugPnuOSConnect", "DisassociateSerialDebugPnuOSDisconnect", "DisassociateShutdown", "DisassociateSolRedirectDisable", "DisassociateSolRedirectEnable", "DisassociateSuccess", "DisassociateSwConfigPnuOSLocal", "DisassociateSwConfigPnuOSPeer", "DisassociateSwConfigPortNivLocal", "DisassociateSwConfigPortNivPeer", "DisassociateSwUnconfigHostOSLocal", "DisassociateSwUnconfigHostOSPeer", "DisassociateSwUnconfigPnuOSLocal", "DisassociateSwUnconfigPnuOSPeer", "DisassociateUnconfigBios", "DisassociateUnconfigCimcVMedia", "DisassociateUnconfigExtMgmtGw", "DisassociateUnconfigExtMgmtRules", "DisassociateUnconfigFlexFlash", "DisassociateUnconfigSoL", "DisassociateUnconfigUuid", "DisassociateVerifyFcZoneConfig", "DiscoverBegin", "DiscoverBiosPostCompletion", "DiscoverBladePowerOff", "DiscoverBmcConfigPnuOS", "DiscoverBmcConfigureConnLocal", "DiscoverBmcConfigureConnPeer", "DiscoverBmcFactoryReset", "DiscoverBmcInventory", "DiscoverBmcPreconfigPnuOSLocal", "DiscoverBmcPreconfigPnuOSPeer", "DiscoverBmcPresence", "DiscoverBmcShutdownDiscovered", "DiscoverBmcUnconfigPnuOS", "DiscoverBootPnuos", "DiscoverBootWait", "DiscoverCheckPowerAvailability", "DiscoverConfigDiscoveryMode", "DiscoverConfigFlexFlashScrub", "DiscoverConfigNivMode", "DiscoverConfigUserAccess", "DiscoverFail", "DiscoverHagConnect", "DiscoverHagDisconnect", "DiscoverHandlePooling", "DiscoverNicConfigPnuOSLocal", "DiscoverNicConfigPnuOSPeer", "DiscoverNicInventoryLocal", "DiscoverNicInventoryPeer", "DiscoverOobStorageInventory", "DiscoverPnuOSCatalog", "DiscoverPnuOSConnStatus", "DiscoverPnuOSConnectivity", "DiscoverPnuOSIdent", "DiscoverPnuOSInventory", "DiscoverPnuOSPolicy", "DiscoverPnuOSScrub", "DiscoverPnuOSSelfTest", "DiscoverPowerDeployWait", "DiscoverPreSanitize", "DiscoverReadSmbios", "DiscoverSanitize", "DiscoverSerialDebugConnect", "DiscoverSerialDebugDisconnect", "DiscoverSolRedirectDisable", "DiscoverSolRedirectEnable", "DiscoverSuccess", "DiscoverSwConfigPnuOSLocal", "DiscoverSwConfigPnuOSPeer", "DiscoverSwConfigPortNivLocal", "DiscoverSwConfigPortNivPeer", "DiscoverSwConfigureConnLocal", "DiscoverSwConfigureConnPeer", "DiscoverSwPnuOSConnectivityLocal", "DiscoverSwPnuOSConnectivityPeer", "DiscoverSwUnconfigPortNivLocal", "DiscoverSwUnconfigPortNivPeer", "DiscoverUnconfigCimcVMedia", "DiscoverUnconfigExtMgmtGw", "DiscoverUnconfigExtMgmtRules", "DiscoverWaitForConnReady", "DiskZoningInventoryBegin", "DiskZoningInventoryBootHost", "DiskZoningInventoryBootWait", "DiskZoningInventoryFail", "DiskZoningInventoryPreSanitize", "DiskZoningInventorySanitize", "DiskZoningInventoryShutdown", "DiskZoningInventoryStorageInventory", "DiskZoningInventorySuccess", "EnableCimcSecureBootActivate", "EnableCimcSecureBootBegin", "EnableCimcSecureBootFail", "EnableCimcSecureBootPollUpdateStatus", "EnableCimcSecureBootReset", "EnableCimcSecureBootSuccess", "EnableCimcSecureBootUpdateRequest", "FlashControllerBegin", "FlashControllerFail", "FlashControllerSuccess", "FlashControllerUpdateFlashLife", "FwUpgradeActivateAdaptorNwFwLocal", "FwUpgradeActivateAdaptorNwFwPeer", "FwUpgradeActivateBios", "FwUpgradeActivateIBMCFw", "FwUpgradeBegin", "FwUpgradeBiosImgUpdate", "FwUpgradeBiosPostCompletion", "FwUpgradeBladePowerOff", "FwUpgradeBmcConfigPnuOS", "FwUpgradeBmcPreconfigPnuOSLocal", "FwUpgradeBmcPreconfigPnuOSPeer", "FwUpgradeBmcUnconfigPnuOS", "FwUpgradeBootPnuos", "FwUpgradeBootWait", "FwUpgradeCheckPowerAvailability", "FwUpgradeCiscoOSOpenGate", "FwUpgradeClearBiosUpdate", "FwUpgradeCopyRemote", "FwUpgradeDeassertResetBypass", "FwUpgradeDeleteCurlDownloadedImages", "FwUpgradeDeleteImagesRemote", "FwUpgradeDownloadImages", "FwUpgradeFail", "FwUpgradeGraphicsImageUpdate", "FwUpgradeHagPnuOSConnect", "FwUpgradeHagPnuOSDisconnect", "FwUpgradeHbaImgUpdate", "FwUpgradeLocalDiskFwUpdate", "FwUpgradeNicConfigPnuOSLocal", "FwUpgradeNicConfigPnuOSPeer", "FwUpgradeNicImgUpdate", "FwUpgradeNicUnconfigPnuOSLocal", "FwUpgradeNicUnconfigPnuOSPeer", "FwUpgradeOobPollSasExpanderActivateStatus", "FwUpgradeOobPollSasExpanderUpdateStatus", "FwUpgradeOobSasExpanderImgActivate", "FwUpgradeOobSasExpanderImgUpdate", "FwUpgradeOobStorageInventory", "FwUpgradePnuOSCatalog", "FwUpgradePnuOSConfig", "FwUpgradePnuOSIdent", "FwUpgradePnuOSInventory", "FwUpgradePnuOSPolicy", "FwUpgradePnuOSSelfTest", "FwUpgradePnuOSUnloadDrivers", "FwUpgradePnuOSValidate", "FwUpgradePollBiosActivateStatus", "FwUpgradePollBiosUpdateStatus", "FwUpgradePollBoardCtrlPowerCycle", "FwUpgradePollBoardCtrlUpdateStatus", "FwUpgradePollClearBiosUpdateStatus", "FwUpgradePowerCycleBoard", "FwUpgradePowerDeployWait", "FwUpgradePowerOn", "FwUpgradePreSanitize", "FwUpgradeResetIBMC", "FwUpgradeSanitize", "FwUpgradeSasExpanderImgUpdate", "FwUpgradeSerialDebugPnuOSConnect", "FwUpgradeSerialDebugPnuOSDisconnect", "FwUpgradeShutdown", "FwUpgradeSolRedirectDisable", "FwUpgradeSolRedirectEnable", "FwUpgradeStorageCtlrImgUpdate", "FwUpgradeSuccess", "FwUpgradeSwConfigPnuOSLocal", "FwUpgradeSwConfigPnuOSPeer", "FwUpgradeSwConfigPortNivLocal", "FwUpgradeSwConfigPortNivPeer", "FwUpgradeSwUnconfigPnuOSLocal", "FwUpgradeSwUnconfigPnuOSPeer", "FwUpgradeUnconfigCimcVMedia", "FwUpgradeUnconfigExtMgmtGw", "FwUpgradeUnconfigExtMgmtRules", "FwUpgradeUnlockFirmwareImage", "FwUpgradeUpdateAdaptorNwFwLocal", "FwUpgradeUpdateAdaptorNwFwPeer", "FwUpgradeUpdateBiosRequest", "FwUpgradeUpdateBoardCtrlRequest", "FwUpgradeUpdateIBMCFw", "FwUpgradeWaitForAdaptorNwFwUpdateLocal", "FwUpgradeWaitForAdaptorNwFwUpdatePeer", "FwUpgradeWaitForIBMCFwUpdate", "HardShutdownBegin", "HardShutdownExecute", "HardShutdownFail", "HardShutdownSuccess", "HardresetBegin", "HardresetCheckPowerAvailability", "HardresetExecute", "HardresetFail", "HardresetPowerDeployWait", "HardresetPreSanitize", "HardresetSanitize", "HardresetSuccess", "OfflineBegin", "OfflineCleanupLocal", "OfflineCleanupPeer", "OfflineFail", "OfflineSuccess", "OfflineSwUnconfigureLocal", "OfflineSwUnconfigurePeer", "OobStorageAdminConfigBegin", "OobStorageAdminConfigBootHost", "OobStorageAdminConfigBootWait", "OobStorageAdminConfigFail", "OobStorageAdminConfigOobStorageConfig", "OobStorageAdminConfigOobStorageInventory", "OobStorageAdminConfigPreSanitize", "OobStorageAdminConfigSanitize", "OobStorageAdminConfigShutdown", "OobStorageAdminConfigSuccess", "OobStorageAdminConfigTearDownVMediaLocal", "OobStorageAdminConfigTearDownVMediaPeer", "PowerCapBegin", "PowerCapConfig", "PowerCapFail", "PowerCapSuccess", "PowercycleBegin", "PowercycleCheckPowerAvailability", "PowercycleExecute", "PowercycleFail", "PowercyclePowerDeployWait", "PowercyclePreSanitize", "PowercycleSanitize", "PowercycleSuccess", "ResetBmcBegin", "ResetBmcExecute", "ResetBmcFail", "ResetBmcSuccess", "ResetIpmiBegin", "ResetIpmiExecute", "ResetIpmiFail", "ResetIpmiSuccess", "ResetKvmBegin", "ResetKvmExecute", "ResetKvmFail", "ResetKvmSuccess", "ResetMemoryErrorsBegin", "ResetMemoryErrorsExecute", "ResetMemoryErrorsFail", "ResetMemoryErrorsSuccess", "ServiceInfraDeployBegin", "ServiceInfraDeployFail", "ServiceInfraDeployNicConfigLocal", "ServiceInfraDeployNicConfigPeer", "ServiceInfraDeploySuccess", "ServiceInfraDeploySwConfigLocal", "ServiceInfraDeploySwConfigPeer", "ServiceInfraWithdrawBegin", "ServiceInfraWithdrawFail", "ServiceInfraWithdrawNicUnConfigLocal", "ServiceInfraWithdrawNicUnConfigPeer", "ServiceInfraWithdrawSuccess", "ServiceInfraWithdrawSwUnConfigLocal", "ServiceInfraWithdrawSwUnConfigPeer", "SoftShutdownBegin", "SoftShutdownExecute", "SoftShutdownFail", "SoftShutdownSuccess", "SoftresetBegin", "SoftresetCheckPowerAvailability", "SoftresetExecute", "SoftresetFail", "SoftresetPowerDeployWait", "SoftresetPreSanitize", "SoftresetSanitize", "SoftresetSuccess", "SwConnUpdA", "SwConnUpdB", "SwConnUpdBegin", "SwConnUpdFail", "SwConnUpdSuccess", "TurnupBegin", "TurnupCheckPowerAvailability", "TurnupExecute", "TurnupFail", "TurnupPowerDeployWait", "TurnupSuccess", "UnconfigSoLBegin", "UnconfigSoLExecute", "UnconfigSoLFail", "UnconfigSoLSuccess", "UpdateAdaptorBegin", "UpdateAdaptorCheckPowerAvailability", "UpdateAdaptorFail", "UpdateAdaptorPollUpdateStatusLocal", "UpdateAdaptorPollUpdateStatusPeer", "UpdateAdaptorPowerDeployWait", "UpdateAdaptorPowerOff", "UpdateAdaptorPowerOn", "UpdateAdaptorSuccess", "UpdateAdaptorUpdateRequestLocal", "UpdateAdaptorUpdateRequestPeer", "UpdateBIOSBegin", "UpdateBIOSClear", "UpdateBIOSFail", "UpdateBIOSPollClearStatus", "UpdateBIOSPollUpdateStatus", "UpdateBIOSSuccess", "UpdateBIOSUpdateRequest", "UpdateBoardControllerBegin", "UpdateBoardControllerCheckPowerAvailability", "UpdateBoardControllerFail", "UpdateBoardControllerPollBoardCtrlPowerCycle", "UpdateBoardControllerPollUpdateStatus", "UpdateBoardControllerPowerCycleBoard", "UpdateBoardControllerPowerDeployWait", "UpdateBoardControllerPrepareForUpdate", "UpdateBoardControllerServerPowerOff", "UpdateBoardControllerServerPowerOn", "UpdateBoardControllerSuccess", "UpdateBoardControllerUpdateRequest", "clearTPMBegin", "clearTPMBiosPostCompletion", "clearTPMBladePowerOff", "clearTPMBladePowerOn", "clearTPMBootHost", "clearTPMClear", "clearTPMFail", "clearTPMPreSanitize", "clearTPMReadSmBios", "clearTPMReconfigBios", "clearTPMSanitize", "clearTPMSetupVmedia", "clearTPMStopVMediaLocal", "clearTPMStopVMediaPeer", "clearTPMSuccess", "clearTPMUnconfigVmedia", "nop", "updateExtUsersBegin", "updateExtUsersDeploy", "updateExtUsersFail", "updateExtUsersSuccess"], []), 
        "fsm_try": MoPropertyMeta("fsm_try", "fsmTry", "byte", VersionMeta.Version141i, MoPropertyMeta.INTERNAL, None, None, None, None, [], []), 
        "id": MoPropertyMeta("id", "id", "uint", VersionMeta.Version141i, MoPropertyMeta.NAMING, 0x20, None, None, None, [], ["1-255"]), 
        "int_id": MoPropertyMeta("int_id", "intId", "string", VersionMeta.Version141i, MoPropertyMeta.INTERNAL, None, None, None, None, ["none"], ["0-4294967295"]), 
        "lc": MoPropertyMeta("lc", "lc", "string", VersionMeta.Version141i, MoPropertyMeta.READ_WRITE, 0x40, None, None, None, ["decommission", "discovered", "migrate", "rediscover", "remove", "resetToFactory", "undiscovered", "upgrade-firmware"], []), 
        "lc_ts": MoPropertyMeta("lc_ts", "lcTs", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, r"""([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], []), 
        "local_id": MoPropertyMeta("local_id", "localId", "string", VersionMeta.Version212a, MoPropertyMeta.READ_ONLY, None, 0, 256, None, [], []), 
        "low_voltage_memory": MoPropertyMeta("low_voltage_memory", "lowVoltageMemory", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, ["low-voltage", "not-applicable", "regular-voltage"], []), 
        "managing_inst": MoPropertyMeta("managing_inst", "managingInst", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, ["A", "B", "NONE"], []), 
        "memory_speed": MoPropertyMeta("memory_speed", "memorySpeed", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, ["not-applicable", "unspecified"], ["0-4294967295"]), 
        "mfg_time": MoPropertyMeta("mfg_time", "mfgTime", "string", VersionMeta.Version201m, MoPropertyMeta.READ_ONLY, None, None, None, r"""([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", ["not-applicable"], []), 
        "model": MoPropertyMeta("model", "model", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, 0, 510, None, [], []), 
        "name": MoPropertyMeta("name", "name", "string", VersionMeta.Version141i, MoPropertyMeta.READ_WRITE, 0x80, None, None, r"""[\-\.:_a-zA-Z0-9]{0,16}""", [], []), 
        "num_of40_g_adaptors_with_old_fw": MoPropertyMeta("num_of40_g_adaptors_with_old_fw", "numOf40GAdaptorsWithOldFw", "byte", VersionMeta.Version311e, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "num_of40_g_adaptors_with_unknown_fw": MoPropertyMeta("num_of40_g_adaptors_with_unknown_fw", "numOf40GAdaptorsWithUnknownFw", "byte", VersionMeta.Version311e, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "num_of_adaptors": MoPropertyMeta("num_of_adaptors", "numOfAdaptors", "byte", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "num_of_cores": MoPropertyMeta("num_of_cores", "numOfCores", "ushort", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "num_of_cores_enabled": MoPropertyMeta("num_of_cores_enabled", "numOfCoresEnabled", "ushort", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "num_of_cpus": MoPropertyMeta("num_of_cpus", "numOfCpus", "byte", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "num_of_eth_host_ifs": MoPropertyMeta("num_of_eth_host_ifs", "numOfEthHostIfs", "ushort", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "num_of_fc_host_ifs": MoPropertyMeta("num_of_fc_host_ifs", "numOfFcHostIfs", "ushort", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "num_of_threads": MoPropertyMeta("num_of_threads", "numOfThreads", "ushort", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "oper_power": MoPropertyMeta("oper_power", "operPower", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, ["degraded", "error", "failed", "not-supported", "off", "offduty", "offline", "ok", "on", "online", "power-save", "test", "unknown"], []), 
        "oper_pwr_trans_src": MoPropertyMeta("oper_pwr_trans_src", "operPwrTransSrc", "string", VersionMeta.Version302a, MoPropertyMeta.READ_ONLY, None, None, None, None, ["software", "software_mcserver", "unknown", "user-fp", "user-unknown"], []), 
        "oper_qualifier": MoPropertyMeta("oper_qualifier", "operQualifier", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, r"""((defaultValue|not-applicable|cpu-voltage|adaptor-voltage|hba-voltage|compute-post-failure|memory-power|nic-power|memory-inoperable|nic-inoperable|compute-power|power-inoperable|compute-thermal|cpu-perf|adaptor-perf|hba-perf|cpu-thermal|adaptor-thermal|hba-thermal|compute-inoperable|memory-voltage|removed|nic-voltage|network-misconfig|cpu-power|adaptor-power|hba-power|compute-voltage|cpu-inoperable|adaptor-inoperable|hba-inoperable|config|memory-perf|nic-perf|adaptor-mismatch|memory-thermal|nic-thermal|mismatch|compute-perf),){0,38}(defaultValue|not-applicable|cpu-voltage|adaptor-voltage|hba-voltage|compute-post-failure|memory-power|nic-power|memory-inoperable|nic-inoperable|compute-power|power-inoperable|compute-thermal|cpu-perf|adaptor-perf|hba-perf|cpu-thermal|adaptor-thermal|hba-thermal|compute-inoperable|memory-voltage|removed|nic-voltage|network-misconfig|cpu-power|adaptor-power|hba-power|compute-voltage|cpu-inoperable|adaptor-inoperable|hba-inoperable|config|memory-perf|nic-perf|adaptor-mismatch|memory-thermal|nic-thermal|mismatch|compute-perf){0,1}""", [], []), 
        "oper_state": MoPropertyMeta("oper_state", "operState", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, ["bios-restore", "cmos-reset", "compute-failed", "compute-mismatch", "config", "config-failure", "decomissioning", "degraded", "diagnostics", "diagnostics-failed", "disabled", "discovery", "discovery-failed", "inaccessible", "indeterminate", "inoperable", "maintenance", "maintenance-failed", "ok", "pending-reassociation", "pending-reboot", "power-off", "power-problem", "removed", "restart", "svnic-not-present", "test", "test-failed", "thermal-problem", "unassociated", "unconfig", "unconfig-failed", "voltage-problem"], []), 
        "operability": MoPropertyMeta("operability", "operability", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, ["accessibility-problem", "auto-upgrade", "backplane-port-problem", "bios-post-timeout", "chassis-limit-exceeded", "config", "decomissioning", "degraded", "disabled", "discovery", "discovery-failed", "equipment-problem", "fabric-conn-problem", "fabric-unsupported-conn", "identify", "identity-unestablishable", "inoperable", "link-activate-blocked", "malformed-fru", "not-supported", "operable", "peer-comm-problem", "performance-problem", "post-failure", "power-problem", "powered-off", "removed", "thermal-problem", "unknown", "upgrade-problem", "voltage-problem"], []), 
        "original_uuid": MoPropertyMeta("original_uuid", "originalUuid", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, r"""(([0-9a-fA-F]){8}\-([0-9a-fA-F]){4}\-([0-9a-fA-F]){4}\-([0-9a-fA-F]){4}\-([0-9a-fA-F]){12})|0""", [], []), 
        "part_number": MoPropertyMeta("part_number", "partNumber", "string", VersionMeta.Version203a, MoPropertyMeta.READ_ONLY, None, 0, 510, None, [], []), 
        "policy_level": MoPropertyMeta("policy_level", "policyLevel", "uint", VersionMeta.Version211a, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "policy_owner": MoPropertyMeta("policy_owner", "policyOwner", "string", VersionMeta.Version211a, MoPropertyMeta.READ_WRITE, 0x100, None, None, None, ["local", "pending-policy", "policy"], []), 
        "presence": MoPropertyMeta("presence", "presence", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, ["empty", "equipped", "equipped-deprecated", "equipped-identity-unestablishable", "equipped-not-primary", "equipped-slave", "equipped-unsupported", "equipped-with-malformed-fru", "inaccessible", "mismatch", "mismatch-identity-unestablishable", "mismatch-slave", "missing", "missing-slave", "unauthorized", "unknown"], []), 
        "revision": MoPropertyMeta("revision", "revision", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, 0, 510, None, [], []), 
        "rn": MoPropertyMeta("rn", "rn", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, 0x200, 0, 256, None, [], []), 
        "sacl": MoPropertyMeta("sacl", "sacl", "string", VersionMeta.Version302a, MoPropertyMeta.READ_ONLY, None, None, None, r"""((none|del|mod|addchild|cascade),){0,4}(none|del|mod|addchild|cascade){0,1}""", [], []), 
        "serial": MoPropertyMeta("serial", "serial", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, 0, 510, None, [], []), 
        "server_id": MoPropertyMeta("server_id", "serverId", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, 0, 510, None, [], []), 
        "status": MoPropertyMeta("status", "status", "string", VersionMeta.Version141i, MoPropertyMeta.READ_WRITE, 0x400, None, None, r"""((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], []), 
        "total_memory": MoPropertyMeta("total_memory", "totalMemory", "uint", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "usr_lbl": MoPropertyMeta("usr_lbl", "usrLbl", "string", VersionMeta.Version141i, MoPropertyMeta.READ_WRITE, 0x800, None, None, r"""[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,32}""", [], []), 
        "uuid": MoPropertyMeta("uuid", "uuid", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, r"""(([0-9a-fA-F]){8}\-([0-9a-fA-F]){4}\-([0-9a-fA-F]){4}\-([0-9a-fA-F]){4}\-([0-9a-fA-F]){12})|0""", [], []), 
        "vendor": MoPropertyMeta("vendor", "vendor", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, 0, 510, None, [], []), 
        "version_holder": MoPropertyMeta("version_holder", "versionHolder", "string", VersionMeta.Version141i, MoPropertyMeta.READ_ONLY, None, None, None, None, ["false", "no", "true", "yes"], []), 
        "vid": MoPropertyMeta("vid", "vid", "string", VersionMeta.Version203a, MoPropertyMeta.READ_ONLY, None, 0, 510, None, [], []), 
    }

    prop_map = {
        "adminPower": "admin_power", 
        "adminState": "admin_state", 
        "assignedToDn": "assigned_to_dn", 
        "association": "association", 
        "availability": "availability", 
        "availableMemory": "available_memory", 
        "checkPoint": "check_point", 
        "childAction": "child_action", 
        "connPath": "conn_path", 
        "connStatus": "conn_status", 
        "descr": "descr", 
        "discovery": "discovery", 
        "discoveryStatus": "discovery_status", 
        "dn": "dn", 
        "fanSpeedConfigStatus": "fan_speed_config_status", 
        "fanSpeedPolicyFault": "fan_speed_policy_fault", 
        "fltAggr": "flt_aggr", 
        "fsmDescr": "fsm_descr", 
        "fsmFlags": "fsm_flags", 
        "fsmPrev": "fsm_prev", 
        "fsmProgr": "fsm_progr", 
        "fsmRmtInvErrCode": "fsm_rmt_inv_err_code", 
        "fsmRmtInvErrDescr": "fsm_rmt_inv_err_descr", 
        "fsmRmtInvRslt": "fsm_rmt_inv_rslt", 
        "fsmStageDescr": "fsm_stage_descr", 
        "fsmStamp": "fsm_stamp", 
        "fsmStatus": "fsm_status", 
        "fsmTry": "fsm_try", 
        "id": "id", 
        "intId": "int_id", 
        "lc": "lc", 
        "lcTs": "lc_ts", 
        "localId": "local_id", 
        "lowVoltageMemory": "low_voltage_memory", 
        "managingInst": "managing_inst", 
        "memorySpeed": "memory_speed", 
        "mfgTime": "mfg_time", 
        "model": "model", 
        "name": "name", 
        "numOf40GAdaptorsWithOldFw": "num_of40_g_adaptors_with_old_fw", 
        "numOf40GAdaptorsWithUnknownFw": "num_of40_g_adaptors_with_unknown_fw", 
        "numOfAdaptors": "num_of_adaptors", 
        "numOfCores": "num_of_cores", 
        "numOfCoresEnabled": "num_of_cores_enabled", 
        "numOfCpus": "num_of_cpus", 
        "numOfEthHostIfs": "num_of_eth_host_ifs", 
        "numOfFcHostIfs": "num_of_fc_host_ifs", 
        "numOfThreads": "num_of_threads", 
        "operPower": "oper_power", 
        "operPwrTransSrc": "oper_pwr_trans_src", 
        "operQualifier": "oper_qualifier", 
        "operState": "oper_state", 
        "operability": "operability", 
        "originalUuid": "original_uuid", 
        "partNumber": "part_number", 
        "policyLevel": "policy_level", 
        "policyOwner": "policy_owner", 
        "presence": "presence", 
        "revision": "revision", 
        "rn": "rn", 
        "sacl": "sacl", 
        "serial": "serial", 
        "serverId": "server_id", 
        "status": "status", 
        "totalMemory": "total_memory", 
        "usrLbl": "usr_lbl", 
        "uuid": "uuid", 
        "vendor": "vendor", 
        "versionHolder": "version_holder", 
        "vid": "vid", 
    }

    def __init__(self, parent_mo_or_dn, id, **kwargs):
        self._dirty_mask = 0
        self.id = id
        self.admin_power = None
        self.admin_state = None
        self.assigned_to_dn = None
        self.association = None
        self.availability = None
        self.available_memory = None
        self.check_point = None
        self.child_action = None
        self.conn_path = None
        self.conn_status = None
        self.descr = None
        self.discovery = None
        self.discovery_status = None
        self.fan_speed_config_status = None
        self.fan_speed_policy_fault = None
        self.flt_aggr = None
        self.fsm_descr = None
        self.fsm_flags = None
        self.fsm_prev = None
        self.fsm_progr = None
        self.fsm_rmt_inv_err_code = None
        self.fsm_rmt_inv_err_descr = None
        self.fsm_rmt_inv_rslt = None
        self.fsm_stage_descr = None
        self.fsm_stamp = None
        self.fsm_status = None
        self.fsm_try = None
        self.int_id = None
        self.lc = None
        self.lc_ts = None
        self.local_id = None
        self.low_voltage_memory = None
        self.managing_inst = None
        self.memory_speed = None
        self.mfg_time = None
        self.model = None
        self.name = None
        self.num_of40_g_adaptors_with_old_fw = None
        self.num_of40_g_adaptors_with_unknown_fw = None
        self.num_of_adaptors = None
        self.num_of_cores = None
        self.num_of_cores_enabled = None
        self.num_of_cpus = None
        self.num_of_eth_host_ifs = None
        self.num_of_fc_host_ifs = None
        self.num_of_threads = None
        self.oper_power = None
        self.oper_pwr_trans_src = None
        self.oper_qualifier = None
        self.oper_state = None
        self.operability = None
        self.original_uuid = None
        self.part_number = None
        self.policy_level = None
        self.policy_owner = None
        self.presence = None
        self.revision = None
        self.sacl = None
        self.serial = None
        self.server_id = None
        self.status = None
        self.total_memory = None
        self.usr_lbl = None
        self.uuid = None
        self.vendor = None
        self.version_holder = None
        self.vid = None

        ManagedObject.__init__(self, "ComputeRackUnit", parent_mo_or_dn, **kwargs)
