# pyconn
pyconn is a tool set which include:
* Connect and query kdb+, oracle database
* Send message via `wechat`

# Requirements
- Python 2.7+
- qpython
- pandas

# Usage

## Query kdb+
```
from pyconn.db.kdb import KDB
from pyconn.db.kdb import Server

db = Server()
db.name = "DBNAME"
db.host = "127.0.0.1"
db.port = 9800
db.username = "username"
db.password = "password"

q = KDB(server=db)
q.get_conn()
result = q.query_sync("{:1+1}[]")
```

## Query Oracle
```
from pyconn.db.oracle import ORACLE
from pyconn.db.oracle import OracleServerInfo

db = OracleServerInfo()
db.name = "db name"
db.sid = "oracle sid"
db.username = "username"
db.password = "password"

q = ORACLE(server=db)
sql_str = "select * from t"
result = q.query(sql_str)
```
