# Stubs for boto.exception (Python 2)
#
# NOTE: This dynamically typed stub was automatically generated by stubgen.

from typing import Any

class BotoClientError(StandardError):
    reason = ...  # type: Any
    def __init__(self, reason, *args): ...

class SDBPersistenceError(StandardError): ...
class StoragePermissionsError(BotoClientError): ...
class S3PermissionsError(StoragePermissionsError): ...
class GSPermissionsError(StoragePermissionsError): ...

class BotoServerError(StandardError):
    status = ...  # type: Any
    reason = ...  # type: Any
    body = ...  # type: Any
    request_id = ...  # type: Any
    error_code = ...  # type: Any
    message = ...  # type: Any
    box_usage = ...  # type: Any
    def __init__(self, status, reason, body=None, *args): ...
    def __getattr__(self, name): ...
    def __setattr__(self, name, value): ...
    def startElement(self, name, attrs, connection): ...
    def endElement(self, name, value, connection): ...

class ConsoleOutput:
    parent = ...  # type: Any
    instance_id = ...  # type: Any
    timestamp = ...  # type: Any
    comment = ...  # type: Any
    output = ...  # type: Any
    def __init__(self, parent=None): ...
    def startElement(self, name, attrs, connection): ...
    def endElement(self, name, value, connection): ...

class StorageCreateError(BotoServerError):
    bucket = ...  # type: Any
    def __init__(self, status, reason, body=None): ...
    def endElement(self, name, value, connection): ...

class S3CreateError(StorageCreateError): ...
class GSCreateError(StorageCreateError): ...
class StorageCopyError(BotoServerError): ...
class S3CopyError(StorageCopyError): ...
class GSCopyError(StorageCopyError): ...

class SQSError(BotoServerError):
    detail = ...  # type: Any
    type = ...  # type: Any
    def __init__(self, status, reason, body=None): ...
    def startElement(self, name, attrs, connection): ...
    def endElement(self, name, value, connection): ...

class SQSDecodeError(BotoClientError):
    message = ...  # type: Any
    def __init__(self, reason, message): ...

class StorageResponseError(BotoServerError):
    resource = ...  # type: Any
    def __init__(self, status, reason, body=None): ...
    def startElement(self, name, attrs, connection): ...
    def endElement(self, name, value, connection): ...

class S3ResponseError(StorageResponseError): ...
class GSResponseError(StorageResponseError): ...

class EC2ResponseError(BotoServerError):
    errors = ...  # type: Any
    def __init__(self, status, reason, body=None): ...
    def startElement(self, name, attrs, connection): ...
    request_id = ...  # type: Any
    def endElement(self, name, value, connection): ...

class JSONResponseError(BotoServerError):
    status = ...  # type: Any
    reason = ...  # type: Any
    body = ...  # type: Any
    error_message = ...  # type: Any
    error_code = ...  # type: Any
    def __init__(self, status, reason, body=None, *args): ...

class DynamoDBResponseError(JSONResponseError): ...
class SWFResponseError(JSONResponseError): ...
class EmrResponseError(BotoServerError): ...

class _EC2Error:
    connection = ...  # type: Any
    error_code = ...  # type: Any
    error_message = ...  # type: Any
    def __init__(self, connection=None): ...
    def startElement(self, name, attrs, connection): ...
    def endElement(self, name, value, connection): ...

class SDBResponseError(BotoServerError): ...
class AWSConnectionError(BotoClientError): ...
class StorageDataError(BotoClientError): ...
class S3DataError(StorageDataError): ...
class GSDataError(StorageDataError): ...

class InvalidUriError(Exception):
    message = ...  # type: Any
    def __init__(self, message): ...

class InvalidAclError(Exception):
    message = ...  # type: Any
    def __init__(self, message): ...

class InvalidCorsError(Exception):
    message = ...  # type: Any
    def __init__(self, message): ...

class NoAuthHandlerFound(Exception): ...

class InvalidLifecycleConfigError(Exception):
    message = ...  # type: Any
    def __init__(self, message): ...

class ResumableTransferDisposition:
    START_OVER = ...  # type: Any
    WAIT_BEFORE_RETRY = ...  # type: Any
    ABORT_CUR_PROCESS = ...  # type: Any
    ABORT = ...  # type: Any

class ResumableUploadException(Exception):
    message = ...  # type: Any
    disposition = ...  # type: Any
    def __init__(self, message, disposition): ...

class ResumableDownloadException(Exception):
    message = ...  # type: Any
    disposition = ...  # type: Any
    def __init__(self, message, disposition): ...

class TooManyRecordsException(Exception):
    message = ...  # type: Any
    def __init__(self, message): ...

class PleaseRetryException(Exception):
    message = ...  # type: Any
    response = ...  # type: Any
    def __init__(self, message, response=None): ...

class InvalidInstanceMetadataError(Exception):
    MSG = ...  # type: Any
    def __init__(self, msg): ...
