# **********************************************************************
#
# Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.0
#
# <auto-generated>
#
# Generated from file `PropertiesAdmin.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

import Ice, IcePy
import Ice_BuiltinSequences_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Start of module Ice
__name__ = 'Ice'

if '_t_PropertyDict' not in _M_Ice.__dict__:
    _M_Ice._t_PropertyDict = IcePy.defineDictionary('::Ice::PropertyDict', (), IcePy._t_string, IcePy._t_string)

if 'PropertiesAdmin' not in _M_Ice.__dict__:
    _M_Ice.PropertiesAdmin = Ice.createTempClass()
    class PropertiesAdmin(Ice.Object):
        '''The PropertiesAdmin interface provides remote access to the properties
of a communicator.'''
        def __init__(self):
            if Ice.getType(self) == _M_Ice.PropertiesAdmin:
                raise RuntimeError('Ice.PropertiesAdmin is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::Ice::PropertiesAdmin')

        def ice_id(self, current=None):
            return '::Ice::PropertiesAdmin'

        def ice_staticId():
            return '::Ice::PropertiesAdmin'
        ice_staticId = staticmethod(ice_staticId)

        def getProperty(self, key, current=None):
            '''Get a property by key. If the property is not set, an empty
string is returned.

Arguments:
    key The property key.

Returns:
    The property value.'''
            pass

        def getPropertiesForPrefix(self, prefix, current=None):
            '''Get all properties whose keys begin with prefix. If
prefix is an empty string then all properties are returned.

Arguments:
    prefix The prefix to search for (empty string if none).
Returns:
    The matching property set.'''
            pass

        def setProperties_async(self, _cb, newProperties, current=None):
            '''Update the communicator's properties with the given property set.

Arguments:
    newProperties Properties to be added, changed, or removed.
If an entry in newProperties matches the name of an existing property,
that property's value is replaced with the new value. If the new value
is an empty string, the property is removed. Any existing properties
that are not modified or removed by the entries in newProperties are
retained with their original values.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_PropertiesAdmin)

        __repr__ = __str__

    _M_Ice.PropertiesAdminPrx = Ice.createTempClass()
    class PropertiesAdminPrx(Ice.ObjectPrx):

        '''Get a property by key. If the property is not set, an empty
string is returned.

Arguments:
    key The property key.

Returns:
    The property value.'''
        def getProperty(self, key, _ctx=None):
            return _M_Ice.PropertiesAdmin._op_getProperty.invoke(self, ((key, ), _ctx))

        '''Get a property by key. If the property is not set, an empty
string is returned.

Arguments:
    key The property key.

Returns:
    The property value.'''
        def begin_getProperty(self, key, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Ice.PropertiesAdmin._op_getProperty.begin(self, ((key, ), _response, _ex, _sent, _ctx))

        '''Get a property by key. If the property is not set, an empty
string is returned.

Arguments:
    key The property key.

Returns:
    The property value.'''
        def end_getProperty(self, _r):
            return _M_Ice.PropertiesAdmin._op_getProperty.end(self, _r)

        '''Get all properties whose keys begin with prefix. If
prefix is an empty string then all properties are returned.

Arguments:
    prefix The prefix to search for (empty string if none).
Returns:
    The matching property set.'''
        def getPropertiesForPrefix(self, prefix, _ctx=None):
            return _M_Ice.PropertiesAdmin._op_getPropertiesForPrefix.invoke(self, ((prefix, ), _ctx))

        '''Get all properties whose keys begin with prefix. If
prefix is an empty string then all properties are returned.

Arguments:
    prefix The prefix to search for (empty string if none).
Returns:
    The matching property set.'''
        def begin_getPropertiesForPrefix(self, prefix, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Ice.PropertiesAdmin._op_getPropertiesForPrefix.begin(self, ((prefix, ), _response, _ex, _sent, _ctx))

        '''Get all properties whose keys begin with prefix. If
prefix is an empty string then all properties are returned.

Arguments:
    prefix The prefix to search for (empty string if none).
Returns:
    The matching property set.'''
        def end_getPropertiesForPrefix(self, _r):
            return _M_Ice.PropertiesAdmin._op_getPropertiesForPrefix.end(self, _r)

        '''Update the communicator's properties with the given property set.

Arguments:
    newProperties Properties to be added, changed, or removed.
If an entry in newProperties matches the name of an existing property,
that property's value is replaced with the new value. If the new value
is an empty string, the property is removed. Any existing properties
that are not modified or removed by the entries in newProperties are
retained with their original values.'''
        def setProperties(self, newProperties, _ctx=None):
            return _M_Ice.PropertiesAdmin._op_setProperties.invoke(self, ((newProperties, ), _ctx))

        '''Update the communicator's properties with the given property set.

Arguments:
    newProperties Properties to be added, changed, or removed.
If an entry in newProperties matches the name of an existing property,
that property's value is replaced with the new value. If the new value
is an empty string, the property is removed. Any existing properties
that are not modified or removed by the entries in newProperties are
retained with their original values.'''
        def begin_setProperties(self, newProperties, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Ice.PropertiesAdmin._op_setProperties.begin(self, ((newProperties, ), _response, _ex, _sent, _ctx))

        '''Update the communicator's properties with the given property set.

Arguments:
    newProperties Properties to be added, changed, or removed.
If an entry in newProperties matches the name of an existing property,
that property's value is replaced with the new value. If the new value
is an empty string, the property is removed. Any existing properties
that are not modified or removed by the entries in newProperties are
retained with their original values.'''
        def end_setProperties(self, _r):
            return _M_Ice.PropertiesAdmin._op_setProperties.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_Ice.PropertiesAdminPrx.ice_checkedCast(proxy, '::Ice::PropertiesAdmin', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_Ice.PropertiesAdminPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::Ice::PropertiesAdmin'
        ice_staticId = staticmethod(ice_staticId)

    _M_Ice._t_PropertiesAdminPrx = IcePy.defineProxy('::Ice::PropertiesAdmin', PropertiesAdminPrx)

    _M_Ice._t_PropertiesAdmin = IcePy.defineClass('::Ice::PropertiesAdmin', PropertiesAdmin, -1, (), True, False, None, (), ())
    PropertiesAdmin._ice_type = _M_Ice._t_PropertiesAdmin

    PropertiesAdmin._op_getProperty = IcePy.Operation('getProperty', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), IcePy._t_string, False, 0), ())
    PropertiesAdmin._op_getPropertiesForPrefix = IcePy.Operation('getPropertiesForPrefix', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), _M_Ice._t_PropertyDict, False, 0), ())
    PropertiesAdmin._op_setProperties = IcePy.Operation('setProperties', Ice.OperationMode.Normal, Ice.OperationMode.Normal, True, None, (), (((), _M_Ice._t_PropertyDict, False, 0),), (), None, ())

    _M_Ice.PropertiesAdmin = PropertiesAdmin
    del PropertiesAdmin

    _M_Ice.PropertiesAdminPrx = PropertiesAdminPrx
    del PropertiesAdminPrx

# End of module Ice
