# -*- coding: utf-8 -*-

################################################################
# zopyx.plone.smashdocs
# (C) 2016,  Andreas Jung, www.zopyx.com, Tuebingen, Germany
################################################################


import lxml.html

from plone.indexer import indexer
from Products.CMFPlone.utils import safe_unicode

from .smashdocument import ISmashDocument


@indexer(ISmashDocument)
def document_searchabletext(obj):
    result = [obj.Title(), obj.Description()]
    html_file = obj.restrictedTraverse('sdxml/index.html', None)
    if html_file:
        html = html_file.text.output
        root = lxml.html.document_fromstring(html)
        result.extend(root.text_content().split())
    result = [safe_unicode(r) for r in result if r]
    return u' '.join(result)
