"""
Import all gentoo based modules.

All manually entered modules can be placed in the following import section.
Portage_Gen based projects will be generated automatically as soon as we
can find an index generated by portage info.
"""
from benchbuild.settings import CFG

from . import autoportage
from . import gentoo
from . import bzip2
from . import gzip
from . import sevenz
from . import xz
from . import postgresql
from . import lammps
from . import x264
from . import crafty
from . import info
from . import eix

import logging
import os

LOG = logging.getLogger(__name__)


def __initialize_dynamic_projects__(autotest_path):
    from benchbuild.projects.gentoo.portage_gen import PortageFactory

    LOG.debug("Loading AutoPortage projects from %s", autotest_path)
    if os.path.exists(autotest_path):
        with open(autotest_path, 'r') as ebuilds:
            for line in ebuilds:
                ebuild_data = line.strip('\n')
                ebuild_data = ebuild_data.split('/')
                domain = ebuild_data[0]
                name = ebuild_data[1]
                PortageFactory("Auto{0}{1}".format(domain, name),
                               domain + "_" + name, domain)


__initialize_dynamic_projects__(CFG['gentoo']['autotest_loc'].value())
