# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VaultProperties(Model):
    """Properties of the vault.

    :param vault_uri: The URI of the vault for performing operations on keys
     and secrets.
    :type vault_uri: str
    :param tenant_id: The Azure Active Directory tenant ID that should be
     used for authenticating requests to the key vault.
    :type tenant_id: str
    :param sku: SKU details
    :type sku: :class:`Sku <azure.mgmt.keyvault.models.Sku>`
    :param access_policies: An array of 0 to 16 identities that have access
     to the key vault. All identities in the array must use the same tenant
     ID as the key vault's tenant ID.
    :type access_policies: list of :class:`AccessPolicyEntry
     <azure.mgmt.keyvault.models.AccessPolicyEntry>`
    :param enabled_for_deployment: Property to specify whether Azure Virtual
     Machines are permitted to retrieve certificates stored as secrets from
     the key vault.
    :type enabled_for_deployment: bool
    :param enabled_for_disk_encryption: Property to specify whether Azure
     Disk Encryption is permitted to retrieve secrets from the vault and
     unwrap keys.
    :type enabled_for_disk_encryption: bool
    :param enabled_for_template_deployment: Property to specify whether Azure
     Resource Manager is permitted to retrieve secrets from the key vault.
    :type enabled_for_template_deployment: bool
    """ 

    _validation = {
        'tenant_id': {'required': True},
        'sku': {'required': True},
        'access_policies': {'required': True, 'max_items': 16},
    }

    _attribute_map = {
        'vault_uri': {'key': 'vaultUri', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'access_policies': {'key': 'accessPolicies', 'type': '[AccessPolicyEntry]'},
        'enabled_for_deployment': {'key': 'enabledForDeployment', 'type': 'bool'},
        'enabled_for_disk_encryption': {'key': 'enabledForDiskEncryption', 'type': 'bool'},
        'enabled_for_template_deployment': {'key': 'enabledForTemplateDeployment', 'type': 'bool'},
    }

    def __init__(self, tenant_id, sku, access_policies, vault_uri=None, enabled_for_deployment=None, enabled_for_disk_encryption=None, enabled_for_template_deployment=None):
        self.vault_uri = vault_uri
        self.tenant_id = tenant_id
        self.sku = sku
        self.access_policies = access_policies
        self.enabled_for_deployment = enabled_for_deployment
        self.enabled_for_disk_encryption = enabled_for_disk_encryption
        self.enabled_for_template_deployment = enabled_for_template_deployment
