# coding=utf-8
__author__ = 'kohlmannj'
import os
from BaseClass import BaseClass
__all__ = ["BaseClass"]
# The root path to the Ity module's directory.
root = os.path.abspath(os.path.dirname(__file__))
# The path to VEP_Core.
parent_root = os.path.abspath(
    os.path.join(root, "..")
)
# The directory containing additional resources shared by both Serendip and Ity.
shared_root = os.path.join(parent_root, "Shared")
# The directory containing all data, including corpora, metadata, dictionaries, etc.
data_root = os.path.join(parent_root, "Data")
# The directory containing all corpora.
corpus_root = os.path.join(data_root, "Corpora")
# The directory containing all dictionaries, i.e. preexisting data files used by other Ity modules.
dictionaries_root = os.path.join(data_root, "Dictionaries")
# The directory containing all metadata imported or generated by other Ity modules.
metadata_root = os.path.join(data_root, "Metadata")
# The directory containing all formatted content generated by Ity Formatter modules.
output_root = os.path.join(data_root, "Output")

# Stuff for Celery Tasks (in here for now)
DATA_NAMES = [
    "Text",
    "SimpleRule",
    "TopicModel"
]
DATA_EXTENSIONS = {
    "Text": [
        ".zip",
        ".txt"
    ],
    "SimpleRule": [
        ".txt",
        ".csv"
    ]
}
