/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.wrappers.mudel;

import ee.ut.soras.wrappers.mudel.MorfAnRida;
import java.util.ArrayList;
import java.util.List;

public class MorfAnSona {
    private boolean leidusAnalyys;
    private String algSona;
    private List<MorfAnRida> analyysiTulemused;
    private boolean onLauseLopp = false;
    private boolean olpOnKindelPiir = false;
    private int tokenPosition = -1;

    public MorfAnSona(String algSona) {
        this.algSona = algSona;
        this.leidusAnalyys = false;
        this.analyysiTulemused = new ArrayList<MorfAnRida>();
    }

    public void lisaAnalyysiRida(String analyysiRida) {
        if (!analyysiRida.equals("####")) {
            MorfAnRida rida = new MorfAnRida(analyysiRida);
            this.analyysiTulemused.add(rida);
            this.leidusAnalyys = true;
        }
    }

    public void lisaAnalyysiRida(MorfAnRida analyysiRida) {
        if (analyysiRida != null) {
            this.analyysiTulemused.add(analyysiRida);
            this.leidusAnalyys = true;
        }
    }

    public List<MorfAnRida> getAnalyysiTulemused() {
        return this.analyysiTulemused;
    }

    public String getAlgSona() {
        return this.algSona;
    }

    public boolean kasLeidusAnalyys() {
        return this.leidusAnalyys;
    }

    public boolean onVerb() {
        if (!this.analyysiTulemused.isEmpty()) {
            for (MorfAnRida morfAnRida : this.analyysiTulemused) {
                if (!morfAnRida.getSonaliik().equals("_V_")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean onAdjektiivPos() {
        if (!this.analyysiTulemused.isEmpty()) {
            for (MorfAnRida morfAnRida : this.analyysiTulemused) {
                if (!morfAnRida.getSonaliik().equals("_A_")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean onLauseLopp() {
        return this.onLauseLopp;
    }

    public void setOnLauseLopp(boolean onLauseLopp) {
        this.onLauseLopp = onLauseLopp;
    }

    public boolean onOlpKindelPiir() {
        return this.olpOnKindelPiir;
    }

    public void setOlpOnKindelPiir(boolean olpOnKindelPiir) {
        this.olpOnKindelPiir = olpOnKindelPiir;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.algSona);
        if (this.leidusAnalyys) {
            for (MorfAnRida rida : this.analyysiTulemused) {
                str.append(" | ");
                str.append(rida.toString());
            }
        }
        return str.toString();
    }

    public int getTokenPosition() {
        return this.tokenPosition;
    }

    public void setTokenPosition(int tokenPosition) {
        this.tokenPosition = tokenPosition;
    }
}

