/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.wrappers.impl;

import ee.ut.soras.ajavtV2.util.TextUtils;
import ee.ut.soras.wrappers.mudel.MorfAnSona;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class T3MestaReader {
    private static Pattern musterLauseAlgus = Pattern.compile("^\\p{Lu}");
    private static Pattern musterLauseLopp = Pattern.compile("[?!.]$");

    private static boolean kasSonaOnSuurt2heliseAlgusega(String sona) {
        return musterLauseAlgus.matcher(TextUtils.trimSurroundingPunctation(sona)).find();
    }

    private static boolean kasSonaLopebLauselopuMargiga(MorfAnSona sona) {
        return musterLauseLopp.matcher(sona.getAlgSona()).find();
    }

    public static List<MorfAnSona> parseT3mestatext(BufferedReader input) throws Exception {
        String rida;
        ArrayList<MorfAnSona> tulemused = new ArrayList<MorfAnSona>();
        String sona = null;
        MorfAnSona eelmineSona = null;
        int tokenPosition = 1;
        while ((rida = input.readLine()) != null) {
            if (rida.length() > 0) {
                String[] parts = rida.split("\\s{4}");
                if (parts.length < 2) {
                    throw new IOException("Unable to parse the output of morphological analyzer - unexpected format: " + rida);
                }
                sona = parts[0];
                MorfAnSona jooksevSona = new MorfAnSona(sona);
                jooksevSona.setTokenPosition(tokenPosition);
                for (int i = 1; i < parts.length; ++i) {
                    jooksevSona.lisaAnalyysiRida(TextUtils.ltrim(parts[i]));
                }
                if (eelmineSona != null) {
                    if (T3MestaReader.kasSonaOnSuurt2heliseAlgusega(sona) && T3MestaReader.kasSonaLopebLauselopuMargiga(eelmineSona)) {
                        eelmineSona.setOnLauseLopp(true);
                    }
                    if (eelmineSona.getAlgSona().endsWith(",")) {
                        eelmineSona.setOlpOnKindelPiir(true);
                    }
                }
                tulemused.add(jooksevSona);
                eelmineSona = (MorfAnSona)tulemused.get(tulemused.size() - 1);
                sona = null;
            }
            ++tokenPosition;
        }
        return tulemused;
    }
}

