/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2;

import ee.ut.soras.ajavtV2.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberTokenizer {
    private static final Pattern musterSisaldabArvuJaMitteArvu = Pattern.compile("(\\d\\D|\\D\\d)");
    private static final Pattern hypenPattern1 = Pattern.compile("(\\d+([.:]\\d+)?-\\d+([.:]\\d+)?)(\\\\|/)(\\d+([.:]\\d+)?-\\d+([.:]\\d+)?)");
    private static final Pattern hypenPattern2 = Pattern.compile("\\d+-\\d+-([a-z]|\u00f6).*");
    private static final Pattern hypenPattern3 = Pattern.compile("\\d+-\\d+-");
    private static final Pattern hypenPattern4 = Pattern.compile("\\d\\d\\d\\d-\\d+-\\d+");
    private static final Pattern pointPattern1 = Pattern.compile("\\d+\\.\\d+\\.\\d+\\.\\d+.*");
    private static final Pattern acronymPattern1 = Pattern.compile("[A-Z][a-zA-Z]*-?\\d+.*");
    private static final Pattern htmlEntityPattern1 = Pattern.compile(".*&#[0-9]+;.*");

    public static boolean isNumberTokenizationNeeded(String analyysitavSona) {
        Matcher matcher1 = musterSisaldabArvuJaMitteArvu.matcher(analyysitavSona);
        if (matcher1.find()) {
            if (!NumberTokenizer.passesHypenGuard(analyysitavSona)) {
                return false;
            }
            if (!NumberTokenizer.passesPointGuard(analyysitavSona)) {
                return false;
            }
            if (!NumberTokenizer.passesAcronymGuard(analyysitavSona)) {
                return false;
            }
            return NumberTokenizer.passesHTMLEntityGuard(analyysitavSona);
        }
        return false;
    }

    public static boolean passesHypenGuard(String analyysitavSona) {
        String sona = TextUtils.normalizeSpecialSymbols(analyysitavSona);
        int occurrences = NumberTokenizer.countNumberOfOccurrences(sona, "-");
        if (occurrences > 1) {
            if (hypenPattern1.matcher(sona).matches()) {
                return true;
            }
            if (hypenPattern2.matcher(sona).matches()) {
                return true;
            }
            if (hypenPattern3.matcher(sona).matches()) {
                return true;
            }
            return hypenPattern4.matcher(sona).matches();
        }
        return true;
    }

    public static boolean passesPointGuard(String analyysitavSona) {
        return !pointPattern1.matcher(analyysitavSona).matches();
    }

    public static boolean passesAcronymGuard(String analyysitavSona) {
        return !acronymPattern1.matcher(analyysitavSona).matches();
    }

    public static boolean passesHTMLEntityGuard(String analyysitavSona) {
        return !htmlEntityPattern1.matcher(analyysitavSona).matches();
    }

    public static int countNumberOfOccurrences(String superString, String subString) {
        int occs = 0;
        int nextIndex = 0;
        while (nextIndex != -1) {
            if ((nextIndex = superString.indexOf(subString, nextIndex)) == -1) continue;
            ++occs;
            ++nextIndex;
        }
        return occs;
    }

    public static List<String> extractNumbersWithTrailingPunctation(String source, boolean keepNonDigits) {
        ArrayList<String> results = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean lastWasAcceptable = false;
        for (int i = 0; i < source.length(); ++i) {
            boolean thisIsAcceptable;
            String substr = source.substring(i, i + 1);
            boolean thisIsDigit = substr.compareTo("0") >= 0 && substr.compareTo("9") <= 0;
            boolean thisIsComma = substr.equals(",");
            boolean bl = thisIsAcceptable = thisIsDigit || thisIsComma;
            if (i > 0 && thisIsAcceptable && !lastWasAcceptable) {
                results.add(sb.toString());
                sb = new StringBuilder();
            }
            if (keepNonDigits || !keepNonDigits && thisIsAcceptable) {
                sb.append(substr);
            }
            lastWasAcceptable = thisIsAcceptable;
            if (i != source.length() - 1 || sb.length() <= 0) continue;
            results.add(sb.toString());
        }
        return results;
    }
}

