#coding=utf-8

import smtplib
from email.header import Header
from email.mime.text import MIMEText

def send(
    from_addr, 
    to_addr,
    host='localhost', 
    port=25, 
    cc_addr = '', 
    title = '', 
    content = ''
):
    msg = MIMEText(content, 'plain', 'utf-8')
    #发件人
    msg['From'] = from_addr
    #收件人
    msg['To'] = to_addr
    #抄送人
    msg['Cc'] = cc_addr
    #标题
    msg['Subject'] = Header(title, 'utf-8').encode()
    s = smtplib.SMTP(host = host, port = port)
    s.sendmail(
        from_addr = from_addr,
        to_addrs = to_addr,
        msg = msg.as_string()
    )
    return True
