/*
 * Decompiled with CFR 0.152.
 */
package org.idpf.epubcheck.util.css;

import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.idpf.epubcheck.util.css.CssErrorHandler;
import org.idpf.epubcheck.util.css.CssEscape;
import org.idpf.epubcheck.util.css.CssExceptions;
import org.idpf.epubcheck.util.css.CssReader;
import org.idpf.epubcheck.util.css.CssToken;

final class CssScanner {
    private final CssReader reader;
    private final CssToken.CssTokenConsumer consumer;
    private final CssEscapeMemoizer escapes;
    private CssToken.TokenBuilder builder;
    private final CssErrorHandler errHandler;
    private final boolean debug = false;
    private char cur;
    private static final int QNT_TOKEN_MAXLENGTH = 4;
    private static final Map<int[], CssToken.Type> quantities = new ImmutableMap.Builder<int[], CssToken.Type>().put(new int[]{100, 112, 99, 109}, CssToken.Type.QNTY_RESOLUTION).put(new int[]{100, 112, 112, 120}, CssToken.Type.QNTY_RESOLUTION).put(new int[]{103, 114, 97, 100}, CssToken.Type.QNTY_ANGLE).put(new int[]{116, 117, 114, 110}, CssToken.Type.QNTY_ANGLE).put(new int[]{118, 109, 105, 110}, CssToken.Type.QNTY_LENGTH).put(new int[]{100, 101, 103}, CssToken.Type.QNTY_ANGLE).put(new int[]{107, 104, 122}, CssToken.Type.QNTY_FREQ).put(new int[]{114, 97, 100}, CssToken.Type.QNTY_ANGLE).put(new int[]{114, 101, 109}, CssToken.Type.QNTY_REMS).put(new int[]{100, 112, 105}, CssToken.Type.QNTY_RESOLUTION).put(new int[]{101, 109}, CssToken.Type.QNTY_EMS).put(new int[]{99, 109}, CssToken.Type.QNTY_LENGTH).put(new int[]{112, 120}, CssToken.Type.QNTY_LENGTH).put(new int[]{109, 109}, CssToken.Type.QNTY_LENGTH).put(new int[]{105, 110}, CssToken.Type.QNTY_LENGTH).put(new int[]{112, 116}, CssToken.Type.QNTY_LENGTH).put(new int[]{112, 99}, CssToken.Type.QNTY_LENGTH).put(new int[]{99, 104}, CssToken.Type.QNTY_LENGTH).put(new int[]{118, 119}, CssToken.Type.QNTY_LENGTH).put(new int[]{118, 104}, CssToken.Type.QNTY_LENGTH).put(new int[]{101, 120}, CssToken.Type.QNTY_EXS).put(new int[]{109, 115}, CssToken.Type.QNTY_TIME).put(new int[]{104, 122}, CssToken.Type.QNTY_FREQ).put(new int[]{37}, CssToken.Type.QNTY_PERCENTAGE).put(new int[]{115}, CssToken.Type.QNTY_TIME).build();
    static final CharMatcher WHITESPACE = CharMatcher.anyOf(" \t\n\r\f").precomputed();
    private static final CharMatcher NOT_WHITESPACE = WHITESPACE.negate().precomputed();
    static final CharMatcher QUOTES = CharMatcher.anyOf("\"'").precomputed();
    private static final CharMatcher U = CharMatcher.anyOf("Uu").precomputed();
    private static final CharMatcher O = CharMatcher.anyOf("Oo").precomputed();
    private static final CharMatcher N = CharMatcher.anyOf("Nn").precomputed();
    private static final CharMatcher A = CharMatcher.anyOf("Aa").precomputed();
    private static final CharMatcher NMSTART = CharMatcher.inRange('A', 'Z').or(CharMatcher.inRange('a', 'z').or(CharMatcher.is('_').or(CharMatcher.inRange('\u0080', '\uffff')))).precomputed();
    private static final CharMatcher NMCHAR = NMSTART.or(CharMatcher.inRange('0', '9').or(CharMatcher.is('-'))).precomputed();
    private static final CharMatcher QNTSTART = NMSTART.or(CharMatcher.is('%')).precomputed();
    private static final CharMatcher NUMEND = CharMatcher.inRange('0', '9').precomputed();
    private static final CharMatcher NUM = NUMEND.or(CharMatcher.is('.')).precomputed();
    private static final CharMatcher UNARY = CharMatcher.anyOf("+-").precomputed();
    private static final CharMatcher NUMSTART = NUM.or(UNARY).precomputed();
    static final CharMatcher HEXCHAR = CharMatcher.anyOf("AaBbCcDdEeFf0123456789").precomputed();
    private static final CharMatcher URANGESTART = HEXCHAR.or(CharMatcher.anyOf("?"));
    private static final CharMatcher URANGECHAR = HEXCHAR.or(CharMatcher.anyOf("?-"));
    static final CharMatcher TERMINATOR = CharMatcher.anyOf(";}{");
    private static final int[] CDO_LL = new int[]{33, 45, 45};
    private static final int[] CDC_LL = new int[]{45, 62};
    private static final int[] URI_LL = new int[]{114, 108, 40};
    private static final int[] ONLY_LL = new int[]{110, 108, 121};
    private static final int[] NOT_LL = new int[]{111, 116};
    private static final int[] AND_LL = new int[]{110, 100};

    private CssScanner(Reader in, String systemID, CssErrorHandler errHandler, CssToken.CssTokenConsumer consumer, int pushbackBufferSize) {
        this.consumer = Preconditions.checkNotNull(consumer);
        this.errHandler = Preconditions.checkNotNull(errHandler);
        this.reader = new CssReader(in, systemID, pushbackBufferSize);
        this.escapes = new CssEscapeMemoizer(this.reader);
    }

    CssScanner(Reader in, String systemID, CssErrorHandler errHandler, CssToken.CssTokenConsumer consumer) {
        this(in, systemID, errHandler, consumer, 8096);
    }

    void scan() throws IOException, CssExceptions.CssException {
        int ch;
        while ((ch = this.reader.next()) != -1) {
            this.builder = new CssToken.TokenBuilder(this.reader, this.errHandler);
            this.cur = (char)ch;
            int next = this.reader.peek();
            this.escapes.reset(this.builder);
            if (WHITESPACE.matches(this.cur)) {
                this._ws();
            } else if (this.cur == '-' && CssScanner.equals(this.reader.peek(2), CDC_LL)) {
                this._cdc();
            } else if (O.matches(this.cur) && CssScanner.matchesOrEOF(this.reader.at(4), WHITESPACE) && CssScanner.equals(this.reader.peek(3), ONLY_LL, true)) {
                this._only();
            } else if (N.matches(this.cur) && CssScanner.matchesOrEOF(this.reader.at(3), WHITESPACE) && CssScanner.equals(this.reader.peek(2), NOT_LL, true)) {
                this._not();
            } else if (A.matches(this.cur) && CssScanner.matchesOrEOF(this.reader.at(3), WHITESPACE) && CssScanner.equals(this.reader.peek(2), AND_LL, true)) {
                this._and();
            } else if (U.matches(this.cur) && CssScanner.equals(this.reader.peek(3), URI_LL, true)) {
                this._uri();
            } else if (U.matches(this.cur) && next == 43 && CssScanner.matchesOrEOF(this.reader.at(2), URANGESTART)) {
                this._urange();
            } else if (NMSTART.matches(this.cur) || this.cur == '-' && CssScanner.matches(next, NMSTART) || this.escapes.get(0).isPresent() || this.cur == '-' && this.escapes.get(1).isPresent()) {
                this._ident();
                if (this.reader.peek() == 40) {
                    this._function();
                }
            } else if (this.cur == '@' && (CssScanner.matches(next, NMSTART) || this.escapes.get(1).isPresent() || next == 45 && CssScanner.matches(this.reader.at(2), NMSTART) || this.escapes.get(2).isPresent())) {
                this._atkeyword();
            } else if (NUMEND.matches(this.cur) || NUMSTART.matches(this.cur) && CssScanner.matches(next, NUMEND) || UNARY.matches(this.cur) && next == 46 && CssScanner.matches(this.reader.at(2), NUMEND)) {
                this._num();
            } else if (this.cur == '<' && CssScanner.equals(this.reader.peek(3), CDO_LL)) {
                this._cdo();
            } else if (this.cur == '/' && next == 42) {
                this._comment();
            } else if (QUOTES.matches(this.cur)) {
                this._string();
            } else if (this.cur == '#' && (CssScanner.matches(next, NMCHAR) || this.escapes.get(1).isPresent())) {
                this._hashname();
            } else if (this.cur == '.' && (CssScanner.matches(next, NMCHAR) || this.escapes.get(1).isPresent())) {
                this._classname();
            } else if (this.cur == '!' && this.forwardMatch("important", true, false)) {
                this._important();
            } else if (this.cur == '~' && next == 61) {
                this._includes();
            } else if (this.cur == '|' && next == 61) {
                this._dashmatch();
            } else if (this.cur == '^' && next == 61) {
                this._prefixmatch();
            } else if (this.cur == '$' && next == 61) {
                this._suffixmatch();
            } else if (this.cur == '*' && next == 61) {
                this._substringmatch();
            } else {
                this.builder.type = CssToken.Type.CHAR;
                this.builder.append(this.cur);
            }
            this.consumer.add(this.builder.asToken());
        }
    }

    private void _function() throws IOException {
        this.builder.type = CssToken.Type.FUNCTION;
        this.builder.append(this.reader.next());
    }

    private void _uri() throws IOException, CssExceptions.CssException {
        this.builder.append("url(");
        this.reader.forward(3);
        this.reader.forward(NOT_WHITESPACE);
        int uristart = this.reader.next();
        if (-1 == uristart) {
            this.builder.error(CssExceptions.CssErrorCode.SCANNER_PREMATURE_EOF, this.reader, new Object[0]);
        } else if (QUOTES.matches((char)uristart)) {
            this.builder.append(39);
            this._string();
            this.builder.append(39);
            this.reader.forward(NOT_WHITESPACE);
            if (this.reader.peek() > -1) {
                this.reader.next();
            }
        } else {
            this.builder.append(uristart);
            StringBuilder buf = new StringBuilder();
            while (true) {
                CssReader.Mark mark = this.reader.mark();
                int ch = this.reader.next();
                if (ch == -1) {
                    this.builder.error(CssExceptions.CssErrorCode.SCANNER_PREMATURE_EOF, this.reader, new Object[0]);
                    this.reader.unread(ch, mark);
                    break;
                }
                if (ch == 41) break;
                buf.append((char)ch);
            }
            this.builder.append(WHITESPACE.trimTrailingFrom(buf.toString()));
        }
        this.builder.append(41);
        this.builder.type = CssToken.Type.URI;
        if (41 != this.reader.curChar && this.builder.errors.size() == 0) {
            this.builder.error(CssExceptions.CssErrorCode.SCANNER_ILLEGAL_SYNTAX, this.reader, this.reader.curChar);
        }
    }

    private void _string() throws IOException, CssExceptions.CssException {
        this.builder.type = CssToken.Type.STRING;
        int quoteType = this.reader.curChar;
        while (true) {
            CssReader.Mark mark = this.reader.mark();
            int ch = this.reader.next();
            if (ch == -1) {
                this.builder.error(CssExceptions.CssErrorCode.SCANNER_PREMATURE_EOF, this.reader, new Object[0]);
                this.reader.unread(ch, mark);
                break;
            }
            if (ch == 10 || ch == 13 || ch == 12) {
                this.builder.error(CssExceptions.CssErrorCode.SCANNER_ILLEGAL_CHAR, this.reader, "NEWLINE", CssToken.Type.STRING.name());
                this.reader.forward(TERMINATOR);
                break;
            }
            if (ch == 92) {
                int[] peek = this.reader.peek(2);
                int nl = CssScanner.isNewLine(peek);
                if (nl > 0) {
                    this.reader.forward(nl);
                    continue;
                }
            } else if (ch == quoteType && this.reader.prevChar != 92) break;
            this.builder.append(ch);
        }
    }

    private void _atkeyword() throws IOException, CssExceptions.CssException {
        this.builder.type = CssToken.Type.ATKEYWORD;
        this.builder.append(this.cur);
        this.append(NMSTART);
        this.append(NMCHAR);
    }

    private void _ident() throws IOException, CssExceptions.CssException {
        this.builder.type = CssToken.Type.IDENT;
        Optional<CssEscape> esc = this.escapes.get(0);
        if (esc.isPresent()) {
            int length = esc.get().render(this.builder, NMSTART);
            this.reader.forward(length);
        } else {
            this.builder.append(this.cur);
        }
        if (this.cur == '-' || esc.isPresent() && esc.get().character == 45) {
            if (this.escapes.get(1).isPresent()) {
                this.reader.forward(this.escapes.get(1).get().render(this.builder, NMSTART));
            } else {
                this.builder.append(this.reader.next());
            }
        }
        this.append(NMCHAR);
    }

    private void _dashmatch() throws IOException {
        this.builder.type = CssToken.Type.DASHMATCH;
        this.builder.append("|=");
        this.reader.next();
    }

    private void _includes() throws IOException {
        this.builder.type = CssToken.Type.INCLUDES;
        this.builder.append("~=");
        this.reader.next();
    }

    private void _prefixmatch() throws IOException {
        this.builder.type = CssToken.Type.PREFIXMATCH;
        this.builder.append("^=");
        this.reader.next();
    }

    private void _suffixmatch() throws IOException {
        this.builder.type = CssToken.Type.SUFFIXMATCH;
        this.builder.append("$=");
        this.reader.next();
    }

    private void _substringmatch() throws IOException {
        this.builder.type = CssToken.Type.SUBSTRINGMATCH;
        this.builder.append("*=");
        this.reader.next();
    }

    private void _hashname() throws IOException, CssExceptions.CssException {
        this.builder.type = CssToken.Type.HASHNAME;
        this.builder.append(35);
        this.append(NMCHAR);
    }

    private void _classname() throws IOException, CssExceptions.CssException {
        this.builder.type = CssToken.Type.CLASSNAME;
        this.builder.append(46);
        this.append(NMCHAR);
    }

    private void _important() {
        this.builder.type = CssToken.Type.IMPORTANT;
        this.builder.append("!important");
    }

    private void _comment() throws IOException, CssExceptions.CssException {
        this.builder.type = CssToken.Type.COMMENT;
        this.reader.next();
        while (true) {
            CssReader.Mark mark = this.reader.mark();
            int ch = this.reader.next();
            if (ch == -1) {
                this.builder.error(CssExceptions.CssErrorCode.SCANNER_PREMATURE_EOF, this.reader, new Object[0]);
                this.reader.unread(ch, mark);
                break;
            }
            if (ch == 42 && this.reader.peek() == 47) {
                this.reader.next();
                break;
            }
            this.builder.append(ch);
        }
    }

    private void _cdo() throws IOException {
        this.builder.type = CssToken.Type.CDO;
        this.builder.append("<!--");
        this.reader.forward(3);
    }

    private void _num() throws IOException, CssExceptions.CssException {
        this.builder.type = CssToken.Type.INTEGER;
        this.builder.append(this.cur);
        if (this.cur == '.') {
            this.builder.type = CssToken.Type.NUMBER;
        }
        while (true) {
            CssReader.Mark mark = this.reader.mark();
            int nm = this.reader.next();
            if (nm == -1) {
                if (this.builder.getLength() == 1 && this.builder.getLast() == '.') {
                    this.builder.type = CssToken.Type.CHAR;
                }
                this.reader.unread(nm, mark);
                break;
            }
            if (!NUM.matches((char)nm)) {
                this.reader.unread(nm, mark);
                break;
            }
            if (nm == 46 && !NUMEND.matches((char)this.reader.peek())) {
                this.reader.unread(nm, mark);
                break;
            }
            this.builder.append(nm);
            if (nm != 46) continue;
            this.builder.type = CssToken.Type.NUMBER;
        }
        int qnt = this.reader.peek();
        if (qnt > -1 && QNTSTART.matches((char)qnt) || this.isNextEscape()) {
            this._quantity();
        }
    }

    private void _quantity() throws IOException, CssExceptions.CssException {
        this.builder.type = CssToken.Type.QNTY_DIMEN;
        CssToken.TokenBuilder suffix = new CssToken.TokenBuilder(this.reader, this.errHandler);
        this.append(QNTSTART, suffix);
        if (suffix.getLast() != '%') {
            this.append(NMCHAR, suffix);
        }
        if (suffix.getLength() > 4) {
            this.builder.append(suffix.toString());
            return;
        }
        int[] ident = suffix.toArray();
        int[] match = null;
        for (int[] test : quantities.keySet()) {
            if (!CssScanner.equals(ident, test, true)) continue;
            this.builder.type = quantities.get(test);
            match = test;
            break;
        }
        if (this.builder.type == CssToken.Type.QNTY_DIMEN) {
            this.builder.append(ident);
        } else {
            this.builder.append(match);
        }
    }

    private void _and() throws IOException {
        this.builder.type = CssToken.Type.AND;
        this.builder.append("and");
        this.reader.forward(2);
    }

    private void _not() throws IOException {
        this.builder.type = CssToken.Type.NOT;
        this.builder.append("not");
        this.reader.forward(2);
    }

    private void _only() throws IOException {
        this.builder.type = CssToken.Type.ONLY;
        this.builder.append("only");
        this.reader.forward(3);
    }

    private void _cdc() throws IOException {
        this.builder.type = CssToken.Type.CDC;
        this.builder.append("-->");
        this.reader.forward(2);
    }

    private void _ws() throws IOException {
        this.builder.type = CssToken.Type.S;
        this.builder.append(32);
        this.reader.forward(NOT_WHITESPACE);
    }

    private void _urange() throws IOException, CssExceptions.CssException {
        ArrayList<Integer> cbuf;
        block3: {
            int ch;
            CssReader.Mark mark;
            this.builder.type = CssToken.Type.URANGE;
            this.reader.next();
            cbuf = Lists.newArrayList();
            int count = 0;
            while (true) {
                mark = this.reader.mark();
                ch = this.reader.next();
                if (ch == -1) {
                    this.reader.unread(ch, mark);
                    break block3;
                }
                if (!URANGECHAR.matches((char)ch)) break;
                int n = count = ch == 45 ? 0 : count + 1;
                if (count == 7) {
                    this.builder.error(CssExceptions.CssErrorCode.SCANNER_ILLEGAL_URANGE, this.reader, "U+" + this.toString(cbuf) + (char)ch);
                }
                cbuf.add(ch);
            }
            this.reader.unread(ch, mark);
        }
        this.builder.append("U+");
        this.builder.append(Ints.toArray(cbuf));
    }

    private boolean isNextEscape() throws IOException {
        boolean result = false;
        CssReader.Mark mark = this.reader.mark();
        int ch = this.reader.next();
        if (ch == 92) {
            try {
                Optional<CssEscape> esc = new CssEscape(this.reader, this.builder).create();
                result = esc.isPresent();
            }
            catch (CssExceptions.CssException cssException) {
                // empty catch block
            }
        }
        this.reader.unread(ch, mark);
        return result;
    }

    private void append(CharMatcher matcher) throws IOException, CssExceptions.CssException {
        this.append(matcher, this.builder);
    }

    private void append(CharMatcher matcher, CssToken.TokenBuilder builder) throws IOException, CssExceptions.CssException {
        block3: {
            int ch;
            CssReader.Mark mark;
            block2: {
                while (true) {
                    mark = this.reader.mark();
                    ch = this.reader.next();
                    if (ch > -1 && matcher.matches((char)ch)) {
                        builder.append(ch);
                        continue;
                    }
                    if (ch != 92) break block2;
                    Optional<CssEscape> escape = new CssEscape(this.reader, builder).create();
                    if (!escape.isPresent()) break;
                    this.reader.forward(escape.get().render(builder, matcher));
                }
                this.reader.unread(ch, mark);
                break block3;
            }
            this.reader.unread(ch, mark);
        }
    }

    private boolean forwardMatch(String match, boolean ignoreCase, boolean resetOnTrue) throws IOException {
        boolean result;
        ArrayList<Integer> cbuf;
        CssReader.Mark mark;
        block9: {
            mark = this.reader.mark();
            cbuf = Lists.newArrayList();
            StringBuilder builder = new StringBuilder();
            result = true;
            boolean seenChar = false;
            do {
                cbuf.add(this.reader.next());
                char ch = (char)this.reader.curChar;
                if (this.reader.curChar == -1) {
                    result = false;
                } else {
                    if (WHITESPACE.matches(ch)) {
                        if (!seenChar) continue;
                        builder.append(ch);
                        continue;
                    }
                    if (builder.length() == 0) {
                        seenChar = true;
                    }
                    builder.append(ch);
                    int index = builder.length() - 1;
                    if (!ignoreCase && builder.charAt(index) == match.charAt(index)) {
                        result = false;
                    } else {
                        if (!ignoreCase || Ascii.toLowerCase(builder.charAt(index)) == Ascii.toLowerCase(match.charAt(index))) continue;
                        result = false;
                    }
                }
                break block9;
            } while (builder.length() != match.length());
            if (!match.equalsIgnoreCase(builder.toString())) {
                result = false;
            }
        }
        if (!result || resetOnTrue) {
            this.reader.unread(cbuf, mark);
        }
        return result;
    }

    private String toString(List<Integer> ints) {
        StringBuilder builder = new StringBuilder();
        for (int i : ints) {
            builder.append((char)i);
        }
        return builder.toString();
    }

    private static boolean equals(int[] a, int[] b) {
        return CssScanner.equals(a, b, false);
    }

    private static boolean equals(int[] a, int[] b, boolean ignoreAsciiCase) {
        if (a == null && b == null || a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (!ignoreAsciiCase) {
                if (a[i] == b[i]) continue;
                return false;
            }
            if (a[i] == -1 && b[i] == -1) continue;
            if (a[i] == -1 || b[i] == -1) {
                return false;
            }
            if (Ascii.toLowerCase((char)a[i]) == Ascii.toLowerCase((char)b[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesOrEOF(int ch, CharMatcher matcher) {
        return ch == -1 || matcher.matches((char)ch);
    }

    private static boolean matches(int ch, CharMatcher matcher) {
        return ch != -1 && matcher.matches((char)ch);
    }

    static int isNewLine(int[] chars) {
        Preconditions.checkArgument(chars.length > 1);
        if (chars[0] == 13 && chars[1] == 10) {
            return 2;
        }
        if (chars[0] == 10 || chars[0] == 13 || chars[0] == 12) {
            return 1;
        }
        return 0;
    }

    static class CssEscapeMemoizer {
        private final Map<Integer, Optional<CssEscape>> map = Maps.newHashMap();
        private CssToken.TokenBuilder errFunnel;
        private final CssReader reader;

        CssEscapeMemoizer(CssReader reader) {
            this.reader = reader;
        }

        CssEscapeMemoizer reset(CssToken.TokenBuilder errFunnel) {
            this.map.clear();
            this.errFunnel = errFunnel;
            return this;
        }

        Optional<CssEscape> get(int n) throws IOException {
            Preconditions.checkNotNull(this.errFunnel);
            if (!this.map.containsKey(n)) {
                this.map.put(n, this.create(n));
            }
            return this.map.get(n);
        }

        private Optional<CssEscape> create(int n) throws IOException {
            ArrayList<Integer> cbuf = Lists.newArrayList();
            CssReader.Mark mark = this.reader.mark();
            for (int i = 0; i < n; ++i) {
                int ch = this.reader.next();
                cbuf.add(ch);
                if (ch != -1) continue;
                this.reader.unread(cbuf, mark);
                return CssEscape.ABSENT;
            }
            if (this.reader.curChar == 92) {
                try {
                    Optional<CssEscape> esc = new CssEscape(this.reader, this.errFunnel).create();
                    this.reader.unread(cbuf, mark);
                    return esc;
                }
                catch (CssExceptions.CssException cssException) {
                    // empty catch block
                }
            }
            this.reader.unread(cbuf, mark);
            return CssEscape.ABSENT;
        }
    }
}

