/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.epubpackage.EpubPackage;
import com.adobe.epubcheck.ctc.epubpackage.ManifestItem;
import com.adobe.epubcheck.ctc.xml.AnchorTagHandler;
import com.adobe.epubcheck.ctc.xml.XMLContentDocParser;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.util.SearchDictionary;
import java.io.File;
import java.util.Vector;
import java.util.zip.ZipEntry;

public class EpubCfiCheck
implements DocumentValidator {
    private final Report report;
    private final EpubPackage epack;

    public EpubCfiCheck(EpubPackage epack, Report report) {
        this.epack = epack;
        this.report = report;
    }

    @Override
    public boolean validate() {
        SearchDictionary validTypes = new SearchDictionary(SearchDictionary.DictionaryType.VALID_TEXT_MEDIA_TYPES);
        for (int i = 0; i < this.epack.getManifest().itemsLength(); ++i) {
            ManifestItem itemEntry = this.epack.getManifest().getItem(i);
            if (!validTypes.isValidMediaType(itemEntry.getMediaType())) continue;
            String fileToParse = this.epack.getManifestItemFileName(itemEntry);
            ZipEntry entry = this.epack.getZip().getEntry(fileToParse);
            if (entry == null) continue;
            XMLContentDocParser parser = new XMLContentDocParser(this.epack.getZip(), this.report);
            AnchorTagHandler h = new AnchorTagHandler();
            parser.parseDoc(fileToParse, h);
            Vector<AnchorTagHandler.DocTagContent> v = h.getHrefAttributesValues();
            for (int e = 0; e < v.size(); ++e) {
                AnchorTagHandler.DocTagContent value = v.elementAt(e);
                this.searchInsideValue(value, fileToParse);
            }
        }
        return true;
    }

    private void searchInsideValue(AnchorTagHandler.DocTagContent entry, String file) {
        String url = entry.getValue();
        int frag = entry.getValue().indexOf("#epubcfi");
        if (frag > -1) {
            String fileName = url.substring(0, frag);
            fileName = new File(fileName).getName();
            if (entry.getValue().contains(".epub") && fileName.compareTo(file) != 0) {
                this.report.message(MessageId.HTM_012, EPUBLocation.create(file, entry.getLine(), entry.getColumn(), entry.getValue()), new Object[0]);
            } else {
                this.report.message(MessageId.HTM_013, EPUBLocation.create(file, entry.getLine(), entry.getColumn(), entry.getValue()), new Object[0]);
            }
        }
    }
}

