/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.css.EpubCSSCheckCSSHandler;
import com.adobe.epubcheck.ctc.epubpackage.EpubPackage;
import com.adobe.epubcheck.ctc.epubpackage.ManifestItem;
import com.adobe.epubcheck.ctc.xml.CSSStyleAttributeHandler;
import com.adobe.epubcheck.ctc.xml.XMLContentDocParser;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.EncryptionFilter;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.util.SearchDictionary;
import com.adobe.epubcheck.util.TextSearchDictionaryEntry;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.idpf.epubcheck.util.css.CssParser;
import org.idpf.epubcheck.util.css.CssSource;

public class EpubCSSCheck
implements DocumentValidator {
    final ZipFile zip;
    final Report report;
    final EpubPackage epack;
    final Hashtable<String, EncryptionFilter> enc;
    static final int EXCESSIVE_CSS_THRESHOLD = 10;
    final boolean isGlobalFixed;

    public EpubCSSCheck(EpubPackage epack, Report report) {
        this.epack = epack;
        this.zip = epack.getZip();
        this.enc = new Hashtable();
        this.report = report;
        this.isGlobalFixed = EpubPackage.isGlobalFixed(epack);
    }

    @Override
    public boolean validate() {
        ZipEntry entry;
        String fileToParse;
        ManifestItem itemEntry;
        int i;
        boolean hasFixedFormatItems = this.getHasFixedFormatItems(this.epack);
        SearchDictionary tsd = new SearchDictionary(SearchDictionary.DictionaryType.CSS_VALUES);
        SearchDictionary cssTypes = new SearchDictionary(SearchDictionary.DictionaryType.CSS_FILES);
        SearchDictionary validTypes = new SearchDictionary(SearchDictionary.DictionaryType.VALID_TEXT_MEDIA_TYPES);
        EpubCSSCheckCSSHandler handler = new EpubCSSCheckCSSHandler(this.report, this.isGlobalFixed, hasFixedFormatItems);
        int numCssFiles = 0;
        for (i = 0; i < this.epack.getManifest().itemsLength(); ++i) {
            itemEntry = this.epack.getManifest().getItem(i);
            if (!cssTypes.isValidMediaType(itemEntry.getMediaType())) continue;
            ++numCssFiles;
            fileToParse = EpubCSSCheck.getEntryFileName(itemEntry, this.epack);
            entry = this.epack.getZip().getEntry(fileToParse);
            if (entry == null) continue;
            try {
                InputStream inputStream = this.getInputStream(fileToParse);
                CssSource source = new CssSource(fileToParse, inputStream);
                CssParser parser = new CssParser();
                handler.setPath(fileToParse);
                parser.parse(source, handler, handler);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < this.epack.getManifest().itemsLength(); ++i) {
            itemEntry = this.epack.getManifest().getItem(i);
            if (!validTypes.isValidMediaType(itemEntry.getMediaType())) continue;
            fileToParse = EpubCSSCheck.getEntryFileName(itemEntry, this.epack);
            entry = this.epack.getZip().getEntry(fileToParse);
            if (entry == null) continue;
            String properties = itemEntry.getProperties();
            boolean itemIsFixedFormat = properties != null && properties.contains("rendition:layout-pre-paginated");
            XMLContentDocParser parser = new XMLContentDocParser(this.epack.getZip(), this.report);
            CSSStyleAttributeHandler h = new CSSStyleAttributeHandler(this.isGlobalFixed, itemIsFixedFormat);
            h.setCssHandler(handler);
            h.setReport(this.report);
            h.setFileName(fileToParse);
            parser.parseDoc(fileToParse, h);
            Vector<CSSStyleAttributeHandler.StyleAttribute> styleTags = h.getStyleTagValues();
            for (int t = 0; t < styleTags.size(); ++t) {
                CSSStyleAttributeHandler.StyleAttribute value = styleTags.elementAt(t);
                this.searchInsideValue(value, tsd, fileToParse);
            }
            Collection<CSSStyleAttributeHandler.StyleAttribute> styleAttributes = h.getStyleAttributesValues();
            for (CSSStyleAttributeHandler.StyleAttribute value : styleAttributes) {
                this.searchInsideValue(value, tsd, fileToParse);
                this.report.message(MessageId.ACC_013, EPUBLocation.create(fileToParse, value.getLine(), value.getColumn(), value.getValue()), new Object[0]);
            }
        }
        this.CheckUnusedCSSClassSelectors(handler, this.report);
        if (numCssFiles > 10) {
            this.report.message(MessageId.CSS_011, EPUBLocation.create(this.epack.getFileName()), new Object[0]);
        }
        return true;
    }

    boolean getHasFixedFormatItems(EpubPackage epack) {
        for (int i = 0; i < epack.getManifest().itemsLength(); ++i) {
            ManifestItem itemEntry = epack.getManifest().getItem(i);
            String properties = itemEntry.getProperties();
            if (properties == null || !properties.contains("rendition:layout-pre-paginated")) continue;
            return true;
        }
        return false;
    }

    void CheckUnusedCSSClassSelectors(EpubCSSCheckCSSHandler handler, Report report) {
        if (handler != null) {
            handler.CheckUnusedCSSClassSelectors(report);
        }
    }

    static String getEntryFileName(ManifestItem itemEntry, EpubPackage epack) {
        String fileToParse = epack.getPackageMainPath() != null && epack.getPackageMainPath().length() > 0 ? PathUtil.resolveRelativeReference(epack.getPackageMainFile(), itemEntry.getHref(), null) : itemEntry.getHref();
        return fileToParse;
    }

    InputStream getInputStream(String name) throws IOException {
        ZipEntry entry = this.zip.getEntry(name);
        if (entry == null) {
            return null;
        }
        InputStream in = this.zip.getInputStream(entry);
        EncryptionFilter filter = this.enc.get(name);
        if (filter == null) {
            return in;
        }
        if (filter.canDecrypt()) {
            return filter.decrypt(in);
        }
        return null;
    }

    void searchInsideValue(CSSStyleAttributeHandler.StyleAttribute entry, SearchDictionary tds, String file) {
        for (int s = 0; s < tds.getDictEntries().size(); ++s) {
            TextSearchDictionaryEntry de = tds.getDictEntries().get(s);
            MessageId messageCode = de.getErrorCode();
            Pattern p = de.getPattern();
            Matcher matcher = p.matcher(entry.getValue());
            int position = 0;
            while (matcher.find(position)) {
                position = matcher.end();
                this.report.message(messageCode, EPUBLocation.create(file, entry.getLine(), entry.getColumn(), entry.getValue().trim()), new Object[0]);
            }
        }
    }
}

