/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import py4j.CallCommand;
import py4j.Command;
import py4j.Gateway;
import py4j.GatewayServer;
import py4j.ListCommand;
import py4j.NetworkUtil;
import py4j.StopGatewayCommand;

public class GatewayConnection
implements Runnable {
    private final Gateway gateway;
    private final GatewayServer gatewayServer;
    private final Socket socket;
    private final BufferedWriter writer;
    private final BufferedReader reader;
    private final Map<String, Command> commands;
    private final Logger logger = Logger.getLogger(GatewayConnection.class.getName());

    public GatewayConnection(GatewayServer gatewayServer, Gateway gateway, Socket socket) throws IOException {
        this.gateway = gateway;
        this.gatewayServer = gatewayServer;
        this.socket = socket;
        this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), Charset.forName("UTF-8")));
        this.writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), Charset.forName("UTF-8")));
        this.commands = new HashMap<String, Command>();
        this.initCommands(gateway);
        Thread t = new Thread(this);
        t.start();
    }

    protected void initCommands(Gateway gateway) {
        CallCommand callCommand = new CallCommand();
        ListCommand listCommand = new ListCommand();
        StopGatewayCommand stopCommand = new StopGatewayCommand(this.gatewayServer);
        callCommand.init(gateway);
        listCommand.init(gateway);
        stopCommand.init(gateway);
        this.commands.put("c", callCommand);
        this.commands.put("l", listCommand);
        this.commands.put("s", stopCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String commandLine = null;
            do {
                commandLine = this.reader.readLine();
                this.logger.info("Received command: " + commandLine);
                Command command = this.commands.get(commandLine);
                if (command == null) continue;
                command.execute(commandLine, this.reader, this.writer);
            } while (commandLine != null && !commandLine.equals(Character.valueOf('q')));
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error occurred while waiting for a command.", e);
        }
        finally {
            this.logger.log(Level.INFO, "Closing connection.");
            NetworkUtil.quietlyClose(this.writer);
            NetworkUtil.quietlyClose(this.reader);
            NetworkUtil.quietlyClose(this.socket);
        }
    }
}

