# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AvailableOperation(Model):
    """Resource provider available operation model.

    :param display: The list of operations
    :type display:
     ~azure.mgmt.vmwarecloudsimple.models.AvailableOperationDisplay
    :param is_data_action: Indicating whether the operation is a data action
     or not. Default value: False .
    :type is_data_action: bool
    :param name:
     {resourceProviderNamespace}/{resourceType}/{read|write|delete|action}
    :type name: str
    :param origin: The origin of operation. Possible values include: 'user',
     'system', 'user,system'
    :type origin: str or ~azure.mgmt.vmwarecloudsimple.models.OperationOrigin
    :param service_specification: The list of specification's service metrics
    :type service_specification:
     ~azure.mgmt.vmwarecloudsimple.models.AvailableOperationDisplayPropertyServiceSpecificationMetricsList
    """

    _attribute_map = {
        'display': {'key': 'display', 'type': 'AvailableOperationDisplay'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'origin': {'key': 'origin', 'type': 'OperationOrigin'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'AvailableOperationDisplayPropertyServiceSpecificationMetricsList'},
    }

    def __init__(self, *, display=None, is_data_action: bool=False, name: str=None, origin=None, service_specification=None, **kwargs) -> None:
        super(AvailableOperation, self).__init__(**kwargs)
        self.display = display
        self.is_data_action = is_data_action
        self.name = name
        self.origin = origin
        self.service_specification = service_specification


class AvailableOperationDisplay(Model):
    """Resource provider available operation display model.

    :param description: Description of the operation for display purposes
    :type description: str
    :param operation: Name of the operation for display purposes
    :type operation: str
    :param provider: Name of the provider for display purposes
    :type provider: str
    :param resource: Name of the resource type for display purposes
    :type resource: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
    }

    def __init__(self, *, description: str=None, operation: str=None, provider: str=None, resource: str=None, **kwargs) -> None:
        super(AvailableOperationDisplay, self).__init__(**kwargs)
        self.description = description
        self.operation = operation
        self.provider = provider
        self.resource = resource


class AvailableOperationDisplayPropertyServiceSpecificationMetricsItem(Model):
    """Available operation display property service specification metrics item.

    All required parameters must be populated in order to send to Azure.

    :param aggregation_type: Required. Metric's aggregation type for e.g.
     (Average, Total). Possible values include: 'Average', 'Total'
    :type aggregation_type: str or
     ~azure.mgmt.vmwarecloudsimple.models.AggregationType
    :param display_description: Required. Metric's description
    :type display_description: str
    :param display_name: Required. Human readable metric's name
    :type display_name: str
    :param name: Required. Metric's name/id
    :type name: str
    :param unit: Required. Metric's unit
    :type unit: str
    """

    _validation = {
        'aggregation_type': {'required': True},
        'display_description': {'required': True},
        'display_name': {'required': True},
        'name': {'required': True},
        'unit': {'required': True},
    }

    _attribute_map = {
        'aggregation_type': {'key': 'aggregationType', 'type': 'AggregationType'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(self, *, aggregation_type, display_description: str, display_name: str, name: str, unit: str, **kwargs) -> None:
        super(AvailableOperationDisplayPropertyServiceSpecificationMetricsItem, self).__init__(**kwargs)
        self.aggregation_type = aggregation_type
        self.display_description = display_description
        self.display_name = display_name
        self.name = name
        self.unit = unit


class AvailableOperationDisplayPropertyServiceSpecificationMetricsList(Model):
    """List of available operation display property service specification metrics.

    :param metric_specifications: Metric specifications of operation
    :type metric_specifications:
     list[~azure.mgmt.vmwarecloudsimple.models.AvailableOperationDisplayPropertyServiceSpecificationMetricsItem]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[AvailableOperationDisplayPropertyServiceSpecificationMetricsItem]'},
    }

    def __init__(self, *, metric_specifications=None, **kwargs) -> None:
        super(AvailableOperationDisplayPropertyServiceSpecificationMetricsList, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class CSRPError(Model):
    """General error model.

    :param error: Error's body
    :type error: ~azure.mgmt.vmwarecloudsimple.models.CSRPErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CSRPErrorBody'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(CSRPError, self).__init__(**kwargs)
        self.error = error


class CSRPErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CSRPError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CSRPErrorException, self).__init__(deserialize, response, 'CSRPError', *args)


class CSRPErrorBody(Model):
    """Error properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Error's code
    :vartype code: str
    :ivar details: Error's details
    :vartype details: list[~azure.mgmt.vmwarecloudsimple.models.CSRPErrorBody]
    :ivar message: Error's message
    :vartype message: str
    :param target: Error's target
    :type target: str
    """

    _validation = {
        'code': {'readonly': True},
        'details': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CSRPErrorBody]'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(self, *, target: str=None, **kwargs) -> None:
        super(CSRPErrorBody, self).__init__(**kwargs)
        self.code = None
        self.details = None
        self.message = None
        self.target = target


class DedicatedCloudNode(Model):
    """Dedicated cloud node model.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/dedicatedCloudNodes/{dedicatedCloudNodeName}
    :vartype id: str
    :param location: Required. Azure region
    :type location: str
    :ivar name: {dedicatedCloudNodeName}
    :vartype name: str
    :param availability_zone_id: Required. Availability Zone id, e.g. "az1"
    :type availability_zone_id: str
    :ivar availability_zone_name: Availability Zone name, e.g. "Availability
     Zone 1"
    :vartype availability_zone_name: str
    :ivar cloud_rack_name: VMWare Cloud Rack Name
    :vartype cloud_rack_name: str
    :ivar created: date time the resource was created
    :vartype created: object
    :param nodes_count: Required. count of nodes to create
    :type nodes_count: int
    :param placement_group_id: Required. Placement Group id, e.g. "n1"
    :type placement_group_id: str
    :ivar placement_group_name: Placement Name, e.g. "Placement Group 1"
    :vartype placement_group_name: str
    :ivar private_cloud_id: Private Cloud Id
    :vartype private_cloud_id: str
    :ivar private_cloud_name: Resource Pool Name
    :vartype private_cloud_name: str
    :ivar provisioning_state: The provisioning status of the resource
    :vartype provisioning_state: str
    :param purchase_id: Required. purchase id
    :type purchase_id: str
    :param id1: Required. SKU's id
    :type id1: str
    :param name1: Required. SKU's name
    :type name1: str
    :ivar status: Node status, indicates is private cloud set up on this node
     or not. Possible values include: 'unused', 'used'
    :vartype status: str or ~azure.mgmt.vmwarecloudsimple.models.NodeStatus
    :ivar vmware_cluster_name: VMWare Cluster Name
    :vartype vmware_cluster_name: str
    :param sku: Dedicated Cloud Nodes SKU
    :type sku: ~azure.mgmt.vmwarecloudsimple.models.Sku
    :param tags: Dedicated Cloud Nodes tags
    :type tags: dict[str, str]
    :ivar type: {resourceProviderNamespace}/{resourceType}
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'location': {'required': True},
        'name': {'readonly': True, 'pattern': r'^[-a-zA-Z0-9]+$'},
        'availability_zone_id': {'required': True},
        'availability_zone_name': {'readonly': True},
        'cloud_rack_name': {'readonly': True},
        'created': {'readonly': True},
        'nodes_count': {'required': True},
        'placement_group_id': {'required': True},
        'placement_group_name': {'readonly': True},
        'private_cloud_id': {'readonly': True},
        'private_cloud_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'purchase_id': {'required': True},
        'id1': {'required': True},
        'name1': {'required': True},
        'status': {'readonly': True},
        'vmware_cluster_name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'availability_zone_id': {'key': 'properties.availabilityZoneId', 'type': 'str'},
        'availability_zone_name': {'key': 'properties.availabilityZoneName', 'type': 'str'},
        'cloud_rack_name': {'key': 'properties.cloudRackName', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'object'},
        'nodes_count': {'key': 'properties.nodesCount', 'type': 'int'},
        'placement_group_id': {'key': 'properties.placementGroupId', 'type': 'str'},
        'placement_group_name': {'key': 'properties.placementGroupName', 'type': 'str'},
        'private_cloud_id': {'key': 'properties.privateCloudId', 'type': 'str'},
        'private_cloud_name': {'key': 'properties.privateCloudName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'purchase_id': {'key': 'properties.purchaseId', 'type': 'str'},
        'id1': {'key': 'properties.skuDescription.id', 'type': 'str'},
        'name1': {'key': 'properties.skuDescription.name', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'NodeStatus'},
        'vmware_cluster_name': {'key': 'properties.vmwareClusterName', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, location: str, availability_zone_id: str, nodes_count: int, placement_group_id: str, purchase_id: str, id1: str, name1: str, sku=None, tags=None, **kwargs) -> None:
        super(DedicatedCloudNode, self).__init__(**kwargs)
        self.id = None
        self.location = location
        self.name = None
        self.availability_zone_id = availability_zone_id
        self.availability_zone_name = None
        self.cloud_rack_name = None
        self.created = None
        self.nodes_count = nodes_count
        self.placement_group_id = placement_group_id
        self.placement_group_name = None
        self.private_cloud_id = None
        self.private_cloud_name = None
        self.provisioning_state = None
        self.purchase_id = purchase_id
        self.id1 = id1
        self.name1 = name1
        self.status = None
        self.vmware_cluster_name = None
        self.sku = sku
        self.tags = tags
        self.type = None


class DedicatedCloudService(Model):
    """Dedicated cloud service model.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/dedicatedCloudServices/{dedicatedCloudServiceName}
    :vartype id: str
    :param location: Required. Azure region
    :type location: str
    :ivar name: {dedicatedCloudServiceName}
    :vartype name: str
    :param gateway_subnet: Required. gateway Subnet for the account. It will
     collect the subnet address and always treat it as /28
    :type gateway_subnet: str
    :ivar is_account_onboarded: indicates whether account onboarded or not in
     a given region. Possible values include: 'notOnBoarded', 'onBoarded',
     'onBoardingFailed', 'onBoarding'
    :vartype is_account_onboarded: str or
     ~azure.mgmt.vmwarecloudsimple.models.OnboardingStatus
    :param nodes: total nodes purchased
    :type nodes: int
    :param service_url: link to a service management web portal
    :type service_url: str
    :param tags: The list of tags
    :type tags: dict[str, str]
    :ivar type: {resourceProviderNamespace}/{resourceType}
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'location': {'required': True},
        'name': {'readonly': True, 'pattern': r'^[-a-zA-Z0-9]+$'},
        'gateway_subnet': {'required': True},
        'is_account_onboarded': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'gateway_subnet': {'key': 'properties.gatewaySubnet', 'type': 'str'},
        'is_account_onboarded': {'key': 'properties.isAccountOnboarded', 'type': 'OnboardingStatus'},
        'nodes': {'key': 'properties.nodes', 'type': 'int'},
        'service_url': {'key': 'properties.serviceURL', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, location: str, gateway_subnet: str, nodes: int=None, service_url: str=None, tags=None, **kwargs) -> None:
        super(DedicatedCloudService, self).__init__(**kwargs)
        self.id = None
        self.location = location
        self.name = None
        self.gateway_subnet = gateway_subnet
        self.is_account_onboarded = None
        self.nodes = nodes
        self.service_url = service_url
        self.tags = tags
        self.type = None


class OperationError(Model):
    """Operation error model.

    :param code: Error's code
    :type code: str
    :param message: Error's message
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, message: str=None, **kwargs) -> None:
        super(OperationError, self).__init__(**kwargs)
        self.code = code
        self.message = message


class OperationResource(Model):
    """Operation status response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar end_time: End time of the operation
    :vartype end_time: datetime
    :param error: Error Message if operation failed
    :type error: ~azure.mgmt.vmwarecloudsimple.models.OperationError
    :ivar id: Operation Id
    :vartype id: str
    :ivar name: Operation ID
    :vartype name: str
    :ivar start_time: Start time of the operation
    :vartype start_time: datetime
    :ivar status: Operation status
    :vartype status: str
    """

    _validation = {
        'end_time': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'start_time': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'OperationError'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(OperationResource, self).__init__(**kwargs)
        self.end_time = None
        self.error = error
        self.id = None
        self.name = None
        self.start_time = None
        self.status = None


class PatchPayload(Model):
    """General patch payload modal.

    :param tags: The tags key:value pairs
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(PatchPayload, self).__init__(**kwargs)
        self.tags = tags


class PrivateCloud(Model):
    """Private cloud model.

    :param id: Azure Id, e.g.
     "/subscriptions/4da99247-a172-4ed6-8ae9-ebed2d12f839/providers/Microsoft.VMwareCloudSimple/privateClouds/cloud123"
    :type id: str
    :param location: Location where private cloud created, e.g "westus"
    :type location: str
    :param name: Private cloud name
    :type name: str
    :param availability_zone_id: Availability Zone id, e.g. "az1"
    :type availability_zone_id: str
    :param availability_zone_name: Availability Zone name, e.g. "Availability
     Zone 1"
    :type availability_zone_name: str
    :param clusters_number: Number of clusters
    :type clusters_number: int
    :param created_by: User's emails who created cloud
    :type created_by: str
    :param created_on: When private cloud was created
    :type created_on: datetime
    :param dns_servers: Array of DNS servers
    :type dns_servers: list[str]
    :param expires: Expiration date of PC
    :type expires: str
    :param nsx_type: Nsx Type, e.g. "Advanced"
    :type nsx_type: str
    :param placement_group_id: Placement Group id, e.g. "n1"
    :type placement_group_id: str
    :param placement_group_name: Placement Group name
    :type placement_group_name: str
    :param private_cloud_id: Id of a private cloud
    :type private_cloud_id: str
    :param resource_pools: The list of Resource Pools
    :type resource_pools:
     list[~azure.mgmt.vmwarecloudsimple.models.ResourcePool]
    :param state: Private Cloud state, e.g. "operational"
    :type state: str
    :param total_cpu_cores: Number of cores
    :type total_cpu_cores: int
    :param total_nodes: Number of nodes
    :type total_nodes: int
    :param total_ram: Memory size
    :type total_ram: int
    :param total_storage: Disk space in TB
    :type total_storage: float
    :param private_cloud_properties_type: Virtualization type e.g. "vSphere"
    :type private_cloud_properties_type: str
    :param v_sphere_version: e.g. "6.5u2"
    :type v_sphere_version: str
    :param vcenter_fqdn: FQDN for vcenter access
    :type vcenter_fqdn: str
    :param vcenter_refid: Vcenter ip address
    :type vcenter_refid: str
    :param virtual_machine_templates: The list of Virtual Machine Templates
    :type virtual_machine_templates:
     list[~azure.mgmt.vmwarecloudsimple.models.VirtualMachineTemplate]
    :param virtual_networks: The list of Virtual Networks
    :type virtual_networks:
     list[~azure.mgmt.vmwarecloudsimple.models.VirtualNetwork]
    :param vr_ops_enabled: Is Vrops enabled/disabled
    :type vr_ops_enabled: bool
    :param type: Azure Resource type. Possible values include:
     'Microsoft.VMwareCloudSimple/privateClouds'
    :type type: str or
     ~azure.mgmt.vmwarecloudsimple.models.PrivateCloudResourceType
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'availability_zone_id': {'key': 'properties.availabilityZoneId', 'type': 'str'},
        'availability_zone_name': {'key': 'properties.availabilityZoneName', 'type': 'str'},
        'clusters_number': {'key': 'properties.clustersNumber', 'type': 'int'},
        'created_by': {'key': 'properties.createdBy', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'dns_servers': {'key': 'properties.dnsServers', 'type': '[str]'},
        'expires': {'key': 'properties.expires', 'type': 'str'},
        'nsx_type': {'key': 'properties.nsxType', 'type': 'str'},
        'placement_group_id': {'key': 'properties.placementGroupId', 'type': 'str'},
        'placement_group_name': {'key': 'properties.placementGroupName', 'type': 'str'},
        'private_cloud_id': {'key': 'properties.privateCloudId', 'type': 'str'},
        'resource_pools': {'key': 'properties.resourcePools', 'type': '[ResourcePool]'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'total_cpu_cores': {'key': 'properties.totalCpuCores', 'type': 'int'},
        'total_nodes': {'key': 'properties.totalNodes', 'type': 'int'},
        'total_ram': {'key': 'properties.totalRam', 'type': 'int'},
        'total_storage': {'key': 'properties.totalStorage', 'type': 'float'},
        'private_cloud_properties_type': {'key': 'properties.type', 'type': 'str'},
        'v_sphere_version': {'key': 'properties.vSphereVersion', 'type': 'str'},
        'vcenter_fqdn': {'key': 'properties.vcenterFqdn', 'type': 'str'},
        'vcenter_refid': {'key': 'properties.vcenterRefid', 'type': 'str'},
        'virtual_machine_templates': {'key': 'properties.virtualMachineTemplates', 'type': '[VirtualMachineTemplate]'},
        'virtual_networks': {'key': 'properties.virtualNetworks', 'type': '[VirtualNetwork]'},
        'vr_ops_enabled': {'key': 'properties.vrOpsEnabled', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'PrivateCloudResourceType'},
    }

    def __init__(self, *, id: str=None, location: str=None, name: str=None, availability_zone_id: str=None, availability_zone_name: str=None, clusters_number: int=None, created_by: str=None, created_on=None, dns_servers=None, expires: str=None, nsx_type: str=None, placement_group_id: str=None, placement_group_name: str=None, private_cloud_id: str=None, resource_pools=None, state: str=None, total_cpu_cores: int=None, total_nodes: int=None, total_ram: int=None, total_storage: float=None, private_cloud_properties_type: str=None, v_sphere_version: str=None, vcenter_fqdn: str=None, vcenter_refid: str=None, virtual_machine_templates=None, virtual_networks=None, vr_ops_enabled: bool=None, type=None, **kwargs) -> None:
        super(PrivateCloud, self).__init__(**kwargs)
        self.id = id
        self.location = location
        self.name = name
        self.availability_zone_id = availability_zone_id
        self.availability_zone_name = availability_zone_name
        self.clusters_number = clusters_number
        self.created_by = created_by
        self.created_on = created_on
        self.dns_servers = dns_servers
        self.expires = expires
        self.nsx_type = nsx_type
        self.placement_group_id = placement_group_id
        self.placement_group_name = placement_group_name
        self.private_cloud_id = private_cloud_id
        self.resource_pools = resource_pools
        self.state = state
        self.total_cpu_cores = total_cpu_cores
        self.total_nodes = total_nodes
        self.total_ram = total_ram
        self.total_storage = total_storage
        self.private_cloud_properties_type = private_cloud_properties_type
        self.v_sphere_version = v_sphere_version
        self.vcenter_fqdn = vcenter_fqdn
        self.vcenter_refid = vcenter_refid
        self.virtual_machine_templates = virtual_machine_templates
        self.virtual_networks = virtual_networks
        self.vr_ops_enabled = vr_ops_enabled
        self.type = type


class ResourcePool(Model):
    """Resource pool model.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. resource pool id (privateCloudId:vsphereId)
    :type id: str
    :ivar location: Azure region
    :vartype location: str
    :ivar name: {ResourcePoolName}
    :vartype name: str
    :ivar private_cloud_id: The Private Cloud Id
    :vartype private_cloud_id: str
    :ivar full_name: Hierarchical resource pool name
    :vartype full_name: str
    :ivar type: {resourceProviderNamespace}/{resourceType}
    :vartype type: str
    """

    _validation = {
        'id': {'required': True},
        'location': {'readonly': True},
        'name': {'readonly': True},
        'private_cloud_id': {'readonly': True},
        'full_name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'private_cloud_id': {'key': 'privateCloudId', 'type': 'str'},
        'full_name': {'key': 'properties.fullName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(ResourcePool, self).__init__(**kwargs)
        self.id = id
        self.location = None
        self.name = None
        self.private_cloud_id = None
        self.full_name = None
        self.type = None


class Sku(Model):
    """The purchase SKU for CloudSimple paid resources.

    All required parameters must be populated in order to send to Azure.

    :param capacity: The capacity of the SKU
    :type capacity: str
    :param description: dedicatedCloudNode example: 8 x Ten-Core Intel® Xeon®
     Processor E5-2640 v4 2.40GHz 25MB Cache (90W); 12 x 64GB PC4-19200 2400MHz
     DDR4 ECC Registered DIMM, ...
    :type description: str
    :param family: If the service has different generations of hardware, for
     the same SKU, then that can be captured here
    :type family: str
    :param name: Required. The name of the SKU for VMWare CloudSimple Node
    :type name: str
    :param tier: The tier of the SKU
    :type tier: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'capacity': {'key': 'capacity', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(self, *, name: str, capacity: str=None, description: str=None, family: str=None, tier: str=None, **kwargs) -> None:
        super(Sku, self).__init__(**kwargs)
        self.capacity = capacity
        self.description = description
        self.family = family
        self.name = name
        self.tier = tier


class SkuAvailability(Model):
    """SKU availability model.

    All required parameters must be populated in order to send to Azure.

    :param dedicated_availability_zone_id: CloudSimple Availability Zone id
    :type dedicated_availability_zone_id: str
    :param dedicated_availability_zone_name: CloudSimple Availability Zone
     Name
    :type dedicated_availability_zone_name: str
    :param dedicated_placement_group_id: CloudSimple Placement Group Id
    :type dedicated_placement_group_id: str
    :param dedicated_placement_group_name: CloudSimple Placement Group name
    :type dedicated_placement_group_name: str
    :param limit: Required. indicates how many resources of a given SKU is
     available in a AZ->PG
    :type limit: int
    :param resource_type: resource type e.g. DedicatedCloudNodes
    :type resource_type: str
    :param sku_id: sku id
    :type sku_id: str
    :param sku_name: sku name
    :type sku_name: str
    """

    _validation = {
        'limit': {'required': True},
    }

    _attribute_map = {
        'dedicated_availability_zone_id': {'key': 'dedicatedAvailabilityZoneId', 'type': 'str'},
        'dedicated_availability_zone_name': {'key': 'dedicatedAvailabilityZoneName', 'type': 'str'},
        'dedicated_placement_group_id': {'key': 'dedicatedPlacementGroupId', 'type': 'str'},
        'dedicated_placement_group_name': {'key': 'dedicatedPlacementGroupName', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'int'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku_id': {'key': 'skuId', 'type': 'str'},
        'sku_name': {'key': 'skuName', 'type': 'str'},
    }

    def __init__(self, *, limit: int, dedicated_availability_zone_id: str=None, dedicated_availability_zone_name: str=None, dedicated_placement_group_id: str=None, dedicated_placement_group_name: str=None, resource_type: str=None, sku_id: str=None, sku_name: str=None, **kwargs) -> None:
        super(SkuAvailability, self).__init__(**kwargs)
        self.dedicated_availability_zone_id = dedicated_availability_zone_id
        self.dedicated_availability_zone_name = dedicated_availability_zone_name
        self.dedicated_placement_group_id = dedicated_placement_group_id
        self.dedicated_placement_group_name = dedicated_placement_group_name
        self.limit = limit
        self.resource_type = resource_type
        self.sku_id = sku_id
        self.sku_name = sku_name


class Usage(Model):
    """Usage model.

    All required parameters must be populated in order to send to Azure.

    :param current_value: Required. The current usage value. Default value: 0
     .
    :type current_value: int
    :param limit: Required. limit of a given sku in a region for a
     subscription. The maximum permitted value for the usage quota. If there is
     no limit, this value will be -1. Default value: 0 .
    :type limit: int
    :param name: Usage name value and localized name
    :type name: ~azure.mgmt.vmwarecloudsimple.models.UsageName
    :param unit: The usages' unit. Possible values include: 'Count', 'Bytes',
     'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond'
    :type unit: str or ~azure.mgmt.vmwarecloudsimple.models.UsageCount
    """

    _validation = {
        'current_value': {'required': True},
        'limit': {'required': True},
    }

    _attribute_map = {
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
        'name': {'key': 'name', 'type': 'UsageName'},
        'unit': {'key': 'unit', 'type': 'UsageCount'},
    }

    def __init__(self, *, current_value: int=0, limit: int=0, name=None, unit=None, **kwargs) -> None:
        super(Usage, self).__init__(**kwargs)
        self.current_value = current_value
        self.limit = limit
        self.name = name
        self.unit = unit


class UsageName(Model):
    """User name model.

    :param localized_value: e.g. "Virtual Machines"
    :type localized_value: str
    :param value: resource type or resource type sku name, e.g.
     virtualMachines
    :type value: str
    """

    _attribute_map = {
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, localized_value: str=None, value: str=None, **kwargs) -> None:
        super(UsageName, self).__init__(**kwargs)
        self.localized_value = localized_value
        self.value = value


class VirtualDisk(Model):
    """Virtual disk model.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param controller_id: Required. Disk's Controller id
    :type controller_id: str
    :param independence_mode: Required. Disk's independence mode type.
     Possible values include: 'persistent', 'independent_persistent',
     'independent_nonpersistent'
    :type independence_mode: str or
     ~azure.mgmt.vmwarecloudsimple.models.DiskIndependenceMode
    :param total_size: Required. Disk's total size
    :type total_size: int
    :param virtual_disk_id: Disk's id
    :type virtual_disk_id: str
    :ivar virtual_disk_name: Disk's display name
    :vartype virtual_disk_name: str
    """

    _validation = {
        'controller_id': {'required': True},
        'independence_mode': {'required': True},
        'total_size': {'required': True},
        'virtual_disk_name': {'readonly': True},
    }

    _attribute_map = {
        'controller_id': {'key': 'controllerId', 'type': 'str'},
        'independence_mode': {'key': 'independenceMode', 'type': 'DiskIndependenceMode'},
        'total_size': {'key': 'totalSize', 'type': 'int'},
        'virtual_disk_id': {'key': 'virtualDiskId', 'type': 'str'},
        'virtual_disk_name': {'key': 'virtualDiskName', 'type': 'str'},
    }

    def __init__(self, *, controller_id: str, independence_mode, total_size: int, virtual_disk_id: str=None, **kwargs) -> None:
        super(VirtualDisk, self).__init__(**kwargs)
        self.controller_id = controller_id
        self.independence_mode = independence_mode
        self.total_size = total_size
        self.virtual_disk_id = virtual_disk_id
        self.virtual_disk_name = None


class VirtualDiskController(Model):
    """Virtual disk controller model.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Controller's id
    :vartype id: str
    :ivar name: The display name of Controller
    :vartype name: str
    :ivar sub_type: dik controller subtype (VMWARE_PARAVIRTUAL, BUS_PARALLEL,
     LSI_PARALLEL, LSI_SAS)
    :vartype sub_type: str
    :ivar type: disk controller type (SCSI)
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'sub_type': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'sub_type': {'key': 'subType', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(VirtualDiskController, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.sub_type = None
        self.type = None


class VirtualMachine(Model):
    """Virtual machine model.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/virtualMachines/{virtualMachineName}
    :vartype id: str
    :param location: Required. Azure region
    :type location: str
    :ivar name: {virtualMachineName}
    :vartype name: str
    :param amount_of_ram: Required. The amount of memory
    :type amount_of_ram: int
    :ivar controllers: The list of Virtual Disks' Controllers
    :vartype controllers:
     list[~azure.mgmt.vmwarecloudsimple.models.VirtualDiskController]
    :param disks: The list of Virtual Disks
    :type disks: list[~azure.mgmt.vmwarecloudsimple.models.VirtualDisk]
    :ivar dnsname: The DNS name of Virtual Machine in VCenter
    :vartype dnsname: str
    :param expose_to_guest_vm: Expose Guest OS or not
    :type expose_to_guest_vm: bool
    :ivar folder: The path to virtual machine folder in VCenter
    :vartype folder: str
    :ivar guest_os: The name of Guest OS
    :vartype guest_os: str
    :ivar guest_os_type: The Guest OS type. Possible values include: 'linux',
     'windows', 'other'
    :vartype guest_os_type: str or
     ~azure.mgmt.vmwarecloudsimple.models.GuestOSType
    :param nics: The list of Virtual NICs
    :type nics: list[~azure.mgmt.vmwarecloudsimple.models.VirtualNic]
    :param number_of_cores: Required. The number of CPU cores
    :type number_of_cores: int
    :param password: Password for login
    :type password: str
    :param private_cloud_id: Required. Private Cloud Id
    :type private_cloud_id: str
    :ivar provisioning_state: The provisioning status of the resource
    :vartype provisioning_state: str
    :ivar public_ip: The public ip of Virtual Machine
    :vartype public_ip: str
    :param resource_pool: Virtual Machines Resource Pool
    :type resource_pool: ~azure.mgmt.vmwarecloudsimple.models.ResourcePool
    :ivar status: The status of Virtual machine. Possible values include:
     'running', 'suspended', 'poweredoff', 'updating', 'deallocating',
     'deleting'
    :vartype status: str or
     ~azure.mgmt.vmwarecloudsimple.models.VirtualMachineStatus
    :param template_id: Virtual Machine Template Id
    :type template_id: str
    :param username: Username for login
    :type username: str
    :param v_sphere_networks: The list of Virtual VSphere Networks
    :type v_sphere_networks: list[str]
    :ivar vm_id: The internal id of Virtual Machine in VCenter
    :vartype vm_id: str
    :ivar vmwaretools: VMware tools version
    :vartype vmwaretools: str
    :param tags: The list of tags
    :type tags: dict[str, str]
    :ivar type: {resourceProviderNamespace}/{resourceType}
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'location': {'required': True},
        'name': {'readonly': True, 'pattern': r'^[-a-zA-Z0-9]+$'},
        'amount_of_ram': {'required': True},
        'controllers': {'readonly': True},
        'dnsname': {'readonly': True},
        'folder': {'readonly': True},
        'guest_os': {'readonly': True},
        'guest_os_type': {'readonly': True},
        'number_of_cores': {'required': True},
        'private_cloud_id': {'required': True},
        'provisioning_state': {'readonly': True},
        'public_ip': {'readonly': True},
        'status': {'readonly': True},
        'vm_id': {'readonly': True},
        'vmwaretools': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'amount_of_ram': {'key': 'properties.amountOfRam', 'type': 'int'},
        'controllers': {'key': 'properties.controllers', 'type': '[VirtualDiskController]'},
        'disks': {'key': 'properties.disks', 'type': '[VirtualDisk]'},
        'dnsname': {'key': 'properties.dnsname', 'type': 'str'},
        'expose_to_guest_vm': {'key': 'properties.exposeToGuestVM', 'type': 'bool'},
        'folder': {'key': 'properties.folder', 'type': 'str'},
        'guest_os': {'key': 'properties.guestOS', 'type': 'str'},
        'guest_os_type': {'key': 'properties.guestOSType', 'type': 'GuestOSType'},
        'nics': {'key': 'properties.nics', 'type': '[VirtualNic]'},
        'number_of_cores': {'key': 'properties.numberOfCores', 'type': 'int'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'private_cloud_id': {'key': 'properties.privateCloudId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'public_ip': {'key': 'properties.publicIP', 'type': 'str'},
        'resource_pool': {'key': 'properties.resourcePool', 'type': 'ResourcePool'},
        'status': {'key': 'properties.status', 'type': 'VirtualMachineStatus'},
        'template_id': {'key': 'properties.templateId', 'type': 'str'},
        'username': {'key': 'properties.username', 'type': 'str'},
        'v_sphere_networks': {'key': 'properties.vSphereNetworks', 'type': '[str]'},
        'vm_id': {'key': 'properties.vmId', 'type': 'str'},
        'vmwaretools': {'key': 'properties.vmwaretools', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, location: str, amount_of_ram: int, number_of_cores: int, private_cloud_id: str, disks=None, expose_to_guest_vm: bool=None, nics=None, password: str=None, resource_pool=None, template_id: str=None, username: str=None, v_sphere_networks=None, tags=None, **kwargs) -> None:
        super(VirtualMachine, self).__init__(**kwargs)
        self.id = None
        self.location = location
        self.name = None
        self.amount_of_ram = amount_of_ram
        self.controllers = None
        self.disks = disks
        self.dnsname = None
        self.expose_to_guest_vm = expose_to_guest_vm
        self.folder = None
        self.guest_os = None
        self.guest_os_type = None
        self.nics = nics
        self.number_of_cores = number_of_cores
        self.password = password
        self.private_cloud_id = private_cloud_id
        self.provisioning_state = None
        self.public_ip = None
        self.resource_pool = resource_pool
        self.status = None
        self.template_id = template_id
        self.username = username
        self.v_sphere_networks = v_sphere_networks
        self.vm_id = None
        self.vmwaretools = None
        self.tags = tags
        self.type = None


class VirtualMachineStopMode(Model):
    """List of virtual machine stop modes.

    :param mode: mode indicates a type of stop operation - reboot, suspend,
     shutdown or power-off. Possible values include: 'reboot', 'suspend',
     'shutdown', 'poweroff'
    :type mode: str or ~azure.mgmt.vmwarecloudsimple.models.StopMode
    """

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'StopMode'},
    }

    def __init__(self, *, mode=None, **kwargs) -> None:
        super(VirtualMachineStopMode, self).__init__(**kwargs)
        self.mode = mode


class VirtualMachineTemplate(Model):
    """Virtual machine template model.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: virtual machine template id (privateCloudId:vsphereId)
    :vartype id: str
    :param location: Azure region
    :type location: str
    :ivar name: {virtualMachineTemplateName}
    :vartype name: str
    :param amount_of_ram: The amount of memory
    :type amount_of_ram: int
    :param controllers: The list of Virtual Disk Controllers
    :type controllers:
     list[~azure.mgmt.vmwarecloudsimple.models.VirtualDiskController]
    :param description: The description of Virtual Machine Template
    :type description: str
    :param disks: The list of Virtual Disks
    :type disks: list[~azure.mgmt.vmwarecloudsimple.models.VirtualDisk]
    :param expose_to_guest_vm: Expose Guest OS or not
    :type expose_to_guest_vm: bool
    :ivar guest_os: The Guest OS
    :vartype guest_os: str
    :ivar guest_os_type: The Guest OS types
    :vartype guest_os_type: str
    :param nics: The list of Virtual NICs
    :type nics: list[~azure.mgmt.vmwarecloudsimple.models.VirtualNic]
    :param number_of_cores: The number of CPU cores
    :type number_of_cores: int
    :param path: path to folder
    :type path: str
    :param private_cloud_id: Required. The Private Cloud Id
    :type private_cloud_id: str
    :param v_sphere_networks: The list of VSphere networks
    :type v_sphere_networks: list[str]
    :param v_sphere_tags: The tags from VSphere
    :type v_sphere_tags: list[str]
    :ivar vmwaretools: The VMware tools version
    :vartype vmwaretools: str
    :ivar type: {resourceProviderNamespace}/{resourceType}
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'guest_os': {'readonly': True},
        'guest_os_type': {'readonly': True},
        'private_cloud_id': {'required': True},
        'vmwaretools': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'amount_of_ram': {'key': 'properties.amountOfRam', 'type': 'int'},
        'controllers': {'key': 'properties.controllers', 'type': '[VirtualDiskController]'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'disks': {'key': 'properties.disks', 'type': '[VirtualDisk]'},
        'expose_to_guest_vm': {'key': 'properties.exposeToGuestVM', 'type': 'bool'},
        'guest_os': {'key': 'properties.guestOS', 'type': 'str'},
        'guest_os_type': {'key': 'properties.guestOSType', 'type': 'str'},
        'nics': {'key': 'properties.nics', 'type': '[VirtualNic]'},
        'number_of_cores': {'key': 'properties.numberOfCores', 'type': 'int'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'private_cloud_id': {'key': 'properties.privateCloudId', 'type': 'str'},
        'v_sphere_networks': {'key': 'properties.vSphereNetworks', 'type': '[str]'},
        'v_sphere_tags': {'key': 'properties.vSphereTags', 'type': '[str]'},
        'vmwaretools': {'key': 'properties.vmwaretools', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, private_cloud_id: str, location: str=None, amount_of_ram: int=None, controllers=None, description: str=None, disks=None, expose_to_guest_vm: bool=None, nics=None, number_of_cores: int=None, path: str=None, v_sphere_networks=None, v_sphere_tags=None, **kwargs) -> None:
        super(VirtualMachineTemplate, self).__init__(**kwargs)
        self.id = None
        self.location = location
        self.name = None
        self.amount_of_ram = amount_of_ram
        self.controllers = controllers
        self.description = description
        self.disks = disks
        self.expose_to_guest_vm = expose_to_guest_vm
        self.guest_os = None
        self.guest_os_type = None
        self.nics = nics
        self.number_of_cores = number_of_cores
        self.path = path
        self.private_cloud_id = private_cloud_id
        self.v_sphere_networks = v_sphere_networks
        self.v_sphere_tags = v_sphere_tags
        self.vmwaretools = None
        self.type = None


class VirtualNetwork(Model):
    """Virtual network model.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar assignable: can be used in vm creation/deletion
    :vartype assignable: bool
    :param id: Required. virtual network id (privateCloudId:vsphereId)
    :type id: str
    :ivar location: Azure region
    :vartype location: str
    :ivar name: {VirtualNetworkName}
    :vartype name: str
    :ivar private_cloud_id: The Private Cloud id
    :vartype private_cloud_id: str
    :ivar type: {resourceProviderNamespace}/{resourceType}
    :vartype type: str
    """

    _validation = {
        'assignable': {'readonly': True},
        'id': {'required': True},
        'location': {'readonly': True},
        'name': {'readonly': True},
        'private_cloud_id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'assignable': {'key': 'assignable', 'type': 'bool'},
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'private_cloud_id': {'key': 'properties.privateCloudId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(VirtualNetwork, self).__init__(**kwargs)
        self.assignable = None
        self.id = id
        self.location = None
        self.name = None
        self.private_cloud_id = None
        self.type = None


class VirtualNic(Model):
    """Virtual NIC model.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param ip_addresses: NIC ip address
    :type ip_addresses: list[str]
    :param mac_address: NIC MAC address
    :type mac_address: str
    :param network: Required. Virtual Network
    :type network: ~azure.mgmt.vmwarecloudsimple.models.VirtualNetwork
    :param nic_type: Required. NIC type. Possible values include: 'E1000',
     'E1000E', 'PCNET32', 'VMXNET', 'VMXNET2', 'VMXNET3'
    :type nic_type: str or ~azure.mgmt.vmwarecloudsimple.models.NICType
    :param power_on_boot: Is NIC powered on/off on boot
    :type power_on_boot: bool
    :param virtual_nic_id: NIC id
    :type virtual_nic_id: str
    :ivar virtual_nic_name: NIC name
    :vartype virtual_nic_name: str
    """

    _validation = {
        'network': {'required': True},
        'nic_type': {'required': True},
        'virtual_nic_name': {'readonly': True},
    }

    _attribute_map = {
        'ip_addresses': {'key': 'ipAddresses', 'type': '[str]'},
        'mac_address': {'key': 'macAddress', 'type': 'str'},
        'network': {'key': 'network', 'type': 'VirtualNetwork'},
        'nic_type': {'key': 'nicType', 'type': 'NICType'},
        'power_on_boot': {'key': 'powerOnBoot', 'type': 'bool'},
        'virtual_nic_id': {'key': 'virtualNicId', 'type': 'str'},
        'virtual_nic_name': {'key': 'virtualNicName', 'type': 'str'},
    }

    def __init__(self, *, network, nic_type, ip_addresses=None, mac_address: str=None, power_on_boot: bool=None, virtual_nic_id: str=None, **kwargs) -> None:
        super(VirtualNic, self).__init__(**kwargs)
        self.ip_addresses = ip_addresses
        self.mac_address = mac_address
        self.network = network
        self.nic_type = nic_type
        self.power_on_boot = power_on_boot
        self.virtual_nic_id = virtual_nic_id
        self.virtual_nic_name = None
