# -*- coding: utf-8 -*-
"""
Created on Fri Jun 03 17:21:39 2016

@author: b3053674
"""

from pydentify import *



'''
This script shows you how to run a profile likelihood 
calculation using copasi and pydentify from the parameters
that were estimated and printed to a file and then placed into a folder. 

Sometimes you'll have multiple parameter estimation results files from different
runs of the same problem (incidently this is the type of PE data I get from a cluster).
In this case, put all these parameter estimation data files into a folder 
and pydentify can work from there. See the 'Results' folder for an example. 

Parameter sets are automaticaly ranked with parameter set 0 being the parameter 
set with the lowest RSS. The MultiProfileLikelihood class takes parameters
from the results folder and inserts them into copasi using the python
module 'insert_copasi_parameters'. You can calculate profile likelihoods around
as many parameter sets as you like by providing the corresponding index i.e.
range(3), range(5), [0,1,2,3,4,5,6] would calculate PLs around the top 4, top 6 and top 7
parameter sets respectively. In this script, we'll just do the top two parameters sets. 
'''

#replace with the correspondiong path on your own machine. Note the r at the begining of the string to remove escape characters
copasi_file=r'D:\MPhil\Model_Building\Models\Exercises\pydentify_examples\Vilar2006\Vilar_example\ProfileLikelihoodFromParametersInFolder_Top100\vilar2006.cps'

#path to parameter estimation data. Replace with your machine specific path
PE_results_folder=r'D:\MPhil\Model_Building\Models\Exercises\pydentify_examples\Vilar2006\Vilar_example\ProfileLikelihoodFromParametersInFolder_Top100\PE_Data'

#initialize multiprofile likelihood class
#MPL=pydentify.MultiProfileLikelihood(copasi_file,[0,1],results_dir=PE_results_folder,lb=15,ub=15,intervals=10)

#MPL.run('slow')

#we now initialize an instance of the MultiPlot class
#Notice we already have the RSS value now from file and do not need to supply it manually
M=pydentify.MultiPlot(copasi_file,PE_results_folder)
#you can plot the profiles of a single index, i.e. just the best or second best parameter set
#M.plot_index(0,savefig=True)
#or you can plot all indexes in one command
M.plot_all_indexes(savefig=True,multiplot=True,axis_size=22,fontsize=28,extra_title='multiplot')
##The multiplot option allows multiple profiles from different indexes to be plotted on the same axis
#M.plot_all_indexes(savefig=True,multiplot=True,extra_title='multiplot')



#Other arguments can be found in the documentation









