#!/usr/bin/env python
# -*- coding: utf-8 -*-
__docformat__ = 'restructuredtext en'


################################################################################
"""

Lot of files generated by the collective.generic packages  will try to load user defined objects in user specific files.
The final goal is to regenerate easyly the test infrastructure on templates updates without impacting
user-specific test boilerplate.
We do not use paster local commands (insert/update) as it cannot determine witch is specific or not and we prefer to totally
separe generated stuff and what is user specific



If you need to edit something in this file, you must have better to do it in:


    - user_globals.py

All from there will be imported in this namespace

"""
################################################################################



import os
# try to import, but not fail as we can do without (for example in a thirdparty which adapt the testcase)
try: from collective.portlet.localcumulus.app_config import GLOBALS
except:pass
try: from collective.portlet.localcumulus.app_config import PRODUCT_DEPENDENCIES
except:pass
try: from collective.portlet.localcumulus.app_config import SKIN
except:pass
try:from collective.portlet.localcumulus.tests_tools import getWorkflows
except:pass
try:from portal_properties import check_portal_properties
except:pass
try:from portal_mailhost import check_portal_mailhost
except:pass
try:from five.grok.testing import grok as fgrok
except:pass
try:
    from Products.Five.testbrowser import Browser
    browser = Browser()
except:pass
try:from Products.statusmessages.interfaces import IStatusMessage
except:pass
try:from Acquisition import aq_inner, aq_parent, aq_self
except:pass 
try:from Acquisition import aq_explicit
except:pass
try:from five import grok
except:pass
try:import collective
except:pass
try:from Globals import package_home
except:pass
try:from Products.CMFCore.utils import getToolByName
except:pass

try:
    import zope
    from zope.traversing.adapters import DefaultTraversable
    zope.component.provideAdapter(DefaultTraversable, [None])
    class Request(zope.publisher.browser.TestRequest):
        def __setitem__(self, name, value):
            self._environ[name] = value
    # alias
    TestRequest = Request
    def make_request(url='http://nohost/@@myview',form=None, *args,  **kwargs):
        r = Request(environ = {'SERVER_URL': url, 'ACTUAL_URL': url}, form=form, *args, **kwargs)
        zope.interface.alsoProvides(r, zope.annotation.interfaces.IAttributeAnnotatable)
        return r
except Exception, e:pass

ZOPETESTCASE = (('ZOPE_TESTCASE' in os.environ) or ('ZOPETESTCASE' in os.environ))
DEFAULT_CONFIG_FILE = os.path.join(
    os.path.dirname(__file__), 'testing.cfg'
)

def getTestingOptionsFromIni(cfg=DEFAULT_CONFIG_FILE):
    """Get options for testing.

    >>> options = getTestingOptionsFromIni()
    >>> options
    {'TEST_VERBOSE_MODE': True, 'FAILS_ON_UNTESTED_ELEMENT': True}

    """
    Config = ConfigParser.ConfigParser()
    Config.read(cfg)
    section = "testing-options"
    FAILS_ON_UNTESTED_ELEMENT = Config.getboolean(section, "FAILS_ON_UNTESTED_ELEMENT")
    TEST_VERBOSE_MODE = Config.getboolean(section, "TEST_VERBOSE_MODE")
    return {
        'FAILS_ON_UNTESTED_ELEMENT': FAILS_ON_UNTESTED_ELEMENT,
        'TEST_VERBOSE_MODE': TEST_VERBOSE_MODE,
    }

# if you have plone.reload out there add an helper to use in doctests while programming
# just use preload(module) in pdb :)
# it would be neccessary for you to precise each module to reload, this method is also not recursive.
# eg: (pdb) from foo import bar;preload(bar)
try:
    def preload(modules_or_module, excludelist=None):
        modules = modules_or_module
        if not (isinstance(modules_or_module, list)
                or isinstance(modules_or_module, tuple)):
            modules = [modules_or_module]
        if not excludelist:
            excludelist = []
        import sys
        if not modules:
            modules = sys.modules
        from plone.reload.xreload import Reloader
        print modules
        for module in modules:
            if not module in excludelist:
                try:
                    Reloader(module).reload()
                except Exception, e:
                    pass
except:
    pass

def format_test_title(title):
    sep = '*' * (len(title)+4)
    return "\n%s\n %s \n%s\n" % (sep, title, sep)

# vim:set et sts=4 ts=4 tw=80:
