# -*- coding: utf-8 -*-
from django.forms import ModelForm
from django import forms
from django.contrib.auth.forms import User


class RegistrationForm(ModelForm):
    username = forms.CharField(required=True)
    fieldbook_book = forms.CharField(required=True, label="Fieldbook ID")
    email = forms.EmailField(required=True, label="Email Address")
    password = forms.CharField(required=True ,widget=forms.PasswordInput)
    password_confirm = forms.CharField(required=True,widget=forms.PasswordInput, label="Confirm password")
    first_name = forms.CharField(required=False)
    last_name = forms.CharField(required=False)

    class Meta:
        model = User
        widgets = {
            'username': forms.CharField(
                attrs={'placeholder': 'Please use the username generated by the Fieldbook API generator (ex. key-1)'}),
            'password': forms.CharField(
                attrs={
                    'placeholder': 'Please use the password generated by the Fieldbook API generator (ex. RoqD4dnPVvpsy5N4gm00)'}),
            'fieldbook_book': forms.CharField(
                attrs={'placeholder': 'Enter fieldbook id here'}),
        }

