#!/usr/bin/env python
# -*- coding: utf-8 -*-
# generated by wxGlade 0.6 on Sun May 25 23:31:23 2008

# Copyright 2008 Martin Manns
# Distributed under the terms of the GNU General Public License
# generated by wxGlade 0.6 on Mon Mar 17 23:22:49 2008

# --------------------------------------------------------------------
# pyspread is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# pyspread is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with pyspread.  If not, see <http://www.gnu.org/licenses/>.
# --------------------------------------------------------------------

"""
_widgets
========

Provides:
---------
  1. IndexGrid: Grid that supports indexing and __len__
  2. MainGrid: Main grid
  2. CollapsiblePane: Collapsible pane with basic toggle mechanism
  3. MacroEditPanel: Collapsible label, parameter entry area and editor
  4. SortedListCtrl: ListCtrl with items sorted in first column
  5. PenStyleComboBox: ComboBox for border pen style selection
  6. FontChoiceCombobox: ComboBox for font selection
  7. BitmapToggleButton: Button that toggles through a list of bitmaps

"""

import keyword

import wx
import wx.grid
import wx.combo
import wx.stc  as  stc
import wx.lib.mixins.listctrl  as  listmix

from pyspread.config import faces, text_styles, fold_symbol_style
from pyspread.config import DEFAULT_FONT_SIZE

class CollapsiblePane(wx.CollapsiblePane):
    """Collapsible pane with basic toggle mechanism
    
    Parameters:
    -----------
    panename: string
    \tLabel for the collapsible pane
    
    """
    
    def __init__(self, *args, **kwds):
        self.label_show = "Show "
        self.label_hide = "Hide "
        panename = kwds.pop('panename')
        self.__dict__['label'] = panename
        wx.CollapsiblePane.__init__(self, *args, **kwds)
        self.SetLabel(self.label_show + panename)
        self.Bind(wx.EVT_COLLAPSIBLEPANE_CHANGED, self.restore_pane, self)
        
    def OnToggle(self, event):
        """"Toggle event handler"""
        self.Collapse(self.IsExpanded())
        self.restore_pane()
        
    def restore_pane(self, event=None):
        """Restores the layout of the content and changes teh labels"""
        self.GetParent().Layout()
        # and also change the labels
        if self.IsExpanded():
            self.SetLabel(self.label_hide + self.__dict__['label'])
        else:
            self.SetLabel(self.label_show + self.__dict__['label'])

# end of class CollapsiblePane

class MacroEditPanel(wx.Panel):
    """Collapsible label, parameter entry area and editor"""
    def __init__(self, parent,  *args, **kwds):
        wx.Panel.__init__(self, parent, *args, **kwds)
        self.maxvar = 100 # The menu will fail for functions with more variables
        sizer = wx.FlexGridSizer(cols=1, rows=3, hgap=5, vgap=5)
        #print sizer.GetColWidths()
        sizer.AddGrowableCol(0)
        sizer.AddGrowableRow(2)
        self.SetSizer(sizer)
        # Add the three panes on the right hand side
        self.pane_docstring = CollapsiblePane(self, label='', \
                                panename = 'docstring', \
                                style=wx.CP_DEFAULT_STYLE|wx.CP_NO_TLW_RESIZE)
        self.make_docstring_content(self.pane_docstring.GetPane())
        sizer.Add(self.pane_docstring, 0, wx.RIGHT|wx.LEFT|wx.EXPAND, 25)
        self.pane_docstring.OnToggle(None)
        
        self.pane_macroform = CollapsiblePane(self, label='', \
                                panename = 'macro form', \
                                style=wx.CP_DEFAULT_STYLE|wx.CP_NO_TLW_RESIZE)
        self.make_macroform_content(self.pane_macroform.GetPane())
        sizer.Add(self.pane_macroform, 0, wx.RIGHT|wx.LEFT|wx.EXPAND, 25)
        self.pane_macroform.OnToggle(None)
        
        self.pane_code = CollapsiblePane(self, label='', \
                                panename = 'code', \
                                style=wx.CP_DEFAULT_STYLE|wx.CP_NO_TLW_RESIZE)
        self.make_code_content(self.pane_code.GetPane())
        sizer.Add(self.pane_code, 0, wx.RIGHT|wx.LEFT|wx.EXPAND, 25)
        
    def make_docstring_content(self, pane):
        """Puts docstring text control into panel"""
        
        self.docstringTextCtrl = wx.TextCtrl(pane, -1, '', \
                        style = wx.NO_BORDER|wx.TE_MULTILINE|wx.TE_READONLY)
        #self.docstringTextCtrl.SetEditable(False)
        sizer = wx.FlexGridSizer(cols=1, rows=1, hgap=5, vgap=5)
        sizer.AddGrowableCol(0)
        sizer.AddGrowableRow(0)
        sizer.Add(self.docstringTextCtrl, 0, wx.EXPAND|wx.FIXED_MINSIZE, 0) 
        pane.SetSizer(sizer)
    
    def update_macroform(self, pane, macro):
        """Updates the macro form, for parameter entry of current macro"""
        
        no_func_parameters = macro.func_code.co_argcount
        func_parameters = macro.func_code.co_varnames[:no_func_parameters]
        
        i = 0
        
        for i, variable in enumerate(func_parameters): 
            self.varlabels[i].SetLabel(variable)
            self.varlabels[i].Show(True)
            self.varentries[i].Show(True)
        
        for i in xrange(i+1, self.maxvar):
            self.varlabels[i].Hide()
            self.varentries[i].Hide()
        
        pane.OnToggle(None)
        pane.OnToggle(None)
        
    def make_macroform_content(self, pane):
        """Takes the current macro's parameters and creates the entry panel"""
        
        self.varlabels = []
        self.varentries = []
        self.macroformsizer = wx.FlexGridSizer(cols=2, hgap=5, vgap=5)
        self.macroformsizer.AddGrowableRow(0)
        #self.macroformsizer.AddGrowableCol(0)
        self.macroformsizer.AddGrowableCol(1)
        for i in xrange(self.maxvar):
            self.varlabels.append(wx.StaticText(pane, -1, "", \
                                  style=wx.ALIGN_RIGHT))
            self.varentries.append(wx.TextCtrl(pane, -1, ""))
            self.varlabels[-1].Hide()
            self.varentries[-1].Hide()
            self.macroformsizer.Add(self.varlabels[i], 0, wx.EXPAND, 0)
            self.macroformsizer.Add(self.varentries[i], 1, wx.EXPAND, 0)
        self.ok_button = wx.Button(pane, wx.ID_OK)
        self.cancel_button = wx.Button(pane, wx.ID_CANCEL)
        self.macroformsizer.Add(self.cancel_button, 0, wx.EXPAND, 0)
        self.macroformsizer.Add(self.ok_button, 1, wx.EXPAND, 0)
        pane.SetSizer(self.macroformsizer)
        self.GetParent().Layout() 
    
    def make_code_content(self, pane):
        """Adds the code entry text control to the panel"""
        
        self.CodeTextCtrl = PythonSTC(pane, wx.NewId(), \
          pos=wx.DefaultPosition, \
          size=wx.DefaultSize, 
          style=wx.TE_PROCESS_ENTER|wx.TE_PROCESS_TAB|wx.TE_MULTILINE|wx.EXPAND)
        
        self.CodeTextCtrl.SetToolTipString("Enter one python function here." + \
                        "\nThe first line has to begin with def")
        border = wx.FlexGridSizer(cols=0, hgap=5, vgap=5)
        border.AddGrowableCol(0)
        border.AddGrowableRow(0)
        border.Add(self.CodeTextCtrl, 0, wx.EXPAND|wx.FIXED_MINSIZE, 0)
        pane.SetSizer(border)

# end of class MacroEditPanel


class SortedListCtrl(wx.ListCtrl, listmix.ListCtrlAutoWidthMixin):
    """ListCtrl with items sorted in first column"""
    
    def __init__(self, parent, wxid, pos=wx.DefaultPosition,
                 size=wx.DefaultSize, style=0):
        wx.ListCtrl.__init__(self, parent, wxid, pos, size, style)
        listmix.ListCtrlAutoWidthMixin.__init__(self)

# end of class SortedListCtrl

class PythonSTC(stc.StyledTextCtrl):
    """Editor that highlights Python source code.
    
    Stolen from the wxPython demo.py
    """
    fold_symbols = 2
    
    def __init__(self, *args, **kwargs):
        stc.StyledTextCtrl.__init__(self, *args, **kwargs)

        self.CmdKeyAssign(ord('B'), stc.STC_SCMOD_CTRL, stc.STC_CMD_ZOOMIN)
        self.CmdKeyAssign(ord('N'), stc.STC_SCMOD_CTRL, stc.STC_CMD_ZOOMOUT)

        self.SetLexer(stc.STC_LEX_PYTHON)
        self.SetKeyWords(0, " ".join(keyword.kwlist))

        self.SetProperty("fold", "1")
        self.SetProperty("tab.timmy.whinge.level", "1")
        self.SetMargins(0, 0)

        self.SetViewWhiteSpace(False)
        self.SetUseAntiAliasing(True)
        
        self.SetEdgeMode(stc.STC_EDGE_BACKGROUND)
        self.SetEdgeColumn(78)

        # Setup a margin to hold fold markers
        self.SetMarginType(2, stc.STC_MARGIN_SYMBOL)
        self.SetMarginMask(2, stc.STC_MASK_FOLDERS)
        self.SetMarginSensitive(2, True)
        self.SetMarginWidth(2, 12)
        
        # Import symbol style from config file
        for marker in fold_symbol_style:
            self.MarkerDefine(*marker)
        
        self.Bind(stc.EVT_STC_UPDATEUI, self.OnUpdateUI)
        self.Bind(stc.EVT_STC_MARGINCLICK, self.OnMarginClick)
        
        # Global default styles for all languages
        self.StyleSetSpec(stc.STC_STYLE_DEFAULT, \
                          "face:%(helv)s,size:%(size)d" % faces)
        self.StyleClearAll()  # Reset all to be like the default
        
        # Import text style specs from config file
        for spec in text_styles:
            self.StyleSetSpec(*spec)
        
        self.SetCaretForeground("BLUE")
        
        self.SetMarginType(1, stc.STC_MARGIN_NUMBER)
        self.SetMarginWidth(1, 30)


    def OnUpdateUI(self, evt):
        """Syntax highlighting while editing"""
        
        # check for matching braces
        brace_at_caret = -1
        brace_opposite = -1
        char_before = None
        caret_pos = self.GetCurrentPos()

        if caret_pos > 0:
            char_before = self.GetCharAt(caret_pos - 1)
            style_before = self.GetStyleAt(caret_pos - 1)

        # check before
        if char_before and chr(char_before) in "[]{}()" and \
           style_before == stc.STC_P_OPERATOR:
            brace_at_caret = caret_pos - 1

        # check after
        if brace_at_caret < 0:
            char_after = self.GetCharAt(caret_pos)
            style_after = self.GetStyleAt(caret_pos)

            if char_after and chr(char_after) in "[]{}()" and \
               style_after == stc.STC_P_OPERATOR:
                brace_at_caret = caret_pos

        if brace_at_caret >= 0:
            brace_opposite = self.BraceMatch(brace_at_caret)

        if brace_at_caret != -1  and brace_opposite == -1:
            self.BraceBadLight(brace_at_caret)
        else:
            self.BraceHighlight(brace_at_caret, brace_opposite)

    def OnMarginClick(self, evt):
        """When clicked, old and unfold as needed"""
        
        if evt.GetMargin() == 2:
            if evt.GetShift() and evt.GetControl():
                self.fold_all()
            else:
                line_clicked = self.LineFromPosition(evt.GetPosition())

                if self.GetFoldLevel(line_clicked) & \
                   stc.STC_FOLDLEVELHEADERFLAG:
                    if evt.GetShift():
                        self.SetFoldExpanded(line_clicked, True)
                        self.expand(line_clicked, True, True, 1)
                    elif evt.GetControl():
                        if self.GetFoldExpanded(line_clicked):
                            self.SetFoldExpanded(line_clicked, False)
                            self.expand(line_clicked, False, True, 0)
                        else:
                            self.SetFoldExpanded(line_clicked, True)
                            self.expand(line_clicked, True, True, 100)
                    else:
                        self.ToggleFold(line_clicked)
    
    def fold_all(self):
        """Folds/unfolds all levels in the editor"""
        
        line_count = self.GetLineCount()
        expanding = True
        
        # find out if we are folding or unfolding
        for line_num in range(line_count):
            if self.GetFoldLevel(line_num) & stc.STC_FOLDLEVELHEADERFLAG:
                expanding = not self.GetFoldExpanded(line_num)
                break
        
        line_num = 0
        
        while line_num < line_count:
            level = self.GetFoldLevel(line_num)
            if level & stc.STC_FOLDLEVELHEADERFLAG and \
               (level & stc.STC_FOLDLEVELNUMBERMASK) == stc.STC_FOLDLEVELBASE:
                
                if expanding:
                    self.SetFoldExpanded(line_num, True)
                    line_num = self.expand(line_num, True)
                    line_num = line_num - 1
                else:
                    last_child = self.GetLastChild(line_num, -1)
                    self.SetFoldExpanded(line_num, False)
                    
                    if last_child > line_num:
                        self.HideLines(line_num+1, last_child)
            
            line_num = line_num + 1
    
    def expand(self, line, do_expand, force=False, vislevels=0, level=-1):
        """Multi-purpose expand method from original STC class"""
        
        lastchild = self.GetLastChild(line, level)
        line += 1
        
        while line <= lastchild:
            if force:
                if vislevels > 0:
                    self.ShowLines(line, line)
                else:
                    self.HideLines(line, line)
            elif do_expand:
                self.ShowLines(line, line)
            
            if level == -1:
                level = self.GetFoldLevel(line)
            
            if level & stc.STC_FOLDLEVELHEADERFLAG:
                if force:
                    self.SetFoldExpanded(line, vislevels - 1)
                    line = self.expand(line, do_expand, force, vislevels-1)
                
                else:
                    expandsub = do_expand and self.GetFoldExpanded(line)
                    line = self.expand(line, expandsub, force, vislevels-1)
            else:
                line += 1
        
        return line
        
# end of class PythonSTC


class PenStyleComboBox(wx.combo.OwnerDrawnComboBox):
    """Combo box for choosing line styles for cell borders
    
    Stolen from demo.py
    
    """
    
    def OnDrawItem(self, dc, rect, item, flags):
        if item == wx.NOT_FOUND:
            # painting the control, but there is no valid item selected yet
            return
        
        r = wx.Rect(*rect)  # make a copy
        r.Deflate(3, 5)
        
        penStyle = wx.SOLID
        if item == 1:
            penStyle = wx.TRANSPARENT
        elif item == 2:
            penStyle = wx.DOT
        elif item == 3:
            penStyle = wx.LONG_DASH
        elif item == 4:
            penStyle = wx.SHORT_DASH
        elif item == 5:
            penStyle = wx.DOT_DASH
        elif item == 6:
            penStyle = wx.BDIAGONAL_HATCH
        elif item == 7:
            penStyle = wx.CROSSDIAG_HATCH
        elif item == 8:
            penStyle = wx.FDIAGONAL_HATCH
        elif item == 9:
            penStyle = wx.CROSS_HATCH
        elif item == 10:
            penStyle = wx.HORIZONTAL_HATCH
        elif item == 11:
            penStyle = wx.VERTICAL_HATCH
            
        pen = wx.Pen(dc.GetTextForeground(), 3, penStyle)
        dc.SetPen(pen)
        
        if flags & wx.combo.ODCB_PAINTING_CONTROL:
            # for painting the control itself
            dc.DrawLine(r.x+5, r.y+r.height/2, 
                        r.x+r.width - 5, r.y+r.height/2)
        
        else:
            # for painting the items in the popup
            dc.DrawText(self.GetString(item),
                        r.x + 3,
                        (r.y + 0) + ((r.height/2) - dc.GetCharHeight())/2)
            dc.DrawLine(r.x+5, r.y+((r.height/4)*3)+1, 
                        r.x+r.width - 5, r.y+((r.height/4)*3)+1)
    
    def OnDrawBackground(self, dc, rect, item, flags):
        """Called for drawing the background area of each item
        
        Overridden from OwnerDrawnComboBox
        
        """
        
        # If the item is selected, or its item # iseven, or we are painting the
        # combo control itself, then use the default rendering.
        if (item & 1 == 0 or flags & (wx.combo.ODCB_PAINTING_CONTROL |
                                      wx.combo.ODCB_PAINTING_SELECTED)):
            wx.combo.OwnerDrawnComboBox.OnDrawBackground(self, dc, 
                                                         rect, item, flags)
            return
        
        # Otherwise, draw every other background with different colour.
        bgCol = wx.Colour(240, 240, 250)
        dc.SetBrush(wx.Brush(bgCol))
        dc.SetPen(wx.Pen(bgCol))
        dc.DrawRectangleRect(rect)
    
    def OnMeasureItem(self, item):
        """should return the height needed to display an item in the popup, 
        or -1 for default
        
        Overridden from OwnerDrawnComboBox
        
        """
        
        # Simply demonstrate the ability to have variable-height items
        if item & 1:
            return 36
        else:
            return 24
    
    def OnMeasureItemWidth(self, item):
        """Callback for item width, or -1 for default/undetermined
        
        Overridden from OwnerDrawnComboBox
        
        """
        return -1 # default - will be measured from text width
    
# end of class PenStyleComboBox

class PenWidthComboBox(wx.combo.OwnerDrawnComboBox):
    """Combo box for choosing line width for cell borders"""
    
    def OnDrawItem(self, dc, rect, item, flags):
        if item == wx.NOT_FOUND:
            # painting the control, but there is no valid item selected yet
            return
        
        r = wx.Rect(*rect)  # make a copy
        r.Deflate(3, 5)
        
        penStyle = wx.SOLID
        if item == 0:
            penStyle = wx.TRANSPARENT
        pen = wx.Pen(dc.GetTextForeground(), item, penStyle)
        dc.SetPen(pen)
        
        if flags & wx.combo.ODCB_PAINTING_CONTROL:
            # for painting the control itself
            dc.DrawLine(r.x+5, r.y+r.height/2, 
                        r.x+r.width - 5, r.y+r.height/2)
        
        else:
            # for painting the items in the popup
            dc.DrawLine(r.x + 5, r.y + r.height / 2, 
                        r.x + r.width - 5, r.y + r.height / 2)
    
    def OnDrawBackground(self, dc, rect, item, flags):
        """Called for drawing the background area of each item
        
        Overridden from OwnerDrawnComboBox
        
        """
        
        # If the item is selected, or its item # iseven, or we are painting the
        # combo control itself, then use the default rendering.
        if (item & 1 == 0 or flags & (wx.combo.ODCB_PAINTING_CONTROL |
                                      wx.combo.ODCB_PAINTING_SELECTED)):
            wx.combo.OwnerDrawnComboBox.OnDrawBackground(self, dc, 
                                                         rect, item, flags)
            return
        
        # Otherwise, draw every other background with different colour.
        bgCol = wx.Colour(240, 240, 250)
        dc.SetBrush(wx.Brush(bgCol))
        dc.SetPen(wx.Pen(bgCol))
        dc.DrawRectangleRect(rect)
    
    def OnMeasureItem(self, item):
        """should return the height needed to display an item in the popup, 
        or -1 for default
        
        Overridden from OwnerDrawnComboBox
        
        """
        
        return -1
    
    def OnMeasureItemWidth(self, item):
        """Callback for item width, or -1 for default/undetermined
        
        Overridden from OwnerDrawnComboBox
        
        """
        return -1 # default - will be measured from text width
    
# end of class PenWidthComboBox

class FontChoiceCombobox(wx.combo.OwnerDrawnComboBox):
    """Combo box for choosing fonts"""
    
#    def __init__(self, *args, **kwargs):
#        kwargs["pos"] = (15, 15)
#        kwargs["size"] = (125, -1)
#        kwargs["style"] = wx.CB_READONLY
#        wx.combo.BitmapComboBox.__init__(self, *args, **kwargs)
#        
#        bmp_width, bmp_height = 125, 20
#        bmp = wx.EmptyBitmap(bmp_width, bmp_height)
#        dc = wx.MemoryDC()
#        
#        for font_string in self.font_list:
#            dc.SelectObject(bmp)
#            font = wx.Font(10, wx.DEFAULT, wx.NORMAL, wx.NORMAL, \
#                           False, font_string)
#            dc.SetFont(font)
#            dc.Clear()
#            text_width, text_height = dc.GetTextExtent(font_string)
#            dc.DrawText(font_string, 0, int((bmp_height - text_height)/2.0))
#            dc.SelectObject(wx.NullBitmap)
#            self.Append(font_string, bmp, font_string)

    def OnDrawItem(self, dc, rect, item, flags):
        if item == wx.NOT_FOUND:
            # painting the control, but there is no valid item selected yet
            return
        
        __rect = wx.Rect(*rect)  # make a copy
        __rect.Deflate(3, 5)
        
        font_string = self.GetString(item)
        font = wx.Font(DEFAULT_FONT_SIZE, wx.DEFAULT, wx.NORMAL, wx.NORMAL, \
                       False, font_string)
        dc.SetFont(font)
        text_width, text_height = dc.GetTextExtent(font_string)
        text_x = __rect.x
        text_y = __rect.y + int((__rect.height - text_height) / 2.0)
        dc.DrawText(font_string, text_x, text_y)
    
    def OnDrawBackground(self, dc, rect, item, flags):
        """Called for drawing the background area of each item
        
        Overridden from OwnerDrawnComboBox
        
        """
        
        # If the item is selected, or its item # iseven, or we are painting the
        # combo control itself, then use the default rendering.
        if (item & 1 == 0 or flags & (wx.combo.ODCB_PAINTING_CONTROL |
                                      wx.combo.ODCB_PAINTING_SELECTED)):
            wx.combo.OwnerDrawnComboBox.OnDrawBackground(self, dc, 
                                                         rect, item, flags)
            return
        
        # Otherwise, draw every other background with different colour.
        bgCol = wx.Colour(240, 240, 250)
        dc.SetBrush(wx.Brush(bgCol))
        dc.SetPen(wx.Pen(bgCol))
        dc.DrawRectangleRect(rect)


# end of class FontChoiceCombobox

class BitmapToggleButton(object):
    """Toggle button that goes through a list of bitmaps
    
    Parameters
    ----------
    bitmap_list: List of wx.Bitmap
    \tMust be non-empty
    
    """
    
    def __init__(self, parent, bitmap_list):

        assert len(bitmap_list) > 0
        
        self.bitmap_list = []
        for bmp in bitmap_list:
            mask = wx.Mask(bmp, wx.BLUE)
            bmp.SetMask(mask)
            self.bitmap_list.append(bmp)
        
        self.button = wx.BitmapButton(parent, -1, self.
                        bitmap_list[0], style=wx.BORDER_NONE)
        
        self.state = 0
        
        """For compatibility with toggle buttons"""
        setattr(self.button, "GetToolState", lambda x: self.state)
        
        self.button.Bind(wx.EVT_BUTTON, self.toggle, self.button)
    
    def toggle(self, event):
        """Toggles state to next bitmap"""
        
        if self.state < len(self.bitmap_list) - 1:
            self.state += 1
        else:
            self.state = 0
        
        self.button.SetBitmapLabel(self.bitmap_list[self.state])
        
        try:
            event.Skip()
        except AttributeError:
            """For compatibility with toggle buttons"""
        setattr(self.button, "GetToolState", lambda x: self.state)
        
# end of class BitmapToggleButton
