# -*- coding: utf-8 -*-

# facemap by @sjdy521
# https://github.com/sjdy521/Mojo-Webqq/blob/master/lib/Mojo/Webqq/Message/Face.pm

# 2017.3.29 由 刘洋 完善
# 2017.5.3 由 刘洋 加入Ejimo字符转义方法

# 发送表情示例：
# qq send buddy jack /可爱
# bot.SendTo(contact, '/可爱')

import re, sys

faceText = [
    "微笑", "撇嘴", "色", "发呆", "得意", "流泪", "害羞", "闭嘴", "睡", "大哭", "尴尬", "发怒",
    "调皮", "呲牙", "NULL惊讶", "难过", "酷", "冷汗", "抓狂", "吐", "偷笑", "可爱", "白眼", "傲慢",
    "饥饿", "困", "惊恐", "流汗", "憨笑", "大兵", "奋斗", "咒骂", "疑问", "嘘", "晕", "折磨",
    "衰", "骷髅", "敲打", "再见", "擦汗", "抠鼻", "鼓掌", "糗大了", "坏笑", "左哼哼", "右哼哼", "哈欠",
    "鄙视", "委屈", "快哭了", "阴险", "亲亲", "吓", "可怜", "眨眼睛", "笑哭", "doge", "泪奔", "无奈",
    "托腮", "卖萌", "斜眼笑", "喷血", "惊喜", "骚扰", "小纠结", "我最美", "菜刀", "西瓜", "啤酒", "篮球",
    "乒乓", "NULL茶", "咖啡", "饭", "猪头", "玫瑰", "凋谢", "示爱", "爱心", "心碎", "蛋糕", "闪电",
    "炸弹", "刀", "足球", "瓢虫", "便便", "月亮", "太阳", "礼物", "拥抱", "强", "弱", "握手",
    "胜利", "抱拳", "勾引", "拳头", "差劲", "爱你", "NO", "OK", "爱情", "飞吻", "跳跳", "发抖",
    "怄火", "激动", "购物", "多云", "恐慌", "雾", "幽灵", "转圈", "不开心", "粥", "害怕", "高铁左车头",
    "钞票", "我不看", "飞机", "手枪", "羊驼", "小样儿", "跳绳", "帅", "右太极", "拜托", "回头", "河蟹",
    "挥手", "啊", "祈祷", "左太极", "献吻", "发财", "女人", "风车", "肥皂", "点赞", "招财猫", "邮件",
    "托脸", "灯笼", "马赛克", "吃", "红包", "鞭炮", "劲爆", "花痴", "下雨", "车厢", "菊花", "高铁右车头",
    "药", "青蛙", "开车", "脸红", "闹钟", "双喜", "冷漠", "灯泡", "喝奶", "送花", "K歌", "蛋",
    "街舞", "熊猫", "飙泪", "棒棒糖", "面条", "磕头", "香蕉", "大笑", "喝彩", "无聊", "呃", "好棒",
]

faceCode = [
    14, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
    12, 13, 0, 50, 51, 96, 53, 54, 73, 74, 75, 76,
    77, 78, 55, 56, 57, 58, 79, 80, 81, 82, 83, 84,
    85, 86, 87, 88, 97, 98, 99, 100, 101, 102, 103, 104,
    105, 106, 107, 108, 109, 110, 111, 172, 182, 179, 173, 174,
    212, 175, 178, 177, 180, 181, 176, 183, 112, 32, 113, 114,
    115, 0, 63, 64, 59, 33, 34, 116, 36, 37, 38, 91,
    92, 93, 29, 117, 72, 45, 42, 39, 62, 46, 47, 71,
    95, 118, 119, 120, 121, 122, 123, 124, 27, 21, 23, 25,
    26, 130, 141, 156, 196, 90, 187, 125, 194, 171, 206, 153,
    158, 211, 151, 169, 185, 208, 128, 143, 134, 200, 127, 184,
    129, 195, 145, 133, 132, 139, 94, 161, 191, 201, 135, 142,
    203, 138, 189, 204, 192, 137, 146, 207, 157, 154, 190, 155,
    168, 170, 152, 209, 162, 136, 197, 160, 148, 205, 140, 188,
    131, 159, 210, 147, 149, 126, 150, 193, 144, 202, 198, 199,
]

faceMap, p = {}, '('
for code, face in zip(faceCode, faceText):
    if code != 0:
        faceMap[code] = face
        faceMap[face] = code
        p = p + '/' + face + '|'
p = p[:-1] + ')'
pat = re.compile(p)

PY3 = (sys.version_info[0] == 3)

def EmojiEncode(pollContent):
    if not PY3:
        return pollContent

    for i in range(1, len(pollContent)):
        item = pollContent[i]
        if isinstance(item, str):
            newstr = []
            for c in item:
                if ord(c) > 0x1f000: # ord("\U0001F000")
                    newstr.append(' /Emoji%d ' % ord(c))
                else:
                    newstr.append(c)
            pollContent[i] = ''.join(newstr)

    return pollContent

def FaceReverseParse(pollContent):
    newContent = EmojiEncode(pollContent) 
    return ''.join(
        (' /%s ' % faceMap.get(m[1], '表情')) if isinstance(m, list) else str(m)
        #(' %d ' % m[1]) if isinstance(m, list) else str(m)
        for m in newContent[1:]
    )

def FaceParse(sendContent):
    result = pat.split(sendContent)
    for i in range(1, len(result), 2):
        result[i] = ['face', faceMap.get(result[i][1:], 134)]
    s = 0 if result[0] else 1
    result[-1] or result.pop()
    return result[s:]
