/*
 * Decompiled with CFR 0.152.
 */
package py3oconverter;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.NoConnectException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XStorable;
import com.sun.star.io.ConnectException;
import com.sun.star.io.IOException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.text.XDocumentIndex;
import com.sun.star.text.XDocumentIndexesSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uri.ExternalUriReferenceTranslator;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XRefreshable;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class Convertor {
    private XComponentContext xRemoteContext = null;
    private String server_host = null;
    private String server_port = null;

    public Convertor(String string, String string2) {
        this.server_host = string;
        this.server_port = string2;
    }

    public void convert(String string, String string2, String string3) throws ConnectException, Exception {
        XDesktop xDesktop = null;
        XComponent xComponent = null;
        xDesktop = this.connect(this.server_host, this.server_port);
        xComponent = this.openDocument(string, xDesktop);
        this.convert_document(string2, string3, xComponent);
    }

    private String createUNOFileURL(String string) {
        File file = new File(string);
        URL uRL = null;
        try {
            uRL = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        String string2 = ExternalUriReferenceTranslator.create((XComponentContext)this.xRemoteContext).translateToInternal(uRL.toExternalForm());
        if (string2.length() == 0 && string.length() > 0) {
            System.out.println("File URL conversion failed. Filelocation contains illegal characters: " + string);
        }
        return string2;
    }

    protected void refreshDocument(XComponent xComponent) {
        XRefreshable xRefreshable = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)xComponent);
        if (xRefreshable != null) {
            xRefreshable.refresh();
        }
    }

    protected void refreshIndexes(XComponent xComponent) {
        XDocumentIndexesSupplier xDocumentIndexesSupplier = (XDocumentIndexesSupplier)UnoRuntime.queryInterface(XDocumentIndexesSupplier.class, (Object)xComponent);
        XIndexAccess xIndexAccess = xDocumentIndexesSupplier.getDocumentIndexes();
        for (int i = 0; i < xIndexAccess.getCount(); ++i) {
            try {
                XDocumentIndex xDocumentIndex = (XDocumentIndex)UnoRuntime.queryInterface(XDocumentIndex.class, (Object)xIndexAccess.getByIndex(i));
                if (xDocumentIndex == null) continue;
                xDocumentIndex.update();
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
                continue;
            }
            catch (WrappedTargetException wrappedTargetException) {
                wrappedTargetException.printStackTrace();
            }
        }
    }

    private void convert_document(String string, String string2, XComponent xComponent) {
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xComponent);
        this.refreshDocument(xComponent);
        this.refreshIndexes(xComponent);
        PropertyValue[] propertyValueArray = new PropertyValue[2];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "Overwrite";
        propertyValueArray[0].Value = new Boolean(true);
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "FilterName";
        propertyValueArray[1].Value = string2;
        try {
            xStorable.storeToURL(this.createUNOFileURL(string), propertyValueArray);
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xStorable);
            if (xCloseable != null) {
                try {
                    xCloseable.close(false);
                }
                catch (CloseVetoException closeVetoException) {}
            } else {
                xComponent.dispose();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private XComponent openDocument(String string, XDesktop xDesktop) {
        XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xDesktop);
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
        propertyValueArray[0].Name = "Hidden";
        propertyValueArray[0].Value = new Boolean(true);
        XComponent xComponent = null;
        try {
            String string2 = this.createUNOFileURL(string);
            xComponent = xComponentLoader.loadComponentFromURL(string2, "_blank", 0, propertyValueArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return xComponent;
    }

    private XDesktop connect(String string, String string2) throws ConnectException, Exception {
        XMultiComponentFactory xMultiComponentFactory = null;
        XDesktop xDesktop = null;
        try {
            XComponentContext xComponentContext = Bootstrap.createInitialComponentContext(null);
            XMultiComponentFactory xMultiComponentFactory2 = xComponentContext.getServiceManager();
            Object object = xMultiComponentFactory2.createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", xComponentContext);
            XUnoUrlResolver xUnoUrlResolver = (XUnoUrlResolver)UnoRuntime.queryInterface(XUnoUrlResolver.class, (Object)object);
            Object object2 = xUnoUrlResolver.resolve("uno:socket,host=" + string + ",port=" + string2 + ";urp;StarOffice.ServiceManager");
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object2);
            Object object3 = xPropertySet.getPropertyValue("DefaultContext");
            this.xRemoteContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)object3);
            xMultiComponentFactory = this.xRemoteContext.getServiceManager();
            Object object4 = xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.Desktop", this.xRemoteContext);
            xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)object4);
        }
        catch (NoConnectException noConnectException) {
            throw new ConnectException("connection failed for host: " + string + ", and port: " + string2 + " : " + noConnectException.getMessage());
        }
        catch (Exception exception) {
            throw new Exception("Open office exception : " + exception);
        }
        return xDesktop;
    }
}

