"""
>>> import sunpos:
>>> print sunpos.__doc__
    Sunpos package provides three structueres: 

    :`cTime`: whith fields:

        :iYear: year, integer
        :iMonth: month, integer
        :iDay: day, integer
        :dHours: double, UTC hours
        :dMinutes: double, minutes
        :dSeconds: double, seconds

    :`cLocation`: with fields:

        :dLongitude: double, longitude
        :dLatitude: double, latitude

    :`cSunCoordinates`: with fields

        :dZenithAngle: double, zenith angle, degrees
        :dAzimuth: double, azimuth angle, degrees

>>> loc=sunpos.cLocation()
>>> loc.dLatitude = 43.1
>>> loc.dLongitude = 131.9

>>> time=sunpos.cTime()
>>> time.iYear = 2013 #imteger, year
>>> time.iMonth = 10 #Integer, month
>>> time.iDay = 13 #integer, day
>>> time.dHours = 16 #double, hours UTC
>>> time.dMinutes = 32 #double, minutes
>>> time.dSeconds = 12 #double, seconds
>>> #calculations
>>> res = sunpos.sunposf(time, loc)
>>> #or 
>>> res = sunpos.cSunCoordinates()
>>> sunpos.sunpos(time, loc, res)
>>> print res.dZenithAngle # sun zenith  angle
>>> print res.dAzimuth # sun azimuth  angle:
>>>
"""
# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.8
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.



from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_sunpos', [dirname(__file__)])
        except ImportError:
            import _sunpos
            return _sunpos
        if fp is not None:
            try:
                _mod = imp.load_module('_sunpos', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _sunpos = swig_import_helper()
    del swig_import_helper
else:
    import _sunpos
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


pi = _sunpos.pi
twopi = _sunpos.twopi
rad = _sunpos.rad
dEarthMeanRadius = _sunpos.dEarthMeanRadius
dAstronomicalUnit = _sunpos.dAstronomicalUnit
class cTime(_object):
    """Proxy of C cTime struct"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, cTime, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, cTime, name)
    __repr__ = _swig_repr
    __swig_setmethods__["iYear"] = _sunpos.cTime_iYear_set
    __swig_getmethods__["iYear"] = _sunpos.cTime_iYear_get
    if _newclass:iYear = _swig_property(_sunpos.cTime_iYear_get, _sunpos.cTime_iYear_set)
    __swig_setmethods__["iMonth"] = _sunpos.cTime_iMonth_set
    __swig_getmethods__["iMonth"] = _sunpos.cTime_iMonth_get
    if _newclass:iMonth = _swig_property(_sunpos.cTime_iMonth_get, _sunpos.cTime_iMonth_set)
    __swig_setmethods__["iDay"] = _sunpos.cTime_iDay_set
    __swig_getmethods__["iDay"] = _sunpos.cTime_iDay_get
    if _newclass:iDay = _swig_property(_sunpos.cTime_iDay_get, _sunpos.cTime_iDay_set)
    __swig_setmethods__["dHours"] = _sunpos.cTime_dHours_set
    __swig_getmethods__["dHours"] = _sunpos.cTime_dHours_get
    if _newclass:dHours = _swig_property(_sunpos.cTime_dHours_get, _sunpos.cTime_dHours_set)
    __swig_setmethods__["dMinutes"] = _sunpos.cTime_dMinutes_set
    __swig_getmethods__["dMinutes"] = _sunpos.cTime_dMinutes_get
    if _newclass:dMinutes = _swig_property(_sunpos.cTime_dMinutes_get, _sunpos.cTime_dMinutes_set)
    __swig_setmethods__["dSeconds"] = _sunpos.cTime_dSeconds_set
    __swig_getmethods__["dSeconds"] = _sunpos.cTime_dSeconds_get
    if _newclass:dSeconds = _swig_property(_sunpos.cTime_dSeconds_get, _sunpos.cTime_dSeconds_set)
    def __init__(self): 
        """__init__(cTime self) -> cTime"""
        this = _sunpos.new_cTime()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _sunpos.delete_cTime
    __del__ = lambda self : None;
cTime_swigregister = _sunpos.cTime_swigregister
cTime_swigregister(cTime)

class cLocation(_object):
    """Proxy of C cLocation struct"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, cLocation, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, cLocation, name)
    __repr__ = _swig_repr
    __swig_setmethods__["dLongitude"] = _sunpos.cLocation_dLongitude_set
    __swig_getmethods__["dLongitude"] = _sunpos.cLocation_dLongitude_get
    if _newclass:dLongitude = _swig_property(_sunpos.cLocation_dLongitude_get, _sunpos.cLocation_dLongitude_set)
    __swig_setmethods__["dLatitude"] = _sunpos.cLocation_dLatitude_set
    __swig_getmethods__["dLatitude"] = _sunpos.cLocation_dLatitude_get
    if _newclass:dLatitude = _swig_property(_sunpos.cLocation_dLatitude_get, _sunpos.cLocation_dLatitude_set)
    def __init__(self): 
        """__init__(cLocation self) -> cLocation"""
        this = _sunpos.new_cLocation()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _sunpos.delete_cLocation
    __del__ = lambda self : None;
cLocation_swigregister = _sunpos.cLocation_swigregister
cLocation_swigregister(cLocation)

class cSunCoordinates(_object):
    """Proxy of C cSunCoordinates struct"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, cSunCoordinates, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, cSunCoordinates, name)
    __repr__ = _swig_repr
    __swig_setmethods__["dZenithAngle"] = _sunpos.cSunCoordinates_dZenithAngle_set
    __swig_getmethods__["dZenithAngle"] = _sunpos.cSunCoordinates_dZenithAngle_get
    if _newclass:dZenithAngle = _swig_property(_sunpos.cSunCoordinates_dZenithAngle_get, _sunpos.cSunCoordinates_dZenithAngle_set)
    __swig_setmethods__["dAzimuth"] = _sunpos.cSunCoordinates_dAzimuth_set
    __swig_getmethods__["dAzimuth"] = _sunpos.cSunCoordinates_dAzimuth_get
    if _newclass:dAzimuth = _swig_property(_sunpos.cSunCoordinates_dAzimuth_get, _sunpos.cSunCoordinates_dAzimuth_set)
    def __init__(self): 
        """__init__(cSunCoordinates self) -> cSunCoordinates"""
        this = _sunpos.new_cSunCoordinates()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _sunpos.delete_cSunCoordinates
    __del__ = lambda self : None;
cSunCoordinates_swigregister = _sunpos.cSunCoordinates_swigregister
cSunCoordinates_swigregister(cSunCoordinates)


def sunpos(*args):
  """sunpos(cTime udtTime, cLocation udtLocation, cSunCoordinates udtSunCoordinates)"""
  return _sunpos.sunpos(*args)

def sunposf(*args):
  """sunposf(cTime udtTime, cLocation udtLocation) -> cSunCoordinates"""
  return _sunpos.sunposf(*args)
# This file is compatible with both classic and new-style classes.


