/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml;

import com.adobe.epubcheck.util.ResourceUtil;
import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.auto.SchemaReaderFactorySchemaReceiverFactory;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.schematron.NewSaxonSchemaReaderFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.TransformerFactory;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.sxpath.IndependentContext;
import org.idpf.epubcheck.util.saxon.ColumnNumberFunction;
import org.idpf.epubcheck.util.saxon.LineNumberFunction;
import org.idpf.epubcheck.util.saxon.SystemIdFunction;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLValidator {
    Schema schema;

    public XMLValidator(String schemaName) {
        try {
            String resourcePath = ResourceUtil.getResourcePath(schemaName);
            URL systemIdURL = ResourceUtil.getResourceURL(resourcePath);
            if (systemIdURL == null) {
                throw new RuntimeException("Could not find resource " + resourcePath);
            }
            InputSource schemaSource = new InputSource(systemIdURL.toString());
            PropertyMapBuilder mapBuilder = new PropertyMapBuilder();
            mapBuilder.put(ValidateProperty.RESOLVER, BasicResolver.getInstance());
            mapBuilder.put(ValidateProperty.ERROR_HANDLER, new ErrorHandlerImpl());
            SchemaReader schemaReader = schemaName.endsWith(".rnc") ? CompactSchemaReader.getInstance() : (schemaName.endsWith(".sch") ? new AutoSchemaReader(new SchemaReaderFactorySchemaReceiverFactory(new ExtendedSaxonSchemaReaderFactory())) : new AutoSchemaReader());
            this.schema = schemaReader.createSchema(schemaSource, mapBuilder.toPropertyMap());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Internal error: " + e + " " + schemaName);
        }
    }

    private class ErrorHandlerImpl
    implements ErrorHandler {
        private ErrorHandlerImpl() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            exception.printStackTrace();
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            exception.printStackTrace();
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            exception.printStackTrace();
        }
    }

    public static class ExtendedSaxonSchemaReaderFactory
    extends NewSaxonSchemaReaderFactory {
        @Override
        public void initTransformerFactory(TransformerFactory factory) {
            super.initTransformerFactory(factory);
            if (factory instanceof TransformerFactoryImpl) {
                Configuration configuration = ((TransformerFactoryImpl)factory).getConfiguration();
                IndependentContext xpathContext = new IndependentContext(configuration);
                if (!xpathContext.getFunctionLibrary().isAvailable(LineNumberFunction.QNAME, -1)) {
                    configuration.registerExtensionFunction(new LineNumberFunction());
                }
                if (!xpathContext.getFunctionLibrary().isAvailable(ColumnNumberFunction.QNAME, -1)) {
                    configuration.registerExtensionFunction(new ColumnNumberFunction());
                }
                if (!xpathContext.getFunctionLibrary().isAvailable(SystemIdFunction.QNAME, -1)) {
                    configuration.registerExtensionFunction(new SystemIdFunction());
                }
            }
        }
    }

    public static class BasicResolver
    implements Resolver {
        private static final BasicResolver theInstance = new BasicResolver();

        BasicResolver() {
        }

        public static BasicResolver getInstance() {
            return theInstance;
        }

        @Override
        public void resolve(Identifier id, Input input) throws IOException, ResolverException {
            if (!input.isResolved()) {
                input.setUri(BasicResolver.resolveUri(id));
            }
        }

        @Override
        public void open(Input input) throws IOException, ResolverException {
            URI uri;
            if (!input.isUriDefinitive()) {
                return;
            }
            try {
                uri = new URI(input.getUri());
            }
            catch (URISyntaxException e) {
                throw new ResolverException(e);
            }
            if (!uri.isAbsolute()) {
                throw new ResolverException("cannot open relative URI: " + uri);
            }
            URL url = new URL(uri.toASCIIString());
            input.setByteStream(url.openStream());
        }

        public static String resolveUri(Identifier id) throws ResolverException {
            try {
                String base;
                String uriRef = id.getUriReference();
                URI uri = new URI(uriRef);
                if (!uri.isAbsolute() && (base = id.getBase()) != null) {
                    URI baseURI = new URI(base);
                    uriRef = "zip".equals(baseURI.getScheme()) || "jar".equals(baseURI.getScheme()) ? new URL(new URL(base), uriRef).toExternalForm() : baseURI.resolve(uri).toString();
                }
                return uriRef;
            }
            catch (URISyntaxException e) {
                throw new ResolverException(e);
            }
            catch (MalformedURLException e) {
                throw new ResolverException(e);
            }
        }
    }
}

