/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.nav;

import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.ops.OPSHandler30;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.vocab.StructureVocab;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLParser;
import java.util.Set;

public class NavHandler
extends OPSHandler30 {
    private boolean inToc = false;

    NavHandler(ValidationContext context, XMLParser parser) {
        super(context, parser);
    }

    @Override
    public void startElement() {
        super.startElement();
        XMLElement e = this.parser.getCurrentElement();
        String name = e.getName();
        if (this.inToc && "a".equals(name)) {
            this.context.featureReport.report(FeatureEnum.TOC_LINKS, this.parser.getLocation());
        }
    }

    @Override
    public void endElement() {
        super.endElement();
        XMLElement e = this.parser.getCurrentElement();
        String name = e.getName();
        if (this.inToc && "nav".equals(name)) {
            this.inToc = false;
        }
    }

    @Override
    protected void checkTypes(Set<StructureVocab.EPUB_TYPES> types) {
        super.checkTypes(types);
        if (types.contains((Object)StructureVocab.EPUB_TYPES.TOC)) {
            this.inToc = true;
        }
        if (types.contains((Object)StructureVocab.EPUB_TYPES.PAGE_LIST)) {
            this.context.featureReport.report(FeatureEnum.PAGE_LIST, this.parser.getLocation());
        }
        if (types.contains((Object)StructureVocab.EPUB_TYPES.LOI)) {
            this.context.featureReport.report(FeatureEnum.LOI, this.parser.getLocation());
        }
        if (types.contains((Object)StructureVocab.EPUB_TYPES.LOT)) {
            this.context.featureReport.report(FeatureEnum.LOT, this.parser.getLocation());
        }
        if (types.contains((Object)StructureVocab.EPUB_TYPES.LOA)) {
            this.context.featureReport.report(FeatureEnum.LOA, this.parser.getLocation());
        }
        if (types.contains((Object)StructureVocab.EPUB_TYPES.LOV)) {
            this.context.featureReport.report(FeatureEnum.LOV, this.parser.getLocation());
        }
    }
}

