// Generated by CoffeeScript 1.3.1
(function() {
  var ELEMENT_NODE, T, TEXT_NODE, Transparency, attr, cloneNode, debug, debugMode, elementMatcher, elementNodes, expando, getText, html5Clone, isDate, isPlainValue, matchingElements, prepareContext, renderChildren, renderDirectives, renderValues, setContent, setHtml, setText, _base,
    __slice = [].slice;

  if (typeof jQuery !== "undefined" && jQuery !== null) {
    jQuery.fn.render = function(models, directives, config) {
      var context, _i, _len;
      for (_i = 0, _len = this.length; _i < _len; _i++) {
        context = this[_i];
        T.render(context, models, directives, config);
      }
      return this;
    };
  }

  this.Transparency = Transparency = {};

  if (typeof module !== "undefined" && module !== null) {
    module.exports = Transparency;
  }

  T = Transparency;

  expando = 'transparency';

  T.data = function(element) {
    return element[expando] || (element[expando] = {});
  };

  debug = null;

  debugMode = function(config) {
    if ((config != null ? config.debug : void 0) && (typeof console !== "undefined" && console !== null)) {
      return function() {
        var m, messages, _i, _len, _results;
        messages = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
        _results = [];
        for (_i = 0, _len = messages.length; _i < _len; _i++) {
          m = messages[_i];
          _results.push(console.log(m));
        }
        return _results;
      };
    } else {
      return function() {};
    }
  };

  T.render = function(context, models, directives, config) {
    var contextData, e, index, instance, model, parent, sibling, _i, _j, _len, _len1, _ref;
    debug = debugMode(config);
    debug("Context:", context, "Models:", models, "Directives:", directives, "Config:", config);
    if (!context) {
      return;
    }
    models || (models = []);
    directives || (directives = {});
    if (!Array.isArray(models)) {
      models = [models];
    }
    sibling = context.nextSibling;
    parent = context.parentNode;
    if (parent != null) {
      parent.removeChild(context);
    }
    prepareContext(context, models);
    contextData = T.data(context);
    for (index = _i = 0, _len = models.length; _i < _len; index = ++_i) {
      model = models[index];
      instance = contextData.instances[index];
      debug("Model:", model, "Template instance for the model:", instance);
      _ref = instance.elements;
      for (_j = 0, _len1 = _ref.length; _j < _len1; _j++) {
        e = _ref[_j];
        T.data(e).model = model;
      }
      renderValues(instance, model);
      renderDirectives(instance, model, index, directives);
      renderChildren(instance, model, directives, config);
    }
    if (sibling) {
      if (parent != null) {
        parent.insertBefore(context, sibling);
      }
    } else {
      if (parent != null) {
        parent.appendChild(context);
      }
    }
    return context;
  };

  prepareContext = function(context, models) {
    var attribute, contextData, e, instance, n, value, _i, _j, _k, _len, _len1, _len2, _ref, _ref1, _ref2, _results;
    contextData = T.data(context);
    contextData.template || (contextData.template = ((function() {
      var _results;
      _results = [];
      while (context.firstChild) {
        _results.push(context.removeChild(context.firstChild));
      }
      return _results;
    })()));
    contextData.instanceCache || (contextData.instanceCache = []);
    contextData.instances || (contextData.instances = []);
    debug("Original template", contextData.template);
    while (models.length > contextData.instances.length) {
      instance = contextData.instanceCache.pop() || {};
      instance.queryCache || (instance.queryCache = {});
      instance.template || (instance.template = (function() {
        var _i, _len, _ref, _results;
        _ref = contextData.template;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          n = _ref[_i];
          _results.push(cloneNode(n));
        }
        return _results;
      })());
      instance.elements || (instance.elements = elementNodes(instance.template));
      _ref = instance.template;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        n = _ref[_i];
        context.appendChild(n);
      }
      contextData.instances.push(instance);
    }
    while (models.length < contextData.instances.length) {
      contextData.instanceCache.push(instance = contextData.instances.pop());
      _ref1 = instance.template;
      for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
        n = _ref1[_j];
        n.parentNode.removeChild(n);
      }
    }
    _ref2 = contextData.instances;
    _results = [];
    for (_k = 0, _len2 = _ref2.length; _k < _len2; _k++) {
      instance = _ref2[_k];
      _results.push((function() {
        var _l, _len3, _ref3, _results1;
        _ref3 = instance.elements;
        _results1 = [];
        for (_l = 0, _len3 = _ref3.length; _l < _len3; _l++) {
          e = _ref3[_l];
          _results1.push((function() {
            var _ref4, _results2;
            _ref4 = T.data(e).attributes;
            _results2 = [];
            for (attribute in _ref4) {
              value = _ref4[attribute];
              _results2.push(attr(e, attribute, value));
            }
            return _results2;
          })());
        }
        return _results1;
      })());
    }
    return _results;
  };

  renderValues = function(instance, model) {
    var element, key, value, _results;
    _results = [];
    for (key in model) {
      value = model[key];
      if (typeof model === 'object' && isPlainValue(value)) {
        _results.push((function() {
          var _i, _len, _ref, _results1;
          _ref = matchingElements(instance, key);
          _results1 = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            element = _ref[_i];
            if (element.nodeName.toLowerCase() === 'input') {
              _results1.push(attr(element, 'value', value));
            } else {
              _results1.push(attr(element, 'text', value));
            }
          }
          return _results1;
        })());
      }
    }
    return _results;
  };

  renderDirectives = function(instance, model, index, directives) {
    var attribute, attributes, directive, element, key, oldValue, value, _results;
    model = typeof model === 'object' ? model : {
      value: model
    };
    _results = [];
    for (key in directives) {
      attributes = directives[key];
      if (typeof attributes !== 'object') {
        throw new Error("Directive syntax is directive[element][attribute] = function(params)");
      }
      _results.push((function() {
        var _i, _len, _ref, _results1;
        _ref = matchingElements(instance, key);
        _results1 = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          element = _ref[_i];
          _results1.push((function() {
            var _results2;
            _results2 = [];
            for (attribute in attributes) {
              directive = attributes[attribute];
              if (!(typeof directive === 'function')) {
                continue;
              }
              oldValue = attr(element, attribute);
              value = directive.call(model, {
                element: element,
                index: index,
                value: oldValue
              });
              if (value) {
                _results2.push(attr(element, attribute, value));
              } else {
                _results2.push(void 0);
              }
            }
            return _results2;
          })());
        }
        return _results1;
      })());
    }
    return _results;
  };

  renderChildren = function(instance, model, directives, config) {
    var element, key, value, _results;
    _results = [];
    for (key in model) {
      value = model[key];
      if (typeof value === 'object' && !isDate(value)) {
        _results.push((function() {
          var _i, _len, _ref, _results1;
          _ref = matchingElements(instance, key);
          _results1 = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            element = _ref[_i];
            _results1.push(T.render(element, value, directives[key], config));
          }
          return _results1;
        })());
      }
    }
    return _results;
  };

  setContent = function(callback) {
    return function(element, content) {
      var c, elementData, n, _i, _len, _ref, _results;
      elementData = T.data(element);
      if (elementData.content === content) {
        return;
      }
      elementData.content = content;
      elementData.children || (elementData.children = (function() {
        var _i, _len, _ref, _results;
        _ref = element.childNodes;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          n = _ref[_i];
          if (n.nodeType === ELEMENT_NODE) {
            _results.push(n);
          }
        }
        return _results;
      })());
      while (element.firstChild) {
        element.removeChild(element.firstChild);
      }
      callback(element, content);
      _ref = elementData.children;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        c = _ref[_i];
        _results.push(element.appendChild(c));
      }
      return _results;
    };
  };

  setHtml = setContent(function(element, html) {
    return element.innerHTML = html;
  });

  setText = setContent(function(element, text) {
    return element.appendChild(element.ownerDocument.createTextNode(text));
  });

  getText = function(element) {
    var child;
    return ((function() {
      var _i, _len, _ref, _results;
      _ref = element.childNodes;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        child = _ref[_i];
        if (child.nodeType === TEXT_NODE) {
          _results.push(child.nodeValue);
        }
      }
      return _results;
    })()).join('');
  };

  attr = function(element, attribute, value) {
    var elementData, _base, _base1, _base2, _base3;
    if (isDate(value)) {
      value = value.toString();
    }
    elementData = T.data(element);
    elementData.attributes || (elementData.attributes = {});
    switch (attribute) {
      case 'text':
        (_base = elementData.attributes)['text'] || (_base['text'] = getText(element));
        if (value) {
          setText(element, value);
        }
        break;
      case 'html':
        (_base1 = elementData.attributes)['html'] || (_base1['html'] = element.innerHTML);
        if (value) {
          setHtml(element, value);
        }
        break;
      case 'class':
        (_base2 = elementData.attributes)['class'] || (_base2['class'] = element.className);
        if (value) {
          element.className = value;
        }
        break;
      default:
        (_base3 = elementData.attributes)[attribute] || (_base3[attribute] = element.getAttribute(attribute));
        if (value) {
          element.setAttribute(attribute, value);
        }
    }
    return elementData.attributes[attribute];
  };

  elementNodes = function(template) {
    var child, e, elements, _i, _j, _len, _len1, _ref;
    elements = [];
    for (_i = 0, _len = template.length; _i < _len; _i++) {
      e = template[_i];
      if (!(e.nodeType === ELEMENT_NODE)) {
        continue;
      }
      elements.push(e);
      _ref = e.getElementsByTagName('*');
      for (_j = 0, _len1 = _ref.length; _j < _len1; _j++) {
        child = _ref[_j];
        elements.push(child);
      }
    }
    return elements;
  };

  matchingElements = function(instance, key) {
    var e, elements, _base;
    elements = (_base = instance.queryCache)[key] || (_base[key] = (function() {
      var _i, _len, _ref, _results;
      _ref = instance.elements;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        e = _ref[_i];
        if (elementMatcher(e, key)) {
          _results.push(e);
        }
      }
      return _results;
    })());
    debug("Matching elements for '" + key + "':", elements);
    return elements;
  };

  elementMatcher = function(element, key) {
    return element.id === key || element.className.split(' ').indexOf(key) > -1 || element.name === key || element.getAttribute('data-bind') === key;
  };

  ELEMENT_NODE = 1;

  TEXT_NODE = 3;

  html5Clone = function() {
    return document.createElement("nav").cloneNode(true).outerHTML !== "<:nav></:nav>";
  };

  cloneNode = html5Clone() ? function(node) {
    return node.cloneNode(true);
  } : function(node) {
    return jQuery(node).clone()[0];
  };

  if (Array.isArray == null) {
    Array.isArray = function(obj) {
      return jQuery.isArray(obj);
    };
  }

  if ((_base = Array.prototype).indexOf == null) {
    _base.indexOf = function(obj) {
      return jQuery.inArray(obj, this);
    };
  }

  isDate = function(obj) {
    return Object.prototype.toString.call(obj) === '[object Date]';
  };

  isPlainValue = function(obj) {
    return isDate(obj) || typeof obj !== 'object' && typeof obj !== 'function';
  };

}).call(this);
