/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.brunel.action.Action;
import org.brunel.data.Field;
import org.brunel.maps.GeoInformation;
import org.brunel.util.FieldCoarseness;
import org.brunel.util.LibraryItem;

public class Library {
    private static final String DEFAULT_ITEMS = "/org/brunel/util/library-items.txt";
    private static Library STANDARD;
    private final Map<String, LibraryItem> store = new HashMap<String, LibraryItem>();

    public static Action choose(Field ... selected) {
        Library lib = Library.standard();
        if (selected == null || selected.length == 0) {
            return null;
        }
        if (selected.length == 1) {
            return lib.chooseUnivariate(selected[0]);
        }
        if (selected.length == 2) {
            return lib.chooseBivariate(selected[0], selected[1]);
        }
        return lib.chooseMultivariate(selected);
    }

    public Action make(String name, Field ... fields) {
        LibraryItem item = this.get(name);
        return item.apply(fields);
    }

    private LibraryItem get(String name) {
        LibraryItem item = this.store.get(name);
        if (item == null) {
            throw new NullPointerException("Unknown library item: " + name);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Library standard() {
        Class<Library> clazz = Library.class;
        synchronized (Library.class) {
            if (STANDARD == null) {
                STANDARD = new Library();
                STANDARD.addItems(Library.class.getResourceAsStream(DEFAULT_ITEMS));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return STANDARD;
        }
    }

    public static Library custom(URL ... sources) {
        Library library = new Library();
        try {
            for (URL url : sources) {
                library.addItems(url.openStream());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return library;
    }

    private void add(LibraryItem item) {
        this.store.put(item.name(), item);
    }

    public void addItems(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream, "UTF-8").useDelimiter("[\r\n\t ]+::[\n\t ]+|\n");
        while (scanner.hasNext()) {
            String name = scanner.next();
            String action = scanner.next();
            LibraryItem.Param[] params = this.toParams(scanner.next().split(","));
            this.add(new LibraryItem(name, action, params));
        }
    }

    private LibraryItem.Param[] toParams(String[] paramTexts) {
        LibraryItem.Param[] params = new LibraryItem.Param[paramTexts.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = LibraryItem.Param.valueOf(paramTexts[i].trim());
        }
        return params;
    }

    private Action chooseBivariate(Field a, Field b) {
        if (b.preferCategorical() && !a.preferCategorical()) {
            return this.chooseBivariate(b, a);
        }
        if (a.isDate() && !b.isDate()) {
            return this.makeLineChart(a, b);
        }
        if (b.isDate() && !a.isDate() && !a.preferCategorical()) {
            return this.makeLineChart(b, a);
        }
        if (this.goodForMapNames(a)) {
            return this.get("colorMap").apply(a, b);
        }
        if (this.goodForMapNames(b)) {
            return this.get("colorMap").apply(b, a);
        }
        if (a.preferCategorical() || b.preferCategorical()) {
            return this.get("heatmap").apply(this.orderByCoarseness(a, b));
        }
        return this.get("scatter").apply(this.orderByCoarseness(a, b));
    }

    private boolean goodForLongitude(Field f) {
        return f.min() > -181.0 && f.max() <= 181.0;
    }

    private boolean goodForLatitude(Field f) {
        return f.min() > -91.0 && f.max() < 91.0;
    }

    private Action chooseMultivariate(Field ... fields) {
        Field[] ordered = this.orderByCoarseness(fields);
        if (fields.length == 3) {
            Field a = ordered[0];
            Field b = ordered[1];
            Field c = ordered[2];
            if (!(a.preferCategorical() || b.preferCategorical() || c.preferCategorical())) {
                return this.get("bubble").apply(ordered);
            }
        }
        return this.get("treemap").apply(ordered);
    }

    private Action chooseUnivariate(Field f) {
        if (this.goodForMapNames(f)) {
            return this.get("map").apply(f);
        }
        if (this.goodForWordle(f)) {
            return this.get("wordle").apply(f);
        }
        return this.get("barOfCounts").apply(f);
    }

    private boolean goodForMapNames(Field f) {
        return GeoInformation.fractionGeoNames(f) > 0.5;
    }

    private boolean goodForWordle(Field f) {
        if (!f.preferCategorical()) {
            return false;
        }
        if (f.numProperty("unique") > 100.0 || f.numProperty("unique") < 7.0) {
            return false;
        }
        for (Object c : f.categories()) {
            if (c.toString().length() <= 20) continue;
            return false;
        }
        return true;
    }

    private Action makeLineChart(Field x, Field y) {
        if (x.numProperty("unique") > 0.95 * x.numProperty("validNumeric")) {
            return this.get("line").apply(x, y);
        }
        return this.get("lineWithPoints").apply(x, y);
    }

    private Field[] orderByCoarseness(Field ... fields) {
        FieldCoarseness.sort(fields);
        return fields;
    }
}

