/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.element;

import org.brunel.build.d3.element.ElementDimension;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.d3.element.GeomAttribute;
import org.brunel.build.util.ModelUtil;
import org.brunel.data.Data;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class ElementDetails {
    public final String dataSource;
    public final ElementRepresentation representation;
    public final String[] classes;
    private final String userDefinedLabelPosition;
    private final boolean strokedShape;
    private final boolean allowTextOverlap;
    private final double labelPadding;
    private final String labelAlignment;
    public final ElementDimension x;
    public final ElementDimension y;
    public GeomAttribute overallSize;
    private GeomAttribute refLocation;

    public static ElementDetails makeForCoordinates(VisSingle vis, String symbol) {
        VisTypes.Element element = vis.tElement;
        ElementRepresentation representation = ElementRepresentation.makeForCoordinateElement(element, symbol, vis);
        String dataSource = element.producesSingleShape ? "splits" : "data._rows";
        boolean filled = element.filled || !vis.fSize.isEmpty() && (element == VisTypes.Element.line || element == VisTypes.Element.path);
        return new ElementDetails(vis, representation, element.name(), dataSource, filled);
    }

    public static ElementDetails makeForDiagram(VisSingle vis, ElementRepresentation representation, String elementClass, String dataSource) {
        boolean filled = representation != ElementRepresentation.segment && representation != ElementRepresentation.curvedPath && representation != ElementRepresentation.generalPath;
        return new ElementDetails(vis, representation, elementClass, dataSource, filled);
    }

    public String getAlignment() {
        return this.labelAlignment;
    }

    public double getPadding() {
        return this.labelPadding;
    }

    public GeomAttribute getRefLocation() {
        return this.refLocation;
    }

    public boolean isPath() {
        return this.representation.isDrawnAsPath();
    }

    public void setReferences(String[] references) {
        this.refLocation = GeomAttribute.makeFunction("[" + Data.join((Object[])references) + "]");
    }

    public ElementDetails(VisSingle vis, ElementRepresentation representation, String className, String dataSource, boolean filled) {
        String[] stringArray;
        if (className == null || className.contains(" ")) {
            throw new IllegalArgumentException("Class name must be a single word");
        }
        if (filled) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "element";
            stringArray2[1] = className;
            stringArray = stringArray2;
            stringArray2[2] = "filled";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "element";
            stringArray = stringArray3;
            stringArray3[1] = className;
        }
        this.classes = stringArray;
        this.x = new ElementDimension(vis, "width", representation, this.classes);
        this.y = new ElementDimension(vis, "height", representation, this.classes);
        this.strokedShape = !filled;
        this.dataSource = dataSource;
        this.representation = representation;
        this.userDefinedLabelPosition = ModelUtil.getLabelPosition(vis);
        this.labelPadding = ModelUtil.getLabelPadding(vis, 3);
        this.labelAlignment = ModelUtil.getLabelAlignment(vis);
        this.allowTextOverlap = vis.tDiagram == VisTypes.Diagram.network;
    }

    public String getTextMethod() {
        return this.userDefinedLabelPosition != null ? this.userDefinedLabelPosition : this.representation.getDefaultTextMethod();
    }

    public boolean requiresSplitting() {
        return this.dataSource.equals("splits");
    }

    public boolean isStroked() {
        return this.strokedShape;
    }

    public boolean textCanOverlap() {
        return this.allowTextOverlap;
    }

    public boolean textFitsShape() {
        return "inside".equals(this.userDefinedLabelPosition) || this.representation.textFitsShape();
    }
}

