/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.element;

import org.brunel.build.util.ScriptWriter;

public class EdgeBuilder {
    private final ScriptWriter out;
    private final boolean polar;

    public EdgeBuilder(ScriptWriter out, boolean polar) {
        this.out = out;
        this.polar = polar;
    }

    public void defineLocation() {
        this.writeEdgePlacement("target");
    }

    public void write(String groupName) {
        this.out.add("var added = edgeGroup.enter().append('path').attr('class', 'edge')");
        this.writeEdgePlacement("source");
        this.out.endStatement();
        this.out.add("BrunelD3.transition(" + groupName + ".merge(added), transitionMillis)");
        this.writeEdgePlacement("target");
        this.out.endStatement();
    }

    private void writeEdgePlacement(String target) {
        this.out.addChained("attr('d', function(d) {").indentMore().indentMore().onNewLine();
        if (this.polar) {
            this.out.add("var r1 = d.source.y, a1 = d.source.x, r2 = d." + target + ".y, a2 = d." + target + ".x, r = (r1+r2)/2").endStatement().add("return 'M' + scale_x(r1*Math.cos(a1)) + ',' + scale_y(r1*Math.sin(a1)) ").continueOnNextLine(new String[0]).add(" + 'Q' +  scale_x(r*Math.cos(a2)) + ',' + scale_y(r*Math.sin(a2))").continueOnNextLine(new String[0]).add(" + ' ' +  scale_x(r2*Math.cos(a2)) + ',' + scale_y(r2*Math.sin(a2))").endStatement();
        } else {
            this.out.add("var x1 =  scale_x(d.source.y), y1 = scale_y(d.source.x), x2 = scale_x(d." + target + ".y), y2 = scale_y(d." + target + ".x)").endStatement().add("return 'M' + x1 + ',' + y1 ").continueOnNextLine(new String[0]).add(" + 'C' + (x1+x2)/2 + ',' + y1").continueOnNextLine(new String[0]).add(" + ' ' + (x1+x2)/2 + ',' + y2").continueOnNextLine(new String[0]).add(" + ' ' + x2 + ',' + y2").endStatement();
        }
        this.out.indentLess().indentLess().add("})");
    }
}

